package skyprocstarter;

import skyproc.ARMO;
import skyproc.BodyTemplate.BodyTemplateType;
import skyproc.BodyTemplate.GeneralFlags;
import skyproc.LVLI;
import skyproc.Mod;
import skyproc.WEAP;
import skyproc.WEAP.WeaponFlag;
import skyproc.genenums.ArmorType;

public final class Patch {
    /** Prevent construction of this class. */
    private Patch() { new AssertionError(); }
    
    ///////////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////
    //                    FIELDS                       ////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////
    
    public static LVLI[] weapons;
    public static LVLI[] armors;
    
    ///////////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////
    //                    METHODS                      ////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////
    
    public static void run(Mod patch, Mod merger) {
        Forms.gen(merger);
        
        weapons = new LVLI[Etch.TO_NUM_TARGETS];
        for (int i = 0; i < weapons.length; i++) {
            if (i != Etch.TO_DRAGON_SCALE) {
                weapons[i] = new LVLI("LIweapon" + Etch.ETCH_EDID[i]);
            }
        }
        
        armors = new LVLI[Etch.TO_NUM_TARGETS];
        for (int i = 0; i < armors.length; i++) {
            if (i != Etch.TO_SILVER) {
                armors[i] = new LVLI("LIarmor" + Etch.ETCH_EDID[i]);
            }
        }
        
        for (WEAP weapon : merger.getWeapons()) {
            if (!weapon.get(WeaponFlag.CantDrop) && !weapon.get(WeaponFlag.NonPlayable)) {
                EtchWeapon.run(patch, weapon);
            }
        }
        for (ARMO armor : merger.getArmors()) {
            if (armor.getBodyTemplate().getArmorType(BodyTemplateType.Biped) != ArmorType.CLOTHING
                    && !armor.getBodyTemplate().get(GeneralFlags.NonPlayable)) {
                EtchArmor.run(patch, armor);
            }
        }
        
        for (int i = 0; i < weapons.length; i++) {
            if (weapons[i] != null && !weapons[i].isEmpty()) {
                patch.addRecord(weapons[i]);
            }
        }
        for (int i = 0; i < armors.length; i++) {
            if (armors[i] != null && !armors[i].isEmpty()) {
                patch.addRecord(armors[i]);
            }
        }
    }
}
