package skyprocstarter;

import skyproc.FormID;
import skyproc.GRUP;
import skyproc.INGR;
import skyproc.MISC;
import skyproc.Mod;

public final class Forms {
    /** Prevent construction of this class. */
    private Forms() { new AssertionError(); }
    
    ///////////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////
    //                  CONSTANTS                      ////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////
    
    public static float[] ADD_WEIGHT = {
        //silver    orcish  glass   ebony   dragonscale dragonbone  daedric
        0.0f,       0.0f,   0.0f,   0.0f,   0.0f,       0.0f,       0.0f
    };
    
    public static FormID WEAP_IRON;
    public static FormID WEAP_STEEL;
    public static FormID WEAP_SILVER;
    public static FormID WEAP_DWARVEN;
    public static FormID WEAP_ELVEN;
    public static FormID WEAP_ORCISH;
    public static FormID WEAP_GLASS;
    public static FormID WEAP_EBONY;
    public static FormID WEAP_DAEDRIC;
    public static FormID WEAP_DRAGON_BONE;
    
    public static FormID ARMO_HEAVY;
    public static FormID ARMO_LIGHT;
    
    public static FormID ARMO_IRON;
    public static FormID ARMO_IRON_BANDED;
    public static FormID ARMO_STEEL;
    public static FormID ARMO_STEEL_PLATE;
    public static FormID ARMO_IMPERIAL_HEAVY;
    public static FormID ARMO_DWARVEN;
    public static FormID ARMO_ELVEN;
    public static FormID ARMO_ELVEN_GILDED;
    public static FormID ARMO_ORCISH;
    public static FormID ARMO_GLASS;
    public static FormID ARMO_EBONY;
    public static FormID ARMO_DAEDRIC;
    public static FormID ARMO_DRAGON_SCALE;
    public static FormID ARMO_DRAGON_BONE;
    public static FormID ARMO_LEATHER; 
    public static FormID ARMO_HIDE;
    public static FormID ARMO_SCALED; 
    public static FormID ARMO_STUDDED; 
    public static FormID ARMO_IMPERIAL_LIGHT; 
    public static FormID ARMO_IMPERIAL_STUDDED;
    
//    public static FormID ARMO_IAK_IRON; 
//    public static FormID ARMO_IAK_STEEL;
//    public static FormID ARMO_IAK_STEEL_CHAIN; 
//    public static FormID ARMO_IAK_STEEL_PLATE;
//    public static FormID ARMO_IAK_DWARVEN; 
//    public static FormID ARMO_IAK_ELVEN;
//    public static FormID ARMO_IAK_GLASS; 
//    public static FormID ARMO_IAK_ORCISH; 
//    public static FormID ARMO_IAK_EBONY; 
//    public static FormID ARMO_IAK_SCALED;
//    public static FormID ARMO_IAK_LEATHER;
    
    public static FormID CROSSBOW_HEAVY;
    public static FormID CROSSBOW_LIGHT;
    public static FormID BOW_HEAVY;
    public static FormID BOW_LIGHT;
    
    public static FormID DAEDRA_HEART;
    public static FormID LEATHER;
    public static FormID INGOT_IRON;
    public static FormID INGOT_STEEL;
    public static FormID INGOT_CORUNDUM;
    public static FormID INGOT_SILVER;
    public static FormID INGOT_ORICHALCUM;
    public static FormID MOONSTONE;
    public static FormID INGOT_DWARVEN;
    public static FormID INGOT_MALACHITE;
    public static FormID INGOT_EBONY;
    public static FormID DRAGON_SCALE;
    public static FormID DRAGON_BONE;
    
    public static FormID BENCH_FORGE;
    public static FormID BENCH_GRINDSTONE;
    public static FormID BENCH_TABLE;
    
    public static FormID PERK_STEEL;
    public static FormID PERK_ADVANCED;
    public static FormID PERK_ELVEN;
    public static FormID PERK_DWARVEN;
    public static FormID PERK_ORCISH;
    public static FormID PERK_GLASS;
    public static FormID PERK_EBONY;
    public static FormID PERK_DRAGON;
    public static FormID PERK_DAEDRIC;
    
    public static FormID DISALLOW_ENCHANTING;
    public static FormID DUMMY;
    
    ///////////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////
    //                    METHODS                      ////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////
    
    protected static void gen(Mod merger) {
        WEAP_IRON = new FormID("01E718", "Skyrim.esm");
        WEAP_STEEL = new FormID("01E719", "Skyrim.esm");
        WEAP_SILVER = new FormID("10AA1A", "Skyrim.esm");
        WEAP_DWARVEN = new FormID("01E71A", "Skyrim.esm");
        WEAP_ELVEN = new FormID("01E71B", "Skyrim.esm");
        WEAP_ORCISH = new FormID("01E71C", "Skyrim.esm");
        WEAP_GLASS = new FormID("01E71D", "Skyrim.esm");
        WEAP_EBONY = new FormID("01E71E", "Skyrim.esm");
        WEAP_DAEDRIC = new FormID("01E71F", "Skyrim.esm");
        WEAP_DRAGON_BONE = new FormID("019822", "Dawnguard.esm");
        
        ARMO_HEAVY = new FormID("06BBD2", "Skyrim.esm");
        ARMO_LIGHT = new FormID("06BBD3", "Skyrim.esm");
        
        ARMO_IRON = new FormID("06BBE3", "Skyrim.esm");
        ARMO_IRON_BANDED = new FormID("06BBE4", "Skyrim.esm");
        ARMO_STEEL = new FormID("06BBE6", "Skyrim.esm");
        ARMO_STEEL_PLATE = new FormID("06BBE7", "Skyrim.esm");
        ARMO_IMPERIAL_HEAVY = new FormID("06BBE2", "Skyrim.esm");
        ARMO_DWARVEN = new FormID("06BBD7", "Skyrim.esm");
        ARMO_ELVEN = new FormID("06BBD9", "Skyrim.esm");
        ARMO_ELVEN_GILDED = new FormID("06BBDA", "Skyrim.esm");
        ARMO_ORCISH = new FormID("06BBE5", "Skyrim.esm");
        ARMO_GLASS = new FormID("06BBDC", "Skyrim.esm");
        ARMO_EBONY = new FormID("06BBD8", "Skyrim.esm");
        ARMO_DAEDRIC = new FormID("06BBD4", "Skyrim.esm");
        ARMO_DRAGON_SCALE = new FormID("06BBD6", "Skyrim.esm");
        ARMO_DRAGON_BONE = new FormID("06BBD5", "Skyrim.esm");
        ARMO_LEATHER = new FormID("06BBDB", "Skyrim.esm");
        ARMO_HIDE = new FormID("06BBDD", "Skyrim.esm");
        ARMO_SCALED = new FormID("06BBDE", "Skyrim.esm");
        ARMO_STUDDED = new FormID("06BBDF", "Skyrim.esm");
        ARMO_IMPERIAL_LIGHT = new FormID("06BBE0", "Skyrim.esm");
        ARMO_IMPERIAL_STUDDED = new FormID("06BBE1", "Skyrim.esm");
        
//        ARMO_IAK_IRON = new FormID("0412CE", "Hothtrooper44_ArmorCompilation.esp");
//        ARMO_IAK_STEEL = new FormID("0142C9", "Hothtrooper44_ArmorCompilation.esp");
//        ARMO_IAK_STEEL_CHAIN = new FormID("0142D1", "Hothtrooper44_ArmorCompilation.esp");
//        ARMO_IAK_STEEL_PLATE = new FormID("0142CF", "Hothtrooper44_ArmorCompilation.esp");
//        ARMO_IAK_DWARVEN = new FormID("0142C4", "Hothtrooper44_ArmorCompilation.esp");
//        ARMO_IAK_ELVEN = new FormID("0142C6", "Hothtrooper44_ArmorCompilation.esp");
//        ARMO_IAK_GLASS = new FormID("0142C7", "Hothtrooper44_ArmorCompilation.esp");
//        ARMO_IAK_ORCISH = new FormID("0142C8", "Hothtrooper44_ArmorCompilation.esp");
//        ARMO_IAK_EBONY = new FormID("0142C5", "Hothtrooper44_ArmorCompilation.esp");
//        ARMO_IAK_SCALED = new FormID("0142CA", "Hothtrooper44_ArmorCompilation.esp");
//        ARMO_IAK_LEATHER = new FormID("0142CB", "Hothtrooper44_ArmorCompilation.esp");
        
        CROSSBOW_HEAVY = new FormID("899DBE", "Requiem.esp");
        CROSSBOW_LIGHT = new FormID("9F7179", "Requiem.esp");
        BOW_HEAVY = new FormID("9F9914", "Requiem.esp");
        BOW_LIGHT = new FormID("9F9915", "Requiem.esp");
        
        DAEDRA_HEART = new FormID("03AD5B", "Skyrim.esm");
        LEATHER = new FormID("DB5D2", "Skyrim.esm");
        INGOT_IRON = new FormID("5ACE4", "Skyrim.esm");;
        INGOT_STEEL = new FormID("5ACE5", "Skyrim.esm");;
        INGOT_CORUNDUM = new FormID("5AD93", "Skyrim.esm");;
        INGOT_SILVER = new FormID("05ACE3", "Skyrim.esm");
        INGOT_ORICHALCUM = new FormID("05AD99", "Skyrim.esm");
        MOONSTONE = new FormID("5AD9F", "Skyrim.esm");
        INGOT_DWARVEN = new FormID("DB8A2", "Skyrim.esm");
        INGOT_MALACHITE = new FormID("05ADA1", "Skyrim.esm");
        INGOT_EBONY = new FormID("05AD9D", "Skyrim.esm");
        DRAGON_SCALE = new FormID("03ADA3", "Skyrim.esm");
        DRAGON_BONE = new FormID("03ADA4", "Skyrim.esm");
        
        BENCH_FORGE = new FormID("088105", "Skyrim.esm");
        BENCH_GRINDSTONE = new FormID("088108", "Skyrim.esm");
        BENCH_TABLE = new FormID("0ADB78", "Skyrim.esm");
        
        PERK_STEEL = new FormID("0CB40D", "Skyrim.esm");
        PERK_ADVANCED = new FormID("CB414", "Skyrim.esm");
        PERK_ELVEN = new FormID("CB40F", "Skyrim.esm");
        PERK_DWARVEN = new FormID("CB40E", "Skyrim.esm");
        PERK_ORCISH = new FormID("0CB410", "Skyrim.esm");
        PERK_GLASS = new FormID("0CB411", "Skyrim.esm");
        PERK_EBONY = new FormID("0CB412", "Skyrim.esm");
        PERK_DRAGON = new FormID("052190", "Skyrim.esm");
        PERK_DAEDRIC = new FormID("0CB413", "Skyrim.esm");
        
        DISALLOW_ENCHANTING = new FormID("0C27BD", "Skyrim.esm");
        DUMMY = new FormID("0F3E6C", "Skyrim.esm");
        
        GRUP<INGR> ingredients = merger.getIngredients();
        ADD_WEIGHT[Etch.TO_DAEDRIC] = ((INGR) ingredients.get(DAEDRA_HEART)).getWeight();
        
        GRUP<MISC> misc = merger.getMiscObjects();
        ADD_WEIGHT[Etch.TO_SILVER] = ((MISC) misc.get(INGOT_SILVER)).getWeight();
        ADD_WEIGHT[Etch.TO_ORCISH] = ((MISC) misc.get(INGOT_ORICHALCUM)).getWeight();
        ADD_WEIGHT[Etch.TO_GLASS] = ((MISC) misc.get(INGOT_MALACHITE)).getWeight();
        ADD_WEIGHT[Etch.TO_EBONY] = ((MISC) misc.get(INGOT_EBONY)).getWeight();
        ADD_WEIGHT[Etch.TO_DRAGON_SCALE] = ((MISC) misc.get(DRAGON_SCALE)).getWeight() / 3.0f;
        ADD_WEIGHT[Etch.TO_DRAGON_BONE] = ((MISC) misc.get(DRAGON_BONE)).getWeight() / 3.0f;
    }
}
