package skyprocstarter;

import java.util.ArrayList;

import skyproc.FormID;
import skyproc.Mod;
import skyproc.WEAP;

public final class EtchWeapon {
    /** Prevent construction of this class. */
    private EtchWeapon() { new AssertionError(); }
    
    ///////////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////
    //                  CONSTANTS                      ////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////
    
    private static final int[][] ADD_DAMAGE = {
        //                  silver              orcish              glass               ebony               dragonscale         dragonbone          daedric
        /* iron */          {5,                 15,                 15,                 25,                 Etch.NO_CHANGE,     45,                 35},
        /* steel */         {0,                 5,                  5,                  10,                 Etch.NO_CHANGE,     30,                 20},
        /* dwarven */       {-2,                2,                  Etch.NO_CHANGE,     7,                  Etch.NO_CHANGE,     20,                 10},
        /* elven */         {-2,                Etch.NO_CHANGE,     10,                 5,                  Etch.NO_CHANGE,     15,                 7},
        /* orcish */        {-2,                Etch.NO_CHANGE,     Etch.NO_CHANGE,     2,                  Etch.NO_CHANGE,     7,                  5},
        /* glass */         {-2,                Etch.NO_CHANGE,     Etch.NO_CHANGE,     2,                  Etch.NO_CHANGE,     10,                 7},
        /* ebony */         {-2,                Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     2},
        /* daedric */       {-2,                Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE},
        /* dragonbone */    {-2,                Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE}
    };
    
    private static final int[][] BOW_LIGHT_ADD_DAMAGE = {
        //                  silver              orcish              glass               ebony               dragonscale         dragonbone          daedric
        /* iron */          {Etch.NO_CHANGE,    13,                 8,                  18,                 Etch.NO_CHANGE,     26,                 23},
        /* steel */         {Etch.NO_CHANGE,    8,                  3,                  10,                 Etch.NO_CHANGE,     18,                 15},
        /* dwarven */       {Etch.NO_CHANGE,    3,                  Etch.NO_CHANGE,     8,                  Etch.NO_CHANGE,     12,                 10},
        /* elven */         {Etch.NO_CHANGE,    Etch.NO_CHANGE,     15,                 5,                  Etch.NO_CHANGE,     18,                 8},
        /* orcish */        {Etch.NO_CHANGE,    Etch.NO_CHANGE,     Etch.NO_CHANGE,     3,                  Etch.NO_CHANGE,     8,                  5},
        /* glass */         {Etch.NO_CHANGE,    Etch.NO_CHANGE,     Etch.NO_CHANGE,     2,                  Etch.NO_CHANGE,     14,                 3},
        /* ebony */         {Etch.NO_CHANGE,    Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     2},
        /* daedric */       {Etch.NO_CHANGE,    Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE},
        /* dragonbone */    {Etch.NO_CHANGE,    Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE}
    };
    
    private static final int[][] BOW_HEAVY_ADD_DAMAGE = {
        //                  silver              orcish              glass               ebony               dragonscale         dragonbone          daedric
        /* iron */          {Etch.NO_CHANGE,    15,                 7,                  25,                 Etch.NO_CHANGE,     37,                 35},
        /* steel */         {Etch.NO_CHANGE,    5,                  3,                  10,                 Etch.NO_CHANGE,     30,                 20},
        /* dwarven */       {Etch.NO_CHANGE,    2,                  Etch.NO_CHANGE,     7,                  Etch.NO_CHANGE,     20,                 10},
        /* elven */         {Etch.NO_CHANGE,    Etch.NO_CHANGE,     5,                  5,                  Etch.NO_CHANGE,     10,                 7},
        /* orcish */        {Etch.NO_CHANGE,    Etch.NO_CHANGE,     Etch.NO_CHANGE,     3,                  Etch.NO_CHANGE,     7,                  5},
        /* glass */         {Etch.NO_CHANGE,    Etch.NO_CHANGE,     Etch.NO_CHANGE,     2,                  Etch.NO_CHANGE,     5,                  3},
        /* ebony */         {Etch.NO_CHANGE,    Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     2},
        /* daedric */       {Etch.NO_CHANGE,    Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE},
        /* dragonbone */    {Etch.NO_CHANGE,    Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE}
    };
    
    private static final int[][] CROSSBOW_LIGHT_ADD_DAMAGE = {
        //                  silver              orcish              glass               ebony               dragonscale         dragonbone          daedric
        /* iron */          {Etch.NO_CHANGE,    13,                 8,                  18,                 Etch.NO_CHANGE,     26,                 23},
        /* steel */         {Etch.NO_CHANGE,    8,                  3,                  10,                 Etch.NO_CHANGE,     18,                 15},
        /* dwarven */       {Etch.NO_CHANGE,    3,                  Etch.NO_CHANGE,     8,                  Etch.NO_CHANGE,     12,                 10},
        /* elven */         {Etch.NO_CHANGE,    Etch.NO_CHANGE,     15,                 5,                  Etch.NO_CHANGE,     18,                 8},
        /* orcish */        {Etch.NO_CHANGE,    Etch.NO_CHANGE,     Etch.NO_CHANGE,     3,                  Etch.NO_CHANGE,     8,                  5},
        /* glass */         {Etch.NO_CHANGE,    Etch.NO_CHANGE,     Etch.NO_CHANGE,     2,                  Etch.NO_CHANGE,     14,                 3},
        /* ebony */         {Etch.NO_CHANGE,    Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     2},
        /* daedric */       {Etch.NO_CHANGE,    Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE},
        /* dragonbone */    {Etch.NO_CHANGE,    Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE}
    };
    
    private static final int[][] CROSSBOW_HEAVY_ADD_DAMAGE = {
        //                  silver              orcish              glass               ebony               dragonscale         dragonbone          daedric
        /* iron */          {Etch.NO_CHANGE,    15,                 7,                  25,                 Etch.NO_CHANGE,     37,                 35},
        /* steel */         {Etch.NO_CHANGE,    5,                  3,                  10,                 Etch.NO_CHANGE,     30,                 20},
        /* dwarven */       {Etch.NO_CHANGE,    2,                  Etch.NO_CHANGE,     7,                  Etch.NO_CHANGE,     20,                 10},
        /* elven */         {Etch.NO_CHANGE,    Etch.NO_CHANGE,     5,                  5,                  Etch.NO_CHANGE,     10,                 7},
        /* orcish */        {Etch.NO_CHANGE,    Etch.NO_CHANGE,     Etch.NO_CHANGE,     3,                  Etch.NO_CHANGE,     7,                  5},
        /* glass */         {Etch.NO_CHANGE,    Etch.NO_CHANGE,     Etch.NO_CHANGE,     2,                  Etch.NO_CHANGE,     5,                  3},
        /* ebony */         {Etch.NO_CHANGE,    Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     2},
        /* daedric */       {Etch.NO_CHANGE,    Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE},
        /* dragonbone */    {Etch.NO_CHANGE,    Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE}
    };
    
    ///////////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////
    //                    METHODS                      ////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////
    
    /**
     * Creates the etched version of a weapon, including the recipe to create it,
     *  and adds that recipe to the current patch.
     * Only non-enchanted weapons with an appropriate material can be etched.
     * @param patch the {@link Mod} current patch
     * @param weapon the {@link WEAP} weapon to etch
     */
    protected static void run(Mod patch, WEAP weapon) {
        if (Etch.isEnchanted(weapon.getEnchantment(), weapon.getKeywordSet().getKeywordRefs())) { 
            return; 
        }
        
        final ArrayList<FormID> keywords = weapon.getKeywordSet().getKeywordRefs();
        final int upgradeType = Etch.getWeaponMaterial(keywords);
        final int bowType = Etch.getBowType(keywords);
        if (upgradeType == Etch.NO_CHANGE) {
            return;
        }
        
        final float[] valueTable = Etch.ADD_VALUE[upgradeType];
        final int[] damageTable;
        switch (bowType) {
            case Etch.CROSSBOW_HEAVY:   damageTable = CROSSBOW_HEAVY_ADD_DAMAGE[upgradeType]; break;
            case Etch.CROSSBOW_LIGHT:   damageTable = CROSSBOW_LIGHT_ADD_DAMAGE[upgradeType]; break;
            case Etch.BOW_HEAVY:        damageTable = BOW_HEAVY_ADD_DAMAGE[upgradeType]; break;
            case Etch.BOW_LIGHT:        damageTable = BOW_LIGHT_ADD_DAMAGE[upgradeType]; break;
            default:                    damageTable = ADD_DAMAGE[upgradeType]; break;
        }
        
        for (int i = 0; i < Etch.TO_NUM_TARGETS; i++) {
            if (damageTable[i] == Etch.NO_CHANGE) { 
                continue; 
            }
            
            WEAP etched = (WEAP) weapon.copy(weapon.getEDID() + Etch.ETCH_EDID[i]);
            etched.setName(etched.getName() + Etch.ETCH_NAME[i]);
            etched.setDescription(Etch.ETCH_DESC[i]);
            etched.setDamage(etched.getDamage() + damageTable[i]);
            etched.setWeight((int) (etched.getWeight() + Forms.ADD_WEIGHT[i]));
            etched.setValue((int) (etched.getValue() * valueTable[i]));
            Etch.replaceWeaponMaterial(etched, upgradeType, i);
            
            Recipe.makeWeapon(patch, weapon, i, etched);
            patch.addRecord(etched);
            
            Patch.weapons[i].addEntry(etched.getForm(), 1, 1);
        }
    }
}
