package skyprocstarter;

import java.util.ArrayList;

import skyproc.ARMO;
import skyproc.FormID;
import skyproc.Mod;

public final class EtchArmor {
    /** Prevent construction of this class. */
    private EtchArmor() { new AssertionError(); }
    
    ///////////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////
    //                  CONSTANTS                      ////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////

    private static final float[][] ADD_ARMOR = {
        //                  silver              orcish              glass               ebony               dragonscale         dragonbone          daedric
        /* iron */          {Etch.NO_CHANGE,    1.4f,               Etch.NO_CHANGE,     1.55f,              Etch.NO_CHANGE,     3.75f,              3.9f},
        /* steel */         {Etch.NO_CHANGE,    1.1f,               Etch.NO_CHANGE,     1.25f,              Etch.NO_CHANGE,     2.9f,               3.1f},
        /* dwarven */       {Etch.NO_CHANGE,    1.05f,              Etch.NO_CHANGE,     1.15f,              Etch.NO_CHANGE,     2.4f,               2.55f},
        /* elven */         {Etch.NO_CHANGE,    Etch.NO_CHANGE,     1.15f,              Etch.NO_CHANGE,     2.65f,              Etch.NO_CHANGE,     Etch.NO_CHANGE},
        /* orcish */        {Etch.NO_CHANGE,    Etch.NO_CHANGE,     Etch.NO_CHANGE,     1.05f,              Etch.NO_CHANGE,     2.2f,               2.3f},
        /* glass */         {Etch.NO_CHANGE,    Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     2.05f,              Etch.NO_CHANGE,     Etch.NO_CHANGE},
        /* ebony */         {Etch.NO_CHANGE,    Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     2.15f},
        /* daedric */       {Etch.NO_CHANGE,    Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE},
        /* dragonbone */    {Etch.NO_CHANGE,    Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE,     Etch.NO_CHANGE},
        /* hide */          {Etch.NO_CHANGE,    Etch.NO_CHANGE,     2.0f,               Etch.NO_CHANGE,     4.0f,               Etch.NO_CHANGE,     Etch.NO_CHANGE},
        /* studded */       {Etch.NO_CHANGE,    Etch.NO_CHANGE,     1.5f,               Etch.NO_CHANGE,     3.5f,               Etch.NO_CHANGE,     Etch.NO_CHANGE},
        /* leather */       {Etch.NO_CHANGE,    Etch.NO_CHANGE,     1.3f,               Etch.NO_CHANGE,     3.0f,               Etch.NO_CHANGE,     Etch.NO_CHANGE},
        /* scale */         {Etch.NO_CHANGE,    Etch.NO_CHANGE,     1.2f,               Etch.NO_CHANGE,     2.65f,              Etch.NO_CHANGE,     Etch.NO_CHANGE},
    };
    
    ///////////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////
    //                    METHODS                      ////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////
    
    /**
     * Creates the etched version of an armor, including the recipe to create it,
     *  and adds that recipe to the current patch.
     * Only non-enchanted armor with an appropriate material can be etched.
     * @param patch the {@link Mod} current patch
     * @param armor the {@link ARMO} armor to etch
     */
    protected static void run(Mod patch, ARMO armor) {
        if (Etch.isEnchanted(armor.getEnchantment(), armor.getKeywordSet().getKeywordRefs())) { 
            return; 
        }
        
        final ArrayList<FormID> keywords = armor.getKeywordSet().getKeywordRefs();
        final int upgradeType = Etch.getArmorMaterial(keywords);
        if (upgradeType == Etch.NO_CHANGE) {
            return;
        }
        
        final float[] valueTable = Etch.ADD_VALUE[upgradeType];
        final float[] armorTable = ADD_ARMOR[upgradeType];
        
        for (int i = 0; i < Etch.TO_NUM_TARGETS; i++) {
            if (armorTable[i] == Etch.NO_CHANGE) { 
                continue;
            }
            
            ARMO etched = (ARMO) armor.copy(armor.getEDID() + Etch.ETCH_EDID[i]);
            etched.setName(etched.getName() + Etch.ETCH_NAME[i]);
            etched.setDescription(Etch.ETCH_DESC[i]);
            etched.setArmorRating((int) (etched.getArmorRating() * armorTable[i]));
            etched.setWeight((int) (etched.getWeight() + Forms.ADD_WEIGHT[i]));
            etched.setValue((int) (etched.getValue() * valueTable[i]));
            Etch.replaceArmorMaterial(etched, upgradeType, i);
            
            Recipe.makeArmor(patch, armor, i, etched);
            patch.addRecord(etched);
            
            Patch.armors[i].addEntry(etched.getForm(), 1, 1);
        }
    }
}
