package skyprocstarter;

import java.util.ArrayList;

import skyproc.ARMO;
import skyproc.FormID;
import skyproc.KeywordSet;
import skyproc.WEAP;

public final class Etch {
    /** Prevent construction of this class. */
    private Etch() { new AssertionError(); }
    
    ///////////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////
    //                  CONSTANTS                      ////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////
    
    public static String[] ETCH_NAME = {
        " (Silver)",
        " (Orcish)",
        " (Glass)",
        " (Ebony)",
        " (Dragonscale)",
        " (Dragonbone)",
        " (Daedric)"
    };
    
    public static String[] ETCH_DESC = {
        "Reinforced with a silver alloy.",
        "Reinforced with orichalcum.",
        "Reinforced with malachite.",
        "Reinforced with ebony.",
        "Reinforced with a dragon's scales.",
        "Reinforced with the bones of a dragon.",
        "Reinforced with a daedra's heart."
    };
    
    public static String[] ETCH_EDID = {
        "_etchSilver",
        "_etchOrcish",
        "_etchGlass",
        "_etchEbony",
        "_etchDragonScale",
        "_etchDragonBone",
        "_etchDaedric"
    };
    
    /** Index for converting an item to silver. */
    public static final int TO_SILVER = 0;
    
    /** Index for converting an item to orcish. */
    public static final int TO_ORCISH = 1;
    
    /** Index for converting an item to glass. */
    public static final int TO_GLASS = 2;
    
    /** Index for converting an item to ebony. */
    public static final int TO_EBONY = 3;
    
    /** Index for converting an item to dragonscale. */
    public static final int TO_DRAGON_SCALE = 4;
    
    /** Index for converting an item to dragonbone. */
    public static final int TO_DRAGON_BONE = 5;
    
    /** Index for converting an item to daedric. */
    public static final int TO_DAEDRIC = 6;
    
    /** The total number of etch targets. */
    public static final int TO_NUM_TARGETS = 7;
    
    /** Index for indicating that no change is to be performed. */
    public static final int NO_CHANGE = -1;
    
    /** Indicates iron weapons or armor that can be etched. */
    public static final int IRON = 0;
    
    /** Indicates steel weapons or armor that can be etched. */
    public static final int STEEL = 1;
    
    /** Indicates dwarven weapons or armor that can be etched. */
    public static final int DWARVEN = 2;
    
    /** Indicates elven weapons or armor that can be etched. */
    public static final int ELVEN = 3;
    
    /** Indicates orcish weapons or armor that can be etched. */
    public static final int ORCISH = 4;
    
    /** Indicates glass weapons or armor that can be etched. */
    public static final int GLASS = 5;
    
    /** Indicates ebony weapons or armor that can be etched. */
    public static final int EBONY = 6;
    
    /** Indicates daedric weapons or armor that can be etched. */
    public static final int DAEDRIC = 7;
    
    /** Indicates dragonbone weapons or armor that can be etched. */
    public static final int DRAGONBONE = 8;
    
    /** Indicates hide armor that can be etched. */
    public static final int HIDE = 9;
    
    /** Indicates studded armor that can be etched. */
    public static final int STUDDED = 10;
    
    /** Indicates leather armor that can be etched. */
    public static final int LEATHER = 11;
    
    /** Indicates scaled armor that can be etched. */
    public static final int SCALED = 12;
    
    /** Indicates silver weapons that can be etched. */
    public static final int SILVER = 13;
    
    /** Indicates dragonscale armor that can be etched. */
    public static final int DRAGONSCALE = 14;
    
    /** Indicates that the weapon is a heavy crossbow. */
    public static final int CROSSBOW_HEAVY = 0;
    
    /** Indicates that the weapon is a light crossbow. */
    public static final int CROSSBOW_LIGHT = 1;
    
    /** Indicates that the weapon is a heavy bow. */
    public static final int BOW_HEAVY = 2;
    
    /** Indicates that the weapon is a light bow. */
    public static final int BOW_LIGHT = 3;
    
    /** An ordered array of material types from worst to best. */
    public static final int[] BEST_MATERIAL = {
        HIDE,                   STUDDED,                LEATHER,                IRON,              
        STEEL,                  SCALED,                 SILVER,                 ELVEN,
        DWARVEN,                ORCISH,                 GLASS,                  EBONY,
        DAEDRIC,                DRAGONSCALE,            DRAGONBONE};
    
    /** The FormIDs for tempering the materials defined in {@link #BEST_MATERIAL}. */
    public static final FormID[] TEMPER_BEST_MATERIAL = {
        Forms.LEATHER,          Forms.INGOT_IRON,       Forms.LEATHER,          Forms.INGOT_IRON,
        Forms.INGOT_STEEL,      Forms.INGOT_CORUNDUM,   Forms.INGOT_SILVER,     Forms.MOONSTONE,
        Forms.INGOT_DWARVEN,    Forms.INGOT_ORICHALCUM, Forms.INGOT_MALACHITE,  Forms.INGOT_EBONY,
        Forms.INGOT_EBONY,      Forms.DRAGON_SCALE,     Forms.DRAGON_BONE};
    
    public static final FormID[] TEMPER_BEST_PERK = {
        Forms.PERK_STEEL,       Forms.PERK_ADVANCED,    Forms.PERK_STEEL,       Forms.PERK_STEEL,
        Forms.PERK_STEEL,       Forms.PERK_ADVANCED,    Forms.PERK_STEEL,       Forms.PERK_ELVEN,      
        Forms.PERK_DWARVEN,     Forms.PERK_ORCISH,      Forms.PERK_GLASS,       Forms.PERK_EBONY,
        Forms.PERK_EBONY,       Forms.PERK_DRAGON,      Forms.PERK_DRAGON};
    
    public static final float[][] ADD_VALUE = {
        //                  silver      orcish      glass       ebony       dragonscale dragonbone  daedric
        /* iron */          {10.0f,     50.0f,      65.0f,      95.0f,      180.0f,     200.0f,     250.0f},
        /* steel */         {5.5f,      2.7f,       36.0f,      52.0f,      100.0f,     110.0f,     138.0f},
        /* dwarven */       {1.8f,      1.1f,       11.0f,      17.0f,      32.0f,      36.0f,      45.0f},
        /* elven */         {1.1f,      1.1f,       6.8f,       10.0f,      18.0f,      21.0f,      26.0f},
        /* orcish */        {2.0f,      1.0f,       13.0f,      19.0f,      36.0f,      40.0f,      50.0f},
        /* glass */         {1.1f,      1.1f,       1.0f,       1.5f,       2.8f,       3.1f,       3.8f},
        /* ebony */         {1.1f,      1.1f,       1.1f,       1.0f,       1.9f,       2.1f,       2.6f},
        /* daedric */       {1.1f,      1.0f,       1.0f,       1.0f,       1.0f,       1.0f,       1.0f},
        /* dragonbone */    {1.1f,      1.0f,       1.0f,       1.0f,       1.0f,       1.0f,       1.0f},
        /* hide */          {1.0f,      1.0f,       46.0f,      1.0f,       150.0f,     1.0f,       1.0f},
        /* studded */       {1.0f,      1.0f,       30.5f,      1.0f,       100.0f,     1.0f,       1.0f},
        /* leather */       {1.0f,      1.0f,       18.5f,      1.0f,       60.0f,      1.0f,       1.0f},
        /* scaled */        {1.0f,      1.0f,       10.2f,      1.0f,       29.5f,      1.0f,       1.0f},
    };
    
    ///////////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////
    //                    METHODS                      ////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////////////
    
    /**
     * Obtains the highest-tier material for the given item.
     * @param itemKeywords the {@link ArrayList} of {@link FormID} weapon keywords to search
     * @return the integer best material type from {@link #BEST_MATERIAL}
     */
    public static int getBestMaterialType(ArrayList<FormID> itemKeywords) {
        int bestMaterial = 0;
        
        for (FormID keyword : itemKeywords) {
            if (bestMaterial < 0 
                    && keyword.equals(Forms.ARMO_HIDE)){
                bestMaterial = 0;
                
            } else if (bestMaterial < 1 
                    && (keyword.equals(Forms.ARMO_STUDDED) 
                            || keyword.equals(Forms.ARMO_IMPERIAL_STUDDED))) {
                bestMaterial = 1;
                
            } else if (bestMaterial < 2 
                    && (keyword.equals(Forms.ARMO_LEATHER) 
                            /*|| keyword.equals(Forms.ARMO_IAK_LEATHER)*/ 
                            || keyword.equals(Forms.ARMO_IMPERIAL_LIGHT))) {
                bestMaterial = 2;
                
            } else if (bestMaterial < 3 
                    && (keyword.equals(Forms.ARMO_IRON) 
                            || keyword.equals(Forms.ARMO_IRON_BANDED) 
                            || keyword.equals(Forms.WEAP_IRON))) {
                bestMaterial = 3;
                
            } else if (bestMaterial < 4 
                    && (keyword.equals(Forms.ARMO_STEEL) 
                            || keyword.equals(Forms.ARMO_STEEL_PLATE)
                            || keyword.equals(Forms.ARMO_IMPERIAL_HEAVY) 
                            || keyword.equals(Forms.WEAP_STEEL) 
                            /*|| keyword.equals(Forms.ARMO_IAK_STEEL)
                            || keyword.equals(Forms.ARMO_IAK_STEEL_CHAIN)
                            || keyword.equals(Forms.ARMO_IAK_STEEL_PLATE)*/)) {
                bestMaterial = 4;
                
            } else if (bestMaterial < 5 
                    && (keyword.equals(Forms.ARMO_SCALED) 
                            /*|| keyword.equals(Forms.ARMO_IAK_SCALED)*/)) {
                bestMaterial = 5;
                
            } else if (bestMaterial < 6 
                    && keyword.equals(Forms.WEAP_SILVER)) {
                bestMaterial = 6;
                
            } else if (bestMaterial < 7 
                    && (keyword.equals(Forms.ARMO_ELVEN) 
                            || keyword.equals(Forms.ARMO_ELVEN_GILDED) 
                            || keyword.equals(Forms.WEAP_ELVEN))) {
                bestMaterial = 7;  
                
            } else if (bestMaterial < 8 
                    && (keyword.equals(Forms.ARMO_DWARVEN) 
                            || keyword.equals(Forms.WEAP_DWARVEN))) {
                bestMaterial = 8;
                
            } else if (bestMaterial < 9 
                    && (keyword.equals(Forms.ARMO_ORCISH) 
                            || keyword.equals(Forms.WEAP_ORCISH))) {
                bestMaterial = 9;
                
            } else if (bestMaterial < 10 
                    && (keyword.equals(Forms.ARMO_GLASS) 
                            || keyword.equals(Forms.WEAP_GLASS))) {
                bestMaterial = 10;
                
            } else if (bestMaterial < 11
                    && (keyword.equals(Forms.ARMO_EBONY) 
                            || keyword.equals(Forms.WEAP_EBONY))) {
                bestMaterial = 11;
                
            } else if (bestMaterial < 12 
                    && (keyword.equals(Forms.ARMO_DAEDRIC) 
                            || keyword.equals(Forms.WEAP_DAEDRIC))) {
                bestMaterial = 12;
                
            } else if (bestMaterial < 13 
                    && keyword.equals(Forms.ARMO_DRAGON_SCALE)) {
                bestMaterial = 13;
                
            } else if (bestMaterial < 14 
                    && (keyword.equals(Forms.ARMO_DRAGON_BONE) 
                            || keyword.equals(Forms.WEAP_DRAGON_BONE))) {
                bestMaterial = 14;
            }
        }
        
        return bestMaterial;
    }
    
    /**
     * Gets the material of the given weapon.
     * @param weaponKeywords the {@link ArrayList} of {@link FormID} weapon keywords to search
     * @return the integer weapon material: {@link #IRON}, {@link #STEEL}, {@link #DWARVEN},
     *  {@link #ELVEN}, {@link #ORCISH}, {@link #GLASS}, {@link #EBONY}, {@link #DAEDRIC},
     *  {@link #DRAGONBONE}, or {@link #NO_CHANGE} 
     *  if the weapon material cannot be upgraded
     */
    public static int getWeaponMaterial(ArrayList<FormID> weaponKeywords) {
        for (FormID keyword : weaponKeywords) {
            if (keyword.equals(Forms.WEAP_IRON)) {
                return IRON;
            } else if (keyword.equals(Forms.WEAP_STEEL)) {
                return STEEL;
            } else if (keyword.equals(Forms.WEAP_DWARVEN)) {
                return DWARVEN;
            } else if (keyword.equals(Forms.WEAP_ELVEN)) {
                return ELVEN;
            } else if (keyword.equals(Forms.WEAP_ORCISH)) {
                return ORCISH;
            } else if (keyword.equals(Forms.WEAP_GLASS)) {
                return GLASS;
            } else if (keyword.equals(Forms.WEAP_EBONY)) {
                return EBONY;
            } else if (keyword.equals(Forms.WEAP_DAEDRIC)) {
                return DAEDRIC;
            } else if (keyword.equals(Forms.WEAP_DRAGON_BONE)) {
                return DRAGONBONE;
            }
        }
        return NO_CHANGE;
    }
    
    /**
     * Replaces the given weapon's material.
     * @param weapon the {@link WEAP} whose material should be replaced
     * @param toRemove the integer weapon material to remove
     * @param replace the integer new weapon material to use
     */
    public static void replaceWeaponMaterial(WEAP weapon, int toRemove, int replace) {
        KeywordSet keywords = weapon.getKeywordSet();
        final boolean toSilver = (replace == TO_SILVER);
        
        switch (toRemove) {
            case IRON:          keywords.removeKeywordRef(Forms.WEAP_IRON); break;
            case STEEL:         keywords.removeKeywordRef(Forms.WEAP_STEEL); break;
            case DWARVEN:       if (!toSilver) { keywords.removeKeywordRef(Forms.WEAP_DWARVEN); } break;
            case ELVEN:         if (!toSilver) { keywords.removeKeywordRef(Forms.WEAP_ELVEN); } break;
            case ORCISH:        if (!toSilver) { keywords.removeKeywordRef(Forms.WEAP_ORCISH); } break;
            case GLASS:         if (!toSilver) { keywords.removeKeywordRef(Forms.WEAP_GLASS); } break;
            case EBONY:         if (!toSilver) { keywords.removeKeywordRef(Forms.WEAP_EBONY); } break;
            case DAEDRIC:       if (!toSilver) { keywords.removeKeywordRef(Forms.WEAP_DAEDRIC); } break;
            case DRAGONBONE:    if (!toSilver) { keywords.removeKeywordRef(Forms.WEAP_DRAGON_BONE); } break;
            default:            return;
        }
        
        switch (replace) {
            case TO_SILVER:         keywords.addKeywordRef(Forms.WEAP_SILVER); break;
            case TO_ORCISH:         keywords.addKeywordRef(Forms.WEAP_ORCISH); break;
            case TO_GLASS:          keywords.addKeywordRef(Forms.WEAP_GLASS); break;
            case TO_EBONY:          keywords.addKeywordRef(Forms.WEAP_EBONY); break;
            case TO_DRAGON_BONE:    keywords.addKeywordRef(Forms.WEAP_DRAGON_BONE); break;
            case TO_DAEDRIC:        keywords.addKeywordRef(Forms.WEAP_DAEDRIC); break;
        }
    }
    
    /**
     * Replaces the given armor's material.
     * @param armor the {@link ARMO} whose material should be replaced
     * @param toRemove the integer armor material to remove
     * @param replace the integer new armor material to use
     */
    public static void replaceArmorMaterial(ARMO armor, int toRemove, int replace) {
        KeywordSet keywords = armor.getKeywordSet();
        switch (toRemove) {
            case IRON:          keywords.removeKeywordRef(Forms.ARMO_IRON); 
                                keywords.removeKeywordRef(Forms.ARMO_IRON_BANDED);
                                break;
                            
            case STEEL:         keywords.removeKeywordRef(Forms.ARMO_STEEL); 
                                keywords.removeKeywordRef(Forms.ARMO_STEEL_PLATE);
                                keywords.removeKeywordRef(Forms.ARMO_IMPERIAL_HEAVY);
                                break;
                            
            case DWARVEN:       keywords.removeKeywordRef(Forms.ARMO_DWARVEN); break;
            
            case ELVEN:         keywords.removeKeywordRef(Forms.ARMO_ELVEN); 
                                keywords.removeKeywordRef(Forms.ARMO_ELVEN_GILDED);
                                break;
             
            case ORCISH:        keywords.removeKeywordRef(Forms.ARMO_ORCISH); break;
            
            case GLASS:         keywords.removeKeywordRef(Forms.ARMO_GLASS); break;
            
            case EBONY:         keywords.removeKeywordRef(Forms.ARMO_EBONY); break;
            
            case DAEDRIC:       keywords.removeKeywordRef(Forms.ARMO_DAEDRIC); break;
            
            case DRAGONBONE:    keywords.removeKeywordRef(Forms.ARMO_DRAGON_BONE); break;
            
            case SCALED:        keywords.removeKeywordRef(Forms.ARMO_SCALED); break;
            
            case LEATHER:       keywords.removeKeywordRef(Forms.ARMO_LEATHER);
                                keywords.removeKeywordRef(Forms.ARMO_IMPERIAL_LIGHT);
                                break;
                            
            case STUDDED:       keywords.removeKeywordRef(Forms.ARMO_STUDDED);
                                keywords.removeKeywordRef(Forms.ARMO_IMPERIAL_STUDDED);
                                break;
                            
            case HIDE:          keywords.removeKeywordRef(Forms.ARMO_HIDE); break;
                
            default:            return;
        }
        
        switch (replace) {
            case TO_ORCISH:         keywords.addKeywordRef(Forms.ARMO_ORCISH); break;
            case TO_GLASS:          keywords.addKeywordRef(Forms.ARMO_GLASS); break;
            case TO_EBONY:          keywords.addKeywordRef(Forms.ARMO_EBONY); break;
            case TO_DRAGON_SCALE:   keywords.addKeywordRef(Forms.ARMO_DRAGON_SCALE); break;
            case TO_DRAGON_BONE:    keywords.addKeywordRef(Forms.ARMO_DRAGON_BONE); break;
            case TO_DAEDRIC:        keywords.addKeywordRef(Forms.ARMO_DAEDRIC); break;
        }
    }
    
    /**
     * Gets the material of the given armor.
     * @param armorKeywords the {@link ArrayList} of {@link FormID} armor keywords to search
     * @return the integer armor material: {@link #IRON}, {@link #STEEL}, {@link #DWARVEN},
     *  {@link #ELVEN}, {@link #ORCISH}, {@link #GLASS}, {@link #EBONY}, or {@link #NO_CHANGE} 
     *  if the armor material cannot be upgraded
     */
    public static int getArmorMaterial(ArrayList<FormID> armorKeywords) {
        for (FormID keyword : armorKeywords) {
            if (keyword.equals(Forms.ARMO_IRON) 
                    || keyword.equals(Forms.ARMO_IRON_BANDED)) {
                return IRON;
                
            } else if (keyword.equals(Forms.ARMO_STEEL) 
                    || keyword.equals(Forms.ARMO_STEEL_PLATE)
                    || keyword.equals(Forms.ARMO_IMPERIAL_HEAVY) 
                    /*|| keyword.equals(Forms.ARMO_IAK_STEEL)
                    || keyword.equals(Forms.ARMO_IAK_STEEL_CHAIN)
                    || keyword.equals(Forms.ARMO_IAK_STEEL_PLATE)*/) {
                return STEEL;
                
            } else if (keyword.equals(Forms.ARMO_DWARVEN)) {
                return DWARVEN;
                
            } else if (keyword.equals(Forms.ARMO_ELVEN) 
                    || keyword.equals(Forms.ARMO_ELVEN_GILDED)) {
                return ELVEN;
                
            } else if (keyword.equals(Forms.ARMO_ORCISH)) {
                return ORCISH;
                
            } else if (keyword.equals(Forms.ARMO_GLASS)) {
                return GLASS;
                
            } else if (keyword.equals(Forms.ARMO_EBONY)) {
                return EBONY;
                
            } else if (keyword.equals(Forms.ARMO_DAEDRIC)) {
                return DAEDRIC;
                
            } else if (keyword.equals(Forms.ARMO_DRAGON_BONE)) {
                return DRAGONBONE;
                
            } else if (keyword.equals(Forms.ARMO_SCALED) 
                    /*|| keyword.equals(Forms.ARMO_IAK_SCALED)*/) {
                return SCALED;
                
            } else if (keyword.equals(Forms.ARMO_LEATHER) 
                    /*|| keyword.equals(Forms.ARMO_IAK_LEATHER)*/ 
                    || keyword.equals(Forms.ARMO_IMPERIAL_LIGHT)) {
                return LEATHER;
                
            } else if (keyword.equals(Forms.ARMO_STUDDED) 
                    || keyword.equals(Forms.ARMO_IMPERIAL_STUDDED)) {
                return STUDDED;
                
            } else if (keyword.equals(Forms.ARMO_HIDE)){
                return HIDE;
            }
        }
        return NO_CHANGE;
    }
    
    /**
     * Gets the bow type of the given weapon.
     * @param weaponKeywords the {@link ArrayList} of {@link FormID} weapon keywords to search
     * @return the integer bow type: {@link #CROSSBOW_HEAVY}, {@link #CROSSBOW_LIGHT},
     *  {@link #BOW_HEAVY}, {@link #BOW_LIGHT}, or {@link #NO_CHANGE} if this weapon is not a bow
     */
    public static int getBowType(ArrayList<FormID> weaponKeywords) {
        for (FormID keyword : weaponKeywords) {
            if (keyword.equals(Forms.CROSSBOW_HEAVY)) {
                return CROSSBOW_HEAVY;
            } else if (keyword.equals(Forms.CROSSBOW_LIGHT)) {
                return CROSSBOW_LIGHT;
            } else if (keyword.equals(Forms.BOW_HEAVY)) {
                return BOW_HEAVY;
            } else if (keyword.equals(Forms.BOW_LIGHT)) {
                return BOW_LIGHT;
            }
        }
        return NO_CHANGE;
    }
    
    /**
     * Determines whether the given enchantment prevents an item from being etched.
     * @param enchantment the {@link FormID} enchantment to check
     * @param keywords the {@link ArrayList} of {@link FormID} item keywords
     * @return a boolean, {@code true} if the given enchantment prevents etching
     */
    public static boolean isEnchanted(FormID enchantment, ArrayList<FormID> keywords) {
        return enchantment == null || !enchantment.toString().equals("NULL") 
                || keywords.contains(Forms.DISALLOW_ENCHANTING) 
                || keywords.contains(Forms.DUMMY)
                || keywords.contains(Forms.WEAP_SILVER) 
                /*|| keywords.contains(Forms.WEAP_DAEDRIC)*/
                || keywords.contains(Forms.ARMO_DAEDRIC)
                /*|| keywords.contains(Forms.WEAP_DRAGON_BONE)*/
                || keywords.contains(Forms.ARMO_DRAGON_BONE) 
                || keywords.contains(Forms.ARMO_DRAGON_SCALE);
    }
}
