/*
 * Decompiled with CFR 0.152.
 */
package skyprocstarter;

import java.awt.Color;
import java.awt.Font;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import lev.gui.LSaveFile;
import skyproc.GRUP_TYPE;
import skyproc.Mod;
import skyproc.ModListing;
import skyproc.SPGlobal;
import skyproc.SkyProcSave;
import skyproc.gui.SPMainMenuPanel;
import skyproc.gui.SUM;
import skyproc.gui.SUMGUI;
import skyprocstarter.OtherSettingsPanel;
import skyprocstarter.Patch;
import skyprocstarter.WelcomePanel;
import skyprocstarter.YourSaveFile;

public class SkyProcStarter
implements SUM {
    GRUP_TYPE[] importRequests = new GRUP_TYPE[]{GRUP_TYPE.WEAP, GRUP_TYPE.ARMO, GRUP_TYPE.INGR, GRUP_TYPE.MISC};
    public static String myPatchName = "WeaponArmorEtching";
    public static String authorName = "Lord Zapharos";
    public static String version = "1.0";
    public static String welcomeText = "This patch creates recipes for etching ebony, daedra hearts, dragon bones, silver, orichalcum, and malachite into weapons and armor, making them considerably stronger.";
    public static String descriptionToShowInSUM = "This patch creates recipes for etching ebony, daedra hearts, dragon bones, silver, orichalcum, and malachite into weapons and armor, making them considerably stronger.";
    public static Color headerColor = new Color(66, 181, 184);
    public static Color settingsColor = new Color(72, 179, 58);
    public static Font settingsFont = new Font("Serif", 1, 15);
    public static SkyProcSave save = new YourSaveFile();

    public static void main(String[] args) {
        try {
            SPGlobal.createGlobalLog();
            SUMGUI.open(new SkyProcStarter(), args);
        }
        catch (Exception e) {
            System.err.println(e.toString());
            SPGlobal.logException(e);
            JOptionPane.showMessageDialog(null, "There was an exception thrown during program execution: '" + e + "'  Check the debug logs or contact the author.");
            SPGlobal.closeDebug();
        }
    }

    @Override
    public String getName() {
        return myPatchName;
    }

    @Override
    public GRUP_TYPE[] dangerousRecordReport() {
        return new GRUP_TYPE[0];
    }

    @Override
    public GRUP_TYPE[] importRequests() {
        return this.importRequests;
    }

    @Override
    public boolean importAtStart() {
        return false;
    }

    @Override
    public boolean hasStandardMenu() {
        return true;
    }

    @Override
    public SPMainMenuPanel getStandardMenu() {
        SPMainMenuPanel settingsMenu = new SPMainMenuPanel(this.getHeaderColor());
        settingsMenu.setWelcomePanel(new WelcomePanel(settingsMenu));
        settingsMenu.addMenu(new OtherSettingsPanel(settingsMenu), false, save, YourSaveFile.Settings.OTHER_SETTINGS);
        return settingsMenu;
    }

    @Override
    public boolean hasCustomMenu() {
        return false;
    }

    @Override
    public JFrame openCustomMenu() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean hasLogo() {
        return false;
    }

    @Override
    public URL getLogo() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean hasSave() {
        return true;
    }

    @Override
    public LSaveFile getSave() {
        return save;
    }

    @Override
    public String getVersion() {
        return version;
    }

    @Override
    public ModListing getListing() {
        return new ModListing(this.getName(), false);
    }

    @Override
    public Mod getExportPatch() {
        Mod out = new Mod(this.getListing());
        out.setAuthor(authorName);
        return out;
    }

    @Override
    public Color getHeaderColor() {
        return headerColor;
    }

    @Override
    public boolean needsPatching() {
        return false;
    }

    @Override
    public void onStart() throws Exception {
    }

    @Override
    public void onExit(boolean patchWasGenerated) throws Exception {
    }

    @Override
    public ArrayList<ModListing> requiredMods() {
        return new ArrayList<ModListing>(0);
    }

    @Override
    public String description() {
        return descriptionToShowInSUM;
    }

    @Override
    public void runChangesToPatch() throws Exception {
        Mod patch = SPGlobal.getGlobalPatch();
        Mod merger = new Mod(String.valueOf(this.getName()) + "Merger", (Boolean)false);
        merger.addAsOverrides(SPGlobal.getDB(), new GRUP_TYPE[0]);
        Patch.run(patch, merger);
    }
}

