/*
 * Decompiled with CFR 0.152.
 */
package skyprocstarter;

import java.util.ArrayList;
import skyproc.FormID;
import skyproc.Mod;
import skyproc.WEAP;
import skyprocstarter.Etch;
import skyprocstarter.Forms;
import skyprocstarter.Patch;
import skyprocstarter.Recipe;

public final class EtchWeapon {
    private static final int[][] ADD_DAMAGE;
    private static final int[][] BOW_LIGHT_ADD_DAMAGE;
    private static final int[][] BOW_HEAVY_ADD_DAMAGE;
    private static final int[][] CROSSBOW_LIGHT_ADD_DAMAGE;
    private static final int[][] CROSSBOW_HEAVY_ADD_DAMAGE;

    static {
        int[][] nArrayArray = new int[9][];
        nArrayArray[0] = new int[]{5, 15, 15, 25, -1, 45, 35};
        int[] nArray = new int[7];
        nArray[1] = 5;
        nArray[2] = 5;
        nArray[3] = 10;
        nArray[4] = -1;
        nArray[5] = 30;
        nArray[6] = 20;
        nArrayArray[1] = nArray;
        nArrayArray[2] = new int[]{-2, 2, -1, 7, -1, 20, 10};
        nArrayArray[3] = new int[]{-2, -1, 10, 5, -1, 15, 7};
        nArrayArray[4] = new int[]{-2, -1, -1, 2, -1, 7, 5};
        nArrayArray[5] = new int[]{-2, -1, -1, 2, -1, 10, 7};
        nArrayArray[6] = new int[]{-2, -1, -1, -1, -1, -1, 2};
        nArrayArray[7] = new int[]{-2, -1, -1, -1, -1, -1, -1};
        nArrayArray[8] = new int[]{-2, -1, -1, -1, -1, -1, -1};
        ADD_DAMAGE = nArrayArray;
        BOW_LIGHT_ADD_DAMAGE = new int[][]{{-1, 13, 8, 18, -1, 26, 23}, {-1, 8, 3, 10, -1, 18, 15}, {-1, 3, -1, 8, -1, 12, 10}, {-1, -1, 15, 5, -1, 18, 8}, {-1, -1, -1, 3, -1, 8, 5}, {-1, -1, -1, 2, -1, 14, 3}, {-1, -1, -1, -1, -1, -1, 2}, {-1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1}};
        BOW_HEAVY_ADD_DAMAGE = new int[][]{{-1, 15, 7, 25, -1, 37, 35}, {-1, 5, 3, 10, -1, 30, 20}, {-1, 2, -1, 7, -1, 20, 10}, {-1, -1, 5, 5, -1, 10, 7}, {-1, -1, -1, 3, -1, 7, 5}, {-1, -1, -1, 2, -1, 5, 3}, {-1, -1, -1, -1, -1, -1, 2}, {-1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1}};
        CROSSBOW_LIGHT_ADD_DAMAGE = new int[][]{{-1, 13, 8, 18, -1, 26, 23}, {-1, 8, 3, 10, -1, 18, 15}, {-1, 3, -1, 8, -1, 12, 10}, {-1, -1, 15, 5, -1, 18, 8}, {-1, -1, -1, 3, -1, 8, 5}, {-1, -1, -1, 2, -1, 14, 3}, {-1, -1, -1, -1, -1, -1, 2}, {-1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1}};
        CROSSBOW_HEAVY_ADD_DAMAGE = new int[][]{{-1, 15, 7, 25, -1, 37, 35}, {-1, 5, 3, 10, -1, 30, 20}, {-1, 2, -1, 7, -1, 20, 10}, {-1, -1, 5, 5, -1, 10, 7}, {-1, -1, -1, 3, -1, 7, 5}, {-1, -1, -1, 2, -1, 5, 3}, {-1, -1, -1, -1, -1, -1, 2}, {-1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1}};
    }

    private EtchWeapon() {
        new AssertionError();
    }

    protected static void run(Mod patch, WEAP weapon) {
        int[] damageTable;
        if (Etch.isEnchanted(weapon.getEnchantment(), weapon.getKeywordSet().getKeywordRefs())) {
            return;
        }
        ArrayList<FormID> keywords = weapon.getKeywordSet().getKeywordRefs();
        int upgradeType = Etch.getWeaponMaterial(keywords);
        int bowType = Etch.getBowType(keywords);
        if (upgradeType == -1) {
            return;
        }
        float[] valueTable = Etch.ADD_VALUE[upgradeType];
        switch (bowType) {
            case 0: {
                damageTable = CROSSBOW_HEAVY_ADD_DAMAGE[upgradeType];
                break;
            }
            case 1: {
                damageTable = CROSSBOW_LIGHT_ADD_DAMAGE[upgradeType];
                break;
            }
            case 2: {
                damageTable = BOW_HEAVY_ADD_DAMAGE[upgradeType];
                break;
            }
            case 3: {
                damageTable = BOW_LIGHT_ADD_DAMAGE[upgradeType];
                break;
            }
            default: {
                damageTable = ADD_DAMAGE[upgradeType];
            }
        }
        int i = 0;
        while (i < 7) {
            if (damageTable[i] != -1) {
                WEAP etched = (WEAP)weapon.copy(String.valueOf(weapon.getEDID()) + Etch.ETCH_EDID[i]);
                etched.setName(String.valueOf(etched.getName()) + Etch.ETCH_NAME[i]);
                etched.setDescription(Etch.ETCH_DESC[i]);
                etched.setDamage(etched.getDamage() + damageTable[i]);
                etched.setWeight((int)(etched.getWeight() + Forms.ADD_WEIGHT[i]));
                etched.setValue((int)((float)etched.getValue() * valueTable[i]));
                Etch.replaceWeaponMaterial(etched, upgradeType, i);
                Recipe.makeWeapon(patch, weapon, i, etched);
                patch.addRecord(etched);
                Patch.weapons[i].addEntry(etched.getForm(), 1, 1);
            }
            ++i;
        }
    }
}

