/*
 * Decompiled with CFR 0.152.
 */
package skyproc.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Objects;
import javax.imageio.ImageIO;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import lev.Ln;
import lev.gui.LCheckBox;
import lev.gui.LComboBox;
import lev.gui.LComponent;
import lev.gui.LImagePane;
import lev.gui.LLabel;
import lev.gui.LNumericSetting;
import lev.gui.LSaveFile;
import lev.gui.LScrollPane;
import lev.gui.LTextArea;
import lev.gui.LUserSetting;
import skyproc.GRUP_TYPE;
import skyproc.Mod;
import skyproc.ModListing;
import skyproc.NiftyFunc;
import skyproc.SPGlobal;
import skyproc.SUMMergerProgram;
import skyproc.SkyProcSave;
import skyproc.SkyProcTester;
import skyproc.exceptions.BadRecord;
import skyproc.gui.SPMainMenuPanel;
import skyproc.gui.SPSettingPanel;
import skyproc.gui.SUM;
import skyproc.gui.SUMGUI;

public class SUMprogram
implements SUM {
    String version = "1.3.3";
    ArrayList<String> exclude = new ArrayList(2);
    ArrayList<PatcherLink> links = new ArrayList();
    ArrayList<File> blockedLinks = new ArrayList();
    SPMainMenuPanel mmenu;
    HookMenu hookMenu;
    OptionsMenu optionsMenu;
    LScrollPane hookMenuScroll;
    LSaveFile SUMsave = new SUMsave();
    Color teal = new Color(75, 164, 134);
    Color green = new Color(54, 154, 31);
    Color grey = new Color(230, 230, 230);
    Font settingFont = SUMGUI.SUMmainFont.deriveFont(15.0f);
    int scrollOffset = 100;
    int patcherNumber = 0;
    BufferedImage collapsedSetting;
    BufferedImage openSetting;
    LCheckBox forceAllPatches;

    public static void main(String[] args) throws Exception {
        try {
            if (SUMprogram.handleArgs(args)) {
                SUMprogram sum = new SUMprogram();
                sum.runProgram();
            }
        }
        catch (Exception e) {
            System.err.println(e.toString());
            SPGlobal.logException(e);
            JOptionPane.showMessageDialog(null, "There was an exception thrown during program execution: '" + e + "'  Check the debug logs.");
            SPGlobal.closeDebug();
        }
    }

    static boolean handleArgs(String[] args) {
        ArrayList<String> argsList = new ArrayList<String>();
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            argsList.add(s.toUpperCase());
            ++n2;
        }
        if (argsList.contains("-TESTCOPY")) {
            SPGlobal.forceValidateMode = true;
            SkyProcTester.runTests(3);
            return false;
        }
        if (argsList.contains("-TESTIMPORT")) {
            SPGlobal.forceValidateMode = true;
            SkyProcTester.runTests(2);
            return false;
        }
        if (argsList.contains("-TEST")) {
            SPGlobal.forceValidateMode = true;
            SkyProcTester.runTests(1);
            return false;
        }
        if (argsList.contains("-EMBEDDEDSCRIPTGEN")) {
            SkyProcTester.parseEmbeddedScripts();
            return false;
        }
        if (argsList.contains("-GENPATCH")) {
            SPGlobal.createGlobalLog("SkyProcDebug/Merger/");
            SUMGUI.open(new SUMMergerProgram(), args);
            return false;
        }
        return true;
    }

    void runProgram() throws InstantiationException, IllegalAccessException {
        this.compileExcludes();
        this.openDebug();
        this.SUMsave.init();
        this.getHooks();
        this.openGUI();
        this.initLinkGUIs();
    }

    void compileExcludes() {
        this.exclude.add("SKYPROC UNIFIED MANAGER.JAR");
        this.exclude.add("SKYPROC.JAR");
        try {
            BufferedReader in = new BufferedReader(new FileReader("Files/Block Jars.txt"));
            while (in.ready()) {
                String read = in.readLine();
                if (read.indexOf("//") != -1) {
                    read = read.substring(0, read.indexOf("//"));
                }
                if ((read = read.trim().toUpperCase()).equals("")) continue;
                this.exclude.add(read.toUpperCase());
            }
        }
        catch (IOException ex) {
            SPGlobal.logError("Block Jars", "Failed to locate or read 'Block Jars.txt'");
        }
    }

    void openDebug() {
        SPGlobal.createGlobalLog();
        SPGlobal.debugModMerge = false;
        SPGlobal.debugBSAimport = false;
        SPGlobal.debugNIFimport = false;
        SPGlobal.newSpecialLog(SUMlogs.JarHook, "Jar Hooking.txt");
    }

    void openGUI() {
        this.mmenu = new SPMainMenuPanel();
        this.mmenu.addLogo(this.getLogo());
        this.mmenu.setVersion(this.getVersion(), new Point(13, 15));
        this.hookMenu = new HookMenu(this.mmenu);
        this.mmenu.addMenu(this.hookMenu, this.green, false, this.SUMsave, null);
        this.mmenu.setWelcomePanel(this.hookMenu);
        this.optionsMenu = new OptionsMenu(this.mmenu);
        this.mmenu.addMenu(this.optionsMenu, this.green, false, this.SUMsave, null);
        try {
            this.collapsedSetting = ImageIO.read(SUM.class.getResource("Open Settings Collapsed.png"));
            this.openSetting = ImageIO.read(SUM.class.getResource("Open Settings.png"));
        }
        catch (IOException ex) {
            SPGlobal.logException(ex);
        }
        SUMGUI.open(this, new String[0]);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SUMGUI.patchNeededLabel.setText("");
                SUMGUI.patchNeededLabel.setLocation(-1000, -1000);
                SUMGUI.forcePatch.setLocation(-1000, -1000);
                SUMprogram.this.forceAllPatches = new LCheckBox("Force All Patches", SUMGUI.SUMSmallFont, Color.GRAY);
                SUMprogram.this.forceAllPatches.setLocation(SUMGUI.rightDimensions.x + 10, SUMGUI.cancelPatch.getY() + SUMGUI.cancelPatch.getHeight() / 2 - SUMprogram.this.forceAllPatches.getHeight() / 2);
                SUMprogram.this.forceAllPatches.setOffset(-4);
                SUMprogram.this.forceAllPatches.addMouseListener(new MouseListener(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                    }

                    @Override
                    public void mousePressed(MouseEvent e) {
                    }

                    @Override
                    public void mouseReleased(MouseEvent e) {
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        SUMGUI.helpPanel.setContent("This will force each patcher to create a patch, even if it doesn't think it needs to.  Use this if you want to forcibly remake all patches for any reason.");
                        SUMGUI.helpPanel.setTitle("Force All Patches");
                        SUMGUI.helpPanel.hideArrow();
                        SUMGUI.helpPanel.setDefaultPos();
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                    }
                });
                SUMGUI.singleton.add((Component)SUMprogram.this.forceAllPatches);
            }
        });
    }

    void initLinkGUIs() {
        ArrayList<PatcherLink> linkTmp = new ArrayList<PatcherLink>(this.links);
        PatcherLink last = null;
        int height = 0;
        for (PatcherLink link : linkTmp) {
            try {
                link.setup();
                if (last != null) {
                    link.setLocation(link.getX(), last.getY() + last.getHeight() + 15);
                }
                last = link;
                this.hookMenu.hookMenu.add((Component)((Object)link));
                height = link.getY() + link.getHeight();
                this.hookMenu.revalidate();
            }
            catch (Exception ex) {
                SPGlobal.logException(ex);
                this.links.remove((Object)link);
            }
        }
        if (this.blockedLinks.size() > 0) {
            LTextArea blockedLinksArea = new LTextArea(this.grey);
            blockedLinksArea.setSize(SUMGUI.middleDimensions.width - 50, 200);
            blockedLinksArea.setLocation(25, height + 20);
            height = blockedLinksArea.getY() + blockedLinksArea.getHeight();
            String text = "Blocked Patchers:\n";
            for (File jar : this.blockedLinks) {
                text = String.valueOf(text) + "            " + jar.getName() + "\n";
            }
            blockedLinksArea.setText(text);
            this.hookMenu.hookMenu.add((Component)blockedLinksArea);
        }
        this.hookMenu.hookMenu.setPreferredSize(new Dimension(SUMGUI.middleDimensions.width, height + 25));
    }

    void getHooks() {
        ArrayList<File> jars = this.findJars(new File("../"));
        block7: for (File jar : jars) {
            try {
                SPGlobal.logSpecial(SUMlogs.JarHook, "Jar Load", "Loading jar " + jar);
                ArrayList classes = Ln.loadClasses((File)jar, (boolean)true);
                for (Class c : classes) {
                    if (c.toString().contains("lev.") || c.toString().contains("skyproc.")) continue;
                    try {
                        Object tester = c.newInstance();
                        if (!(tester instanceof SUM)) continue;
                        SPGlobal.logSpecial(SUMlogs.JarHook, "Jar Load", "   Added jar " + jar);
                        PatcherLink newLink = new PatcherLink((SUM)c.newInstance(), jar);
                        if (this.links.contains((Object)newLink)) continue block7;
                        this.links.add(newLink);
                        continue block7;
                    }
                    catch (Throwable ex) {
                        SPGlobal.logSpecial(SUMlogs.JarHook, "Loading class", "   Skipped " + c + ": " + ex.getMessage());
                    }
                }
            }
            catch (Throwable ex) {
                SPGlobal.logSpecial(SUMlogs.JarHook, "Loading jar", "   Skipped jar " + jar + ": " + ex.getMessage());
            }
        }
        ArrayList<PatcherLink> tmpLinks = new ArrayList<PatcherLink>(this.links);
        for (PatcherLink link : tmpLinks) {
            try {
                link.hook.description();
            }
            catch (AbstractMethodError ex) {
                this.links.remove((Object)link);
                this.blockedLinks.add(link.path);
                SPGlobal.logSpecial(SUMlogs.JarHook, "Checking Links", "Removing link " + link.getName() + " because it was an older version of SUM.");
            }
            catch (UnsupportedOperationException ex) {
                this.links.remove((Object)link);
                this.blockedLinks.add(link.path);
                SPGlobal.logSpecial(SUMlogs.JarHook, "Checking Links", "Removing link " + link.getName() + " because it didn't fully implement SUM (Threw a UnsupportedOperationException).");
            }
        }
        this.sortLinks(this.links);
    }

    ArrayList<File> findJars(File dir) {
        ArrayList files = Ln.generateFileList((File)dir, (boolean)false);
        ArrayList<File> out = new ArrayList<File>();
        for (File f : files) {
            if (!f.getName().toUpperCase().endsWith(".JAR") || this.exclude.contains(f.getName().toUpperCase())) continue;
            out.add(f);
        }
        return out;
    }

    @Override
    public ModListing getListing() {
        return new ModListing("SUM", false);
    }

    @Override
    public boolean needsPatching() {
        return true;
    }

    @Override
    public ArrayList<ModListing> requiredMods() {
        return new ArrayList<ModListing>(0);
    }

    @Override
    public String description() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getName() {
        return "SkyProc Unified Manager";
    }

    @Override
    public GRUP_TYPE[] dangerousRecordReport() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public GRUP_TYPE[] importRequests() {
        return new GRUP_TYPE[0];
    }

    @Override
    public boolean importAtStart() {
        return false;
    }

    @Override
    public boolean hasStandardMenu() {
        return true;
    }

    @Override
    public SPMainMenuPanel getStandardMenu() {
        return this.mmenu;
    }

    @Override
    public boolean hasCustomMenu() {
        return false;
    }

    @Override
    public JFrame openCustomMenu() {
        return null;
    }

    @Override
    public boolean hasLogo() {
        return true;
    }

    @Override
    public URL getLogo() {
        return SUMprogram.class.getResource("SUM program.png");
    }

    @Override
    public boolean hasSave() {
        return true;
    }

    @Override
    public LSaveFile getSave() {
        return this.SUMsave;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public Mod getExportPatch() {
        Mod patch = new Mod(this.getListing());
        patch.setFlag(Mod.Mod_Flags.STRING_TABLED, false);
        patch.setAuthor("Leviathan1753 and friends");
        return patch;
    }

    @Override
    public Color getHeaderColor() {
        return this.teal;
    }

    @Override
    public void onExit(boolean patchWasGenerated) {
        ArrayList<String> disabledLinks = new ArrayList<String>();
        for (PatcherLink link : this.links) {
            if (link.isActive()) continue;
            disabledLinks.add(link.getName().toUpperCase());
        }
        this.SUMsave.setStrings((Enum)SUMSettings.DISABLED, disabledLinks);
        File blocklist = new File("Files\\Blocklist.txt");
        if (blocklist.isFile()) {
            blocklist.delete();
        }
    }

    @Override
    public void onStart() {
        SUMGUI.boss = false;
    }

    @Override
    public void runChangesToPatch() throws Exception {
        if (this.SUMsave.getBool((Enum)SUMSettings.MERGE_PATCH).booleanValue() && !this.SUMsave.getBool((Enum)SUMSettings.RUN_BOSS).booleanValue() && !this.SUMsave.getBool((Enum)SUMSettings.RUN_LOOT).booleanValue()) {
            throw new Exception("\n\nMerging requires running either BOSS or LOOT");
        }
        ArrayList<PatcherLink> activeLinks = this.getActiveLinks();
        this.setupProgress(activeLinks);
        this.checkMemAllocation();
        this.setupLinksForBOSS(activeLinks);
        this.runBOSS();
        this.sortLinks(activeLinks);
        this.runEachPatcher(activeLinks);
        this.mergePatches(activeLinks);
        SUMGUI.progress.done();
        SUMGUI.exitProgram(true, true);
    }

    void checkMemAllocation() {
        File f = new File("Files/MemTester.jar");
        if (f.exists()) {
            ArrayList<String> args = new ArrayList<String>();
            args.add("java");
            args.add("-jar");
            args.add("-Xms200m");
            args.add("-Xmx" + this.SUMsave.getInt((Enum)SUMSettings.MAX_MEM) + "m");
            args.add(f.getPath());
            boolean pass = NiftyFunc.startProcess(null, args.toArray(new String[0]));
            if (!pass) {
                JOptionPane.showMessageDialog(null, "Could not allocate " + this.SUMsave.getInt((Enum)SUMSettings.MAX_MEM) + " megabytes from the OS.  Lower the amount and try again.");
                SPGlobal.logMain("Run Changes", "Mem allocation test failed.");
                SUMGUI.exitProgram(false, true);
            }
        }
    }

    void setupProgress(ArrayList<PatcherLink> activeLinks) {
        SUMGUI.progress.setBar(0);
        int progressMax = activeLinks.size();
        if (this.SUMsave.getBool((Enum)SUMSettings.RUN_BOSS).booleanValue()) {
            ++progressMax;
        }
        if (this.SUMsave.getBool((Enum)SUMSettings.RUN_LOOT).booleanValue()) {
            ++progressMax;
        }
        if (this.SUMsave.getBool((Enum)SUMSettings.MERGE_PATCH).booleanValue()) {
            ++progressMax;
        }
        SUMGUI.progress.setMax(progressMax);
    }

    ArrayList<PatcherLink> getActiveLinks() {
        ArrayList<PatcherLink> activeLinks = new ArrayList<PatcherLink>();
        for (PatcherLink l : this.links) {
            if (!l.isActive()) continue;
            activeLinks.add(l);
        }
        return activeLinks;
    }

    void setupLinksForBOSS(ArrayList<PatcherLink> activeLinks) throws IOException, BadRecord {
        ArrayList<Mod> active = new ArrayList<Mod>();
        for (PatcherLink link : activeLinks) {
            active.add(link.hook.getExportPatch());
        }
        NiftyFunc.setupMissingPatchFiles(active);
        ArrayList<Mod> inactive = new ArrayList<Mod>();
        for (PatcherLink link : this.links) {
            if (activeLinks.contains((Object)link)) continue;
            inactive.add(link.hook.getExportPatch());
        }
        if (this.SUMsave.getBool((Enum)SUMSettings.MERGE_PATCH).booleanValue()) {
            active.add(this.getExportPatch());
        } else {
            inactive.add(this.getExportPatch());
        }
        NiftyFunc.modifyPluginsTxt(active, inactive);
    }

    void runBOSS() {
        if (this.SUMsave.getBool((Enum)SUMSettings.RUN_BOSS).booleanValue()) {
            SUMGUI.bossWarning();
            NiftyFunc.runBOSS(true);
            SUMGUI.progress.incrementBar();
        }
        if (this.SUMsave.getBool((Enum)SUMSettings.RUN_LOOT).booleanValue()) {
            SUMGUI.lootWarning();
            NiftyFunc.runLOOT(true);
            SUMGUI.progress.incrementBar();
        }
    }

    void sortLinks(ArrayList<PatcherLink> links) {
        try {
            String listPath;
            ArrayList<PatcherLink> sorted = new ArrayList<PatcherLink>(links.size());
            ArrayList<PatcherLink> unsorted = new ArrayList<PatcherLink>(links);
            try {
                listPath = SPGlobal.getLoadOrderTxt();
            }
            catch (IOException ex) {
                listPath = SPGlobal.getPluginsTxt();
            }
            ArrayList pluginList = Ln.loadFileToStrings((String)listPath, (boolean)false);
            block4: for (String plugin : pluginList) {
                for (PatcherLink link : unsorted) {
                    if (!link.getPatchName().equalsIgnoreCase(plugin.trim()) || sorted.contains((Object)link)) continue;
                    sorted.add(link);
                    unsorted.remove((Object)link);
                    continue block4;
                }
            }
            links.clear();
            links.addAll(sorted);
            links.addAll(unsorted);
        }
        catch (IOException ex) {
            SPGlobal.logException(ex);
        }
    }

    void runEachPatcher(ArrayList<PatcherLink> activeLinks) {
        SUMGUI.progress.setStatus("Running Patchers");
        int i = 0;
        while (i < activeLinks.size()) {
            PatcherLink link = activeLinks.get(i);
            SUMGUI.progress.setStatusNumbered("Running " + link.getName());
            SPGlobal.logMain("Run Changes", "Running jar: " + link.path);
            if (!link.isActive()) {
                SPGlobal.logMain("Run Changes", "Skipped jar because it was not selected: " + link.path);
            } else if (this.runJarPatcher(link)) {
                SPGlobal.logMain("Run Changes", "Successfully ran jar: " + link.path);
            } else {
                int response = JOptionPane.showConfirmDialog(null, "Failed to properly run " + link.getName() + ".  Continue patching?", "Error", 0);
                if (response == 1) {
                    SUMGUI.exitProgram(false, true);
                }
                SPGlobal.logMain("Run Changes", "UNsuccessfully ran jar: " + link.path);
            }
            ++i;
        }
    }

    boolean runJarPatcher(PatcherLink link) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("java");
        args.add("-jar");
        args.add("-Xms200m");
        args.add("-Xmx" + this.SUMsave.getInt((Enum)SUMSettings.MAX_MEM) + "m");
        args.add(link.path.getPath());
        args.add("-GENPATCH");
        args.add("-NONEW");
        args.add("-NOMODSAFTER");
        args.add("-LANGUAGE");
        args.add("" + (Object)((Object)SPGlobal.Language.values()[this.SUMsave.getInt((Enum)SUMSettings.LANGUAGE)]));
        if (this.forceAllPatches.isSelected().booleanValue() || this.SUMsave.getBool((Enum)SUMSettings.MERGE_PATCH).booleanValue()) {
            args.add("-FORCE");
        }
        args.add("-PROGRESSLOCATION");
        args.add("" + (SUMGUI.progress.getX() + SUMGUI.progress.getWidth() + 10));
        args.add("" + SUMGUI.progress.getY());
        args.add("-SUMBLOCK");
        args.add("-NOBOSS");
        if (this.SUMsave.getBool((Enum)SUMSettings.ALL_AS_MASTERS).booleanValue()) {
            args.add("-ALLMODSASMASTERS");
        }
        boolean ret = NiftyFunc.startProcess(new File(String.valueOf(link.path.getParentFile().getPath()) + "\\"), args.toArray(new String[0]));
        SUMGUI.progress.incrementBar();
        return ret;
    }

    void mergePatches(ArrayList<PatcherLink> links) throws IOException {
        if (this.SUMsave.getBool((Enum)SUMSettings.MERGE_PATCH).booleanValue()) {
            SUMGUI.progress.setStatusNumbered("Merging Patches");
            String path = SUMprogram.getSUMPatchList();
            Throwable throwable = null;
            Object var4_5 = null;
            try (BufferedWriter out = new BufferedWriter(new FileWriter(path));){
                for (PatcherLink link : links) {
                    out.write(String.valueOf(link.getPatchName()) + "\n");
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            File SUM2 = new File("SUM.jar").getAbsoluteFile();
            PatcherLink mergerLink = new PatcherLink(null, SUM2);
            this.runJarPatcher(mergerLink);
            SUMGUI.progress.incrementBar();
        }
    }

    public static String getSUMPatchList() throws IOException {
        return SPGlobal.getSkyProcDocuments() + "\\SUM patch list.txt";
    }

    class HookMenu
    extends SPSettingPanel {
        JPanel hookMenu;

        HookMenu(SPMainMenuPanel parent_) {
            super(parent_, "Patcher List", SUMprogram.this.grey);
            this.initialize();
        }

        @Override
        protected final void initialize() {
            super.initialize();
            this.hookMenu = new JPanel();
            this.hookMenu.setOpaque(false);
            this.hookMenu.setLayout(null);
            SUMprogram.this.hookMenuScroll = new LScrollPane((Component)this.hookMenu);
            SUMprogram.this.hookMenuScroll.setSize(SUMGUI.middleDimensions.width, SUMGUI.middleDimensions.height - SUMprogram.this.scrollOffset);
            SUMprogram.this.hookMenuScroll.setHorizontalScrollBarPolicy(31);
            SUMprogram.this.hookMenuScroll.setLocation(0, SUMprogram.this.scrollOffset);
            SUMprogram.this.hookMenuScroll.getVerticalScrollBar().setUnitIncrement(20);
            this.Add((Component)SUMprogram.this.hookMenuScroll);
        }
    }

    class OptionsMenu
    extends SPSettingPanel {
        LCheckBox runBoss;
        LCheckBox runLoot;
        LCheckBox AllModsAsMasters;
        LCheckBox mergePatches;
        LNumericSetting maxMem;
        LLabel langLabel;
        LComboBox language;

        OptionsMenu(SPMainMenuPanel parent_) {
            super(parent_, "SUM Options", SUMprogram.this.grey);
        }

        @Override
        protected final void initialize() {
            super.initialize();
            this.mergePatches = new LCheckBox("Merge Patches", SUMprogram.this.settingFont, SUMGUI.light);
            this.mergePatches.setOffset(-3);
            this.mergePatches.addShadow();
            this.mergePatches.tie((Enum)SUMSettings.MERGE_PATCH, SUMprogram.this.SUMsave, SUMGUI.helpPanel, true);
            this.setPlacement((Component)this.mergePatches);
            this.AddSetting((LUserSetting)this.mergePatches);
            this.runBoss = new LCheckBox("Run BOSS", SUMprogram.this.settingFont, SUMGUI.light);
            this.runBoss.setOffset(-3);
            this.runBoss.addShadow();
            this.runBoss.tie((Enum)SUMSettings.RUN_BOSS, SUMprogram.this.SUMsave, SUMGUI.helpPanel, true);
            this.setPlacement((Component)this.runBoss);
            this.AddSetting((LUserSetting)this.runBoss);
            this.runLoot = new LCheckBox("Run LOOT", SUMprogram.this.settingFont, SUMGUI.light);
            this.runLoot.setOffset(-3);
            this.runLoot.addShadow();
            this.runLoot.tie((Enum)SUMSettings.RUN_LOOT, SUMprogram.this.SUMsave, SUMGUI.helpPanel, true);
            this.setPlacement((Component)this.runLoot);
            this.AddSetting((LUserSetting)this.runLoot);
            this.AllModsAsMasters = new LCheckBox("All Mods As Masters For Patches", SUMprogram.this.settingFont, SUMGUI.light);
            this.AllModsAsMasters.setOffset(-3);
            this.AllModsAsMasters.addShadow();
            this.AllModsAsMasters.tie((Enum)SUMSettings.ALL_AS_MASTERS, SUMprogram.this.SUMsave, SUMGUI.helpPanel, true);
            this.setPlacement((Component)this.AllModsAsMasters);
            this.AddSetting((LUserSetting)this.AllModsAsMasters);
            this.maxMem = new LNumericSetting("Max Allocated Memory", SUMprogram.this.settingFont, SUMGUI.light, 250, Integer.valueOf(2000), 250);
            this.maxMem.tie((Enum)SUMSettings.MAX_MEM, SUMprogram.this.SUMsave, SUMGUI.helpPanel, true);
            this.setPlacement((Component)this.maxMem);
            this.AddSetting((LUserSetting)this.maxMem);
            this.langLabel = new LLabel("Language", SUMprogram.this.settingFont, SUMGUI.light);
            this.language = new LComboBox("Language");
            this.language.setSize(150, 25);
            SPGlobal.Language[] languageArray = SPGlobal.Language.values();
            int n = languageArray.length;
            int n2 = 0;
            while (n2 < n) {
                SPGlobal.Language e = languageArray[n2];
                this.language.addItem((Object)e);
                ++n2;
            }
            this.language.tie((Enum)SUMSettings.LANGUAGE, SUMprogram.this.SUMsave, SUMGUI.helpPanel, true);
            this.setPlacement((Component)this.language, this.last.x + this.langLabel.getWidth() + 15, this.last.y);
            this.AddSetting((LUserSetting)this.language);
            this.langLabel.setLocation(this.language.getX() - this.langLabel.getWidth() - 15, this.language.getY() + this.language.getHeight() / 2 - this.langLabel.getHeight() / 2);
            this.langLabel.addShadow();
            this.settingsPanel.add((Component)this.langLabel);
            this.alignRight();
        }
    }

    class PatcherLink
    extends LComponent {
        LImagePane logo;
        LLabel title;
        JCheckBox cbox;
        SUM hook;
        File path;
        JPanel menu;
        LImagePane setting;

        PatcherLink(SUM hook, File path) {
            this.hook = hook;
            this.path = path;
        }

        final void setup() {
            this.setupGUI();
        }

        final void setupGUI() {
            Component using = null;
            this.cbox = new JCheckBox();
            this.cbox.setSize(this.cbox.getPreferredSize());
            this.cbox.setOpaque(false);
            this.cbox.setVisible(true);
            this.cbox.setSelected(!SUMprogram.this.SUMsave.getStrings((Enum)SUMSettings.DISABLED).contains(this.getName().toUpperCase()));
            int desiredMargin = 15;
            int desiredWidth = SUMGUI.middleDimensions.width - desiredMargin * 2;
            int width = this.cbox.getWidth() + 10;
            if (this.hook.hasLogo()) {
                try {
                    this.logo = new LImagePane(this.hook.getLogo());
                    if (this.logo.getWidth() + width > desiredWidth) {
                        this.logo.setMaxSize(desiredWidth - width, 0);
                    }
                    using = this.logo;
                    this.add((Component)this.logo);
                }
                catch (IOException ex) {
                    SPGlobal.logException(ex);
                    this.logo = null;
                }
            }
            if (this.logo == null) {
                this.title = new LLabel(this.hook.getName(), SUMGUI.SUMmainFont.deriveFont(25.0f), this.hook.getHeaderColor());
                this.title.addShadow();
                using = this.title;
                this.add((Component)this.title);
            }
            width += using.getWidth();
            using.addMouseListener(new LinkClick());
            this.cbox.setLocation(desiredMargin, using.getHeight() / 2 - this.cbox.getHeight() / 2);
            this.add(this.cbox);
            using.setLocation(this.cbox.getX() + this.cbox.getWidth() + 10, 0);
            this.setting = new LImagePane(SUMprogram.this.collapsedSetting);
            this.setting.setLocation(SUMGUI.middleDimensions.width - 10 - this.setting.getWidth(), using.getHeight() / 2 - this.setting.getHeight() / 2);
            this.setting.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    ArrayList<String> args = new ArrayList<String>();
                    args.add("java");
                    args.add("-jar");
                    args.add("-Xms500m");
                    args.add("-Xmx1000m");
                    args.add(PatcherLink.this.path.getPath());
                    args.add("-NONEW");
                    args.add("-JUSTSETTINGS");
                    NiftyFunc.startProcess(new File(String.valueOf(PatcherLink.this.path.getParentFile().getPath()) + "\\"), args.toArray(new String[0]));
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    PatcherLink.this.setting.setImage(((PatcherLink)PatcherLink.this).SUMprogram.this.openSetting);
                    PatcherLink.this.setting.setLocation(SUMGUI.middleDimensions.width - 10 - PatcherLink.this.setting.getWidth(), PatcherLink.this.setting.getY());
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    PatcherLink.this.setting.setImage(((PatcherLink)PatcherLink.this).SUMprogram.this.collapsedSetting);
                    PatcherLink.this.setting.setLocation(SUMGUI.middleDimensions.width - 10 - PatcherLink.this.setting.getWidth(), PatcherLink.this.setting.getY());
                }
            });
            this.add((Component)this.setting, 0);
            if (this.setting.getY() < 0) {
                this.setting.setLocation(this.setting.getX(), 0);
                using.setLocation(using.getX(), this.setting.getHeight() / 2 - using.getHeight() / 2);
                using = this.setting;
            }
            this.cbox.setLocation(desiredMargin, using.getHeight() / 2 - this.cbox.getHeight() / 2);
            this.setSize(SUMGUI.middleDimensions.width, using.getHeight());
            MouseListener updateHelp = new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    SUMGUI.helpPanel.setContent(PatcherLink.this.hook.description());
                    SUMGUI.helpPanel.setTitle(PatcherLink.this.hook.getName());
                    SUMGUI.helpPanel.hideArrow();
                    SUMGUI.helpPanel.setDefaultPos();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }
            };
            this.addMouseListener(updateHelp);
            using.addMouseListener(updateHelp);
        }

        boolean isActive() {
            return this.cbox.isSelected();
        }

        public String getName() {
            return this.hook.getName();
        }

        public String getPatchName() {
            return this.hook.getListing().toString();
        }

        public int hashCode() {
            int hash = 7;
            hash = 83 * hash + Objects.hashCode(this.hook);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            PatcherLink other = (PatcherLink)((Object)obj);
            return this.hook.getName().equalsIgnoreCase(other.hook.getName());
        }

        class LinkClick
        implements MouseListener {
            LinkClick() {
            }

            @Override
            public void mouseClicked(MouseEvent arg0) {
                PatcherLink.this.cbox.setSelected(!PatcherLink.this.cbox.isSelected());
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }
        }
    }

    static enum SUMSettings {
        MAX_MEM,
        MERGE_PATCH,
        DISABLED,
        RUN_BOSS,
        RUN_LOOT,
        ALL_AS_MASTERS,
        LANGUAGE;

    }

    static enum SUMlogs {
        JarHook;

    }

    class SUMsave
    extends SkyProcSave {
        SUMsave() {
        }

        protected void initSettings() {
            this.Add(SUMSettings.MERGE_PATCH, false, new Boolean[]{true});
            this.Add(SUMSettings.DISABLED, new ArrayList(0), new Boolean[]{true});
            this.Add(SUMSettings.RUN_BOSS, false, new Boolean[]{false});
            this.Add(SUMSettings.RUN_LOOT, true, new Boolean[]{false});
            this.Add(SUMSettings.ALL_AS_MASTERS, false, new Boolean[]{false});
            this.Add(SUMSettings.MAX_MEM, 750, new Boolean[]{false});
            this.Add(SUMSettings.LANGUAGE, 0, new Boolean[]{true});
        }

        protected void initHelp() {
            this.helpInfo.put(SUMSettings.MERGE_PATCH, "This will merge all of your SkyProc patches into one patch.  This helps if you're hitting the max number of mods.\n\nMergeing REQUIRES either BOSS or LOOT to be run by SUM since it adds and removes plugins from your load order.\n\nWARNING:  This is an experimental setting.  In addition, existing savegames may break when switching this setting on/off, as all the references the savegame uses to the patches will be broken.  It is recommended you start new savegames when changing this setting.");
            this.helpInfo.put(SUMSettings.RUN_BOSS, "SUM will run BOSS before running the patchers to confirm that they are all in the correct load order.  BOSS has been replaced by LOOT by most users.\n\nNOTE:  Be aware that BOSS reserves the right to change load ordering as it sees fit.  If it adjusts its load order and shuffles SkyProc patchers around to be in a different order, your savegame may or may not function with the new ordering.  This is most likely to occur if the SkyProc patcher is brand new, and hasn't been processed yet by BOSS.\n\nSUM does not update BOSS before running it.");
            this.helpInfo.put(SUMSettings.RUN_LOOT, "SUM will run LOOT before running the patchers to confirm that they are all in the correct load order.  It is highly recommended you leave this setting on.\n\nNOTE:  Be aware that LOOT reserves the right to change load ordering as it sees fit.  If it adjusts its load order and shuffles SkyProc patchers around to be in a different order, your savegame may or may not function with the new ordering.  This is most likely to occur if the SkyProc patcher is brand new, and hasn't been processed yet by LOOT.\n\n");
            this.helpInfo.put(SUMSettings.ALL_AS_MASTERS, "This will attempt to use all active plugins as the masters for generated patches.\n\nThis can significantly reduce patching time on large load orders.\n\nThis is still an experimental setting.");
            this.helpInfo.put(SUMSettings.MAX_MEM, "This will determine the max amount of megabytes of memory patchers will be allowed to use.\n\nIf a patcher runs out of memory the program will essentially halt as it tries to scrap by with too little memory. If you experience this, then try allocating more memory.\n\nWindows has the final say in how much memory it will allow the programs.  If your request is denied you'll see an error.  Just lower your memory request and try again.");
            this.helpInfo.put(SUMSettings.LANGUAGE, "You can set your preferred language here.  This will make the patchers import strings files of that language first.");
        }
    }
}

