/*
 * Decompiled with CFR 0.152.
 */
package skyproc.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import lev.Ln;
import lev.debug.LDebug;
import lev.gui.LButton;
import lev.gui.LCheckBox;
import lev.gui.LHelpPanel;
import lev.gui.LImagePane;
import lev.gui.LLabel;
import lev.gui.LProgressBarInterface;
import lev.gui.LSaveFile;
import lev.gui.Lg;
import lev.gui.resources.LFonts;
import lev.gui.resources.LImages;
import skyproc.GRUP_TYPE;
import skyproc.Mod;
import skyproc.ModListing;
import skyproc.NiftyFunc;
import skyproc.SPDatabase;
import skyproc.SPGlobal;
import skyproc.SPImporter;
import skyproc.exceptions.MissingMaster;
import skyproc.gui.SPDefaultGUI;
import skyproc.gui.SPMainMenuPanel;
import skyproc.gui.SPProgressBarFrame;
import skyproc.gui.SPProgressBarPlug;
import skyproc.gui.SUM;
import skyproc.gui.SUMprogram;

public class SUMGUI
extends JFrame {
    static JFrame singleton = null;
    public static final Rectangle fullDimensions = new Rectangle(0, 0, 950, 632);
    public static final Rectangle leftDimensions = new Rectangle(0, 0, 299, SUMGUI.fullDimensions.height - 28);
    public static final Rectangle middleDimensions = new Rectangle(SUMGUI.leftDimensions.x + SUMGUI.leftDimensions.width + 7, 0, 330, SUMGUI.fullDimensions.height);
    public static final Rectangle rightDimensions = new Rectangle(SUMGUI.middleDimensions.x + SUMGUI.middleDimensions.width + 7, 0, 305, SUMGUI.fullDimensions.height);
    public static final Rectangle middleRightDimensions = new Rectangle(SUMGUI.middleDimensions.x, 0, SUMGUI.rightDimensions.x + SUMGUI.rightDimensions.width, SUMGUI.fullDimensions.height);
    public static final Rectangle middleLeftDimensions = new Rectangle(0, 0, SUMGUI.middleDimensions.x + SUMGUI.middleDimensions.width, SUMGUI.middleDimensions.height);
    static final Color light = new Color(238, 233, 204);
    static final Color lightGray = new Color(190, 190, 190);
    static final Color darkGray = new Color(110, 110, 110);
    static final Color lightred = Color.red;
    static SUM hook;
    static final String header = "SUM";
    public static Thread parser;
    static ProcessingThread parserRunnable;
    static boolean imported;
    static boolean exitRequested;
    public static SPProgressBarFrame progress;
    public static LHelpPanel helpPanel;
    static LImagePane backgroundPanel;
    static LLabel patchNeededLabel;
    static boolean needsPatching;
    static boolean justPatching;
    static boolean justSettings;
    static boolean boss;
    static LCheckBox forcePatch;
    static LImagePane skyProcLogo;
    static JTextArea statusUpdate;
    static LLabel versionNum;
    static LButton cancelPatch;
    static LButton startPatch;
    static SUMGUISave save;
    static Font SUMmainFont;
    static Font SUMSmallFont;
    static String errorMessage;
    private static boolean patchrequested;

    static {
        imported = false;
        exitRequested = false;
        progress = new SPProgressBarFrame(new Font("SansSerif", 0, 12), Color.lightGray, new Font("SansSerif", 0, 10), Color.lightGray);
        helpPanel = new LHelpPanel(rightDimensions, new Font("Serif", 1, 25), light, lightGray, (Image)LImages.arrow((boolean)true, (boolean)false), 10);
        needsPatching = false;
        justPatching = false;
        justSettings = false;
        boss = true;
        save = new SUMGUISave();
        SUMmainFont = LFonts.MyriadProBold((float)30.0f);
        SUMSmallFont = new Font("SansSerif", 0, 10);
        errorMessage = "Please contact the author.";
        patchrequested = false;
    }

    SUMGUI() {
        super(hook.getName());
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        Dimension GUISIZE = new Dimension(954, 658);
        this.setSize(GUISIZE);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - GUISIZE.width / 2, dim.height / 2 - GUISIZE.height / 2);
        this.setLayout(null);
        this.addComponents();
        helpPanel.setHeaderFont(SUMmainFont.deriveFont(0, 25.0f));
        helpPanel.setXOffsets(23, 35);
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowClosed(WindowEvent arg0) {
            }

            @Override
            public void windowActivated(WindowEvent arg0) {
            }

            @Override
            public void windowClosing(WindowEvent arg0) {
                SUMGUI.closingGUIwindow();
            }

            @Override
            public void windowDeactivated(WindowEvent arg0) {
            }

            @Override
            public void windowDeiconified(WindowEvent arg0) {
            }

            @Override
            public void windowIconified(WindowEvent arg0) {
            }

            @Override
            public void windowOpened(WindowEvent arg0) {
            }
        });
        helpPanel.setHeaderColor(hook.getHeaderColor());
        helpPanel.setDefaultY(75);
    }

    public void closeWindow() {
        WindowEvent wev = new WindowEvent(this, 201);
        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(wev);
    }

    final void addComponents() {
        try {
            backgroundPanel = new LImagePane(SUMGUI.class.getResource("background.jpg"));
            super.add((Component)backgroundPanel);
            startPatch = new LButton("Patch");
            startPatch.setLocation(backgroundPanel.getWidth() - startPatch.getWidth() - 5, 5);
            startPatch.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (SPGlobal.logging()) {
                        SPGlobal.logMain(SUMGUI.header, "Starting patch because user pressed patch.");
                    }
                    patchrequested = true;
                    SUMGUI.this.closeWindow();
                }
            });
            startPatch.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    helpPanel.setDefaultPos();
                    helpPanel.setContent("This will create a patch if necessary and then exit the program.");
                    helpPanel.setTitle("Start Patch and Exit");
                    helpPanel.hideArrow();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }
            });
            backgroundPanel.add((Component)startPatch);
            cancelPatch = new LButton("Cancel");
            cancelPatch.setLocation(startPatch.getX() - cancelPatch.getWidth() - 5, 5);
            cancelPatch.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    helpPanel.setContent("This will save your current program settings and exit the program immediately without generating a patch.\n\nAfter doing so, it is recommended that you start this patcher again and patch correctly before playing the game again.\n\nNOTE: Clicking exit on the progress bar while patching has the same effect.");
                    helpPanel.setTitle("Cancel and Exit");
                    helpPanel.hideArrow();
                    helpPanel.setDefaultPos();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }
            });
            cancelPatch.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (SPGlobal.logging()) {
                        SPGlobal.logMain(SUMGUI.header, "Closing program early because user cancelled.");
                    }
                    SUMGUI.exitProgram(false, true);
                }
            });
            backgroundPanel.add((Component)cancelPatch);
            forcePatch = new LCheckBox("Force Patch on Exit", SUMSmallFont, Color.GRAY);
            forcePatch.setLocation(SUMGUI.rightDimensions.x + 10, cancelPatch.getY() + cancelPatch.getHeight() / 2 - forcePatch.getHeight() / 2);
            forcePatch.setOffset(-4);
            forcePatch.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    helpPanel.setContent("This will force the patcher to create a patch, even if it doesn't think it needs to.  Use this if you want to forcibly remake the patch for any reason.");
                    helpPanel.setTitle("Force Patch On Exit");
                    helpPanel.hideArrow();
                    helpPanel.setDefaultPos();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }
            });
            backgroundPanel.add((Component)forcePatch);
            patchNeededLabel = new LLabel("A patch will be generated upon exit.", SUMSmallFont, Color.GRAY);
            patchNeededLabel.setLocation(forcePatch.getLocation());
            patchNeededLabel.setVisible(false);
            backgroundPanel.add((Component)patchNeededLabel);
            progress.addWindowListener(new WindowListener(){

                @Override
                public void windowClosed(WindowEvent arg0) {
                }

                @Override
                public void windowActivated(WindowEvent arg0) {
                }

                @Override
                public void windowClosing(WindowEvent arg0) {
                    if (progress.getDefaultCloseOperation() == 2) {
                        if (SPGlobal.logging()) {
                            SPGlobal.logMain(SUMGUI.header, "Closing program early because progress bar was forced to close by user.");
                        }
                        SUMGUI.exitProgram(false, true);
                    }
                }

                @Override
                public void windowDeactivated(WindowEvent arg0) {
                }

                @Override
                public void windowDeiconified(WindowEvent arg0) {
                }

                @Override
                public void windowIconified(WindowEvent arg0) {
                }

                @Override
                public void windowOpened(WindowEvent arg0) {
                }
            });
            if (hook.hasLogo()) {
                progress.addLogo(hook.getLogo());
            }
            statusUpdate = new JTextArea();
            statusUpdate.setSize(250, 18);
            statusUpdate.setLocation(5, this.getFrameHeight() - statusUpdate.getHeight());
            statusUpdate.setForeground(Color.LIGHT_GRAY);
            statusUpdate.setOpaque(false);
            statusUpdate.setText("Started application");
            statusUpdate.setEditable(false);
            statusUpdate.setVisible(true);
            backgroundPanel.add((Component)statusUpdate);
            skyProcLogo = new LImagePane(SPDefaultGUI.class.getResource("SkyProc Logo Small.png"));
            skyProcLogo.setLocation(5, statusUpdate.getY() - skyProcLogo.getHeight() - 5);
            backgroundPanel.add((Component)skyProcLogo);
            helpPanel.setBounds(rightDimensions);
            backgroundPanel.add((Component)helpPanel);
            SPProgressBarPlug.addProgressBar(new SUMProgress());
            if (!justPatching) {
                this.setVisible(true);
            }
        }
        catch (IOException ex) {
            SPGlobal.logException(ex);
        }
    }

    public static void open(final SUM hook, String[] mainArgs) {
        SUMGUI.handleArgs(mainArgs);
        SUMGUI.loadBlockedMods("Files/BlockList.txt");
        SUMGUI.clean();
        SUMGUI.hook = hook;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (singleton == null) {
                    try {
                        if (hook.hasSave()) {
                            hook.getSave().init();
                        }
                        save.init();
                        SUMGUI.logStatus();
                        SPGlobal.setGlobalPatch(hook.getExportPatch());
                        try {
                            hook.onStart();
                        }
                        catch (Exception ex) {
                            SPGlobal.logException(ex);
                        }
                        singleton = hook.hasCustomMenu() ? hook.openCustomMenu() : new SUMGUI();
                        if (hook.hasStandardMenu()) {
                            SPMainMenuPanel menu = hook.getStandardMenu();
                            if (!menu.hasVersion()) {
                                menu.setVersion(hook.getVersion());
                            }
                            singleton.add(menu);
                            if (justSettings) {
                                SUMGUI.switchToSettingsMode();
                            }
                        }
                        progress.moveToCorrectLocation();
                        if (!justPatching) {
                            progress.setGUIref(singleton);
                        }
                        if (justPatching && SUMGUI.needsImporting()) {
                            exitRequested = true;
                            progress.open();
                            SUMGUI.runThread();
                        } else if (!justPatching && hook.importAtStart()) {
                            SUMGUI.runThread();
                        } else if (SUMGUI.testNeedsPatching(false)) {
                            SUMGUI.setPatchNeeded(true);
                        }
                    }
                    catch (Exception e) {
                        SPGlobal.logException(e);
                        JOptionPane.showMessageDialog(null, "<html>There was an error running the program.<br>Refer to the debug logs.</html>");
                    }
                }
            }
        });
    }

    static void clean() {
        ArrayList<File> files = new ArrayList<File>();
        files.add(new File(String.valueOf(SPGlobal.pathToInternalFiles) + "/Last Masterlist.txt"));
        files.add(new File(String.valueOf(SPGlobal.pathToInternalFiles) + "/Last Modlist.txt"));
        for (File f : files) {
            if (!f.isFile()) continue;
            f.delete();
        }
    }

    static void logStatus() {
        SPGlobal.logMain("Status", String.valueOf(hook.getName()) + " version: " + hook.getVersion());
        SPGlobal.logMain("Status", "Used Memory: " + Ln.toMB((long)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory())) + "MB");
        SPGlobal.logMain("Status", "Max Memory: " + Ln.toMB((long)Runtime.getRuntime().maxMemory()) + "MB");
    }

    static void loadBlockedMods(String path) {
        File f = new File(path);
        if (f.exists()) {
            try {
                boolean foundMods = false;
                ArrayList blockMods = Ln.loadFileToStrings((File)f, (boolean)true);
                for (String s : blockMods) {
                    s = Ln.cleanLine((String)s, (String)"//");
                    if (foundMods && !"".equals(s)) {
                        SPGlobal.addModToSkip(s);
                        continue;
                    }
                    if (!s.contains("MOD BLOCKS")) continue;
                    foundMods = true;
                }
            }
            catch (IOException ex) {
                SPGlobal.logException(ex);
            }
        } else {
            try {
                Throwable ex = null;
                Object var3_8 = null;
                try (BufferedWriter out = new BufferedWriter(new FileWriter(path));){
                    out.write("==MOD BLOCKS==\n");
                    out.write("//Add a mod names or keywords to look for to block\n//One per line");
                }
                catch (Throwable throwable) {
                    if (ex == null) {
                        ex = throwable;
                    } else if (ex != throwable) {
                        ex.addSuppressed(throwable);
                    }
                    throw ex;
                }
            }
            catch (IOException ex) {
                SPGlobal.logException(ex);
            }
        }
    }

    static void handleArgs(String[] args) {
        ArrayList arguments = Ln.toUpper(new ArrayList<String>(Arrays.asList(args)));
        if (SPGlobal.logging()) {
            SPGlobal.logMain("Run Location", "Program running from: " + new File(".").getAbsolutePath());
            for (String arg : arguments) {
                SPGlobal.logMain(header, "Arg: " + arg);
            }
        }
        justPatching = arguments.contains("-GENPATCH");
        SPGlobal.setNoModsAfter(!arguments.contains("-MODSAFTER"));
        int index = arguments.indexOf("-PROGRESSLOCATION");
        if (index != -1) {
            Dimension progressLoc = new Dimension(Integer.valueOf((String)arguments.get(index + 1)), Integer.valueOf((String)arguments.get(index + 2)));
            progress.setCorrectLocation(progressLoc.width, progressLoc.height);
        }
        justSettings = arguments.contains("-JUSTSETTINGS");
        SPGlobal.Language ini_lang = SPGlobal.getLanguageFromSkyrimIni();
        if (ini_lang != null) {
            SPGlobal.language = ini_lang;
        }
        if ((index = arguments.indexOf("-LANGUAGE")) != -1) {
            String lang = (String)arguments.get(index + 1);
            SPGlobal.Language[] languageArray = SPGlobal.Language.values();
            int n = languageArray.length;
            int n2 = 0;
            while (n2 < n) {
                SPGlobal.Language l = languageArray[n2];
                if (lang.equalsIgnoreCase(l.toString())) {
                    SPGlobal.language = l;
                    break;
                }
                ++n2;
            }
        }
        if (SPGlobal.logging()) {
            SPGlobal.logMain("Language", "Language set to " + (Object)((Object)SPGlobal.language));
        }
        if (arguments.contains("-SUMBLOCK")) {
            try {
                SUMGUI.loadBlockedMods(SPGlobal.getSkyProcDocuments() + "\\SUM Mod Blocklist.txt");
            }
            catch (IOException ex) {
                SPGlobal.logException(ex);
            }
        }
        if (arguments.contains("-FORCE")) {
            SUMGUI.setPatchNeeded(true);
        }
        SPGlobal.setStreamMode(!arguments.contains("-NOSTREAM"));
        boss = arguments.contains("-BOSS");
        if (arguments.contains("-ALLMODSASMASTERS")) {
            SPGlobal.setAllModsAsMasters(true);
        }
        if (SPGlobal.logging() && justPatching) {
            SPGlobal.logMain(header, "Program is just patching. (-GENPATCH)");
        }
    }

    static void switchToSettingsMode() {
        patchNeededLabel.setText("Change Settings Mode - No patch will be generated.");
        patchNeededLabel.setVisible(true);
        forcePatch.setVisible(false);
        cancelPatch.setVisible(false);
        startPatch.setVisible(false);
        try {
            final LImagePane backToSUM = new LImagePane(SUMprogram.class.getResource("BackToSUMdark.png"));
            backToSUM.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    SUMGUI.exitProgram(false, true);
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    try {
                        backToSUM.setImage(SUMprogram.class.getResource("BackToSUM.png"));
                    }
                    catch (IOException ex) {
                        SPGlobal.logException(ex);
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    try {
                        backToSUM.setImage(SUMprogram.class.getResource("BackToSUMdark.png"));
                    }
                    catch (IOException ex) {
                        SPGlobal.logException(ex);
                    }
                }
            });
            backToSUM.setLocation(0, 510);
            singleton.add((Component)backToSUM);
        }
        catch (IOException ex) {
            SPGlobal.logException(ex);
        }
    }

    public static void setErrorMessage(String message) {
        errorMessage = message;
    }

    int getFrameHeight() {
        return this.getHeight() - 28;
    }

    static void imported() {
        SPProgressBarPlug.setStatus("Done importing.");
        SUMGUI.setPatchNeeded(SUMGUI.testNeedsPatching(true));
    }

    public static void setPatchNeeded(boolean on) {
        needsPatching = on;
        if (SPGlobal.logging()) {
            SPGlobal.logMain(header, "Patch needed: " + on);
        }
        if (patchNeededLabel != null) {
            patchNeededLabel.setVisible(on);
            forcePatch.setVisible(!on);
        }
    }

    static void setBackgroundPicture(URL backgroundPicture) {
        try {
            backgroundPanel.setImage(backgroundPicture);
        }
        catch (IOException ex) {
            SPGlobal.logException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean needsImporting() {
        if (forcePatch.isSelected().booleanValue() || SUMGUI.testNeedsPatching(false)) {
            if (SPGlobal.logging()) {
                SPGlobal.logMain("Needs Importing", "Needs importing because force patch was on or patch needed updating.");
            }
            SUMGUI.setPatchNeeded(true);
            return true;
        }
        try {
            ArrayList<ModListing> curListTmp;
            ArrayList<ModListing> curList;
            ArrayList oldList = save.getStrings(SUMGUISettings.LastModlist);
            int i = 0;
            while (true) {
                if (i >= oldList.size()) {
                    curList = new ArrayList<ModListing>(SPImporter.getActiveModList());
                    curList.remove(hook.getListing());
                    curListTmp = new ArrayList<ModListing>(curList);
                    if (curList.size() == oldList.size()) break;
                    if (SPGlobal.logging()) {
                        SPGlobal.logMain("Needs Importing", "Needs importing because last Modlist isn't the same size as current.");
                    }
                    return true;
                }
                String oldString = (String)oldList.get(i);
                if (oldString.contains("<--DATE-->")) {
                    oldList.set(i, oldString.substring(0, oldString.indexOf("<--DATE-->")));
                }
                ++i;
            }
            int i2 = 0;
            while (true) {
                if (i2 >= curList.size()) {
                    ArrayList<String> changedMods = SUMGUI.getChangedMods(true);
                    if (changedMods.size() <= 0) {
                        return hook.needsPatching();
                    }
                    if (SPGlobal.logging()) {
                        SPGlobal.logMain("Needs Importing", "Needs importing because " + changedMods.get(0) + " had its date changed.");
                    }
                    return true;
                }
                ModListing m = curListTmp.get(i2);
                if (!((String)oldList.get(i2)).equals(m.print().toUpperCase())) {
                    if (SPGlobal.logging()) {
                        SPGlobal.logMain("Needs Importing", "Needs importing because " + (String)oldList.get(i2) + " doesn't match " + m.print() + " at index " + i2);
                    }
                    return true;
                }
                ++i2;
            }
        }
        catch (IOException ex) {
            SPGlobal.logException(ex);
            return true;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    static boolean testNeedsPatching(boolean imported) {
        if (needsPatching) {
            return true;
        }
        if (!SPGlobal.getGlobalPatch().exists()) {
            if (SPGlobal.logging()) {
                SPGlobal.logMain(header, "Patch needed because no patch existed.");
            }
            return true;
        }
        if (save.getBool(SUMGUISettings.CrashState).booleanValue()) {
            if (SPGlobal.logging()) {
                SPGlobal.logMain(header, "Patch needed because it closed prematurely earlier while needing to patch.");
            }
            return true;
        }
        if (save.getInt(SUMGUISettings.PrevVersion) != NiftyFunc.versionToNum(hook.getVersion())) {
            if (SPGlobal.logging()) {
                SPGlobal.logMain(header, "Needs update because of versioning: " + save.getInt(SUMGUISettings.PrevVersion) + " to " + hook.getVersion());
            }
            return true;
        }
        if (hook.hasSave() && hook.getSave().checkFlagOr(0)) {
            if (SPGlobal.logging()) {
                SPGlobal.logMain(header, "Patch needed because an important setting changed.");
            }
            return true;
        }
        if (imported) {
            try {
                ArrayList oldMasterList = save.getStrings(SUMGUISettings.LastMasterlist);
                ArrayList<String> curImportedMods = new ArrayList<String>();
                for (ModListing m : SPDatabase.getImportedModListings()) {
                    curImportedMods.add(m.print().toUpperCase());
                }
                curImportedMods.remove(SPGlobal.getGlobalPatch().getName().toUpperCase());
                ArrayList curImportedModsTmp = new ArrayList(curImportedMods);
                int i = 0;
                while (i < curImportedModsTmp.size()) {
                    String curName = (String)curImportedModsTmp.get(i);
                    if (oldMasterList.contains(curName)) {
                        int j = 0;
                        while (j < oldMasterList.size()) {
                            if (((String)oldMasterList.get(j)).equalsIgnoreCase(curName)) {
                                oldMasterList.remove(j);
                                break;
                            }
                            if (curImportedModsTmp.contains(oldMasterList.get(j))) {
                                if (SPGlobal.logging()) {
                                    SPGlobal.logMain(header, "Patch needed because masters from before were in a different order.");
                                }
                                return true;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                if (!oldMasterList.isEmpty()) {
                    if (SPGlobal.logging()) {
                        SPGlobal.logMain(header, "Patch needed because old masters are missing:");
                        for (String s : oldMasterList) {
                            SPGlobal.logMain(header, "   " + s);
                        }
                    }
                    return true;
                }
                curImportedMods.removeAll(SUMGUI.getChangedMods(false));
                for (String curString : curImportedMods) {
                    Mod curMaster = SPDatabase.getMod(new ModListing(curString));
                    ArrayList<GRUP_TYPE> contained = curMaster.getContainedTypes();
                    GRUP_TYPE[] gRUP_TYPEArray = hook.importRequests();
                    int n = gRUP_TYPEArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        GRUP_TYPE g = gRUP_TYPEArray[n2];
                        if (contained.contains((Object)g)) {
                            if (SPGlobal.logging()) {
                                SPGlobal.logMain(header, "Patch needed because " + curMaster + " had records patch might be interested in.");
                            }
                            return true;
                        }
                        ++n2;
                    }
                }
            }
            catch (IOException ex) {
                SPGlobal.logException(ex);
                if (SPGlobal.logging()) {
                    SPGlobal.logMain(header, "Patch needed because exception was thrown in patch sensing code.");
                }
                return true;
            }
        }
        if (SPGlobal.logging()) {
            SPGlobal.logMain(header, "Checking SUM hook to see if it wants to create a patch.");
        }
        return hook.needsPatching();
    }

    static ArrayList<String> getChangedMods(boolean changed) throws IOException {
        ArrayList oldModListRaw = save.getStrings(SUMGUISettings.LastModlist);
        ArrayList<String> oldModList = new ArrayList<String>(oldModListRaw.size());
        ArrayList<Long> oldModListDate = new ArrayList<Long>(oldModListRaw.size());
        ArrayList<String> out = new ArrayList<String>();
        for (String modAndDate : oldModListRaw) {
            String[] split = modAndDate.split("<--DATE-->");
            oldModList.add(split[0]);
            if (split.length <= 1) continue;
            oldModListDate.add(Long.valueOf(split[1]));
        }
        if (oldModList.size() != oldModListDate.size()) {
            if (changed) {
                return oldModList;
            }
            return new ArrayList<String>(0);
        }
        ArrayList<String> oldModListTmp = new ArrayList<String>(oldModList);
        int i = 0;
        while (i < oldModListTmp.size()) {
            boolean changedF;
            String modName = oldModListTmp.get(i);
            File modFile = new File(String.valueOf(SPGlobal.pathToData) + modName);
            boolean bl = changedF = modFile.lastModified() != ((Long)oldModListDate.get(i)).longValue();
            if (changed && changedF || !changed && !changedF) {
                out.add(modName);
            }
            ++i;
        }
        return out;
    }

    static void closingGUIwindow() {
        SPGlobal.logMain(header, "Window Closing.");
        if (justSettings || !patchrequested) {
            SUMGUI.exitProgram(false, true);
        }
        exitRequested = true;
        if (!imported && !SUMGUI.needsImporting()) {
            SPProgressBarPlug.done();
            if (SPGlobal.logging()) {
                SPGlobal.logMain(header, "Closing program early because it does not need importing.");
            }
            SUMGUI.exitProgram(false, true);
        } else {
            progress.setExitOnClose();
            progress.open();
        }
        SUMGUI.runThread();
    }

    public static void exitProgram(boolean generatedPatch, boolean forceClose) {
        SPGlobal.log(header, "Exit requested.");
        if (generatedPatch) {
            save.setStrings(SUMGUISettings.LastModlist, Ln.toUpper(SPDatabase.getModListDates()));
            save.setStrings(SUMGUISettings.LastMasterlist, Ln.toUpper(SPGlobal.getGlobalPatch().getMastersStrings()));
            save.setBool(SUMGUISettings.CrashState, false);
            save.setInt(SUMGUISettings.PrevVersion, NiftyFunc.versionToNum(hook.getVersion()));
        } else if (needsPatching) {
            save.setBool(SUMGUISettings.CrashState, true);
        }
        if (singleton != null) {
            singleton.dispose();
        }
        progress.dispose();
        try {
            hook.onExit(generatedPatch);
        }
        catch (Exception e) {
            SPGlobal.logException(e);
        }
        if (hook.hasSave()) {
            hook.getSave().saveToFile();
        }
        save.saveToFile();
        if (forceClose) {
            LDebug.wrapUpAndExit();
        } else {
            LDebug.wrapUp();
        }
    }

    static void runThread() {
        SUMGUI.runThread(null);
    }

    static void runThread(Runnable r) {
        if (parser == null || !parser.isAlive()) {
            parserRunnable = new ProcessingThread();
            parser = new Thread(parserRunnable);
            if (r != null) {
                SUMGUI.parserRunnable.afterImporting.add(r);
            }
            parser.start();
        } else if (r != null) {
            SUMGUI.parserRunnable.afterImporting.add(r);
        }
    }

    static void bossWarning() {
        if (save.getBool(SUMGUISettings.BOSSWarning).booleanValue()) {
            String message = "<html>This patcher is going to run BOSS first to standardize ordering.<br><br>To turn BOSS execution off, download <a href=\"http://skyrim.nexusmods.com/mods/29865\">SUM</a> and adjust its settings.<br>However, running BOSS is recommended.  <a href=\"http://afterimagemetal.com/SkyProc/SUM%20Readme.html#BOSS\">Read this article why.</a><br><br>Do you want to continue patching?</html>";
            int response = JOptionPane.showConfirmDialog(null, Lg.getQuickHTMLPane((String)message), "Running BOSS", 0);
            if (response == 0) {
                response = JOptionPane.showConfirmDialog(null, "Do you want to see this warning next time?", "Running BOSS", 0);
                if (response == 1) {
                    save.setBool(SUMGUISettings.BOSSWarning, false);
                }
            } else {
                SUMGUI.exitProgram(false, true);
            }
        }
    }

    static void lootWarning() {
        if (save.getBool(SUMGUISettings.LOOTWarning).booleanValue()) {
            String message = "<html>This patcher is going to run LOOT first to standardize ordering.<br><br>To turn LOOT execution off, download <a href=\"http://skyrim.nexusmods.com/mods/29865\">SUM</a> and adjust its settings.<br>However, running LOOT is recommended.  <a href=\"http://afterimagemetal.com/SkyProc/SUM%20Readme.html#BOSS\">Read this article why.</a><br><br>Do you want to continue patching?</html>";
            int response = JOptionPane.showConfirmDialog(null, Lg.getQuickHTMLPane((String)message), "Running LOOT", 0);
            if (response == 0) {
                response = JOptionPane.showConfirmDialog(null, "Do you want to see this warning next time?", "Running LOOT", 0);
                if (response == 1) {
                    save.setBool(SUMGUISettings.LOOTWarning, false);
                }
            } else {
                SUMGUI.exitProgram(false, true);
            }
        }
    }

    public static void startImport(Runnable codeToRunAfter) {
        if (!imported) {
            SUMGUI.runThread(codeToRunAfter);
        } else {
            Thread t = new Thread(codeToRunAfter);
            t.start();
        }
    }

    public static void startImport() {
        SUMGUI.runThread(null);
    }

    @Override
    public Component add(Component comp) {
        return backgroundPanel.add(comp, 0);
    }

    static class ProcessingThread
    implements Runnable {
        public Set<Runnable> afterImporting = new HashSet<Runnable>();

        ProcessingThread() {
        }

        @Override
        public void run() {
            block14: {
                SPGlobal.logMain("START IMPORT THREAD", "Starting of process thread.");
                try {
                    if (!imported) {
                        if (boss) {
                            SUMGUI.bossWarning();
                            NiftyFunc.setupMissingPatchFiles(SPGlobal.getGlobalPatch());
                            NiftyFunc.modifyPluginsTxt(SPGlobal.getGlobalPatch());
                            NiftyFunc.runBOSS(true);
                        }
                        SPImporter.importActiveMods(hook.importRequests());
                        SUMGUI.imported();
                        imported = true;
                        for (Runnable r : this.afterImporting) {
                            r.run();
                        }
                    }
                    if (!exitRequested) break block14;
                    if (needsPatching || forcePatch == null || forcePatch.isSelected().booleanValue()) {
                        for (ModListing m : hook.requiredMods()) {
                            if (SPDatabase.hasMod(m)) continue;
                            String modNames = "";
                            for (ModListing m2 : hook.requiredMods()) {
                                modNames = String.valueOf(modNames) + "\n" + m2.toString();
                            }
                            JOptionPane.showMessageDialog(null, "This patcher requires the following mods, please add them to your load order:" + modNames);
                            SPGlobal.logMain("Required Mods", "Didn't have required mods.  Stopping patcher.");
                            SPProgressBarPlug.done();
                            SUMGUI.exitProgram(true, true);
                        }
                        hook.runChangesToPatch();
                        try {
                            SPGlobal.getGlobalPatch().export();
                        }
                        catch (Exception ex) {
                            SPGlobal.logException(ex);
                            JOptionPane.showMessageDialog(null, "There was an error exporting the custom patch.\n(" + ex.getMessage() + ")\n\n" + errorMessage);
                            SUMGUI.exitProgram(false, true);
                        }
                        if (SPGlobal.logging()) {
                            SPGlobal.logMain(SUMGUI.header, "Closing program after successfully running patch.");
                        }
                    }
                    if (SPGlobal.logging()) {
                        SPGlobal.logMain(SUMGUI.header, "Closing program normally from thread.");
                    }
                    SPProgressBarPlug.done();
                    SUMGUI.exitProgram(true, false);
                }
                catch (MissingMaster m) {
                    System.err.println(m.toString());
                    SPGlobal.logException(m);
                    JOptionPane.showMessageDialog(null, String.valueOf(m.toString()) + "\n\n Please activate and try again.");
                    SUMGUI.exitProgram(false, true);
                }
                catch (Throwable e) {
                    System.err.println(e.toString());
                    SPGlobal.logException(e);
                    JOptionPane.showMessageDialog(null, "There was an exception thrown during program execution: '" + e + "'\n\n" + errorMessage);
                    if (SPGlobal.logging()) {
                        SPGlobal.logMain(SUMGUI.header, "Closing program after UNSUCCESSFULLY running import/patch.");
                    }
                    SUMGUI.exitProgram(false, true);
                }
            }
        }

        public void main(String[] args) {
            new Thread(new ProcessingThread()).start();
        }
    }

    static class SUMGUISave
    extends LSaveFile {
        SUMGUISave() {
            super(String.valueOf(SPGlobal.pathToInternalFiles) + "SUMsave");
        }

        protected void initSettings() {
            this.Add(SUMGUISettings.PrevVersion, 0, new Boolean[]{true});
            this.Add(SUMGUISettings.LastMasterlist, new ArrayList(), new Boolean[]{false});
            this.Add(SUMGUISettings.LastModlist, new ArrayList(), new Boolean[]{false});
            this.Add(SUMGUISettings.CrashState, false, new Boolean[]{false});
            this.Add(SUMGUISettings.BOSSWarning, true, new Boolean[]{false});
            this.Add(SUMGUISettings.LOOTWarning, true, new Boolean[]{false});
        }

        protected void initHelp() {
        }
    }

    static enum SUMGUISettings {
        LastMasterlist,
        LastModlist,
        PrevVersion,
        CrashState,
        BOSSWarning,
        LOOTWarning;

    }

    public class SUMProgress
    implements LProgressBarInterface {
        public void setMax(int in) {
            progress.setMax(in);
        }

        public void setMax(int in, String status) {
            progress.setMax(in, status);
            if (!progress.paused()) {
                statusUpdate.setText(status);
            }
        }

        public void setStatus(String status) {
            progress.setStatus(status);
            if (!progress.paused()) {
                statusUpdate.setText(status);
            }
        }

        public void setStatusNumbered(int min, int max, String status) {
            progress.setStatusNumbered(min, max, status);
            if (!progress.paused()) {
                statusUpdate.setText(status);
            }
        }

        public void setStatusNumbered(String status) {
            progress.setStatusNumbered(status);
            if (!progress.paused()) {
                statusUpdate.setText(status);
            }
        }

        public void incrementBar() {
            progress.incrementBar();
        }

        public void reset() {
            progress.incrementBar();
        }

        public void setBar(int in) {
            progress.setBar(in);
        }

        public int getBar() {
            return progress.getBar();
        }

        public int getMax() {
            return progress.getMax();
        }

        public void pause(boolean on) {
            progress.pause(on);
        }

        public boolean paused() {
            return progress.paused();
        }

        public void done() {
            progress.done();
        }
    }
}

