/*
 * Decompiled with CFR 0.152.
 */
package skyproc.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import lev.gui.LButton;
import lev.gui.LLabel;
import lev.gui.LPanel;
import lev.gui.LScrollPane;
import lev.gui.LUserSetting;
import skyproc.gui.SPMainMenuPanel;
import skyproc.gui.SUMGUI;

public abstract class SPSettingPanel
extends LPanel {
    protected SPMainMenuPanel parent;
    private int rightMost = 0;
    protected LLabel header;
    protected ArrayList<LUserSetting> settings = new ArrayList();
    protected LScrollPane scroll;
    protected LPanel settingsPanel;
    private ArrayList<Component> components = new ArrayList();
    protected boolean initialized = false;

    public SPSettingPanel(SPMainMenuPanel parent_, String title, Color headerColor) {
        super(SUMGUI.fullDimensions);
        this.parent = parent_;
        this.header = new LLabel(title, SUMGUI.SUMmainFont, headerColor);
    }

    public String getName() {
        return this.header.getText();
    }

    protected void initialize() {
        this.settingsPanel = new LPanel(SUMGUI.middleDimensions);
        this.settingsPanel.add((Component)this.header);
        this.scroll = new LScrollPane((Component)this.settingsPanel);
        this.scroll.setLocation(SUMGUI.middleDimensions.x, SUMGUI.middleDimensions.y);
        this.scroll.setSize(SUMGUI.middleDimensions.width, SUMGUI.middleDimensions.height);
        this.add((Component)this.scroll);
        this.header.addShadow();
        this.header.setLocation(this.settingsPanel.getWidth() / 2 - this.header.getWidth() / 2, 20);
        this.settingsPanel.setPreferredSize(this.scroll.getSize());
        this.last = new Point(this.settingsPanel.getWidth(), 65);
        this.initialized = true;
        this.setVisible(true);
    }

    protected void update() {
    }

    protected Point getSpacing(LButton in1, LButton in2, boolean left) {
        int spacing = (this.settingsPanel.getWidth() - in1.getWidth() - in2.getWidth()) / 3;
        if (left) {
            return new Point(spacing, this.settingsPanel.getHeight() - in1.getHeight() - 15);
        }
        return new Point(in1.getX() + in1.getWidth() + spacing, this.settingsPanel.getHeight() - in2.getHeight() - 15);
    }

    public final void Add(Component c) {
        this.components.add(c);
        this.settingsPanel.Add(c);
        int range = c.getY() + c.getHeight();
        if ((double)range > this.settingsPanel.getPreferredSize().getHeight()) {
            this.settingsPanel.setPreferredSize(new Dimension(this.settingsPanel.getPreferredSize().width, range));
        }
    }

    public void AddSetting(LUserSetting c) {
        this.Add((Component)c);
        this.settings.add(c);
    }

    public void open() {
        this.parent.open();
        if (!this.initialized) {
            this.initialize();
        }
        SUMGUI.helpPanel.reset();
        this.parent.openPanel(this);
        this.onOpen(this.parent);
        this.parent.revalidate();
    }

    public ActionListener getOpenHandler() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SPSettingPanel.this.open();
                    }
                });
            }
        };
    }

    public void onOpen(SPMainMenuPanel parent) {
    }

    void close(SPMainMenuPanel parent) {
        this.setVisible(false);
        this.onClose(parent);
    }

    public void onClose(SPMainMenuPanel parent) {
    }

    public Point setPlacement(Component c, int x, int y) {
        c.setLocation(x / 2 - c.getWidth() / 2, y + this.spacing);
        if (c.getX() + c.getWidth() > this.rightMost) {
            this.rightMost = c.getX() + c.getWidth();
        }
        this.updateLast(c);
        return this.last;
    }

    public void alignRight() {
        for (Component c : this.components) {
            c.setLocation(this.rightMost - c.getWidth(), c.getY());
        }
    }
}

