/*
 * Decompiled with CFR 0.152.
 */
package skyproc.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.JPanel;
import lev.gui.LImagePane;
import lev.gui.LLabel;
import lev.gui.LPanel;
import lev.gui.LSaveFile;
import lev.gui.LScrollPane;
import skyproc.SPGlobal;
import skyproc.gui.SPMainMenuConfig;
import skyproc.gui.SPSettingPanel;
import skyproc.gui.SUMGUI;

public class SPMainMenuPanel
extends JPanel {
    static final int spacing = 35;
    static final int xPlacement = SUMGUI.leftDimensions.width - 25;
    int yPlacement = 0;
    LImagePane customLogo;
    LLabel version;
    Color color;
    protected LScrollPane menuScroll;
    protected LPanel menuPanel = new LPanel(SUMGUI.leftDimensions);
    ArrayList<SPSettingPanel> panels = new ArrayList();
    SPSettingPanel welcome = null;
    SPSettingPanel activePanel;

    public SPMainMenuPanel(Color menuColor) {
        this.setLayout(null);
        this.setSize(SUMGUI.middleLeftDimensions.getSize());
        this.setLocation(0, 0);
        int topMargin = 170;
        int bottomMargin = 40;
        this.menuPanel.setPreferredSize(this.menuPanel.getSize());
        this.menuScroll = new LScrollPane((Component)this.menuPanel);
        this.menuScroll.setLocation(0, topMargin);
        this.menuScroll.setHorizontalScrollBarPolicy(31);
        this.menuScroll.setSize(SUMGUI.leftDimensions.width, SUMGUI.leftDimensions.height - topMargin - bottomMargin);
        this.add((Component)this.menuScroll);
        this.setOpaque(false);
        this.color = menuColor;
    }

    public SPMainMenuPanel() {
        this(SUMGUI.light);
    }

    public void addLogo(URL logo) {
        try {
            int height = 150;
            this.customLogo = new LImagePane(logo);
            this.customLogo.setMaxSize(SUMGUI.leftDimensions.width, height);
            this.customLogo.setLocation(SUMGUI.leftDimensions.width / 2 - this.customLogo.getWidth() / 2, 14);
            this.add((Component)this.customLogo);
            this.tieWelcomeAndLogo();
        }
        catch (IOException ex) {
            SPGlobal.logException(ex);
        }
    }

    public void setVersion(String version) {
        this.setVersion(version, new Point(5, 5));
    }

    public void setVersion(String version, Point location) {
        if (!this.hasVersion()) {
            this.version = new LLabel(version, new Font("Serif", 0, 10), SUMGUI.darkGray);
            this.add((Component)this.version);
        }
        this.version.setLocation(location);
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    public SPMainMenuConfig addMenu(SPSettingPanel panel, boolean checkBoxPresent, LSaveFile save, Enum setting) {
        return this.addMenu(panel, this.color, checkBoxPresent, save, setting);
    }

    public SPMainMenuConfig addMenu(SPSettingPanel panel, Color c, boolean checkBoxPresent, LSaveFile save, Enum setting) {
        SPMainMenuConfig menuConfig = new SPMainMenuConfig(panel.header, checkBoxPresent, c, new Point(xPlacement, this.yPlacement), save, setting);
        this.yPlacement += 35;
        menuConfig.addActionListener(panel.getOpenHandler());
        this.menuPanel.add((Component)((Object)menuConfig));
        this.menuPanel.setPreferredSize(new Dimension(this.menuPanel.getPreferredSize().width, this.yPlacement));
        return menuConfig;
    }

    public SPMainMenuConfig addMenu(SPSettingPanel panel) {
        return this.addMenu(panel, false, null, null);
    }

    public void openPanel(SPSettingPanel panel) {
        int index;
        if (this.activePanel != null) {
            this.activePanel.close(this);
        }
        if ((index = this.panels.indexOf((Object)panel)) != -1) {
            this.activePanel = this.panels.get(index);
        } else {
            this.panels.add(panel);
            this.activePanel = panel;
            this.add((Component)((Object)panel));
        }
        this.activePanel.setVisible(true);
    }

    public void setWelcomePanel(SPSettingPanel panel) {
        this.welcome = panel;
        this.welcome.open();
        this.tieWelcomeAndLogo();
    }

    void tieWelcomeAndLogo() {
        if (this.welcome != null && this.customLogo != null) {
            this.customLogo.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    SPMainMenuPanel.this.welcome.open();
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }
            });
        }
    }

    public void setBackgroundPicture(URL backgroundPicture) {
        SUMGUI.setBackgroundPicture(backgroundPicture);
    }

    public void setMainFont(Font font, int helpSize, int headerSize, int menuSize) {
        SUMGUI.helpPanel.setHeaderFont(font.deriveFont(0, helpSize));
        SUMGUI.SUMmainFont = font.deriveFont(0, headerSize);
        SPMainMenuConfig.size = menuSize;
    }

    public void setMainFont(URL fontURL, int helpSize, int headerSize, int menuSize) {
        try {
            Font font = Font.createFont(0, fontURL.openStream());
            this.setMainFont(font, helpSize, headerSize, menuSize);
        }
        catch (FontFormatException | IOException ex) {
            SPGlobal.logException(ex);
        }
    }

    void open() {
        this.setVisible(true);
        this.repaint();
    }
}

