/*
 * Decompiled with CFR 0.152.
 */
package skyproc.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.io.IOException;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import lev.gui.LImagePane;
import lev.gui.LLabel;
import lev.gui.LProgressBar;
import lev.gui.LProgressBarInterface;
import lev.gui.LTextPane;
import lev.gui.resources.LFonts;
import lev.gui.resources.LImages;
import skyproc.gui.SPProgressBarPlug;

public class SPDefaultGUI
extends JFrame {
    LImagePane backgroundPanel;
    LImagePane patcherLogo;
    Component descriptionAnchor;
    LLabel pluginLabel;
    LLabel patching;
    LTextPane description;
    LImagePane skyprocLogo;
    LProgressBar pbar = new LProgressBar(250, 15, new Font("SansSerif", 0, 11), new Color(180, 180, 180));

    public SPDefaultGUI(final String yourPatcherName, final String yourDescription) {
        super(yourPatcherName);
        SPProgressBarPlug.addProgressBar((LProgressBarInterface)this.pbar);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SPDefaultGUI.this.init(yourPatcherName, yourDescription);
            }
        });
    }

    final void init(String pluginName, String descriptionText) {
        try {
            this.setDefaultCloseOperation(3);
            this.setSize(600, 400);
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation(dim.width / 2 - this.getWidth() / 2, dim.height / 2 - this.getHeight() / 2);
            this.setResizable(false);
            this.setLayout(null);
            this.backgroundPanel = new LImagePane(LImages.multipurpose());
            super.add((Component)this.backgroundPanel);
            this.skyprocLogo = new LImagePane(SPDefaultGUI.class.getResource("SkyProc Logo Small.png"));
            this.skyprocLogo.setLocation(this.getWidth() - this.skyprocLogo.getWidth() - 15, this.getHeight() - this.skyprocLogo.getHeight() - 30);
            this.backgroundPanel.add((Component)this.skyprocLogo);
            this.pluginLabel = new LLabel("[ " + pluginName + " ]", LFonts.OptimusPrinceps((float)30.0f), new Color(61, 143, 184));
            this.pluginLabel.addShadow();
            this.pluginLabel.centerIn((Component)this, 20);
            this.descriptionAnchor = this.pluginLabel;
            this.backgroundPanel.add((Component)this.pluginLabel);
            this.patching = new LLabel("Creating patch.", LFonts.Typo3((float)15.0f), new Color(210, 210, 210));
            this.patching.addShadow();
            this.patching.centerIn((Component)this, this.getHeight() - this.patching.getHeight() - 80);
            this.backgroundPanel.add((Component)this.patching);
            this.pbar.centerIn((Component)this, this.patching.getY() + this.patching.getHeight() + 5);
            this.pbar.setCentered(false);
            this.pbar.setStatusOffset(-5);
            LLabel status = new LLabel(". . .", new Font("SansSerif", 0, 11), new Color(160, 160, 160));
            this.pbar.setStatusLabel(status);
            status.setLocation(8, this.getHeight() - status.getHeight() - 36);
            this.backgroundPanel.add((Component)status);
            this.backgroundPanel.add((Component)this.pbar);
            int descY = this.descriptionAnchor.getY() + this.descriptionAnchor.getHeight() + 20;
            Dimension descSize = new Dimension(this.getWidth() - 100, this.getHeight() - descY - (this.getHeight() - this.patching.getY()) - 15);
            this.description = new LTextPane(descSize, new Color(200, 200, 200));
            this.description.centerIn((Component)this, descY);
            this.description.setEditable(false);
            this.description.setText(descriptionText);
            this.description.setFontSize(14.0f);
            this.description.centerText();
            this.backgroundPanel.add((Component)this.description);
            this.setVisible(true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void finishRun() {
        this.patching.setText("Patch is complete!");
        this.patching.centerIn((Component)this, this.patching.getY());
        this.patching.setFontColor(Color.orange);
    }

    @Override
    public Component add(final Component c) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SPDefaultGUI.this.backgroundPanel.add(c, 0);
            }
        });
        return c;
    }

    public void replaceHeader(URL logo, final int descriptionOffset) throws IOException {
        this.patcherLogo = new LImagePane(logo);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SPDefaultGUI.this.description.setVisible(false);
                SPDefaultGUI.this.patcherLogo.setLocation(SPDefaultGUI.this.getWidth() / 2 - SPDefaultGUI.this.patcherLogo.getWidth() / 2, 0);
                SPDefaultGUI.this.pluginLabel.setVisible(false);
                SPDefaultGUI.this.backgroundPanel.add((Component)SPDefaultGUI.this.patcherLogo, 0);
                SPDefaultGUI.this.fitDesc((Component)SPDefaultGUI.this.patcherLogo, descriptionOffset);
            }
        });
    }

    void fitDesc(final Component descAnchor, final int offset) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SPDefaultGUI.this.description.setVisible(false);
                int descY = descAnchor.getY() + descAnchor.getHeight() + 20;
                Dimension descSize = new Dimension(SPDefaultGUI.this.getWidth() - 100, SPDefaultGUI.this.getHeight() - descY - (SPDefaultGUI.this.getHeight() - SPDefaultGUI.this.patching.getY()) - 15 - offset);
                SPDefaultGUI.this.description.setLocation(SPDefaultGUI.this.description.getX(), descY + offset);
                SPDefaultGUI.this.description.setSize(descSize);
                SPDefaultGUI.this.description.setVisible(true);
            }
        });
    }

    public void setHeaderColor(final Color c) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SPDefaultGUI.this.pluginLabel.setFontColor(c);
            }
        });
    }

    public void finished() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SPDefaultGUI.this.finishRun();
            }
        });
    }
}

