/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.DataFormatException;
import lev.LFlags;
import lev.LImport;
import skyproc.AltTextures;
import skyproc.DestructionData;
import skyproc.FormID;
import skyproc.GRUP_TYPE;
import skyproc.KeywordSet;
import skyproc.MajorRecordDescription;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.Model;
import skyproc.Record;
import skyproc.SPDatabase;
import skyproc.SPGlobal;
import skyproc.ScriptPackage;
import skyproc.SubData;
import skyproc.SubForm;
import skyproc.SubInt;
import skyproc.SubList;
import skyproc.SubPrototype;
import skyproc.SubRecord;
import skyproc.SubString;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;
import skyproc.genenums.Skill;
import skyproc.genenums.SoundVolume;

public class WEAP
extends MajorRecordDescription {
    static final SubPrototype WEAPproto = new SubPrototype(MajorRecordDescription.descProto){

        @Override
        protected void addRecords() {
            this.after(new ScriptPackage(), "EDID");
            this.add(new SubData("OBND", new byte[12]));
            this.reposition("FULL");
            this.add(new Model());
            this.add(new SubString("ICON"));
            this.add(new SubString("MICO"));
            this.add(new SubForm("EITM"));
            this.add(new SubInt("EAMT", 2));
            this.add(new DestructionData());
            this.add(new SubForm("ETYP"));
            this.add(new SubForm("BIDS"));
            this.add(new SubForm("BAMT"));
            this.add(new SubForm("YNAM"));
            this.add(new SubForm("ZNAM"));
            this.add(new KeywordSet());
            this.reposition("DESC");
            this.add(SubString.getNew("NNAM", true));
            this.add(new SubForm("INAM"));
            this.add(new SubForm("WNAM"));
            this.add(new SubList(new SubData("ENAM")));
            this.add(new SubForm("SNAM"));
            this.add(new SubForm("XNAM"));
            this.add(new SubForm("NAM7"));
            this.add(new SubForm("TNAM"));
            this.add(new SubForm("UNAM"));
            this.add(new SubForm("NAM9"));
            this.add(new SubForm("NAM8"));
            this.add(new DATA());
            this.add(new DNAM());
            this.add(new CRDT());
            this.add(new SubInt("VNAM", 4));
            this.add(new SubForm("CNAM"));
        }
    };

    WEAP() {
        this.subRecords.setPrototype(WEAPproto);
    }

    @Override
    ArrayList<String> getTypes() {
        return Record.getTypeList("WEAP");
    }

    @Override
    Record getNew() {
        return new WEAP();
    }

    public ScriptPackage getScriptPackage() {
        return this.subRecords.getScripts();
    }

    public KeywordSet getKeywordSet() {
        return this.subRecords.getKeywords();
    }

    DATA getDATA() {
        return (DATA)this.subRecords.get("DATA");
    }

    public void setValue(int value) {
        this.getDATA().value = Math.abs(value);
    }

    public int getValue() {
        return this.getDATA().value;
    }

    public void setWeight(float weight) {
        this.getDATA().weight = weight;
    }

    public float getWeight() {
        return this.getDATA().weight;
    }

    public void setDamage(int damage) {
        this.getDATA().damage = Math.abs(damage);
    }

    public int getDamage() {
        return this.getDATA().damage;
    }

    public void setEnchantmentCharge(int amount) {
        this.subRecords.setSubInt("EAMT", amount);
    }

    public int getEnchantmentCharge() {
        return this.subRecords.getSubInt("EAMT").get();
    }

    public void setEnchantment(FormID id) {
        this.subRecords.setSubForm("EITM", id);
    }

    public FormID getEnchantment() {
        return this.subRecords.getSubForm("EITM").getForm();
    }

    public void setEquipmentSlot(FormID id) {
        this.subRecords.setSubForm("ETYP", id);
    }

    public FormID getEquipmentSlot() {
        return this.subRecords.getSubForm("ETYP").getForm();
    }

    public void setImpactSet(FormID id) {
        this.subRecords.setSubForm("INAM", id);
    }

    public FormID getImpactSet() {
        return this.subRecords.getSubForm("INAM").getForm();
    }

    public void setModelFilename(String filename) {
        this.subRecords.getModel().setFileName(filename);
    }

    public String getModelFilename() {
        return this.subRecords.getModel().getFileName();
    }

    public void setSheathSound(FormID id) {
        this.subRecords.setSubForm("NAM8", id);
    }

    public FormID getSheathSound() {
        return this.subRecords.getSubForm("NAM8").getForm();
    }

    public void setDrawSound(FormID id) {
        this.subRecords.setSubForm("NAM9", id);
    }

    public FormID getDrawSound() {
        return this.subRecords.getSubForm("NAM9").getForm();
    }

    public void setSwingSound(FormID id) {
        this.subRecords.setSubForm("TNAM", id);
    }

    public FormID getSwingSound() {
        return this.subRecords.getSubForm("TNAM").getForm();
    }

    public void setBoundWeaponSound(FormID id) {
        this.subRecords.setSubForm("UNAM", id);
    }

    public FormID getBoundWeaponSound() {
        return this.subRecords.getSubForm("UNAM").getForm();
    }

    DNAM getDNAM() {
        return (DNAM)this.subRecords.get("DNAM");
    }

    public void setWeaponType(WeaponType in) {
        this.getDNAM().wtype = in;
    }

    public WeaponType getWeaponType() {
        return this.getDNAM().wtype;
    }

    public void setSpeed(float speed) {
        this.getDNAM().speed = speed;
    }

    public float getSpeed() {
        return this.getDNAM().speed;
    }

    public void setReach(float reach) {
        this.getDNAM().reach = reach;
    }

    public float getReach() {
        return this.getDNAM().reach;
    }

    public void setSightFOV(float fov) {
        this.getDNAM().sightFOV = fov;
    }

    public float getSightFOV() {
        return this.getDNAM().sightFOV;
    }

    public void setVATS(int vats) {
        this.getDNAM().vats = vats;
    }

    public int getVATS() {
        return this.getDNAM().vats;
    }

    public void setNumProjectiles(int numProj) {
        this.getDNAM().numProjectiles = numProj;
    }

    public int getNumProjectiles() {
        return this.getDNAM().numProjectiles;
    }

    public void setMinRange(float minRange) {
        this.getDNAM().minRange = minRange;
    }

    public float getMinRange() {
        return this.getDNAM().minRange;
    }

    public void setMaxRange(float maxRange) {
        this.getDNAM().maxRange = maxRange;
    }

    public float getMaxRange() {
        return this.getDNAM().maxRange;
    }

    public void setStagger(float stagger) {
        this.getDNAM().stagger = stagger;
    }

    public float getStagger() {
        return this.getDNAM().stagger;
    }

    CRDT getCRDT() {
        return (CRDT)this.subRecords.get("CRDT");
    }

    public void setCritDamage(int critDmg) {
        this.getCRDT().critDmg = critDmg;
    }

    public int getCritDamage() {
        return this.getCRDT().critDmg;
    }

    public void setCritMult(float critMult) {
        this.getCRDT().critMult = critMult;
    }

    public float getCritMult() {
        return this.getCRDT().critMult;
    }

    public void setCritEffectOnDeath(boolean onDeath) {
        this.getCRDT().onDeath = onDeath ? 1 : 0;
    }

    public boolean getCritEffectOnDeath() {
        return this.getCRDT().onDeath != 0;
    }

    public void setCritEffect(FormID critEffect) {
        this.getCRDT().critEffect = critEffect;
    }

    public FormID getCritEffect() {
        return this.getCRDT().critEffect;
    }

    public void set(WeaponFlag flag, boolean on) {
        this.getDNAM().set(flag, on);
    }

    public boolean get(WeaponFlag flag) {
        return this.getDNAM().get(flag);
    }

    public Skill getSkill() {
        return this.getDNAM().getSkill();
    }

    public void setSkill(Skill skill) {
        this.getDNAM().setSkill(skill);
    }

    public SoundVolume getDetectionSoundLevel() {
        return SoundVolume.values()[this.subRecords.getSubInt("VNAM").get()];
    }

    public void setDetectionSoundLevel(SoundVolume level) {
        this.subRecords.setSubInt("VNAM", level.ordinal());
    }

    public void setTemplate(FormID weap) {
        this.subRecords.setSubForm("CNAM", weap);
    }

    public FormID getTemplate() {
        return this.subRecords.getSubForm("CNAM").getForm();
    }

    public boolean isTemplated() {
        return !FormID.NULL.equals(this.getTemplate());
    }

    public WEAP getTemplateTop() {
        if (!this.isTemplated()) {
            return this;
        }
        WEAP template = (WEAP)SPDatabase.getMajor(this.getTemplate(), GRUP_TYPE.WEAP);
        if (template != null) {
            return template.getTemplateTop();
        }
        return null;
    }

    public ArrayList<AltTextures.AltTexture> getAltTextures() {
        return this.subRecords.getModel().getAltTextures();
    }

    public Model getModelData() {
        return this.subRecords.getModel();
    }

    public boolean equalAltTextures(WEAP rhs) {
        return AltTextures.equal(this.getAltTextures(), rhs.getAltTextures());
    }

    public FormID getFirstPersonModel() {
        return this.subRecords.getSubForm("WNAM").getForm();
    }

    public void setFirstPersonModel(FormID id) {
        this.subRecords.setSubForm("WNAM", id);
    }

    public FormID getBlockBashImpactDataSet() {
        return this.subRecords.getSubForm("BIDS").getForm();
    }

    public void setBlockBashImpactDataSet(FormID id) {
        this.subRecords.setSubForm("BIDS", id);
    }

    public FormID getAlternateBlockMaterial() {
        return this.subRecords.getSubForm("BAMT").getForm();
    }

    public void setAlternateBlockMaterial(FormID id) {
        this.subRecords.setSubForm("BAMT", id);
    }

    static final class CRDT
    extends SubRecord {
        int critDmg;
        byte[] unknown0;
        float critMult;
        int onDeath;
        byte[] unknown;
        FormID critEffect = new FormID();

        @Override
        void export(ModExporter out) throws IOException {
            super.export(out);
            out.write(this.critDmg);
            out.write(this.critMult);
            out.write(this.onDeath, 1);
            out.write(this.unknown, 3);
            this.critEffect.export(out);
        }

        @Override
        void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
            super.parseData(in, srcMod);
            this.critDmg = in.extractInt(2);
            this.unknown0 = in.extract(2);
            this.critMult = in.extractFloat();
            this.onDeath = in.extractInt(1);
            this.unknown = in.extract(3);
            this.critEffect.parseData(in, srcMod);
            if (SPGlobal.logMods) {
                CRDT.logMod(srcMod, "", "critDmg: " + this.critDmg + ", critMult: " + this.critMult + ", crit effect: " + this.critEffect);
            }
        }

        @Override
        SubRecord getNew(String type) {
            return new CRDT();
        }

        @Override
        boolean isValid() {
            return true;
        }

        @Override
        int getContentLength(ModExporter out) {
            return 16;
        }

        @Override
        ArrayList<FormID> allFormIDs() {
            ArrayList<FormID> out = new ArrayList<FormID>(1);
            out.add(this.critEffect);
            return out;
        }

        @Override
        ArrayList<String> getTypes() {
            return Record.getTypeList("CRDT");
        }
    }

    static final class DATA
    extends SubRecord {
        int value = 0;
        float weight = 0.0f;
        int damage = 0;

        @Override
        void export(ModExporter out) throws IOException {
            super.export(out);
            out.write(this.value);
            out.write(this.weight);
            out.write(this.damage, 2);
        }

        @Override
        void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
            super.parseData(in, srcMod);
            this.value = in.extractInt(4);
            this.weight = in.extractFloat();
            this.damage = in.extractInt(2);
            if (SPGlobal.logMods) {
                DATA.logMod(srcMod, "", "Value: " + this.value + ", weight: " + this.weight + ", damage: " + this.damage);
            }
        }

        @Override
        SubRecord getNew(String type) {
            return new DATA();
        }

        @Override
        boolean isValid() {
            return true;
        }

        @Override
        int getContentLength(ModExporter out) {
            return 10;
        }

        @Override
        ArrayList<String> getTypes() {
            return Record.getTypeList("DATA");
        }
    }

    static final class DNAM
    extends SubRecord {
        WeaponType wtype;
        byte[] unknown1;
        float speed;
        float reach;
        LFlags flags1 = new LFlags(4);
        float sightFOV;
        byte[] unknown2;
        int vats;
        byte[] attackAnimation;
        int numProjectiles;
        int embeddedWeapActorValue;
        float minRange;
        float maxRange;
        byte[] onHit;
        LFlags flags2 = new LFlags(4);
        float animationAttackMult;
        float unknownFloat;
        float rumbleLeftMotorStrength;
        float rumbleRightMotorStrength;
        float runbleDuration;
        byte[] unknown6;
        int skill;
        byte[] unknown7;
        byte[] resist;
        byte[] unknown8;
        float stagger;

        @Override
        void export(ModExporter out) throws IOException {
            super.export(out);
            out.write(this.wtype.ordinal(), 1);
            out.write(this.unknown1, 3);
            out.write(this.speed);
            out.write(this.reach);
            out.write(this.flags1.export());
            out.write(this.sightFOV);
            out.write(this.unknown2, 4);
            out.write(this.vats, 1);
            out.write(this.attackAnimation, 1);
            out.write(this.numProjectiles, 1);
            out.write(this.embeddedWeapActorValue, 1);
            out.write(this.minRange);
            out.write(this.maxRange);
            out.write(this.onHit, 4);
            out.write(this.flags2.export());
            out.write(this.animationAttackMult);
            out.write(this.unknownFloat);
            out.write(this.rumbleLeftMotorStrength);
            out.write(this.rumbleRightMotorStrength);
            out.write(this.runbleDuration);
            out.write(this.unknown6, 12);
            out.write(this.skill);
            out.write(this.unknown7, 8);
            out.write(this.resist, 4);
            out.write(this.unknown8, 4);
            out.write(this.stagger);
        }

        @Override
        void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
            super.parseData(in, srcMod);
            this.wtype = WeaponType.values()[in.extractInt(1)];
            this.unknown1 = in.extract(3);
            this.speed = in.extractFloat();
            this.reach = in.extractFloat();
            this.flags1.set(in.extract(4));
            this.sightFOV = in.extractFloat();
            this.unknown2 = in.extract(4);
            this.vats = in.extractInt(1);
            this.attackAnimation = in.extract(1);
            this.numProjectiles = in.extractInt(1);
            this.embeddedWeapActorValue = in.extractInt(1);
            this.minRange = in.extractFloat();
            this.maxRange = in.extractFloat();
            this.onHit = in.extract(4);
            this.flags2.set(in.extract(4));
            this.animationAttackMult = in.extractFloat();
            this.unknownFloat = in.extractFloat();
            this.rumbleLeftMotorStrength = in.extractFloat();
            this.rumbleRightMotorStrength = in.extractFloat();
            this.runbleDuration = in.extractFloat();
            this.unknown6 = in.extract(12);
            this.skill = in.extractInt(4);
            this.unknown7 = in.extract(8);
            this.resist = in.extract(4);
            this.unknown8 = in.extract(4);
            this.stagger = in.extractFloat();
            if (SPGlobal.logMods) {
                DNAM.logMod(srcMod, "", "WType: " + (Object)((Object)this.wtype) + ", speed: " + this.speed + ", reach: " + this.reach);
                DNAM.logMod(srcMod, "", "SightFOV: " + this.sightFOV + ", vats: " + this.vats + ", numProjectiles: " + this.numProjectiles);
                DNAM.logMod(srcMod, "", "EmbeddedWeapActorVal: " + this.embeddedWeapActorValue + ", MinRange: " + this.minRange + ", MaxRange: " + this.maxRange);
                DNAM.logMod(srcMod, "", "stagger: " + this.stagger + ", Bound: " + this.get(WeaponFlag.BoundWeapon) + ", Cant Drop: " + this.get(WeaponFlag.CantDrop));
                DNAM.logMod(srcMod, "", "Hide Backpack: " + this.get(WeaponFlag.HideBackpack) + ", Ignore Normal Weapon Resistance: " + this.get(WeaponFlag.IgnoresNormalWeaponResistance) + ", Minor Crime: " + this.get(WeaponFlag.MinorCrime));
                DNAM.logMod(srcMod, "", "NPCs Use Ammo: " + this.get(WeaponFlag.NPCsUseAmmo) + ", No jam after reload: " + this.get(WeaponFlag.NoJamAfterReload) + ", Non Hostile: " + this.get(WeaponFlag.NonHostile));
                DNAM.logMod(srcMod, "", "Non Playable: " + this.get(WeaponFlag.NonPlayable) + ", Not used in normal combat: " + this.get(WeaponFlag.NotUsedInNormalCombat) + ", Player Only: " + this.get(WeaponFlag.PlayerOnly));
            }
        }

        public boolean get(WeaponFlag flag) {
            switch (flag.flagSet) {
                case 0: {
                    return this.flags1.get(flag.value);
                }
                case 1: {
                    return this.flags2.get(flag.value);
                }
            }
            return false;
        }

        public void set(WeaponFlag flag, boolean on) {
            switch (flag.flagSet) {
                case 0: {
                    this.flags1.set(flag.value, on);
                    break;
                }
                case 1: {
                    this.flags2.set(flag.value, on);
                }
            }
        }

        @Override
        SubRecord getNew(String type) {
            return new DNAM();
        }

        @Override
        boolean isValid() {
            return true;
        }

        @Override
        int getContentLength(ModExporter out) {
            return 100;
        }

        @Override
        ArrayList<String> getTypes() {
            return Record.getTypeList("DNAM");
        }

        public Skill getSkill() {
            return Skill.value(this.skill);
        }

        public void setSkill(Skill skill) {
            this.skill = Skill.value(skill);
        }
    }

    public static enum WeaponFlag {
        IgnoresNormalWeaponResistance(1, 0),
        HideBackpack(4, 0),
        NonPlayable(7, 0),
        CantDrop(3, 0),
        PlayerOnly(0, 1),
        NPCsUseAmmo(1, 1),
        NoJamAfterReload(3, 1),
        MinorCrime(4, 1),
        NotUsedInNormalCombat(6, 1),
        NonHostile(8, 1),
        BoundWeapon(13, 1);

        int value;
        int flagSet;

        private WeaponFlag(int value, int flagSet) {
            this.value = value;
            this.flagSet = flagSet;
        }
    }

    public static enum WeaponType {
        HandToHandMelee,
        OneHSword,
        Dagger,
        OneHAxe,
        OneHBlunt,
        TwoHSword,
        TwoHBluntAxe,
        Bow,
        Staff,
        Crossbow;

    }
}

