/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.zip.DataFormatException;
import lev.LImport;
import lev.Ln;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.SPGlobal;
import skyproc.SubData;
import skyproc.SubRecord;
import skyproc.SubRecordTyped;
import skyproc.SubString;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;

class SubStringPointer
extends SubRecordTyped {
    SubData data;
    SubString text;
    Files file;
    boolean forceExport = false;
    static boolean shortNull = true;

    SubStringPointer(String type, Files file) {
        super(type);
        this.data = new SubData(type, new byte[1]);
        this.text = SubString.getNew(type, true);
        this.file = file;
    }

    @Override
    SubRecord getNew(String type) {
        SubStringPointer out = new SubStringPointer(type, this.file);
        out.forceExport = this.forceExport;
        return out;
    }

    void setText(String textIn) {
        this.text.setString(textIn);
    }

    @Override
    boolean isValid() {
        return this.text.isValid() && !this.text.print().equals("") || this.forceExport;
    }

    @Override
    void export(ModExporter out) throws IOException {
        if (this.isValid()) {
            if (out.getExportMod().isFlag(Mod.Mod_Flags.STRING_TABLED)) {
                this.data.setData(Ln.toByteArray((int)out.getExportMod().addOutString(this.text.string, this.file), (int)4));
                this.data.export(out);
            } else if (this.text.isValid()) {
                this.text.export(out);
            } else if (this.forceExport) {
                this.data.setData(0, shortNull ? 1 : 4);
                this.data.export(out);
            }
        }
    }

    @Override
    void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
        this.data.parseData(in, srcMod);
        this.fetchStringPointers(srcMod);
        if (SPGlobal.logMods) {
            SubStringPointer.logMod(srcMod, this.getType(), "Setting " + this.toString() + " to : " + Ln.arrayToString((byte[])this.data.getData()) + " - " + this.toString());
        }
    }

    void fetchStringPointers(Mod srcMod) {
        if (srcMod.isFlag(Mod.Mod_Flags.STRING_TABLED)) {
            Map<Files, LImport> streams = srcMod.stringStreams;
            if (this.data.isValid() && streams.containsKey((Object)this.file)) {
                int index = Ln.arrayToInt((byte[])this.data.getData());
                if (srcMod.stringLocations.get((Object)this.file).containsKey(index)) {
                    int offset = srcMod.stringLocations.get((Object)this.file).get(index);
                    LImport stream = streams.get((Object)this.file);
                    stream.pos((long)offset);
                    switch (this.file) {
                        case STRINGS: {
                            int input;
                            String string = "";
                            while ((input = stream.read()) != 0) {
                                string = String.valueOf(string) + (char)input;
                            }
                            this.text.setString(string);
                            break;
                        }
                        default: {
                            int length = Ln.arrayToInt((int[])stream.extractInts(0, 4));
                            String in = Ln.arrayToString((int[])stream.extractInts(0, length - 1));
                            if (in.equals("")) break;
                            this.text.setString(in);
                        }
                    }
                    if (SPGlobal.logMods && SPGlobal.debugStringPairing) {
                        SubStringPointer.logMod(srcMod, "", (Object)((Object)this.file) + " pointer " + Ln.printHex((byte[])this.data.getData(), (Boolean)true, (Boolean)false) + " set to : " + this.print());
                    }
                } else {
                    if (this.logging() && SPGlobal.debugStringPairing) {
                        boolean nullPtr = true;
                        byte[] byArray = this.data.getData();
                        int n = byArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            byte b = byArray[n2];
                            if (b != 0) {
                                nullPtr = false;
                                break;
                            }
                            ++n2;
                        }
                        if (!nullPtr && SPGlobal.logMods) {
                            SubStringPointer.logMod(srcMod, "", (Object)((Object)this.file) + " pointer " + Ln.printHex((byte[])this.data.getData(), (Boolean)true, (Boolean)false) + " COULD NOT BE PAIRED");
                        }
                    }
                    this.data.setData(0, 1);
                }
            }
        } else {
            this.text.setString(Ln.arrayToString((byte[])this.data.getData()));
        }
    }

    @Override
    public String print() {
        if (this.text.isValid()) {
            return this.text.print();
        }
        return "<NO TEXT>";
    }

    @Override
    int getContentLength(ModExporter out) {
        if (this.isValid()) {
            if (out.getExportMod().isFlag(Mod.Mod_Flags.STRING_TABLED)) {
                return 4;
            }
            if (this.text.isValid()) {
                return this.text.getContentLength(out);
            }
        }
        return shortNull ? 1 : 4;
    }

    @Override
    int getTotalLength(ModExporter out) {
        if (this.isValid() || this.forceExport) {
            return this.getContentLength(out) + this.getHeaderLength();
        }
        return 0;
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Objects.hashCode(this.text);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubStringPointer other = (SubStringPointer)obj;
        return Objects.equals(this.text, other.text);
    }

    static enum Files {
        STRINGS,
        ILSTRINGS,
        DLSTRINGS;

    }
}

