/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.util.zip.DataFormatException;
import lev.LImport;
import lev.Ln;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.SPGlobal;
import skyproc.SubRecord;
import skyproc.SubRecordTyped;
import skyproc.SubStringNonNull;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;

class SubString
extends SubRecordTyped<String> {
    String string;

    static SubString getNew(String type, boolean nullterminated) {
        if (nullterminated) {
            return new SubString(type);
        }
        return new SubStringNonNull(type);
    }

    SubString(String type_) {
        super(type_);
    }

    SubString(String type, String in) {
        this(type);
        this.string = in;
    }

    @Override
    void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
        super.parseData(in, srcMod);
        this.string = Ln.arrayToString((int[])in.extractInts(in.available() - 1));
        if (SPGlobal.logMods) {
            SubString.logMod(srcMod, this.getType().toString(), "Setting " + this.toString() + " to " + this.print());
        }
    }

    @Override
    boolean isValid() {
        return this.string != null;
    }

    public void setString(String input) {
        this.string = input;
    }

    @Override
    public String print() {
        if (this.isValid()) {
            return this.string;
        }
        return "";
    }

    @Override
    int getContentLength(ModExporter out) {
        return this.string.length() + 1;
    }

    @Override
    void export(ModExporter out) throws IOException {
        super.export(out);
        out.write(this.string);
        out.write(0, 1);
    }

    @Override
    SubRecord getNew(String type_) {
        return new SubString(type_);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubString)) {
            return false;
        }
        SubString other = (SubString)obj;
        return !(this.string == null ? other.string != null : !this.string.equals(other.string));
    }

    public boolean equalsIgnoreCase(SubString in) {
        return this.equalsIgnoreCase(in.string);
    }

    public boolean equalsIgnoreCase(String in) {
        return this.string.equalsIgnoreCase(in);
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + (this.string != null ? this.string.hashCode() : 0);
        return hash;
    }

    public int hashUpperCaseCode() {
        int hash = 7;
        hash = 29 * hash + (this.string != null ? this.string.toUpperCase().hashCode() : 0);
        return hash;
    }

    @Override
    String translate() {
        return this.string;
    }

    @Override
    SubRecord<String> translate(String in) {
        SubString out = (SubString)this.getNew(this.getType());
        out.string = in;
        return out;
    }
}

