/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.util.HashMap;
import java.util.Map;
import java.util.zip.DataFormatException;
import lev.LImport;
import lev.LInChannel;
import skyproc.MajorRecord;
import skyproc.Mod;
import skyproc.Record;
import skyproc.RecordShrinkArray;
import skyproc.SPGlobal;
import skyproc.SubPrototype;
import skyproc.SubRecord;
import skyproc.SubRecordsDerived;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;

class SubRecordsStream
extends SubRecordsDerived {
    protected Map<String, RecordLocation> pos = new HashMap<String, RecordLocation>(0);
    MajorRecord major;

    SubRecordsStream(SubPrototype proto) {
        super(proto);
    }

    @Override
    public void setMajor(MajorRecord in) {
        this.major = in;
    }

    @Override
    public boolean shouldExport(String t) {
        if (this.map.containsKey(t)) {
            return this.shouldExport((SubRecord)this.map.get(t));
        }
        if (this.pos.containsKey(t)) {
            SubRecord s = this.get(t);
            return this.shouldExport(s);
        }
        return this.shouldExport(this.prototype.get(t));
    }

    @Override
    public SubRecord get(String in) {
        SubRecord s = null;
        if (this.map.containsKey(in)) {
            s = (SubRecord)this.map.get(in);
        } else if (this.prototype.contains(in)) {
            s = this.createFromPrototype(in);
            try {
                this.loadFromPosition(s);
            }
            catch (DataFormatException | BadParameter | BadRecord ex) {
                SPGlobal.logException(ex);
                return s;
            }
        }
        return s;
    }

    @Override
    public void remove(String in) {
        super.remove(in);
        if (this.pos.containsKey(in)) {
            this.pos.remove(in);
        }
    }

    @Override
    void clear() {
        super.clear();
        this.pos.clear();
    }

    @Override
    void importSubRecords(LImport in, Mod srcMod) throws BadRecord, BadParameter, DataFormatException {
        while (!in.isDone().booleanValue()) {
            this.importSubRecord(in, srcMod);
        }
        int counter = 0;
        String print = "";
        if (SPGlobal.logMods) {
            for (String type : this.getTypes()) {
                RecordLocation r = this.pos.get(type);
                if (r == null) continue;
                print = String.valueOf(print) + type + " [" + r.pos + "](" + r.num + ") ";
                if (++counter != 5) continue;
                SPGlobal.logMod(srcMod, "", print);
                print = "";
                counter = 0;
            }
            if (counter > 0) {
                SPGlobal.logMod(srcMod, "Stream", print);
            }
        }
    }

    @Override
    void importSubRecord(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
        String nextType = Record.getNextType(in);
        if (this.contains(nextType)) {
            if (SPGlobal.streamMode && (in instanceof RecordShrinkArray || in instanceof LInChannel)) {
                String standardType = this.prototype.get(nextType).getType();
                if (!this.pos.containsKey(standardType)) {
                    long position = in.pos();
                    this.pos.put(standardType, new RecordLocation(position));
                } else {
                    ++this.pos.get((Object)standardType).num;
                }
                in.skip(this.prototype.get(nextType).getRecordLength(in));
            } else {
                SubRecord record = this.getSilent(nextType);
                record.parseData(record.extractRecordData(in), srcMod);
            }
        } else {
            throw new BadRecord(String.valueOf(this.getTypes().get(0).toString()) + " doesn't know what to do with a " + nextType.toString() + " record.");
        }
    }

    public SubRecord getSilent(String nextType) {
        if (this.map.containsKey(nextType)) {
            return (SubRecord)this.map.get(nextType);
        }
        return this.createFromPrototype(nextType);
    }

    void loadFromPosition(SubRecord s) throws BadRecord, BadParameter, DataFormatException {
        RecordLocation position;
        if (SPGlobal.streamMode && (position = this.pos.get(s.getType())) != null) {
            try {
                this.major.srcMod.input.pos(position.pos);
                if (SPGlobal.debugStream && SPGlobal.logging() && !this.major.equals(SPGlobal.lastStreamed)) {
                    if (SPGlobal.logMods) {
                        SPGlobal.logMod(this.major.srcMod, "Stream", "Streaming from " + this.major);
                    }
                    SPGlobal.lastStreamed = this.major;
                }
                int i = 0;
                while (i < position.num) {
                    s.parseData(s.extractRecordData((LImport)this.major.srcMod.input), this.major.srcMod);
                    ++i;
                }
                this.pos.remove(s.getType());
            }
            catch (DataFormatException | BadParameter | BadRecord e) {
                SPGlobal.logError("Stream Error", "Error streaming subrecord type " + s.getType() + " from " + this.major);
                throw e;
            }
        }
    }

    protected static class RecordLocation {
        long pos;
        int num = 1;

        RecordLocation(long pos) {
            this.pos = pos;
        }
    }
}

