/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.DataFormatException;
import lev.LImport;
import skyproc.BodyTemplate;
import skyproc.FormID;
import skyproc.KeywordSet;
import skyproc.MajorRecord;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.Model;
import skyproc.RGB;
import skyproc.RGBA;
import skyproc.Record;
import skyproc.ScriptPackage;
import skyproc.SubData;
import skyproc.SubFlag;
import skyproc.SubFloat;
import skyproc.SubForm;
import skyproc.SubFormArray;
import skyproc.SubFormInt;
import skyproc.SubInt;
import skyproc.SubList;
import skyproc.SubMarkerSet;
import skyproc.SubPrototype;
import skyproc.SubRGB;
import skyproc.SubRGBshort;
import skyproc.SubRecord;
import skyproc.SubShell;
import skyproc.SubString;
import skyproc.SubStringPointer;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;

abstract class SubRecords
implements Serializable,
Iterable<SubRecord> {
    protected Map<String, SubRecord> map = new HashMap<String, SubRecord>(0);

    public void setMajor(MajorRecord in) {
    }

    public void setPrototype(SubPrototype proto) {
    }

    public abstract SubPrototype getPrototype();

    public void add(SubRecord r) {
        for (String t : r.getTypes()) {
            this.map.put(t, r);
        }
    }

    protected void export(ModExporter out) throws IOException {
        for (SubRecord s : this) {
            s.export(out);
        }
    }

    void clear() {
        this.map.clear();
    }

    public boolean shouldExport(SubRecord s) {
        return s.isValid();
    }

    public boolean contains(String t) {
        return this.map.containsKey(t);
    }

    public SubRecord get(String in) {
        return this.map.get(in);
    }

    public SubString getSubString(String in) {
        return (SubString)this.get(in);
    }

    public void setSubString(String in, String str) {
        this.getSubString(in).setString(str);
    }

    public SubStringPointer getSubStringPointer(String in) {
        return (SubStringPointer)this.get(in);
    }

    public void setSubStringPointer(String in, String s) {
        this.getSubStringPointer(in).setText(s);
    }

    public SubForm getSubForm(String in) {
        return (SubForm)this.get(in);
    }

    public void setSubForm(String in, FormID id) {
        this.getSubForm(in).setForm(id);
    }

    public SubFloat getSubFloat(String in) {
        return (SubFloat)this.get(in);
    }

    public void setSubFloat(String in, float f) {
        this.getSubFloat(in).set(f);
    }

    public SubData getSubData(String in) {
        return (SubData)this.get(in);
    }

    public void setSubData(String in, byte[] b) {
        this.getSubData(in).setData(b);
    }

    public void setSubData(String in, int i) {
        this.getSubData(in).setData(i);
    }

    public void setSubData(String in, int i, int size) {
        this.getSubData(in).setData(size, size);
    }

    public SubFlag getSubFlag(String in) {
        return (SubFlag)this.get(in);
    }

    public void setSubFlag(String in, int i, boolean b) {
        this.getSubFlag(in).set(i, b);
    }

    public SubInt getSubInt(String in) {
        return (SubInt)this.get(in);
    }

    public void setSubInt(String in, int i) {
        this.getSubInt(in).set(i);
    }

    public SubRGB getSubRGB(String in) {
        return (SubRGB)this.get(in);
    }

    public void setSubRGB(String in, RGB c, float f) {
        this.getSubRGB(in).set(c, f);
    }

    public SubRGBshort getSubRGBshort(String in) {
        return (SubRGBshort)this.get(in);
    }

    public void setSubRGBshort(String in, RGBA c, short val) {
        this.getSubRGBshort(in).set(c, val);
    }

    public SubMarkerSet getSubMarker(String in) {
        return (SubMarkerSet)this.get(in);
    }

    public KeywordSet getKeywords() {
        return (KeywordSet)this.get("KWDA");
    }

    public SubFormArray getSubFormArray(String in) {
        return (SubFormArray)this.get(in);
    }

    public SubList getSubList(String in) {
        return (SubList)this.get(in);
    }

    public ScriptPackage getScripts() {
        return (ScriptPackage)this.get("VMAD");
    }

    public BodyTemplate getBodyTemplate() {
        BodyTemplate b = (BodyTemplate)this.get("BODT");
        if (b == null) {
            b = (BodyTemplate)this.get("BOD2");
        }
        return b;
    }

    public SubShell getSubShell(String t) {
        return (SubShell)this.get(t);
    }

    public SubFormInt getSubFormInt(String t) {
        return (SubFormInt)this.get(t);
    }

    public void setSubFormInt(String t, FormID id, int val) {
        SubFormInt s = this.getSubFormInt(t);
        s.setForm(id);
        s.setNum(val);
    }

    public void setSubFormInt(String t, FormID id) {
        this.getSubFormInt(t).setForm(id);
    }

    public void setSubFormInt(String t, int val) {
        this.getSubFormInt(t).setNum(val);
    }

    public Model getModel() {
        return (Model)this.get("MODL");
    }

    boolean isValid() {
        for (SubRecord s : this) {
            if (s.isValid()) continue;
            return false;
        }
        return true;
    }

    boolean isAnyValid() {
        for (SubRecord s : this) {
            if (!s.isValid()) continue;
            return true;
        }
        return false;
    }

    ArrayList<String> summaryLines() {
        ArrayList<String> out = new ArrayList<String>();
        String header = "Summary: ";
        String data = "";
        int counter = 0;
        ArrayList<String> printedTypes = new ArrayList<String>();
        for (String type : this.getTypes()) {
            SubRecord s = this.map.get(type);
            if (s == null || !s.isValid() || printedTypes.contains(type)) continue;
            data = String.valueOf(data) + type + " ";
            if (s instanceof SubList) {
                data = String.valueOf(data) + "(" + ((SubList)s).size() + ") ";
            }
            printedTypes.addAll(s.getTypes());
            if (counter++ != 12) continue;
            out.add(String.valueOf(header) + data);
            header = "-------- ";
            data = "";
            counter = 0;
        }
        if (counter > 0) {
            out.add(String.valueOf(header) + data);
        }
        return out;
    }

    void importSubRecords(LImport in, Mod srcMod) throws BadRecord, BadParameter, DataFormatException {
        while (!in.isDone().booleanValue()) {
            this.importSubRecord(in, srcMod);
        }
    }

    void importSubRecord(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
        String nextType = Record.getNextType(in);
        SubRecord record = this.get(nextType);
        if (record == null) {
            throw new BadRecord(String.valueOf(this.getTypes().get(0).toString()) + " doesn't know what to do with a " + nextType + " record.");
        }
        record.parseData(record.extractRecordData(in), srcMod);
    }

    public void remove(String in) {
        if (this.map.containsKey(in)) {
            this.map.remove(in);
        }
    }

    public int length(ModExporter out) {
        int length = 0;
        for (SubRecord s : this) {
            length += s.getTotalLength(out);
        }
        return length;
    }

    public abstract ArrayList<String> getTypes();

    public abstract ArrayList<String> getTopLevelTypes();

    public ArrayList<FormID> allFormIDs() {
        ArrayList<FormID> out = new ArrayList<FormID>();
        for (SubRecord s : this) {
            out.addAll(s.allFormIDs());
        }
        return out;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubRecords)) {
            return false;
        }
        SubRecords other = (SubRecords)obj;
        Iterator lhs = this.iterator();
        Iterator rhs = other.iterator();
        while (lhs.hasNext() && rhs.hasNext()) {
            SubRecord lhsNext = (SubRecord)lhs.next();
            SubRecord rhsNext = (SubRecord)rhs.next();
            if ("EDID".equals(lhsNext.getType()) || lhsNext.equals(rhsNext)) continue;
            return false;
        }
        return !lhs.hasNext() && !rhs.hasNext();
    }
}

