/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.util.zip.DataFormatException;
import lev.LImport;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.RGB;
import skyproc.SPGlobal;
import skyproc.SubRecord;
import skyproc.SubRecordTyped;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;

class SubRGB
extends SubRecordTyped {
    float r;
    float g;
    float b;

    SubRGB(String type, float red, float green, float blue) {
        this(type);
        this.r = red;
        this.g = green;
        this.b = blue;
    }

    SubRGB(String type) {
        super(type);
    }

    @Override
    SubRecord getNew(String type) {
        return new SubRGB(type);
    }

    @Override
    int getContentLength(ModExporter out) {
        return 12;
    }

    @Override
    void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
        super.parseData(in, srcMod);
        this.r = in.extractFloat();
        this.g = in.extractFloat();
        this.b = in.extractFloat();
        if (SPGlobal.logMods) {
            SubRGB.logMod(srcMod, this.toString(), "Setting " + this.toString() + " to : " + this.print());
        }
    }

    @Override
    public String print() {
        if (this.isValid()) {
            return "R: " + this.r + " G: " + this.g + " B: " + this.b;
        }
        return super.toString();
    }

    @Override
    void export(ModExporter out) throws IOException {
        if (this.isValid()) {
            super.export(out);
            out.write(this.r);
            out.write(this.g);
            out.write(this.b);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubRGB other = (SubRGB)obj;
        if (Float.floatToIntBits(this.r) != Float.floatToIntBits(other.r)) {
            return false;
        }
        if (Float.floatToIntBits(this.g) != Float.floatToIntBits(other.g)) {
            return false;
        }
        return Float.floatToIntBits(this.b) == Float.floatToIntBits(other.b);
    }

    public int hashCode() {
        int hash = 7;
        hash = 19 * hash + Float.floatToIntBits(this.r);
        hash = 19 * hash + Float.floatToIntBits(this.g);
        hash = 19 * hash + Float.floatToIntBits(this.b);
        return hash;
    }

    public void set(RGB color, float val) {
        switch (color) {
            case Red: {
                this.r = val;
                break;
            }
            case Green: {
                this.g = val;
                break;
            }
            case Blue: {
                this.b = val;
            }
        }
    }

    public float get(RGB color) {
        if (!this.isValid()) {
            return 0.0f;
        }
        switch (color) {
            case Red: {
                return this.r;
            }
            case Green: {
                return this.g;
            }
        }
        return this.b;
    }
}

