/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.DataFormatException;
import lev.LImport;
import skyproc.FormID;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.Record;
import skyproc.SPGlobal;
import skyproc.SubData;
import skyproc.SubRecord;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;

class SubMarkerSet<T extends SubRecord>
extends SubRecord {
    Map<String, T> set = new HashMap<String, T>(2);
    ArrayList<String> markers;
    T prototype;
    boolean forceMarkers = false;
    static String loadedMarker;

    SubMarkerSet(T prototype) {
        this.prototype = prototype;
    }

    SubMarkerSet(T prototype, String ... markers) {
        this.markers = new ArrayList<String>(Arrays.asList(markers));
        this.prototype = prototype;
    }

    @Override
    void export(ModExporter out) throws IOException {
        for (String t : this.markers) {
            SubData marker;
            if (this.set.containsKey(t) && ((SubRecord)this.set.get(t)).isValid()) {
                marker = new SubData(t);
                marker.export(out);
                ((SubRecord)this.set.get(t)).export(out);
                continue;
            }
            if (!this.forceMarkers) continue;
            marker = new SubData(t);
            marker.export(out);
        }
    }

    @Override
    void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
        String next = Record.getNextType(in);
        if (this.markers.contains(next)) {
            if (SPGlobal.logMods) {
                SubMarkerSet.logMod(srcMod, "", "Loaded Marker " + next);
            }
            loadedMarker = next;
        } else {
            if (!this.set.containsKey(loadedMarker)) {
                this.set.put(loadedMarker, ((SubRecord)this.prototype).getNew(next));
            }
            ((SubRecord)this.set.get(loadedMarker)).parseData(in, srcMod);
        }
    }

    @Override
    int getHeaderLength() {
        return 0;
    }

    @Override
    SubRecord getNew(String t) {
        SubMarkerSet<T> out = new SubMarkerSet<T>(this.prototype);
        out.markers = this.markers;
        out.forceMarkers = this.forceMarkers;
        return out;
    }

    @Override
    int getContentLength(ModExporter out) {
        int len = 0;
        for (String t : this.markers) {
            if (this.set.containsKey(t) && ((SubRecord)this.set.get(t)).isValid()) {
                len += 6 + ((SubRecord)this.set.get(t)).getTotalLength(out);
                continue;
            }
            if (!this.forceMarkers) continue;
            len += 6;
        }
        return len;
    }

    public void clear() {
        this.set.clear();
    }

    public T get(String marker) {
        if (!this.set.containsKey(marker)) {
            SubRecord newItem = (SubRecord)((SubRecord)this.prototype).getNew();
            this.set.put(marker, newItem);
        }
        return (T)((SubRecord)this.set.get(marker));
    }

    @Override
    boolean isValid() {
        return true;
    }

    @Override
    ArrayList<FormID> allFormIDs() {
        ArrayList<FormID> out = new ArrayList<FormID>();
        for (SubRecord s : this.set.values()) {
            out.addAll(s.allFormIDs());
        }
        return out;
    }

    @Override
    ArrayList<String> getTypes() {
        ArrayList<String> out = new ArrayList<String>(((Record)this.prototype).getTypes());
        out.addAll(this.markers);
        return out;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubMarkerSet other = (SubMarkerSet)obj;
        for (String marker : this.markers) {
            if (((SubRecord)this.set.get(marker)).equals(other.set.get(marker))) continue;
            return false;
        }
        return true;
    }
}

