/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.DataFormatException;
import lev.LImport;
import lev.Ln;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.SubData;
import skyproc.SubList;
import skyproc.SubRecord;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;

class SubListCounted<T extends SubRecord>
extends SubList {
    String counterType = "";
    private int counterLength = 4;

    SubListCounted(String counter, int counterLength, T prototype_) {
        super(prototype_);
        this.counterType = counter;
        this.counterLength = counterLength;
    }

    SubListCounted(SubListCounted rhs) {
        super(rhs);
        this.counterType = rhs.counterType;
        this.counterLength = rhs.counterLength;
    }

    @Override
    int getContentLength(ModExporter out) {
        int length = super.getContentLength(out);
        if (!"".equals(this.counterType)) {
            length += this.counterLength + 6;
        }
        return length;
    }

    @Override
    void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
        String t = SubListCounted.getNextType(in);
        if (!t.equals(this.counterType)) {
            super.parseData(in, srcMod, t);
        }
    }

    @Override
    SubRecord getNew(String type) {
        return new SubListCounted<T>(this);
    }

    @Override
    void export(ModExporter out) throws IOException {
        if (this.isValid()) {
            if (!"".equals(this.counterType)) {
                SubData counter = new SubData(this.counterType, Ln.toByteArray((int)this.collection.size(), (int)this.counterLength));
                counter.export(out);
            }
            super.export(out);
        }
    }

    @Override
    ArrayList<String> getTypes() {
        ArrayList<String> out = new ArrayList<String>(super.getTypes());
        out.add(this.counterType);
        return out;
    }
}

