/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.util.Objects;
import java.util.zip.DataFormatException;
import lev.LImport;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.SPGlobal;
import skyproc.SubRecord;
import skyproc.SubRecordTyped;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;

class SubInt
extends SubRecordTyped<Integer> {
    private Integer data;
    int length = 4;

    SubInt(String type) {
        super(type);
    }

    SubInt(String type, int length) {
        this(type);
        this.length = length;
    }

    @Override
    SubRecord getNew(String type) {
        return new SubInt(type, this.length);
    }

    @Override
    int getContentLength(ModExporter out) {
        return this.length;
    }

    public void set(int in) {
        this.data = in;
    }

    public int get() {
        if (this.data == null) {
            this.data = 0;
        }
        return this.data;
    }

    @Override
    void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
        super.parseData(in, srcMod);
        this.data = in.extractInt(this.length);
        if (SPGlobal.logMods) {
            SubInt.logMod(srcMod, this.toString(), "Setting " + this.toString() + " to : " + this.print());
        }
    }

    @Override
    public String print() {
        if (this.isValid()) {
            return String.valueOf(this.data);
        }
        return super.toString();
    }

    @Override
    void export(ModExporter out) throws IOException {
        if (this.isValid()) {
            super.export(out);
            out.write(this.data, this.length);
        }
    }

    @Override
    boolean isValid() {
        return this.data != null;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubInt other = (SubInt)obj;
        return Objects.equals(this.data, other.data);
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + Objects.hashCode(this.data);
        return hash;
    }

    @Override
    Integer translate() {
        return this.data;
    }

    @Override
    SubRecord<Integer> translate(Integer in) {
        SubInt out = (SubInt)this.getNew(this.getType());
        out.set(in);
        return out;
    }
}

