/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.DataFormatException;
import lev.LImport;
import skyproc.FormID;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.ModListing;
import skyproc.SubRecord;
import skyproc.SubRecordTyped;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;

public class SubFormInt
extends SubRecordTyped {
    FormID ID = new FormID();
    int num;

    SubFormInt(String in) {
        super(in);
    }

    SubFormInt(String type, FormID id, int number) {
        super(type);
        this.ID = id;
        this.num = number;
    }

    @Override
    void export(ModExporter out) throws IOException {
        super.export(out);
        this.ID.export(out);
        out.write(this.num);
    }

    @Override
    void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
        super.parseData(in, srcMod);
        this.ID.parseData(in, srcMod);
        this.num = in.extractInt(4);
    }

    @Override
    int getContentLength(ModExporter out) {
        return this.ID.getContentLength() + 4;
    }

    @Override
    ArrayList<FormID> allFormIDs() {
        ArrayList<FormID> out = new ArrayList<FormID>(1);
        out.add(this.ID);
        return out;
    }

    @Override
    SubRecord getNew(String type_) {
        return new SubFormInt(type_);
    }

    @Override
    public String print() {
        return "ID: " + this.ID + ", value: " + this.num;
    }

    void copyForm(FormID in) {
        this.ID = new FormID(in);
    }

    public void setForm(FormID id) {
        this.ID = id;
    }

    public String getFormStr() {
        return this.ID.getArrayStr(true);
    }

    public ModListing getFormMaster() {
        return this.ID.getMaster();
    }

    FormID copyOfForm() {
        return new FormID(this.ID);
    }

    public FormID getForm() {
        return this.ID;
    }

    public void setNum(int number) {
        this.num = number;
    }

    public int getNum() {
        return this.num;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubFormInt other = (SubFormInt)obj;
        return this.ID == other.ID || this.ID != null && this.ID.equals(other.ID);
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + (this.ID != null ? this.ID.hashCode() : 0);
        return hash;
    }
}

