/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.util.Objects;
import java.util.zip.DataFormatException;
import lev.LFlags;
import lev.LImport;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.SPGlobal;
import skyproc.SubRecord;
import skyproc.SubRecordTyped;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;

class SubFlag
extends SubRecordTyped {
    LFlags flags;

    SubFlag(String type_, int size) {
        super(type_);
        this.flags = new LFlags(size);
    }

    @Override
    void export(ModExporter out) throws IOException {
        super.export(out);
        out.write(this.flags.export(), this.flags.length());
    }

    @Override
    void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
        super.parseData(in, srcMod);
        this.flags.set(in.getAllBytes());
        if (SPGlobal.logMods) {
            SubFlag.logMod(srcMod, this.toString(), "Setting " + this.toString() + " to : " + this.print());
        }
    }

    void set(int bit, boolean on) {
        this.flags.set(bit, on);
    }

    boolean is(int bit) {
        return this.flags.get(bit);
    }

    @Override
    public String print() {
        return this.flags.toString();
    }

    @Override
    SubRecord getNew(String type) {
        return new SubFlag(type, this.flags.length());
    }

    @Override
    public boolean isValid() {
        return this.flags != null;
    }

    @Override
    int getContentLength(ModExporter out) {
        return this.flags.length();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubFlag other = (SubFlag)obj;
        return Objects.equals(this.flags, other.flags);
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Objects.hashCode(this.flags);
        return hash;
    }
}

