/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.util.Arrays;
import java.util.zip.DataFormatException;
import lev.LImport;
import lev.Ln;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.SubRecord;
import skyproc.SubRecordTyped;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;

class SubData
extends SubRecordTyped<byte[]> {
    byte[] data;

    SubData(String type_) {
        super(type_);
    }

    SubData(String type_, byte[] in) {
        this(type_);
        if (in != null) {
            this.data = new byte[in.length];
            System.arraycopy(in, 0, this.data, 0, in.length);
        }
    }

    SubData(String type_, int in) {
        this(type_, Ln.toByteArray((int)in));
    }

    void initialize(int size) {
        this.data = new byte[size];
    }

    public void modValue(int mod) {
        this.setData(Ln.toByteArray((int)(Ln.arrayToInt((byte[])this.getData()) + mod), (int)this.getData().length));
    }

    @Override
    void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
        super.parseData(in, srcMod);
        this.setData(in.extractAllBytes());
    }

    @Override
    boolean isValid() {
        return this.data != null;
    }

    void setData(byte[] data_) {
        this.data = data_;
    }

    void setData(int data) {
        this.setData(data, 4);
    }

    void setData(int data, int size) {
        this.setData(Ln.toByteArray((int)data, (int)size));
    }

    void setDataAbs(int data, int min, int max) {
        this.setData(Ln.toByteArray((int)Math.abs(data), (int)min, (int)max));
    }

    byte[] getData() {
        return this.data;
    }

    int toInt() {
        return Ln.arrayToInt((byte[])this.data);
    }

    @Override
    public String print() {
        if (this.isValid()) {
            return Ln.printHex((byte[])this.data, (Boolean)true, (Boolean)false);
        }
        return super.toString();
    }

    @Override
    int getContentLength(ModExporter out) {
        if (this.isValid()) {
            return this.data.length;
        }
        return 0;
    }

    @Override
    void export(ModExporter out) throws IOException {
        if (this.data == null) {
            this.data = new byte[0];
        }
        super.export(out);
        out.write(this.data, 0);
    }

    @Override
    SubRecord getNew(String type_) {
        return new SubData(type_, this.data);
    }

    public int hashCode() {
        int hash = 7;
        hash = 23 * hash + Arrays.hashCode(this.data);
        return hash;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof byte[])) {
            return false;
        }
        byte[] b = (byte[])o;
        return Arrays.equals(this.data, b);
    }

    @Override
    byte[] translate() {
        return this.data;
    }

    @Override
    SubRecord<byte[]> translate(byte[] in) {
        return new SubData(this.getType(), in);
    }
}

