/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.zip.DataFormatException;
import lev.LImport;
import skyproc.FormID;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.Record;
import skyproc.SPGlobal;
import skyproc.ScriptProperty;
import skyproc.StringNonNull;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;

public class ScriptRef
extends Record
implements Iterable<String> {
    StringNonNull name = new StringNonNull();
    int unknown = 0;
    ArrayList<ScriptProperty> properties = new ArrayList();

    ScriptRef() {
    }

    public ScriptRef(String name) {
        this.name.set(name);
    }

    ScriptRef(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
        this.parseData(in, srcMod);
    }

    @Override
    final void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
        this.name.set(in.extractString(in.extractInt(2)));
        this.unknown = in.extractInt(1);
        int propertyCount = in.extractInt(2);
        if (SPGlobal.logMods) {
            ScriptRef.logMod(srcMod, "VMAD", "  Script " + this.name.toString() + " with " + propertyCount + " properties. Unknown: " + this.unknown);
        }
        int i = 0;
        while (i < propertyCount) {
            this.properties.add(new ScriptProperty(in, srcMod));
            ++i;
        }
    }

    @Override
    void export(ModExporter out) throws IOException {
        this.name.export(out);
        out.write(this.unknown, 1);
        out.write(this.properties.size(), 2);
        for (ScriptProperty p : this.properties) {
            p.export(out);
        }
    }

    ArrayList<FormID> allFormIDs() {
        ArrayList<FormID> out = new ArrayList<FormID>();
        for (ScriptProperty s : this.properties) {
            out.addAll(s.allFormIDs());
        }
        return out;
    }

    @Override
    boolean isValid() {
        return this.name != null;
    }

    @Override
    public String toString() {
        return this.print();
    }

    @Override
    public String print() {
        return this.name.toString();
    }

    @Override
    ArrayList<String> getTypes() {
        return Record.getTypeList("VMAD");
    }

    @Override
    Record getNew() {
        return new ScriptRef();
    }

    @Override
    int getHeaderLength() {
        return 0;
    }

    @Override
    int getSizeLength() {
        return 0;
    }

    @Override
    int getFluffLength() {
        return 0;
    }

    @Override
    int getContentLength(ModExporter out) {
        int len = this.name.getTotalLength(out) + 3;
        for (ScriptProperty p : this.properties) {
            len += p.getTotalLength(out);
        }
        return len;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScriptRef other = (ScriptRef)obj;
        return this.name == other.name || this.name != null && this.name.equals(other.name);
    }

    public int hashCode() {
        int hash = 7;
        hash = 23 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }

    @Override
    public Iterator<String> iterator() {
        return this.getProperties().iterator();
    }

    public void setName(String name) {
        this.name.set(name);
    }

    public String getName() {
        return this.name.print();
    }

    public ArrayList<String> getProperties() {
        ArrayList<String> out = new ArrayList<String>(this.properties.size());
        for (ScriptProperty p : this.properties) {
            out.add(p.name.data);
        }
        return out;
    }

    void removeProperty(ScriptProperty property) {
        this.properties.remove(property);
    }

    public void removeProperty(String propertyName) {
        this.removeProperty(new ScriptProperty(propertyName, 0));
    }

    void addProperty(String propertyName, boolean booleanProperty) {
        this.properties.add(new ScriptProperty(propertyName, booleanProperty));
    }

    void addProperty(String propertyName, int integerProperty) {
        this.properties.add(new ScriptProperty(propertyName, integerProperty));
    }

    void addProperty(String propertyName, FormID idProperty) {
        this.properties.add(new ScriptProperty(propertyName, idProperty));
    }

    void addProperty(String propertyName, Float floatProperty) {
        this.properties.add(new ScriptProperty(propertyName, floatProperty.floatValue()));
    }

    void addProperty(String propertyName, Integer ... in) {
        this.properties.add(new ScriptProperty(propertyName, in));
    }

    void addProperty(String propertyName, Float ... in) {
        this.properties.add(new ScriptProperty(propertyName, in));
    }

    void addProperty(String propertyName, Boolean ... in) {
        this.properties.add(new ScriptProperty(propertyName, in));
    }

    void addProperty(String propertyName, FormID ... in) {
        this.properties.add(new ScriptProperty(propertyName, in));
    }

    void addProperty(String propertyName, String ... in) {
        this.properties.add(new ScriptProperty(propertyName, in));
    }

    public void setProperty(String propertyName, boolean booleanProperty) {
        this.removeProperty(propertyName);
        this.addProperty(propertyName, booleanProperty);
    }

    public void setProperty(String propertyName, int integerProperty) {
        this.removeProperty(propertyName);
        this.addProperty(propertyName, integerProperty);
    }

    public void setProperty(String propertyName, FormID idProperty) {
        this.removeProperty(propertyName);
        this.addProperty(propertyName, idProperty);
    }

    public void setProperty(String propertyName, float floatProperty) {
        this.removeProperty(propertyName);
        this.addProperty(propertyName, Float.valueOf(floatProperty));
    }

    public void setProperty(String propertyName, Float ... floatProperty) {
        this.removeProperty(propertyName);
        this.addProperty(propertyName, floatProperty);
    }

    public void setProperty(String propertyName, Integer ... intProperty) {
        this.removeProperty(propertyName);
        this.addProperty(propertyName, intProperty);
    }

    public void setProperty(String propertyName, Boolean ... boolProperty) {
        this.removeProperty(propertyName);
        this.addProperty(propertyName, boolProperty);
    }

    public void setProperty(String propertyName, String ... stringProperty) {
        this.removeProperty(propertyName);
        this.addProperty(propertyName, stringProperty);
    }

    public void setProperty(String propertyName, FormID ... formProperty) {
        this.removeProperty(propertyName);
        this.addProperty(propertyName, formProperty);
    }
}

