/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.zip.DataFormatException;
import lev.LImport;
import skyproc.FormID;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.Record;
import skyproc.SPGlobal;
import skyproc.StringNonNull;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;

class ScriptProperty
extends Record
implements Serializable {
    StringNonNull name = new StringNonNull();
    int unknown = 1;
    ScriptData data;

    ScriptProperty() {
    }

    ScriptProperty(String name) {
        this.name.set(name);
    }

    ScriptProperty(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
        this.parseData(in, srcMod);
    }

    public ScriptProperty(String name, boolean b) {
        this(name);
        BooleanData tmp = new BooleanData();
        tmp.data = b;
        this.data = tmp;
    }

    public ScriptProperty(String name, int in) {
        this(name);
        IntData tmp = new IntData();
        tmp.data = in;
        this.data = tmp;
    }

    public ScriptProperty(String name, FormID id) {
        this(name);
        FormIDData tmp = new FormIDData();
        tmp.id = id;
        this.data = tmp;
    }

    public ScriptProperty(String name, float in) {
        this(name);
        FloatData tmp = new FloatData();
        tmp.data = in;
        this.data = tmp;
    }

    public ScriptProperty(String name, Integer ... in) {
        this(name);
        IntegerArrayData tmp = new IntegerArrayData();
        tmp.data = new ArrayList<Integer>(Arrays.asList(in));
        this.data = tmp;
    }

    public ScriptProperty(String name, String ... in) {
        this(name);
        StringArrayData tmp = new StringArrayData();
        tmp.data = new ArrayList<String>(Arrays.asList(in));
        this.data = tmp;
    }

    public ScriptProperty(String name, Float ... in) {
        this(name);
        FloatArrayData tmp = new FloatArrayData();
        tmp.data = new ArrayList<Float>(Arrays.asList(in));
        this.data = tmp;
    }

    public ScriptProperty(String name, Boolean ... in) {
        this(name);
        BoolArrayData tmp = new BoolArrayData();
        tmp.data = new ArrayList<Boolean>(Arrays.asList(in));
        this.data = tmp;
    }

    public ScriptProperty(String name, FormID ... in) {
        this(name);
        FormArrayData tmp = new FormArrayData();
        ArrayList<FormIDData> list = new ArrayList<FormIDData>(in.length);
        FormID[] formIDArray = in;
        int n = in.length;
        int n2 = 0;
        while (n2 < n) {
            FormID id = formIDArray[n2];
            list.add(new FormIDData(id));
            ++n2;
        }
        tmp.data = list;
        this.data = tmp;
    }

    ArrayList<FormID> allFormIDs() {
        ArrayList<FormID> out = new ArrayList<FormID>();
        if (this.getPropertyType().equals((Object)ScriptPropertyType.FormID)) {
            out.add(((FormIDData)this.data).id);
        } else if (this.getPropertyType().equals((Object)ScriptPropertyType.FormIDArr)) {
            FormArrayData arr = (FormArrayData)this.data;
            for (FormIDData id : arr.data) {
                out.add(id.id);
            }
        }
        return out;
    }

    @Override
    final void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
        this.name.set(in.extractString(in.extractInt(2)));
        ScriptPropertyType type = ScriptPropertyType.value(in.extractInt(1));
        this.unknown = in.extractInt(1);
        if (SPGlobal.logMods) {
            ScriptProperty.logMod(srcMod, "VMAD", "    Property " + this.name + " with type " + (Object)((Object)type) + ", unknown: " + this.unknown);
        }
        switch (type) {
            case FormID: {
                this.data = new FormIDData();
                break;
            }
            case String: {
                this.data = new StringData();
                break;
            }
            case Integer: {
                this.data = new IntData();
                break;
            }
            case Float: {
                this.data = new FloatData();
                break;
            }
            case Boolean: {
                this.data = new BooleanData();
                break;
            }
            case FormIDArr: {
                this.data = new FormArrayData();
                break;
            }
            case StringArr: {
                this.data = new StringArrayData();
                break;
            }
            case IntegerArr: {
                this.data = new IntegerArrayData();
                break;
            }
            case FloatArr: {
                this.data = new FloatArrayData();
                break;
            }
            case BooleanArr: {
                this.data = new BoolArrayData();
                break;
            }
            default: {
                if (this.logging()) {
                    this.logError("VMAD", "    Importing property with UNKNOWN TYPE!");
                }
                if (SPGlobal.logMods) {
                    ScriptProperty.logMod(srcMod, "VMAD", "    Importing property with UNKNOWN TYPE!");
                }
                in.extractInts(1000);
            }
        }
        if (this.data != null) {
            this.data.parseData(in, srcMod);
        }
        if (SPGlobal.logMods) {
            ScriptProperty.logMod(srcMod, "VMAD", "      Data: " + this.data.print());
        }
    }

    @Override
    void export(ModExporter out) throws IOException {
        this.name.export(out);
        out.write(this.getPropertyType().value, 1);
        out.write(this.unknown, 1);
        this.data.export(out);
    }

    @Override
    boolean isValid() {
        return this.name != null;
    }

    @Override
    public String toString() {
        return "VMADproperty " + this.name;
    }

    @Override
    public String print() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    ArrayList<String> getTypes() {
        return Record.getTypeList("VMAD");
    }

    @Override
    Record getNew() {
        return new ScriptProperty();
    }

    @Override
    int getHeaderLength() {
        return 0;
    }

    @Override
    int getSizeLength() {
        return 0;
    }

    @Override
    int getFluffLength() {
        return 0;
    }

    @Override
    int getContentLength(ModExporter out) {
        int len = this.name.getTotalLength(out) + 2;
        return len + this.data.getContentLength();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScriptProperty other = (ScriptProperty)obj;
        return this.name == other.name || this.name != null && this.name.equals(other.name);
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }

    public ScriptPropertyType getPropertyType() {
        return this.data.getType();
    }

    class BoolArrayData
    implements ScriptData,
    Serializable {
        ArrayList<Boolean> data;

        BoolArrayData() {
        }

        @Override
        public void parseData(LImport in, Mod srcMod) {
            int size = in.extractInt(4);
            this.data = new ArrayList(size);
            int i = 0;
            while (i < size) {
                this.data.add(in.extractBool(1));
                ++i;
            }
        }

        @Override
        public int getContentLength() {
            return this.data.size() + 4;
        }

        @Override
        public void export(ModExporter out) throws IOException {
            out.write(this.data.size());
            for (Boolean i : this.data) {
                if (i.booleanValue()) {
                    out.write(1, 1);
                    continue;
                }
                out.write(0, 1);
            }
        }

        @Override
        public ScriptPropertyType getType() {
            return ScriptPropertyType.BooleanArr;
        }

        @Override
        public String print() {
            String out = "";
            for (Boolean i : this.data) {
                out = String.valueOf(out) + i + " ";
            }
            return out;
        }
    }

    class BooleanData
    implements ScriptData,
    Serializable {
        boolean data;

        BooleanData() {
        }

        @Override
        public void parseData(LImport in, Mod srcMod) {
            this.data = in.extractBool(1);
        }

        @Override
        public int getContentLength() {
            return 1;
        }

        @Override
        public void export(ModExporter out) throws IOException {
            if (this.data) {
                out.write(1, 1);
            } else {
                out.write(0, 1);
            }
        }

        @Override
        public ScriptPropertyType getType() {
            return ScriptPropertyType.Boolean;
        }

        @Override
        public String print() {
            return String.valueOf(this.data);
        }
    }

    class FloatArrayData
    implements ScriptData,
    Serializable {
        ArrayList<Float> data;

        FloatArrayData() {
        }

        @Override
        public void parseData(LImport in, Mod srcMod) {
            int size = in.extractInt(4);
            this.data = new ArrayList(size);
            int i = 0;
            while (i < size) {
                this.data.add(Float.valueOf(in.extractFloat()));
                ++i;
            }
        }

        @Override
        public int getContentLength() {
            return this.data.size() * 4 + 4;
        }

        @Override
        public void export(ModExporter out) throws IOException {
            out.write(this.data.size());
            for (Float i : this.data) {
                out.write(i.floatValue());
            }
        }

        @Override
        public ScriptPropertyType getType() {
            return ScriptPropertyType.FloatArr;
        }

        @Override
        public String print() {
            String out = "";
            for (Float i : this.data) {
                out = String.valueOf(out) + i + " ";
            }
            return out;
        }
    }

    class FloatData
    implements ScriptData,
    Serializable {
        float data;

        FloatData() {
        }

        @Override
        public void parseData(LImport in, Mod srcMod) {
            this.data = in.extractFloat();
        }

        @Override
        public int getContentLength() {
            return 4;
        }

        @Override
        public void export(ModExporter out) throws IOException {
            out.write(this.data);
        }

        @Override
        public ScriptPropertyType getType() {
            return ScriptPropertyType.Float;
        }

        @Override
        public String print() {
            return String.valueOf(this.data);
        }
    }

    class FormArrayData
    implements ScriptData,
    Serializable {
        ArrayList<FormIDData> data;

        FormArrayData() {
        }

        @Override
        public void parseData(LImport in, Mod srcMod) {
            int size = in.extractInt(4);
            this.data = new ArrayList(size);
            int i = 0;
            while (i < size) {
                FormIDData id = new FormIDData();
                id.parseData(in, srcMod);
                this.data.add(id);
                ++i;
            }
        }

        @Override
        public int getContentLength() {
            return this.data.size() * 8 + 4;
        }

        @Override
        public void export(ModExporter out) throws IOException {
            out.write(this.data.size());
            for (FormIDData i : this.data) {
                i.export(out);
            }
        }

        @Override
        public ScriptPropertyType getType() {
            return ScriptPropertyType.FormIDArr;
        }

        @Override
        public String print() {
            String out = "";
            for (FormIDData i : this.data) {
                out = String.valueOf(out) + i.print() + " ";
            }
            return out;
        }
    }

    class FormIDData
    implements ScriptData,
    Serializable {
        byte[] data = new byte[4];
        FormID id;

        FormIDData() {
            this.data[2] = -1;
            this.data[3] = -1;
        }

        FormIDData(FormID in) {
            this();
            this.id = in;
        }

        @Override
        public void parseData(LImport in, Mod srcMod) {
            this.data = in.extract(4);
            this.id = new FormID();
            this.id.parseData(in, srcMod);
        }

        @Override
        public int getContentLength() {
            return 8;
        }

        @Override
        public void export(ModExporter out) throws IOException {
            out.write(this.data, 4);
            this.id.export(out);
        }

        @Override
        public ScriptPropertyType getType() {
            return ScriptPropertyType.FormID;
        }

        @Override
        public String print() {
            return this.id.toString();
        }
    }

    class IntData
    implements ScriptData,
    Serializable {
        int data;

        IntData() {
        }

        @Override
        public void parseData(LImport in, Mod srcMod) {
            this.data = in.extractInt(4);
        }

        @Override
        public int getContentLength() {
            return 4;
        }

        @Override
        public void export(ModExporter out) throws IOException {
            out.write(this.data);
        }

        @Override
        public ScriptPropertyType getType() {
            return ScriptPropertyType.Integer;
        }

        @Override
        public String print() {
            return Integer.toString(this.data);
        }
    }

    class IntegerArrayData
    implements ScriptData,
    Serializable {
        ArrayList<Integer> data;

        IntegerArrayData() {
        }

        @Override
        public void parseData(LImport in, Mod srcMod) {
            int size = in.extractInt(4);
            this.data = new ArrayList(size);
            int i = 0;
            while (i < size) {
                this.data.add(in.extractInt(4));
                ++i;
            }
        }

        @Override
        public int getContentLength() {
            return this.data.size() * 4 + 4;
        }

        @Override
        public void export(ModExporter out) throws IOException {
            out.write(this.data.size());
            for (Integer i : this.data) {
                out.write(i);
            }
        }

        @Override
        public ScriptPropertyType getType() {
            return ScriptPropertyType.IntegerArr;
        }

        @Override
        public String print() {
            String out = "";
            for (Integer i : this.data) {
                out = String.valueOf(out) + i + " ";
            }
            return out;
        }
    }

    static interface ScriptData {
        public void parseData(LImport var1, Mod var2);

        public int getContentLength();

        public void export(ModExporter var1) throws IOException;

        public ScriptPropertyType getType();

        public String print();
    }

    public static enum ScriptPropertyType {
        Unknown(0),
        FormID(1),
        String(2),
        Integer(3),
        Float(4),
        Boolean(5),
        FormIDArr(11),
        StringArr(12),
        IntegerArr(13),
        FloatArr(14),
        BooleanArr(15);

        int value;

        private ScriptPropertyType(int value) {
            this.value = value;
        }

        static ScriptPropertyType value(int value) {
            ScriptPropertyType[] scriptPropertyTypeArray = ScriptPropertyType.values();
            int n = scriptPropertyTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ScriptPropertyType p = scriptPropertyTypeArray[n2];
                if (p.value == value) {
                    return p;
                }
                ++n2;
            }
            return Unknown;
        }
    }

    class StringArrayData
    implements ScriptData,
    Serializable {
        ArrayList<String> data;

        StringArrayData() {
        }

        @Override
        public void parseData(LImport in, Mod srcMod) {
            int size = in.extractInt(4);
            this.data = new ArrayList(size);
            int i = 0;
            while (i < size) {
                int stringSize = in.extractInt(2);
                this.data.add(in.extractString(stringSize));
                ++i;
            }
        }

        @Override
        public int getContentLength() {
            int out = this.data.size() * 2 + 4;
            for (String s : this.data) {
                out += s.length();
            }
            return out;
        }

        @Override
        public void export(ModExporter out) throws IOException {
            out.write(this.data.size());
            for (String i : this.data) {
                out.write(i.length(), 2);
                out.write(i);
            }
        }

        @Override
        public ScriptPropertyType getType() {
            return ScriptPropertyType.StringArr;
        }

        @Override
        public String print() {
            String out = "";
            for (String i : this.data) {
                out = String.valueOf(out) + i + " ";
            }
            return out;
        }
    }

    class StringData
    implements ScriptData,
    Serializable {
        String data;

        StringData() {
        }

        @Override
        public void parseData(LImport in, Mod srcMod) {
            this.data = in.extractString(in.extractInt(2));
        }

        @Override
        public int getContentLength() {
            return 2 + this.data.length();
        }

        @Override
        public void export(ModExporter out) throws IOException {
            out.write(this.data.length(), 2);
            out.write(this.data);
        }

        @Override
        public ScriptPropertyType getType() {
            return ScriptPropertyType.String;
        }

        @Override
        public String print() {
            return this.data;
        }
    }
}

