/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import lev.debug.LDebug;
import lev.debug.LLogger;
import skyproc.BSA;
import skyproc.Consistency;
import skyproc.Mod;

class SPLogger
extends LLogger {
    Map<Mod, LDebug> modImports = new HashMap<Mod, LDebug>();
    int modNum = 0;

    public ArrayList<LDebug> allDebugs() {
        ArrayList out = super.allDebugs();
        out.addAll(this.modImports.values());
        return out;
    }

    public SPLogger(String in) {
        super(in);
        this.addSpecial(SpecialTypes.BLOCKED, "Blocked Records.txt");
        this.addSpecial(Consistency.LogTypes.CONSISTENCY, String.valueOf(Consistency.debugFolder) + "Requests.txt");
        this.addSpecial(BSA.LogTypes.BSA, "BSA.txt");
    }

    public void logMod(Mod srcMod, String header, String ... data) {
        LDebug log = this.modImports.get(srcMod);
        if (log == null) {
            log = new LDebug(String.valueOf(this.debugPath) + "Mod Import/" + this.modNum++ + " - " + srcMod.getName() + ".txt", 40);
            this.modImports.put(srcMod, log);
        }
        log.w(header, data);
    }

    public static enum SpecialTypes {
        BLOCKED;

    }
}

