/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.DataFormatException;
import lev.LFlags;
import lev.LImport;
import lev.LInChannel;
import lev.LShrinkArray;
import lev.Ln;
import skyproc.BSA;
import skyproc.Consistency;
import skyproc.GRUP_TYPE;
import skyproc.MajorRecord;
import skyproc.Mod;
import skyproc.ModListing;
import skyproc.RecordFileChannel;
import skyproc.RecordShrinkArray;
import skyproc.SPDatabase;
import skyproc.SPGlobal;
import skyproc.SubStringPointer;
import skyproc.exceptions.BadMod;
import skyproc.exceptions.MissingMaster;
import skyproc.gui.SPProgressBarPlug;

public class SPImporter {
    private static String header = "Importer";
    private static String debugPath = "Mod Import/";

    public static void runBackgroundImport() {
        new Thread(new StartImportThread()).start();
    }

    public static ArrayList<ModListing> getActiveModList() throws IOException {
        if (SPDatabase.activePlugins.isEmpty()) {
            SPGlobal.sync(true);
            SPGlobal.newSyncLog("Get Active Mod List.txt");
            String header = "IMPORT MODS";
            String dataFolder = SPGlobal.getPluginsTxt();
            BufferedReader ModFile = new BufferedReader(new FileReader(dataFolder));
            try {
                String line = ModFile.readLine();
                ArrayList<String> lines = new ArrayList<String>();
                SPGlobal.logSync(header, "Loading in Active Plugins");
                if (SPGlobal.gameName.equals("Skyrim")) {
                    lines.add("Skyrim.esm");
                    lines.add("Update.esm");
                }
                while (line != null) {
                    if (line.indexOf("#") >= 0) {
                        line = line.substring(0, line.indexOf("#"));
                    }
                    if (!(line = line.trim()).equals("")) {
                        File pluginName = new File(String.valueOf(SPGlobal.pathToData) + line);
                        ModListing nextMod = new ModListing(line);
                        if (SPGlobal.noModsAfter && nextMod.equals(SPGlobal.getGlobalPatch().getInfo())) {
                            SPGlobal.logSync(header, "Skipping the remaining mods as they were after the patch.");
                            break;
                        }
                        if (SPGlobal.shouldImport(nextMod) && SPGlobal.shouldImport(line)) {
                            if (pluginName.isFile()) {
                                if (Ln.indexOfIgnoreCase(lines, (String)line) == -1) {
                                    SPGlobal.logSync(header, "Adding mod: " + line);
                                    lines.add(line);
                                } else if (SPGlobal.logging()) {
                                    SPGlobal.logSync(header, "Mod was already added: ", line);
                                }
                            } else if (SPGlobal.logging()) {
                                SPGlobal.logSync(header, "Mod didn't exist: ", line);
                            }
                        } else if (SPGlobal.logging()) {
                            SPGlobal.logSync(header, "Mod was on the list to skip: " + line);
                        }
                    }
                    line = ModFile.readLine();
                }
                SPGlobal.sync(false);
                SPDatabase.activePlugins = SPImporter.sortModListings(lines);
            }
            catch (FileNotFoundException e) {
                SPGlobal.logException(e);
                SPGlobal.sync(false);
                throw e;
            }
            catch (IOException e) {
                SPGlobal.logException(e);
                SPGlobal.sync(false);
                throw e;
            }
        }
        return SPDatabase.activePlugins;
    }

    public static ArrayList<ModListing> getModList() {
        SPGlobal.newSyncLog("Get All Present Mod List.txt");
        File directory = new File(SPGlobal.pathToData);
        ArrayList<String> out = new ArrayList<String>();
        if (directory.isDirectory()) {
            File[] files;
            File[] fileArray = files = directory.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                String name = f.getName().toUpperCase();
                if (name.contains(".ESP") || name.contains(".ESM")) {
                    if (!SPGlobal.modsToSkip.contains(new ModListing(f.getName()))) {
                        out.add(f.getName());
                    } else if (SPGlobal.logging()) {
                        SPGlobal.logSync(header, "Mod was on the list to skip: " + name);
                    }
                }
                ++n2;
            }
        }
        return SPImporter.sortModListings(out);
    }

    static ArrayList<ModListing> sortModListings(ArrayList<String> lines) {
        SPGlobal.sync(true);
        ArrayList<String> esms = new ArrayList<String>();
        ArrayList<String> esps = new ArrayList<String>();
        for (String line : lines) {
            try {
                RecordFileChannel input = new RecordFileChannel(String.valueOf(SPGlobal.pathToData) + line);
                ModListing tempListing = new ModListing(line);
                Mod plugin = new Mod(tempListing, SPImporter.extractHeaderInfo(input));
                if (plugin.isFlag(Mod.Mod_Flags.MASTER)) {
                    esms.add(line);
                    continue;
                }
                esps.add(line);
            }
            catch (Exception e) {
                if (SPGlobal.logging()) {
                    SPGlobal.logSync(header, "Could not read mod file: " + line + ", Sorting based on extension.");
                }
                if (line.toUpperCase().contains(".ESM")) {
                    esms.add(line);
                    continue;
                }
                esps.add(line);
            }
        }
        SPGlobal.flush();
        ArrayList<ModListing> listing = new ArrayList<ModListing>();
        for (String m : esms) {
            listing.add(new ModListing(m));
        }
        for (String m : esps) {
            listing.add(new ModListing(m));
        }
        if (SPGlobal.logging()) {
            SPGlobal.logSync(header, "=========  Final sorted load order : ==========");
            int counter = 0;
            for (ModListing m : listing) {
                SPGlobal.logSync(header, String.valueOf(Ln.prettyPrintHex((int)counter++)) + " Name: " + m.print());
            }
        }
        SPGlobal.sync(false);
        return listing;
    }

    public static Set<Mod> importAllMods() throws MissingMaster, BadMod {
        return SPImporter.importAllMods(GRUP_TYPE.values());
    }

    public static Set<Mod> importAllMods(GRUP_TYPE ... grup_targets) throws MissingMaster, BadMod {
        return SPImporter.importMods(SPImporter.getModList(), SPGlobal.pathToData, grup_targets);
    }

    public static Set<Mod> importAllMods(ArrayList<GRUP_TYPE> grup_targets) throws MissingMaster, BadMod {
        GRUP_TYPE[] tmp = new GRUP_TYPE[]{};
        return SPImporter.importMods(SPImporter.getModList(), SPGlobal.pathToData, grup_targets.toArray(tmp));
    }

    public static Set<Mod> importActiveMods() throws IOException, MissingMaster, BadMod {
        return SPImporter.importActiveMods(GRUP_TYPE.values());
    }

    public static Set<Mod> importActiveMods(GRUP_TYPE ... grup_targets) throws IOException, MissingMaster, BadMod {
        return SPImporter.importMods(SPImporter.getActiveModList(), SPGlobal.pathToData, grup_targets);
    }

    public static Set<Mod> importActiveMods(ArrayList<GRUP_TYPE> grup_targets) throws IOException, MissingMaster, BadMod {
        GRUP_TYPE[] tmp = new GRUP_TYPE[]{};
        return SPImporter.importMods(SPImporter.getActiveModList(), SPGlobal.pathToData, grup_targets.toArray(tmp));
    }

    public static Set<Mod> importMods(ArrayList<ModListing> mods, GRUP_TYPE ... grup_targets) throws MissingMaster, BadMod {
        return SPImporter.importMods(mods, SPGlobal.pathToData, grup_targets);
    }

    public static Set<Mod> importMods(ArrayList<ModListing> mods, ArrayList<GRUP_TYPE> grup_targets) throws MissingMaster, BadMod {
        GRUP_TYPE[] tmp = new GRUP_TYPE[]{};
        return SPImporter.importMods(mods, SPGlobal.pathToData, grup_targets.toArray(tmp));
    }

    public static Set<Mod> importMods(ArrayList<ModListing> mods) throws MissingMaster, BadMod {
        return SPImporter.importMods(mods, SPGlobal.pathToData, GRUP_TYPE.values());
    }

    public static Set<Mod> importMods(ArrayList<ModListing> mods, String path) throws MissingMaster, BadMod {
        return SPImporter.importMods(mods, path, GRUP_TYPE.values());
    }

    public static Set<Mod> importMods(ArrayList<ModListing> mods, String path, GRUP_TYPE ... grup_targets) throws MissingMaster, BadMod {
        if (grup_targets.length == 0) {
            SPGlobal.logMain(header, "Skipping import because requests were empty.");
            return new HashSet<Mod>(0);
        }
        if (SPGlobal.logging()) {
            SPGlobal.logMain(header, "Starting import of targets: ");
            String grups = "";
            GRUP_TYPE[] gRUP_TYPEArray = grup_targets;
            int n = grup_targets.length;
            int n2 = 0;
            while (n2 < n) {
                GRUP_TYPE g = gRUP_TYPEArray[n2];
                grups = String.valueOf(grups) + "   " + g.toString() + " ";
                ++n2;
            }
            SPGlobal.logMain(header, grups);
            SPGlobal.logMain(header, "In mods: ");
            for (ModListing m : mods) {
                SPGlobal.logMain(header, "   " + m.print());
            }
        }
        String header = "Import Mods";
        TreeSet<Mod> outSet = new TreeSet<Mod>();
        SPProgressBarPlug.setMax(mods.size(), "Importing plugins.");
        int i = 0;
        while (i < mods.size()) {
            String mod = mods.get(i).print();
            SPProgressBarPlug.setStatusNumbered(SPImporter.genStatus(mods.get(i)));
            if (!SPGlobal.modsToSkip.contains(new ModListing(mod))) {
                outSet.add(SPImporter.importMod(new ModListing(mod), i, path, true, grup_targets));
            } else {
                SPProgressBarPlug.setStatusNumbered(String.valueOf(SPImporter.genStatus(mods.get(i))) + ": Skipped!");
            }
            SPProgressBarPlug.incrementBar();
            ++i;
        }
        if (SPGlobal.logging()) {
            SPGlobal.logMain(header, "Done Importing Mods.");
        }
        System.gc();
        return outSet;
    }

    public static Mod importMod(ModListing listing, String path, GRUP_TYPE ... grup_targets) throws BadMod, MissingMaster {
        return SPImporter.importMod(listing, 1000, path, true, grup_targets);
    }

    static Mod importMod(ModListing listing, int index, String path, Boolean addtoDb, GRUP_TYPE ... grup_targets) throws BadMod, MissingMaster {
        if (!Consistency.isImported()) {
            Consistency.importConsistency(true);
        }
        SPGlobal.sync(true);
        try {
            RecordFileChannel input = new RecordFileChannel(String.valueOf(path) + listing.print());
            Mod plugin = new Mod(listing, SPImporter.extractHeaderInfo(input));
            if (SPGlobal.logMods) {
                SPGlobal.logMod(plugin, header, "Opened filestream to mod: " + listing.print());
            }
            if (SPGlobal.checkMissingMasters) {
                SPImporter.checkMissingMasters(plugin);
            }
            plugin.input = input;
            if (SPGlobal.streamMode) {
                plugin.input = input;
            }
            if (plugin.isFlag(Mod.Mod_Flags.STRING_TABLED)) {
                SPImporter.importStringLocations(plugin);
                plugin.openStringStreams();
            }
            GRUPIterator iter = new GRUPIterator(grup_targets, input);
            while (iter.hasNext()) {
                String result = iter.loading();
                SPProgressBarPlug.setStatusNumbered(String.valueOf(SPImporter.genStatus(listing)) + ": " + result);
                if (SPGlobal.logMods) {
                    SPGlobal.logMod(plugin, header, "================== Loading in GRUP " + result + ": ", plugin.getName(), " ===================");
                }
                plugin.parseData(result, (LImport)iter.next());
                SPGlobal.flush();
            }
            if (addtoDb.booleanValue()) {
                SPDatabase.add(plugin);
            }
            if (!SPGlobal.streamMode) {
                input.close();
            }
            SPProgressBarPlug.setStatusNumbered(String.valueOf(SPImporter.genStatus(listing)) + ": Done");
            Mod mod = plugin;
            return mod;
        }
        catch (MissingMaster m) {
            throw m;
        }
        catch (Exception e) {
            SPGlobal.logException(e);
            throw new BadMod("Ran into an exception, check SPGlobal.logs for more details.", e, listing);
        }
        finally {
            SPGlobal.sync(false);
        }
    }

    public static Mod importMod(ModListing listing, GRUP_TYPE ... grup_targets) throws BadMod, MissingMaster {
        return SPImporter.importMod(listing, SPGlobal.pathToData, grup_targets);
    }

    static void checkMissingMasters(Mod plugin) throws MissingMaster, IOException {
        ArrayList<ModListing> notinstalled = new ArrayList<ModListing>();
        ArrayList<ModListing> inactive = new ArrayList<ModListing>();
        ArrayList<ModListing> loadedafter = new ArrayList<ModListing>();
        int failedmasters = 0;
        for (ModListing master : plugin.getMasters()) {
            Mod masterMod;
            try {
                RecordFileChannel input = new RecordFileChannel(String.valueOf(SPGlobal.pathToData) + master.print());
                ModListing tempListing = new ModListing(master.print());
                masterMod = new Mod(tempListing, SPImporter.extractHeaderInfo(input));
            }
            catch (Exception exception) {
                notinstalled.add(master);
                ++failedmasters;
                continue;
            }
            if (!SPImporter.getActiveModList().contains(masterMod.modInfo)) {
                inactive.add(master);
                ++failedmasters;
                continue;
            }
            if (SPDatabase.getMod(masterMod.modInfo) != null) continue;
            loadedafter.add(master);
            ++failedmasters;
        }
        if (failedmasters > 0) {
            String errormessage = "The plugin '" + plugin.getName() + "' has " + "missing masters:\r\n\r\n";
            for (ModListing failedmod : notinstalled) {
                errormessage = String.valueOf(errormessage) + "    -'" + failedmod.print() + "' is not installed\r\n";
            }
            for (ModListing failedmod : inactive) {
                errormessage = String.valueOf(errormessage) + "    -'" + failedmod.print() + "' is installed, but not activated\r\n";
            }
            for (ModListing failedmod : loadedafter) {
                errormessage = String.valueOf(errormessage) + "    -'" + failedmod.print() + "' is loaded after the mod depending on it\r\n";
            }
            throw new MissingMaster(errormessage, plugin.getInfo(), notinstalled, inactive, loadedafter);
        }
    }

    public static DirtyParsingIterator getSubRecordsInGRUPs(String typeString, String ... grups) {
        return new DirtyParsingIterator(typeString, grups);
    }

    public static DirtyParsingIterator getSubRecordsInGRUPs(ModListing targetMod, String typeString, String ... grups) {
        return new DirtyParsingIterator(targetMod, typeString, grups);
    }

    static ByteBuffer extractHeaderInfo(LInChannel in) {
        if (Ln.arrayToString((int[])in.extractInts(0, 4)).equals("TES4")) {
            int size = Ln.arrayToInt((int[])in.extractInts(0, 4)) + 24;
            in.skip(-8);
            return in.extractByteBuffer(0, size);
        }
        return ByteBuffer.allocate(0);
    }

    static void importStringLocations(Mod mod) {
        String header = "Importing Strings";
        if (SPGlobal.logMods) {
            SPGlobal.logMod(mod, header, "Importing Strings");
        }
        SubStringPointer.Files[] filesArray = SubStringPointer.Files.values();
        int n = filesArray.length;
        int n2 = 0;
        while (n2 < n) {
            SubStringPointer.Files f = filesArray[n2];
            try {
                SPImporter.importStringLocations(mod, f);
            }
            catch (IOException | DataFormatException e) {
                SPGlobal.logError(header, "Error Importing Strings " + (Object)((Object)f) + ": " + e);
            }
            ++n2;
        }
    }

    static void importStringLocations(Mod plugin, SubStringPointer.Files file) throws FileNotFoundException, IOException, DataFormatException {
        ArrayList<SPGlobal.Language> languageList = new ArrayList<SPGlobal.Language>();
        languageList.add(SPGlobal.language);
        languageList.addAll(Arrays.asList(SPGlobal.Language.values()));
        LShrinkArray in = null;
        int numRecords = 0;
        int recordsSize = 0;
        for (SPGlobal.Language l : languageList) {
            String strings = SPImporter.getStringFilePath(plugin, l, file);
            File stringsFile = new File(String.valueOf(SPGlobal.pathToData) + strings);
            if (stringsFile.isFile()) {
                LInChannel istream = new LInChannel(stringsFile);
                numRecords = istream.extractInt(0, 4);
                recordsSize = numRecords * 8 + 8;
                in = new LShrinkArray(istream.extractByteBuffer(4, recordsSize));
            } else {
                for (BSA theBSA : BSA.getPluginBSAs()) {
                    theBSA.loadFolders();
                    if (!theBSA.hasFile(strings)) continue;
                    in = theBSA.getFile(strings);
                    numRecords = in.extractInt(4);
                    recordsSize = numRecords * 8 + 8;
                    in.skip(4);
                    break;
                }
                if (in == null) {
                    for (BSA theBSA : BSA.getResourceBSAa()) {
                        theBSA.loadFolders();
                        if (!theBSA.hasFile(strings)) continue;
                        in = theBSA.getFile(strings);
                        numRecords = in.extractInt(4);
                        recordsSize = numRecords * 8 + 8;
                        in.skip(4);
                        break;
                    }
                }
            }
            if (in == null) continue;
            plugin.language = l;
            int i = 0;
            while (i < numRecords) {
                plugin.stringLocations.get((Object)file).put(in.extractInt(4), in.extractInt(4) + recordsSize);
                ++i;
            }
            break block0;
        }
        if (in == null) {
            SPGlobal.logError(header, String.valueOf(plugin.toString()) + " did not have Strings files (loose or in BSA).");
        } else if (SPGlobal.logMods) {
            SPGlobal.logMod(plugin, header, "Loaded " + (Object)((Object)file) + " from language: " + (Object)((Object)plugin.language));
        }
    }

    static String getStringFilePath(Mod plugin, SPGlobal.Language l, SubStringPointer.Files file) {
        return "Strings\\" + plugin.getName().substring(0, plugin.getName().indexOf(".es")) + "_" + (Object)((Object)l) + "." + (Object)((Object)file);
    }

    static String scanToGRUPStart(LInChannel in, ArrayList<String> target) throws IOException {
        while (in.available() >= 12) {
            String intro = Ln.arrayToString((byte[])in.getBytes(0, 4));
            if ("TES4".equals(intro)) {
                SPImporter.extractHeaderInfo(in);
            }
            int size = Ln.arrayToInt((int[])in.extractInts(4, 4));
            String type = Ln.arrayToString((int[])in.extractInts(0, 4));
            for (String t : target) {
                if (!t.equals(type)) continue;
                in.skip(-12);
                return type;
            }
            in.skip(size - 12);
        }
        return "NULL";
    }

    static RecordShrinkArray extractGRUPData(LInChannel in) throws IOException {
        return new RecordShrinkArray((LImport)in, SPImporter.getGRUPsize(in));
    }

    static int getGRUPsize(LInChannel in) {
        int size = Ln.arrayToInt((int[])in.extractInts(4, 4));
        in.skip(-8);
        return size;
    }

    private static String genStatus(ModListing mod) {
        return "Importing " + mod.print();
    }

    public static class DirtyParsingIterator
    implements Iterator<RecordShrinkArray> {
        String typeString;
        ArrayList<String> grups;
        LImport input;
        LInChannel fileInput;
        LShrinkArray uncompressed = new LShrinkArray(new byte[0]);
        String inputStr = "";
        String majorRecordType = "";
        RecordShrinkArray next;
        ArrayList<ModListing> activeMods;
        ModListing activeMod;

        DirtyParsingIterator(String typeString, String[] grups) {
            this.init(typeString, grups);
            try {
                this.activeMods = SPImporter.getActiveModList();
            }
            catch (IOException ex) {
                this.activeMods = new ArrayList();
                SPGlobal.logException(ex);
            }
            this.switchToNextMod();
        }

        DirtyParsingIterator(ModListing mod, String typeString, String[] grups) {
            this.init(typeString, grups);
            this.activeMods = new ArrayList();
            this.activeMods.add(mod);
            this.switchToNextMod();
        }

        void init(String typeString, String[] grupTypes) {
            this.typeString = typeString;
            this.grups = new ArrayList<String>(Arrays.asList(grupTypes));
        }

        public ModListing activeMod() {
            return this.activeMod;
        }

        @Override
        public boolean hasNext() {
            this.grabNext();
            return this.next != null;
        }

        @Override
        public RecordShrinkArray next() {
            return this.next;
        }

        void grabNext() {
            while (this.fileInput.available() >= 4 || this.uncompressed.available() >= 4) {
                int size;
                this.input = this.uncompressed.available() >= 4 ? this.uncompressed : this.fileInput;
                this.inputStr = this.input.extractString(0, 4);
                if ("TES4".equals(this.inputStr)) {
                    this.input.skip(this.input.extractInt(4) + 16);
                    continue;
                }
                if ("GRUP".equals(this.inputStr)) {
                    size = this.input.extractInt(4);
                    String tmpMajorType = this.input.extractString(0, 4);
                    if (this.grups.contains(tmpMajorType)) {
                        this.input.skip(12);
                        this.majorRecordType = tmpMajorType;
                        continue;
                    }
                    if (!tmpMajorType.matches("[a-zA-Z0-9_]*")) {
                        this.input.skip(12);
                        continue;
                    }
                    this.input.skip(size - 12);
                    continue;
                }
                if (this.majorRecordType.equals(this.inputStr) || "REFR".equals(this.inputStr) || "ACHR".equals(this.inputStr) || "LAND".equals(this.inputStr) || "NAVM".equals(this.inputStr) || "NVNM".equals(this.inputStr)) {
                    if (this.typeString.equals(this.inputStr)) {
                        this.next = new RecordShrinkArray(this.input.extract(this.input.extractInt(4) + 16));
                        return;
                    }
                    size = this.input.extractInt(4);
                    LFlags flags = new LFlags(this.input.extract(4));
                    this.input.extract(4);
                    this.input.skip(8);
                    if (this.inputStr.equals("NAVM")) {
                        this.input.skip(size);
                        continue;
                    }
                    if (!flags.get(MajorRecord.MajorFlags.Compressed.value)) continue;
                    this.uncompressed = new LShrinkArray(this.input.extract(size));
                    try {
                        this.uncompressed = this.uncompressed.correctForCompression();
                    }
                    catch (DataFormatException ex) {
                        SPGlobal.logException(ex);
                    }
                    continue;
                }
                if (this.typeString.equals(this.inputStr)) {
                    this.next = new RecordShrinkArray(this.input.extract(this.input.extractInt(2)));
                    return;
                }
                this.input.skip(this.input.extractInt(2));
            }
            if (this.switchToNextMod()) {
                this.grabNext();
            }
        }

        boolean switchToNextMod() {
            if (this.fileInput != null) {
                this.fileInput.close();
            }
            if (this.activeMods.size() > 0) {
                this.fileInput = new LInChannel(String.valueOf(SPGlobal.pathToData) + this.activeMods.get(0).print());
                this.activeMod = this.activeMods.get(0);
                this.activeMods.remove(0);
                return true;
            }
            this.next = null;
            return false;
        }

        @Override
        public void remove() {
        }
    }

    static class GRUPIterator
    implements Iterator<RecordShrinkArray> {
        LInChannel input;
        ArrayList<String> targets;
        String loading;

        GRUPIterator() {
            this.targets = new ArrayList(0);
        }

        GRUPIterator(GRUP_TYPE[] grup_targets, LInChannel input) {
            ArrayList<GRUP_TYPE> tmp = new ArrayList<GRUP_TYPE>(Arrays.asList(grup_targets));
            for (GRUP_TYPE g : new ArrayList<GRUP_TYPE>(tmp)) {
                if (!GRUP_TYPE.unfinished(g) || GRUP_TYPE.internal(g)) continue;
                tmp.remove((Object)g);
            }
            this.targets = new ArrayList(tmp.size());
            for (GRUP_TYPE g : tmp) {
                this.targets.add(g.toString());
            }
            this.input = input;
        }

        @Override
        public boolean hasNext() {
            if (this.targets.isEmpty()) {
                return false;
            }
            try {
                this.loading = SPImporter.scanToGRUPStart(this.input, this.targets);
                this.targets.remove(this.loading);
                return !"NULL".equals(this.loading);
            }
            catch (IOException ex) {
                SPGlobal.logException(ex);
                return false;
            }
        }

        @Override
        public RecordShrinkArray next() {
            RecordShrinkArray out;
            try {
                out = SPImporter.extractGRUPData(this.input);
            }
            catch (IOException ex) {
                SPGlobal.logException(ex);
                out = new RecordShrinkArray();
            }
            return out;
        }

        public String loading() {
            return this.loading;
        }

        @Override
        public void remove() {
        }
    }

    private static class StartImportThread
    implements Runnable {
        private StartImportThread() {
        }

        @Override
        public void run() {
        }

        public void main(String[] args) {
            new Thread(new StartImportThread()).start();
        }
    }
}

