/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.regex.Pattern;
import lev.Ln;
import lev.debug.LDebug;
import skyproc.Consistency;
import skyproc.FormID;
import skyproc.GRUP_TYPE;
import skyproc.MajorRecord;
import skyproc.Mod;
import skyproc.ModListing;
import skyproc.SPDatabase;
import skyproc.SPLogger;
import skyproc.gui.SUMGUI;

public class SPGlobal {
    static String header = "SPGlobal";
    static String gameName = "Skyrim";
    static String pathToDebug = "SkyProcDebug/";
    static Mod globalPatchOut;
    static SPLogger log;
    static boolean logMods;
    static SPDatabase globalDatabase;
    static boolean testing;
    static boolean streamMode;
    static boolean deleteAfterExport;
    static boolean mergeMode;
    static boolean noModsAfter;
    static boolean checkMissingMasters;
    static MajorRecord lastStreamed;
    public static String pluginsListPath;
    public static String pathToData;
    public static String pathToInternalFiles;
    public static Language language;
    public static String pluginListBackupPath;
    static File skyProcDocuments;
    static ArrayList<ModListing> modsToSkip;
    static ArrayList<String> modsToSkipStr;
    static ArrayList<ModListing> modsWhiteList;
    static ArrayList<String> modsWhiteListStr;
    static String appDataFolder;
    public static boolean debugStream;
    public static boolean debugBSAimport;
    public static boolean debugNIFimport;
    public static boolean debugStringPairing;
    public static boolean debugModMerge;
    public static boolean forceValidateMode;
    private static boolean allModsAsMasters;

    static {
        logMods = false;
        globalDatabase = new SPDatabase();
        testing = false;
        streamMode = true;
        deleteAfterExport = true;
        mergeMode = false;
        noModsAfter = true;
        checkMissingMasters = true;
        pluginsListPath = "/Skyrim/plugins.txt";
        pathToData = "..\\..\\";
        pathToInternalFiles = "Files/";
        language = Language.English;
        pluginListBackupPath = "SkyProc-PluginListLocation.txt";
        modsToSkip = new ArrayList();
        modsToSkipStr = new ArrayList();
        modsWhiteList = new ArrayList();
        modsWhiteListStr = new ArrayList();
        debugStream = true;
        debugBSAimport = false;
        debugNIFimport = false;
        debugStringPairing = true;
        debugModMerge = false;
        forceValidateMode = false;
        allModsAsMasters = false;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Language getLanguageFromSkyrimIni() {
        try {
            var0 = null;
            var1_3 = null;
            try {
                fstream = new FileReader(SPGlobal.getSkyrimINI());
                try {
                    reader = new BufferedReader(fstream);
                    try {
                        category = "";
                        line = reader.readLine();
                        pattern_category = Pattern.compile("\\[([A-z]+)\\]");
                        pattern_lang = Pattern.compile("sLanguage *= *([A-z]+)", 2);
                        while (true) {
                            match = pattern_category.matcher(line.trim());
                            if (match.matches()) {
                                category = match.group(1).toLowerCase();
                            }
                            if (!category.equals("general")) {
                                line = reader.readLine();
                            }
                            match = pattern_lang.matcher(line.trim());
                            if (!match.matches()) ** GOTO lbl-1000
                            iniLanguage = match.group(1);
                            var13_14 = Language.values();
                            var12_15 = var13_14.length;
                            var11_16 = 0;
lbl-1000:
                            // 1 sources

                            {
                                line = reader.readLine();
                                return line;
                            }
                            break;
                        }
                    }
                    finally {
                        if (line != null) ** continue;
                    }
                    if (fstream == null) return null;
                }
                catch (Throwable var1_4) {
                    if (var0 == null) {
                        var0 = var1_4;
                    } else if (var0 != var1_4) {
                        var0.addSuppressed(var1_4);
                    }
                    if (fstream == null) throw var0;
                    fstream.close();
                    throw var0;
                }
                fstream.close();
                return null;
            }
            catch (Throwable var1_5) {
                if (var0 == null) {
                    var0 = var1_5;
                    throw var0;
                }
                if (var0 == var1_5) throw var0;
                var0.addSuppressed(var1_5);
                throw var0;
            }
        }
        catch (IOException ex) {
            SPGlobal.logException(ex);
        }
        return null;
    }

    public static File getSkyProcDocuments() throws FileNotFoundException, IOException {
        if (skyProcDocuments == null) {
            File myDocs = SPGlobal.getMyDocumentsSkyrimFolder();
            skyProcDocuments = new File(String.valueOf(myDocs.getPath()) + "\\SkyProc\\");
            skyProcDocuments.mkdirs();
        }
        return skyProcDocuments;
    }

    public static SPDatabase getDB() {
        return globalDatabase;
    }

    public static void setGlobalPatch(Mod patch) {
        if (globalPatchOut != null) {
            modsToSkip.remove(globalPatchOut.getInfo());
        }
        globalPatchOut = patch;
        modsToSkip.add(globalPatchOut.getInfo());
    }

    public static Mod getGlobalPatch() {
        return globalPatchOut;
    }

    public static void addModToSkip(ModListing m) {
        modsToSkip.add(m);
    }

    public static void addModToSkip(String s) {
        if ((s = s.toUpperCase()).contains(".ESP") || s.contains(".ESM")) {
            SPGlobal.addModToSkip(new ModListing(s));
        } else {
            modsToSkipStr.add(s);
        }
    }

    public static boolean isModToSkip(ModListing m) {
        return modsToSkip.contains(m) || SPGlobal.isModToSkip(m.print());
    }

    public static boolean isModToSkip(String name) {
        return Ln.hasAnyKeywords((String)name, modsToSkipStr);
    }

    public static boolean isWhiteListed(ModListing m) {
        return modsWhiteList.isEmpty() && modsWhiteListStr.isEmpty() || modsWhiteList.contains(m) || SPGlobal.isWhiteListed(m.print());
    }

    public static boolean isWhiteListed(String name) {
        return modsWhiteList.isEmpty() && modsWhiteListStr.isEmpty() || Ln.hasAnyKeywords((String)name, modsWhiteListStr);
    }

    public static boolean shouldImport(ModListing m) {
        return !SPGlobal.isModToSkip(m) && SPGlobal.isWhiteListed(m);
    }

    public static boolean shouldImport(String name) {
        return !SPGlobal.isModToSkip(name) && SPGlobal.isWhiteListed(name);
    }

    public static void addModToWhiteList(ModListing m) {
        modsWhiteList.add(m);
    }

    public static void addModToWhiteList(String s) {
        if (s.contains(".ESP") || s.contains(".ESM")) {
            SPGlobal.addModToWhiteList(new ModListing(s));
        } else {
            modsWhiteListStr.add(s);
        }
    }

    public static boolean queryMajor(FormID query) {
        return SPDatabase.queryMajor(query, SPGlobal.getDB());
    }

    public static boolean queryMajor(FormID query, GRUP_TYPE ... grup_types) {
        return SPDatabase.queryMajor(query, SPGlobal.getDB(), grup_types);
    }

    public static File getMyDocumentsSkyrimFolder() throws FileNotFoundException, IOException {
        return SPGlobal.getSkyrimINI().getParentFile();
    }

    public static File getSkyrimINI() throws FileNotFoundException, IOException {
        File myDocuments = Ln.getMyDocuments();
        File ini = new File(String.valueOf(myDocuments.getPath()) + "//My Games//Skyrim//Skyrim.ini");
        File override = new File(String.valueOf(pathToInternalFiles) + "Skyrim-INI-Location.txt");
        if (override.exists()) {
            SPGlobal.log(header, "Skyrim.ini override file exists: " + override);
            BufferedReader in = new BufferedReader(new FileReader(override));
            File iniTmp = new File(in.readLine());
            if (iniTmp.exists()) {
                SPGlobal.log(header, "Skyrim.ini location override: " + iniTmp);
                ini = iniTmp;
            } else {
                SPGlobal.log(header, "Skyrim.ini location override thought to be in: " + iniTmp + ", but it did not exist.");
            }
        }
        if (!ini.exists()) {
            SPGlobal.logMain(header, "Skyrim.ini believed to be in: " + ini + ". But it does not exist.  Locating manually.");
            ini = Ln.manualFindFile((String)"your Skyrim.ini file.", (File)new File(String.valueOf(pathToInternalFiles) + "SkyrimINIlocation.txt"));
        } else if (SPGlobal.logging()) {
            SPGlobal.logMain(header, "Skyrim.ini believed to be in: " + ini + ". File exists.");
        }
        return ini;
    }

    public static String getSkyrimAppData() throws IOException {
        if (appDataFolder == null) {
            appDataFolder = System.getenv("LOCALAPPDATA");
            if (appDataFolder == null) {
                SPGlobal.logError(header, "Can't locate local app data folder directly, probably running XP.");
                appDataFolder = System.getenv("APPDATA");
                if (appDataFolder == null) {
                    SPGlobal.logError(header, "Can't locate local app data folder.");
                    appDataFolder = Ln.manualFindFile((String)"your Plugins.txt file.\nThis is usually found in your Local Application Data folder.\nYou may need to turn on hidden folders to see it.", (File)new File(String.valueOf(pathToInternalFiles) + "PluginsListLocation.txt")).getPath();
                    SPGlobal.logMain(header, "Plugin.txt returned: ", appDataFolder, "     Shaving off the \\Plugins.txt.");
                    appDataFolder = appDataFolder.substring(0, appDataFolder.lastIndexOf("\\"));
                    appDataFolder = appDataFolder.substring(0, appDataFolder.lastIndexOf("\\"));
                } else {
                    SPGlobal.logMain(header, "APPDATA returned: ", appDataFolder, "     Shaving off the \\Application Data.");
                    appDataFolder = appDataFolder.substring(0, appDataFolder.lastIndexOf("\\"));
                    SPGlobal.logMain(header, "path now reads: ", appDataFolder, "     appending \\Local Settings\\Application Data");
                    appDataFolder = String.valueOf(appDataFolder) + "\\Local Settings\\Application Data";
                    SPGlobal.logMain(header, "path now reads: ", appDataFolder);
                }
            }
            appDataFolder = String.valueOf(appDataFolder) + "\\Skyrim";
            SPGlobal.logMain(header, String.valueOf(gameName) + " App data thought to be found at: ", appDataFolder);
        }
        return appDataFolder;
    }

    public static String getPluginsTxt() throws FileNotFoundException, IOException {
        String pluginsFile = String.valueOf(SPGlobal.getSkyrimAppData()) + "\\plugins.txt";
        File pluginListPath = new File(pluginsFile);
        if (!pluginListPath.exists()) {
            SPGlobal.logMain(header, String.valueOf(gameName) + " Plugin file location wrong. Locating manually.");
            pluginsFile = Ln.manualFindFile((String)"your Plugins.txt file.\nThis is usually found in your Local Application Data folder.\nYou may need to turn on hidden folders to see it.", (File)new File(String.valueOf(pathToInternalFiles) + "PluginsListLocation.txt")).getPath();
        }
        return pluginsFile;
    }

    public static String getLoadOrderTxt() throws IOException {
        String loadorderFile = String.valueOf(SPGlobal.getSkyrimAppData()) + "\\loadorder.txt";
        File loadorderPath = new File(loadorderFile);
        if (!loadorderPath.exists()) {
            throw new FileNotFoundException("Load Order Text file does not exist at: " + loadorderFile);
        }
        return loadorderFile;
    }

    public static void setStreamMode(boolean on) {
        streamMode = on;
    }

    public static void setNoModsAfter(boolean on) {
        noModsAfter = on;
    }

    public static void setSUMerrorMessage(String message) {
        SUMGUI.setErrorMessage(message);
    }

    public static void createGlobalLog() {
        SPGlobal.createGlobalLog("SkyProcDebug/");
    }

    public static void createGlobalLog(String path) {
        pathToDebug = path;
        log = new SPLogger(path);
    }

    static void logSync(String header, String ... print) {
        if (log != null) {
            log.logSync(header, print);
        }
    }

    public static void logMain(String header, String ... print) {
        if (log != null) {
            log.logMain(header, print);
        }
    }

    public static void logBlocked(String header, String reason, MajorRecord m) {
        log.logSpecial(SPLogger.SpecialTypes.BLOCKED, header, new String[]{"Blocked " + m + " for reason: " + reason});
    }

    public static boolean logging() {
        if (log != null) {
            return log.logging();
        }
        return false;
    }

    public static void logging(Boolean on) {
        if (log != null) {
            log.logging(on);
        }
    }

    public static boolean loggingSync() {
        if (log != null) {
            return log.loggingSync();
        }
        return false;
    }

    public static void loggingSync(Boolean on) {
        if (log != null) {
            log.loggingSync(on);
        }
    }

    public static void loggingAsync(Boolean on) {
        if (log != null) {
            log.loggingAsync(on);
        }
    }

    public static boolean loggingAsync() {
        if (log != null) {
            return log.loggingAsync();
        }
        return false;
    }

    public static void flush() {
        if (log != null) {
            log.flush();
        }
    }

    public static void logError(String header, String ... print) {
        if (log != null) {
            log.logError(header, print);
        }
    }

    public static void logException(Throwable e) {
        if (log != null) {
            log.logException(e);
        }
    }

    public static void logSpecial(Enum e, String header, String ... print) {
        if (log != null) {
            log.logSpecial(e, header, print);
        }
    }

    public static void newSpecialLog(Enum e, String logName) {
        if (log != null) {
            log.addSpecial(e, logName);
        }
    }

    public static boolean logMods() {
        return logMods;
    }

    public static void logMods(boolean on) {
        logMods = on;
        if (on) {
            SPGlobal.logging(true);
        }
    }

    static void logMod(Mod m, String h, String ... data) {
        if (logMods && log != null) {
            log.logMod(m, h, data);
        }
    }

    static void newSyncLog(String fileName) {
        if (log != null) {
            log.newSyncLog(fileName);
        }
    }

    public static void log(String header, String ... print) {
        if (log != null) {
            log.log(header, print);
        }
    }

    public static void newLog(String fileName) {
        if (log != null) {
            log.newLog(fileName);
        }
    }

    static void sync(boolean flag) {
        if (log != null) {
            log.sync(flag);
        }
    }

    static boolean sync() {
        if (log != null) {
            return log.sync();
        }
        return false;
    }

    public static void redirectSystemOutStream() throws FileNotFoundException, IOException {
        if (log == null) {
            SPGlobal.createGlobalLog();
        }
        OutputStream outToDebug = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                if (b != 116) {
                    SPGlobal.log("", String.valueOf((char)b));
                }
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                String output = new String(b, off, len);
                if (output.length() > 2) {
                    SPGlobal.log("", output);
                }
            }

            @Override
            public void write(byte[] b) throws IOException {
                this.write(b, 0, b.length);
            }
        };
        System.setOut(new PrintStream(outToDebug, true));
    }

    static void reset() {
        SPDatabase.activePlugins.clear();
        SPDatabase.addedPlugins.clear();
        SPDatabase.modLookup.clear();
        FormID.allIDs.clear();
        Consistency.clear();
    }

    public static void closeDebug() {
        LDebug.wrapUp();
    }

    public static String pathToDebug() {
        return pathToDebug;
    }

    public static boolean getAllModsAsMasters() {
        return allModsAsMasters;
    }

    public static void setAllModsAsMasters(boolean b) {
        allModsAsMasters = b;
    }

    public static enum Language {
        English,
        Spanish,
        Italian,
        French,
        German,
        Russian,
        Czech,
        Polish,
        Japanese;

    }
}

