/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.DataFormatException;
import lev.LImport;
import skyproc.FormID;
import skyproc.INGR;
import skyproc.MagicItem;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.Model;
import skyproc.Record;
import skyproc.SPEL;
import skyproc.SPGlobal;
import skyproc.SubForm;
import skyproc.SubPrototype;
import skyproc.SubRecord;
import skyproc.SubString;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;
import skyproc.genenums.CastType;
import skyproc.genenums.DeliveryType;

public class SCRL
extends MagicItem {
    static final SubPrototype SCRLproto = new SubPrototype(MagicItem.magicItemProto){

        @Override
        protected void addRecords() {
            this.add(new SubForm("MDOB"));
            this.add(new SubForm("ETYP"));
            this.reposition("DESC");
            this.add(new Model());
            this.add(new DATA());
            this.forceExport.add("DATA");
            this.add(new MagicItem.SPIT());
            this.reposition("EFID");
            this.add(SubString.getNew("ICON", true));
            this.add(SubString.getNew("MICO", true));
        }
    };

    SCRL() {
        this.subRecords.setPrototype(SCRLproto);
    }

    public SCRL(String edid) {
        this.subRecords.setPrototype(SCRLproto);
        this.originateFromPatch(edid);
    }

    @Override
    ArrayList<String> getTypes() {
        return Record.getTypeList("SCRL");
    }

    @Override
    Record getNew() {
        return new SCRL();
    }

    public void setMenuDisplayObject(FormID obj) {
        this.subRecords.setSubForm("MDOB", obj);
    }

    public FormID getMenuDisplayObject() {
        return this.subRecords.getSubForm("MDOB").getForm();
    }

    public void setEquipmentType(FormID obj) {
        this.subRecords.setSubForm("ETYP", obj);
    }

    public FormID getEquipmentType() {
        return this.subRecords.getSubForm("ETYP").getForm();
    }

    public Model getModelData() {
        return this.subRecords.getModel();
    }

    public void setValue(int val) {
        DATA data = (DATA)this.subRecords.get("DATA");
        data.value = val;
    }

    public int getValue() {
        DATA data = (DATA)this.subRecords.get("DATA");
        return data.value;
    }

    public void setWeight(float weight) {
        DATA data = (DATA)this.subRecords.get("DATA");
        data.weight = weight;
    }

    public float getWeight() {
        DATA data = (DATA)this.subRecords.get("DATA");
        return data.weight;
    }

    final MagicItem.SPIT getSPIT() {
        return (MagicItem.SPIT)this.subRecords.get("SPIT");
    }

    public void setBaseCost(int baseCost) {
        this.getSPIT().baseCost = baseCost;
    }

    public int getBaseCost() {
        return this.getSPIT().baseCost;
    }

    public void set(MagicItem.SPELFlag flag, boolean on) {
        this.getSPIT().flags.set(flag.value, on);
    }

    public boolean get(MagicItem.SPELFlag flag) {
        return this.getSPIT().flags.get(flag.value);
    }

    public void setSpellType(SPEL.SPELType type) {
        this.getSPIT().baseType = type.value;
    }

    public SPEL.SPELType getSpellType() {
        return SPEL.SPELType.value(this.getSPIT().baseType);
    }

    public void setChargeTime(float chargeTime) {
        this.getSPIT().chargeTime = chargeTime;
    }

    public float getChargeTime() {
        return this.getSPIT().chargeTime;
    }

    public void setCastType(CastType type) {
        this.getSPIT().castType = type;
    }

    public CastType getCastType() {
        return this.getSPIT().castType;
    }

    public void setDeliveryType(DeliveryType type) {
        this.getSPIT().targetType = type;
    }

    public DeliveryType getDeliveryType() {
        return this.getSPIT().targetType;
    }

    public void setCastDuration(float duration) {
        this.getSPIT().castDuration = duration;
    }

    public float getCastDuration() {
        return this.getSPIT().castDuration;
    }

    public void setRange(float range) {
        this.getSPIT().range = range;
    }

    public float getRange() {
        return this.getSPIT().range;
    }

    public FormID getPerkRef() {
        return this.getSPIT().perkType;
    }

    public void setPerkRef(FormID perkRef) {
        this.getSPIT().perkType = perkRef;
    }

    public void setInventoryIcon(String filename) {
        this.subRecords.setSubString("ICON", filename);
    }

    public String getInventoryIcon() {
        return this.subRecords.getSubString("ICON").print();
    }

    public void setMessageIcon(String filename) {
        this.subRecords.setSubString("MICO", filename);
    }

    public String getMessageIcon() {
        return this.subRecords.getSubString("MICO").print();
    }

    static class DATA
    extends SubRecord {
        int value = 0;
        float weight = 0.0f;

        DATA() {
        }

        @Override
        void export(ModExporter out) throws IOException {
            super.export(out);
            out.write(this.value);
            out.write(this.weight);
        }

        @Override
        void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
            super.parseData(in, srcMod);
            this.value = in.extractInt(4);
            this.weight = in.extractFloat();
            if (SPGlobal.logMods) {
                DATA.logMod(srcMod, "", "Setting DATA:    Weight: " + this.weight);
            }
        }

        @Override
        SubRecord getNew(String type) {
            return new INGR.DATA();
        }

        @Override
        int getContentLength(ModExporter out) {
            return 8;
        }

        @Override
        ArrayList<String> getTypes() {
            return Record.getTypeList("DATA");
        }
    }
}

