/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.DataFormatException;
import lev.LImport;
import skyproc.Condition;
import skyproc.FormID;
import skyproc.MajorRecordDescription;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.Record;
import skyproc.ScriptPackage;
import skyproc.StringNonNull;
import skyproc.SubData;
import skyproc.SubForm;
import skyproc.SubFormData;
import skyproc.SubList;
import skyproc.SubPrototype;
import skyproc.SubRecord;
import skyproc.SubShell;
import skyproc.SubShellBulkType;
import skyproc.SubString;
import skyproc.SubStringPointer;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;

public class PERK
extends MajorRecordDescription {
    static final SubPrototype PERKproto = new SubPrototype(MajorRecordDescription.descProto){

        @Override
        protected void addRecords() {
            this.after(new ScriptPackage(new PERKScriptFragments()), "EDID");
            this.add(new SubList(new Condition()));
            this.add(new SubData("DATA"));
            this.add(new SubForm("NNAM"));
            this.add(SubString.getNew("ICON", true));
            this.add(new SubList(new PRKEPackage(new SubPrototype(){

                @Override
                protected void addRecords() {
                    this.add(new SubData("PRKE"));
                    this.add(new PRKEComplexSubPackage(new SubPrototype(){

                        @Override
                        protected void addRecords() {
                            this.add(new SubData("DATA"));
                            this.add(new SubList(new SubShell(new SubPrototype(){

                                @Override
                                protected void addRecords() {
                                    this.add(new SubData("PRKC"));
                                    this.add(new SubList(new Condition()));
                                }
                            })));
                            this.add(new SubData("EPFT"));
                            this.add(new SubStringPointer("EPF2", SubStringPointer.Files.STRINGS));
                            this.add(new SubData("EPF3"));
                            this.add(new SubData("EPFD"));
                        }
                    }));
                    this.add(new SubData("PRKF"));
                    this.forceExport("PRKF");
                }
            })));
        }
    };

    PERK() {
        this.subRecords.setPrototype(PERKproto);
    }

    @Override
    ArrayList<String> getTypes() {
        return Record.getTypeList("PERK");
    }

    @Override
    Record getNew() {
        return new PERK();
    }

    public ScriptPackage getScriptPackage() {
        return this.subRecords.getScripts();
    }

    public ArrayList<Condition> getConditions() {
        return this.subRecords.getSubList("CTDA").toPublic();
    }

    public void addCondition(Condition c) {
        this.subRecords.getSubList("CTDA").add(c);
    }

    public void removeCondition(Condition c) {
        this.subRecords.getSubList("CTDA").remove(c);
    }

    public void setNextPerk(FormID perk) {
        this.subRecords.setSubForm("NNAM", perk);
    }

    public FormID getNextPerk() {
        return this.subRecords.getSubForm("NNAM").getForm();
    }

    static class PERKScriptFragment {
        int index = 0;
        byte[] unknown = new byte[3];
        StringNonNull scriptName = new StringNonNull();
        StringNonNull fragmentName = new StringNonNull();

        PERKScriptFragment() {
        }

        void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
            this.index = in.extractInt(2);
            this.unknown = in.extract(3);
            this.scriptName.set(in.extractString(in.extractInt(2)));
            this.fragmentName.set(in.extractString(in.extractInt(2)));
        }

        void export(ModExporter out) throws IOException {
            out.write(this.index, 2);
            out.write(this.unknown);
            this.scriptName.export(out);
            this.fragmentName.export(out);
        }

        int getContentLength(ModExporter out) {
            return 5 + this.scriptName.getTotalLength(out) + this.fragmentName.getTotalLength(out);
        }
    }

    static class PERKScriptFragments
    extends SubRecord {
        byte unknown = 0;
        StringNonNull fragmentFile = new StringNonNull();
        ArrayList<PERKScriptFragment> fragments = new ArrayList();
        boolean valid = false;

        PERKScriptFragments() {
        }

        @Override
        void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
            this.unknown = in.extract(1)[0];
            this.fragmentFile.set(in.extractString(in.extractInt(2)));
            int numFrag = in.extractInt(2);
            int i = 0;
            while (i < numFrag) {
                PERKScriptFragment frag = new PERKScriptFragment();
                frag.parseData(in, srcMod);
                this.fragments.add(frag);
                ++i;
            }
            this.valid = true;
        }

        @Override
        void export(ModExporter out) throws IOException {
            if (!this.valid) {
                return;
            }
            out.write(this.unknown, 1);
            this.fragmentFile.export(out);
            out.write(this.fragments.size(), 2);
            for (PERKScriptFragment frag : this.fragments) {
                frag.export(out);
            }
        }

        @Override
        int getContentLength(ModExporter out) {
            if (!this.valid) {
                return 0;
            }
            int len = 3;
            len += this.fragmentFile.getTotalLength(out);
            for (PERKScriptFragment frag : this.fragments) {
                len += frag.getContentLength(out);
            }
            return len;
        }

        @Override
        SubRecord getNew(String type) {
            return new PERKScriptFragments();
        }

        @Override
        ArrayList<String> getTypes() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    static class PRKEComplexSubPackage
    extends SubShell {
        PRKEComplexSubPackage(SubPrototype proto) {
            super(proto);
        }

        @Override
        SubRecord getNew(String type) {
            return new PRKEComplexSubPackage(this.getPrototype());
        }

        @Override
        void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
            switch (PRKEComplexSubPackage.getNextType(in)) {
                case "EPFT": {
                    SubData EPFT = this.subRecords.getSubData("EPFT");
                    EPFT.parseData(in, srcMod);
                    if (EPFT.toInt() >= 3 && EPFT.toInt() <= 5) {
                        this.subRecords.remove("EPFD");
                        this.subRecords.add(new SubForm("EPFD"));
                    }
                    return;
                }
            }
            super.parseData(in, srcMod);
        }

        @Override
        boolean isValid() {
            return true;
        }
    }

    static class PRKEPackage
    extends SubShellBulkType {
        PRKEPackage(SubPrototype proto) {
            super(proto, false);
        }

        @Override
        final void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
            SubData PRKE = this.subRecords.getSubData("PRKE");
            PRKE.parseData(PRKE.extractRecordData(in), srcMod);
            PerkType perkType = PerkType.values()[this.subRecords.getSubData("PRKE").getData()[0]];
            switch (perkType) {
                case QUEST: {
                    this.subRecords.remove("DATA");
                    this.subRecords.add(new SubFormData("DATA"));
                    break;
                }
                case ABILITY: {
                    this.subRecords.remove("DATA");
                    this.subRecords.add(new SubForm("DATA"));
                }
            }
            super.parseData(in, srcMod);
        }

        @Override
        SubRecord getNew(String type) {
            return new PRKEPackage(this.getPrototype());
        }

        @Override
        boolean isValid() {
            return this.subRecords.get("PRKE").isValid() && this.subRecords.get("DATA").isValid();
        }
    }

    static enum PerkType {
        QUEST,
        ABILITY,
        COMPLEX;

    }
}

