/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import WinRegistry.WinRegistry;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import lev.LInChannel;
import lev.Ln;
import skyproc.FormID;
import skyproc.GRUP_TYPE;
import skyproc.LVLN;
import skyproc.MGEF;
import skyproc.MajorRecord;
import skyproc.Mod;
import skyproc.ModListing;
import skyproc.NPC_;
import skyproc.QUST;
import skyproc.RACE;
import skyproc.SPDatabase;
import skyproc.SPEL;
import skyproc.SPGlobal;
import skyproc.ScriptRef;
import skyproc.gui.SUMGUI;

public class NiftyFunc {
    static String[] validationSkip = new String[]{"DIAL"};
    static String recordLengths = "Record Lengths";
    static Map<FormID, MajorRecord> deepSubrecordCopyDB = new HashMap<FormID, MajorRecord>();

    public static SPEL genScriptAttachingSpel(ScriptRef script, String uniqueID) {
        String name = "SP_" + uniqueID + "_" + script.name.data + "_attacher";
        MGEF mgef = new MGEF(String.valueOf(name) + "_MGEF", String.valueOf(name) + "_MGEF");
        mgef.getScriptPackage().addScript(script);
        mgef.set(MGEF.SpellEffectFlag.HideInUI, true);
        SPEL spel = new SPEL(String.valueOf(name) + "_SPEL");
        spel.setSpellType(SPEL.SPELType.Ability);
        spel.addMagicEffect(mgef);
        return spel;
    }

    public static RACE genSafeScriptAttachingRace(ScriptRef script, RACE raceToDup, String uniqueID) {
        SPEL attachmentSpel = NiftyFunc.genScriptAttachingSpel(script, uniqueID);
        RACE attachmentRace = (RACE)SPGlobal.getGlobalPatch().makeCopy(raceToDup);
        attachmentRace.addSpell(attachmentSpel.getForm());
        return attachmentRace;
    }

    public static LVLN isTemplatedToLList(FormID npc, NPC_.TemplateFlag ... templateFlagsToCheck) {
        return NiftyFunc.isTemplatedToLList(npc, templateFlagsToCheck, 0);
    }

    public static LVLN isTemplatedToLList(NPC_ npc, NPC_.TemplateFlag ... templateFlagsToCheck) {
        return NiftyFunc.isTemplatedToLList(npc.getForm(), templateFlagsToCheck);
    }

    static LVLN isTemplatedToLList(FormID npc, NPC_.TemplateFlag[] templateFlagsToCheck, int depth) {
        NPC_ npcSrc;
        if (depth > 100) {
            return null;
        }
        if (templateFlagsToCheck.length == 0) {
            templateFlagsToCheck = NPC_.TemplateFlag.values();
        }
        if ((npcSrc = (NPC_)SPDatabase.getMajor(npc, GRUP_TYPE.NPC_)) != null && !npcSrc.getTemplate().equals(FormID.NULL)) {
            boolean hasTargetTemplate = false;
            NPC_.TemplateFlag[] templateFlagArray = templateFlagsToCheck;
            int n = templateFlagsToCheck.length;
            int n2 = 0;
            while (n2 < n) {
                NPC_.TemplateFlag flag = templateFlagArray[n2];
                if (npcSrc.get(flag)) {
                    hasTargetTemplate = true;
                    break;
                }
                ++n2;
            }
            if (!hasTargetTemplate) {
                return null;
            }
            NPC_ templateN = (NPC_)SPDatabase.getMajor(npcSrc.getTemplate(), GRUP_TYPE.NPC_);
            if (templateN != null) {
                return NiftyFunc.isTemplatedToLList(templateN.getForm(), templateFlagsToCheck, depth + 1);
            }
            return (LVLN)SPDatabase.getMajor(npcSrc.getTemplate(), GRUP_TYPE.LVLN);
        }
        return null;
    }

    public static QUST makeScriptQuest(ScriptRef script) {
        QUST quest = new QUST(String.valueOf(script.getName()) + "_qust");
        quest.getScriptPackage().addScript(script);
        quest.setName(String.valueOf(script.getName()) + " Quest");
        return quest;
    }

    public static void allocateMoreMemory(String startingMem, String maxMem, String jarPath, String ... args) throws IOException, InterruptedException {
        String[] argsInternal = new String[args.length + 5];
        argsInternal[0] = "java";
        argsInternal[1] = "-jar";
        argsInternal[2] = "-Xms" + startingMem;
        argsInternal[3] = "-Xmx" + maxMem;
        argsInternal[4] = jarPath;
        int i = 5;
        while (i < args.length + 5) {
            argsInternal[i] = args[i - 5];
            ++i;
        }
        ProcessBuilder proc = new ProcessBuilder(argsInternal);
        Process start = proc.start();
        InputStream shellIn = start.getInputStream();
        int exitStatus = start.waitFor();
        String response = Ln.convertStreamToStr((InputStream)shellIn);
        if (exitStatus != 0) {
            JOptionPane.showMessageDialog(null, "Error allocating " + maxMem + " of memory:\n" + response + "\nMemory defaulted to lowest levels.  Please lower your\n" + "allocated memory in Other Settings and start the program again.");
        } else {
            System.exit(0);
        }
    }

    public static String EDIDtrimmer(String origEDID) {
        origEDID = origEDID.replaceAll(" ", "");
        origEDID = origEDID.replaceAll(":", "_");
        origEDID = origEDID.replaceAll("-", "_");
        return origEDID;
    }

    public static int versionToNum(String version) {
        String tmp = "";
        int i = 0;
        while (i < version.length()) {
            if (!Character.isDigit(version.charAt(i)) && version.charAt(i) != '.') break;
            tmp = String.valueOf(tmp) + version.charAt(i);
            ++i;
        }
        version = tmp;
        String[] split = version.split("\\.");
        int out = 0;
        int i2 = 0;
        while (i2 < split.length && i2 < 4) {
            int next = Integer.valueOf(split[i2]) * 1000000;
            if (i2 != 0) {
                next = (int)((double)next / Math.pow(100.0, i2));
            }
            out += next;
            ++i2;
        }
        return out;
    }

    public static boolean validateRecordLengths(File testFile, int numErrorsToPrint) {
        return NiftyFunc.validateRecordLengths(testFile.getPath(), numErrorsToPrint);
    }

    public static boolean validateRecordLengths(String testFilePath, int numErrorsToPrint) {
        boolean correct = true;
        int numErrors = 0;
        ArrayList<String> skip = new ArrayList<String>(Arrays.asList(validationSkip));
        try {
            File file = new File(testFilePath);
            if (file.isFile()) {
                SPGlobal.log("Validate", "Target file exists: " + file);
            } else {
                SPGlobal.log("Validate", "Target file does NOT exist: " + file);
            }
            LInChannel input = new LInChannel(testFilePath);
            correct = NiftyFunc.testHeaderLength(input);
            String majorRecordType = "NULL";
            int grupLength = 0;
            long grupPos = input.pos();
            long start = 0L;
            String EDID = "";
            HashMap<Integer, String> formids = new HashMap<Integer, String>();
            HashMap<Integer, String> dupIds = new HashMap<Integer, String>();
            while (input.available() >= 4 && (numErrors < numErrorsToPrint || numErrorsToPrint == 0)) {
                String inputStr = input.extractString(0, 4);
                if (inputStr.equals("GRUP")) {
                    long inputPos = input.pos();
                    if (inputPos - grupPos - 4L != (long)grupLength) {
                        SPGlobal.logError(recordLengths, "GRUP " + majorRecordType + " is wrong. (" + Ln.prettyPrintHex((long)grupPos) + ")");
                        ++numErrors;
                        correct = false;
                    }
                    grupPos = input.pos() - 4L;
                    grupLength = input.extractInt(0, 4);
                    majorRecordType = input.extractString(0, 4);
                    if (skip.contains(majorRecordType)) {
                        input.skip(grupLength - 12);
                        continue;
                    }
                    input.skip(12);
                    continue;
                }
                if (inputStr.equals(majorRecordType)) {
                    start = input.pos() - 4L;
                    int length = input.extractInt(0, 4);
                    input.skip(4);
                    int formID = input.extractInt(4);
                    input.skip(8);
                    String subRecordType = input.extractString(0, 4);
                    if (subRecordType.equalsIgnoreCase("EDID")) {
                        int edidLength = input.extractInt(0, 2);
                        EDID = input.extractString(0, edidLength - 1);
                        input.skip(length - 6 - EDID.length());
                        if (formids.containsKey(formID)) {
                            dupIds.put(formID, EDID);
                            continue;
                        }
                        formids.put(formID, EDID);
                        continue;
                    }
                    EDID = "No EDID subrecord";
                    input.skip(length - 4);
                    continue;
                }
                SPGlobal.logError(recordLengths, "Major Record: " + majorRecordType + " | " + EDID + " is wrong. (" + Ln.prettyPrintHex((long)start) + ")");
                ++numErrors;
                correct = false;
            }
            if (!dupIds.isEmpty()) {
                SPGlobal.logError(recordLengths, "Duplicate FormIDs: ");
                Iterator iterator = dupIds.keySet().iterator();
                while (iterator.hasNext()) {
                    int id = (Integer)iterator.next();
                    SPGlobal.logError(recordLengths, String.valueOf(Ln.printHex((int)id)) + ", EDIDS: " + (String)dupIds.get(id) + ", and " + (String)formids.get(id));
                }
                correct = false;
            }
            input.close();
        }
        catch (FileNotFoundException ex) {
            SPGlobal.logError(recordLengths, "File could not be found.");
            SPGlobal.logException(ex);
        }
        catch (IOException ex) {
            SPGlobal.logError(recordLengths, "File I/O error.");
            SPGlobal.logException(ex);
        }
        if (correct) {
            SPGlobal.log(recordLengths, "Validated.");
        } else {
            SPGlobal.logError(recordLengths, "NOT Validated.");
        }
        return correct;
    }

    static boolean testHeaderLength(LInChannel input) throws IOException {
        boolean correct = true;
        int length = input.extractInt(4, 4);
        input.skip(length + 16);
        if (input.available() > 0) {
            String inputStr = input.extractString(0, 4);
            if (!"GRUP".equals(inputStr)) {
                SPGlobal.logError("Mod Header", "Header length is wrong.");
                correct = false;
            }
            input.skip(-4);
        } else if (input.available() < 0) {
            SPGlobal.logError("Mod Header", "Header length is wrong.");
            correct = false;
        } else {
            SPGlobal.logError("Mod Header", "File header was correct, but there were no GRUPS.  Validated.");
            return true;
        }
        return correct;
    }

    public static boolean startProcess(File directory, String ... args) {
        try {
            ProcessBuilder proc = new ProcessBuilder(args);
            if (directory != null) {
                proc.directory(directory);
            }
            Process start = proc.start();
            InputStream shellIn = start.getInputStream();
            int exitStatus = start.waitFor();
            String response = Ln.convertStreamToStr((InputStream)shellIn);
            if (exitStatus != 0) {
                String tmp = "";
                String[] stringArray = args;
                int n = args.length;
                int n2 = 0;
                while (n2 < n) {
                    String arg = stringArray[n2];
                    tmp = String.valueOf(tmp) + " " + arg;
                    ++n2;
                }
                SPGlobal.logError("StartProcess", "Process with args " + tmp + " Failed to run: " + response);
                return false;
            }
        }
        catch (IOException | InterruptedException ex) {
            SPGlobal.logException(ex);
            return false;
        }
        return true;
    }

    public static boolean startProcess(String ... args) {
        return NiftyFunc.startProcess(null, args);
    }

    public static String trimToFour(String in) {
        if (in.length() > 4) {
            return in.substring(0, 3);
        }
        if (in.length() < 4) {
            return Ln.spaceRight((int)4, (char)'_', (String[])new String[]{in});
        }
        return in;
    }

    public static int replaceAll(ArrayList<FormID> src, FormID target, FormID ... with) {
        ArrayList<FormID> tmp = new ArrayList<FormID>(src);
        int numChanges = 0;
        int i = tmp.size() - 1;
        while (i >= 0) {
            if (tmp.get(i).equals(target)) {
                ++numChanges;
                src.remove(i);
                FormID[] formIDArray = with;
                int n = with.length;
                int n2 = 0;
                while (n2 < n) {
                    FormID id = formIDArray[n2];
                    src.add(i, id);
                    ++n2;
                }
            }
            --i;
        }
        return numChanges;
    }

    public static int replaceAll(ArrayList<FormID> src, FormID target, ArrayList<FormID> with) {
        return NiftyFunc.replaceAll(src, target, with.toArray(new FormID[0]));
    }

    public static Map<FormID, Integer> replaceIDs(ArrayList<FormID> src, Map<FormID, FormID> replacements) {
        HashMap<FormID, Integer> out = new HashMap<FormID, Integer>(replacements.size());
        for (FormID id : replacements.keySet()) {
            out.put(id, 0);
        }
        for (FormID id : src) {
            FormID replace = replacements.get(id);
            if (replace == null) continue;
            out.put(replace, (Integer)out.get(replace) + 1);
            id.setTo(id);
        }
        return out;
    }

    public static Map<FormID, Integer> replaceMajors(ArrayList<FormID> src, Map<FormID, MajorRecord> replacements) {
        HashMap<FormID, Integer> out = new HashMap<FormID, Integer>(replacements.size());
        for (FormID id : replacements.keySet()) {
            out.put(id, new Integer(0));
        }
        for (FormID id : src) {
            MajorRecord replace = replacements.get(id);
            if (replace == null) continue;
            Integer i = (Integer)out.get(id);
            out.put(id, i + 1);
            id.setTo(id);
        }
        return out;
    }

    public static void setupMissingPatchFiles(ArrayList<Mod> mods) throws IOException {
        NiftyFunc.setupMissingPatchFiles(mods.toArray(new Mod[0]));
    }

    public static void setupMissingPatchFiles(Mod ... mods) throws IOException {
        Mod[] modArray = mods;
        int n = mods.length;
        int n2 = 0;
        while (n2 < n) {
            Mod newPatcher = modArray[n2];
            File path = new File(String.valueOf(SPGlobal.pathToData) + newPatcher.getName());
            if (!path.isFile()) {
                BufferedWriter placeholder = new BufferedWriter(new FileWriter(String.valueOf(SPGlobal.pathToData) + newPatcher.getName()));
                placeholder.close();
            }
            ++n2;
        }
    }

    public static void modifyPluginsTxt(ArrayList<Mod> add, ArrayList<Mod> remove) throws IOException {
        ArrayList pluginsLines = Ln.loadFileToStrings((String)SPGlobal.getPluginsTxt(), (boolean)false);
        if (remove != null) {
            for (Mod r : remove) {
                Ln.removeIgnoreCase((ArrayList)pluginsLines, (String)r.getName());
            }
        }
        if (add != null) {
            for (Mod newPatcher : add) {
                if (Ln.containsEqualsIgnoreCase((ArrayList)pluginsLines, (String)newPatcher.getName())) continue;
                pluginsLines.add(newPatcher.getName());
            }
        }
        BufferedWriter pluginsOut = new BufferedWriter(new FileWriter(SPGlobal.getPluginsTxt()));
        for (String line : pluginsLines) {
            pluginsOut.write(String.valueOf(line) + "\n");
        }
        pluginsOut.close();
    }

    public static void modifyPluginsTxt(Mod add) throws IOException {
        ArrayList<Mod> addL = new ArrayList<Mod>(1);
        addL.add(add);
        NiftyFunc.modifyPluginsTxt(addL, null);
    }

    public static void runBOSS(boolean errorMessages) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SUMGUI.progress.setStatusNumbered("Running BOSS");
            }
        });
        SPGlobal.logMain("BOSS", "Looking for BOSS.");
        int response = 0;
        String bossPath = WinRegistry.getRegistryEntry((String)"BOSS", (String)"Installed Path");
        File bossExe = new File(".");
        if (bossPath != null) {
            bossExe = new File(String.valueOf(bossPath) + "\\BOSS.exe");
        }
        if (!bossExe.isFile()) {
            try {
                bossExe = Ln.manualFindFile((String)"BOSS.exe", (File)new File(String.valueOf(SPGlobal.pathToInternalFiles) + "BOSS location"));
            }
            catch (IOException ex) {
                SPGlobal.logException(ex);
            }
        }
        if (bossExe != null && bossExe.isFile()) {
            SPGlobal.logMain("BOSS", "Running BOSS.");
            if (!NiftyFunc.startProcess(bossExe.getParentFile(), bossExe.getPath(), "-s", "-U", "-g", "Skyrim")) {
                SPGlobal.logMain("BOSS", "BOSS failed to run.");
                if (errorMessages) {
                    response = JOptionPane.showConfirmDialog(null, "BOSS failed to run. Do you want to continue?", "BOSS failed", 0);
                }
            }
        } else if (errorMessages) {
            SPGlobal.logMain("BOSS", "BOSS could not be found.");
            response = JOptionPane.showConfirmDialog(null, "BOSS could not be located.\nIt is highly recommended you download BOSS so that it can be used.\n\nDo you want to continue patching without BOSS?", "Cannot locate BOSS", 0);
        }
        if (response == 1) {
            SPGlobal.logMain("BOSS", "Exiting program due to BOSS failure.");
            SUMGUI.exitProgram(false, true);
        }
        SPGlobal.logMain("BOSS", "BOSS complete.");
    }

    public static void runLOOT(boolean errorMessages) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SUMGUI.progress.setStatusNumbered("Running LOOT");
            }
        });
        SPGlobal.logMain("LOOT", "Looking for LOOT.");
        int response = 0;
        String lootPath = WinRegistry.getRegistryEntry((String)"LOOT", (String)"Installed Path");
        File lootExe = new File(".");
        if (lootPath != null) {
            lootExe = new File(String.valueOf(lootPath) + "\\LOOT.exe");
        }
        if (!lootExe.isFile()) {
            try {
                lootExe = Ln.manualFindFile((String)"LOOT.exe", (File)new File(String.valueOf(SPGlobal.pathToInternalFiles) + "LOOT location"));
            }
            catch (IOException ex) {
                SPGlobal.logException(ex);
            }
        }
        if (lootExe != null && lootExe.isFile()) {
            SPGlobal.logMain("LOOT", "Running LOOT.");
            if (!NiftyFunc.startProcess(lootExe.getParentFile(), lootExe.getPath(), "--game=Skyrim")) {
                SPGlobal.logMain("LOOT", "LOOT failed to run.");
                if (errorMessages) {
                    response = JOptionPane.showConfirmDialog(null, "LOOT failed to run. Do you want to continue?", "LOOT failed", 0);
                }
            }
        } else if (errorMessages) {
            SPGlobal.logMain("LOOT", "LOOT could not be found.");
            response = JOptionPane.showConfirmDialog(null, "LOOT could not be located.\nIt is highly recommended you download LOOT so that it can be used.\n\nDo you want to continue patching without LOOT?", "Cannot locate LOOT", 0);
        }
        if (response == 1) {
            SPGlobal.logMain("LOOT", "Exiting program due to LOOT failure.");
            SUMGUI.exitProgram(false, true);
        }
        SPGlobal.logMain("LOOT", "LOOT complete.");
    }

    public static ArrayList<MajorRecord> deepCopySubRecords(MajorRecord in, ModListing targetMod) {
        ArrayList<MajorRecord> out = new ArrayList<MajorRecord>();
        ArrayList<FormID> allIDs = in.allFormIDs();
        allIDs.remove(in.getForm());
        for (FormID id : allIDs) {
            MajorRecord m = SPDatabase.getMajor(id);
            if (m == null || !id.getMaster().equals(targetMod) && SPDatabase.getMod(id.getMaster()).contains(id)) continue;
            MajorRecord copy = deepSubrecordCopyDB.get(id);
            if (copy == null) {
                String edid = m.getEDID();
                if (!m.getType().equals("KYWD") && !m.getType().equals("GMST")) {
                    edid = String.valueOf(edid) + "_deepCopy";
                }
                copy = m.copy(edid);
                deepSubrecordCopyDB.put(id, copy);
                NiftyFunc.deepCopySubRecords(copy, targetMod);
            }
            id.setTo(copy.getForm());
            out.add(copy);
        }
        return out;
    }

    public static MajorRecord mergeDuplicate(MajorRecord in) {
        GRUP_TYPE g = GRUP_TYPE.valueOf(in.getType());
        ArrayList grup = new ArrayList(SPGlobal.getGlobalPatch().getGRUPs().get((Object)g).getRecords());
        grup.remove(in);
        for (MajorRecord existing : grup) {
            if (!in.deepEquals(existing)) continue;
            SPGlobal.getGlobalPatch().remove(in.getForm());
            if (SPGlobal.logging()) {
                SPGlobal.log("NiftyFunc", in + " duplicate of " + existing);
            }
            return existing;
        }
        return in;
    }

    public static void logMem(String header) {
        SPGlobal.logMain(header, "Used Memory: " + Ln.toMB((long)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory())) + "MB");
    }
}

