/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.zip.DataFormatException;
import lev.LFlags;
import lev.LImport;
import lev.Ln;
import skyproc.DestructionData;
import skyproc.FormID;
import skyproc.GRUP_TYPE;
import skyproc.ItemListing;
import skyproc.KeywordSet;
import skyproc.LVLN;
import skyproc.MajorRecordNamed;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.NiftyFunc;
import skyproc.RGB;
import skyproc.RGBA;
import skyproc.Record;
import skyproc.SPDatabase;
import skyproc.SPGlobal;
import skyproc.ScriptPackage;
import skyproc.SubData;
import skyproc.SubFloat;
import skyproc.SubForm;
import skyproc.SubFormInt;
import skyproc.SubInt;
import skyproc.SubIntSigned;
import skyproc.SubList;
import skyproc.SubListCounted;
import skyproc.SubPrototype;
import skyproc.SubRGB;
import skyproc.SubRGBshort;
import skyproc.SubRecord;
import skyproc.SubShell;
import skyproc.SubString;
import skyproc.SubStringPointer;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;
import skyproc.genenums.Skill;
import skyproc.genenums.SoundVolume;

public class NPC_
extends MajorRecordNamed
implements Serializable {
    static final SubPrototype NPC_proto = new SubPrototype(MajorRecordNamed.namedProto){

        @Override
        protected void addRecords() {
            this.after(new ScriptPackage(), "EDID");
            this.add(new SubData("OBND", new byte[12]));
            this.add(new ACBS());
            this.add(new SubList(new SubFormInt("SNAM")));
            this.add(new SubForm("INAM"));
            this.add(new SubForm("VTCK"));
            this.add(new SubForm("TPLT"));
            this.add(new SubForm("RNAM"));
            this.add(new SubListCounted<SubForm>("SPCT", 4, new SubForm("SPLO")));
            this.add(new DestructionData());
            this.add(new SubForm("WNAM"));
            this.add(new SubForm("ANAM"));
            this.add(new SubForm("ATKR"));
            this.add(new SubList(new AttackPackage()));
            this.add(new SubForm("SPOR"));
            this.add(new SubForm("OCOR"));
            this.add(new SubForm("GWOR"));
            this.add(new SubForm("ECOR"));
            this.add(new SubListCounted<SubFormInt>("PRKZ", 4, new SubFormInt("PRKR")));
            this.add(new SubListCounted<ItemListing>("COCT", 4, new ItemListing()));
            this.add(new AIDT());
            this.add(new SubList(new SubForm("PKID")));
            this.add(new KeywordSet());
            this.add(new SubForm("CNAM"));
            this.reposition("FULL");
            this.add(new SubStringPointer("SHRT", SubStringPointer.Files.STRINGS));
            this.add(new SubData("DATA"));
            this.forceExport("DATA");
            this.add(new DNAM());
            this.add(new SubList(new SubForm("PNAM")));
            this.add(new SubForm("HCLF"));
            this.add(new SubForm("ZNAM"));
            this.add(new SubForm("GNAM"));
            this.add(new SubData("NAM5"));
            this.add(new SubFloat("NAM6"));
            this.add(new SubFloat("NAM7"));
            this.add(new SubInt("NAM8"));
            this.add(new SubList(new SoundPackage()));
            this.add(new SubForm("CSCR"));
            this.add(new SubForm("DOFT"));
            this.add(new SubForm("SOFT"));
            this.add(new SubForm("DPLT"));
            this.add(new SubForm("CRIF"));
            this.add(new SubForm("FTST"));
            this.add(new SubRGB("QNAM"));
            this.add(new NAM9());
            this.add(new NAMA());
            this.add(new SubList(new TintLayer()));
        }
    };

    public void templateTo(NPC_ otherNPC, TemplateFlag ... flags) {
        TemplateFlag f;
        int n;
        int n2;
        TemplateFlag[] templateFlagArray;
        if (flags.length == 0) {
            ArrayList<TemplateFlag> flagsList = new ArrayList<TemplateFlag>();
            templateFlagArray = TemplateFlag.values();
            n2 = templateFlagArray.length;
            n = 0;
            while (n < n2) {
                f = templateFlagArray[n];
                if (this.get(f)) {
                    flagsList.add(f);
                }
                ++n;
            }
            flags = flagsList.toArray(flags);
        }
        NPC_ dup = (NPC_)Ln.deepCopy((Object)otherNPC);
        templateFlagArray = flags;
        n2 = flags.length;
        n = 0;
        while (n < n2) {
            f = templateFlagArray[n];
            if (this.templateToInternal(dup, f)) {
                this.set(f, false);
            }
            ++n;
        }
        boolean templated = false;
        TemplateFlag[] templateFlagArray2 = TemplateFlag.values();
        int n3 = templateFlagArray2.length;
        n2 = 0;
        while (n2 < n3) {
            TemplateFlag f2 = templateFlagArray2[n2];
            if (this.get(f2)) {
                templated = true;
                break;
            }
            ++n2;
        }
        if (!templated) {
            this.setTemplate(FormID.NULL);
        }
    }

    public void templateTo(FormID npc, TemplateFlag ... flags) {
        this.templateTo((NPC_)SPDatabase.getMajor(npc, GRUP_TYPE.NPC_), flags);
    }

    boolean templateToInternal(NPC_ otherNPC, TemplateFlag flag) {
        if (otherNPC == null) {
            return false;
        }
        if (otherNPC.get(flag)) {
            NPC_ otherNPCsTemplate = (NPC_)SPDatabase.getMajor(otherNPC.getTemplate(), GRUP_TYPE.NPC_);
            if (otherNPCsTemplate != null) {
                return this.templateToInternal(otherNPCsTemplate, flag);
            }
            return false;
        }
        switch (flag) {
            case USE_TRAITS: {
                this.set(NPCFlag.Female, otherNPC.get(NPCFlag.Female));
                this.setRace(otherNPC.getRace());
                this.setSkin(otherNPC.getSkin());
                this.setHeight(otherNPC.getHeight());
                this.setWeight(otherNPC.getWeight());
                this.setFarAwayModelSkin(otherNPC.getFarAwayModelSkin());
                this.setVoiceType(otherNPC.getVoiceType());
                this.getACBS().dispositionBase = otherNPC.getACBS().dispositionBase;
                this.setDeathItem(otherNPC.getDeathItem());
                this.set(NPCFlag.OppositeGenderAnims, otherNPC.get(NPCFlag.OppositeGenderAnims));
                this.setSoundVolume(otherNPC.getSoundVolume());
                this.setAudioTemplate(otherNPC.getAudioTemplate());
                this.subRecords.add(otherNPC.subRecords.getSubList("CSDT"));
                break;
            }
            case USE_STATS: {
                this.getACBS().level = otherNPC.getACBS().level;
                this.set(NPCFlag.PCLevelMult, otherNPC.get(NPCFlag.PCLevelMult));
                this.set(NPCStat.MIN_CALC_LEVEL, otherNPC.get(NPCStat.MIN_CALC_LEVEL));
                this.set(NPCStat.MAX_CALC_LEVEL, otherNPC.get(NPCStat.MAX_CALC_LEVEL));
                this.getACBS().healthOffset = otherNPC.getACBS().healthOffset;
                this.getACBS().magickaOffset = otherNPC.getACBS().magickaOffset;
                this.getACBS().fatigueOffset = otherNPC.getACBS().fatigueOffset;
                Skill[] skillArray = Skill.NPC_Skills();
                int n = skillArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Skill s = skillArray[n2];
                    this.set(s, otherNPC.get(s));
                    this.setMod(s, otherNPC.getMod(s));
                    ++n2;
                }
                this.getACBS().speed = otherNPC.getACBS().speed;
                this.getACBS().bleedout = otherNPC.getACBS().bleedout;
                this.setNPCClass(otherNPC.getNPCClass());
                break;
            }
            case USE_FACTIONS: {
                this.clearFactions();
                for (SubFormInt s : otherNPC.getFactions()) {
                    this.addFaction(s.getForm(), s.getNum());
                }
                this.setCrimeFaction(otherNPC.getCrimeFaction());
                break;
            }
            case USE_SPELL_LIST: {
                this.clearSpells();
                for (FormID f : otherNPC.getSpells()) {
                    this.addSpell(f);
                }
                this.clearPerks();
                for (SubFormInt s : otherNPC.getPerks()) {
                    this.addPerk(s.getForm(), s.getNum());
                }
                break;
            }
            case USE_AI_DATA: {
                this.setAggression(otherNPC.getAggression());
                this.setMood(otherNPC.getMood());
                this.setConfidence(otherNPC.getConfidence());
                this.setAssistance(otherNPC.getAssistance());
                this.setMorality(otherNPC.getMorality());
                this.setEnergy(otherNPC.getEnergy());
                this.set(NPCFlag.AggroRadiusBehavior, otherNPC.get(NPCFlag.AggroRadiusBehavior));
                this.setAggroWarn(otherNPC.getAggroWarn());
                this.setAggroWarnAttack(otherNPC.getAggroWarnAttack());
                this.setAggroAttack(otherNPC.getAggroAttack());
                this.setCombatStyle(otherNPC.getCombatStyle());
                this.setGiftFilter(otherNPC.getGiftFilter());
                break;
            }
            case USE_INVENTORY: {
                this.setDefaultOutfit(otherNPC.getDefaultOutfit());
                this.setSleepingOutfit(otherNPC.getSleepingOutfit());
                this.setGearedUpWeapons(otherNPC.getGearedUpWeapons());
                this.clearItems();
                for (ItemListing f : otherNPC.getItems()) {
                    this.addItem(new ItemListing(f.getForm(), f.getCount()));
                }
                break;
            }
            case USE_AI_PACKAGES: {
                this.clearAIPackages();
                for (FormID id : otherNPC.getAIPackages()) {
                    this.addAIPackage(id);
                }
                break;
            }
            case USE_DEF_PACK_LIST: {
                this.setDefaultPackageList(otherNPC.getDefaultPackageList());
                this.setSpectatorOverride(otherNPC.getSpectatorOverride());
                this.setObserveDeadOverride(otherNPC.getObserveDeadOverride());
                this.setGuardWornOverride(otherNPC.getGuardWornOverride());
                this.setCombatOverride(otherNPC.getCombatOverride());
                break;
            }
            case USE_ATTACK_DATA: {
                this.setAttackDataRace(otherNPC.getAttackDataRace());
                this.clearAttackPackages();
                for (AttackPackage a : otherNPC.getAttackPackages()) {
                    this.addAttackPackage(a);
                }
                break;
            }
            case USE_BASE_DATA: {
                this.setName(otherNPC.getName());
                this.setShortName(otherNPC.getShortName());
                this.set(NPCFlag.Essential, otherNPC.get(NPCFlag.Essential));
                this.set(NPCFlag.Protected, otherNPC.get(NPCFlag.Protected));
                this.set(NPCFlag.Respawn, otherNPC.get(NPCFlag.Respawn));
                this.set(NPCFlag.Summonable, otherNPC.get(NPCFlag.Summonable));
                this.set(NPCFlag.SimpleActor, otherNPC.get(NPCFlag.SimpleActor));
                this.set(NPCFlag.DoesntAffectStealthMeter, otherNPC.get(NPCFlag.DoesntAffectStealthMeter));
                break;
            }
            case USE_KEYWORDS: {
                this.subRecords.add(otherNPC.getKeywordSet());
            }
        }
        return true;
    }

    public LVLN isTemplatedToLList(TemplateFlag ... templateFlagsToCheck) {
        return NiftyFunc.isTemplatedToLList(this.getForm(), templateFlagsToCheck, 0);
    }

    NPC_() {
        this.subRecords.setPrototype(NPC_proto);
    }

    @Override
    ArrayList<String> getTypes() {
        return Record.getTypeList("NPC_");
    }

    @Override
    Record getNew() {
        return new NPC_();
    }

    ACBS getACBS() {
        return (ACBS)this.subRecords.get("ACBS");
    }

    public ScriptPackage getScriptPackage() {
        return this.subRecords.getScripts();
    }

    public void set(TemplateFlag flag, boolean on) {
        this.getACBS().templateFlags.set(flag.value, on);
    }

    public boolean get(TemplateFlag flag) {
        return this.getACBS().templateFlags.get(flag.value);
    }

    public ArrayList<SubFormInt> getFactions() {
        return this.subRecords.getSubList("SNAM").toPublic();
    }

    public boolean addFaction(FormID factionRef, int rank) {
        return this.subRecords.getSubList("SNAM").add(new SubFormInt("SNAM", factionRef, rank));
    }

    public boolean removeFaction(FormID factionRef) {
        return this.subRecords.getSubList("SNAM").remove(new SubFormInt("SNAM", factionRef, 0));
    }

    public void clearFactions() {
        this.subRecords.getSubList("SNAM").clear();
    }

    public ArrayList<SubFormInt> getPerks() {
        return this.subRecords.getSubList("PRKR").toPublic();
    }

    public void addPerk(FormID perkRef, int rank) {
        this.subRecords.getSubList("PRKR").add(new SubFormInt("PRKR", perkRef, rank));
    }

    public boolean removePerk(FormID perkRef) {
        return this.subRecords.getSubList("PRKR").remove(new SubFormInt("PRKR", perkRef, 0));
    }

    public void clearPerks() {
        this.subRecords.getSubList("PRKR").clear();
    }

    AIDT getAIDT() {
        return (AIDT)this.subRecords.get("AIDT");
    }

    public boolean get(NPCFlag flag) {
        switch (flag) {
            case AggroRadiusBehavior: {
                return this.getAIDT().aggroRadiusBehavior;
            }
        }
        return this.getACBS().ACBSflags.get(flag.value);
    }

    public void set(NPCFlag flag, boolean on) {
        switch (flag) {
            case AggroRadiusBehavior: {
                this.getAIDT().aggroRadiusBehavior = on;
                break;
            }
            default: {
                this.getACBS().ACBSflags.set(flag.value, on);
            }
        }
    }

    DNAM getDNAM() {
        return (DNAM)this.subRecords.get("DNAM");
    }

    public int get(Skill skill) {
        return this.getDNAM().getSkillBase(skill);
    }

    public void set(Skill skill, int value) {
        if (value < 0) {
            value = 0;
        }
        this.getDNAM().setSkillBase(skill, value);
    }

    public int getMod(Skill skill) {
        return this.getDNAM().getSkillMod(skill);
    }

    public void setMod(Skill skill, int value) {
        if (value < 0) {
            value = 0;
        }
        this.getDNAM().setSkillMod(skill, value);
    }

    public void setAggression(Aggression level) {
        this.getAIDT().aggression = level;
    }

    public Aggression getAggression() {
        return this.getAIDT().aggression;
    }

    public void setConfidence(Confidence level) {
        this.getAIDT().confidence = level;
    }

    public Confidence getConfidence() {
        return this.getAIDT().confidence;
    }

    public void setMorality(Morality level) {
        this.getAIDT().morality = level;
    }

    public Morality getMorality() {
        return this.getAIDT().morality;
    }

    public void setAssistance(Assistance level) {
        this.getAIDT().assistance = level;
    }

    public Assistance getAssistance() {
        return this.getAIDT().assistance;
    }

    public int get(NPCStat stat) {
        switch (stat) {
            case SPELL_POINTS_BASE: {
                return this.getACBS().magickaOffset;
            }
            case FATIGUE_BASE: {
                return this.getACBS().fatigueOffset;
            }
            case LEVEL: {
                return this.getACBS().level;
            }
            case MIN_CALC_LEVEL: {
                return this.getACBS().minCalcLevel;
            }
            case MAX_CALC_LEVEL: {
                return this.getACBS().maxCalcLevel;
            }
            case SPEED_MULT: {
                return this.getACBS().speed;
            }
            case DISPOSITION_BASE: {
                return this.getACBS().dispositionBase;
            }
        }
        return -1;
    }

    public void set(NPCStat stat, int value) {
        if (value < 0) {
            value = 0;
        }
        switch (stat) {
            case SPELL_POINTS_BASE: {
                this.getACBS().magickaOffset = value;
                break;
            }
            case FATIGUE_BASE: {
                this.getACBS().fatigueOffset = value;
                break;
            }
            case LEVEL: {
                this.getACBS().level = value;
                break;
            }
            case MIN_CALC_LEVEL: {
                this.getACBS().minCalcLevel = value;
                break;
            }
            case MAX_CALC_LEVEL: {
                this.getACBS().maxCalcLevel = value;
                break;
            }
            case SPEED_MULT: {
                this.getACBS().speed = value;
                break;
            }
            case DISPOSITION_BASE: {
                this.getACBS().dispositionBase = value;
            }
        }
    }

    public void setDeathItem(FormID deathItemRef) {
        this.subRecords.setSubForm("INAM", deathItemRef);
    }

    public FormID getDeathItem() {
        return this.subRecords.getSubForm("INAM").getForm();
    }

    public void setVoiceType(FormID voiceTypeRef) {
        this.subRecords.setSubForm("VTCK", voiceTypeRef);
    }

    public FormID getVoiceType() {
        return this.subRecords.getSubForm("VTCK").getForm();
    }

    public void setTemplate(FormID templateRef) {
        this.subRecords.setSubForm("TPLT", templateRef);
    }

    public FormID getTemplate() {
        return this.subRecords.getSubForm("TPLT").getForm();
    }

    public boolean isTemplated() {
        return !this.getTemplate().equals(FormID.NULL);
    }

    public void setRace(FormID raceRef) {
        this.subRecords.setSubForm("RNAM", raceRef);
    }

    public FormID getRace() {
        return this.subRecords.getSubForm("RNAM").getForm();
    }

    public ArrayList<FormID> getSpells() {
        return this.subRecords.getSubList("SPLO").toPublic();
    }

    public boolean addSpell(FormID spellReference) {
        return this.subRecords.getSubList("SPLO").add(spellReference);
    }

    public boolean removeSpell(FormID spellReference) {
        return this.subRecords.getSubList("SPLO").remove(spellReference);
    }

    public void clearSpells() {
        this.subRecords.getSubList("SPLO").clear();
    }

    public boolean addItem(FormID itemReference, int count) {
        return this.subRecords.getSubList("CNTO").add(new ItemListing(itemReference, count));
    }

    public boolean addItem(ItemListing item) {
        return this.subRecords.getSubList("CNTO").add(item);
    }

    public boolean removeItem(FormID itemReference) {
        return this.subRecords.getSubList("CNTO").remove(new ItemListing(itemReference));
    }

    public void clearItems() {
        this.subRecords.getSubList("CNTO").clear();
    }

    public ArrayList<ItemListing> getItems() {
        return this.subRecords.getSubList("CNTO").toPublic();
    }

    public ArrayList<FormID> getItemForms() {
        ArrayList<ItemListing> items = this.getItems();
        ArrayList<FormID> out = new ArrayList<FormID>(items.size());
        for (ItemListing item : items) {
            out.add(item.getForm());
        }
        return out;
    }

    public boolean addAIPackage(FormID aiPackageReference) {
        return this.subRecords.getSubList("PKID").add(aiPackageReference);
    }

    public boolean removeAIPackage(FormID aiPackageReference) {
        return this.subRecords.getSubList("PKID").remove(aiPackageReference);
    }

    public ArrayList<FormID> getAIPackages() {
        return this.subRecords.getSubList("PKID").toPublic();
    }

    public void clearAIPackages() {
        this.subRecords.getSubList("PKID").clear();
    }

    public void setNPCClass(FormID classReference) {
        this.subRecords.setSubForm("CNAM", classReference);
    }

    public FormID getNPCClass() {
        return this.subRecords.getSubForm("CNAM").getForm();
    }

    public void setHairColor(FormID hairColorRef) {
        this.subRecords.setSubForm("HCLF", hairColorRef);
    }

    public FormID getHairColor() {
        return this.subRecords.getSubForm("HCLF").getForm();
    }

    public void setSkin(FormID wornArmorRef) {
        this.subRecords.setSubForm("WNAM", wornArmorRef);
    }

    public FormID getSkin() {
        return this.subRecords.getSubForm("WNAM").getForm();
    }

    public void setAttackDataRace(FormID attackRaceRef) {
        this.subRecords.setSubForm("ATKR", attackRaceRef);
    }

    public FormID getAttackDataRace() {
        return this.subRecords.getSubForm("ATKR").getForm();
    }

    public void setDefaultOutfit(FormID defaultOutfitRef) {
        this.subRecords.setSubForm("DOFT", defaultOutfitRef);
    }

    public FormID getDefaultOutfit() {
        return this.subRecords.getSubForm("DOFT").getForm();
    }

    public void setSleepingOutfit(FormID sleepingOutfitRef) {
        this.subRecords.setSubForm("SOFT", sleepingOutfitRef);
    }

    public FormID getSleepingOutfit() {
        return this.subRecords.getSubForm("SOFT").getForm();
    }

    public void setCombatStyle(FormID combatRef) {
        this.subRecords.setSubForm("ZNAM", combatRef);
    }

    public FormID getCombatStyle() {
        return this.subRecords.getSubForm("ZNAM").getForm();
    }

    public void setCrimeFaction(FormID crimeFactionRef) {
        this.subRecords.setSubForm("CRIF", crimeFactionRef);
    }

    public FormID getCrimeFaction() {
        return this.subRecords.getSubForm("CRIF").getForm();
    }

    public void setFeatureSet(FormID headPartsRef) {
        this.subRecords.setSubForm("FTST", headPartsRef);
    }

    public FormID getFeatureSet() {
        return this.subRecords.getSubForm("FTST").getForm();
    }

    public void setAudioTemplate(FormID audioTemplateRef) {
        this.subRecords.setSubForm("CSCR", audioTemplateRef);
    }

    public FormID getAudioTemplate() {
        return this.subRecords.getSubForm("CSCR").getForm();
    }

    public void setDefaultPackageList(FormID list) {
        this.subRecords.setSubForm("DPLT", list);
    }

    public FormID getDefaultPackageList() {
        return this.subRecords.getSubForm("DPLT").getForm();
    }

    public void setHeight(float height) {
        this.subRecords.setSubFloat("NAM6", height);
    }

    public float getHeight() {
        return this.subRecords.getSubFloat("NAM6").get();
    }

    public void setWeight(float weight) {
        this.subRecords.setSubFloat("NAM7", weight);
    }

    public float getWeight() {
        return this.subRecords.getSubFloat("NAM7").get();
    }

    public void setFarAwayModelSkin(FormID id) {
        this.subRecords.setSubForm("ANAM", id);
    }

    public FormID getFarAwayModelSkin() {
        return this.subRecords.getSubForm("ANAM").getForm();
    }

    public void setFarAwayModelDistance(float dist) {
        this.getDNAM().farAwayDistance = dist;
    }

    public float getFarAwayModelDistance() {
        return this.getDNAM().farAwayDistance;
    }

    public void setHealthOffset(int value) {
        this.getACBS().healthOffset = value;
    }

    public int getHealthOffset() {
        return this.getACBS().healthOffset;
    }

    public void setMagickaOffset(int value) {
        this.getACBS().magickaOffset = value;
    }

    public int getMagickaOffset() {
        return this.getACBS().magickaOffset;
    }

    public void setFatigueOffset(int value) {
        this.getACBS().fatigueOffset = value;
    }

    public int getFatigueOffset() {
        return this.getACBS().fatigueOffset;
    }

    public void setMood(Mood value) {
        this.getAIDT().mood = value;
    }

    public Mood getMood() {
        return this.getAIDT().mood;
    }

    public void setEnergy(int energy) {
        this.getAIDT().energy = energy;
    }

    public int getEnergy() {
        return this.getAIDT().energy;
    }

    public void setAggroWarn(int aggro) {
        this.getAIDT().aggroWarn = aggro;
    }

    public int getAggroWarn() {
        return this.getAIDT().aggroWarn;
    }

    public void setAggroWarnAttack(int aggro) {
        this.getAIDT().aggroWarnAttack = aggro;
    }

    public int getAggroWarnAttack() {
        return this.getAIDT().aggroWarnAttack;
    }

    public void setAggroAttack(int aggro) {
        this.getAIDT().aggroAttack = aggro;
    }

    public int getAggroAttack() {
        return this.getAIDT().aggroAttack;
    }

    public void setGiftFilter(FormID id) {
        this.subRecords.setSubForm("GNAM", id);
    }

    public FormID getGiftFilter() {
        return this.subRecords.getSubForm("ACBS").getForm();
    }

    public void setGearedUpWeapons(int value) {
        this.getDNAM().gearedUpWeapons = value;
    }

    public int getGearedUpWeapons() {
        return this.getDNAM().gearedUpWeapons;
    }

    public void setSpectatorOverride(FormID list) {
        this.subRecords.setSubForm("SPOR", list);
    }

    public FormID getSpectatorOverride() {
        return this.subRecords.getSubForm("SPOR").getForm();
    }

    public void setObserveDeadOverride(FormID list) {
        this.subRecords.setSubForm("OCOR", list);
    }

    public FormID getObserveDeadOverride() {
        return this.subRecords.getSubForm("OCOR").getForm();
    }

    public void setGuardWornOverride(FormID list) {
        this.subRecords.setSubForm("GWOR", list);
    }

    public FormID getGuardWornOverride() {
        return this.subRecords.getSubForm("GWOR").getForm();
    }

    public void setCombatOverride(FormID list) {
        this.subRecords.setSubForm("ECOR", list);
    }

    public FormID getCombatOverride() {
        return this.subRecords.getSubForm("ECOR").getForm();
    }

    public void setShortName(String alias) {
        this.subRecords.setSubString("SHRT", alias);
    }

    public String getShortName() {
        return this.subRecords.getSubString("SHRT").print();
    }

    public void setSoundVolume(SoundVolume vol) {
        this.subRecords.setSubInt("NAM8", vol.ordinal());
    }

    public SoundVolume getSoundVolume() {
        return SoundVolume.values()[this.subRecords.getSubInt("NAM8").get()];
    }

    NAM9 getNAM9() {
        return (NAM9)this.subRecords.get("NAM9");
    }

    public void setFaceValue(FacePart part, float value) {
        switch (part) {
            case NoseLongShort: {
                this.getNAM9().noseLong = value;
                break;
            }
            case NoseUpDown: {
                this.getNAM9().noseUp = value;
                break;
            }
            case JawUpDown: {
                this.getNAM9().jawUp = value;
                break;
            }
            case JawNarrowWide: {
                this.getNAM9().jawWide = value;
                break;
            }
            case JawForwardBack: {
                this.getNAM9().jawForward = value;
                break;
            }
            case CheeksUpDown: {
                this.getNAM9().cheekUp = value;
                break;
            }
            case CheeksForwardBack: {
                this.getNAM9().cheekForward = value;
                break;
            }
            case EyesUpDown: {
                this.getNAM9().eyeUp = value;
                break;
            }
            case EyesInOut: {
                this.getNAM9().eyeIn = value;
                break;
            }
            case BrowsUpDown: {
                this.getNAM9().browUp = value;
                break;
            }
            case BrowsForwardBack: {
                this.getNAM9().browForward = value;
                break;
            }
            case LipsUpDown: {
                this.getNAM9().lipUp = value;
                break;
            }
            case LipsInOut: {
                this.getNAM9().lipIn = value;
                break;
            }
            case ChinThinWide: {
                this.getNAM9().chinWide = value;
                break;
            }
            case ChinUpDown: {
                this.getNAM9().chinUp = value;
                break;
            }
            case ChinOverbite: {
                this.getNAM9().chinOverbite = value;
                break;
            }
            case EyesForwardBack: {
                this.getNAM9().eyesForward = value;
            }
        }
        this.getNAM9().valid = true;
    }

    public float getFaceValue(FacePart part) {
        switch (part) {
            case NoseLongShort: {
                return this.getNAM9().noseLong;
            }
            case NoseUpDown: {
                return this.getNAM9().noseUp;
            }
            case JawUpDown: {
                return this.getNAM9().jawUp;
            }
            case JawNarrowWide: {
                return this.getNAM9().jawWide;
            }
            case JawForwardBack: {
                return this.getNAM9().jawForward;
            }
            case CheeksUpDown: {
                return this.getNAM9().cheekUp;
            }
            case CheeksForwardBack: {
                return this.getNAM9().cheekForward;
            }
            case EyesUpDown: {
                return this.getNAM9().eyeUp;
            }
            case EyesInOut: {
                return this.getNAM9().eyeIn;
            }
            case BrowsUpDown: {
                return this.getNAM9().browUp;
            }
            case BrowsForwardBack: {
                return this.getNAM9().browForward;
            }
            case LipsUpDown: {
                return this.getNAM9().lipUp;
            }
            case LipsInOut: {
                return this.getNAM9().lipIn;
            }
            case ChinThinWide: {
                return this.getNAM9().chinWide;
            }
            case ChinUpDown: {
                return this.getNAM9().chinUp;
            }
            case ChinOverbite: {
                return this.getNAM9().chinOverbite;
            }
        }
        return this.getNAM9().eyesForward;
    }

    public ArrayList<TintLayer> getTinting() {
        return this.subRecords.getSubList((String)"TINI").collection;
    }

    public boolean addTinting(TintLayer tinting) {
        return this.subRecords.getSubList("TINI").add(tinting);
    }

    public boolean removeTinting(TintLayer tinting) {
        return this.subRecords.getSubList("TINI").remove(tinting);
    }

    public void clearTinting() {
        this.subRecords.getSubList("TINI").clear();
    }

    public ArrayList<SoundPackage> getSounds() {
        return this.subRecords.getSubList((String)"CSDT").collection;
    }

    public boolean addSoundPackage(SoundPackage sounds) {
        return this.subRecords.getSubList("CSDT").add(sounds);
    }

    public boolean removeSoundPackage(SoundPackage sounds) {
        return this.subRecords.getSubList("CSDT").remove(sounds);
    }

    public void clearSoundPackages() {
        this.subRecords.getSubList("CSDT").clear();
    }

    public float getFaceTint(RGB color) {
        return this.subRecords.getSubRGB("QNAM").get(color);
    }

    public void setFaceTint(RGB color, float value) {
        this.subRecords.setSubRGB("QNAM", color, value);
    }

    NAMA getNAMA() {
        return (NAMA)this.subRecords.get("NAMA");
    }

    public int getNosePreset() {
        return this.getNAMA().nose;
    }

    public void setNosePreset(int val) {
        this.getNAMA().nose = val;
        this.getNAMA().valid = true;
    }

    public int getEyePreset() {
        return this.getNAMA().eyes;
    }

    public void setEyePreset(int val) {
        NAMA n = this.getNAMA();
        n.eyes = val;
        n.valid = true;
    }

    public int getMouthPreset() {
        return this.getNAMA().mouth;
    }

    public void setMouthPreset(int val) {
        NAMA n = this.getNAMA();
        n.mouth = val;
        n.valid = true;
    }

    public ArrayList<FormID> getHeadParts() {
        return this.subRecords.getSubList("PNAM").toPublic();
    }

    public void addHeadPart(FormID pnam) {
        this.subRecords.getSubList("PNAM").add(pnam);
    }

    public void removeHeadPart(FormID pnam) {
        this.subRecords.getSubList("PNAM").remove(pnam);
    }

    public void clearHeadParts() {
        this.subRecords.getSubList("PNAM").clear();
    }

    public ArrayList<AttackPackage> getAttackPackages() {
        return this.subRecords.getSubList("ATKD").toPublic();
    }

    public boolean addAttackPackage(AttackPackage attack) {
        return this.subRecords.getSubList("ATKD").add(attack);
    }

    public boolean removeAttackPackage(AttackPackage attack) {
        return this.subRecords.getSubList("ATKD").remove(attack);
    }

    public void clearAttackPackages() {
        this.subRecords.getSubList("ATKD").clear();
    }

    public KeywordSet getKeywordSet() {
        return this.subRecords.getKeywords();
    }

    static class ACBS
    extends SubRecord
    implements Serializable {
        LFlags ACBSflags = new LFlags(4);
        int magickaOffset = 0;
        int fatigueOffset = 0;
        int level = 0;
        int minCalcLevel = 0;
        int maxCalcLevel = 0;
        int speed = 100;
        int dispositionBase = 0;
        LFlags templateFlags = new LFlags(2);
        int healthOffset = 0;
        int bleedout = 0;

        ACBS() {
        }

        @Override
        SubRecord getNew(String type) {
            return new ACBS();
        }

        @Override
        final void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
            super.parseData(in, srcMod);
            this.ACBSflags.set(in.extract(4));
            this.magickaOffset = in.extractIntSigned(2);
            this.fatigueOffset = in.extractIntSigned(2);
            this.level = in.extractInt(2);
            this.minCalcLevel = in.extractInt(2);
            this.maxCalcLevel = in.extractInt(2);
            this.speed = in.extractInt(2);
            this.dispositionBase = in.extractIntSigned(2);
            this.templateFlags.set(in.extract(2));
            this.healthOffset = in.extractIntSigned(2);
            this.bleedout = in.extractInt(2);
            if (SPGlobal.logMods) {
                ACBS.logMod(srcMod, "", "ACBS record: ");
                ACBS.logMod(srcMod, "", "  Base Spell Points: " + this.magickaOffset + ", Base Fatigue: " + this.fatigueOffset);
                ACBS.logMod(srcMod, "", "  Level: " + this.level + ", Min Calculated Level: " + this.minCalcLevel + ", Max Calculated Level: " + this.maxCalcLevel);
                ACBS.logMod(srcMod, "", "  Speed Multiplier: " + this.speed + ", Disposition Base: " + this.dispositionBase);
            }
        }

        @Override
        void export(ModExporter out) throws IOException {
            super.export(out);
            out.write(this.ACBSflags.export(), 4);
            out.write(this.magickaOffset, 2);
            out.write(this.fatigueOffset, 2);
            out.write(this.level, 2);
            out.write(this.minCalcLevel, 2);
            out.write(this.maxCalcLevel, 2);
            out.write(this.speed, 2);
            out.write(this.dispositionBase, 2);
            out.write(this.templateFlags.export(), 2);
            out.write(this.healthOffset, 2);
            out.write(this.bleedout, 2);
        }

        @Override
        boolean isValid() {
            return true;
        }

        @Override
        int getContentLength(ModExporter out) {
            return 24;
        }

        @Override
        ArrayList<String> getTypes() {
            return Record.getTypeList("ACBS");
        }
    }

    static class AIDT
    extends SubRecord
    implements Serializable {
        Aggression aggression = Aggression.Unaggressive;
        Confidence confidence = Confidence.Cowardly;
        Morality morality = Morality.AnyCrime;
        Assistance assistance = Assistance.HelpsNobody;
        int energy = 0;
        Mood mood = Mood.Neutral;
        boolean aggroRadiusBehavior = false;
        byte[] fluff = new byte[1];
        int aggroWarn = 0;
        int aggroWarnAttack = 0;
        int aggroAttack = 0;

        AIDT() {
        }

        @Override
        SubRecord getNew(String type) {
            return new AIDT();
        }

        @Override
        final void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
            super.parseData(in, srcMod);
            this.aggression = Aggression.values()[in.extractInt(1)];
            this.confidence = Confidence.values()[in.extractInt(1)];
            this.energy = in.extractInt(1);
            this.morality = Morality.values()[in.extractInt(1)];
            this.mood = Mood.values()[in.extractInt(1)];
            this.assistance = Assistance.values()[in.extractInt(1)];
            this.aggroRadiusBehavior = in.extractBool(1);
            this.fluff = in.extract(1);
            this.aggroWarn = in.extractInt(4);
            this.aggroWarnAttack = in.extractInt(4);
            this.aggroAttack = in.extractInt(4);
            if (SPGlobal.logMods) {
                AIDT.logMod(srcMod, "", "AIDT record: ");
                AIDT.logMod(srcMod, "", "  Aggression: " + (Object)((Object)this.aggression) + ", Confidence: " + (Object)((Object)this.confidence) + ", Morality: " + (Object)((Object)this.morality));
                AIDT.logMod(srcMod, "", "  Assistance: " + (Object)((Object)this.assistance) + ", Mood: " + (Object)((Object)this.mood) + ", AggroRadiusBehavior: " + this.aggroRadiusBehavior);
                AIDT.logMod(srcMod, "", "  Aggro Attack: " + this.aggroAttack + ", Aggro Warn: " + this.aggroWarn + ", Aggro Warn/Attack: " + this.aggroWarnAttack);
            }
        }

        @Override
        void export(ModExporter out) throws IOException {
            super.export(out);
            out.write(this.aggression.ordinal(), 1);
            out.write(this.confidence.ordinal(), 1);
            out.write(this.energy, 1);
            out.write(this.morality.ordinal(), 1);
            out.write(this.mood.ordinal(), 1);
            out.write(this.assistance.ordinal(), 1);
            out.write(this.aggroRadiusBehavior, 1);
            out.write(this.fluff, 1);
            out.write(this.aggroWarn);
            out.write(this.aggroWarnAttack);
            out.write(this.aggroAttack);
        }

        @Override
        boolean isValid() {
            return true;
        }

        @Override
        int getContentLength(ModExporter out) {
            return 20;
        }

        @Override
        ArrayList<String> getTypes() {
            return Record.getTypeList("AIDT");
        }
    }

    static class ATKD
    extends SubRecord
    implements Serializable {
        float damageMult;
        float attackChance;
        FormID attackSpell = new FormID();
        LFlags flags = new LFlags(4);
        float attackAngle;
        float strikeAngle;
        float stagger;
        FormID attackType = new FormID();
        float knockdown;
        float recovery;
        float staminaMult;
        boolean valid = false;

        ATKD() {
        }

        @Override
        void export(ModExporter out) throws IOException {
            super.export(out);
            if (this.isValid()) {
                out.write(this.damageMult);
                out.write(this.attackChance);
                this.attackSpell.export(out);
                out.write(this.flags.export());
                out.write(this.attackAngle);
                out.write(this.strikeAngle);
                out.write(this.stagger);
                this.attackType.export(out);
                out.write(this.knockdown);
                out.write(this.recovery);
                out.write(this.staminaMult);
            }
        }

        @Override
        void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
            super.parseData(in, srcMod);
            this.damageMult = in.extractFloat();
            this.attackChance = in.extractFloat();
            this.attackSpell.parseData(in, srcMod);
            this.flags.set(in.extract(4));
            this.attackAngle = in.extractFloat();
            this.strikeAngle = in.extractFloat();
            this.stagger = in.extractFloat();
            this.attackType.parseData(in, srcMod);
            this.knockdown = in.extractFloat();
            this.recovery = in.extractFloat();
            this.staminaMult = in.extractFloat();
            this.valid = true;
        }

        @Override
        boolean isValid() {
            return this.valid;
        }

        @Override
        SubRecord getNew(String type) {
            return new ATKD();
        }

        @Override
        int getContentLength(ModExporter out) {
            return 44;
        }

        @Override
        ArrayList<FormID> allFormIDs() {
            ArrayList<FormID> out = new ArrayList<FormID>(2);
            out.add(this.attackSpell);
            out.add(this.attackType);
            return out;
        }

        @Override
        ArrayList<String> getTypes() {
            return Record.getTypeList("ATKD");
        }
    }

    public static enum Aggression {
        Unaggressive,
        Aggressive,
        VeryAggressive,
        Frenzied;

    }

    public static enum Assistance {
        HelpsNobody,
        HelpsAllies,
        HelpsFriends;

    }

    public static class AttackPackage
    extends SubShell
    implements Serializable {
        static SubPrototype attackPackageProto = new SubPrototype(){

            @Override
            protected void addRecords() {
                this.add(new ATKD());
                this.add(SubString.getNew("ATKE", true));
            }
        };

        AttackPackage() {
            super(attackPackageProto);
        }

        @Override
        SubRecord getNew(String type_) {
            return new AttackPackage();
        }

        ATKD getATKD() {
            return (ATKD)this.subRecords.get("ATKD");
        }

        void setATKD(ATKD rhs) {
            this.subRecords.add(rhs);
        }

        void setATKE(String in) {
            this.subRecords.setSubString("ATKE", in);
        }

        String getATKE() {
            return this.subRecords.getSubString("ATKE").print();
        }
    }

    public static enum Confidence {
        Cowardly,
        Cautious,
        Average,
        Brave,
        Foolhardy;

    }

    static class DNAM
    extends SubRecord
    implements Serializable {
        byte[] skills = new byte[36];
        int health = 1;
        int magicka = 1;
        int stamina = 1;
        byte[] fluff1 = new byte[2];
        float farAwayDistance = 0.0f;
        int gearedUpWeapons = 1;
        byte[] fluff2 = new byte[3];

        DNAM() {
        }

        @Override
        SubRecord getNew(String type) {
            return new DNAM();
        }

        @Override
        boolean isValid() {
            return true;
        }

        @Override
        int getContentLength(ModExporter out) {
            return 52;
        }

        int getSkillBase(Skill in) {
            return this.skills[Skill.NPC_Value(in)];
        }

        int getSkillMod(Skill in) {
            return this.skills[Skill.NPC_Value(in) + 18];
        }

        void setSkillBase(Skill in, int to) {
            this.skills[Skill.NPC_Value((Skill)in)] = (byte)to;
        }

        void setSkillMod(Skill in, int to) {
            this.skills[Skill.NPC_Value((Skill)in) + 18] = (byte)to;
        }

        @Override
        final void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
            super.parseData(in, srcMod);
            this.skills = in.extract(36);
            this.health = in.extractInt(2);
            this.magicka = in.extractInt(2);
            this.stamina = in.extractInt(2);
            this.fluff1 = in.extract(2);
            this.farAwayDistance = in.extractFloat();
            this.gearedUpWeapons = in.extractInt(1);
            this.fluff2 = in.extract(3);
            if (SPGlobal.logMods) {
                DNAM.logMod(srcMod, "", "DNAM record: ");
                Skill[] skillArray = Skill.NPC_Skills();
                int n = skillArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Skill s = skillArray[n2];
                    String temp = " BASE:" + this.getSkillBase(s) + ", MOD:" + this.getSkillMod(s);
                    DNAM.logMod(srcMod, "", "  " + s.toString() + Ln.spaceLeft((Boolean)false, (int)(15 - s.toString().length() + temp.length()), (char)' ', (String[])new String[]{temp}));
                    ++n2;
                }
                DNAM.logMod(srcMod, "", "  Health: " + this.health + ", Magicka: " + this.magicka + ", Stamina: " + this.stamina);
                DNAM.logMod(srcMod, "", "  Far Away Distance: " + this.farAwayDistance + ", Geared Up weapons: " + this.gearedUpWeapons);
            }
        }

        @Override
        void export(ModExporter out) throws IOException {
            super.export(out);
            out.write(this.skills, 36);
            out.write(this.health, 2);
            out.write(this.magicka, 2);
            out.write(this.stamina, 2);
            out.write(this.fluff1, 2);
            out.write(this.farAwayDistance);
            out.write(this.gearedUpWeapons, 1);
            out.write(this.fluff2, 3);
        }

        @Override
        ArrayList<String> getTypes() {
            return Record.getTypeList("DNAM");
        }
    }

    public static enum FacePart {
        NoseLongShort,
        NoseUpDown,
        JawUpDown,
        JawNarrowWide,
        JawForwardBack,
        CheeksUpDown,
        CheeksForwardBack,
        EyesUpDown,
        EyesInOut,
        BrowsUpDown,
        BrowsInOut,
        BrowsForwardBack,
        LipsUpDown,
        LipsInOut,
        ChinThinWide,
        ChinUpDown,
        ChinOverbite,
        EyesForwardBack;

    }

    public static enum Mood {
        Neutral,
        Angry,
        Fear,
        Happy,
        Sad,
        Surprised,
        Puzzled,
        Disgusted;

    }

    public static enum Morality {
        AnyCrime,
        ViolenceAgainstEnemies,
        PropertyCrimeOnly,
        NoCrime;

    }

    static class NAM9
    extends SubRecord
    implements Serializable {
        float noseLong = 0.0f;
        float noseUp = 0.0f;
        float jawUp = 0.0f;
        float jawWide = 0.0f;
        float jawForward = 0.0f;
        float cheekUp = 0.0f;
        float cheekForward = 0.0f;
        float eyeUp = 0.0f;
        float eyeIn = 0.0f;
        float browUp = 0.0f;
        float browIn = 0.0f;
        float browForward = 0.0f;
        float lipUp = 0.0f;
        float lipIn = 0.0f;
        float chinWide = 0.0f;
        float chinUp = 0.0f;
        float chinOverbite = 0.0f;
        float eyesForward = 0.0f;
        byte[] unknown = new byte[4];
        boolean valid = false;

        NAM9() {
        }

        @Override
        void export(ModExporter out) throws IOException {
            super.export(out);
            out.write(this.noseLong);
            out.write(this.noseUp);
            out.write(this.jawUp);
            out.write(this.jawWide);
            out.write(this.jawForward);
            out.write(this.cheekUp);
            out.write(this.cheekForward);
            out.write(this.eyeUp);
            out.write(this.eyeIn);
            out.write(this.browUp);
            out.write(this.browIn);
            out.write(this.browForward);
            out.write(this.lipUp);
            out.write(this.lipIn);
            out.write(this.chinWide);
            out.write(this.chinUp);
            out.write(this.chinOverbite);
            out.write(this.eyesForward);
            out.write(this.unknown, 4);
        }

        @Override
        void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
            super.parseData(in, srcMod);
            this.noseLong = in.extractFloat();
            this.noseUp = in.extractFloat();
            this.jawUp = in.extractFloat();
            this.jawWide = in.extractFloat();
            this.jawForward = in.extractFloat();
            this.cheekUp = in.extractFloat();
            this.cheekForward = in.extractFloat();
            this.eyeUp = in.extractFloat();
            this.eyeIn = in.extractFloat();
            this.browUp = in.extractFloat();
            this.browIn = in.extractFloat();
            this.browForward = in.extractFloat();
            this.lipUp = in.extractFloat();
            this.lipIn = in.extractFloat();
            this.chinWide = in.extractFloat();
            this.chinUp = in.extractFloat();
            this.chinOverbite = in.extractFloat();
            this.eyesForward = in.extractFloat();
            this.unknown = in.extract(4);
            this.valid = true;
        }

        @Override
        boolean isValid() {
            return this.valid;
        }

        @Override
        SubRecord getNew(String type) {
            return new NAM9();
        }

        @Override
        int getContentLength(ModExporter out) {
            return 76;
        }

        @Override
        ArrayList<String> getTypes() {
            return Record.getTypeList("NAM9");
        }
    }

    static class NAMA
    extends SubRecord
    implements Serializable {
        int nose;
        int unknown;
        int eyes;
        int mouth;
        boolean valid = false;

        NAMA() {
        }

        @Override
        void export(ModExporter out) throws IOException {
            super.export(out);
            out.write(this.nose);
            out.write(this.unknown);
            out.write(this.eyes);
            out.write(this.mouth);
        }

        @Override
        void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
            super.parseData(in, srcMod);
            this.nose = in.extractInt(4);
            this.unknown = in.extractInt(4);
            this.eyes = in.extractInt(4);
            this.mouth = in.extractInt(4);
            this.valid = true;
        }

        @Override
        SubRecord getNew(String type) {
            return new NAMA();
        }

        @Override
        boolean isValid() {
            return this.valid;
        }

        @Override
        int getContentLength(ModExporter out) {
            return 16;
        }

        @Override
        ArrayList<String> getTypes() {
            return Record.getTypeList("NAMA");
        }
    }

    public static enum NPCFlag {
        Female(0),
        Essential(1),
        IsCharGenFacePreset(2),
        Respawn(3),
        AutoCalcStats(4),
        Unique(5),
        PCLevelMult(7),
        Protected(13),
        Summonable(14),
        DoesntBleed(16),
        BleedoutOverride(18),
        OppositeGenderAnims(19),
        SimpleActor(20),
        DoesntAffectStealthMeter(21),
        IsGhost(29),
        Invulnerable(31),
        AggroRadiusBehavior(-1);

        int value;

        private NPCFlag(int value) {
            this.value = value;
        }
    }

    public static enum NPCStat {
        DISPOSITION_BASE,
        FATIGUE_BASE,
        LEVEL,
        MIN_CALC_LEVEL,
        MAX_CALC_LEVEL,
        SPEED_MULT,
        SPELL_POINTS_BASE;

    }

    public static enum SoundLocation {
        Idle,
        Aware,
        Attack,
        Hit,
        Death,
        Weapon,
        MovementLoop,
        ConsciousLoop;

    }

    public static class SoundPackage
    extends SubShell
    implements Serializable {
        static SubPrototype soundPackageProto = new SubPrototype(){

            @Override
            protected void addRecords() {
                this.add(new SubInt("CSDT"));
                this.add(new SubList(new SoundPair()));
            }
        };

        SoundPackage(SoundLocation location) {
            this();
            this.setLocation(location);
        }

        SoundPackage() {
            super(soundPackageProto);
        }

        @Override
        SubRecord getNew(String type_) {
            return new SoundPackage();
        }

        public final void setLocation(SoundLocation loc) {
            this.subRecords.setSubInt("CSDT", loc.ordinal());
        }

        public SoundLocation getLocation() {
            SubInt csdt = this.subRecords.getSubInt("CSDT");
            if (csdt.get() < SoundLocation.values().length) {
                return SoundLocation.values()[csdt.get()];
            }
            return SoundLocation.Idle;
        }

        public ArrayList<SoundPair> getSoundPairs() {
            return new ArrayList<SoundPair>(this.subRecords.getSubList("CSDI").toPublic());
        }

        public void addSoundPair(SoundPair pair) {
            this.subRecords.getSubList("CSDI").add(pair);
        }
    }

    public static class SoundPair
    extends SubShell {
        static SubPrototype soundPairProto = new SubPrototype(){

            @Override
            protected void addRecords() {
                this.add(new SubForm("CSDI"));
                this.forceExport("CSDI");
                this.add(new SubInt("CSDC", 1));
            }
        };

        SoundPair() {
            super(soundPairProto);
        }

        public SoundPair(FormID sound, int chance) {
            this();
            this.setChance(chance);
            this.setSound(sound);
        }

        public final void setChance(int chance) {
            if (chance < 0) {
                chance = 0;
            } else if (chance > 100) {
                chance = 100;
            }
            this.subRecords.setSubInt("CSDC", chance);
        }

        public int getChance() {
            return this.subRecords.getSubInt("CSDC").get();
        }

        public final void setSound(FormID sound) {
            this.subRecords.setSubForm("CSDI", sound);
        }

        public FormID getSound() {
            return this.subRecords.getSubForm("CSDI").getForm();
        }

        @Override
        SubRecord getNew(String type) {
            return new SoundPair();
        }
    }

    public static enum TemplateFlag {
        USE_TRAITS(0),
        USE_STATS(1),
        USE_FACTIONS(2),
        USE_SPELL_LIST(3),
        USE_AI_DATA(4),
        USE_AI_PACKAGES(5),
        USE_BASE_DATA(7),
        USE_INVENTORY(8),
        USE_SCRIPTS(9),
        USE_DEF_PACK_LIST(10),
        USE_ATTACK_DATA(11),
        USE_KEYWORDS(12);

        int value;

        private TemplateFlag(int in) {
            this.value = in;
        }
    }

    public static class TintLayer
    extends SubShell
    implements Serializable {
        static SubPrototype tintPrototype = new SubPrototype(){

            @Override
            protected void addRecords() {
                this.add(new SubInt("TINI", 2));
                this.add(new SubRGBshort("TINC"));
                this.add(new SubInt("TINV"));
                this.add(new SubIntSigned("TIAS", 2));
            }
        };

        TintLayer() {
            super(tintPrototype);
        }

        @Override
        SubRecord getNew(String type_) {
            return new TintLayer();
        }

        public TintLayer(int tini) {
            super(tintPrototype);
            this.setIndex(tini);
        }

        public void setIndex(int in) {
            this.subRecords.setSubInt("TINI", in);
        }

        public int getIndex() {
            return this.subRecords.getSubInt("TINI").get();
        }

        public void setColor(RGBA color, short value) {
            this.subRecords.setSubRGBshort("TINC", color, value);
        }

        public short getColor(RGBA color) {
            return this.subRecords.getSubRGBshort("TINC").get(color);
        }

        public void setInterpolation(float value) {
            int val = (int)(value * 100.0f);
            this.subRecords.setSubInt("TINV", val);
        }

        public float getInterpolation() {
            float val = (float)this.subRecords.getSubInt("TINV").get() / 100.0f;
            return val;
        }

        public void setPreset(int value) {
            this.subRecords.setSubInt("TIAS", value);
        }

        public int getPreset() {
            return this.subRecords.getSubInt("TIAS").get();
        }
    }
}

