/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import java.util.zip.DataFormatException;
import lev.LFlags;
import lev.LImport;
import skyproc.Consistency;
import skyproc.FormID;
import skyproc.GRUP;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.ModListing;
import skyproc.Record;
import skyproc.SPGlobal;
import skyproc.SubPrototype;
import skyproc.SubRecord;
import skyproc.SubRecords;
import skyproc.SubRecordsCopied;
import skyproc.SubRecordsDerived;
import skyproc.SubRecordsStream;
import skyproc.SubString;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;

public abstract class MajorRecord
extends Record
implements Serializable {
    static final HashMap<FormID, ArrayList<MajorRecord>> recordHistory = new HashMap();
    static final SubPrototype majorProto = new SubPrototype(){

        @Override
        protected void addRecords() {
            this.add(SubString.getNew("EDID", true));
        }
    };
    SubRecords subRecords = new SubRecordsStream(majorProto);
    private FormID ID = new FormID();
    LFlags majorFlags = new LFlags(4);
    byte[] revision = new byte[4];
    int formVersion = 40;
    byte[] version = new byte[2];
    Mod srcMod;

    MajorRecord() {
    }

    void originateFromPatch(String edid) {
        this.srcMod = SPGlobal.getGlobalPatch();
        this.subRecords.setMajor(this);
        this.setEDID(edid);
        this.srcMod.addRecord(this);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MajorRecord other = (MajorRecord)obj;
        if (!other.getType().equals(this.getType())) {
            return false;
        }
        return this.ID.equals(other.ID);
    }

    public boolean deepEquals(MajorRecord other) {
        if (!other.getType().equals(this.getType())) {
            return false;
        }
        return this.subRecords.equals(other.subRecords);
    }

    public int hashCode() {
        int hash = 3;
        hash = 37 * hash + Objects.hashCode(this.ID);
        return hash;
    }

    @Override
    public String toString() {
        String out = "[" + this.getType().toString() + " | ";
        if (this.ID.isStandardized().booleanValue()) {
            out = String.valueOf(out) + this.getFormStr();
        } else if (this.isValid()) {
            out = String.valueOf(out) + this.getFormArrayStr(true);
        }
        SubString EDID = this.subRecords.getSubString("EDID");
        if (EDID.isValid()) {
            out = String.valueOf(out) + " | " + EDID.print();
        }
        return String.valueOf(out) + "]";
    }

    MajorRecord copyOf(Mod modToOriginateFrom) {
        return this.copyOf(modToOriginateFrom, String.valueOf(this.getEDID()) + "_DUP");
    }

    MajorRecord copyOf(Mod modToOriginateFrom, String edid) {
        MajorRecord out = (MajorRecord)this.getNew();
        out.formVersion = this.formVersion;
        out.version = Arrays.copyOf(this.version, this.version.length);
        out.srcMod = modToOriginateFrom;
        out.ID = new FormID();
        out.majorFlags = new LFlags(this.majorFlags);
        System.arraycopy(this.revision, 0, out.revision, 0, this.revision.length);
        System.arraycopy(this.version, 0, out.version, 0, this.version.length);
        out.subRecords = new SubRecordsCopied(this.subRecords);
        out.setEDID(edid);
        modToOriginateFrom.addRecord(out);
        return out;
    }

    public MajorRecord copy(String edid) {
        return SPGlobal.getGlobalPatch().makeCopy(this, edid);
    }

    @Override
    boolean isValid() {
        if (this.ID == null) {
            return false;
        }
        return this.ID.isValid();
    }

    @Override
    void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
        super.parseData(in, srcMod);
        this.majorFlags = new LFlags(in.extract(4));
        this.ID.parseData(in, srcMod);
        this.revision = in.extract(4);
        this.formVersion = in.extractInt(2);
        this.version = in.extract(2);
        if (this.get(MajorFlags.Compressed)) {
            this.set(MajorFlags.Compressed, false);
            in = in.correctForCompression();
            if (SPGlobal.logMods) {
                MajorRecord.logMod(srcMod, this.getTypes().toString(), "Decompressed");
            }
        }
        if (!in.isDone().booleanValue() && "EDID".equals(MajorRecord.getNextType(in))) {
            SubString EDID = this.subRecords.getSubString("EDID");
            EDID.parseData(EDID.extractRecordData(in), srcMod);
        }
        this.importSubRecords(in);
        ArrayList<MajorRecord> versions = recordHistory.get(this.ID);
        if (versions == null) {
            versions = new ArrayList();
            recordHistory.put(this.ID, versions);
        }
        versions.add(this);
    }

    void importSubRecords(LImport in) throws BadRecord, DataFormatException, BadParameter {
        this.subRecords.importSubRecords(in, this.srcMod);
    }

    ArrayList<FormID> allFormIDs() {
        ArrayList<FormID> out = new ArrayList<FormID>();
        out.add(this.ID);
        out.addAll(this.subRecords.allFormIDs());
        return out;
    }

    @Override
    public String print() {
        MajorRecord.logMod(this.srcMod, this.getTypes().toString(), "Form ID: " + this.getFormStr() + ", EDID: " + this.getEDID());
        return "";
    }

    @Override
    int getFluffLength() {
        return 16;
    }

    @Override
    int getContentLength(ModExporter out) {
        if (this.get(MajorFlags.Deleted) && !SPGlobal.forceValidateMode) {
            return 0;
        }
        return this.subRecords.length(out);
    }

    @Override
    int getTotalLength(ModExporter out) {
        int len = super.getTotalLength(out);
        if (this.shouldExportGRUP()) {
            len += this.getGRUPAppend().getTotalLength(out);
        }
        return len;
    }

    @Override
    int getSizeLength() {
        return 4;
    }

    @Override
    void export(ModExporter out) throws IOException {
        out.setSourceMod(this.srcMod);
        out.setSourceMajor(this);
        super.export(out);
        if (this.isValid()) {
            out.write(this.majorFlags.export(), 4);
            this.ID.export(out);
            out.write(this.revision, 4);
            out.write(this.formVersion, 2);
            out.write(this.version, 2);
            if (!this.get(MajorFlags.Deleted) || SPGlobal.forceValidateMode) {
                this.subRecords.export(out);
            }
            if (SPGlobal.deleteAfterExport) {
                SubRecord edid = this.subRecords.get("EDID");
                this.subRecords = new SubRecordsDerived(this.subRecords.getPrototype());
                this.subRecords.add(edid);
            }
            if (this.shouldExportGRUP()) {
                this.getGRUPAppend().export(out);
            }
        }
    }

    public final void setEDID(String edid) {
        if (SPGlobal.getGlobalPatch().equals(this.srcMod)) {
            edid = Consistency.edidFilter(edid);
            Consistency.syncIDwithEDID(edid, this);
            this.subRecords.getSubString("EDID").setString(edid);
        }
    }

    public final String getEDID() {
        return this.subRecords.getSubString("EDID").print();
    }

    public void setForm(FormID in) {
        this.ID = in;
    }

    public FormID getForm() {
        return this.ID;
    }

    public String getFormStr() {
        return this.ID.getFormStr();
    }

    String getFormArrayStr(Boolean master) {
        return this.ID.getArrayStr(master);
    }

    public ModListing getFormMaster() {
        return this.ID.getMaster();
    }

    public ModListing getModImportedFrom() {
        return this.srcMod.getInfo();
    }

    public void set(MajorFlags flag, Boolean on) {
        this.majorFlags.set(flag.value, on.booleanValue());
    }

    public boolean get(MajorFlags flag) {
        return this.majorFlags.get(flag.value);
    }

    GRUP getGRUPAppend() {
        return null;
    }

    boolean shouldExportGRUP() {
        return false;
    }

    public ArrayList<MajorRecord> getRecordHistory() {
        return new ArrayList<MajorRecord>((Collection)recordHistory.get(this.ID));
    }

    public static enum MajorFlags {
        ESM(0),
        Unknown2(1),
        NonPlayable(2),
        Unknown4(3),
        Unknown5(4),
        Deleted(5),
        RelatedToShields(6),
        Localized(7),
        Inaccessible(8),
        HiddenFromLocalMap(9),
        QuestItemPersistentRef(10),
        InitiallyDisabled(11),
        Ignored(12),
        ActorChanged(13),
        Unknown15(14),
        VisibleWhenDistant(15),
        RandomAnimationStart(16),
        DangerousOffLimits(17),
        Compressed(18),
        CantWait(19),
        IgnoreObjectInteraction(20),
        UsedinMemoryChangedForm(21),
        Unknown23(22),
        IsMarker(23),
        Unknown25(24),
        Obstacle(25),
        NavMeshFilter(26),
        NavMeshBoundingBox(27),
        MustExitToTalk(28),
        ChildCanUse(29),
        NavMeshGround(30),
        MultiBound(31);

        int value;

        private MajorFlags(int value) {
            this.value = value;
        }
    }
}

