/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.DataFormatException;
import lev.LFlags;
import lev.LImport;
import skyproc.FormID;
import skyproc.KeywordSet;
import skyproc.MGEF;
import skyproc.MagicEffectRef;
import skyproc.MajorRecordDescription;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.Record;
import skyproc.SPGlobal;
import skyproc.SubData;
import skyproc.SubList;
import skyproc.SubPrototype;
import skyproc.SubRecord;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;
import skyproc.genenums.CastType;
import skyproc.genenums.DeliveryType;

public abstract class MagicItem
extends MajorRecordDescription {
    static final SubPrototype magicItemProto = new SubPrototype(MajorRecordDescription.descProto){

        @Override
        protected void addRecords() {
            this.add(new SubData("OBND", new byte[12]));
            this.reposition("FULL");
            this.reposition("DESC");
            this.add(new SubList(new MagicEffectRef()));
            this.add(new KeywordSet());
        }
    };

    MagicItem() {
    }

    public ArrayList<MagicEffectRef> getMagicEffects() {
        return this.subRecords.getSubList("EFID").toPublic();
    }

    public void removeMagicEffect(MagicEffectRef magicEffect) {
        this.subRecords.getSubList("EFID").remove(magicEffect);
    }

    public void addMagicEffect(MagicEffectRef magicEffect) {
        this.subRecords.getSubList("EFID").add(magicEffect);
    }

    public void addMagicEffect(MGEF magicEffect) {
        this.subRecords.getSubList("EFID").add(new MagicEffectRef(magicEffect.getForm()));
    }

    public void clearMagicEffects() {
        this.subRecords.getSubList("EFID").clear();
    }

    public static enum SPELFlag {
        ManualCostCalculation(0),
        PCStartSpell(17),
        AreaEffectIgnoresLOS(19),
        IgnoreResistance(20),
        NoAbsorbOrReflect(21),
        NoDualCastModification(23);

        int value;

        private SPELFlag(int valuein) {
            this.value = valuein;
        }
    }

    static class SPIT
    extends SubRecord {
        int baseCost = 0;
        LFlags flags = new LFlags(4);
        int baseType = 0;
        float chargeTime = 0.0f;
        CastType castType = CastType.ConstantEffect;
        DeliveryType targetType = DeliveryType.Self;
        float castDuration = 0.0f;
        float range = 0.0f;
        boolean valid = false;
        FormID perkType = new FormID();

        SPIT() {
        }

        @Override
        SubRecord getNew(String type) {
            return new SPIT();
        }

        @Override
        final void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
            super.parseData(in, srcMod);
            this.baseCost = in.extractInt(4);
            this.flags = new LFlags(in.extract(4));
            this.baseType = in.extractInt(4);
            this.chargeTime = in.extractFloat();
            this.castType = CastType.values()[in.extractInt(4)];
            this.targetType = DeliveryType.values()[in.extractInt(4)];
            this.castDuration = in.extractFloat();
            this.range = in.extractFloat();
            this.perkType.parseData(in, srcMod);
            if (SPGlobal.logMods) {
                SPIT.logMod(srcMod, "", "SPIT record: ");
                SPIT.logMod(srcMod, "", "  Base Spell Cost: " + this.baseCost + ", flags: " + this.flags + ", Base Type: " + this.baseType + ", Spell Charge Time: " + this.chargeTime);
                SPIT.logMod(srcMod, "", "  cast type: " + (Object)((Object)this.castType) + ", targetType: " + (Object)((Object)this.targetType) + ", Cast Duration: " + this.castDuration + ", Spell Range: " + this.range + ", Perk for Spell: " + this.perkType);
            }
            this.valid = true;
        }

        @Override
        void export(ModExporter out) throws IOException {
            super.export(out);
            if (this.isValid()) {
                out.write(this.baseCost);
                out.write(this.flags.export(), 4);
                out.write(this.baseType);
                out.write(this.chargeTime);
                out.write(this.castType.ordinal());
                out.write(this.targetType.ordinal());
                out.write(this.castDuration);
                out.write(this.range);
                this.perkType.export(out);
            }
        }

        @Override
        boolean isValid() {
            return this.valid;
        }

        @Override
        int getContentLength(ModExporter out) {
            if (this.isValid()) {
                return 36;
            }
            return 0;
        }

        @Override
        ArrayList<FormID> allFormIDs() {
            ArrayList<FormID> out = new ArrayList<FormID>(1);
            out.add(this.perkType);
            return out;
        }

        @Override
        ArrayList<String> getTypes() {
            return Record.getTypeList("SPIT");
        }
    }
}

