/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.DataFormatException;
import lev.LImport;
import skyproc.Condition;
import skyproc.FormID;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.Record;
import skyproc.SubForm;
import skyproc.SubList;
import skyproc.SubPrototype;
import skyproc.SubRecord;
import skyproc.SubShellBulkType;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;

public class MagicEffectRef
extends SubShellBulkType {
    static SubPrototype magicEffProto = new SubPrototype(){

        @Override
        protected void addRecords() {
            this.add(new SubForm("EFID"));
            this.add(new EFIT());
            this.add(new SubList(new Condition()));
        }
    };

    public MagicEffectRef(FormID magicEffectRef) {
        this();
        this.subRecords.setSubForm("EFID", magicEffectRef);
    }

    MagicEffectRef() {
        super(magicEffProto, false);
    }

    @Override
    SubRecord getNew(String type) {
        return new MagicEffectRef();
    }

    @Override
    boolean isValid() {
        return this.subRecords.isAnyValid();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MagicEffectRef other = (MagicEffectRef)obj;
        return this.getMagicRef().equals(other.getMagicRef());
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + this.getMagicRef().hashCode();
        return hash;
    }

    public void setMagicRef(FormID magicRef) {
        this.subRecords.setSubForm("EFID", magicRef);
    }

    public FormID getMagicRef() {
        return this.subRecords.getSubForm("EFID").getForm();
    }

    EFIT getEFIT() {
        return (EFIT)this.subRecords.get("EFIT");
    }

    public void setMagnitude(float magnitude) {
        this.getEFIT().magnitude = magnitude;
    }

    public float getMagnitude() {
        return this.getEFIT().magnitude;
    }

    public void setAreaOfEffect(int aoe) {
        this.getEFIT().AOE = aoe;
    }

    public int getAreaOfEffect() {
        return this.getEFIT().AOE;
    }

    public void setDuration(int duration) {
        this.getEFIT().duration = duration;
    }

    public int getDuration() {
        return this.getEFIT().duration;
    }

    public ArrayList<Condition> getConditions() {
        return this.subRecords.getSubList("CTDA").toPublic();
    }

    public void addCondition(Condition c) {
        this.subRecords.getSubList("CTDA").add(c);
    }

    public void removeCondition(Condition c) {
        this.subRecords.getSubList("CTDA").remove(c);
    }

    static class EFIT
    extends SubRecord {
        float magnitude = 0.0f;
        int AOE = 0;
        int duration = 0;

        EFIT() {
        }

        @Override
        void export(ModExporter out) throws IOException {
            super.export(out);
            out.write(this.magnitude);
            out.write(this.AOE);
            out.write(this.duration);
        }

        @Override
        void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
            super.parseData(in, srcMod);
            this.magnitude = in.extractFloat();
            this.AOE = in.extractInt(4);
            this.duration = in.extractInt(4);
        }

        @Override
        SubRecord getNew(String type) {
            return new EFIT();
        }

        @Override
        boolean isValid() {
            return true;
        }

        @Override
        int getContentLength(ModExporter out) {
            return 12;
        }

        @Override
        ArrayList<String> getTypes() {
            return Record.getTypeList("EFIT");
        }
    }
}

