/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import lev.Ln;
import skyproc.FormID;
import skyproc.LeveledEntry;
import skyproc.MajorRecord;
import skyproc.SPDatabase;
import skyproc.SubData;
import skyproc.SubFlag;
import skyproc.SubForm;
import skyproc.SubListCounted;
import skyproc.SubPrototype;
import skyproc.exceptions.BadParameter;

public abstract class LeveledRecord
extends MajorRecord
implements Iterable<LeveledEntry> {
    static final SubPrototype LeveledProto = new SubPrototype(MajorRecord.majorProto){

        @Override
        protected void addRecords() {
            this.add(new SubData("OBND", new byte[12]));
            this.add(new SubData("LVLD", new byte[1]));
            this.add(new SubFlag("LVLF", 1));
            this.add(new SubForm("LVLG"));
            this.add(new SubListCounted<LeveledEntry>("LLCT", 1, new LeveledEntry()));
        }
    };

    LeveledRecord() {
        this.subRecords.setPrototype(LeveledProto);
    }

    public LeveledRecord(String edid) {
        this();
        this.originateFromPatch(edid);
        this.set(LVLFlag.CalcAllLevelsEqualOrBelowPC, true);
    }

    @Override
    public Iterator<LeveledEntry> iterator() {
        return this.subRecords.getSubList("LVLO").iterator();
    }

    public void clearEntries() {
        this.subRecords.getSubList("LVLO").clear();
    }

    public ArrayList<LeveledEntry> getEntries() {
        return this.subRecords.getSubList("LVLO").toPublic();
    }

    public ArrayList<FormID> getEntryForms() {
        ArrayList<LeveledEntry> entries = this.getEntries();
        ArrayList<FormID> out = new ArrayList<FormID>(entries.size());
        for (LeveledEntry e : entries) {
            out.add(e.getForm());
        }
        return out;
    }

    public ArrayList<LeveledEntry> getFlattenedEntries() {
        ArrayList<LeveledEntry> out = new ArrayList<LeveledEntry>();
        for (LeveledEntry entry : this.getEntries()) {
            MajorRecord o = SPDatabase.getMajor(entry.getForm());
            if (o instanceof LeveledRecord) {
                out.addAll(((LeveledRecord)o).getFlattenedEntries());
                continue;
            }
            out.add(entry);
        }
        return out;
    }

    public void addEntry(LeveledEntry entry) {
        this.subRecords.getSubList("LVLO").add(entry);
    }

    public void addEntry(FormID id, int level, int count) {
        this.addEntry(new LeveledEntry(id, level, count));
    }

    public int numEntries() {
        return this.subRecords.getSubList("LVLO").size();
    }

    public Boolean isEmpty() {
        if (this.numEntries() == 0) {
            return true;
        }
        return false;
    }

    public LeveledEntry getEntry(int i) {
        return (LeveledEntry)this.subRecords.getSubList("LVLO").get(i);
    }

    public void removeEntry(int i) {
        this.subRecords.getSubList("LVLO").remove(i);
    }

    public void removeFirstEntry(FormID id) {
        ArrayList<LeveledEntry> list = this.getEntries();
        int i = 0;
        while (i < list.size()) {
            if (list.get(i).getForm().equals(id)) {
                list.remove(i);
                break;
            }
            ++i;
        }
    }

    public void removeAllEntries(FormID id) {
        ArrayList<LeveledEntry> list = this.getEntries();
        int i = 0;
        while (i < list.size()) {
            if (list.get(i).getForm().equals(id)) {
                list.remove(i);
                continue;
            }
            ++i;
        }
    }

    public void reduce() {
        LListSummary sum = new LListSummary(this);
        sum.reduce();
        this.setTo(sum);
    }

    void setTo(LListSummary sum) {
        this.clearEntries();
        for (LListEntry e : sum.entries) {
            int i = 0;
            while (i < e.numEntries) {
                this.addEntry(e.id, e.level, e.count);
                ++i;
            }
        }
    }

    public Double getChanceNonePct() {
        SubData lvld = this.subRecords.getSubData("LVLD");
        if (lvld.isValid()) {
            return (double)lvld.toInt() / 100.0;
        }
        return 0.0;
    }

    public void setChanceNone(int in) throws BadParameter {
        if (in < 0 || in > 100) {
            throw new BadParameter("Chance none set outside range 0-100: " + in);
        }
        this.subRecords.setSubData("LVLD", in, 1);
    }

    public int getChanceNone() {
        return this.subRecords.getSubData("LVLD").toInt();
    }

    public boolean get(LVLFlag flag) {
        return this.subRecords.getSubFlag("LVLF").is(flag.ordinal());
    }

    public final void set(LVLFlag flag, boolean on) {
        this.subRecords.setSubFlag("LVLF", flag.ordinal(), on);
    }

    public FormID getGlobalForm() {
        return this.subRecords.getSubForm("LVLG").getForm();
    }

    public void setGlobalForm(FormID id) {
        this.subRecords.setSubForm("LVLG", id);
    }

    public final boolean contains(MajorRecord target) {
        for (LeveledEntry entry : this) {
            if (!entry.getForm().equals(target.getForm())) continue;
            return true;
        }
        return false;
    }

    public final int replace(MajorRecord target, MajorRecord replacement) {
        int out = 0;
        FormID targetF = target.getForm();
        FormID replaceF = replacement.getForm();
        for (LeveledEntry entry : this) {
            if (!entry.getForm().equals(targetF)) continue;
            ++out;
            entry.setForm(replaceF);
        }
        return out;
    }

    public void splitEntries() {
        this.reduce();
        if (this.numEntries() <= 255) {
            return;
        }
        int numSplits = (int)((double)this.numEntries() / 255.0 + 1.0);
        int numPerSplit = this.numEntries() / numSplits;
        ArrayList<LeveledEntry> list = this.getEntries();
        ArrayList<LListSummary> sums = new ArrayList<LListSummary>(numSplits);
        int i = 0;
        while (i < numSplits) {
            int index = i * numPerSplit;
            int max = index + numPerSplit;
            if (max > list.size()) {
                max = list.size();
            }
            LListSummary sum = new LListSummary(list.subList(index, max));
            sum.reduce();
            sums.add(sum);
            ++i;
        }
        this.clearEntries();
        i = 0;
        while (i < sums.size()) {
            LListSummary s = (LListSummary)sums.get(i);
            LListEntry e = s.oneEntry();
            if (e == null) {
                LeveledRecord copy = (LeveledRecord)this.copy(String.valueOf(this.getEDID()) + "_" + i);
                copy.setTo(s);
                this.addEntry(copy.getForm(), 1, 1);
            } else {
                this.addEntry(e.id, e.level, e.count);
            }
            ++i;
        }
    }

    static class LListEntry {
        FormID id;
        int level;
        int count;
        int numEntries = 1;

        LListEntry(LeveledEntry e) {
            this.id = e.getForm();
            this.level = e.getLevel();
            this.count = e.getCount();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LListEntry other = (LListEntry)obj;
            if (!Objects.equals(this.id, other.id)) {
                return false;
            }
            if (this.level != other.level) {
                return false;
            }
            return this.count == other.count;
        }

        public int hashCode() {
            int hash = 7;
            hash = 47 * hash + Objects.hashCode(this.id);
            hash = 47 * hash + this.level;
            hash = 47 * hash + this.count;
            return hash;
        }
    }

    static class LListSummary {
        ArrayList<LListEntry> entries = new ArrayList();

        LListSummary(LeveledRecord in) {
            this(in.getEntries());
        }

        LListSummary(Collection<LeveledEntry> in) {
            for (LeveledEntry e : in) {
                LListEntry trans = new LListEntry(e);
                int existing = this.entries.indexOf(trans);
                if (existing != -1) {
                    ++this.entries.get((int)existing).numEntries;
                    continue;
                }
                this.entries.add(trans);
            }
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LListSummary other = (LListSummary)obj;
            if (this.entries.size() != other.entries.size()) {
                return false;
            }
            for (LListEntry entry : other.entries) {
                if (this.entries.contains(entry)) continue;
                return false;
            }
            return true;
        }

        public void reduce() {
            int[] divs = new int[this.entries.size()];
            int i = 0;
            while (i < divs.length) {
                divs[i] = this.entries.get((int)i).numEntries;
                ++i;
            }
            int reduc = Ln.gcd((int[])divs);
            if (reduc != 1) {
                for (LListEntry e : this.entries) {
                    e.numEntries /= reduc;
                }
            }
        }

        public LListEntry oneEntry() {
            if (this.entries.size() == 1) {
                return this.entries.get(0);
            }
            return null;
        }
    }

    public static enum LVLFlag {
        CalcAllLevelsEqualOrBelowPC,
        CalcForEachItemInCount,
        UseAll,
        SpecialLoot;

    }
}

