/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.zip.DataFormatException;
import lev.LFlags;
import lev.LImport;
import skyproc.AltTextures;
import skyproc.DestructionData;
import skyproc.FormID;
import skyproc.MajorRecordNamed;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.Model;
import skyproc.Record;
import skyproc.ScriptPackage;
import skyproc.SubData;
import skyproc.SubFloat;
import skyproc.SubForm;
import skyproc.SubPrototype;
import skyproc.SubRecord;
import skyproc.SubString;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;

public class LIGH
extends MajorRecordNamed {
    static final SubPrototype LIGHproto = new SubPrototype(MajorRecordNamed.namedProto){

        @Override
        protected void addRecords() {
            this.after(new ScriptPackage(), "EDID");
            this.add(new SubData("OBND", new byte[12]));
            this.add(new Model());
            this.add(new DestructionData());
            this.reposition("FULL");
            this.add(SubString.getNew("ICON", true));
            this.add(SubString.getNew("MICO", true));
            this.add(new DATA());
            this.add(new SubFloat("FNAM"));
            this.add(new SubForm("SNAM"));
        }
    };

    LIGH() {
        this.subRecords.setPrototype(LIGHproto);
    }

    @Override
    Record getNew() {
        return new LIGH();
    }

    @Override
    ArrayList<String> getTypes() {
        return Record.getTypeList("LIGH");
    }

    public void setModel(String path) {
        this.subRecords.getModel().setFileName(path);
    }

    public String getModel() {
        return this.subRecords.getModel().getFileName();
    }

    DATA getDATA() {
        return (DATA)this.subRecords.get("DATA");
    }

    public void set(LIGHFlag flag, boolean on) {
        this.getDATA().flags.set(flag.ordinal() + 1, on);
    }

    public boolean get(LIGHFlag flag) {
        return this.getDATA().flags.get(flag.ordinal() + 1);
    }

    public void setValue(int gold) {
        this.getDATA().value = gold;
    }

    public int getValue() {
        return this.getDATA().value;
    }

    public int getBlue() {
        return this.getDATA().blue;
    }

    public void setBlue(int blue) {
        this.getDATA().blue = blue;
    }

    public float getFalloff() {
        return this.getDATA().falloff;
    }

    public void setFalloff(float falloff) {
        this.getDATA().falloff = falloff;
    }

    public float getFov() {
        return this.getDATA().fov;
    }

    public void setFov(float fov) {
        this.getDATA().fov = fov;
    }

    public int getGreen() {
        return this.getDATA().green;
    }

    public void setGreen(int green) {
        this.getDATA().green = green;
    }

    public float getIntensity() {
        return this.getDATA().intensity;
    }

    public void setIntensity(float intensity) {
        this.getDATA().intensity = intensity;
    }

    public float getMovement() {
        return this.getDATA().movement;
    }

    public void setMovement(float movement) {
        this.getDATA().movement = movement;
    }

    public float getNearclip() {
        return this.getDATA().nearclip;
    }

    public void setNearclip(float nearclip) {
        this.getDATA().nearclip = nearclip;
    }

    public float getPeriod() {
        return this.getDATA().period;
    }

    public void setPeriod(float period) {
        this.getDATA().period = period;
    }

    public int getRadius() {
        return this.getDATA().radius;
    }

    public void setRadius(int radius) {
        this.getDATA().radius = radius;
    }

    public int getRed() {
        return this.getDATA().red;
    }

    public void setRed(int red) {
        this.getDATA().red = red;
    }

    public int getTime() {
        return this.getDATA().time;
    }

    public void setTime(int time) {
        this.getDATA().time = time;
    }

    public float getWeight() {
        return this.getDATA().weight;
    }

    public void setWeight(float weight) {
        this.getDATA().weight = weight;
    }

    public ArrayList<AltTextures.AltTexture> getAltTextures() {
        return this.subRecords.getModel().getAltTextures();
    }

    public Model getModelData() {
        return this.subRecords.getModel();
    }

    static class DATA
    extends SubRecord {
        int time = 0;
        int radius = 0;
        int red = 0;
        int blue = 0;
        int green = 0;
        int holder = 0;
        LFlags flags = new LFlags(4);
        float falloff = 0.0f;
        float fov = 0.0f;
        float nearclip;
        float period = 0.0f;
        float intensity = 0.0f;
        float movement = 0.0f;
        int value = 0;
        float weight = 0.0f;

        DATA() {
        }

        @Override
        void export(ModExporter out) throws IOException {
            super.export(out);
            out.write(this.time);
            out.write(this.radius);
            out.write(this.red, 1);
            out.write(this.blue, 1);
            out.write(this.green, 1);
            out.write(this.holder, 1);
            out.write(this.flags.export(), 4);
            out.write(this.falloff);
            out.write(this.fov);
            out.write(this.nearclip);
            out.write(this.period);
            out.write(this.intensity);
            out.write(this.movement);
            out.write(this.value);
            out.write(this.weight);
        }

        @Override
        void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
            super.parseData(in, srcMod);
            this.time = in.extractInt(4);
            this.radius = in.extractInt(4);
            this.red = in.extractInt(1);
            this.blue = in.extractInt(1);
            this.green = in.extractInt(1);
            this.holder = in.extractInt(1);
            this.flags.set(in.extract(4));
            this.falloff = in.extractFloat();
            this.fov = in.extractFloat();
            this.nearclip = in.extractFloat();
            this.period = in.extractFloat();
            this.intensity = in.extractFloat();
            this.movement = in.extractFloat();
            this.value = in.extractInt(4);
            this.weight = in.extractFloat();
        }

        @Override
        SubRecord getNew(String type) {
            return new DATA();
        }

        @Override
        int getContentLength(ModExporter out) {
            return 48;
        }

        @Override
        ArrayList<FormID> allFormIDs() {
            ArrayList<FormID> out = new ArrayList<FormID>(0);
            return out;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DATA other = (DATA)obj;
            if (this.time != other.time) {
                return false;
            }
            if (this.radius != other.radius) {
                return false;
            }
            if (this.red != other.red) {
                return false;
            }
            if (this.blue != other.blue) {
                return false;
            }
            if (this.green != other.green) {
                return false;
            }
            if (this.holder != other.holder) {
                return false;
            }
            if (!Objects.equals(this.flags, other.flags)) {
                return false;
            }
            if (Float.floatToIntBits(this.falloff) != Float.floatToIntBits(other.falloff)) {
                return false;
            }
            if (Float.floatToIntBits(this.fov) != Float.floatToIntBits(other.fov)) {
                return false;
            }
            if (Float.floatToIntBits(this.nearclip) != Float.floatToIntBits(other.nearclip)) {
                return false;
            }
            if (Float.floatToIntBits(this.period) != Float.floatToIntBits(other.period)) {
                return false;
            }
            if (Float.floatToIntBits(this.intensity) != Float.floatToIntBits(other.intensity)) {
                return false;
            }
            if (Float.floatToIntBits(this.movement) != Float.floatToIntBits(other.movement)) {
                return false;
            }
            if (this.value != other.value) {
                return false;
            }
            return Float.floatToIntBits(this.weight) == Float.floatToIntBits(other.weight);
        }

        public int hashCode() {
            int hash = 7;
            hash = 89 * hash + this.time;
            hash = 89 * hash + this.radius;
            hash = 89 * hash + this.red;
            hash = 89 * hash + this.blue;
            hash = 89 * hash + this.green;
            hash = 89 * hash + this.holder;
            hash = 89 * hash + Objects.hashCode(this.flags);
            hash = 89 * hash + Float.floatToIntBits(this.falloff);
            hash = 89 * hash + Float.floatToIntBits(this.fov);
            hash = 89 * hash + Float.floatToIntBits(this.nearclip);
            hash = 89 * hash + Float.floatToIntBits(this.period);
            hash = 89 * hash + Float.floatToIntBits(this.intensity);
            hash = 89 * hash + Float.floatToIntBits(this.movement);
            hash = 89 * hash + this.value;
            hash = 89 * hash + Float.floatToIntBits(this.weight);
            return hash;
        }

        @Override
        ArrayList<String> getTypes() {
            return Record.getTypeList("DATA");
        }
    }

    public static enum LIGHFlag {
        Dynamic,
        CanBeCarried,
        Negative,
        Flicker,
        Unknown,
        OffByDefault,
        FlickerSlow,
        Pulse,
        PulseSlow,
        Spotlight,
        ShadowSpotlight,
        ShadowHemisphere,
        ShadowOmnidirectional,
        PortalStrict;

    }
}

