/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.DataFormatException;
import lev.LImport;
import lev.LOutFile;
import skyproc.FormID;
import skyproc.MajorRecord;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.Record;
import skyproc.SubPrototype;
import skyproc.SubRecord;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;

public class LGTM
extends MajorRecord {
    static final SubPrototype LGTMproto = new SubPrototype(MajorRecord.majorProto){

        @Override
        protected void addRecords() {
            this.add(new DATA());
            this.add(new DALC());
        }
    };

    LGTM() {
        this.subRecords.setPrototype(LGTMproto);
    }

    @Override
    Record getNew() {
        return new LGTM();
    }

    @Override
    ArrayList<String> getTypes() {
        return Record.getTypeList("LGTM");
    }

    static Color extractColor(LImport in) {
        return new Color(in.extractInt(1), in.extractInt(1), in.extractInt(1), in.extractInt(1));
    }

    static void writeColor(LOutFile out, Color c) throws IOException {
        out.write(c.getRed(), 1);
        out.write(c.getGreen(), 1);
        out.write(c.getBlue(), 1);
        out.write(c.getAlpha(), 1);
    }

    static class DALC
    extends SubRecord {
        Color dirAmbXpos = new Color(0, 0, 0, 0);
        Color dirAmbXneg = new Color(0, 0, 0, 0);
        Color dirAmbYpos = new Color(0, 0, 0, 0);
        Color dirAmbYneg = new Color(0, 0, 0, 0);
        Color dirAmbZpos = new Color(0, 0, 0, 0);
        Color dirAmbZneg = new Color(0, 0, 0, 0);
        Color specular = new Color(0, 0, 0, 0);
        float fresnelPower = 0.0f;

        DALC() {
        }

        @Override
        void export(ModExporter out) throws IOException {
            super.export(out);
            LGTM.writeColor(out, this.dirAmbXpos);
            LGTM.writeColor(out, this.dirAmbXneg);
            LGTM.writeColor(out, this.dirAmbYpos);
            LGTM.writeColor(out, this.dirAmbYneg);
            LGTM.writeColor(out, this.dirAmbZpos);
            LGTM.writeColor(out, this.dirAmbZneg);
            LGTM.writeColor(out, this.specular);
            out.write(this.fresnelPower);
        }

        @Override
        void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
            super.parseData(in, srcMod);
            this.dirAmbXpos = LGTM.extractColor(in);
            this.dirAmbXneg = LGTM.extractColor(in);
            this.dirAmbYpos = LGTM.extractColor(in);
            this.dirAmbYneg = LGTM.extractColor(in);
            this.dirAmbZpos = LGTM.extractColor(in);
            this.dirAmbZneg = LGTM.extractColor(in);
            this.specular = LGTM.extractColor(in);
            this.fresnelPower = in.extractFloat();
        }

        @Override
        SubRecord getNew(String type) {
            return new DALC();
        }

        @Override
        int getContentLength(ModExporter out) {
            return 32;
        }

        @Override
        ArrayList<FormID> allFormIDs() {
            ArrayList<FormID> out = new ArrayList<FormID>(0);
            return out;
        }

        @Override
        ArrayList<String> getTypes() {
            return Record.getTypeList("DALC");
        }
    }

    static class DATA
    extends SubRecord {
        Color amb = new Color(0, 0, 0, 0);
        Color dir = new Color(0, 0, 0, 0);
        Color fog = new Color(0, 0, 0, 0);
        float fogNear = 0.0f;
        float fogFar = 0.0f;
        int dirRotationXY = 0;
        int dirRotationZ = 0;
        float dirFade = 0.0f;
        float fogClipDist = 0.0f;
        float fogPower = 0.0f;
        byte[] unknown;
        Color fogFarColor = new Color(0, 0, 0, 0);
        float fogMax = 0.0f;
        float lightFadeStart = 0.0f;
        float lightFadeEnd = 0.0f;
        byte[] unknown2 = new byte[4];

        DATA() {
        }

        @Override
        void export(ModExporter out) throws IOException {
            super.export(out);
            LGTM.writeColor(out, this.amb);
            LGTM.writeColor(out, this.dir);
            LGTM.writeColor(out, this.fog);
            out.write(this.fogNear);
            out.write(this.fogFar);
            out.write(this.dirRotationXY, 4);
            out.write(this.dirRotationZ, 4);
            out.write(this.dirFade);
            out.write(this.fogClipDist);
            out.write(this.fogPower);
            out.write(this.unknown, 32);
            LGTM.writeColor(out, this.fogFarColor);
            out.write(this.fogMax);
            out.write(this.lightFadeStart);
            out.write(this.lightFadeEnd);
            out.write(this.unknown2, 4);
        }

        @Override
        void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
            super.parseData(in, srcMod);
            this.amb = LGTM.extractColor(in);
            this.dir = LGTM.extractColor(in);
            this.fog = LGTM.extractColor(in);
            this.fogNear = in.extractFloat();
            this.fogFar = in.extractFloat();
            this.dirRotationXY = in.extractInt(4);
            this.dirRotationZ = in.extractInt(4);
            this.dirFade = in.extractFloat();
            this.fogClipDist = in.extractFloat();
            this.fogPower = in.extractFloat();
            this.unknown = in.extract(32);
            this.fogFarColor = LGTM.extractColor(in);
            this.fogMax = in.extractFloat();
            this.lightFadeStart = in.extractFloat();
            this.lightFadeEnd = in.extractFloat();
            this.unknown2 = in.extract(4);
        }

        @Override
        SubRecord getNew(String type) {
            return new DATA();
        }

        @Override
        int getContentLength(ModExporter out) {
            return 92;
        }

        @Override
        ArrayList<FormID> allFormIDs() {
            ArrayList<FormID> out = new ArrayList<FormID>(0);
            return out;
        }

        @Override
        ArrayList<String> getTypes() {
            return Record.getTypeList("DATA");
        }
    }
}

