/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.zip.DataFormatException;
import lev.LImport;
import skyproc.FormID;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.SubData;
import skyproc.SubFormArray;
import skyproc.SubRecord;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;

public class KeywordSet
extends SubRecord {
    private static final ArrayList<String> type = new ArrayList<String>(Arrays.asList("KSIZ", "KWDA"));
    SubData counter = new SubData("KSIZ", 0);
    SubFormArray keywords = new SubFormArray("KWDA", 0);

    KeywordSet() {
    }

    @Override
    SubRecord getNew(String type) {
        return new KeywordSet();
    }

    @Override
    boolean isValid() {
        return this.keywords.isValid();
    }

    @Override
    int getHeaderLength() {
        return 0;
    }

    @Override
    int getContentLength(ModExporter out) {
        return this.counter.getTotalLength(out) + this.keywords.getTotalLength(out);
    }

    @Override
    void export(ModExporter out) throws IOException {
        if (this.isValid()) {
            this.counter.setData(this.keywords.size(), 4);
            this.counter.export(out);
            this.keywords.export(out);
        }
    }

    @Override
    void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
        switch (KeywordSet.getNextType(in)) {
            case "KSIZ": {
                this.counter.parseData(in, srcMod);
                break;
            }
            case "KWDA": {
                this.keywords.parseData(in, srcMod);
            }
        }
    }

    @Override
    ArrayList<FormID> allFormIDs() {
        return this.keywords.IDs;
    }

    public ArrayList<FormID> getKeywordRefs() {
        return new ArrayList<FormID>(this.keywords.IDs);
    }

    public void addKeywordRef(FormID keywordRef) {
        if (!this.keywords.contains(keywordRef)) {
            this.keywords.add(keywordRef);
        }
    }

    public void removeKeywordRef(FormID keywordRef) {
        this.keywords.remove(keywordRef);
    }

    public void clearKeywordRefs() {
        this.keywords.clear();
        this.counter.setData(0, 4);
    }

    public boolean containedIn(KeywordSet set) {
        return this.keywords.containedIn(set.keywords);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KeywordSet other = (KeywordSet)obj;
        return this.keywords == other.keywords || this.keywords != null && this.keywords.equals(other.keywords);
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + (this.keywords != null ? this.keywords.hashCode() : 0);
        return hash;
    }

    @Override
    ArrayList<String> getTypes() {
        return type;
    }
}

