/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.DataFormatException;
import lev.LFlags;
import lev.LImport;
import skyproc.Condition;
import skyproc.FormID;
import skyproc.MajorRecord;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.Record;
import skyproc.ScriptPackage;
import skyproc.StringNonNull;
import skyproc.SubData;
import skyproc.SubForm;
import skyproc.SubInt;
import skyproc.SubList;
import skyproc.SubPrototype;
import skyproc.SubRecord;
import skyproc.SubRecordTyped;
import skyproc.SubShell;
import skyproc.SubShellBulkType;
import skyproc.SubString;
import skyproc.SubStringPointer;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;
import skyproc.genenums.EmotionType;
import skyproc.genenums.FavorLevel;

public class INFO
extends MajorRecord {
    static final SubPrototype responseProto = new SubPrototype(){

        @Override
        protected void addRecords() {
            this.add(new TRDT());
            this.add(new SubStringPointer("NAM1", SubStringPointer.Files.ILSTRINGS));
            this.add(new SubString("NAM2"));
            this.add(new SubData("NAM3"));
            this.add(new SubForm("SNAM"));
            this.add(new SubForm("LNAM"));
        }
    };
    static final SubPrototype INFOprototype = new SubPrototype(MajorRecord.majorProto){

        @Override
        protected void addRecords() {
            this.add(new ScriptPackage(new ScriptFragments()));
            this.add(new SubData("DATA"));
            this.add(new ENAM());
            this.add(new SubForm("TPIC"));
            this.add(new SubForm("PNAM"));
            this.add(new SubInt("CNAM", 1));
            this.add(new SubList(new SubForm("TCLT")));
            this.add(new SubForm("DNAM"));
            this.add(new SubList(new SubShellBulkType(responseProto, false)));
            this.add(new SubList(new Condition()));
            this.add(new SubList(new SubShell(new SubPrototype(){

                @Override
                protected void addRecords() {
                    this.add(new SubData("SCHR"));
                    this.add(new SubForm("QNAM"));
                    this.add(new SubData("NEXT"));
                }
            })));
            this.add(new SubStringPointer("RNAM", SubStringPointer.Files.STRINGS));
            this.add(new SubForm("ANAM"));
            this.add(new SubForm("TWAT"));
            this.add(new SubForm("ONAM"));
        }
    };

    INFO() {
        this.subRecords.setPrototype(INFOprototype);
    }

    @Override
    ArrayList<String> getTypes() {
        return Record.getTypeList("INFO");
    }

    @Override
    Record getNew() {
        return new INFO();
    }

    public ScriptPackage getScriptPackage() {
        return this.subRecords.getScripts();
    }

    ENAM getENAM() {
        return (ENAM)this.subRecords.get("ENAM");
    }

    public void set(ResponseFlag res, boolean on) {
        this.getENAM().flags.set(res.value, on);
    }

    public boolean get(ResponseFlag res) {
        return this.getENAM().flags.get(res.value);
    }

    public void setResetTime(float hours) {
        this.getENAM().hoursReset = (int)((hours /= 24.0f) * 65535.0f);
    }

    public float getResetTime() {
        float tmp = (float)this.getENAM().hoursReset / 65535.0f;
        return tmp * 24.0f;
    }

    public void setTopic(FormID id) {
        this.subRecords.setSubForm("TPIC", id);
    }

    public FormID getTopic() {
        return this.subRecords.getSubForm("TPIC").getForm();
    }

    public void setPreviousINFO(FormID id) {
        this.subRecords.setSubForm("PNAM", id);
    }

    public FormID getPreviousINFO() {
        return this.subRecords.getSubForm("PNAM").getForm();
    }

    public void setFavorLevel(FavorLevel lev) {
        this.subRecords.setSubInt("CNAM", lev.ordinal());
    }

    public FavorLevel getFavorLevel() {
        return FavorLevel.values()[this.subRecords.getSubInt("CNAM").get()];
    }

    public ArrayList<FormID> getLinkTo() {
        return this.subRecords.getSubList("TCLT").toPublic();
    }

    public void removeLinkTo(FormID id) {
        this.subRecords.getSubList("TCLT").remove(id);
    }

    public void addLinkTo(FormID id) {
        this.subRecords.getSubList("TCLT").add(id);
    }

    public void clearLinkTo() {
        this.subRecords.getSubList("TCLT").clear();
    }

    public void setResponseData(FormID id) {
        this.subRecords.setSubForm("DNAM", id);
    }

    public FormID getResponseData() {
        return this.subRecords.getSubForm("DNAM").getForm();
    }

    public ArrayList<Condition> getConditions() {
        return this.subRecords.getSubList("CTDA").toPublic();
    }

    public void addCondition(Condition c) {
        this.subRecords.getSubList("CTDA").add(c);
    }

    public void removeCondition(Condition c) {
        this.subRecords.getSubList("CTDA").remove(c);
    }

    public ArrayList<Response> getResponses() {
        return this.subRecords.getSubList("TRDT").toPublic();
    }

    public void setPrompt(String text) {
        this.subRecords.setSubStringPointer("RNAM", text);
    }

    public String getPrompt() {
        return this.subRecords.getSubStringPointer("RNAM").print();
    }

    public void setSpeaker(FormID id) {
        this.subRecords.setSubForm("ANAM", id);
    }

    public FormID getSpeaker() {
        return this.subRecords.getSubForm("ANAM").getForm();
    }

    public void setWalkAwayTopic(FormID id) {
        this.subRecords.setSubForm("TWAT", id);
    }

    public FormID getWalkAwayTopic() {
        return this.subRecords.getSubForm("TWAT").getForm();
    }

    public void setAudioOverride(FormID id) {
        this.subRecords.setSubForm("ONAM", id);
    }

    public FormID getAudioOverride() {
        return this.subRecords.getSubForm("ONAM").getForm();
    }

    static class ENAM
    extends SubRecordTyped {
        LFlags flags;
        int hoursReset = 0;

        public ENAM() {
            super("ENAM");
        }

        @Override
        void export(ModExporter out) throws IOException {
            super.export(out);
            out.write(this.flags.export(), 2);
            out.write(this.hoursReset, 2);
        }

        @Override
        void parseData(LImport in, Mod srcMod) throws BadRecord, BadParameter, DataFormatException {
            super.parseData(in, srcMod);
            this.flags = new LFlags(2);
            this.flags.set(in.extract(2));
            this.hoursReset = in.extractInt(2);
        }

        @Override
        boolean isValid() {
            return this.flags != null;
        }

        @Override
        SubRecord getNew(String type) {
            return new ENAM();
        }

        @Override
        int getContentLength(ModExporter out) {
            return 4;
        }
    }

    public class Response
    extends SubShell {
        Response() {
            super(responseProto);
        }

        TRDT getTRDT() {
            return (TRDT)this.subRecords.get("TRDT");
        }

        public void setEmotionType(EmotionType type) {
            this.getTRDT().emotion = type;
        }

        public EmotionType getEmotionType() {
            return this.getTRDT().emotion;
        }

        public void setEmotionValue(int val) {
            this.getTRDT().emotionValue = val %= 100;
        }

        public int getEmotionValue() {
            return this.getTRDT().emotionValue;
        }

        public void setResponseText(String text) {
            this.subRecords.setSubStringPointer("NAM1", text);
        }

        public String getResponseText() {
            return this.subRecords.getSubStringPointer("NAM1").print();
        }

        public void setActorNotes(String text) {
            this.subRecords.setSubStringPointer("NAM2", text);
        }

        public String getActorNotes() {
            return this.subRecords.getSubStringPointer("NAM2").print();
        }

        public void setIdleAnimSpeaker(FormID id) {
            this.subRecords.setSubForm("SNAM", id);
        }

        public FormID getIdleAnimSpeaker() {
            return this.subRecords.getSubForm("SNAM").getForm();
        }

        public void setIdleAnimListener(FormID id) {
            this.subRecords.setSubForm("LNAM", id);
        }

        public FormID getIdleAnimListener() {
            return this.subRecords.getSubForm("LNAM").getForm();
        }
    }

    public static enum ResponseFlag {
        Goodbye(0),
        Random(1),
        SayOnce(2),
        RandomEnd(5),
        InvisibleContinue(6),
        WalkAway(7),
        WalkAwayInvisbleInMenu(8),
        ForceSubtitle(9),
        CanMoveWhileGreeting(10),
        HasNoLipFile(11),
        RequiresPostProcessing(12),
        AudioOutputOverride(13),
        SpendsFavorPoints(14);

        int value;

        private ResponseFlag(int val) {
            this.value = val;
        }
    }

    static class ScriptFragment {
        byte unknown = 0;
        StringNonNull scriptName = new StringNonNull();
        StringNonNull fragmentName = new StringNonNull();

        ScriptFragment() {
        }

        void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
            this.unknown = in.extract(1)[0];
            this.scriptName.set(in.extractString(in.extractInt(2)));
            this.fragmentName.set(in.extractString(in.extractInt(2)));
        }

        void export(ModExporter out) throws IOException {
            out.write(this.unknown, 1);
            this.scriptName.export(out);
            this.fragmentName.export(out);
        }

        int getContentLength(ModExporter out) {
            return 1 + this.scriptName.getTotalLength(out) + this.fragmentName.getTotalLength(out);
        }
    }

    static class ScriptFragments
    extends SubRecord {
        byte unknown = 0;
        LFlags fragmentFlags = new LFlags(1);
        StringNonNull fragmentFile = new StringNonNull();
        ArrayList<ScriptFragment> fragments = new ArrayList();
        boolean valid = false;

        ScriptFragments() {
        }

        @Override
        void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
            this.unknown = in.extract(1)[0];
            this.fragmentFlags.set(in.extract(1));
            this.fragmentFile.set(in.extractString(in.extractInt(2)));
            while (!in.isDone().booleanValue()) {
                ScriptFragment frag = new ScriptFragment();
                frag.parseData(in, srcMod);
                this.fragments.add(frag);
            }
            this.valid = true;
        }

        @Override
        void export(ModExporter out) throws IOException {
            if (!this.valid) {
                return;
            }
            out.write(this.unknown, 1);
            out.write(this.fragmentFlags.export());
            this.fragmentFile.export(out);
            for (ScriptFragment frag : this.fragments) {
                frag.export(out);
            }
        }

        @Override
        int getContentLength(ModExporter out) {
            if (!this.valid) {
                return 0;
            }
            int len = 2;
            len += this.fragmentFile.getTotalLength(out);
            for (ScriptFragment frag : this.fragments) {
                len += frag.getContentLength(out);
            }
            return len;
        }

        @Override
        SubRecord getNew(String type) {
            return new ScriptFragments();
        }

        @Override
        ArrayList<String> getTypes() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    static class TRDT
    extends SubRecordTyped {
        EmotionType emotion = EmotionType.Neutral;
        int emotionValue = 0;
        byte[] fluff = new byte[16];

        public TRDT() {
            super("TRDT");
        }

        @Override
        void export(ModExporter out) throws IOException {
            super.export(out);
            out.write(this.emotion.ordinal());
            out.write(this.emotionValue);
            out.write(this.fluff);
        }

        @Override
        void parseData(LImport in, Mod srcMod) throws BadRecord, BadParameter, DataFormatException {
            super.parseData(in, srcMod);
            this.emotion = EmotionType.values()[in.extractInt(4)];
            this.emotionValue = in.extractInt(4);
            this.fluff = in.extract(16);
        }

        @Override
        SubRecord getNew(String type) {
            return new TRDT();
        }

        @Override
        int getContentLength(ModExporter out) {
            return 24;
        }
    }
}

