/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.DataFormatException;
import lev.LImport;
import skyproc.MajorRecord;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.Record;
import skyproc.SPGlobal;
import skyproc.SubData;
import skyproc.SubPrototype;
import skyproc.SubRecord;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;

public class IMGS
extends MajorRecord {
    static final SubPrototype IMGSproto = new SubPrototype(MajorRecord.majorProto){

        @Override
        protected void addRecords() {
            this.add(new SubData("ENAM"));
            this.add(new HNAM());
            this.add(new CNAM());
            this.add(new TNAM());
            this.add(new DNAM());
        }
    };

    public IMGS() {
        this.subRecords.setPrototype(IMGSproto);
    }

    @Override
    ArrayList<String> getTypes() {
        return Record.getTypeList("IMGS");
    }

    @Override
    Record getNew() {
        return new IMGS();
    }

    HNAM getHNAM() {
        return (HNAM)this.subRecords.get("HNAM");
    }

    CNAM getCNAM() {
        return (CNAM)this.subRecords.get("CNAM");
    }

    TNAM getTNAM() {
        return (TNAM)this.subRecords.get("TNAM");
    }

    DNAM getDNAM() {
        return (DNAM)this.subRecords.get("DNAM");
    }

    public float getEyeAdaptSpeed() {
        return this.getHNAM().eyeAdaptSpeed;
    }

    public float getBloomRadius() {
        return this.getHNAM().bloomRadius;
    }

    public float getBloomThreshold() {
        return this.getHNAM().bloomThreshold;
    }

    public float getBloomScale() {
        return this.getHNAM().bloomScale;
    }

    public float getTargetLum1() {
        return this.getHNAM().targetLum1;
    }

    public float getTargetLum2() {
        return this.getHNAM().targetLum2;
    }

    public float getSunlightScale() {
        return this.getHNAM().sunlightScale;
    }

    public float getSkyScale() {
        return this.getHNAM().skyScale;
    }

    public float getEyeAdaptStrength() {
        return this.getHNAM().eyeAdaptStrength;
    }

    public void setEyeAdaptSpeed(float in) {
        this.getHNAM().eyeAdaptSpeed = in;
    }

    public void setBloomRadius(float in) {
        this.getHNAM().bloomRadius = in;
    }

    public void setBloomThreshold(float in) {
        this.getHNAM().bloomThreshold = in;
    }

    public void setBloomScale(float in) {
        this.getHNAM().bloomScale = in;
    }

    public void setTargetLum1(float in) {
        this.getHNAM().targetLum1 = in;
    }

    public void setTargetLum2(float in) {
        this.getHNAM().targetLum2 = in;
    }

    public void setSunlightScale(float in) {
        this.getHNAM().sunlightScale = in;
    }

    public void setSkyScale(float in) {
        this.getHNAM().skyScale = in;
    }

    public void setEyeAdaptStrength(float in) {
        this.getHNAM().eyeAdaptStrength = in;
    }

    public float getSaturation() {
        return this.getCNAM().saturation;
    }

    public float getBrightness() {
        return this.getCNAM().brightness;
    }

    public float getContrast() {
        return this.getCNAM().contrast;
    }

    public float getRed() {
        return this.getTNAM().red;
    }

    public float getBlue() {
        return this.getTNAM().blue;
    }

    public float getGreen() {
        return this.getTNAM().green;
    }

    public float getAlpha() {
        return this.getTNAM().alpha;
    }

    public void setSaturation(float in) {
        this.getCNAM().saturation = in;
    }

    public void setBrightness(float in) {
        this.getCNAM().brightness = in;
    }

    public void setContrast(float in) {
        this.getCNAM().contrast = in;
    }

    public void setRed(float in) {
        this.getTNAM().red = in;
    }

    public void setBlue(float in) {
        this.getTNAM().blue = in;
    }

    public void setGreen(float in) {
        this.getTNAM().green = in;
    }

    public void setAlpha(float in) {
        this.getTNAM().alpha = in;
    }

    public void setDOFstrength(float in) {
        this.getDNAM().DOFstrength = in;
    }

    public float getDOFstrength() {
        return this.getDNAM().DOFstrength;
    }

    public void setDOFdistance(float in) {
        this.getDNAM().DOFdistance = in;
    }

    public float getDOFdistance() {
        return this.getDNAM().DOFdistance;
    }

    public void setDOFrange(float in) {
        this.getDNAM().DOFrange = in;
    }

    public float getDOFrange() {
        return this.getDNAM().DOFrange;
    }

    static final class CNAM
    extends SubRecord {
        private float saturation = 0.0f;
        private float brightness = 0.0f;
        private float contrast = 0.0f;
        private boolean valid = false;

        @Override
        SubRecord getNew(String type) {
            return new CNAM();
        }

        @Override
        void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
            super.parseData(in, srcMod);
            this.saturation = in.extractFloat();
            this.brightness = in.extractFloat();
            this.contrast = in.extractFloat();
            if (SPGlobal.logMods) {
                CNAM.logMod(srcMod, "", "CNAM record: ");
                CNAM.logMod(srcMod, "", "  Saturation: " + this.saturation + ", Brightness: " + this.brightness + ", Contrast: " + this.contrast);
            }
            this.valid = true;
        }

        @Override
        void export(ModExporter out) throws IOException {
            super.export(out);
            if (this.isValid()) {
                out.write(this.saturation);
                out.write(this.brightness);
                out.write(this.contrast);
            }
        }

        @Override
        boolean isValid() {
            return this.valid;
        }

        @Override
        int getContentLength(ModExporter out) {
            if (this.isValid()) {
                return 12;
            }
            return 0;
        }

        @Override
        ArrayList<String> getTypes() {
            return Record.getTypeList("CNAM");
        }
    }

    static final class DNAM
    extends SubRecord {
        float DOFstrength = 0.0f;
        float DOFdistance = 0.0f;
        float DOFrange = 0.0f;
        byte[] unknown;
        boolean valid = false;

        @Override
        void export(ModExporter out) throws IOException {
            super.export(out);
            if (this.isValid()) {
                out.write(this.DOFstrength);
                out.write(this.DOFdistance);
                out.write(this.DOFrange);
                if (this.unknown != null) {
                    out.write(this.unknown, 4);
                }
            }
        }

        @Override
        void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
            super.parseData(in, srcMod);
            this.DOFstrength = in.extractFloat();
            this.DOFdistance = in.extractFloat();
            this.DOFrange = in.extractFloat();
            if (in.available() >= 4) {
                this.unknown = in.extract(4);
            }
            this.valid = true;
        }

        @Override
        SubRecord getNew(String type) {
            return new DNAM();
        }

        @Override
        boolean isValid() {
            return this.valid;
        }

        @Override
        int getContentLength(ModExporter out) {
            if (this.isValid()) {
                if (this.unknown != null) {
                    return 16;
                }
                return 12;
            }
            return 0;
        }

        @Override
        ArrayList<String> getTypes() {
            return Record.getTypeList("DNAM");
        }
    }

    static final class HNAM
    extends SubRecord {
        private float eyeAdaptSpeed = 0.0f;
        private float bloomRadius = 0.0f;
        private float bloomThreshold = 0.0f;
        private float bloomScale = 0.0f;
        private float targetLum1 = 0.0f;
        private float targetLum2 = 0.0f;
        private float sunlightScale = 0.0f;
        private float skyScale = 0.0f;
        private float eyeAdaptStrength = 0.0f;
        private boolean valid = false;

        HNAM() {
        }

        @Override
        SubRecord getNew(String type) {
            return new HNAM();
        }

        @Override
        final void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
            super.parseData(in, srcMod);
            this.eyeAdaptSpeed = in.extractFloat();
            this.bloomRadius = in.extractFloat();
            this.bloomThreshold = in.extractFloat();
            this.bloomScale = in.extractFloat();
            this.targetLum1 = in.extractFloat();
            this.targetLum2 = in.extractFloat();
            this.sunlightScale = in.extractFloat();
            this.skyScale = in.extractFloat();
            this.eyeAdaptStrength = in.extractFloat();
            if (SPGlobal.logMods) {
                HNAM.logMod(srcMod, "", "HNAM record: ");
                HNAM.logMod(srcMod, "", "  Eye Adapt Speed: " + this.eyeAdaptSpeed + ", Bloom Radius: " + this.bloomRadius);
                HNAM.logMod(srcMod, "", "  Bloom Threshold: " + this.bloomThreshold + ", Bloom Scale: " + this.bloomScale + ", Target Lum #1: " + this.targetLum1);
                HNAM.logMod(srcMod, "", "  Target Lum #2: " + this.targetLum2 + ", Sunlight Scale: " + this.sunlightScale);
                HNAM.logMod(srcMod, "", "  Sky Scale: " + this.skyScale + ", Eye Adapt Strength: " + this.eyeAdaptStrength);
            }
            this.valid = true;
        }

        @Override
        void export(ModExporter out) throws IOException {
            super.export(out);
            if (this.isValid()) {
                out.write(this.eyeAdaptSpeed);
                out.write(this.bloomRadius);
                out.write(this.bloomThreshold);
                out.write(this.bloomScale);
                out.write(this.targetLum1);
                out.write(this.targetLum2);
                out.write(this.sunlightScale);
                out.write(this.skyScale);
                out.write(this.eyeAdaptStrength);
            }
        }

        @Override
        boolean isValid() {
            return this.valid;
        }

        @Override
        int getContentLength(ModExporter out) {
            if (this.isValid()) {
                return 36;
            }
            return 0;
        }

        @Override
        ArrayList<String> getTypes() {
            return Record.getTypeList("HNAM");
        }
    }

    static final class TNAM
    extends SubRecord {
        private float red = 0.0f;
        private float green = 0.0f;
        private float blue = 0.0f;
        private float alpha = 0.0f;
        private boolean valid = false;

        @Override
        SubRecord getNew(String type) {
            return new TNAM();
        }

        @Override
        void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
            super.parseData(in, srcMod);
            this.alpha = in.extractFloat();
            this.red = in.extractFloat();
            this.green = in.extractFloat();
            this.blue = in.extractFloat();
            if (SPGlobal.logMods) {
                TNAM.logMod(srcMod, "", "TNAM record: RWX Format");
                TNAM.logMod(srcMod, "", "  Red: " + this.red + ", Green: " + this.green);
                TNAM.logMod(srcMod, "", "  Blue: " + this.blue + ", Alpha: " + this.alpha);
            }
            this.valid = true;
        }

        @Override
        void export(ModExporter out) throws IOException {
            super.export(out);
            if (this.isValid()) {
                out.write(this.alpha);
                out.write(this.red);
                out.write(this.green);
                out.write(this.blue);
            }
        }

        @Override
        boolean isValid() {
            return this.valid;
        }

        @Override
        int getContentLength(ModExporter out) {
            if (this.isValid()) {
                return 16;
            }
            return 0;
        }

        @Override
        ArrayList<String> getTypes() {
            return Record.getTypeList("TNAM");
        }
    }
}

