/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.DataFormatException;
import lev.LImport;
import lev.Ln;
import skyproc.FormID;
import skyproc.GRUP_TYPE;
import skyproc.MajorRecord;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.Record;
import skyproc.SPGlobal;
import skyproc.SPLogger;
import skyproc.SubRecord;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;

public class GRUP<T extends MajorRecord>
extends SubRecord
implements Iterable<T> {
    byte[] contained;
    byte[] grupType = new byte[4];
    byte[] dateStamp = new byte[4];
    byte[] version = new byte[4];
    ArrayList<T> listRecords = new ArrayList();
    Map<FormID, T> mapRecords = new HashMap<FormID, T>();
    Map<String, T> edidRecords = new HashMap<String, T>();
    T prototype;

    GRUP(T prototype) {
        this.prototype = prototype;
        this.contained = Ln.toByteArray((String)((Record)prototype).getType());
    }

    @Override
    ArrayList<String> getTypes() {
        return Record.getTypeList("GRUP");
    }

    public GRUP_TYPE getContainedType() {
        return GRUP_TYPE.valueOf(((Record)this.prototype).getType());
    }

    @Override
    public String toString() {
        return String.valueOf(this.getContainedType().toString()) + " GRUP";
    }

    @Override
    boolean isValid() {
        return this.isEmpty() == false;
    }

    public Boolean isEmpty() {
        return this.mapRecords.isEmpty();
    }

    @Override
    void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
        super.parseData(in, srcMod);
        this.contained = in.extract(4);
        this.grupType = in.extract(4);
        this.dateStamp = in.extract(4);
        this.version = in.extract(4);
        while (!in.isDone().booleanValue()) {
            this.extractMajor(in, srcMod);
        }
        if (SPGlobal.logMods) {
            GRUP.logMod(srcMod, this.toString(), "Data exhausted");
        }
    }

    MajorRecord extractMajor(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
        if (SPGlobal.logMods) {
            GRUP.logMod(srcMod, this.toString(), "============== Extracting Next " + (Object)((Object)this.getContainedType()) + " =============");
        }
        MajorRecord item = (MajorRecord)((Record)this.prototype).getNew();
        item.srcMod = srcMod;
        item.subRecords.setMajor(item);
        try {
            item.parseData(item.extractRecordData(in), srcMod);
            if (item.isValid()) {
                this.addRecord((T)item);
            } else if (SPGlobal.logMods) {
                GRUP.logMod(srcMod, this.toString(), "Did not add " + this.getContainedType().toString() + " " + item.toString() + " because it was not valid.");
            }
            return item;
        }
        catch (BufferUnderflowException e) {
            SPGlobal.logException(e);
            this.handleBadRecord(item, e.toString());
            return null;
        }
    }

    public int size() {
        return this.listRecords.size();
    }

    @Override
    public String print() {
        if (!this.isEmpty().booleanValue()) {
            for (MajorRecord t : this.mapRecords.values()) {
                t.toString();
            }
        }
        return "";
    }

    @Override
    void export(ModExporter out) throws IOException {
        out.write(this.getType().toString());
        out.write(this.getContentLength(out) + this.getHeaderLength(), this.getSizeLength());
        out.write(this.contained);
        out.write(this.grupType);
        out.write(this.dateStamp);
        out.write(this.version);
        if (this.logging()) {
            this.logSync(this.toString(), "Exporting " + this.numRecords() + " " + (Object)((Object)this.getContainedType()) + " records.");
        }
        for (MajorRecord t : this) {
            if (this.logging()) {
                this.logSync(this.toString(), t.toString());
            }
            t.export(out);
        }
    }

    @Override
    ArrayList<FormID> allFormIDs() {
        ArrayList<FormID> out = new ArrayList<FormID>();
        for (MajorRecord item : this.listRecords) {
            out.addAll(item.allFormIDs());
        }
        return out;
    }

    public int numRecords() {
        return this.mapRecords.size();
    }

    public boolean removeRecord(FormID id) {
        if (this.mapRecords.containsKey(id)) {
            this.listRecords.remove(this.mapRecords.get(id));
            MajorRecord r = (MajorRecord)this.mapRecords.get(id);
            this.edidRecords.remove(r.getEDID().toUpperCase());
            this.mapRecords.remove(id);
            return true;
        }
        return false;
    }

    public boolean removeRecord(T item) {
        return this.removeRecord(((MajorRecord)item).getForm());
    }

    void handleBadRecord(MajorRecord r, String reason) {
        if (SPGlobal.logMods) {
            if (r.isValid()) {
                GRUP.logMod(r.srcMod, this.toString(), "Caught a bad record: " + r + ", reason: " + reason);
                this.logSpecial(SPLogger.SpecialTypes.BLOCKED, this.toString(), "Caught a bad record: " + r + " from " + r.srcMod + ", reason: " + reason);
            } else {
                GRUP.logMod(r.srcMod, this.toString(), "Caught a bad record, reason:" + reason);
                this.logSpecial(SPLogger.SpecialTypes.BLOCKED, this.toString(), "Caught a bad record, reason:" + reason);
            }
        }
    }

    public void addRecord(T item) {
        this.removeRecord(item);
        this.mapRecords.put(((MajorRecord)item).getForm(), item);
        this.edidRecords.put(((MajorRecord)item).getEDID().toUpperCase(), item);
        this.listRecords.add(item);
    }

    public ArrayList<T> getRecords() {
        return this.listRecords;
    }

    void addRecord(Object item) {
        this.addRecord((T)((MajorRecord)item));
    }

    public boolean contains(FormID id) {
        return this.mapRecords.containsKey(id);
    }

    public boolean contains(String edid) {
        return this.edidRecords.containsKey(edid.toUpperCase());
    }

    public boolean contains(T item) {
        return this.contains(((MajorRecord)item).getForm());
    }

    public MajorRecord get(FormID id) {
        return (MajorRecord)this.mapRecords.get(id);
    }

    public MajorRecord get(String edid) {
        return (MajorRecord)this.edidRecords.get(edid.toUpperCase());
    }

    public void clear() {
        this.listRecords.clear();
        this.mapRecords.clear();
        this.edidRecords.clear();
    }

    @Override
    Record getNew() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void merge(GRUP<T> rhs) {
        if (this.logging() && SPGlobal.debugModMerge) {
            this.log(this.toString(), "Size before: " + this.numRecords());
        }
        for (MajorRecord item : rhs) {
            if (this.logging() && SPGlobal.debugModMerge) {
                if (this.contains(item.getForm())) {
                    this.log(this.toString(), "Replacing record " + item.toString() + " with one from " + rhs.toString());
                } else {
                    this.log(this.toString(), "Adding record " + item.toString());
                }
            }
            this.addRecord(item);
        }
        if (this.logging() && SPGlobal.debugModMerge) {
            this.log(this.toString(), "Size after: " + this.numRecords());
        }
    }

    @Override
    int getFluffLength() {
        return 16;
    }

    @Override
    int getSizeLength() {
        return 4;
    }

    @Override
    int getContentLength(ModExporter out) {
        int length = 0;
        for (MajorRecord t : this.listRecords) {
            if (!t.isValid()) continue;
            length += t.getTotalLength(out);
        }
        return length;
    }

    @Override
    public Iterator<T> iterator() {
        ArrayList<T> temp = new ArrayList<T>();
        temp.addAll(this.listRecords);
        return temp.iterator();
    }

    @Override
    SubRecord getNew(String type) {
        return new GRUP<T>(this.prototype);
    }

    @Override
    public int getRecordLength(LImport in) {
        return Ln.arrayToInt((int[])in.getInts(this.getIdentifierLength(), this.getSizeLength()));
    }
}

