/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.zip.DataFormatException;
import lev.LImport;
import skyproc.MajorRecord;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.Record;
import skyproc.SubData;
import skyproc.SubPrototype;
import skyproc.SubRecord;
import skyproc.SubRecordsStream;
import skyproc.SubStringPointer;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;

public class GMST
extends MajorRecord {
    static final SubPrototype GMSTproto = new SubPrototype(MajorRecord.majorProto){

        @Override
        protected void addRecords() {
            this.add(new DATA());
        }
    };

    GMST() {
        this.subRecords.setPrototype(GMSTproto);
    }

    public GMST(BoolSetting setting, Boolean b) {
        this();
        this.originateFromPatch(setting.toString());
        this.setData(b);
    }

    public GMST(String setting, Boolean b) {
        this();
        this.originateFromPatch(setting);
        this.setData(b);
    }

    public GMST(StringSetting setting, String s) {
        this();
        this.originateFromPatch(setting.toString());
        this.setData(s);
    }

    public GMST(String setting, String s) {
        this();
        this.originateFromPatch(setting);
        this.setData(s);
    }

    public GMST(IntSetting setting, int i) {
        this();
        this.originateFromPatch(setting.toString());
        this.setData(i);
    }

    public GMST(String setting, int i) {
        this();
        this.originateFromPatch(setting);
        this.setData(i);
    }

    public GMST(FloatSetting setting, float f) {
        this();
        this.originateFromPatch(setting.toString());
        this.setData(f);
    }

    public GMST(String setting, float f) {
        this();
        this.originateFromPatch(setting);
        this.setData(f);
    }

    @Override
    Record getNew() {
        return new GMST();
    }

    @Override
    ArrayList<String> getTypes() {
        return Record.getTypeList("GMST");
    }

    @Override
    void importSubRecords(LImport in) throws BadRecord, DataFormatException, BadParameter {
        SubRecord data = ((SubRecordsStream)this.subRecords).getSilent("DATA");
        this.updateDATAtype();
        super.importSubRecords(in);
        ((SubRecordsStream)this.subRecords).loadFromPosition(data);
    }

    @Override
    void export(ModExporter out) throws IOException {
        this.updateDATAtype();
        super.export(out);
    }

    @Override
    int getContentLength(ModExporter out) {
        this.updateDATAtype();
        return super.getContentLength(out);
    }

    public GMSTType getGMSTType() {
        if (this.getEDID().length() == 0) {
            return GMSTType.Unknown;
        }
        switch (this.getEDID().charAt(0)) {
            case 'B': 
            case 'b': {
                return GMSTType.Bool;
            }
            case 'I': 
            case 'i': {
                return GMSTType.Int;
            }
            case 'F': 
            case 'f': {
                return GMSTType.Float;
            }
            case 'S': 
            case 's': {
                return GMSTType.String;
            }
        }
        return GMSTType.Unknown;
    }

    DATA getDATA() {
        return (DATA)this.subRecords.get("DATA");
    }

    public final void setData(Boolean b) {
        if (b.booleanValue()) {
            this.getDATA().DATA.setData(1, 4);
        } else {
            this.getDATA().DATA.setData(0, 4);
        }
    }

    public final void setData(String s) {
        this.getDATA().DATAs.setText(s);
    }

    public final void setData(int i) {
        this.getDATA().DATA.setData(i, 4);
    }

    public final void setData(float f) {
        ByteBuffer out = ByteBuffer.allocate(4);
        out.putInt(Integer.reverseBytes(Float.floatToIntBits(f)));
        this.getDATA().DATA.setData(out.array());
    }

    public boolean getBool() {
        return this.getDATA().DATA.toInt() != 0;
    }

    public String getString() {
        return this.getDATA().DATAs.print();
    }

    public int getInt() {
        return this.getDATA().DATA.toInt();
    }

    public float getFloat() {
        return Float.intBitsToFloat(this.getDATA().DATA.toInt());
    }

    SubRecord updateDATAtype() {
        DATA data = this.getDATA();
        data.GMSTtype = this.getGMSTType();
        return data;
    }

    public static enum BoolSetting {
        bAllow,
        bAutoAimBasedOnDistance,
        bCrosshairEnabled,
        bForce,
        bForcePow,
        bFull,
        bRegenNPCMagickaDuringCast,
        bReturnTo,
        bSaveOnPause,
        bSaveOnRest,
        bSaveOnTravel,
        bSaveOnWait,
        bShowInventory,
        bUse,
        bUseWaterHDR,
        bWantCastLeft,
        bWantCastRight,
        bWantCastVoice;

    }

    static final class DATA
    extends SubRecord {
        private GMSTType GMSTtype;
        SubData DATA = new SubData("DATA");
        SubStringPointer DATAs = new SubStringPointer("DATA", SubStringPointer.Files.STRINGS);

        DATA() {
            this.DATAs.forceExport = true;
        }

        @Override
        SubRecord getNew(String type) {
            return new DATA();
        }

        @Override
        void export(ModExporter out) throws IOException {
            switch (this.GMSTtype) {
                case String: {
                    this.DATAs.export(out);
                    break;
                }
                default: {
                    this.DATA.export(out);
                }
            }
        }

        @Override
        void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
            switch (this.GMSTtype) {
                case String: {
                    this.DATAs.parseData(in, srcMod);
                    break;
                }
                default: {
                    this.DATA.parseData(in, srcMod);
                }
            }
        }

        @Override
        int getContentLength(ModExporter out) {
            switch (this.GMSTtype) {
                case String: {
                    return this.DATAs.getContentLength(out);
                }
            }
            return this.DATA.getContentLength(out);
        }

        @Override
        ArrayList<String> getTypes() {
            return Record.getTypeList("DATA");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static final class FloatSetting
    extends Enum<FloatSetting> {
        public static final /* enum */ FloatSetting fAIAcquireObjectDistance;
        public static final /* enum */ FloatSetting fAIActivateHeight;
        public static final /* enum */ FloatSetting fAIActivateReach;
        public static final /* enum */ FloatSetting fAIActorPackTargetHeadTrackMod;
        public static final /* enum */ FloatSetting fAIAimBlockedHalfCircleRadius;
        public static final /* enum */ FloatSetting fAIAimBlockedToleranceDegrees;
        public static final /* enum */ FloatSetting fAIAwareofPlayerTimer;
        public static final /* enum */ FloatSetting fAIBestHeadTrackDistance;
        public static final /* enum */ FloatSetting fAICombatFleeScoreThreshold;
        public static final /* enum */ FloatSetting fAICombatNoAreaEffectAllyDistance;
        public static final /* enum */ FloatSetting fAICombatNoTargetLOSPriorityMult;
        public static final /* enum */ FloatSetting fAICombatSlopeDifference;
        public static final /* enum */ FloatSetting fAICombatTargetUnreachablePriorityMult;
        public static final /* enum */ FloatSetting fAICombatUnreachableTargetPriorityMult;
        public static final /* enum */ FloatSetting fAICommentTimeWindow;
        public static final /* enum */ FloatSetting fAIConversationExploreTime;
        public static final /* enum */ FloatSetting fAIDefaultSpeechMult;
        public static final /* enum */ FloatSetting fAIDialogueDistance;
        public static final /* enum */ FloatSetting fAIDistanceRadiusMinLocation;
        public static final /* enum */ FloatSetting fAIDistanceTeammateDrawWeapon;
        public static final /* enum */ FloatSetting fAIDodgeDecisionBase;
        public static final /* enum */ FloatSetting fAIDodgeFavorLeftRightMult;
        public static final /* enum */ FloatSetting fAIDodgeVerticalRangedAttackMult;
        public static final /* enum */ FloatSetting fAIDodgeWalkChance;
        public static final /* enum */ FloatSetting fAIEnergyLevelBase;
        public static final /* enum */ FloatSetting fAIEngergyLevelMult;
        public static final /* enum */ FloatSetting fAIEscortFastTravelMaxDistFromPath;
        public static final /* enum */ FloatSetting fAIEscortHysteresisWidth;
        public static final /* enum */ FloatSetting fAIEscortStartStopDelayTime;
        public static final /* enum */ FloatSetting fAIEscortWaitDistanceExterior;
        public static final /* enum */ FloatSetting fAIEscortWaitDistanceInterior;
        public static final /* enum */ FloatSetting fAIExclusiveGreetingTimer;
        public static final /* enum */ FloatSetting fAIExplosiveWeaponDamageMult;
        public static final /* enum */ FloatSetting fAIExplosiveWeaponRangeMult;
        public static final /* enum */ FloatSetting fAIExteriorSpectatorDetection;
        public static final /* enum */ FloatSetting fAIExteriorSpectatorDistance;
        public static final /* enum */ FloatSetting fAIFaceTargetAnimationAngle;
        public static final /* enum */ FloatSetting fAIFindBedChairsDistance;
        public static final /* enum */ FloatSetting fAIFleeConfBase;
        public static final /* enum */ FloatSetting fAIFleeConfMult;
        public static final /* enum */ FloatSetting fAIFleeHealthMult;
        public static final /* enum */ FloatSetting fAIFleeSuccessTimeout;
        public static final /* enum */ FloatSetting fAIForceGreetingTimer;
        public static final /* enum */ FloatSetting fAIFurnitureDestinationRadius;
        public static final /* enum */ FloatSetting fAIGreetingTimer;
        public static final /* enum */ FloatSetting fAIHeadTrackDialogueOffsetRandomValue;
        public static final /* enum */ FloatSetting fAIHeadTrackDialoguePickNewOffsetTimer;
        public static final /* enum */ FloatSetting fAIHeadTrackDialogueResetPositionTimer;
        public static final /* enum */ FloatSetting fAIHeadTrackDialogueStayInOffsetMax;
        public static final /* enum */ FloatSetting fAIHeadTrackDialogueStayInOffsetMin;
        public static final /* enum */ FloatSetting fAIHeadTrackOffsetRandomValueMax;
        public static final /* enum */ FloatSetting fAIHeadTrackOffsetRandomValueMin;
        public static final /* enum */ FloatSetting fAIHeadTrackPickNewOffsetTimer;
        public static final /* enum */ FloatSetting fAIHeadTrackResetPositionTimer;
        public static final /* enum */ FloatSetting fAIHeadTrackStayInOffsetMax;
        public static final /* enum */ FloatSetting fAIHeadTrackStayInOffsetMin;
        public static final /* enum */ FloatSetting fAIHoldDefaultHeadTrackTimer;
        public static final /* enum */ FloatSetting fAIHorseSearchDistance;
        public static final /* enum */ FloatSetting fAIIdleAnimationDistance;
        public static final /* enum */ FloatSetting fAIIdleAnimationLargeCreatureDistanceMult;
        public static final /* enum */ FloatSetting fAIIdleWaitTime;
        public static final /* enum */ FloatSetting fAIIdleWaitTimeComplexScene;
        public static final /* enum */ FloatSetting fAIInDialogueModeWithPlayerDistance;
        public static final /* enum */ FloatSetting fAIInDialogueModewithPlayerTimer;
        public static final /* enum */ FloatSetting fAIInteriorHeadTrackMult;
        public static final /* enum */ FloatSetting fAIInteriorSpectatorDetection;
        public static final /* enum */ FloatSetting fAIInteriorSpectatorDistance;
        public static final /* enum */ FloatSetting fAILockDoorsSeenRecentlySeconds;
        public static final /* enum */ FloatSetting fAIMagicSpellMult;
        public static final /* enum */ FloatSetting fAIMagicTimer;
        public static final /* enum */ FloatSetting fAIMarkerDestinationRadius;
        public static final /* enum */ FloatSetting fAIMaxAngleRangeMovingToStartSceneDialogue;
        public static final /* enum */ FloatSetting fAIMaxHeadTrackDistance;
        public static final /* enum */ FloatSetting fAIMaxHeadTrackDistanceFromPC;
        public static final /* enum */ FloatSetting fAIMaxLargeCreatureHeadTrackDistance;
        public static final /* enum */ FloatSetting fAIMaxSmileDistance;
        public static final /* enum */ FloatSetting fAIMaxWanderTime;
        public static final /* enum */ FloatSetting fAIMeleeArmorMult;
        public static final /* enum */ FloatSetting fAIMeleeHandMult;
        public static final /* enum */ FloatSetting fAIMinAngleRangeToStartSceneDialogue;
        public static final /* enum */ FloatSetting fAIMinGreetingDistance;
        public static final /* enum */ FloatSetting fAIMinLocationHeight;
        public static final /* enum */ FloatSetting fAIMoveDistanceToRecalcFollowPath;
        public static final /* enum */ FloatSetting fAIMoveDistanceToRecalcTravelPath;
        public static final /* enum */ FloatSetting fAIMoveDistanceToRecalcTravelToActor;
        public static final /* enum */ FloatSetting fAIPatrolHysteresisWidth;
        public static final /* enum */ FloatSetting fAIPatrolMinSecondsAtNormalFurniture;
        public static final /* enum */ FloatSetting fAIPowerAttackCreatureChance;
        public static final /* enum */ FloatSetting fAIPowerAttackKnockdownBonus;
        public static final /* enum */ FloatSetting fAIPowerAttackNPCChance;
        public static final /* enum */ FloatSetting fAIPowerAttackRecoilBonus;
        public static final /* enum */ FloatSetting fAIPursueDistanceLineOfSight;
        public static final /* enum */ FloatSetting fAIRandomizeInitialLocationMinRadius;
        public static final /* enum */ FloatSetting fAIRangMagicSpellMult;
        public static final /* enum */ FloatSetting fAIRangedWeaponMult;
        public static final /* enum */ FloatSetting fAIRevertToScriptTracking;
        public static final /* enum */ FloatSetting fAIShoutMinAimSeconds;
        public static final /* enum */ FloatSetting fAIShoutRetryDelaySeconds;
        public static final /* enum */ FloatSetting fAIShoutToleranceDegrees;
        public static final /* enum */ FloatSetting fAISocialRadiusToTriggerConversation;
        public static final /* enum */ FloatSetting fAISocialRadiusToTriggerConversationInterior;
        public static final /* enum */ FloatSetting fAISocialTimerForConversationsMax;
        public static final /* enum */ FloatSetting fAISocialTimerForConversationsMin;
        public static final /* enum */ FloatSetting fAISocialTimerToWaitForEvent;
        public static final /* enum */ FloatSetting fAISocialchanceForConversation;
        public static final /* enum */ FloatSetting fAISocialchanceForConversationInterior;
        public static final /* enum */ FloatSetting fAISpectatorCommentTimer;
        public static final /* enum */ FloatSetting fAISpectatorRememberThreatTimer;
        public static final /* enum */ FloatSetting fAISpectatorShutdownDistance;
        public static final /* enum */ FloatSetting fAISpectatorThreatDistExplosion;
        public static final /* enum */ FloatSetting fAISpectatorThreatDistMelee;
        public static final /* enum */ FloatSetting fAISpectatorThreatDistMine;
        public static final /* enum */ FloatSetting fAISpectatorThreatDistRanged;
        public static final /* enum */ FloatSetting fAIStayonScriptHeadtrack;
        public static final /* enum */ FloatSetting fAITrespassWarningTimer;
        public static final /* enum */ FloatSetting fAIUpdateMovementRestrictionsDistance;
        public static final /* enum */ FloatSetting fAIUseMagicToleranceDegrees;
        public static final /* enum */ FloatSetting fAIUseWeaponAnimationTimeoutSeconds;
        public static final /* enum */ FloatSetting fAIUseWeaponDistance;
        public static final /* enum */ FloatSetting fAIUseWeaponToleranceDegrees;
        public static final /* enum */ FloatSetting fAIWaitingforScriptCallback;
        public static final /* enum */ FloatSetting fAIWalkAwayTimerForConversation;
        public static final /* enum */ FloatSetting fAIWanderDefaultMinDist;
        public static final /* enum */ FloatSetting fAItalktoNPCtimer;
        public static final /* enum */ FloatSetting fAItalktosameNPCtimer;
        public static final /* enum */ FloatSetting fActionPointsAimAdjustment;
        public static final /* enum */ FloatSetting fActionPointsAttackMagic;
        public static final /* enum */ FloatSetting fActionPointsAttackOneHandMelee;
        public static final /* enum */ FloatSetting fActionPointsAttackRanged;
        public static final /* enum */ FloatSetting fActionPointsAttackTwoHandMelee;
        public static final /* enum */ FloatSetting fActionPointsAttackUnarmed;
        public static final /* enum */ FloatSetting fActionPointsCrouch;
        public static final /* enum */ FloatSetting fActionPointsFOVBase;
        public static final /* enum */ FloatSetting fActionPointsFOVMult;
        public static final /* enum */ FloatSetting fActionPointsHeal;
        public static final /* enum */ FloatSetting fActionPointsPowerAttackMult;
        public static final /* enum */ FloatSetting fActionPointsReload;
        public static final /* enum */ FloatSetting fActionPointsRestoreRate;
        public static final /* enum */ FloatSetting fActionPointsRunAndGunMult;
        public static final /* enum */ FloatSetting fActionPointsStand;
        public static final /* enum */ FloatSetting fActionPointsSwitchWeapon;
        public static final /* enum */ FloatSetting fActionPointsToggleWeaponDrawn;
        public static final /* enum */ FloatSetting fActionPointsVATSMeleeMult;
        public static final /* enum */ FloatSetting fActiveEffectConditionUpdateInterval;
        public static final /* enum */ FloatSetting fActorAlertSoundTimer;
        public static final /* enum */ FloatSetting fActorAlphaFadeSeconds;
        public static final /* enum */ FloatSetting fActorAnimZAdjust;
        public static final /* enum */ FloatSetting fActorArmorDesirabilityDamageMult;
        public static final /* enum */ FloatSetting fActorArmorDesirabilitySkillMult;
        public static final /* enum */ FloatSetting fActorDefaultTurningSpeed;
        public static final /* enum */ FloatSetting fActorLeaveWaterBreathTimer;
        public static final /* enum */ FloatSetting fActorLuckSkillMult;
        public static final /* enum */ FloatSetting fActorStrengthEncumbranceMult;
        public static final /* enum */ FloatSetting fActorSwimBreathBase;
        public static final /* enum */ FloatSetting fActorSwimBreathDamage;
        public static final /* enum */ FloatSetting fActorSwimBreathMult;
        public static final /* enum */ FloatSetting fActorTeleportFadeSeconds;
        public static final /* enum */ FloatSetting fActorWeaponDesirabilityDamageMult;
        public static final /* enum */ FloatSetting fActorWeaponDesirabilitySkillMult;
        public static final /* enum */ FloatSetting fAddictionUsageMonitorThreshold;
        public static final /* enum */ FloatSetting fAiAcquireKillBase;
        public static final /* enum */ FloatSetting fAiAcquireKillMult;
        public static final /* enum */ FloatSetting fAiAcquirePickBase;
        public static final /* enum */ FloatSetting fAiAcquirePickMult;
        public static final /* enum */ FloatSetting fAiAcquireStealBase;
        public static final /* enum */ FloatSetting fAiAcquireStealMult;
        public static final /* enum */ FloatSetting fAlchemyGoldMult;
        public static final /* enum */ FloatSetting fAlchemyIngredientInitMult;
        public static final /* enum */ FloatSetting fAlchemySkillFactor;
        public static final /* enum */ FloatSetting fAmbushOverRideRadiusforPlayerDetection;
        public static final /* enum */ FloatSetting fArmorBaseFactor;
        public static final /* enum */ FloatSetting fArmorRatingBase;
        public static final /* enum */ FloatSetting fArmorRatingMax;
        public static final /* enum */ FloatSetting fArmorRatingPCBase;
        public static final /* enum */ FloatSetting fArmorRatingPCMax;
        public static final /* enum */ FloatSetting fArmorScalingFactor;
        public static final /* enum */ FloatSetting fArmorWeightLightMaxMod;
        public static final /* enum */ FloatSetting fArrowBounceBlockPercentage;
        public static final /* enum */ FloatSetting fArrowBounceLinearSpeed;
        public static final /* enum */ FloatSetting fArrowBounceRotateSpeed;
        public static final /* enum */ FloatSetting fArrowBowFastMult;
        public static final /* enum */ FloatSetting fArrowBowMinTime;
        public static final /* enum */ FloatSetting fArrowBowSlowMult;
        public static final /* enum */ FloatSetting fArrowFakeMass;
        public static final /* enum */ FloatSetting fArrowGravityBase;
        public static final /* enum */ FloatSetting fArrowGravityMin;
        public static final /* enum */ FloatSetting fArrowGravityMult;
        public static final /* enum */ FloatSetting fArrowMaxDistance;
        public static final /* enum */ FloatSetting fArrowMinBowVelocity;
        public static final /* enum */ FloatSetting fArrowMinDistanceForTrails;
        public static final /* enum */ FloatSetting fArrowMinPower;
        public static final /* enum */ FloatSetting fArrowMinSpeedForTrails;
        public static final /* enum */ FloatSetting fArrowMinVelocity;
        public static final /* enum */ FloatSetting fArrowOptimalDistance;
        public static final /* enum */ FloatSetting fArrowSpeedMult;
        public static final /* enum */ FloatSetting fArrowWeakGravity;
        public static final /* enum */ FloatSetting fAuroraFadeInStart;
        public static final /* enum */ FloatSetting fAuroraFadeOutStart;
        public static final /* enum */ FloatSetting fAutoAimMaxDegrees;
        public static final /* enum */ FloatSetting fAutoAimMaxDegreesMelee;
        public static final /* enum */ FloatSetting fAutoAimMaxDegreesVATS;
        public static final /* enum */ FloatSetting fAutoAimMaxDistance;
        public static final /* enum */ FloatSetting fAutoAimScreenPercentage;
        public static final /* enum */ FloatSetting fAutomaticWeaponBurstCooldownTime;
        public static final /* enum */ FloatSetting fAutomaticWeaponBurstFireTime;
        public static final /* enum */ FloatSetting fAutoraFadeIn;
        public static final /* enum */ FloatSetting fAutoraFadeOut;
        public static final /* enum */ FloatSetting fAvoidPlayerDistance;
        public static final /* enum */ FloatSetting fBarterBuyMin;
        public static final /* enum */ FloatSetting fBarterMax;
        public static final /* enum */ FloatSetting fBarterMin;
        public static final /* enum */ FloatSetting fBarterSellMax;
        public static final /* enum */ FloatSetting fBeamWidthDefault;
        public static final /* enum */ FloatSetting fBigBumpSpeed;
        public static final /* enum */ FloatSetting fBleedoutCheck;
        public static final /* enum */ FloatSetting fBleedoutDefault;
        public static final /* enum */ FloatSetting fBleedoutMin;
        public static final /* enum */ FloatSetting fBleedoutRate;
        public static final /* enum */ FloatSetting fBleedoutRecover;
        public static final /* enum */ FloatSetting fBlinkDelayMax;
        public static final /* enum */ FloatSetting fBlinkDelayMin;
        public static final /* enum */ FloatSetting fBlinkDownTime;
        public static final /* enum */ FloatSetting fBlinkUpTime;
        public static final /* enum */ FloatSetting fBlockAmountHandToHandMult;
        public static final /* enum */ FloatSetting fBlockAmountWeaponMult;
        public static final /* enum */ FloatSetting fBlockLevel;
        public static final /* enum */ FloatSetting fBlockMax;
        public static final /* enum */ FloatSetting fBlockPowerAttackMult;
        public static final /* enum */ FloatSetting fBlockScoreNoShieldMult;
        public static final /* enum */ FloatSetting fBlockSkillBase;
        public static final /* enum */ FloatSetting fBlockSkillMult;
        public static final /* enum */ FloatSetting fBlockWeaponBase;
        public static final /* enum */ FloatSetting fBlockWeaponScaling;
        public static final /* enum */ FloatSetting fBloodSplatterCountBase;
        public static final /* enum */ FloatSetting fBloodSplatterCountDamageBase;
        public static final /* enum */ FloatSetting fBloodSplatterCountDamageMult;
        public static final /* enum */ FloatSetting fBloodSplatterCountRandomMargin;
        public static final /* enum */ FloatSetting fBloodSplatterDuration;
        public static final /* enum */ FloatSetting fBloodSplatterFadeStart;
        public static final /* enum */ FloatSetting fBloodSplatterFlareMult;
        public static final /* enum */ FloatSetting fBloodSplatterFlareOffsetScale;
        public static final /* enum */ FloatSetting fBloodSplatterFlareSize;
        public static final /* enum */ FloatSetting fBloodSplatterMaxOpacity;
        public static final /* enum */ FloatSetting fBloodSplatterMaxSize;
        public static final /* enum */ FloatSetting fBloodSplatterMinOpacity;
        public static final /* enum */ FloatSetting fBloodSplatterMinSize;
        public static final /* enum */ FloatSetting fBloodSplatterOpacityChance;
        public static final /* enum */ FloatSetting fBookLight;
        public static final /* enum */ FloatSetting fBowDrawTime;
        public static final /* enum */ FloatSetting fBowHoldTimer;
        public static final /* enum */ FloatSetting fBowNPCSpreadAngle;
        public static final /* enum */ FloatSetting fBowZoomStaminaDrainMult;
        public static final /* enum */ FloatSetting fBowZoomStaminaRegenDelay;
        public static final /* enum */ FloatSetting fBribeBase;
        public static final /* enum */ FloatSetting fBribeCostCurve;
        public static final /* enum */ FloatSetting fBribeMoralityMult;
        public static final /* enum */ FloatSetting fBribeMult;
        public static final /* enum */ FloatSetting fBribeNPCLevelMult;
        public static final /* enum */ FloatSetting fBribeScale;
        public static final /* enum */ FloatSetting fBribeSpeechcraftMult;
        public static final /* enum */ FloatSetting fBumpReactionIdealMoveDist;
        public static final /* enum */ FloatSetting fBumpReactionMinMoveDist;
        public static final /* enum */ FloatSetting fBumpReactionSmallDelayTime;
        public static final /* enum */ FloatSetting fBumpReactionSmallWaitTimer;
        public static final /* enum */ FloatSetting fBuoyancyMultBody;
        public static final /* enum */ FloatSetting fBuoyancyMultExtremity;
        public static final /* enum */ FloatSetting fCameraShakeDistFadeDelta;
        public static final /* enum */ FloatSetting fCameraShakeDistFadeStart;
        public static final /* enum */ FloatSetting fCameraShakeDistMin;
        public static final /* enum */ FloatSetting fCameraShakeExplosionDistMult;
        public static final /* enum */ FloatSetting fCameraShakeFadeTime;
        public static final /* enum */ FloatSetting fCameraShakeMultMin;
        public static final /* enum */ FloatSetting fCameraShakeTime;
        public static final /* enum */ FloatSetting fChaseDetectionTimerSetting;
        public static final /* enum */ FloatSetting fCheckDeadBodyTimer;
        public static final /* enum */ FloatSetting fCheckPositionFallDistance;
        public static final /* enum */ FloatSetting fClosetoPlayerDistance;
        public static final /* enum */ FloatSetting fClothingArmorBase;
        public static final /* enum */ FloatSetting fClothingArmorScale;
        public static final /* enum */ FloatSetting fClothingBase;
        public static final /* enum */ FloatSetting fClothingClassScale;
        public static final /* enum */ FloatSetting fClothingJewelryBase;
        public static final /* enum */ FloatSetting fClothingJewelryScale;
        public static final /* enum */ FloatSetting fCombatAbsoluteMaxRangeMult;
        public static final /* enum */ FloatSetting fCombatAcquirePickupAnimationDelay;
        public static final /* enum */ FloatSetting fCombatAcquireWeaponAmmoMinimumScoreMult;
        public static final /* enum */ FloatSetting fCombatAcquireWeaponAvoidTargetRadius;
        public static final /* enum */ FloatSetting fCombatAcquireWeaponCloseDistanceMax;
        public static final /* enum */ FloatSetting fCombatAcquireWeaponCloseDistanceMin;
        public static final /* enum */ FloatSetting fCombatAcquireWeaponDisarmedAcquireTime;
        public static final /* enum */ FloatSetting fCombatAcquireWeaponDisarmedDistanceMax;
        public static final /* enum */ FloatSetting fCombatAcquireWeaponDisarmedDistanceMin;
        public static final /* enum */ FloatSetting fCombatAcquireWeaponDisarmedTime;
        public static final /* enum */ FloatSetting fCombatAcquireWeaponEnchantmentChargeMult;
        public static final /* enum */ FloatSetting fCombatAcquireWeaponFindAmmoDistance;
        public static final /* enum */ FloatSetting fCombatAcquireWeaponMeleeScoreMult;
        public static final /* enum */ FloatSetting fCombatAcquireWeaponMinimumScoreMult;
        public static final /* enum */ FloatSetting fCombatAcquireWeaponMinimumTargetDistance;
        public static final /* enum */ FloatSetting fCombatAcquireWeaponRangedDistanceMax;
        public static final /* enum */ FloatSetting fCombatAcquireWeaponRangedDistanceMin;
        public static final /* enum */ FloatSetting fCombatAcquireWeaponReachDistance;
        public static final /* enum */ FloatSetting fCombatAcquireWeaponScoreCostMult;
        public static final /* enum */ FloatSetting fCombatAcquireWeaponScoreRatioMax;
        public static final /* enum */ FloatSetting fCombatAcquireWeaponSearchFailedDelay;
        public static final /* enum */ FloatSetting fCombatAcquireWeaponSearchRadiusBuffer;
        public static final /* enum */ FloatSetting fCombatAcquireWeaponSearchSuccessDelay;
        public static final /* enum */ FloatSetting fCombatAcquireWeaponTargetDistanceCheck;
        public static final /* enum */ FloatSetting fCombatAcquireWeaponUnarmedDistanceMax;
        public static final /* enum */ FloatSetting fCombatAcquireWeaponUnarmedDistanceMin;
        public static final /* enum */ FloatSetting fCombatActiveCombatantAttackRangeDistance;
        public static final /* enum */ FloatSetting fCombatActiveCombatantLastSeenTime;
        public static final /* enum */ FloatSetting fCombatAdvanceInnerRadiusMax;
        public static final /* enum */ FloatSetting fCombatAdvanceInnerRadiusMid;
        public static final /* enum */ FloatSetting fCombatAdvanceInnerRadiusMin;
        public static final /* enum */ FloatSetting fCombatAdvanceLastDamagedThreshold;
        public static final /* enum */ FloatSetting fCombatAdvanceNormalAttackChance;
        public static final /* enum */ FloatSetting fCombatAdvanceOuterRadiusMax;
        public static final /* enum */ FloatSetting fCombatAdvanceOuterRadiusMid;
        public static final /* enum */ FloatSetting fCombatAdvanceOuterRadiusMin;
        public static final /* enum */ FloatSetting fCombatAdvancePathRetryTime;
        public static final /* enum */ FloatSetting fCombatAdvanceRadiusStaggerMult;
        public static final /* enum */ FloatSetting fCombatAimDeltaThreshold;
        public static final /* enum */ FloatSetting fCombatAimLastSeenLocationTimeLimit;
        public static final /* enum */ FloatSetting fCombatAimMeleeHighPriorityUpdateTime;
        public static final /* enum */ FloatSetting fCombatAimMeleeUpdateTime;
        public static final /* enum */ FloatSetting fCombatAimProjectileBlockedTime;
        public static final /* enum */ FloatSetting fCombatAimProjectileGroundMinRadius;
        public static final /* enum */ FloatSetting fCombatAimProjectileRandomOffset;
        public static final /* enum */ FloatSetting fCombatAimProjectileUpdateTime;
        public static final /* enum */ FloatSetting fCombatAimTrackTargetUpdateTime;
        public static final /* enum */ FloatSetting fCombatAngleTolerance;
        public static final /* enum */ FloatSetting fCombatAnticipateTime;
        public static final /* enum */ FloatSetting fCombatAnticipatedLocationCheckDistance;
        public static final /* enum */ FloatSetting fCombatApproachTargetSlowdownDecelerationMult;
        public static final /* enum */ FloatSetting fCombatApproachTargetSlowdownDistance;
        public static final /* enum */ FloatSetting fCombatApproachTargetSlowdownUpdateTime;
        public static final /* enum */ FloatSetting fCombatApproachTargetSlowdownVelocityAngle;
        public static final /* enum */ FloatSetting fCombatApproachTargetSprintStopMovingRange;
        public static final /* enum */ FloatSetting fCombatApproachTargetSprintStopRange;
        public static final /* enum */ FloatSetting fCombatApproachTargetUpdateTime;
        public static final /* enum */ FloatSetting fCombatAreaHoldPositionMinimumRadius;
        public static final /* enum */ FloatSetting fCombatAreaStandardAttackedRadius;
        public static final /* enum */ FloatSetting fCombatAreaStandardAttackedTime;
        public static final /* enum */ FloatSetting fCombatAreaStandardCheckViewConeDistanceMax;
        public static final /* enum */ FloatSetting fCombatAreaStandardCheckViewConeDistanceMin;
        public static final /* enum */ FloatSetting fCombatAreaStandardFlyingRadiusMult;
        public static final /* enum */ FloatSetting fCombatAreaStandardRadius;
        public static final /* enum */ FloatSetting fCombatAttackAllowedOverrunDistance;
        public static final /* enum */ FloatSetting fCombatAttackAnimationDrivenDelayTime;
        public static final /* enum */ FloatSetting fCombatAttackAnticipatedDistanceMin;
        public static final /* enum */ FloatSetting fCombatAttackChanceBlockingMultMax;
        public static final /* enum */ FloatSetting fCombatAttackChanceBlockingMultMin;
        public static final /* enum */ FloatSetting fCombatAttackChanceBlockingSwingMult;
        public static final /* enum */ FloatSetting fCombatAttackChanceLastAttackBonus;
        public static final /* enum */ FloatSetting fCombatAttackChanceLastAttackBonusTime;
        public static final /* enum */ FloatSetting fCombatAttackChanceMax;
        public static final /* enum */ FloatSetting fCombatAttackChanceMin;
        public static final /* enum */ FloatSetting fCombatAttackCheckTargetRangeDistance;
        public static final /* enum */ FloatSetting fCombatAttackMovingAttackDistance;
        public static final /* enum */ FloatSetting fCombatAttackMovingAttackReachMult;
        public static final /* enum */ FloatSetting fCombatAttackMovingStrikeAngleMult;
        public static final /* enum */ FloatSetting fCombatAttackPlayerAnticipateMult;
        public static final /* enum */ FloatSetting fCombatAttackStationaryAttackDistance;
        public static final /* enum */ FloatSetting fCombatAttackStrikeAngleMult;
        public static final /* enum */ FloatSetting fCombatAvoidThreatsChance;
        public static final /* enum */ FloatSetting fCombatBackoffChance;
        public static final /* enum */ FloatSetting fCombatBackoffMinDistanceMult;
        public static final /* enum */ FloatSetting fCombatBashChanceMax;
        public static final /* enum */ FloatSetting fCombatBashChanceMin;
        public static final /* enum */ FloatSetting fCombatBashReach;
        public static final /* enum */ FloatSetting fCombatBashTargetBlockingMult;
        public static final /* enum */ FloatSetting fCombatBetweenAdvanceTimer;
        public static final /* enum */ FloatSetting fCombatBlockAttackChanceMax;
        public static final /* enum */ FloatSetting fCombatBlockAttackChanceMin;
        public static final /* enum */ FloatSetting fCombatBlockAttackReachMult;
        public static final /* enum */ FloatSetting fCombatBlockAttackStrikeAngleMult;
        public static final /* enum */ FloatSetting fCombatBlockChanceMax;
        public static final /* enum */ FloatSetting fCombatBlockChanceMin;
        public static final /* enum */ FloatSetting fCombatBlockChanceWeaponMult;
        public static final /* enum */ FloatSetting fCombatBlockMaxTargetRetreatVelocity;
        public static final /* enum */ FloatSetting fCombatBlockStartDistanceMax;
        public static final /* enum */ FloatSetting fCombatBlockStartDistanceMin;
        public static final /* enum */ FloatSetting fCombatBlockStopDistanceMax;
        public static final /* enum */ FloatSetting fCombatBlockStopDistanceMin;
        public static final /* enum */ FloatSetting fCombatBlockTimeMax;
        public static final /* enum */ FloatSetting fCombatBlockTimeMid;
        public static final /* enum */ FloatSetting fCombatBlockTimeMin;
        public static final /* enum */ FloatSetting fCombatBoundWeaponDPSBonus;
        public static final /* enum */ FloatSetting fCombatBuffMaxTimer;
        public static final /* enum */ FloatSetting fCombatBuffStandoffTimer;
        public static final /* enum */ FloatSetting fCombatCastConcentrationOffensiveMagicCastTimeMax;
        public static final /* enum */ FloatSetting fCombatCastConcentrationOffensiveMagicCastTimeMin;
        public static final /* enum */ FloatSetting fCombatCastConcentrationOffensiveMagicChanceMax;
        public static final /* enum */ FloatSetting fCombatCastConcentrationOffensiveMagicChanceMin;
        public static final /* enum */ FloatSetting fCombatCastConcentrationOffensiveMagicWaitTimeMax;
        public static final /* enum */ FloatSetting fCombatCastConcentrationOffensiveMagicWaitTimeMin;
        public static final /* enum */ FloatSetting fCombatCastImmediateOffensiveMagicChanceMax;
        public static final /* enum */ FloatSetting fCombatCastImmediateOffensiveMagicChanceMin;
        public static final /* enum */ FloatSetting fCombatCastImmediateOffensiveMagicHoldTimeAbsoluteMin;
        public static final /* enum */ FloatSetting fCombatCastImmediateOffensiveMagicHoldTimeMax;
        public static final /* enum */ FloatSetting fCombatCastImmediateOffensiveMagicHoldTimeMin;
        public static final /* enum */ FloatSetting fCombatCastImmediateOffensiveMagicHoldTimeMinDistance;
        public static final /* enum */ FloatSetting fCombatChangeProcessFaceTargetDistance;
        public static final /* enum */ FloatSetting fCombatCircleAngleMax;
        public static final /* enum */ FloatSetting fCombatCircleAngleMin;
        public static final /* enum */ FloatSetting fCombatCircleAnglePlayerMult;
        public static final /* enum */ FloatSetting fCombatCircleChanceMax;
        public static final /* enum */ FloatSetting fCombatCircleChanceMin;
        public static final /* enum */ FloatSetting fCombatCircleDistanceMax;
        public static final /* enum */ FloatSetting fCombatCircleDistantChanceMax;
        public static final /* enum */ FloatSetting fCombatCircleDistantChanceMin;
        public static final /* enum */ FloatSetting fCombatCircleMinDistanceMult;
        public static final /* enum */ FloatSetting fCombatCircleMinDistanceRadiusMult;
        public static final /* enum */ FloatSetting fCombatCircleMinMovementDistance;
        public static final /* enum */ FloatSetting fCombatCircleViewConeAngle;
        public static final /* enum */ FloatSetting fCombatCloseRangeTrackTargetDistance;
        public static final /* enum */ FloatSetting fCombatClusterUpdateTime;
        public static final /* enum */ FloatSetting fCombatCollectAlliesTimer;
        public static final /* enum */ FloatSetting fCombatConfidenceModifierMax;
        public static final /* enum */ FloatSetting fCombatConfidenceModifierMin;
        public static final /* enum */ FloatSetting fCombatCoverAttackMaxWaitTime;
        public static final /* enum */ FloatSetting fCombatCoverAttackOffsetDistance;
        public static final /* enum */ FloatSetting fCombatCoverAttackTimeMax;
        public static final /* enum */ FloatSetting fCombatCoverAttackTimeMid;
        public static final /* enum */ FloatSetting fCombatCoverAttackTimeMin;
        public static final /* enum */ FloatSetting fCombatCoverAvoidTargetRadius;
        public static final /* enum */ FloatSetting fCombatCoverCheckCoverHeightMin;
        public static final /* enum */ FloatSetting fCombatCoverCheckCoverHeightOffset;
        public static final /* enum */ FloatSetting fCombatCoverEdgeOffsetDistance;
        public static final /* enum */ FloatSetting fCombatCoverLedgeOffsetDistance;
        public static final /* enum */ FloatSetting fCombatCoverMaxRangeMult;
        public static final /* enum */ FloatSetting fCombatCoverMidPointMaxRangeBuffer;
        public static final /* enum */ FloatSetting fCombatCoverMinimumActiveRange;
        public static final /* enum */ FloatSetting fCombatCoverMinimumRange;
        public static final /* enum */ FloatSetting fCombatCoverObstacleMovedTime;
        public static final /* enum */ FloatSetting fCombatCoverRangeMaxActiveMult;
        public static final /* enum */ FloatSetting fCombatCoverRangeMaxBufferDistance;
        public static final /* enum */ FloatSetting fCombatCoverRangeMinActiveMult;
        public static final /* enum */ FloatSetting fCombatCoverRangeMinBufferDistance;
        public static final /* enum */ FloatSetting fCombatCoverReservationWidthMult;
        public static final /* enum */ FloatSetting fCombatCoverSearchDistanceMax;
        public static final /* enum */ FloatSetting fCombatCoverSearchDistanceMin;
        public static final /* enum */ FloatSetting fCombatCoverSearchFailedDelay;
        public static final /* enum */ FloatSetting fCombatCoverSecondaryThreatLastSeenTime;
        public static final /* enum */ FloatSetting fCombatCoverSecondaryThreatMinDistance;
        public static final /* enum */ FloatSetting fCombatCoverWaitLookOffsetDistance;
        public static final /* enum */ FloatSetting fCombatCoverWaitTimeMax;
        public static final /* enum */ FloatSetting fCombatCoverWaitTimeMid;
        public static final /* enum */ FloatSetting fCombatCoverWaitTimeMin;
        public static final /* enum */ FloatSetting fCombatCurrentWeaponAbsoluteMaxRangeMult;
        public static final /* enum */ FloatSetting fCombatDPSBowSpeedMult;
        public static final /* enum */ FloatSetting fCombatDPSMeleeSpeedMult;
        public static final /* enum */ FloatSetting fCombatDamageBonusMeleeSneakingMult;
        public static final /* enum */ FloatSetting fCombatDamageBonusSneakingMult;
        public static final /* enum */ FloatSetting fCombatDamageScale;
        public static final /* enum */ FloatSetting fCombatDeadActorHitConeMult;
        public static final /* enum */ FloatSetting fCombatDetectionDialogueIdleMaxElapsedTime;
        public static final /* enum */ FloatSetting fCombatDetectionDialogueIdleMinElapsedTime;
        public static final /* enum */ FloatSetting fCombatDetectionDialogueMaxElapsedTime;
        public static final /* enum */ FloatSetting fCombatDetectionDialogueMinElapsedTime;
        public static final /* enum */ FloatSetting fCombatDetectionFleeingLostRemoveTime;
        public static final /* enum */ FloatSetting fCombatDetectionLostCheckNoticedDistance;
        public static final /* enum */ FloatSetting fCombatDetectionLostRemoveDistance;
        public static final /* enum */ FloatSetting fCombatDetectionLostRemoveDistanceTime;
        public static final /* enum */ FloatSetting fCombatDetectionLostRemoveTime;
        public static final /* enum */ FloatSetting fCombatDetectionLostTimeLimit;
        public static final /* enum */ FloatSetting fCombatDetectionLowDetectionDistance;
        public static final /* enum */ FloatSetting fCombatDetectionLowPriorityDistance;
        public static final /* enum */ FloatSetting fCombatDetectionNoticedDistanceLimit;
        public static final /* enum */ FloatSetting fCombatDetectionNoticedTimeLimit;
        public static final /* enum */ FloatSetting fCombatDetectionVeryLowPriorityDistance;
        public static final /* enum */ FloatSetting fCombatDialogueAllyKilledDistanceMult;
        public static final /* enum */ FloatSetting fCombatDialogueAllyKilledMaxElapsedTime;
        public static final /* enum */ FloatSetting fCombatDialogueAllyKilledMinElapsedTime;
        public static final /* enum */ FloatSetting fCombatDialogueAttackDistanceMult;
        public static final /* enum */ FloatSetting fCombatDialogueAttackMaxElapsedTime;
        public static final /* enum */ FloatSetting fCombatDialogueAttackMinElapsedTime;
        public static final /* enum */ FloatSetting fCombatDialogueAvoidThreatDistanceMult;
        public static final /* enum */ FloatSetting fCombatDialogueAvoidThreatMaxElapsedTime;
        public static final /* enum */ FloatSetting fCombatDialogueAvoidThreatMinElapsedTime;
        public static final /* enum */ FloatSetting fCombatDialogueBashDistanceMult;
        public static final /* enum */ FloatSetting fCombatDialogueBleedOutMaxElapsedTime;
        public static final /* enum */ FloatSetting fCombatDialogueBleedOutMinElapsedTime;
        public static final /* enum */ FloatSetting fCombatDialogueBleedoutDistanceMult;
        public static final /* enum */ FloatSetting fCombatDialogueBlockDistanceMult;
        public static final /* enum */ FloatSetting fCombatDialogueDeathDistanceMult;
        public static final /* enum */ FloatSetting fCombatDialogueFleeDistanceMult;
        public static final /* enum */ FloatSetting fCombatDialogueFleeMaxElapsedTime;
        public static final /* enum */ FloatSetting fCombatDialogueFleeMinElapsedTime;
        public static final /* enum */ FloatSetting fCombatDialogueGroupStrategyDistanceMult;
        public static final /* enum */ FloatSetting fCombatDialogueHitDistanceMult;
        public static final /* enum */ FloatSetting fCombatDialoguePowerAttackDistanceMult;
        public static final /* enum */ FloatSetting fCombatDialogueTauntDistanceMult;
        public static final /* enum */ FloatSetting fCombatDialogueTauntMaxElapsedTime;
        public static final /* enum */ FloatSetting fCombatDialogueTauntMinElapsedTime;
        public static final /* enum */ FloatSetting fCombatDisarmedFindBetterWeaponInitialTime;
        public static final /* enum */ FloatSetting fCombatDisarmedFindBetterWeaponTime;
        public static final /* enum */ FloatSetting fCombatDismemberedLimbVelocity;
        public static final /* enum */ FloatSetting fCombatDistance;
        public static final /* enum */ FloatSetting fCombatDistanceMin;
        public static final /* enum */ FloatSetting fCombatDiveBombChanceMax;
        public static final /* enum */ FloatSetting fCombatDiveBombChanceMin;
        public static final /* enum */ FloatSetting fCombatDiveBombOffsetPercent;
        public static final /* enum */ FloatSetting fCombatDiveBombSlowDownDistance;
        public static final /* enum */ FloatSetting fCombatDodgeAccelerationMult;
        public static final /* enum */ FloatSetting fCombatDodgeAcceptableThreatScoreMult;
        public static final /* enum */ FloatSetting fCombatDodgeAnticipateThreatTime;
        public static final /* enum */ FloatSetting fCombatDodgeBufferDistance;
        public static final /* enum */ FloatSetting fCombatDodgeChanceMax;
        public static final /* enum */ FloatSetting fCombatDodgeChanceMin;
        public static final /* enum */ FloatSetting fCombatDodgeDecelerationMult;
        public static final /* enum */ FloatSetting fCombatDodgeMovingReactionTime;
        public static final /* enum */ FloatSetting fCombatDodgeReactionTime;
        public static final /* enum */ FloatSetting fCombatEffectiveDistanceAnticipateTime;
        public static final /* enum */ FloatSetting fCombatEnvironmentBloodChance;
        public static final /* enum */ FloatSetting fCombatFallbackChanceMax;
        public static final /* enum */ FloatSetting fCombatFallbackChanceMin;
        public static final /* enum */ FloatSetting fCombatFallbackDistanceMax;
        public static final /* enum */ FloatSetting fCombatFallbackDistanceMin;
        public static final /* enum */ FloatSetting fCombatFallbackMaxAngle;
        public static final /* enum */ FloatSetting fCombatFallbackMinMovementDistance;
        public static final /* enum */ FloatSetting fCombatFallbackWaitTimeMax;
        public static final /* enum */ FloatSetting fCombatFallbackWaitTimeMin;
        public static final /* enum */ FloatSetting fCombatFindAllyAttackLocationAllyRadius;
        public static final /* enum */ FloatSetting fCombatFindAllyAttackLocationDistanceMax;
        public static final /* enum */ FloatSetting fCombatFindAllyAttackLocationDistanceMin;
        public static final /* enum */ FloatSetting fCombatFindAttackLocationAvoidTargetRadius;
        public static final /* enum */ FloatSetting fCombatFindAttackLocationDistance;
        public static final /* enum */ FloatSetting fCombatFindAttackLocationKeyAngle;
        public static final /* enum */ FloatSetting fCombatFindAttackLocationKeyHeight;
        public static final /* enum */ FloatSetting fCombatFindBetterWeaponTime;
        public static final /* enum */ FloatSetting fCombatFindLateralAttackLocationDistance;
        public static final /* enum */ FloatSetting fCombatFindLateralAttackLocationIntervalMax;
        public static final /* enum */ FloatSetting fCombatFindLateralAttackLocationIntervalMin;
        public static final /* enum */ FloatSetting fCombatFiringArcStationaryTurnMult;
        public static final /* enum */ FloatSetting fCombatFlankingAngleOffset;
        public static final /* enum */ FloatSetting fCombatFlankingAngleOffsetCostMult;
        public static final /* enum */ FloatSetting fCombatFlankingAngleOffsetMax;
        public static final /* enum */ FloatSetting fCombatFlankingDirectionDistanceMult;
        public static final /* enum */ FloatSetting fCombatFlankingDirectionGoalAngleOffset;
        public static final /* enum */ FloatSetting fCombatFlankingDirectionOffsetCostMult;
        public static final /* enum */ FloatSetting fCombatFlankingDirectionRotateAngleOffset;
        public static final /* enum */ FloatSetting fCombatFlankingDistanceMax;
        public static final /* enum */ FloatSetting fCombatFlankingDistanceMin;
        public static final /* enum */ FloatSetting fCombatFlankingGoalAngleFarMax;
        public static final /* enum */ FloatSetting fCombatFlankingGoalAngleFarMaxDistance;
        public static final /* enum */ FloatSetting fCombatFlankingGoalAngleFarMin;
        public static final /* enum */ FloatSetting fCombatFlankingGoalAngleFarMinDistance;
        public static final /* enum */ FloatSetting fCombatFlankingGoalAngleNear;
        public static final /* enum */ FloatSetting fCombatFlankingGoalCheckDistanceMax;
        public static final /* enum */ FloatSetting fCombatFlankingGoalCheckDistanceMin;
        public static final /* enum */ FloatSetting fCombatFlankingGoalCheckDistanceMult;
        public static final /* enum */ FloatSetting fCombatFlankingLocationGridSize;
        public static final /* enum */ FloatSetting fCombatFlankingMaxTurnAngle;
        public static final /* enum */ FloatSetting fCombatFlankingMaxTurnAngleGoal;
        public static final /* enum */ FloatSetting fCombatFlankingNearDistance;
        public static final /* enum */ FloatSetting fCombatFlankingRotateAngle;
        public static final /* enum */ FloatSetting fCombatFlankingStalkRange;
        public static final /* enum */ FloatSetting fCombatFlankingStalkTimeMax;
        public static final /* enum */ FloatSetting fCombatFlankingStalkTimeMin;
        public static final /* enum */ FloatSetting fCombatFlankingStepDistanceMax;
        public static final /* enum */ FloatSetting fCombatFlankingStepDistanceMin;
        public static final /* enum */ FloatSetting fCombatFlankingStepDistanceMult;
        public static final /* enum */ FloatSetting fCombatFleeAllyDistanceMax;
        public static final /* enum */ FloatSetting fCombatFleeAllyDistanceMin;
        public static final /* enum */ FloatSetting fCombatFleeAllyRadius;
        public static final /* enum */ FloatSetting fCombatFleeCoverMinDistance;
        public static final /* enum */ FloatSetting fCombatFleeCoverSearchRadius;
        public static final /* enum */ FloatSetting fCombatFleeDistanceExterior;
        public static final /* enum */ FloatSetting fCombatFleeDistanceInterior;
        public static final /* enum */ FloatSetting fCombatFleeDoorDistanceMax;
        public static final /* enum */ FloatSetting fCombatFleeDoorTargetCheckDistance;
        public static final /* enum */ FloatSetting fCombatFleeInitialDoorRestrictChance;
        public static final /* enum */ FloatSetting fCombatFleeLastDoorRestrictTime;
        public static final /* enum */ FloatSetting fCombatFleeTargetAvoidRadius;
        public static final /* enum */ FloatSetting fCombatFleeTargetGatherRadius;
        public static final /* enum */ FloatSetting fCombatFleeUseDoorChance;
        public static final /* enum */ FloatSetting fCombatFleeUseDoorRestrictTime;
        public static final /* enum */ FloatSetting fCombatFlightEffectiveDistance;
        public static final /* enum */ FloatSetting fCombatFlightMinimumRange;
        public static final /* enum */ FloatSetting fCombatFlyingAttackChanceMax;
        public static final /* enum */ FloatSetting fCombatFlyingAttackChanceMin;
        public static final /* enum */ FloatSetting fCombatFlyingAttackTargetDistanceThreshold;
        public static final /* enum */ FloatSetting fCombatFollowRadiusBase;
        public static final /* enum */ FloatSetting fCombatFollowRadiusMin;
        public static final /* enum */ FloatSetting fCombatFollowRadiusMult;
        public static final /* enum */ FloatSetting fCombatFollowSneakFollowRadius;
        public static final /* enum */ FloatSetting fCombatForwardAttackChance;
        public static final /* enum */ FloatSetting fCombatGiantCreatureReachMult;
        public static final /* enum */ FloatSetting fCombatGrenadeBounceTimeMax;
        public static final /* enum */ FloatSetting fCombatGrenadeBounceTimeMin;
        public static final /* enum */ FloatSetting fCombatGroundAttackChanceMax;
        public static final /* enum */ FloatSetting fCombatGroundAttackChanceMin;
        public static final /* enum */ FloatSetting fCombatGroundAttackTimeMax;
        public static final /* enum */ FloatSetting fCombatGroundAttackTimeMin;
        public static final /* enum */ FloatSetting fCombatGroupCombatStrengthUpdateTime;
        public static final /* enum */ FloatSetting fCombatGroupOffensiveMultMin;
        public static final /* enum */ FloatSetting fCombatGuardFollowBufferDistance;
        public static final /* enum */ FloatSetting fCombatGuardRadiusMin;
        public static final /* enum */ FloatSetting fCombatGuardRadiusMult;
        public static final /* enum */ FloatSetting fCombatHealthRegenRateMult;
        public static final /* enum */ FloatSetting fCombatHideCheckViewConeDistanceMax;
        public static final /* enum */ FloatSetting fCombatHideCheckViewConeDistanceMin;
        public static final /* enum */ FloatSetting fCombatHideFailedTargetDistance;
        public static final /* enum */ FloatSetting fCombatHideFailedTargetLOSDistance;
        public static final /* enum */ FloatSetting fCombatHitConeAngle;
        public static final /* enum */ FloatSetting fCombatHoverAngleLimit;
        public static final /* enum */ FloatSetting fCombatHoverAngleMax;
        public static final /* enum */ FloatSetting fCombatHoverAngleMin;
        public static final /* enum */ FloatSetting fCombatHoverChanceMax;
        public static final /* enum */ FloatSetting fCombatHoverChanceMin;
        public static final /* enum */ FloatSetting fCombatHoverTimeMax;
        public static final /* enum */ FloatSetting fCombatHoverTimeMin;
        public static final /* enum */ FloatSetting fCombatInTheWayTimer;
        public static final /* enum */ FloatSetting fCombatInventoryDesiredRangeScoreMultMax;
        public static final /* enum */ FloatSetting fCombatInventoryDesiredRangeScoreMultMid;
        public static final /* enum */ FloatSetting fCombatInventoryDesiredRangeScoreMultMin;
        public static final /* enum */ FloatSetting fCombatInventoryDualWieldScorePenalty;
        public static final /* enum */ FloatSetting fCombatInventoryEquipmentMinScoreMult;
        public static final /* enum */ FloatSetting fCombatInventoryEquippedScoreBonus;
        public static final /* enum */ FloatSetting fCombatInventoryMaxRangeEquippedBonus;
        public static final /* enum */ FloatSetting fCombatInventoryMaxRangeScoreMult;
        public static final /* enum */ FloatSetting fCombatInventoryMeleeEquipRange;
        public static final /* enum */ FloatSetting fCombatInventoryMinEquipTimeBlock;
        public static final /* enum */ FloatSetting fCombatInventoryMinEquipTimeDefault;
        public static final /* enum */ FloatSetting fCombatInventoryMinEquipTimeMagic;
        public static final /* enum */ FloatSetting fCombatInventoryMinEquipTimeShout;
        public static final /* enum */ FloatSetting fCombatInventoryMinEquipTimeStaff;
        public static final /* enum */ FloatSetting fCombatInventoryMinEquipTimeTorch;
        public static final /* enum */ FloatSetting fCombatInventoryMinEquipTimeWeapon;
        public static final /* enum */ FloatSetting fCombatInventoryMinRangeScoreMult;
        public static final /* enum */ FloatSetting fCombatInventoryMinRangeUnequippedBonus;
        public static final /* enum */ FloatSetting fCombatInventoryOptimalRangePercent;
        public static final /* enum */ FloatSetting fCombatInventoryRangedScoreMult;
        public static final /* enum */ FloatSetting fCombatInventoryResourceCurrentRequiredMult;
        public static final /* enum */ FloatSetting fCombatInventoryResourceDesiredRequiredMult;
        public static final /* enum */ FloatSetting fCombatInventoryResourceRegenTime;
        public static final /* enum */ FloatSetting fCombatInventoryShieldEquipRange;
        public static final /* enum */ FloatSetting fCombatInventoryShoutMaxRecoveryTime;
        public static final /* enum */ FloatSetting fCombatInventoryTorchEquipRange;
        public static final /* enum */ FloatSetting fCombatInventoryUpdateTimer;
        public static final /* enum */ FloatSetting fCombatIronSightsDistance;
        public static final /* enum */ FloatSetting fCombatIronSightsRangeMult;
        public static final /* enum */ FloatSetting fCombatItemBuffTimer;
        public static final /* enum */ FloatSetting fCombatItemRestoreTimer;
        public static final /* enum */ FloatSetting fCombatKillMoveDamageMult;
        public static final /* enum */ FloatSetting fCombatLandingAvoidActorRadius;
        public static final /* enum */ FloatSetting fCombatLandingSearchDistance;
        public static final /* enum */ FloatSetting fCombatLandingZoneDistance;
        public static final /* enum */ FloatSetting fCombatLineOfSightTimer;
        public static final /* enum */ FloatSetting fCombatLocationTargetRadiusMin;
        public static final /* enum */ FloatSetting fCombatLowFleeingTargetHitPercent;
        public static final /* enum */ FloatSetting fCombatLowMaxAttackDistance;
        public static final /* enum */ FloatSetting fCombatLowTargetHitPercent;
        public static final /* enum */ FloatSetting fCombatMagicArmorDistanceMax;
        public static final /* enum */ FloatSetting fCombatMagicArmorDistanceMin;
        public static final /* enum */ FloatSetting fCombatMagicArmorMinCastTime;
        public static final /* enum */ FloatSetting fCombatMagicBoundItemDistance;
        public static final /* enum */ FloatSetting fCombatMagicBuffDuration;
        public static final /* enum */ FloatSetting fCombatMagicCloakDistanceMax;
        public static final /* enum */ FloatSetting fCombatMagicCloakDistanceMin;
        public static final /* enum */ FloatSetting fCombatMagicCloakMinCastTime;
        public static final /* enum */ FloatSetting fCombatMagicConcentrationAimVariance;
        public static final /* enum */ FloatSetting fCombatMagicConcentrationFiringArcMult;
        public static final /* enum */ FloatSetting fCombatMagicConcentrationMinCastTime;
        public static final /* enum */ FloatSetting fCombatMagicConcentrationScoreDuration;
        public static final /* enum */ FloatSetting fCombatMagicDefaultLongDuration;
        public static final /* enum */ FloatSetting fCombatMagicDefaultMinCastTime;
        public static final /* enum */ FloatSetting fCombatMagicDefaultShortDuration;
        public static final /* enum */ FloatSetting fCombatMagicDisarmDistance;
        public static final /* enum */ FloatSetting fCombatMagicDisarmRestrictTime;
        public static final /* enum */ FloatSetting fCombatMagicDrinkPotionWaitTime;
        public static final /* enum */ FloatSetting fCombatMagicDualCastChance;
        public static final /* enum */ FloatSetting fCombatMagicDualCastInterruptTime;
        public static final /* enum */ FloatSetting fCombatMagicImmediateAimVariance;
        public static final /* enum */ FloatSetting fCombatMagicInvisibilityDistance;
        public static final /* enum */ FloatSetting fCombatMagicInvisibilityMinCastTime;
        public static final /* enum */ FloatSetting fCombatMagicLightMinCastTime;
        public static final /* enum */ FloatSetting fCombatMagicOffensiveMinCastTime;
        public static final /* enum */ FloatSetting fCombatMagicParalyzeDistance;
        public static final /* enum */ FloatSetting fCombatMagicParalyzeMinCastTime;
        public static final /* enum */ FloatSetting fCombatMagicParalyzeRestrictTime;
        public static final /* enum */ FloatSetting fCombatMagicProjectileFiringArc;
        public static final /* enum */ FloatSetting fCombatMagicReanimateDistance;
        public static final /* enum */ FloatSetting fCombatMagicReanimateMinCastTime;
        public static final /* enum */ FloatSetting fCombatMagicReanimateRestrictTime;
        public static final /* enum */ FloatSetting fCombatMagicStaggerDistance;
        public static final /* enum */ FloatSetting fCombatMagicSummonMinCastTime;
        public static final /* enum */ FloatSetting fCombatMagicSummonRestrictTime;
        public static final /* enum */ FloatSetting fCombatMagicTacticalDuration;
        public static final /* enum */ FloatSetting fCombatMagicTargetEffectMinCastTime;
        public static final /* enum */ FloatSetting fCombatMagicWardAttackRangeDistance;
        public static final /* enum */ FloatSetting fCombatMagicWardAttackReachMult;
        public static final /* enum */ FloatSetting fCombatMagicWardCooldownTime;
        public static final /* enum */ FloatSetting fCombatMagicWardMagickaCastLimit;
        public static final /* enum */ FloatSetting fCombatMagicWardMagickaEquipLimit;
        public static final /* enum */ FloatSetting fCombatMagicWardMinCastTime;
        public static final /* enum */ FloatSetting fCombatMagickaRegenRateMult;
        public static final /* enum */ FloatSetting fCombatMaintainOptimalDistanceMaxAngle;
        public static final /* enum */ FloatSetting fCombatMaintainRangeDistanceMin;
        public static final /* enum */ FloatSetting fCombatMaxHoldScore;
        public static final /* enum */ FloatSetting fCombatMaximumOptimalRangeMax;
        public static final /* enum */ FloatSetting fCombatMaximumOptimalRangeMid;
        public static final /* enum */ FloatSetting fCombatMaximumOptimalRangeMin;
        public static final /* enum */ FloatSetting fCombatMaximumProjectileRange;
        public static final /* enum */ FloatSetting fCombatMaximumRange;
        public static final /* enum */ FloatSetting fCombatMeleeTrackTargetDistanceMax;
        public static final /* enum */ FloatSetting fCombatMeleeTrackTargetDistanceMin;
        public static final /* enum */ FloatSetting fCombatMinEngageDistance;
        public static final /* enum */ FloatSetting fCombatMissileImpaleDepth;
        public static final /* enum */ FloatSetting fCombatMissileStickDepth;
        public static final /* enum */ FloatSetting fCombatMonitorBuffsTimer;
        public static final /* enum */ FloatSetting fCombatMoveToActorBufferDistance;
        public static final /* enum */ FloatSetting fCombatMusicGroupThreatRatioMax;
        public static final /* enum */ FloatSetting fCombatMusicGroupThreatRatioMin;
        public static final /* enum */ FloatSetting fCombatMusicGroupThreatRatioTimer;
        public static final /* enum */ FloatSetting fCombatMusicNearCombatInnerRadius;
        public static final /* enum */ FloatSetting fCombatMusicNearCombatOuterRadius;
        public static final /* enum */ FloatSetting fCombatMusicPlayerCombatStrengthCap;
        public static final /* enum */ FloatSetting fCombatMusicPlayerNearStrengthMult;
        public static final /* enum */ FloatSetting fCombatMusicPlayerTargetedThreatRatio;
        public static final /* enum */ FloatSetting fCombatMusicStopTime;
        public static final /* enum */ FloatSetting fCombatMusicUpdateTime;
        public static final /* enum */ FloatSetting fCombatOffensiveBashChanceMax;
        public static final /* enum */ FloatSetting fCombatOffensiveBashChanceMin;
        public static final /* enum */ FloatSetting fCombatOptimalRangeMaxBufferDistance;
        public static final /* enum */ FloatSetting fCombatOptimalRangeMinBufferDistance;
        public static final /* enum */ FloatSetting fCombatOrbitDistance;
        public static final /* enum */ FloatSetting fCombatOrbitTimeMax;
        public static final /* enum */ FloatSetting fCombatOrbitTimeMin;
        public static final /* enum */ FloatSetting fCombatParalyzeTacticalDuration;
        public static final /* enum */ FloatSetting fCombatPathingAccelerationMult;
        public static final /* enum */ FloatSetting fCombatPathingCurvedPathSmoothingMult;
        public static final /* enum */ FloatSetting fCombatPathingDecelerationMult;
        public static final /* enum */ FloatSetting fCombatPathingGoalRayCastPathDistance;
        public static final /* enum */ FloatSetting fCombatPathingIncompletePathMinDistance;
        public static final /* enum */ FloatSetting fCombatPathingLocationCenterOffsetMult;
        public static final /* enum */ FloatSetting fCombatPathingLookAheadDelta;
        public static final /* enum */ FloatSetting fCombatPathingNormalizedRotationSpeed;
        public static final /* enum */ FloatSetting fCombatPathingRefLocationUpdateDistance;
        public static final /* enum */ FloatSetting fCombatPathingRefLocationUpdateTimeDistanceMax;
        public static final /* enum */ FloatSetting fCombatPathingRefLocationUpdateTimeDistanceMin;
        public static final /* enum */ FloatSetting fCombatPathingRefLocationUpdateTimeMax;
        public static final /* enum */ FloatSetting fCombatPathingRefLocationUpdateTimeMin;
        public static final /* enum */ FloatSetting fCombatPathingRetryWaitTime;
        public static final /* enum */ FloatSetting fCombatPathingRotationAccelerationMult;
        public static final /* enum */ FloatSetting fCombatPathingStartRayCastPathDistance;
        public static final /* enum */ FloatSetting fCombatPathingStraightPathCheckDistance;
        public static final /* enum */ FloatSetting fCombatPathingStraightRayCastPathDistance;
        public static final /* enum */ FloatSetting fCombatPathingUpdatePathCostMult;
        public static final /* enum */ FloatSetting fCombatPerchAttackChanceMax;
        public static final /* enum */ FloatSetting fCombatPerchAttackChanceMin;
        public static final /* enum */ FloatSetting fCombatPerchAttackTimeMax;
        public static final /* enum */ FloatSetting fCombatPerchAttackTimeMin;
        public static final /* enum */ FloatSetting fCombatPerchMaxTargetAngle;
        public static final /* enum */ FloatSetting fCombatPlayerBleedoutHealthDamageMult;
        public static final /* enum */ FloatSetting fCombatPlayerLimbDamageMult;
        public static final /* enum */ FloatSetting fCombatProjectileMaxRangeMult;
        public static final /* enum */ FloatSetting fCombatProjectileMaxRangeOptimalMult;
        public static final /* enum */ FloatSetting fCombatRadiusMinMult;
        public static final /* enum */ FloatSetting fCombatRangedAimVariance;
        public static final /* enum */ FloatSetting fCombatRangedAttackChanceLastAttackBonus;
        public static final /* enum */ FloatSetting fCombatRangedAttackChanceLastAttackBonusTime;
        public static final /* enum */ FloatSetting fCombatRangedAttackChanceMax;
        public static final /* enum */ FloatSetting fCombatRangedAttackChanceMin;
        public static final /* enum */ FloatSetting fCombatRangedAttackHoldTimeAbsoluteMin;
        public static final /* enum */ FloatSetting fCombatRangedAttackHoldTimeMax;
        public static final /* enum */ FloatSetting fCombatRangedAttackHoldTimeMin;
        public static final /* enum */ FloatSetting fCombatRangedAttackHoldTimeMinDistance;
        public static final /* enum */ FloatSetting fCombatRangedAttackMaximumHoldTime;
        public static final /* enum */ FloatSetting fCombatRangedDistance;
        public static final /* enum */ FloatSetting fCombatRangedMinimumRange;
        public static final /* enum */ FloatSetting fCombatRangedProjectileFiringArc;
        public static final /* enum */ FloatSetting fCombatRangedStandoffTimer;
        public static final /* enum */ FloatSetting fCombatRelativeDamageMod;
        public static final /* enum */ FloatSetting fCombatRestoreHealthPercentMax;
        public static final /* enum */ FloatSetting fCombatRestoreHealthPercentMin;
        public static final /* enum */ FloatSetting fCombatRestoreHealthRestrictTime;
        public static final /* enum */ FloatSetting fCombatRestoreMagickaPercentMax;
        public static final /* enum */ FloatSetting fCombatRestoreMagickaPercentMin;
        public static final /* enum */ FloatSetting fCombatRestoreMagickaRestrictTime;
        public static final /* enum */ FloatSetting fCombatRestoreStopCastThreshold;
        public static final /* enum */ FloatSetting fCombatRoundAmount;
        public static final /* enum */ FloatSetting fCombatSearchAreaUpdateTime;
        public static final /* enum */ FloatSetting fCombatSearchCenterRadius;
        public static final /* enum */ FloatSetting fCombatSearchCheckDestinationDistanceMax;
        public static final /* enum */ FloatSetting fCombatSearchCheckDestinationDistanceMid;
        public static final /* enum */ FloatSetting fCombatSearchCheckDestinationDistanceMin;
        public static final /* enum */ FloatSetting fCombatSearchCheckDestinationTime;
        public static final /* enum */ FloatSetting fCombatSearchDoorDistance;
        public static final /* enum */ FloatSetting fCombatSearchDoorDistanceLow;
        public static final /* enum */ FloatSetting fCombatSearchDoorSearchRadius;
        public static final /* enum */ FloatSetting fCombatSearchExteriorRadiusMax;
        public static final /* enum */ FloatSetting fCombatSearchExteriorRadiusMin;
        public static final /* enum */ FloatSetting fCombatSearchIgnoreLocationRadius;
        public static final /* enum */ FloatSetting fCombatSearchInteriorRadiusMax;
        public static final /* enum */ FloatSetting fCombatSearchInteriorRadiusMin;
        public static final /* enum */ FloatSetting fCombatSearchInvestigateTime;
        public static final /* enum */ FloatSetting fCombatSearchLocationCheckDistance;
        public static final /* enum */ FloatSetting fCombatSearchLocationCheckTime;
        public static final /* enum */ FloatSetting fCombatSearchLocationInitialCheckTime;
        public static final /* enum */ FloatSetting fCombatSearchLocationInvestigateDistance;
        public static final /* enum */ FloatSetting fCombatSearchLocationRadius;
        public static final /* enum */ FloatSetting fCombatSearchLookTime;
        public static final /* enum */ FloatSetting fCombatSearchRadiusBufferDistance;
        public static final /* enum */ FloatSetting fCombatSearchRadiusMemberDistance;
        public static final /* enum */ FloatSetting fCombatSearchSightRadius;
        public static final /* enum */ FloatSetting fCombatSearchStartWaitTime;
        public static final /* enum */ FloatSetting fCombatSearchUpdateTime;
        public static final /* enum */ FloatSetting fCombatSearchWanderDistance;
        public static final /* enum */ FloatSetting fCombatSelectTargetSwitchUpdateTime;
        public static final /* enum */ FloatSetting fCombatSelectTargetUpdateTime;
        public static final /* enum */ FloatSetting fCombatShoutHeadTrackingAngleMovingMult;
        public static final /* enum */ FloatSetting fCombatShoutHeadTrackingAngleMult;
        public static final /* enum */ FloatSetting fCombatShoutLongRecoveryTime;
        public static final /* enum */ FloatSetting fCombatShoutMaxHeadTrackingAngle;
        public static final /* enum */ FloatSetting fCombatShoutReleaseTime;
        public static final /* enum */ FloatSetting fCombatShoutShortRecoveryTime;
        public static final /* enum */ FloatSetting fCombatSneakAttackBonusMult;
        public static final /* enum */ FloatSetting fCombatSpeakAttackChance;
        public static final /* enum */ FloatSetting fCombatSpeakHitChance;
        public static final /* enum */ FloatSetting fCombatSpeakHitThreshold;
        public static final /* enum */ FloatSetting fCombatSpeakPowerAttackChance;
        public static final /* enum */ FloatSetting fCombatSpeakTauntChance;
        public static final /* enum */ FloatSetting fCombatSpecialAttackChanceMax;
        public static final /* enum */ FloatSetting fCombatSpecialAttackChanceMin;
        public static final /* enum */ FloatSetting fCombatSpeedValueFastWalk;
        public static final /* enum */ FloatSetting fCombatSpeedValueJog;
        public static final /* enum */ FloatSetting fCombatSpeedValueRun;
        public static final /* enum */ FloatSetting fCombatSpeedValueWalk;
        public static final /* enum */ FloatSetting fCombatSplashDamageMaxSpeed;
        public static final /* enum */ FloatSetting fCombatSplashDamageMinDamage;
        public static final /* enum */ FloatSetting fCombatSplashDamageMinRadius;
        public static final /* enum */ FloatSetting fCombatStaffTimer;
        public static final /* enum */ FloatSetting fCombatStaminaRegenRateMult;
        public static final /* enum */ FloatSetting fCombatStealthPointAttackedMaxValue;
        public static final /* enum */ FloatSetting fCombatStealthPointDetectedEventMaxValue;
        public static final /* enum */ FloatSetting fCombatStealthPointDrainMult;
        public static final /* enum */ FloatSetting fCombatStealthPointMax;
        public static final /* enum */ FloatSetting fCombatStealthPointRegenAlertWaitTime;
        public static final /* enum */ FloatSetting fCombatStealthPointRegenAttackedWaitTime;
        public static final /* enum */ FloatSetting fCombatStealthPointRegenDetectedEventWaitTime;
        public static final /* enum */ FloatSetting fCombatStealthPointRegenLostWaitTime;
        public static final /* enum */ FloatSetting fCombatStealthPointRegenMin;
        public static final /* enum */ FloatSetting fCombatStealthPointRegenMult;
        public static final /* enum */ FloatSetting fCombatStepAdvanceDistance;
        public static final /* enum */ FloatSetting fCombatStrafeChanceMax;
        public static final /* enum */ FloatSetting fCombatStrafeChanceMin;
        public static final /* enum */ FloatSetting fCombatStrafeDistanceMax;
        public static final /* enum */ FloatSetting fCombatStrafeDistanceMin;
        public static final /* enum */ FloatSetting fCombatStrafeMinDistanceRadiusMult;
        public static final /* enum */ FloatSetting fCombatStrengthUpdateTime;
        public static final /* enum */ FloatSetting fCombatSurroundDistanceMax;
        public static final /* enum */ FloatSetting fCombatSurroundDistanceMin;
        public static final /* enum */ FloatSetting fCombatTargetEngagedLastSeenTime;
        public static final /* enum */ FloatSetting fCombatTargetLocationAvoidNodeRadiusOffset;
        public static final /* enum */ FloatSetting fCombatTargetLocationCurrentReservationDistanceMult;
        public static final /* enum */ FloatSetting fCombatTargetLocationMaxDistance;
        public static final /* enum */ FloatSetting fCombatTargetLocationMinDistanceMult;
        public static final /* enum */ FloatSetting fCombatTargetLocationPathingRadius;
        public static final /* enum */ FloatSetting fCombatTargetLocationRadiusSizeMult;
        public static final /* enum */ FloatSetting fCombatTargetLocationRepositionAngleMult;
        public static final /* enum */ FloatSetting fCombatTargetLocationSwimmingOffset;
        public static final /* enum */ FloatSetting fCombatTargetLocationWidthMax;
        public static final /* enum */ FloatSetting fCombatTargetLocationWidthMin;
        public static final /* enum */ FloatSetting fCombatTargetLocationWidthSizeMult;
        public static final /* enum */ FloatSetting fCombatTeammateFollowRadiusBase;
        public static final /* enum */ FloatSetting fCombatTeammateFollowRadiusMin;
        public static final /* enum */ FloatSetting fCombatTeammateFollowRadiusMult;
        public static final /* enum */ FloatSetting fCombatThreatAnticipateTime;
        public static final /* enum */ FloatSetting fCombatThreatAvoidCost;
        public static final /* enum */ FloatSetting fCombatThreatBufferRadius;
        public static final /* enum */ FloatSetting fCombatThreatCacheVelocityTime;
        public static final /* enum */ FloatSetting fCombatThreatDangerousObjectHealth;
        public static final /* enum */ FloatSetting fCombatThreatExplosiveObjectThreatTime;
        public static final /* enum */ FloatSetting fCombatThreatExtrudeTime;
        public static final /* enum */ FloatSetting fCombatThreatExtrudeVelocityThreshold;
        public static final /* enum */ FloatSetting fCombatThreatNegativeExtrudeTime;
        public static final /* enum */ FloatSetting fCombatThreatProximityExplosionAvoidTime;
        public static final /* enum */ FloatSetting fCombatThreatRatioUpdateTime;
        public static final /* enum */ FloatSetting fCombatThreatSignificantScore;
        public static final /* enum */ FloatSetting fCombatThreatTimedExplosionLength;
        public static final /* enum */ FloatSetting fCombatThreatUpdateTimeMax;
        public static final /* enum */ FloatSetting fCombatThreatUpdateTimeMin;
        public static final /* enum */ FloatSetting fCombatThreatViewCone;
        public static final /* enum */ FloatSetting fCombatUnarmedCritDamageMult;
        public static final /* enum */ FloatSetting fCombatUnreachableTargetCheckTime;
        public static final /* enum */ FloatSetting fCombatVulnerabilityMod;
        public static final /* enum */ FloatSetting fCombatYieldRetryTime;
        public static final /* enum */ FloatSetting fCombatYieldTime;
        public static final /* enum */ FloatSetting fCommentOnPlayerActionsTimer;
        public static final /* enum */ FloatSetting fCommentOnPlayerKnockingThings;
        public static final /* enum */ FloatSetting fConcussionTimer;
        public static final /* enum */ FloatSetting fConeProjectileEnvironmentDistance;
        public static final /* enum */ FloatSetting fConeProjectileEnvironmentTimer;
        public static final /* enum */ FloatSetting fConeProjectileForceBase;
        public static final /* enum */ FloatSetting fConeProjectileForceMult;
        public static final /* enum */ FloatSetting fConeProjectileForceMultAngular;
        public static final /* enum */ FloatSetting fConeProjectileForceMultLinear;
        public static final /* enum */ FloatSetting fConeProjectileWaterScaleMult;
        public static final /* enum */ FloatSetting fCoverEvaluationLastSeenExpireTime;
        public static final /* enum */ FloatSetting fCoverFiredProjectileExpireTime;
        public static final /* enum */ FloatSetting fCoverFiringReloadClipPercent;
        public static final /* enum */ FloatSetting fCoverWaitReloadClipPercent;
        public static final /* enum */ FloatSetting fCoveredAdvanceMinAdvanceDistanceMax;
        public static final /* enum */ FloatSetting fCoveredAdvanceMinAdvanceDistanceMin;
        public static final /* enum */ FloatSetting fCrafting;
        public static final /* enum */ FloatSetting fCreatureDefaultTurningSpeed;
        public static final /* enum */ FloatSetting fCreditsScrollSpeed;
        public static final /* enum */ FloatSetting fCrimeAlarmRespMult;
        public static final /* enum */ FloatSetting fCrimeDispAttack;
        public static final /* enum */ FloatSetting fCrimeDispMurder;
        public static final /* enum */ FloatSetting fCrimeDispPersonal;
        public static final /* enum */ FloatSetting fCrimeDispPickpocket;
        public static final /* enum */ FloatSetting fCrimeDispSteal;
        public static final /* enum */ FloatSetting fCrimeDispTresspass;
        public static final /* enum */ FloatSetting fCrimeFavorMult;
        public static final /* enum */ FloatSetting fCrimeGoldSkillPenaltyMult;
        public static final /* enum */ FloatSetting fCrimeGoldSteal;
        public static final /* enum */ FloatSetting fCrimePersonalRegardMult;
        public static final /* enum */ FloatSetting fCrimeRegardMult;
        public static final /* enum */ FloatSetting fCrimeSoundBase;
        public static final /* enum */ FloatSetting fCrimeSoundMult;
        public static final /* enum */ FloatSetting fCrimeWitnessRegardMult;
        public static final /* enum */ FloatSetting fDOFDistanceMult;
        public static final /* enum */ FloatSetting fDamageArmConditionBase;
        public static final /* enum */ FloatSetting fDamageArmConditionMult;
        public static final /* enum */ FloatSetting fDamageGunWeapCondBase;
        public static final /* enum */ FloatSetting fDamageGunWeapCondMult;
        public static final /* enum */ FloatSetting fDamageMeleeWeapCondBase;
        public static final /* enum */ FloatSetting fDamageMeleeWeapCondMult;
        public static final /* enum */ FloatSetting fDamagePCSkillMax;
        public static final /* enum */ FloatSetting fDamagePCSkillMin;
        public static final /* enum */ FloatSetting fDamageSkillMax;
        public static final /* enum */ FloatSetting fDamageSkillMin;
        public static final /* enum */ FloatSetting fDamageSneakAttackMult;
        public static final /* enum */ FloatSetting fDamageStrengthBase;
        public static final /* enum */ FloatSetting fDamageStrengthMult;
        public static final /* enum */ FloatSetting fDamageToArmorPercentage;
        public static final /* enum */ FloatSetting fDamageToWeaponEnergyMult;
        public static final /* enum */ FloatSetting fDamageToWeaponGunMult;
        public static final /* enum */ FloatSetting fDamageToWeaponLauncherMult;
        public static final /* enum */ FloatSetting fDamageToWeaponMeleeMult;
        public static final /* enum */ FloatSetting fDamageUnarmedPenalty;
        public static final /* enum */ FloatSetting fDamageWeaponMult;
        public static final /* enum */ FloatSetting fDamagedAVRegenDelay;
        public static final /* enum */ FloatSetting fDamagedHealthRegenDelay;
        public static final /* enum */ FloatSetting fDamagedMagickaRegenDelay;
        public static final /* enum */ FloatSetting fDamagedStaminaRegenDelay;
        public static final /* enum */ FloatSetting fDangerousObjectExplosionDamage;
        public static final /* enum */ FloatSetting fDangerousObjectExplosionRadius;
        public static final /* enum */ FloatSetting fDangerousProjectileExplosionDamage;
        public static final /* enum */ FloatSetting fDangerousProjectileExplosionRadius;
        public static final /* enum */ FloatSetting fDaytimeColorExtension;
        public static final /* enum */ FloatSetting fDeadReactionDistance;
        public static final /* enum */ FloatSetting fDeathForceDamageMax;
        public static final /* enum */ FloatSetting fDeathForceDamageMin;
        public static final /* enum */ FloatSetting fDeathForceForceMax;
        public static final /* enum */ FloatSetting fDeathForceForceMin;
        public static final /* enum */ FloatSetting fDeathForceMassBase;
        public static final /* enum */ FloatSetting fDeathForceMassMult;
        public static final /* enum */ FloatSetting fDeathForceRangedDamageMax;
        public static final /* enum */ FloatSetting fDeathForceRangedDamageMin;
        public static final /* enum */ FloatSetting fDeathForceRangedForceMax;
        public static final /* enum */ FloatSetting fDeathForceRangedForceMin;
        public static final /* enum */ FloatSetting fDeathForceSpellImpactMult;
        public static final /* enum */ FloatSetting fDeathSoundMaxDistance;
        public static final /* enum */ FloatSetting fDebrisFadeTime;
        public static final /* enum */ FloatSetting fDecalLOD;
        public static final /* enum */ FloatSetting fDecapitateBloodTime;
        public static final /* enum */ FloatSetting fDefault;
        public static final /* enum */ FloatSetting fDefaultAngleTolerance;
        public static final /* enum */ FloatSetting fDefaultBowSpeedBonus;
        public static final /* enum */ FloatSetting fDemandBase;
        public static final /* enum */ FloatSetting fDemandMult;
        public static final /* enum */ FloatSetting fDetectEventDistanceNPC;
        public static final /* enum */ FloatSetting fDetectEventDistancePlayer;
        public static final /* enum */ FloatSetting fDetectEventDistanceVeryLoudMult;
        public static final /* enum */ FloatSetting fDetectEventSneakDistanceVeryLoud;
        public static final /* enum */ FloatSetting fDetectProjectileDistanceNPC;
        public static final /* enum */ FloatSetting fDetectProjectileDistancePlayer;
        public static final /* enum */ FloatSetting fDetectionActionTimer;
        public static final /* enum */ FloatSetting fDetectionCombatNonTargetDistanceMult;
        public static final /* enum */ FloatSetting fDetectionCommentTimer;
        public static final /* enum */ FloatSetting fDetectionEventExpireTime;
        public static final /* enum */ FloatSetting fDetectionLOSDistanceAngle;
        public static final /* enum */ FloatSetting fDetectionLOSDistanceMultExterior;
        public static final /* enum */ FloatSetting fDetectionLOSDistanceMultInterior;
        public static final /* enum */ FloatSetting fDetectionLargeActorSizeMult;
        public static final /* enum */ FloatSetting fDetectionNightEyeBonus;
        public static final /* enum */ FloatSetting fDetectionSneakLightMod;
        public static final /* enum */ FloatSetting fDetectionStateExpireTime;
        public static final /* enum */ FloatSetting fDetectionUpdateTimeMax;
        public static final /* enum */ FloatSetting fDetectionUpdateTimeMaxComplex;
        public static final /* enum */ FloatSetting fDetectionUpdateTimeMin;
        public static final /* enum */ FloatSetting fDetectionUpdateTimeMinComplex;
        public static final /* enum */ FloatSetting fDetectionViewCone;
        public static final /* enum */ FloatSetting fDialogFocalDepthRange;
        public static final /* enum */ FloatSetting fDialogFocalDepthStrength;
        public static final /* enum */ FloatSetting fDialogSpeechDelaySeconds;
        public static final /* enum */ FloatSetting fDialogZoomInSeconds;
        public static final /* enum */ FloatSetting fDialogZoomOutSeconds;
        public static final /* enum */ FloatSetting fDialogueHardStopAngle;
        public static final /* enum */ FloatSetting fDialogueSoftStopAngle;
        public static final /* enum */ FloatSetting fDiffMultHPByPCE;
        public static final /* enum */ FloatSetting fDiffMultHPByPCH;
        public static final /* enum */ FloatSetting fDiffMultHPByPCN;
        public static final /* enum */ FloatSetting fDiffMultHPByPCVE;
        public static final /* enum */ FloatSetting fDiffMultHPByPCVH;
        public static final /* enum */ FloatSetting fDiffMultHPToPCE;
        public static final /* enum */ FloatSetting fDiffMultHPToPCH;
        public static final /* enum */ FloatSetting fDiffMultHPToPCN;
        public static final /* enum */ FloatSetting fDiffMultHPToPCVE;
        public static final /* enum */ FloatSetting fDiffMultHPToPCVH;
        public static final /* enum */ FloatSetting fDiffMultXPE;
        public static final /* enum */ FloatSetting fDiffMultXPH;
        public static final /* enum */ FloatSetting fDiffMultXPN;
        public static final /* enum */ FloatSetting fDiffMultXPVE;
        public static final /* enum */ FloatSetting fDiffMultXPVH;
        public static final /* enum */ FloatSetting fDifficultyDamageMultiplier;
        public static final /* enum */ FloatSetting fDifficultyDefaultValue;
        public static final /* enum */ FloatSetting fDifficultyMaxValue;
        public static final /* enum */ FloatSetting fDifficultyMinValue;
        public static final /* enum */ FloatSetting fDisarmedPickupWeaponDistanceMult;
        public static final /* enum */ FloatSetting fDisenchantSkillUse;
        public static final /* enum */ FloatSetting fDistanceAutomaticallyActivateDoor;
        public static final /* enum */ FloatSetting fDistanceExteriorReactCombat;
        public static final /* enum */ FloatSetting fDistanceFadeActorAutoLoadDoor;
        public static final /* enum */ FloatSetting fDistanceInteriorReactCombat;
        public static final /* enum */ FloatSetting fDistanceProjectileExplosionDetection;
        public static final /* enum */ FloatSetting fDistancetoPlayerforConversations;
        public static final /* enum */ FloatSetting fDrinkRepeatRate;
        public static final /* enum */ FloatSetting fDyingTimer;
        public static final /* enum */ FloatSetting fEmbeddedWeaponSwitchChance;
        public static final /* enum */ FloatSetting fEmbeddedWeaponSwitchTime;
        public static final /* enum */ FloatSetting fEnchantingCostExponent;
        public static final /* enum */ FloatSetting fEnchantingRuleOfFive;
        public static final /* enum */ FloatSetting fEnchantingRuleOfTen;
        public static final /* enum */ FloatSetting fEnchantingRuleOfTwo;
        public static final /* enum */ FloatSetting fEnchantingSkillCostBase;
        public static final /* enum */ FloatSetting fEnchantingSkillCostMult;
        public static final /* enum */ FloatSetting fEnchantingSkillCostScale;
        public static final /* enum */ FloatSetting fEnchantingSkillFactor;
        public static final /* enum */ FloatSetting fEnchantmentEffectPointsMult;
        public static final /* enum */ FloatSetting fEnchantmentGoldMult;
        public static final /* enum */ FloatSetting fEnchantmentPointsMult;
        public static final /* enum */ FloatSetting fEnemyHealthBarTimer;
        public static final /* enum */ FloatSetting fEnvMapLOD;
        public static final /* enum */ FloatSetting fEssentialDeathTime;
        public static final /* enum */ FloatSetting fEssentialDownCombatHealthRegenMult;
        public static final /* enum */ FloatSetting fEssentialHealthPercentReGain;
        public static final /* enum */ FloatSetting fEssentialNPCMinimumHealth;
        public static final /* enum */ FloatSetting fEssentialNonCombatHealRateBonus;
        public static final /* enum */ FloatSetting fEvaluatePackageTimer;
        public static final /* enum */ FloatSetting fEvaluateProcedureTimer;
        public static final /* enum */ FloatSetting fExplodeLimbRemovalDelay;
        public static final /* enum */ FloatSetting fExplodeLimbRemovalDelayVATS;
        public static final /* enum */ FloatSetting fExplosionForceClutterUpBias;
        public static final /* enum */ FloatSetting fExplosionForceKnockdownMinimum;
        public static final /* enum */ FloatSetting fExplosionForceMultAngular;
        public static final /* enum */ FloatSetting fExplosionForceMultLinear;
        public static final /* enum */ FloatSetting fExplosionImageSpaceSwapPower;
        public static final /* enum */ FloatSetting fExplosionKnockStateExplodeDownTime;
        public static final /* enum */ FloatSetting fExplosionLOSBuffer;
        public static final /* enum */ FloatSetting fExplosionLOSBufferDistance;
        public static final /* enum */ FloatSetting fExplosionMaxImpulse;
        public static final /* enum */ FloatSetting fExplosionSourceRefMult;
        public static final /* enum */ FloatSetting fExplosionSplashRadius;
        public static final /* enum */ FloatSetting fExplosionWaterRadiusRatio;
        public static final /* enum */ FloatSetting fExplosiveProjectileBlockedResetTime;
        public static final /* enum */ FloatSetting fExplosiveProjectileBlockedWaitTime;
        public static final /* enum */ FloatSetting fExpressionChangePerSec;
        public static final /* enum */ FloatSetting fExpressionStrengthAdd;
        public static final /* enum */ FloatSetting fEyeEnvMapLOD;
        public static final /* enum */ FloatSetting fEyeHeadingMaxOffsetEmotionAngry;
        public static final /* enum */ FloatSetting fEyeHeadingMaxOffsetEmotionFear;
        public static final /* enum */ FloatSetting fEyeHeadingMaxOffsetEmotionHappy;
        public static final /* enum */ FloatSetting fEyeHeadingMaxOffsetEmotionNeutral;
        public static final /* enum */ FloatSetting fEyeHeadingMaxOffsetEmotionSad;
        public static final /* enum */ FloatSetting fEyeHeadingMinOffsetEmotionAngry;
        public static final /* enum */ FloatSetting fEyeHeadingMinOffsetEmotionFear;
        public static final /* enum */ FloatSetting fEyeHeadingMinOffsetEmotionHappy;
        public static final /* enum */ FloatSetting fEyeHeadingMinOffsetEmotionNeutral;
        public static final /* enum */ FloatSetting fEyeHeadingMinOffsetEmotionSad;
        public static final /* enum */ FloatSetting fEyePitchMaxOffsetEmotionAngry;
        public static final /* enum */ FloatSetting fEyePitchMaxOffsetEmotionFear;
        public static final /* enum */ FloatSetting fEyePitchMaxOffsetEmotionHappy;
        public static final /* enum */ FloatSetting fEyePitchMaxOffsetEmotionNeutral;
        public static final /* enum */ FloatSetting fEyePitchMaxOffsetEmotionSad;
        public static final /* enum */ FloatSetting fEyePitchMinOffsetEmotionAngry;
        public static final /* enum */ FloatSetting fEyePitchMinOffsetEmotionFear;
        public static final /* enum */ FloatSetting fEyePitchMinOffsetEmotionHappy;
        public static final /* enum */ FloatSetting fEyePitchMinOffsetEmotionNeutral;
        public static final /* enum */ FloatSetting fEyePitchMinOffsetEmotionSad;
        public static final /* enum */ FloatSetting fFallLegDamageMult;
        public static final /* enum */ FloatSetting fFastTravelSpeedMult;
        public static final /* enum */ FloatSetting fFastWalkInterpolationBetweenWalkAndRun;
        public static final /* enum */ FloatSetting fFavorCostActivator;
        public static final /* enum */ FloatSetting fFavorCostAttack;
        public static final /* enum */ FloatSetting fFavorCostAttackCrimeMult;
        public static final /* enum */ FloatSetting fFavorCostLoadDoor;
        public static final /* enum */ FloatSetting fFavorCostNonLoadDoor;
        public static final /* enum */ FloatSetting fFavorCostOwnedDoorMult;
        public static final /* enum */ FloatSetting fFavorCostStealContainerCrime;
        public static final /* enum */ FloatSetting fFavorCostStealContainerMult;
        public static final /* enum */ FloatSetting fFavorCostStealObjectMult;
        public static final /* enum */ FloatSetting fFavorCostTakeObject;
        public static final /* enum */ FloatSetting fFavorCostUnlockContainer;
        public static final /* enum */ FloatSetting fFavorCostUnlockDoor;
        public static final /* enum */ FloatSetting fFavorEventStopDistance;
        public static final /* enum */ FloatSetting fFavorEventTriggerDistance;
        public static final /* enum */ FloatSetting fFavorRequestPickDistance;
        public static final /* enum */ FloatSetting fFavorRequestRadius;
        public static final /* enum */ FloatSetting fFavorRequestWaitTimer;
        public static final /* enum */ FloatSetting fFirstPersonLookAtVertOffset;
        public static final /* enum */ FloatSetting fFleeDistanceExterior;
        public static final /* enum */ FloatSetting fFleeDistanceInterior;
        public static final /* enum */ FloatSetting fFleeDoneDistanceExterior;
        public static final /* enum */ FloatSetting fFleeDoneDistanceInterior;
        public static final /* enum */ FloatSetting fFleeIsSafeTimer;
        public static final /* enum */ FloatSetting fFloatQuestMarkerFloatHeight;
        public static final /* enum */ FloatSetting fFloatQuestMarkerMaxDistance;
        public static final /* enum */ FloatSetting fFloatQuestMarkerMinDistance;
        public static final /* enum */ FloatSetting fFlyingActorDefaultTurningSpeed;
        public static final /* enum */ FloatSetting fFollowExtraCatchUpSpeedMult;
        public static final /* enum */ FloatSetting fFollowMatchSpeedZoneWidth;
        public static final /* enum */ FloatSetting fFollowRunMaxSpeedupMultiplier;
        public static final /* enum */ FloatSetting fFollowRunMinSlowdownMultiplier;
        public static final /* enum */ FloatSetting fFollowSlowdownZoneWidth;
        public static final /* enum */ FloatSetting fFollowSpaceBetweenFollowers;
        public static final /* enum */ FloatSetting fFollowStartSprintDistance;
        public static final /* enum */ FloatSetting fFollowStopZoneMinMult;
        public static final /* enum */ FloatSetting fFollowWalkMaxSpeedupMultiplier;
        public static final /* enum */ FloatSetting fFollowWalkMinSlowdownMultiplier;
        public static final /* enum */ FloatSetting fFollowWalkZoneMult;
        public static final /* enum */ FloatSetting fFollowerSpacingAtDoors;
        public static final /* enum */ FloatSetting fFriendHitTimer;
        public static final /* enum */ FloatSetting fFriendMinimumLastHitTime;
        public static final /* enum */ FloatSetting fFurnitureMarkerAngleTolerance;
        public static final /* enum */ FloatSetting fFurnitureScaleAnimDurationNPC;
        public static final /* enum */ FloatSetting fFurnitureScaleAnimDurationPlayer;
        public static final /* enum */ FloatSetting fGameplayImpulseMinMass;
        public static final /* enum */ FloatSetting fGameplayImpulseMultBiped;
        public static final /* enum */ FloatSetting fGameplayImpulseMultClutter;
        public static final /* enum */ FloatSetting fGameplayImpulseMultDebrisLarge;
        public static final /* enum */ FloatSetting fGameplayImpulseMultProp;
        public static final /* enum */ FloatSetting fGameplayImpulseMultTrap;
        public static final /* enum */ FloatSetting fGameplayImpulseScale;
        public static final /* enum */ FloatSetting fGameplaySpeakingEmotionMaxChangeValue;
        public static final /* enum */ FloatSetting fGameplaySpeakingEmotionMinChangeValue;
        public static final /* enum */ FloatSetting fGameplayVoiceFilePadding;
        public static final /* enum */ FloatSetting fGameplayiSpeakingEmotionMaxDeltaChange;
        public static final /* enum */ FloatSetting fGameplayiSpeakingEmotionMinDeltaChange;
        public static final /* enum */ FloatSetting fGetHitPainMult;
        public static final /* enum */ FloatSetting fGrabMaxWeightRunning;
        public static final /* enum */ FloatSetting fGrabMaxWeightWalking;
        public static final /* enum */ FloatSetting fGrenadeAgeMax;
        public static final /* enum */ FloatSetting fGrenadeFriction;
        public static final /* enum */ FloatSetting fGrenadeHighArcSpeedPercentage;
        public static final /* enum */ FloatSetting fGrenadeRestitution;
        public static final /* enum */ FloatSetting fGrenadeThrowHitFractionThreshold;
        public static final /* enum */ FloatSetting fGuardPackageAttackRadiusMult;
        public static final /* enum */ FloatSetting fGunDecalCameraDistance;
        public static final /* enum */ FloatSetting fGunParticleCameraDistance;
        public static final /* enum */ FloatSetting fGunReferenceSkill;
        public static final /* enum */ FloatSetting fGunShellCameraDistance;
        public static final /* enum */ FloatSetting fGunShellDirectionRandomize;
        public static final /* enum */ FloatSetting fGunShellEjectSpeed;
        public static final /* enum */ FloatSetting fGunShellLifetime;
        public static final /* enum */ FloatSetting fGunShellRotateRandomize;
        public static final /* enum */ FloatSetting fGunShellRotateSpeed;
        public static final /* enum */ FloatSetting fGunSpreadArmBase;
        public static final /* enum */ FloatSetting fGunSpreadArmMult;
        public static final /* enum */ FloatSetting fGunSpreadCondBase;
        public static final /* enum */ FloatSetting fGunSpreadCondMult;
        public static final /* enum */ FloatSetting fGunSpreadCrouchBase;
        public static final /* enum */ FloatSetting fGunSpreadCrouchMult;
        public static final /* enum */ FloatSetting fGunSpreadDriftBase;
        public static final /* enum */ FloatSetting fGunSpreadDriftMult;
        public static final /* enum */ FloatSetting fGunSpreadHeadBase;
        public static final /* enum */ FloatSetting fGunSpreadHeadMult;
        public static final /* enum */ FloatSetting fGunSpreadIronSightsBase;
        public static final /* enum */ FloatSetting fGunSpreadIronSightsMult;
        public static final /* enum */ FloatSetting fGunSpreadNPCArmBase;
        public static final /* enum */ FloatSetting fGunSpreadNPCArmMult;
        public static final /* enum */ FloatSetting fGunSpreadRunBase;
        public static final /* enum */ FloatSetting fGunSpreadRunMult;
        public static final /* enum */ FloatSetting fGunSpreadSkillBase;
        public static final /* enum */ FloatSetting fGunSpreadSkillMult;
        public static final /* enum */ FloatSetting fGunSpreadWalkBase;
        public static final /* enum */ FloatSetting fGunSpreadWalkMult;
        public static final /* enum */ FloatSetting fHUDCompassLocationMaxDist;
        public static final /* enum */ FloatSetting fHUDOpacity;
        public static final /* enum */ FloatSetting fHandDamageSkillBase;
        public static final /* enum */ FloatSetting fHandDamageSkillMult;
        public static final /* enum */ FloatSetting fHandDamageStrengthBase;
        public static final /* enum */ FloatSetting fHandDamageStrengthMult;
        public static final /* enum */ FloatSetting fHandHealthMax;
        public static final /* enum */ FloatSetting fHandHealthMin;
        public static final /* enum */ FloatSetting fHandReachDefault;
        public static final /* enum */ FloatSetting fHavokTauRatio;
        public static final /* enum */ FloatSetting fHazardDropMaxDistance;
        public static final /* enum */ FloatSetting fHazardMaxWaitTime;
        public static final /* enum */ FloatSetting fHazardSpacingMult;
        public static final /* enum */ FloatSetting fHeadTrackSpeedMax;
        public static final /* enum */ FloatSetting fHeadTrackSpeedMaxAngle;
        public static final /* enum */ FloatSetting fHeadTrackSpeedMin;
        public static final /* enum */ FloatSetting fHeadTrackSpeedMinAngle;
        public static final /* enum */ FloatSetting fHeadingMarkerAngleTolerance;
        public static final /* enum */ FloatSetting fHealthRegenDelayMax;
        public static final /* enum */ FloatSetting fHorseMountOffsetX;
        public static final /* enum */ FloatSetting fHorseMountOffsetY;
        public static final /* enum */ FloatSetting fHostileActorExteriorDistance;
        public static final /* enum */ FloatSetting fHostileActorInteriorDistance;
        public static final /* enum */ FloatSetting fHostileFlyingActorExteriorDistance;
        public static final /* enum */ FloatSetting fIdleChatterCommentTimer;
        public static final /* enum */ FloatSetting fIdleChatterCommentTimerMax;
        public static final /* enum */ FloatSetting fIdleMarkerAngleTolerance;
        public static final /* enum */ FloatSetting fImpactShaderMaxDistance;
        public static final /* enum */ FloatSetting fImpactShaderMaxMagnitude;
        public static final /* enum */ FloatSetting fImpactShaderMinMagnitude;
        public static final /* enum */ FloatSetting fIntimidateConfidenceMultAverage;
        public static final /* enum */ FloatSetting fIntimidateConfidenceMultBrave;
        public static final /* enum */ FloatSetting fIntimidateConfidenceMultCautious;
        public static final /* enum */ FloatSetting fIntimidateConfidenceMultCowardly;
        public static final /* enum */ FloatSetting fIntimidateConfidenceMultFoolhardy;
        public static final /* enum */ FloatSetting fIntimidateSpeechcraftCurve;
        public static final /* enum */ FloatSetting fInventory;
        public static final /* enum */ FloatSetting fInventoryLight;
        public static final /* enum */ FloatSetting fInventoryMenuLight;
        public static final /* enum */ FloatSetting fIronSightsDOFDistance;
        public static final /* enum */ FloatSetting fIronSightsDOFRange;
        public static final /* enum */ FloatSetting fIronSightsDOFStrengthCap;
        public static final /* enum */ FloatSetting fIronSightsDOFSwitchSeconds;
        public static final /* enum */ FloatSetting fIronSightsFOVTimeChange;
        public static final /* enum */ FloatSetting fIronSightsGunMotionBlur;
        public static final /* enum */ FloatSetting fIronSightsMotionBlur;
        public static final /* enum */ FloatSetting fItemPointsMult;
        public static final /* enum */ FloatSetting fItemRepairCostMult;
        public static final /* enum */ FloatSetting fJogInterpolationBetweenWalkAndRun;
        public static final /* enum */ FloatSetting fJumpDoubleMult;
        public static final /* enum */ FloatSetting fJumpFallHeightExponent;
        public static final /* enum */ FloatSetting fJumpFallHeightExponentNPC;
        public static final /* enum */ FloatSetting fJumpFallHeightMin;
        public static final /* enum */ FloatSetting fJumpFallHeightMinNPC;
        public static final /* enum */ FloatSetting fJumpFallHeightMult;
        public static final /* enum */ FloatSetting fJumpFallHeightMultNPC;
        public static final /* enum */ FloatSetting fJumpFallRiderMult;
        public static final /* enum */ FloatSetting fJumpFallSkillBase;
        public static final /* enum */ FloatSetting fJumpFallSkillMult;
        public static final /* enum */ FloatSetting fJumpFallVelocityMin;
        public static final /* enum */ FloatSetting fJumpHeightMin;
        public static final /* enum */ FloatSetting fJumpMoveBase;
        public static final /* enum */ FloatSetting fJumpMoveMult;
        public static final /* enum */ FloatSetting fJumpSwimmingMult;
        public static final /* enum */ FloatSetting fKarmaModKillingEvilActor;
        public static final /* enum */ FloatSetting fKarmaModMurderingNonEvilCreature;
        public static final /* enum */ FloatSetting fKarmaModMurderingNonEvilNPC;
        public static final /* enum */ FloatSetting fKarmaModStealing;
        public static final /* enum */ FloatSetting fKillCamBaseOdds;
        public static final /* enum */ FloatSetting fKillCamLevelBias;
        public static final /* enum */ FloatSetting fKillCamLevelFactor;
        public static final /* enum */ FloatSetting fKillCamLevelMaxBias;
        public static final /* enum */ FloatSetting fKillMoveMaxDuration;
        public static final /* enum */ FloatSetting fKillWitnessesTimerSetting;
        public static final /* enum */ FloatSetting fKnockbackAgilBase;
        public static final /* enum */ FloatSetting fKnockbackAgilMult;
        public static final /* enum */ FloatSetting fKnockbackDamageBase;
        public static final /* enum */ FloatSetting fKnockbackDamageMult;
        public static final /* enum */ FloatSetting fKnockbackForceMax;
        public static final /* enum */ FloatSetting fKnockbackTime;
        public static final /* enum */ FloatSetting fKnockdownAgilBase;
        public static final /* enum */ FloatSetting fKnockdownAgilMult;
        public static final /* enum */ FloatSetting fKnockdownBaseHealthThreshold;
        public static final /* enum */ FloatSetting fKnockdownChance;
        public static final /* enum */ FloatSetting fKnockdownCurrentHealthThreshold;
        public static final /* enum */ FloatSetting fKnockdownDamageBase;
        public static final /* enum */ FloatSetting fKnockdownDamageMult;
        public static final /* enum */ FloatSetting fLargeProjectilePickBufferSize;
        public static final /* enum */ FloatSetting fLargeProjectileSize;
        public static final /* enum */ FloatSetting fLevelUpCarryWeightMod;
        public static final /* enum */ FloatSetting fLightRecalcTimer;
        public static final /* enum */ FloatSetting fLightRecalcTimerPlayer;
        public static final /* enum */ FloatSetting fLoadingWheelScale;
        public static final /* enum */ FloatSetting fLockLevelBase;
        public static final /* enum */ FloatSetting fLockLevelMult;
        public static final /* enum */ FloatSetting fLockPickBreakBase;
        public static final /* enum */ FloatSetting fLockPickBreakMult;
        public static final /* enum */ FloatSetting fLockPickQualityBase;
        public static final /* enum */ FloatSetting fLockPickQualityMult;
        public static final /* enum */ FloatSetting fLockSkillBase;
        public static final /* enum */ FloatSetting fLockSkillMult;
        public static final /* enum */ FloatSetting fLockTrapGoOffBase;
        public static final /* enum */ FloatSetting fLockTrapGoOffMult;
        public static final /* enum */ FloatSetting fLockpickBreakAdept;
        public static final /* enum */ FloatSetting fLockpickBreakApprentice;
        public static final /* enum */ FloatSetting fLockpickBreakExpert;
        public static final /* enum */ FloatSetting fLockpickBreakMaster;
        public static final /* enum */ FloatSetting fLockpickBreakNovice;
        public static final /* enum */ FloatSetting fLockpickBreakSkillBase;
        public static final /* enum */ FloatSetting fLockpickBreakSkillMult;
        public static final /* enum */ FloatSetting fLockpickBrokenPicksMult;
        public static final /* enum */ FloatSetting fLockpickSkillPartialPickBase;
        public static final /* enum */ FloatSetting fLockpickSkillPartialPickMult;
        public static final /* enum */ FloatSetting fLockpickSkillSweetSpotBase;
        public static final /* enum */ FloatSetting fLockpickSkillSweetSpotMult;
        public static final /* enum */ FloatSetting fLookDownDisableBlinkingAmt;
        public static final /* enum */ FloatSetting fLookGraphX;
        public static final /* enum */ FloatSetting fLookGraphY;
        public static final /* enum */ FloatSetting fLowHealthTutorialPercentage;
        public static final /* enum */ FloatSetting fLowLevelNPCBaseHealthMult;
        public static final /* enum */ FloatSetting fLowMagickaTutorialPercentage;
        public static final /* enum */ FloatSetting fLowStaminaTutorialPercentage;
        public static final /* enum */ FloatSetting fMagic;
        public static final /* enum */ FloatSetting fMagicAbsorbDistanceReachMult;
        public static final /* enum */ FloatSetting fMagicAbsorbVisualTimer;
        public static final /* enum */ FloatSetting fMagicAccumulatingModifierEffectHoldDuration;
        public static final /* enum */ FloatSetting fMagicAreaBaseCostMult;
        public static final /* enum */ FloatSetting fMagicAreaScale;
        public static final /* enum */ FloatSetting fMagicAreaScaleMax;
        public static final /* enum */ FloatSetting fMagicAreaScaleMin;
        public static final /* enum */ FloatSetting fMagicBarrierDepth;
        public static final /* enum */ FloatSetting fMagicBarrierHeight;
        public static final /* enum */ FloatSetting fMagicBarrierSpacing;
        public static final /* enum */ FloatSetting fMagicBoltDuration;
        public static final /* enum */ FloatSetting fMagicBoltSegmentLength;
        public static final /* enum */ FloatSetting fMagicCEEnchantMagOffset;
        public static final /* enum */ FloatSetting fMagicCasterPCSkillCostBase;
        public static final /* enum */ FloatSetting fMagicCasterPCSkillCostMult;
        public static final /* enum */ FloatSetting fMagicCasterSkillCostBase;
        public static final /* enum */ FloatSetting fMagicCasterSkillCostMult;
        public static final /* enum */ FloatSetting fMagicChainExplosionEffectivenessDelta;
        public static final /* enum */ FloatSetting fMagicCloudAreaMin;
        public static final /* enum */ FloatSetting fMagicCloudDurationMin;
        public static final /* enum */ FloatSetting fMagicCloudFindTargetTime;
        public static final /* enum */ FloatSetting fMagicCloudLifeScale;
        public static final /* enum */ FloatSetting fMagicCloudSizeScale;
        public static final /* enum */ FloatSetting fMagicCloudSlowdownRate;
        public static final /* enum */ FloatSetting fMagicCloudSpeedBase;
        public static final /* enum */ FloatSetting fMagicCloudSpeedScale;
        public static final /* enum */ FloatSetting fMagicCostScale;
        public static final /* enum */ FloatSetting fMagicDefaultAccumulatingModifierEffectRate;
        public static final /* enum */ FloatSetting fMagicDefaultTouchDistance;
        public static final /* enum */ FloatSetting fMagicDiseaseTransferBase;
        public static final /* enum */ FloatSetting fMagicDiseaseTransferMult;
        public static final /* enum */ FloatSetting fMagicDispelMagnitudeMult;
        public static final /* enum */ FloatSetting fMagicDualCastingCostBase;
        public static final /* enum */ FloatSetting fMagicDualCastingCostMult;
        public static final /* enum */ FloatSetting fMagicDualCastingEffectivenessBase;
        public static final /* enum */ FloatSetting fMagicDualCastingEffectivenessMult;
        public static final /* enum */ FloatSetting fMagicDualCastingTimeBase;
        public static final /* enum */ FloatSetting fMagicDualCastingTimeMult;
        public static final /* enum */ FloatSetting fMagicDurMagBaseCostMult;
        public static final /* enum */ FloatSetting fMagicEnchantmentChargeBase;
        public static final /* enum */ FloatSetting fMagicEnchantmentChargeMult;
        public static final /* enum */ FloatSetting fMagicEnchantmentDrainBase;
        public static final /* enum */ FloatSetting fMagicEnchantmentDrainMult;
        public static final /* enum */ FloatSetting fMagicExplosionAgilityMult;
        public static final /* enum */ FloatSetting fMagicExplosionClutterMult;
        public static final /* enum */ FloatSetting fMagicExplosionIncorporealMult;
        public static final /* enum */ FloatSetting fMagicExplosionIncorporealTime;
        public static final /* enum */ FloatSetting fMagicExplosionPowerBase;
        public static final /* enum */ FloatSetting fMagicExplosionPowerMax;
        public static final /* enum */ FloatSetting fMagicExplosionPowerMin;
        public static final /* enum */ FloatSetting fMagicExplosionPowerMult;
        public static final /* enum */ FloatSetting fMagicGuideSpacing;
        public static final /* enum */ FloatSetting fMagicLightForwardOffset;
        public static final /* enum */ FloatSetting fMagicLightHeightOffset;
        public static final /* enum */ FloatSetting fMagicLightRadiusBase;
        public static final /* enum */ FloatSetting fMagicLightSideOffset;
        public static final /* enum */ FloatSetting fMagicNightEyeAmbient;
        public static final /* enum */ FloatSetting fMagicPCSkillCostScale;
        public static final /* enum */ FloatSetting fMagicPlayerMinimumInvisibility;
        public static final /* enum */ FloatSetting fMagicPostDrawCastDelay;
        public static final /* enum */ FloatSetting fMagicProjectileMaxDistance;
        public static final /* enum */ FloatSetting fMagicRangeTargetCostMult;
        public static final /* enum */ FloatSetting fMagicResistActorSkillBase;
        public static final /* enum */ FloatSetting fMagicResistActorSkillMult;
        public static final /* enum */ FloatSetting fMagicResistTargetWillpowerBase;
        public static final /* enum */ FloatSetting fMagicResistTargetWillpowerMult;
        public static final /* enum */ FloatSetting fMagicSkillCostScale;
        public static final /* enum */ FloatSetting fMagicSummonMaxAppearTime;
        public static final /* enum */ FloatSetting fMagicTelekinesiDistanceMult;
        public static final /* enum */ FloatSetting fMagicTelekinesisBaseDistance;
        public static final /* enum */ FloatSetting fMagicTelekinesisComplexMaxForce;
        public static final /* enum */ FloatSetting fMagicTelekinesisComplexObjectDamping;
        public static final /* enum */ FloatSetting fMagicTelekinesisComplexSpringDamping;
        public static final /* enum */ FloatSetting fMagicTelekinesisComplexSpringElasticity;
        public static final /* enum */ FloatSetting fMagicTelekinesisDamageBase;
        public static final /* enum */ FloatSetting fMagicTelekinesisDamageMult;
        public static final /* enum */ FloatSetting fMagicTelekinesisDistanceMin;
        public static final /* enum */ FloatSetting fMagicTelekinesisDualCastDamageMult;
        public static final /* enum */ FloatSetting fMagicTelekinesisDualCastThrowMult;
        public static final /* enum */ FloatSetting fMagicTelekinesisLiftPowerMult;
        public static final /* enum */ FloatSetting fMagicTelekinesisMaxForce;
        public static final /* enum */ FloatSetting fMagicTelekinesisMoveAccelerate;
        public static final /* enum */ FloatSetting fMagicTelekinesisMoveBase;
        public static final /* enum */ FloatSetting fMagicTelekinesisMoveMax;
        public static final /* enum */ FloatSetting fMagicTelekinesisObjectDamping;
        public static final /* enum */ FloatSetting fMagicTelekinesisSpringDamping;
        public static final /* enum */ FloatSetting fMagicTelekinesisSpringElasticity;
        public static final /* enum */ FloatSetting fMagicTelekinesisThrow;
        public static final /* enum */ FloatSetting fMagicTelekinesisThrowAccelerate;
        public static final /* enum */ FloatSetting fMagicTelekinesisThrowMax;
        public static final /* enum */ FloatSetting fMagicTrackingLimit;
        public static final /* enum */ FloatSetting fMagicTrackingLimitComplex;
        public static final /* enum */ FloatSetting fMagicTrackingMultBall;
        public static final /* enum */ FloatSetting fMagicTrackingMultBolt;
        public static final /* enum */ FloatSetting fMagicTrackingMultFog;
        public static final /* enum */ FloatSetting fMagicUnitsPerFoot;
        public static final /* enum */ FloatSetting fMagicVACNoPartTargetedMult;
        public static final /* enum */ FloatSetting fMagicVACPartTargetedMult;
        public static final /* enum */ FloatSetting fMagicWardPowerMaxBase;
        public static final /* enum */ FloatSetting fMagicWardPowerMaxMult;
        public static final /* enum */ FloatSetting fMagickaRegenDelayMax;
        public static final /* enum */ FloatSetting fMagickaReturnBase;
        public static final /* enum */ FloatSetting fMagickaReturnMult;
        public static final /* enum */ FloatSetting fMapMarkerMaxPercentSize;
        public static final /* enum */ FloatSetting fMapMarkerMinFadeAlpha;
        public static final /* enum */ FloatSetting fMapMarkerMinPercentSize;
        public static final /* enum */ FloatSetting fMapQuestMarkerMaxPercentSize;
        public static final /* enum */ FloatSetting fMapQuestMarkerMinFadeAlpha;
        public static final /* enum */ FloatSetting fMapQuestMarkerMinPercentSize;
        public static final /* enum */ FloatSetting fMasserAngleFadeEnd;
        public static final /* enum */ FloatSetting fMasserAngleFadeStart;
        public static final /* enum */ FloatSetting fMasserAngleShadowEarlyFade;
        public static final /* enum */ FloatSetting fMasserSpeed;
        public static final /* enum */ FloatSetting fMasserZOffset;
        public static final /* enum */ FloatSetting fMaxArmorRating;
        public static final /* enum */ FloatSetting fMaxSandboxRescanSeconds;
        public static final /* enum */ FloatSetting fMaxSellMult;
        public static final /* enum */ FloatSetting fMaximumWind;
        public static final /* enum */ FloatSetting fMeleeMovementRestrictionsUpdateTime;
        public static final /* enum */ FloatSetting fMeleeSweepViewAngleMult;
        public static final /* enum */ FloatSetting fMeshLODLevel;
        public static final /* enum */ FloatSetting fMinBuyMult;
        public static final /* enum */ FloatSetting fMinDistanceUseHorse;
        public static final /* enum */ FloatSetting fMinSandboxRescanSeconds;
        public static final /* enum */ FloatSetting fMineAgeMax;
        public static final /* enum */ FloatSetting fMineExteriorRadiusMult;
        public static final /* enum */ FloatSetting fMinesBlinkFast;
        public static final /* enum */ FloatSetting fMinesBlinkMax;
        public static final /* enum */ FloatSetting fMinesBlinkSlow;
        public static final /* enum */ FloatSetting fMinesDelayMin;
        public static final /* enum */ FloatSetting fModelReferenceEffectMaxWaitTime;
        public static final /* enum */ FloatSetting fMostCommonProjectileCollisionRadius;
        public static final /* enum */ FloatSetting fMotionBlur;
        public static final /* enum */ FloatSetting fMountedMaxLookingDown;
        public static final /* enum */ FloatSetting fMoveCharRunBase;
        public static final /* enum */ FloatSetting fMoveCharWalkBase;
        public static final /* enum */ FloatSetting fMoveEncumEffect;
        public static final /* enum */ FloatSetting fMoveEncumEffectNoWeapon;
        public static final /* enum */ FloatSetting fMoveFlyRunMult;
        public static final /* enum */ FloatSetting fMoveFlyWalkMult;
        public static final /* enum */ FloatSetting fMoveGraphX;
        public static final /* enum */ FloatSetting fMoveGraphY;
        public static final /* enum */ FloatSetting fMoveSprintMult;
        public static final /* enum */ FloatSetting fMoveSwimMult;
        public static final /* enum */ FloatSetting fMoveWeightMax;
        public static final /* enum */ FloatSetting fMoveWeightMin;
        public static final /* enum */ FloatSetting fMovementNearTargetAvoidCost;
        public static final /* enum */ FloatSetting fMovementNearTargetAvoidRadius;
        public static final /* enum */ FloatSetting fMovementTargetAvoidCost;
        public static final /* enum */ FloatSetting fMovementTargetAvoidRadius;
        public static final /* enum */ FloatSetting fMovementTargetAvoidRadiusMult;
        public static final /* enum */ FloatSetting fNPCAttributeHealthMult;
        public static final /* enum */ FloatSetting fNPCBaseMagickaMult;
        public static final /* enum */ FloatSetting fNPCHealthLevelBonus;
        public static final /* enum */ FloatSetting fNear;
        public static final /* enum */ FloatSetting fObjectHitH;
        public static final /* enum */ FloatSetting fObjectHitTwoHandReach;
        public static final /* enum */ FloatSetting fObjectHitWeaponReach;
        public static final /* enum */ FloatSetting fObjectMotionBlur;
        public static final /* enum */ FloatSetting fObjectWeightPickupDetectionMult;
        public static final /* enum */ FloatSetting fOutOfBreathStaminaRegenDelay;
        public static final /* enum */ FloatSetting fPCBaseHealthMult;
        public static final /* enum */ FloatSetting fPCBaseMagickaMult;
        public static final /* enum */ FloatSetting fPCHealthLevelBonus;
        public static final /* enum */ FloatSetting fPainDelay;
        public static final /* enum */ FloatSetting fPartialPickAverage;
        public static final /* enum */ FloatSetting fPartialPickEasy;
        public static final /* enum */ FloatSetting fPartialPickHard;
        public static final /* enum */ FloatSetting fPartialPickVeryEasy;
        public static final /* enum */ FloatSetting fPartialPickVeryHard;
        public static final /* enum */ FloatSetting fPerceptionMult;
        public static final /* enum */ FloatSetting fPerkHeavyArmorExpertSpeedMult;
        public static final /* enum */ FloatSetting fPerkHeavyArmorJourneymanDamageMult;
        public static final /* enum */ FloatSetting fPerkHeavyArmorMasterSpeedMult;
        public static final /* enum */ FloatSetting fPerkHeavyArmorNoviceDamageMult;
        public static final /* enum */ FloatSetting fPerkHeavyArmorSinkGravityMult;
        public static final /* enum */ FloatSetting fPerkLightArmorExpertSpeedMult;
        public static final /* enum */ FloatSetting fPerkLightArmorJourneymanDamageMult;
        public static final /* enum */ FloatSetting fPerkLightArmorMasterRatingMult;
        public static final /* enum */ FloatSetting fPerkLightArmorNoviceDamageMult;
        public static final /* enum */ FloatSetting fPersAdmireAggr;
        public static final /* enum */ FloatSetting fPersAdmireConf;
        public static final /* enum */ FloatSetting fPersAdmireEner;
        public static final /* enum */ FloatSetting fPersAdmireIntel;
        public static final /* enum */ FloatSetting fPersAdmirePers;
        public static final /* enum */ FloatSetting fPersAdmireResp;
        public static final /* enum */ FloatSetting fPersAdmireStre;
        public static final /* enum */ FloatSetting fPersAdmireWillp;
        public static final /* enum */ FloatSetting fPersBoastAggr;
        public static final /* enum */ FloatSetting fPersBoastConf;
        public static final /* enum */ FloatSetting fPersBoastEner;
        public static final /* enum */ FloatSetting fPersBoastIntel;
        public static final /* enum */ FloatSetting fPersBoastPers;
        public static final /* enum */ FloatSetting fPersBoastResp;
        public static final /* enum */ FloatSetting fPersBoastStre;
        public static final /* enum */ FloatSetting fPersBoastWillp;
        public static final /* enum */ FloatSetting fPersBullyAggr;
        public static final /* enum */ FloatSetting fPersBullyConf;
        public static final /* enum */ FloatSetting fPersBullyEner;
        public static final /* enum */ FloatSetting fPersBullyIntel;
        public static final /* enum */ FloatSetting fPersBullyPers;
        public static final /* enum */ FloatSetting fPersBullyResp;
        public static final /* enum */ FloatSetting fPersBullyStre;
        public static final /* enum */ FloatSetting fPersBullyWillp;
        public static final /* enum */ FloatSetting fPersJokeAggr;
        public static final /* enum */ FloatSetting fPersJokeConf;
        public static final /* enum */ FloatSetting fPersJokeEner;
        public static final /* enum */ FloatSetting fPersJokeIntel;
        public static final /* enum */ FloatSetting fPersJokePers;
        public static final /* enum */ FloatSetting fPersJokeResp;
        public static final /* enum */ FloatSetting fPersJokeStre;
        public static final /* enum */ FloatSetting fPersJokeWillp;
        public static final /* enum */ FloatSetting fPersuasionAccuracyMaxDisposition;
        public static final /* enum */ FloatSetting fPersuasionAccuracyMaxSelect;
        public static final /* enum */ FloatSetting fPersuasionAccuracyMinDispostion;
        public static final /* enum */ FloatSetting fPersuasionAccuracyMinSelect;
        public static final /* enum */ FloatSetting fPersuasionBaseValueMaxDisposition;
        public static final /* enum */ FloatSetting fPersuasionBaseValueMaxSelect;
        public static final /* enum */ FloatSetting fPersuasionBaseValueMinDispostion;
        public static final /* enum */ FloatSetting fPersuasionBaseValueMinSelect;
        public static final /* enum */ FloatSetting fPersuasionBaseValueShape;
        public static final /* enum */ FloatSetting fPersuasionMaxDisposition;
        public static final /* enum */ FloatSetting fPersuasionMaxInput;
        public static final /* enum */ FloatSetting fPersuasionMaxSelect;
        public static final /* enum */ FloatSetting fPersuasionMinDispostion;
        public static final /* enum */ FloatSetting fPersuasionMinInput;
        public static final /* enum */ FloatSetting fPersuasionMinPercentCircle;
        public static final /* enum */ FloatSetting fPersuasionMinSelect;
        public static final /* enum */ FloatSetting fPersuasionShape;
        public static final /* enum */ FloatSetting fPhysicsDamage;
        public static final /* enum */ FloatSetting fPhysicsDamageSpeedBase;
        public static final /* enum */ FloatSetting fPhysicsDamageSpeedMin;
        public static final /* enum */ FloatSetting fPhysicsDamageSpeedMult;
        public static final /* enum */ FloatSetting fPickLevelBase;
        public static final /* enum */ FloatSetting fPickLevelMult;
        public static final /* enum */ FloatSetting fPickMaxAngle;
        public static final /* enum */ FloatSetting fPickNumBase;
        public static final /* enum */ FloatSetting fPickNumMult;
        public static final /* enum */ FloatSetting fPickPocketActorSkillBase;
        public static final /* enum */ FloatSetting fPickPocketActorSkillMult;
        public static final /* enum */ FloatSetting fPickPocketAmountBase;
        public static final /* enum */ FloatSetting fPickPocketAmountMult;
        public static final /* enum */ FloatSetting fPickPocketDetected;
        public static final /* enum */ FloatSetting fPickPocketMaxChance;
        public static final /* enum */ FloatSetting fPickPocketMinChance;
        public static final /* enum */ FloatSetting fPickPocketTargetSkillBase;
        public static final /* enum */ FloatSetting fPickPocketTargetSkillMult;
        public static final /* enum */ FloatSetting fPickPocketWeightBase;
        public static final /* enum */ FloatSetting fPickPocketWeightMult;
        public static final /* enum */ FloatSetting fPickSpring;
        public static final /* enum */ FloatSetting fPickUpWeaponDelay;
        public static final /* enum */ FloatSetting fPickpocketSkillUsesCurve;
        public static final /* enum */ FloatSetting fPickupItemDistanceFudge;
        public static final /* enum */ FloatSetting fPickupWeaponDistanceMinMaxDPSMult;
        public static final /* enum */ FloatSetting fPickupWeaponMeleeDistanceMax;
        public static final /* enum */ FloatSetting fPickupWeaponMeleeDistanceMin;
        public static final /* enum */ FloatSetting fPickupWeaponMeleeWeaponDPSMult;
        public static final /* enum */ FloatSetting fPickupWeaponMinDPSImprovementPercent;
        public static final /* enum */ FloatSetting fPickupWeaponRangedDistanceMax;
        public static final /* enum */ FloatSetting fPickupWeaponRangedDistanceMin;
        public static final /* enum */ FloatSetting fPickupWeaponRangedMeleeDPSRatioThreshold;
        public static final /* enum */ FloatSetting fPickupWeaponTargetUnreachableDistanceMult;
        public static final /* enum */ FloatSetting fPickupWeaponUnarmedDistanceMax;
        public static final /* enum */ FloatSetting fPickupWeaponUnarmedDistanceMin;
        public static final /* enum */ FloatSetting fPlayerDeathReloadTime;
        public static final /* enum */ FloatSetting fPlayerDetectActorValue;
        public static final /* enum */ FloatSetting fPlayerDetectionSneakBase;
        public static final /* enum */ FloatSetting fPlayerDetectionSneakMult;
        public static final /* enum */ FloatSetting fPlayerDropDistance;
        public static final /* enum */ FloatSetting fPlayerHealthHeartbeatFast;
        public static final /* enum */ FloatSetting fPlayerHealthHeartbeatSlow;
        public static final /* enum */ FloatSetting fPlayerMaxResistance;
        public static final /* enum */ FloatSetting fPlayerTargetCombatDistance;
        public static final /* enum */ FloatSetting fPlayerTeleportFadeSeconds;
        public static final /* enum */ FloatSetting fPlayerVelocityCacheTime;
        public static final /* enum */ FloatSetting fPlayerVelocitySampleInterval;
        public static final /* enum */ FloatSetting fPlayerVelocitySampleTime;
        public static final /* enum */ FloatSetting fPotionGoldValueMult;
        public static final /* enum */ FloatSetting fPotionMortPestleMult;
        public static final /* enum */ FloatSetting fPotionT;
        public static final /* enum */ FloatSetting fPowerAttackCoolDownTime;
        public static final /* enum */ FloatSetting fPowerAttackDefaultBonus;
        public static final /* enum */ FloatSetting fPowerAttackStaminaPenalty;
        public static final /* enum */ FloatSetting fProjectileCollisionImpulseScale;
        public static final /* enum */ FloatSetting fProjectileDefaultTracerRange;
        public static final /* enum */ FloatSetting fProjectileDeflectionTime;
        public static final /* enum */ FloatSetting fProjectileInventoryGrenadeFreakoutTime;
        public static final /* enum */ FloatSetting fProjectileInventoryGrenadeTimer;
        public static final /* enum */ FloatSetting fProjectileKnockMinMass;
        public static final /* enum */ FloatSetting fProjectileKnockMultBiped;
        public static final /* enum */ FloatSetting fProjectileKnockMultClutter;
        public static final /* enum */ FloatSetting fProjectileKnockMultProp;
        public static final /* enum */ FloatSetting fProjectileKnockMultTrap;
        public static final /* enum */ FloatSetting fProjectileMaxDistance;
        public static final /* enum */ FloatSetting fProjectileReorientTracerMin;
        public static final /* enum */ FloatSetting fQuestCinematicCharacterFadeIn;
        public static final /* enum */ FloatSetting fQuestCinematicCharacterFadeInDelay;
        public static final /* enum */ FloatSetting fQuestCinematicCharacterFadeOut;
        public static final /* enum */ FloatSetting fQuestCinematicCharacterRemain;
        public static final /* enum */ FloatSetting fQuestCinematicObjectiveFadeIn;
        public static final /* enum */ FloatSetting fQuestCinematicObjectiveFadeInDelay;
        public static final /* enum */ FloatSetting fQuestCinematicObjectiveFadeOut;
        public static final /* enum */ FloatSetting fQuestCinematicObjectivePauseTime;
        public static final /* enum */ FloatSetting fQuestCinematicObjectiveScrollTime;
        public static final /* enum */ FloatSetting fRandomSceneAgainMaxTime;
        public static final /* enum */ FloatSetting fRandomSceneAgainMinTime;
        public static final /* enum */ FloatSetting fReEquipArmorTime;
        public static final /* enum */ FloatSetting fRechargeGoldMult;
        public static final /* enum */ FloatSetting fReflectedAbsorbChanceReduction;
        public static final /* enum */ FloatSetting fRelationshipBase;
        public static final /* enum */ FloatSetting fRelationshipMult;
        public static final /* enum */ FloatSetting fRemoteCombatMissedAttack;
        public static final /* enum */ FloatSetting fRemoveExcessComplexDeadTime;
        public static final /* enum */ FloatSetting fRemoveExcessDeadTime;
        public static final /* enum */ FloatSetting fRepairMax;
        public static final /* enum */ FloatSetting fRepairMin;
        public static final /* enum */ FloatSetting fRepairScavengeMult;
        public static final /* enum */ FloatSetting fRepairSkillBase;
        public static final /* enum */ FloatSetting fRepairSkillMax;
        public static final /* enum */ FloatSetting fReservationExpirationSeconds;
        public static final /* enum */ FloatSetting fResistArrestTimer;
        public static final /* enum */ FloatSetting fRockitDamageBonusWeightMin;
        public static final /* enum */ FloatSetting fRockitDamageBonusWeightMult;
        public static final /* enum */ FloatSetting fRoomLightingTransitionDuration;
        public static final /* enum */ FloatSetting fRumbleBlockStrength;
        public static final /* enum */ FloatSetting fRumbleBlockTime;
        public static final /* enum */ FloatSetting fRumbleHitBlockedStrength;
        public static final /* enum */ FloatSetting fRumbleHitBlockedTime;
        public static final /* enum */ FloatSetting fRumbleHitStrength;
        public static final /* enum */ FloatSetting fRumbleHitTime;
        public static final /* enum */ FloatSetting fRumblePainStrength;
        public static final /* enum */ FloatSetting fRumblePainTime;
        public static final /* enum */ FloatSetting fRumbleShakeRadiusMult;
        public static final /* enum */ FloatSetting fRumbleShakeTimeMult;
        public static final /* enum */ FloatSetting fRumbleStruckStrength;
        public static final /* enum */ FloatSetting fRumbleStruckTime;
        public static final /* enum */ FloatSetting fSandBoxDelayEvalSeconds;
        public static final /* enum */ FloatSetting fSandBoxExtraDialogueRange;
        public static final /* enum */ FloatSetting fSandBoxInterMarkerMinDist;
        public static final /* enum */ FloatSetting fSandBoxRadiusHysteresis;
        public static final /* enum */ FloatSetting fSandBoxSearchRadius;
        public static final /* enum */ FloatSetting fSandboxBreakfastMax;
        public static final /* enum */ FloatSetting fSandboxBreakfastMin;
        public static final /* enum */ FloatSetting fSandboxCylinderBottom;
        public static final /* enum */ FloatSetting fSandboxCylinderTop;
        public static final /* enum */ FloatSetting fSandboxDinnerMax;
        public static final /* enum */ FloatSetting fSandboxDinnerMin;
        public static final /* enum */ FloatSetting fSandboxDurationBase;
        public static final /* enum */ FloatSetting fSandboxDurationMultEatSitting;
        public static final /* enum */ FloatSetting fSandboxDurationMultEatStanding;
        public static final /* enum */ FloatSetting fSandboxDurationMultFurniture;
        public static final /* enum */ FloatSetting fSandboxDurationMultIdleMarker;
        public static final /* enum */ FloatSetting fSandboxDurationMultSitting;
        public static final /* enum */ FloatSetting fSandboxDurationMultSleeping;
        public static final /* enum */ FloatSetting fSandboxDurationMultWandering;
        public static final /* enum */ FloatSetting fSandboxDurationRangeMult;
        public static final /* enum */ FloatSetting fSandboxEnergyMult;
        public static final /* enum */ FloatSetting fSandboxEnergyMultEatSitting;
        public static final /* enum */ FloatSetting fSandboxEnergyMultEatStanding;
        public static final /* enum */ FloatSetting fSandboxEnergyMultFurniture;
        public static final /* enum */ FloatSetting fSandboxEnergyMultIdleMarker;
        public static final /* enum */ FloatSetting fSandboxEnergyMultSitting;
        public static final /* enum */ FloatSetting fSandboxEnergyMultSleeping;
        public static final /* enum */ FloatSetting fSandboxEnergyMultWandering;
        public static final /* enum */ FloatSetting fSandboxLunchMax;
        public static final /* enum */ FloatSetting fSandboxLunchMin;
        public static final /* enum */ FloatSetting fSandboxMealDurationMax;
        public static final /* enum */ FloatSetting fSandboxMealDurationMin;
        public static final /* enum */ FloatSetting fSandboxSleepDurationMax;
        public static final /* enum */ FloatSetting fSandboxSleepDurationMin;
        public static final /* enum */ FloatSetting fSandboxSleepStartMax;
        public static final /* enum */ FloatSetting fSandboxSleepStartMin;
        public static final /* enum */ FloatSetting fSayOncePerDayInfoTimer;
        public static final /* enum */ FloatSetting fScrollCostMult;
        public static final /* enum */ FloatSetting fSecondsBetweenWindowUpdate;
        public static final /* enum */ FloatSetting fSecundaAngleFadeEnd;
        public static final /* enum */ FloatSetting fSecundaAngleFadeStart;
        public static final /* enum */ FloatSetting fSecundaAngleShadowEarlyFade;
        public static final /* enum */ FloatSetting fSecundaSpeed;
        public static final /* enum */ FloatSetting fSecundaZOffset;
        public static final /* enum */ FloatSetting fShieldBaseFactor;
        public static final /* enum */ FloatSetting fShieldBashMax;
        public static final /* enum */ FloatSetting fShieldBashMin;
        public static final /* enum */ FloatSetting fShieldBashPCMax;
        public static final /* enum */ FloatSetting fShieldBashPCMin;
        public static final /* enum */ FloatSetting fShieldBashSkillUseBase;
        public static final /* enum */ FloatSetting fShieldBashSkillUseMult;
        public static final /* enum */ FloatSetting fShieldScalingFactor;
        public static final /* enum */ FloatSetting fShockBoltGrowWidth;
        public static final /* enum */ FloatSetting fShockBoltSmallWidth;
        public static final /* enum */ FloatSetting fShockBoltsLength;
        public static final /* enum */ FloatSetting fShockBoltsRadius;
        public static final /* enum */ FloatSetting fShockBoltsRadiusStrength;
        public static final /* enum */ FloatSetting fShockBranchBoltsRadius;
        public static final /* enum */ FloatSetting fShockBranchBoltsRadiusStrength;
        public static final /* enum */ FloatSetting fShockBranchLifetime;
        public static final /* enum */ FloatSetting fShockBranchSegmentLength;
        public static final /* enum */ FloatSetting fShockBranchSegmentVariance;
        public static final /* enum */ FloatSetting fShockCastVOffset;
        public static final /* enum */ FloatSetting fShockCoreColorB;
        public static final /* enum */ FloatSetting fShockCoreColorG;
        public static final /* enum */ FloatSetting fShockCoreColorR;
        public static final /* enum */ FloatSetting fShockGlowColorB;
        public static final /* enum */ FloatSetting fShockGlowColorG;
        public static final /* enum */ FloatSetting fShockGlowColorR;
        public static final /* enum */ FloatSetting fShockSegmentLength;
        public static final /* enum */ FloatSetting fShockSegmentVariance;
        public static final /* enum */ FloatSetting fShockSubSegmentVariance;
        public static final /* enum */ FloatSetting fShoutTime;
        public static final /* enum */ FloatSetting fShoutTimeout;
        public static final /* enum */ FloatSetting fSittingMaxLookingDown;
        public static final /* enum */ FloatSetting fSkillUsageLockPickAverage;
        public static final /* enum */ FloatSetting fSkillUsageLockPickBroken;
        public static final /* enum */ FloatSetting fSkillUsageLockPickEasy;
        public static final /* enum */ FloatSetting fSkillUsageLockPickHard;
        public static final /* enum */ FloatSetting fSkillUsageLockPickVeryEasy;
        public static final /* enum */ FloatSetting fSkillUsageLockPickVeryHard;
        public static final /* enum */ FloatSetting fSkillUsageRechargeMult;
        public static final /* enum */ FloatSetting fSkillUsageSneakHidden;
        public static final /* enum */ FloatSetting fSkillUsageSneakPerSecond;
        public static final /* enum */ FloatSetting fSkillUseCurve;
        public static final /* enum */ FloatSetting fSkinnedDecalLOD;
        public static final /* enum */ FloatSetting fSkyCellRefFadeDistance;
        public static final /* enum */ FloatSetting fSmallBumpSpeed;
        public static final /* enum */ FloatSetting fSmithingArmorMax;
        public static final /* enum */ FloatSetting fSmithingConditionFactor;
        public static final /* enum */ FloatSetting fSmithingWeaponMax;
        public static final /* enum */ FloatSetting fSneakActionMult;
        public static final /* enum */ FloatSetting fSneakAlertMod;
        public static final /* enum */ FloatSetting fSneakAmbushNonTargetMod;
        public static final /* enum */ FloatSetting fSneakAmbushTargetMod;
        public static final /* enum */ FloatSetting fSneakAttackSkillUsageMelee;
        public static final /* enum */ FloatSetting fSneakAttackSkillUsageRanged;
        public static final /* enum */ FloatSetting fSneakBaseValue;
        public static final /* enum */ FloatSetting fSneakCombatMod;
        public static final /* enum */ FloatSetting fSneakDetectionSizeLarge;
        public static final /* enum */ FloatSetting fSneakDetectionSizeNormal;
        public static final /* enum */ FloatSetting fSneakDetectionSizeSmall;
        public static final /* enum */ FloatSetting fSneakDetectionSizeVeryLarge;
        public static final /* enum */ FloatSetting fSneakDistanceAttenuationExponent;
        public static final /* enum */ FloatSetting fSneakEquippedWeightBase;
        public static final /* enum */ FloatSetting fSneakEquippedWeightMult;
        public static final /* enum */ FloatSetting fSneakExteriorDistanceMult;
        public static final /* enum */ FloatSetting fSneakFlyingDistanceMult;
        public static final /* enum */ FloatSetting fSneakLightExteriorMult;
        public static final /* enum */ FloatSetting fSneakLightMoveMult;
        public static final /* enum */ FloatSetting fSneakLightMult;
        public static final /* enum */ FloatSetting fSneakLightRunMult;
        public static final /* enum */ FloatSetting fSneakMaxDistance;
        public static final /* enum */ FloatSetting fSneakNoticeMin;
        public static final /* enum */ FloatSetting fSneakPerceptionSkillMax;
        public static final /* enum */ FloatSetting fSneakPerceptionSkillMin;
        public static final /* enum */ FloatSetting fSneakRunningMult;
        public static final /* enum */ FloatSetting fSneakSizeBase;
        public static final /* enum */ FloatSetting fSneakSkillMult;
        public static final /* enum */ FloatSetting fSneakSleepBonus;
        public static final /* enum */ FloatSetting fSneakSleepMod;
        public static final /* enum */ FloatSetting fSneakSoundLosMult;
        public static final /* enum */ FloatSetting fSneakSoundsMult;
        public static final /* enum */ FloatSetting fSneakStealthBoyMult;
        public static final /* enum */ FloatSetting fSortActorDistanceListTimer;
        public static final /* enum */ FloatSetting fSpeechCraftBase;
        public static final /* enum */ FloatSetting fSpeechCraftMult;
        public static final /* enum */ FloatSetting fSpeechDelay;
        public static final /* enum */ FloatSetting fSpeechcraftFavorMax;
        public static final /* enum */ FloatSetting fSpeechcraftFavorMin;
        public static final /* enum */ FloatSetting fSpellCastingDetectionHitActorMod;
        public static final /* enum */ FloatSetting fSpellCastingDetectionMod;
        public static final /* enum */ FloatSetting fSpellmakingGoldMult;
        public static final /* enum */ FloatSetting fSplashScale;
        public static final /* enum */ FloatSetting fSplashSoundHeavy;
        public static final /* enum */ FloatSetting fSplashSoundLight;
        public static final /* enum */ FloatSetting fSplashSoundMedium;
        public static final /* enum */ FloatSetting fSplashSoundOutMult;
        public static final /* enum */ FloatSetting fSplashSoundTimer;
        public static final /* enum */ FloatSetting fSplashSoundVelocityMult;
        public static final /* enum */ FloatSetting fSprintEncumbranceMult;
        public static final /* enum */ FloatSetting fSprintStaminaDrainMult;
        public static final /* enum */ FloatSetting fSprintStaminaWeightBase;
        public static final /* enum */ FloatSetting fSprintStaminaWeightMult;
        public static final /* enum */ FloatSetting fStagger;
        public static final /* enum */ FloatSetting fStaggerAttackBase;
        public static final /* enum */ FloatSetting fStaggerAttackMult;
        public static final /* enum */ FloatSetting fStaggerBlockAttackBase;
        public static final /* enum */ FloatSetting fStaggerBlockAttackMult;
        public static final /* enum */ FloatSetting fStaggerBlockAttackShieldBase;
        public static final /* enum */ FloatSetting fStaggerBlockAttackShieldMult;
        public static final /* enum */ FloatSetting fStaggerBlockBase;
        public static final /* enum */ FloatSetting fStaggerBlockMult;
        public static final /* enum */ FloatSetting fStaggerBlockingMult;
        public static final /* enum */ FloatSetting fStaggerMassBase;
        public static final /* enum */ FloatSetting fStaggerMassMult;
        public static final /* enum */ FloatSetting fStaggerMassOffsetBase;
        public static final /* enum */ FloatSetting fStaggerMassOffsetMult;
        public static final /* enum */ FloatSetting fStaggerMaxDuration;
        public static final /* enum */ FloatSetting fStaggerMin;
        public static final /* enum */ FloatSetting fStaggerPlayerMassMult;
        public static final /* enum */ FloatSetting fStaggerRecoilingMult;
        public static final /* enum */ FloatSetting fStaggerRunningMult;
        public static final /* enum */ FloatSetting fStaggerShieldMult;
        public static final /* enum */ FloatSetting fStaminaAttackWeaponBase;
        public static final /* enum */ FloatSetting fStaminaAttackWeaponMult;
        public static final /* enum */ FloatSetting fStaminaBashBase;
        public static final /* enum */ FloatSetting fStaminaBlockBase;
        public static final /* enum */ FloatSetting fStaminaBlockDmgMult;
        public static final /* enum */ FloatSetting fStaminaBlockStaggerMult;
        public static final /* enum */ FloatSetting fStaminaPowerBashBase;
        public static final /* enum */ FloatSetting fStaminaRegenDelayMax;
        public static final /* enum */ FloatSetting fStarsRotateDays;
        public static final /* enum */ FloatSetting fStarsRotateXAxis;
        public static final /* enum */ FloatSetting fStarsRotateYAxis;
        public static final /* enum */ FloatSetting fStatsCameraFOV;
        public static final /* enum */ FloatSetting fStatsCameraNearDistance;
        public static final /* enum */ FloatSetting fStatsHealthLevelMult;
        public static final /* enum */ FloatSetting fStatsHealthStartMult;
        public static final /* enum */ FloatSetting fStatsLineScale;
        public static final /* enum */ FloatSetting fStatsRotationRampTime;
        public static final /* enum */ FloatSetting fStatsRotationSpeedMax;
        public static final /* enum */ FloatSetting fStatsSkillsLookAtX;
        public static final /* enum */ FloatSetting fStatsSkillsLookAtY;
        public static final /* enum */ FloatSetting fStatsSkillsLookAtZ;
        public static final /* enum */ FloatSetting fStatsStarCameraOffsetX;
        public static final /* enum */ FloatSetting fStatsStarCameraOffsetY;
        public static final /* enum */ FloatSetting fStatsStarCameraOffsetZ;
        public static final /* enum */ FloatSetting fStatsStarLookAtX;
        public static final /* enum */ FloatSetting fStatsStarLookAtY;
        public static final /* enum */ FloatSetting fStatsStarLookAtZ;
        public static final /* enum */ FloatSetting fStatsStarScale;
        public static final /* enum */ FloatSetting fStatsStarXIncrement;
        public static final /* enum */ FloatSetting fStatsStarYIncrement;
        public static final /* enum */ FloatSetting fStatsStarZIncrement;
        public static final /* enum */ FloatSetting fStatsStarZInitialOffset;
        public static final /* enum */ FloatSetting fSubSegmentVariance;
        public static final /* enum */ FloatSetting fSubmergedAngularDamping;
        public static final /* enum */ FloatSetting fSubmergedLODDistance;
        public static final /* enum */ FloatSetting fSubmergedLinearDampingH;
        public static final /* enum */ FloatSetting fSubmergedLinearDampingV;
        public static final /* enum */ FloatSetting fSubmergedMaxSpeed;
        public static final /* enum */ FloatSetting fSubmergedMaxWaterDistance;
        public static final /* enum */ FloatSetting fSubtitleSpeechDelay;
        public static final /* enum */ FloatSetting fSummonDistanceCheckThreshold;
        public static final /* enum */ FloatSetting fSummonedCreatureFadeOutSeconds;
        public static final /* enum */ FloatSetting fSummonedCreatureMaxFollowDist;
        public static final /* enum */ FloatSetting fSummonedCreatureMinFollowDist;
        public static final /* enum */ FloatSetting fSummonedCreatureSearchRadius;
        public static final /* enum */ FloatSetting fSunAlphaTransTime;
        public static final /* enum */ FloatSetting fSunDirXExtreme;
        public static final /* enum */ FloatSetting fSunMinimumGlareScale;
        public static final /* enum */ FloatSetting fSunReduceGlareSpeed;
        public static final /* enum */ FloatSetting fSunXExtreme;
        public static final /* enum */ FloatSetting fSunYExtreme;
        public static final /* enum */ FloatSetting fSunZExtreme;
        public static final /* enum */ FloatSetting fSweetSpotAverage;
        public static final /* enum */ FloatSetting fSweetSpotEasy;
        public static final /* enum */ FloatSetting fSweetSpotHard;
        public static final /* enum */ FloatSetting fSweetSpotVeryEasy;
        public static final /* enum */ FloatSetting fSweetSpotVeryHard;
        public static final /* enum */ FloatSetting fTakeBackTimerSetting;
        public static final /* enum */ FloatSetting fTargetMovedCoveredMoveRepathLength;
        public static final /* enum */ FloatSetting fTargetMovedRepathLength;
        public static final /* enum */ FloatSetting fTargetMovedRepathLengthLow;
        public static final /* enum */ FloatSetting fTeammateAggroOnDistancefromPlayer;
        public static final /* enum */ FloatSetting fTeleportDoorActivateDelayTimer;
        public static final /* enum */ FloatSetting fTemperingSkillUseMult;
        public static final /* enum */ FloatSetting fTimerForPlayerFurnitureEnter;
        public static final /* enum */ FloatSetting fTorchEvaluationTimer;
        public static final /* enum */ FloatSetting fTorchLightLevelInterior;
        public static final /* enum */ FloatSetting fTorchLightLevelMorning;
        public static final /* enum */ FloatSetting fTorchLightLevelNight;
        public static final /* enum */ FloatSetting fTrackDeadZoneXY;
        public static final /* enum */ FloatSetting fTrackDeadZoneZ;
        public static final /* enum */ FloatSetting fTrackEyeXY;
        public static final /* enum */ FloatSetting fTrackEyeZ;
        public static final /* enum */ FloatSetting fTrackFudgeXY;
        public static final /* enum */ FloatSetting fTrackFudgeZ;
        public static final /* enum */ FloatSetting fTrackJustAcquiredDuration;
        public static final /* enum */ FloatSetting fTrackMaxZ;
        public static final /* enum */ FloatSetting fTrackMinZ;
        public static final /* enum */ FloatSetting fTrackSpeed;
        public static final /* enum */ FloatSetting fTrackXY;
        public static final /* enum */ FloatSetting fTrainingBaseCost;
        public static final /* enum */ FloatSetting fTrainingMultCost;
        public static final /* enum */ FloatSetting fTriggerAvoidPlayerDistance;
        public static final /* enum */ FloatSetting fUIAltLogoModel;
        public static final /* enum */ FloatSetting fUILogoModel;
        public static final /* enum */ FloatSetting fUIMistMenu;
        public static final /* enum */ FloatSetting fUIMistModel;
        public static final /* enum */ FloatSetting fUIPlayerSceneLight;
        public static final /* enum */ FloatSetting fUIRaceSexLight;
        public static final /* enum */ FloatSetting fUnarmedCreatureDPSMult;
        public static final /* enum */ FloatSetting fUnarmedDamageMult;
        public static final /* enum */ FloatSetting fUnarmedNPCDPSMult;
        public static final /* enum */ FloatSetting fUnderwaterFullDepth;
        public static final /* enum */ FloatSetting fVATSAutomaticMeleeDamageMult;
        public static final /* enum */ FloatSetting fVATSCamTransRBDownStart;
        public static final /* enum */ FloatSetting fVATSCamTransRBRampDown;
        public static final /* enum */ FloatSetting fVATSCamTransRBRampup;
        public static final /* enum */ FloatSetting fVATSCamTransRBStart;
        public static final /* enum */ FloatSetting fVATSCamTransRBStrengthCap;
        public static final /* enum */ FloatSetting fVATSCamZoomInTime;
        public static final /* enum */ FloatSetting fVATSCameraMaxTime;
        public static final /* enum */ FloatSetting fVATSCameraMinTime;
        public static final /* enum */ FloatSetting fVATSCriticalChanceBonus;
        public static final /* enum */ FloatSetting fVATSDOFRange;
        public static final /* enum */ FloatSetting fVATSDOFStrengthCap;
        public static final /* enum */ FloatSetting fVATSDOFSwitchSeconds;
        public static final /* enum */ FloatSetting fVATSDamageToWeaponMult;
        public static final /* enum */ FloatSetting fVATSDestructibleMult;
        public static final /* enum */ FloatSetting fVATSDistanceFactor;
        public static final /* enum */ FloatSetting fVATSGrenadeChanceMult;
        public static final /* enum */ FloatSetting fVATSGrenadeDistAimZMult;
        public static final /* enum */ FloatSetting fVATSGrenadeRangeMin;
        public static final /* enum */ FloatSetting fVATSGrenadeRangeMult;
        public static final /* enum */ FloatSetting fVATSGrenadeSkillFactor;
        public static final /* enum */ FloatSetting fVATSGrenadeSuccessExplodeTimer;
        public static final /* enum */ FloatSetting fVATSGrenadeSuccessMaxDistance;
        public static final /* enum */ FloatSetting fVATSGrenadeTargetArea;
        public static final /* enum */ FloatSetting fVATSGrenadeTargetMelee;
        public static final /* enum */ FloatSetting fVATSH;
        public static final /* enum */ FloatSetting fVATSHitChanceMult;
        public static final /* enum */ FloatSetting fVATSImageSpaceTransitionTime;
        public static final /* enum */ FloatSetting fVATSLimbSelectCamPanTime;
        public static final /* enum */ FloatSetting fVATSMaxChance;
        public static final /* enum */ FloatSetting fVATSMaxEngageDistance;
        public static final /* enum */ FloatSetting fVATSMeleeArmConditionBase;
        public static final /* enum */ FloatSetting fVATSMeleeArmConditionMult;
        public static final /* enum */ FloatSetting fVATSMeleeChanceMult;
        public static final /* enum */ FloatSetting fVATSMeleeMaxDistance;
        public static final /* enum */ FloatSetting fVATSMeleeReachMult;
        public static final /* enum */ FloatSetting fVATSMeleeWarpDistanceMult;
        public static final /* enum */ FloatSetting fVATSMoveCameraLimbMult;
        public static final /* enum */ FloatSetting fVATSMoveCameraLimbPercent;
        public static final /* enum */ FloatSetting fVATSMoveCameraMaxSpeed;
        public static final /* enum */ FloatSetting fVATSMoveCameraXPercent;
        public static final /* enum */ FloatSetting fVATSMoveCameraYPercent;
        public static final /* enum */ FloatSetting fVATSParalyzePalmChance;
        public static final /* enum */ FloatSetting fVATSPlaybackDelay;
        public static final /* enum */ FloatSetting fVATSPlayerDamageMult;
        public static final /* enum */ FloatSetting fVATSPlayerMagicTimeSlowdownMult;
        public static final /* enum */ FloatSetting fVATSPlayerTimeUpdateMult;
        public static final /* enum */ FloatSetting fVATSRadialRampup;
        public static final /* enum */ FloatSetting fVATSRadialStart;
        public static final /* enum */ FloatSetting fVATSRadialStrength;
        public static final /* enum */ FloatSetting fVATSRangeSpreadMax;
        public static final /* enum */ FloatSetting fVATSRangeSpreadUncertainty;
        public static final /* enum */ FloatSetting fVATSScreenPercentFactor;
        public static final /* enum */ FloatSetting fVATSShotBurstTime;
        public static final /* enum */ FloatSetting fVATSShotLongBurstTime;
        public static final /* enum */ FloatSetting fVATSSkillFactor;
        public static final /* enum */ FloatSetting fVATSSmartCameraCheckHeight;
        public static final /* enum */ FloatSetting fVATSSmartCameraCheckStepCount;
        public static final /* enum */ FloatSetting fVATSSmartCameraCheckStepDistance;
        public static final /* enum */ FloatSetting fVATSSpreadMult;
        public static final /* enum */ FloatSetting fVATSStealthMult;
        public static final /* enum */ FloatSetting fVATSStrangerDistance;
        public static final /* enum */ FloatSetting fVATSStrangerOdds;
        public static final /* enum */ FloatSetting fVATSTargetActorHeightPanMult;
        public static final /* enum */ FloatSetting fVATSTargetActorZMultFar;
        public static final /* enum */ FloatSetting fVATSTargetActorZMultFarDist;
        public static final /* enum */ FloatSetting fVATSTargetActorZMultNear;
        public static final /* enum */ FloatSetting fVATSTargetFOVMinDist;
        public static final /* enum */ FloatSetting fVATSTargetFOVMinFOV;
        public static final /* enum */ FloatSetting fVATSTargetFOVMultFar;
        public static final /* enum */ FloatSetting fVATSTargetFOVMultFarDist;
        public static final /* enum */ FloatSetting fVATSTargetFOVMultNear;
        public static final /* enum */ FloatSetting fVATSTargetRotateMult;
        public static final /* enum */ FloatSetting fVATSTargetScanRotateMult;
        public static final /* enum */ FloatSetting fVATSTargetSelectCamPanTime;
        public static final /* enum */ FloatSetting fVATSTargetTimeUpdateMult;
        public static final /* enum */ FloatSetting fVATSThrownWeaponRangeMult;
        public static final /* enum */ FloatSetting fValueofItemForNoOwnership;
        public static final /* enum */ FloatSetting fVatsShotgunSpreadRatio;
        public static final /* enum */ FloatSetting fVoiceRateBase;
        public static final /* enum */ FloatSetting fWardAngleForExplosions;
        public static final /* enum */ FloatSetting fWarningTimer;
        public static final /* enum */ FloatSetting fWaterKnockdownSizeLarge;
        public static final /* enum */ FloatSetting fWaterKnockdownSizeNormal;
        public static final /* enum */ FloatSetting fWaterKnockdownSizeSmall;
        public static final /* enum */ FloatSetting fWaterKnockdownSizeVeryLarge;
        public static final /* enum */ FloatSetting fWaterKnockdownVelocity;
        public static final /* enum */ FloatSetting fWeaponBashMax;
        public static final /* enum */ FloatSetting fWeaponBashMin;
        public static final /* enum */ FloatSetting fWeaponBashPCMax;
        public static final /* enum */ FloatSetting fWeaponBashPCMin;
        public static final /* enum */ FloatSetting fWeaponBashSkillUseBase;
        public static final /* enum */ FloatSetting fWeaponBashSkillUseMult;
        public static final /* enum */ FloatSetting fWeaponBlockSkillUseBase;
        public static final /* enum */ FloatSetting fWeaponBlockSkillUseMult;
        public static final /* enum */ FloatSetting fWeaponClutterKnockBipedScale;
        public static final /* enum */ FloatSetting fWeaponClutterKnockMaxWeaponMass;
        public static final /* enum */ FloatSetting fWeaponClutterKnockMinClutterMass;
        public static final /* enum */ FloatSetting fWeaponClutterKnockMult;
        public static final /* enum */ FloatSetting fWeaponConditionCriticalChanceMult;
        public static final /* enum */ FloatSetting fWeaponConditionJam;
        public static final /* enum */ FloatSetting fWeaponConditionRateOfFire;
        public static final /* enum */ FloatSetting fWeaponConditionReloadJam;
        public static final /* enum */ FloatSetting fWeaponConditionSpread;
        public static final /* enum */ FloatSetting fWeaponTwoHandedAnimationSpeedMult;
        public static final /* enum */ FloatSetting fWeatherFlashAmbient;
        public static final /* enum */ FloatSetting fWeatherFlashDirectional;
        public static final /* enum */ FloatSetting fWeatherFlashDuration;
        public static final /* enum */ FloatSetting fWeatherTransAccel;
        public static final /* enum */ FloatSetting fWeatherTransMax;
        public static final /* enum */ FloatSetting fWeatherTransMin;
        public static final /* enum */ FloatSetting fWortFailSkillUseMagnitude;
        public static final /* enum */ FloatSetting fWortStrMult;
        public static final /* enum */ FloatSetting fWortalchmult;
        public static final /* enum */ FloatSetting fWortcraftChanceIntDenom;
        public static final /* enum */ FloatSetting fWortcraftChanceLuckDenom;
        public static final /* enum */ FloatSetting fWortcraftStrChanceDenom;
        public static final /* enum */ FloatSetting fWortcraftStrCostDenom;
        public static final /* enum */ FloatSetting fXPLevelUpBase;
        public static final /* enum */ FloatSetting fXPLevelUpMult;
        public static final /* enum */ FloatSetting fXPPerSkillRank;
        public static final /* enum */ FloatSetting fZKeyComplexHelperMinDistance;
        public static final /* enum */ FloatSetting fZKeyComplexHelperScale;
        public static final /* enum */ FloatSetting fZKeyComplexHelperWeightMax;
        public static final /* enum */ FloatSetting fZKeyComplexHelperWeightMin;
        public static final /* enum */ FloatSetting fZKeyHeavyWeight;
        public static final /* enum */ FloatSetting fZKeyMaxContactDistance;
        public static final /* enum */ FloatSetting fZKeyMaxContactMassRatio;
        public static final /* enum */ FloatSetting fZKeyMaxForce;
        public static final /* enum */ FloatSetting fZKeyMaxForceScaleHigh;
        public static final /* enum */ FloatSetting fZKeyMaxForceScaleLow;
        public static final /* enum */ FloatSetting fZKeyMaxForceWeightHigh;
        public static final /* enum */ FloatSetting fZKeyMaxForceWeightLow;
        public static final /* enum */ FloatSetting fZKeyObjectDamping;
        public static final /* enum */ FloatSetting fZKeySpringDamping;
        public static final /* enum */ FloatSetting fZKeySpringElasticity;
        public static final /* enum */ FloatSetting fmodifiedTargetAttackRange;
        private static final /* synthetic */ FloatSetting[] ENUM$VALUES;

        static {
            FloatSetting. enum constant initialization$2();
            FloatSetting. enum constant initialization$3();
            ENUM$VALUES = new FloatSetting[]{fAIAcquireObjectDistance, fAIActivateHeight, fAIActivateReach, fAIActorPackTargetHeadTrackMod, fAIAimBlockedHalfCircleRadius, fAIAimBlockedToleranceDegrees, fAIAwareofPlayerTimer, fAIBestHeadTrackDistance, fAICombatFleeScoreThreshold, fAICombatNoAreaEffectAllyDistance, fAICombatNoTargetLOSPriorityMult, fAICombatSlopeDifference, fAICombatTargetUnreachablePriorityMult, fAICombatUnreachableTargetPriorityMult, fAICommentTimeWindow, fAIConversationExploreTime, fAIDefaultSpeechMult, fAIDialogueDistance, fAIDistanceRadiusMinLocation, fAIDistanceTeammateDrawWeapon, fAIDodgeDecisionBase, fAIDodgeFavorLeftRightMult, fAIDodgeVerticalRangedAttackMult, fAIDodgeWalkChance, fAIEnergyLevelBase, fAIEngergyLevelMult, fAIEscortFastTravelMaxDistFromPath, fAIEscortHysteresisWidth, fAIEscortStartStopDelayTime, fAIEscortWaitDistanceExterior, fAIEscortWaitDistanceInterior, fAIExclusiveGreetingTimer, fAIExplosiveWeaponDamageMult, fAIExplosiveWeaponRangeMult, fAIExteriorSpectatorDetection, fAIExteriorSpectatorDistance, fAIFaceTargetAnimationAngle, fAIFindBedChairsDistance, fAIFleeConfBase, fAIFleeConfMult, fAIFleeHealthMult, fAIFleeSuccessTimeout, fAIForceGreetingTimer, fAIFurnitureDestinationRadius, fAIGreetingTimer, fAIHeadTrackDialogueOffsetRandomValue, fAIHeadTrackDialoguePickNewOffsetTimer, fAIHeadTrackDialogueResetPositionTimer, fAIHeadTrackDialogueStayInOffsetMax, fAIHeadTrackDialogueStayInOffsetMin, fAIHeadTrackOffsetRandomValueMax, fAIHeadTrackOffsetRandomValueMin, fAIHeadTrackPickNewOffsetTimer, fAIHeadTrackResetPositionTimer, fAIHeadTrackStayInOffsetMax, fAIHeadTrackStayInOffsetMin, fAIHoldDefaultHeadTrackTimer, fAIHorseSearchDistance, fAIIdleAnimationDistance, fAIIdleAnimationLargeCreatureDistanceMult, fAIIdleWaitTime, fAIIdleWaitTimeComplexScene, fAIInDialogueModeWithPlayerDistance, fAIInDialogueModewithPlayerTimer, fAIInteriorHeadTrackMult, fAIInteriorSpectatorDetection, fAIInteriorSpectatorDistance, fAILockDoorsSeenRecentlySeconds, fAIMagicSpellMult, fAIMagicTimer, fAIMarkerDestinationRadius, fAIMaxAngleRangeMovingToStartSceneDialogue, fAIMaxHeadTrackDistance, fAIMaxHeadTrackDistanceFromPC, fAIMaxLargeCreatureHeadTrackDistance, fAIMaxSmileDistance, fAIMaxWanderTime, fAIMeleeArmorMult, fAIMeleeHandMult, fAIMinAngleRangeToStartSceneDialogue, fAIMinGreetingDistance, fAIMinLocationHeight, fAIMoveDistanceToRecalcFollowPath, fAIMoveDistanceToRecalcTravelPath, fAIMoveDistanceToRecalcTravelToActor, fAIPatrolHysteresisWidth, fAIPatrolMinSecondsAtNormalFurniture, fAIPowerAttackCreatureChance, fAIPowerAttackKnockdownBonus, fAIPowerAttackNPCChance, fAIPowerAttackRecoilBonus, fAIPursueDistanceLineOfSight, fAIRandomizeInitialLocationMinRadius, fAIRangMagicSpellMult, fAIRangedWeaponMult, fAIRevertToScriptTracking, fAIShoutMinAimSeconds, fAIShoutRetryDelaySeconds, fAIShoutToleranceDegrees, fAISocialRadiusToTriggerConversation, fAISocialRadiusToTriggerConversationInterior, fAISocialTimerForConversationsMax, fAISocialTimerForConversationsMin, fAISocialTimerToWaitForEvent, fAISocialchanceForConversation, fAISocialchanceForConversationInterior, fAISpectatorCommentTimer, fAISpectatorRememberThreatTimer, fAISpectatorShutdownDistance, fAISpectatorThreatDistExplosion, fAISpectatorThreatDistMelee, fAISpectatorThreatDistMine, fAISpectatorThreatDistRanged, fAIStayonScriptHeadtrack, fAITrespassWarningTimer, fAIUpdateMovementRestrictionsDistance, fAIUseMagicToleranceDegrees, fAIUseWeaponAnimationTimeoutSeconds, fAIUseWeaponDistance, fAIUseWeaponToleranceDegrees, fAIWaitingforScriptCallback, fAIWalkAwayTimerForConversation, fAIWanderDefaultMinDist, fAItalktoNPCtimer, fAItalktosameNPCtimer, fActionPointsAimAdjustment, fActionPointsAttackMagic, fActionPointsAttackOneHandMelee, fActionPointsAttackRanged, fActionPointsAttackTwoHandMelee, fActionPointsAttackUnarmed, fActionPointsCrouch, fActionPointsFOVBase, fActionPointsFOVMult, fActionPointsHeal, fActionPointsPowerAttackMult, fActionPointsReload, fActionPointsRestoreRate, fActionPointsRunAndGunMult, fActionPointsStand, fActionPointsSwitchWeapon, fActionPointsToggleWeaponDrawn, fActionPointsVATSMeleeMult, fActiveEffectConditionUpdateInterval, fActorAlertSoundTimer, fActorAlphaFadeSeconds, fActorAnimZAdjust, fActorArmorDesirabilityDamageMult, fActorArmorDesirabilitySkillMult, fActorDefaultTurningSpeed, fActorLeaveWaterBreathTimer, fActorLuckSkillMult, fActorStrengthEncumbranceMult, fActorSwimBreathBase, fActorSwimBreathDamage, fActorSwimBreathMult, fActorTeleportFadeSeconds, fActorWeaponDesirabilityDamageMult, fActorWeaponDesirabilitySkillMult, fAddictionUsageMonitorThreshold, fAiAcquireKillBase, fAiAcquireKillMult, fAiAcquirePickBase, fAiAcquirePickMult, fAiAcquireStealBase, fAiAcquireStealMult, fAlchemyGoldMult, fAlchemyIngredientInitMult, fAlchemySkillFactor, fAmbushOverRideRadiusforPlayerDetection, fArmorBaseFactor, fArmorRatingBase, fArmorRatingMax, fArmorRatingPCBase, fArmorRatingPCMax, fArmorScalingFactor, fArmorWeightLightMaxMod, fArrowBounceBlockPercentage, fArrowBounceLinearSpeed, fArrowBounceRotateSpeed, fArrowBowFastMult, fArrowBowMinTime, fArrowBowSlowMult, fArrowFakeMass, fArrowGravityBase, fArrowGravityMin, fArrowGravityMult, fArrowMaxDistance, fArrowMinBowVelocity, fArrowMinDistanceForTrails, fArrowMinPower, fArrowMinSpeedForTrails, fArrowMinVelocity, fArrowOptimalDistance, fArrowSpeedMult, fArrowWeakGravity, fAuroraFadeInStart, fAuroraFadeOutStart, fAutoAimMaxDegrees, fAutoAimMaxDegreesMelee, fAutoAimMaxDegreesVATS, fAutoAimMaxDistance, fAutoAimScreenPercentage, fAutomaticWeaponBurstCooldownTime, fAutomaticWeaponBurstFireTime, fAutoraFadeIn, fAutoraFadeOut, fAvoidPlayerDistance, fBarterBuyMin, fBarterMax, fBarterMin, fBarterSellMax, fBeamWidthDefault, fBigBumpSpeed, fBleedoutCheck, fBleedoutDefault, fBleedoutMin, fBleedoutRate, fBleedoutRecover, fBlinkDelayMax, fBlinkDelayMin, fBlinkDownTime, fBlinkUpTime, fBlockAmountHandToHandMult, fBlockAmountWeaponMult, fBlockLevel, fBlockMax, fBlockPowerAttackMult, fBlockScoreNoShieldMult, fBlockSkillBase, fBlockSkillMult, fBlockWeaponBase, fBlockWeaponScaling, fBloodSplatterCountBase, fBloodSplatterCountDamageBase, fBloodSplatterCountDamageMult, fBloodSplatterCountRandomMargin, fBloodSplatterDuration, fBloodSplatterFadeStart, fBloodSplatterFlareMult, fBloodSplatterFlareOffsetScale, fBloodSplatterFlareSize, fBloodSplatterMaxOpacity, fBloodSplatterMaxSize, fBloodSplatterMinOpacity, fBloodSplatterMinSize, fBloodSplatterOpacityChance, fBookLight, fBowDrawTime, fBowHoldTimer, fBowNPCSpreadAngle, fBowZoomStaminaDrainMult, fBowZoomStaminaRegenDelay, fBribeBase, fBribeCostCurve, fBribeMoralityMult, fBribeMult, fBribeNPCLevelMult, fBribeScale, fBribeSpeechcraftMult, fBumpReactionIdealMoveDist, fBumpReactionMinMoveDist, fBumpReactionSmallDelayTime, fBumpReactionSmallWaitTimer, fBuoyancyMultBody, fBuoyancyMultExtremity, fCameraShakeDistFadeDelta, fCameraShakeDistFadeStart, fCameraShakeDistMin, fCameraShakeExplosionDistMult, fCameraShakeFadeTime, fCameraShakeMultMin, fCameraShakeTime, fChaseDetectionTimerSetting, fCheckDeadBodyTimer, fCheckPositionFallDistance, fClosetoPlayerDistance, fClothingArmorBase, fClothingArmorScale, fClothingBase, fClothingClassScale, fClothingJewelryBase, fClothingJewelryScale, fCombatAbsoluteMaxRangeMult, fCombatAcquirePickupAnimationDelay, fCombatAcquireWeaponAmmoMinimumScoreMult, fCombatAcquireWeaponAvoidTargetRadius, fCombatAcquireWeaponCloseDistanceMax, fCombatAcquireWeaponCloseDistanceMin, fCombatAcquireWeaponDisarmedAcquireTime, fCombatAcquireWeaponDisarmedDistanceMax, fCombatAcquireWeaponDisarmedDistanceMin, fCombatAcquireWeaponDisarmedTime, fCombatAcquireWeaponEnchantmentChargeMult, fCombatAcquireWeaponFindAmmoDistance, fCombatAcquireWeaponMeleeScoreMult, fCombatAcquireWeaponMinimumScoreMult, fCombatAcquireWeaponMinimumTargetDistance, fCombatAcquireWeaponRangedDistanceMax, fCombatAcquireWeaponRangedDistanceMin, fCombatAcquireWeaponReachDistance, fCombatAcquireWeaponScoreCostMult, fCombatAcquireWeaponScoreRatioMax, fCombatAcquireWeaponSearchFailedDelay, fCombatAcquireWeaponSearchRadiusBuffer, fCombatAcquireWeaponSearchSuccessDelay, fCombatAcquireWeaponTargetDistanceCheck, fCombatAcquireWeaponUnarmedDistanceMax, fCombatAcquireWeaponUnarmedDistanceMin, fCombatActiveCombatantAttackRangeDistance, fCombatActiveCombatantLastSeenTime, fCombatAdvanceInnerRadiusMax, fCombatAdvanceInnerRadiusMid, fCombatAdvanceInnerRadiusMin, fCombatAdvanceLastDamagedThreshold, fCombatAdvanceNormalAttackChance, fCombatAdvanceOuterRadiusMax, fCombatAdvanceOuterRadiusMid, fCombatAdvanceOuterRadiusMin, fCombatAdvancePathRetryTime, fCombatAdvanceRadiusStaggerMult, fCombatAimDeltaThreshold, fCombatAimLastSeenLocationTimeLimit, fCombatAimMeleeHighPriorityUpdateTime, fCombatAimMeleeUpdateTime, fCombatAimProjectileBlockedTime, fCombatAimProjectileGroundMinRadius, fCombatAimProjectileRandomOffset, fCombatAimProjectileUpdateTime, fCombatAimTrackTargetUpdateTime, fCombatAngleTolerance, fCombatAnticipateTime, fCombatAnticipatedLocationCheckDistance, fCombatApproachTargetSlowdownDecelerationMult, fCombatApproachTargetSlowdownDistance, fCombatApproachTargetSlowdownUpdateTime, fCombatApproachTargetSlowdownVelocityAngle, fCombatApproachTargetSprintStopMovingRange, fCombatApproachTargetSprintStopRange, fCombatApproachTargetUpdateTime, fCombatAreaHoldPositionMinimumRadius, fCombatAreaStandardAttackedRadius, fCombatAreaStandardAttackedTime, fCombatAreaStandardCheckViewConeDistanceMax, fCombatAreaStandardCheckViewConeDistanceMin, fCombatAreaStandardFlyingRadiusMult, fCombatAreaStandardRadius, fCombatAttackAllowedOverrunDistance, fCombatAttackAnimationDrivenDelayTime, fCombatAttackAnticipatedDistanceMin, fCombatAttackChanceBlockingMultMax, fCombatAttackChanceBlockingMultMin, fCombatAttackChanceBlockingSwingMult, fCombatAttackChanceLastAttackBonus, fCombatAttackChanceLastAttackBonusTime, fCombatAttackChanceMax, fCombatAttackChanceMin, fCombatAttackCheckTargetRangeDistance, fCombatAttackMovingAttackDistance, fCombatAttackMovingAttackReachMult, fCombatAttackMovingStrikeAngleMult, fCombatAttackPlayerAnticipateMult, fCombatAttackStationaryAttackDistance, fCombatAttackStrikeAngleMult, fCombatAvoidThreatsChance, fCombatBackoffChance, fCombatBackoffMinDistanceMult, fCombatBashChanceMax, fCombatBashChanceMin, fCombatBashReach, fCombatBashTargetBlockingMult, fCombatBetweenAdvanceTimer, fCombatBlockAttackChanceMax, fCombatBlockAttackChanceMin, fCombatBlockAttackReachMult, fCombatBlockAttackStrikeAngleMult, fCombatBlockChanceMax, fCombatBlockChanceMin, fCombatBlockChanceWeaponMult, fCombatBlockMaxTargetRetreatVelocity, fCombatBlockStartDistanceMax, fCombatBlockStartDistanceMin, fCombatBlockStopDistanceMax, fCombatBlockStopDistanceMin, fCombatBlockTimeMax, fCombatBlockTimeMid, fCombatBlockTimeMin, fCombatBoundWeaponDPSBonus, fCombatBuffMaxTimer, fCombatBuffStandoffTimer, fCombatCastConcentrationOffensiveMagicCastTimeMax, fCombatCastConcentrationOffensiveMagicCastTimeMin, fCombatCastConcentrationOffensiveMagicChanceMax, fCombatCastConcentrationOffensiveMagicChanceMin, fCombatCastConcentrationOffensiveMagicWaitTimeMax, fCombatCastConcentrationOffensiveMagicWaitTimeMin, fCombatCastImmediateOffensiveMagicChanceMax, fCombatCastImmediateOffensiveMagicChanceMin, fCombatCastImmediateOffensiveMagicHoldTimeAbsoluteMin, fCombatCastImmediateOffensiveMagicHoldTimeMax, fCombatCastImmediateOffensiveMagicHoldTimeMin, fCombatCastImmediateOffensiveMagicHoldTimeMinDistance, fCombatChangeProcessFaceTargetDistance, fCombatCircleAngleMax, fCombatCircleAngleMin, fCombatCircleAnglePlayerMult, fCombatCircleChanceMax, fCombatCircleChanceMin, fCombatCircleDistanceMax, fCombatCircleDistantChanceMax, fCombatCircleDistantChanceMin, fCombatCircleMinDistanceMult, fCombatCircleMinDistanceRadiusMult, fCombatCircleMinMovementDistance, fCombatCircleViewConeAngle, fCombatCloseRangeTrackTargetDistance, fCombatClusterUpdateTime, fCombatCollectAlliesTimer, fCombatConfidenceModifierMax, fCombatConfidenceModifierMin, fCombatCoverAttackMaxWaitTime, fCombatCoverAttackOffsetDistance, fCombatCoverAttackTimeMax, fCombatCoverAttackTimeMid, fCombatCoverAttackTimeMin, fCombatCoverAvoidTargetRadius, fCombatCoverCheckCoverHeightMin, fCombatCoverCheckCoverHeightOffset, fCombatCoverEdgeOffsetDistance, fCombatCoverLedgeOffsetDistance, fCombatCoverMaxRangeMult, fCombatCoverMidPointMaxRangeBuffer, fCombatCoverMinimumActiveRange, fCombatCoverMinimumRange, fCombatCoverObstacleMovedTime, fCombatCoverRangeMaxActiveMult, fCombatCoverRangeMaxBufferDistance, fCombatCoverRangeMinActiveMult, fCombatCoverRangeMinBufferDistance, fCombatCoverReservationWidthMult, fCombatCoverSearchDistanceMax, fCombatCoverSearchDistanceMin, fCombatCoverSearchFailedDelay, fCombatCoverSecondaryThreatLastSeenTime, fCombatCoverSecondaryThreatMinDistance, fCombatCoverWaitLookOffsetDistance, fCombatCoverWaitTimeMax, fCombatCoverWaitTimeMid, fCombatCoverWaitTimeMin, fCombatCurrentWeaponAbsoluteMaxRangeMult, fCombatDPSBowSpeedMult, fCombatDPSMeleeSpeedMult, fCombatDamageBonusMeleeSneakingMult, fCombatDamageBonusSneakingMult, fCombatDamageScale, fCombatDeadActorHitConeMult, fCombatDetectionDialogueIdleMaxElapsedTime, fCombatDetectionDialogueIdleMinElapsedTime, fCombatDetectionDialogueMaxElapsedTime, fCombatDetectionDialogueMinElapsedTime, fCombatDetectionFleeingLostRemoveTime, fCombatDetectionLostCheckNoticedDistance, fCombatDetectionLostRemoveDistance, fCombatDetectionLostRemoveDistanceTime, fCombatDetectionLostRemoveTime, fCombatDetectionLostTimeLimit, fCombatDetectionLowDetectionDistance, fCombatDetectionLowPriorityDistance, fCombatDetectionNoticedDistanceLimit, fCombatDetectionNoticedTimeLimit, fCombatDetectionVeryLowPriorityDistance, fCombatDialogueAllyKilledDistanceMult, fCombatDialogueAllyKilledMaxElapsedTime, fCombatDialogueAllyKilledMinElapsedTime, fCombatDialogueAttackDistanceMult, fCombatDialogueAttackMaxElapsedTime, fCombatDialogueAttackMinElapsedTime, fCombatDialogueAvoidThreatDistanceMult, fCombatDialogueAvoidThreatMaxElapsedTime, fCombatDialogueAvoidThreatMinElapsedTime, fCombatDialogueBashDistanceMult, fCombatDialogueBleedOutMaxElapsedTime, fCombatDialogueBleedOutMinElapsedTime, fCombatDialogueBleedoutDistanceMult, fCombatDialogueBlockDistanceMult, fCombatDialogueDeathDistanceMult, fCombatDialogueFleeDistanceMult, fCombatDialogueFleeMaxElapsedTime, fCombatDialogueFleeMinElapsedTime, fCombatDialogueGroupStrategyDistanceMult, fCombatDialogueHitDistanceMult, fCombatDialoguePowerAttackDistanceMult, fCombatDialogueTauntDistanceMult, fCombatDialogueTauntMaxElapsedTime, fCombatDialogueTauntMinElapsedTime, fCombatDisarmedFindBetterWeaponInitialTime, fCombatDisarmedFindBetterWeaponTime, fCombatDismemberedLimbVelocity, fCombatDistance, fCombatDistanceMin, fCombatDiveBombChanceMax, fCombatDiveBombChanceMin, fCombatDiveBombOffsetPercent, fCombatDiveBombSlowDownDistance, fCombatDodgeAccelerationMult, fCombatDodgeAcceptableThreatScoreMult, fCombatDodgeAnticipateThreatTime, fCombatDodgeBufferDistance, fCombatDodgeChanceMax, fCombatDodgeChanceMin, fCombatDodgeDecelerationMult, fCombatDodgeMovingReactionTime, fCombatDodgeReactionTime, fCombatEffectiveDistanceAnticipateTime, fCombatEnvironmentBloodChance, fCombatFallbackChanceMax, fCombatFallbackChanceMin, fCombatFallbackDistanceMax, fCombatFallbackDistanceMin, fCombatFallbackMaxAngle, fCombatFallbackMinMovementDistance, fCombatFallbackWaitTimeMax, fCombatFallbackWaitTimeMin, fCombatFindAllyAttackLocationAllyRadius, fCombatFindAllyAttackLocationDistanceMax, fCombatFindAllyAttackLocationDistanceMin, fCombatFindAttackLocationAvoidTargetRadius, fCombatFindAttackLocationDistance, fCombatFindAttackLocationKeyAngle, fCombatFindAttackLocationKeyHeight, fCombatFindBetterWeaponTime, fCombatFindLateralAttackLocationDistance, fCombatFindLateralAttackLocationIntervalMax, fCombatFindLateralAttackLocationIntervalMin, fCombatFiringArcStationaryTurnMult, fCombatFlankingAngleOffset, fCombatFlankingAngleOffsetCostMult, fCombatFlankingAngleOffsetMax, fCombatFlankingDirectionDistanceMult, fCombatFlankingDirectionGoalAngleOffset, fCombatFlankingDirectionOffsetCostMult, fCombatFlankingDirectionRotateAngleOffset, fCombatFlankingDistanceMax, fCombatFlankingDistanceMin, fCombatFlankingGoalAngleFarMax, fCombatFlankingGoalAngleFarMaxDistance, fCombatFlankingGoalAngleFarMin, fCombatFlankingGoalAngleFarMinDistance, fCombatFlankingGoalAngleNear, fCombatFlankingGoalCheckDistanceMax, fCombatFlankingGoalCheckDistanceMin, fCombatFlankingGoalCheckDistanceMult, fCombatFlankingLocationGridSize, fCombatFlankingMaxTurnAngle, fCombatFlankingMaxTurnAngleGoal, fCombatFlankingNearDistance, fCombatFlankingRotateAngle, fCombatFlankingStalkRange, fCombatFlankingStalkTimeMax, fCombatFlankingStalkTimeMin, fCombatFlankingStepDistanceMax, fCombatFlankingStepDistanceMin, fCombatFlankingStepDistanceMult, fCombatFleeAllyDistanceMax, fCombatFleeAllyDistanceMin, fCombatFleeAllyRadius, fCombatFleeCoverMinDistance, fCombatFleeCoverSearchRadius, fCombatFleeDistanceExterior, fCombatFleeDistanceInterior, fCombatFleeDoorDistanceMax, fCombatFleeDoorTargetCheckDistance, fCombatFleeInitialDoorRestrictChance, fCombatFleeLastDoorRestrictTime, fCombatFleeTargetAvoidRadius, fCombatFleeTargetGatherRadius, fCombatFleeUseDoorChance, fCombatFleeUseDoorRestrictTime, fCombatFlightEffectiveDistance, fCombatFlightMinimumRange, fCombatFlyingAttackChanceMax, fCombatFlyingAttackChanceMin, fCombatFlyingAttackTargetDistanceThreshold, fCombatFollowRadiusBase, fCombatFollowRadiusMin, fCombatFollowRadiusMult, fCombatFollowSneakFollowRadius, fCombatForwardAttackChance, fCombatGiantCreatureReachMult, fCombatGrenadeBounceTimeMax, fCombatGrenadeBounceTimeMin, fCombatGroundAttackChanceMax, fCombatGroundAttackChanceMin, fCombatGroundAttackTimeMax, fCombatGroundAttackTimeMin, fCombatGroupCombatStrengthUpdateTime, fCombatGroupOffensiveMultMin, fCombatGuardFollowBufferDistance, fCombatGuardRadiusMin, fCombatGuardRadiusMult, fCombatHealthRegenRateMult, fCombatHideCheckViewConeDistanceMax, fCombatHideCheckViewConeDistanceMin, fCombatHideFailedTargetDistance, fCombatHideFailedTargetLOSDistance, fCombatHitConeAngle, fCombatHoverAngleLimit, fCombatHoverAngleMax, fCombatHoverAngleMin, fCombatHoverChanceMax, fCombatHoverChanceMin, fCombatHoverTimeMax, fCombatHoverTimeMin, fCombatInTheWayTimer, fCombatInventoryDesiredRangeScoreMultMax, fCombatInventoryDesiredRangeScoreMultMid, fCombatInventoryDesiredRangeScoreMultMin, fCombatInventoryDualWieldScorePenalty, fCombatInventoryEquipmentMinScoreMult, fCombatInventoryEquippedScoreBonus, fCombatInventoryMaxRangeEquippedBonus, fCombatInventoryMaxRangeScoreMult, fCombatInventoryMeleeEquipRange, fCombatInventoryMinEquipTimeBlock, fCombatInventoryMinEquipTimeDefault, fCombatInventoryMinEquipTimeMagic, fCombatInventoryMinEquipTimeShout, fCombatInventoryMinEquipTimeStaff, fCombatInventoryMinEquipTimeTorch, fCombatInventoryMinEquipTimeWeapon, fCombatInventoryMinRangeScoreMult, fCombatInventoryMinRangeUnequippedBonus, fCombatInventoryOptimalRangePercent, fCombatInventoryRangedScoreMult, fCombatInventoryResourceCurrentRequiredMult, fCombatInventoryResourceDesiredRequiredMult, fCombatInventoryResourceRegenTime, fCombatInventoryShieldEquipRange, fCombatInventoryShoutMaxRecoveryTime, fCombatInventoryTorchEquipRange, fCombatInventoryUpdateTimer, fCombatIronSightsDistance, fCombatIronSightsRangeMult, fCombatItemBuffTimer, fCombatItemRestoreTimer, fCombatKillMoveDamageMult, fCombatLandingAvoidActorRadius, fCombatLandingSearchDistance, fCombatLandingZoneDistance, fCombatLineOfSightTimer, fCombatLocationTargetRadiusMin, fCombatLowFleeingTargetHitPercent, fCombatLowMaxAttackDistance, fCombatLowTargetHitPercent, fCombatMagicArmorDistanceMax, fCombatMagicArmorDistanceMin, fCombatMagicArmorMinCastTime, fCombatMagicBoundItemDistance, fCombatMagicBuffDuration, fCombatMagicCloakDistanceMax, fCombatMagicCloakDistanceMin, fCombatMagicCloakMinCastTime, fCombatMagicConcentrationAimVariance, fCombatMagicConcentrationFiringArcMult, fCombatMagicConcentrationMinCastTime, fCombatMagicConcentrationScoreDuration, fCombatMagicDefaultLongDuration, fCombatMagicDefaultMinCastTime, fCombatMagicDefaultShortDuration, fCombatMagicDisarmDistance, fCombatMagicDisarmRestrictTime, fCombatMagicDrinkPotionWaitTime, fCombatMagicDualCastChance, fCombatMagicDualCastInterruptTime, fCombatMagicImmediateAimVariance, fCombatMagicInvisibilityDistance, fCombatMagicInvisibilityMinCastTime, fCombatMagicLightMinCastTime, fCombatMagicOffensiveMinCastTime, fCombatMagicParalyzeDistance, fCombatMagicParalyzeMinCastTime, fCombatMagicParalyzeRestrictTime, fCombatMagicProjectileFiringArc, fCombatMagicReanimateDistance, fCombatMagicReanimateMinCastTime, fCombatMagicReanimateRestrictTime, fCombatMagicStaggerDistance, fCombatMagicSummonMinCastTime, fCombatMagicSummonRestrictTime, fCombatMagicTacticalDuration, fCombatMagicTargetEffectMinCastTime, fCombatMagicWardAttackRangeDistance, fCombatMagicWardAttackReachMult, fCombatMagicWardCooldownTime, fCombatMagicWardMagickaCastLimit, fCombatMagicWardMagickaEquipLimit, fCombatMagicWardMinCastTime, fCombatMagickaRegenRateMult, fCombatMaintainOptimalDistanceMaxAngle, fCombatMaintainRangeDistanceMin, fCombatMaxHoldScore, fCombatMaximumOptimalRangeMax, fCombatMaximumOptimalRangeMid, fCombatMaximumOptimalRangeMin, fCombatMaximumProjectileRange, fCombatMaximumRange, fCombatMeleeTrackTargetDistanceMax, fCombatMeleeTrackTargetDistanceMin, fCombatMinEngageDistance, fCombatMissileImpaleDepth, fCombatMissileStickDepth, fCombatMonitorBuffsTimer, fCombatMoveToActorBufferDistance, fCombatMusicGroupThreatRatioMax, fCombatMusicGroupThreatRatioMin, fCombatMusicGroupThreatRatioTimer, fCombatMusicNearCombatInnerRadius, fCombatMusicNearCombatOuterRadius, fCombatMusicPlayerCombatStrengthCap, fCombatMusicPlayerNearStrengthMult, fCombatMusicPlayerTargetedThreatRatio, fCombatMusicStopTime, fCombatMusicUpdateTime, fCombatOffensiveBashChanceMax, fCombatOffensiveBashChanceMin, fCombatOptimalRangeMaxBufferDistance, fCombatOptimalRangeMinBufferDistance, fCombatOrbitDistance, fCombatOrbitTimeMax, fCombatOrbitTimeMin, fCombatParalyzeTacticalDuration, fCombatPathingAccelerationMult, fCombatPathingCurvedPathSmoothingMult, fCombatPathingDecelerationMult, fCombatPathingGoalRayCastPathDistance, fCombatPathingIncompletePathMinDistance, fCombatPathingLocationCenterOffsetMult, fCombatPathingLookAheadDelta, fCombatPathingNormalizedRotationSpeed, fCombatPathingRefLocationUpdateDistance, fCombatPathingRefLocationUpdateTimeDistanceMax, fCombatPathingRefLocationUpdateTimeDistanceMin, fCombatPathingRefLocationUpdateTimeMax, fCombatPathingRefLocationUpdateTimeMin, fCombatPathingRetryWaitTime, fCombatPathingRotationAccelerationMult, fCombatPathingStartRayCastPathDistance, fCombatPathingStraightPathCheckDistance, fCombatPathingStraightRayCastPathDistance, fCombatPathingUpdatePathCostMult, fCombatPerchAttackChanceMax, fCombatPerchAttackChanceMin, fCombatPerchAttackTimeMax, fCombatPerchAttackTimeMin, fCombatPerchMaxTargetAngle, fCombatPlayerBleedoutHealthDamageMult, fCombatPlayerLimbDamageMult, fCombatProjectileMaxRangeMult, fCombatProjectileMaxRangeOptimalMult, fCombatRadiusMinMult, fCombatRangedAimVariance, fCombatRangedAttackChanceLastAttackBonus, fCombatRangedAttackChanceLastAttackBonusTime, fCombatRangedAttackChanceMax, fCombatRangedAttackChanceMin, fCombatRangedAttackHoldTimeAbsoluteMin, fCombatRangedAttackHoldTimeMax, fCombatRangedAttackHoldTimeMin, fCombatRangedAttackHoldTimeMinDistance, fCombatRangedAttackMaximumHoldTime, fCombatRangedDistance, fCombatRangedMinimumRange, fCombatRangedProjectileFiringArc, fCombatRangedStandoffTimer, fCombatRelativeDamageMod, fCombatRestoreHealthPercentMax, fCombatRestoreHealthPercentMin, fCombatRestoreHealthRestrictTime, fCombatRestoreMagickaPercentMax, fCombatRestoreMagickaPercentMin, fCombatRestoreMagickaRestrictTime, fCombatRestoreStopCastThreshold, fCombatRoundAmount, fCombatSearchAreaUpdateTime, fCombatSearchCenterRadius, fCombatSearchCheckDestinationDistanceMax, fCombatSearchCheckDestinationDistanceMid, fCombatSearchCheckDestinationDistanceMin, fCombatSearchCheckDestinationTime, fCombatSearchDoorDistance, fCombatSearchDoorDistanceLow, fCombatSearchDoorSearchRadius, fCombatSearchExteriorRadiusMax, fCombatSearchExteriorRadiusMin, fCombatSearchIgnoreLocationRadius, fCombatSearchInteriorRadiusMax, fCombatSearchInteriorRadiusMin, fCombatSearchInvestigateTime, fCombatSearchLocationCheckDistance, fCombatSearchLocationCheckTime, fCombatSearchLocationInitialCheckTime, fCombatSearchLocationInvestigateDistance, fCombatSearchLocationRadius, fCombatSearchLookTime, fCombatSearchRadiusBufferDistance, fCombatSearchRadiusMemberDistance, fCombatSearchSightRadius, fCombatSearchStartWaitTime, fCombatSearchUpdateTime, fCombatSearchWanderDistance, fCombatSelectTargetSwitchUpdateTime, fCombatSelectTargetUpdateTime, fCombatShoutHeadTrackingAngleMovingMult, fCombatShoutHeadTrackingAngleMult, fCombatShoutLongRecoveryTime, fCombatShoutMaxHeadTrackingAngle, fCombatShoutReleaseTime, fCombatShoutShortRecoveryTime, fCombatSneakAttackBonusMult, fCombatSpeakAttackChance, fCombatSpeakHitChance, fCombatSpeakHitThreshold, fCombatSpeakPowerAttackChance, fCombatSpeakTauntChance, fCombatSpecialAttackChanceMax, fCombatSpecialAttackChanceMin, fCombatSpeedValueFastWalk, fCombatSpeedValueJog, fCombatSpeedValueRun, fCombatSpeedValueWalk, fCombatSplashDamageMaxSpeed, fCombatSplashDamageMinDamage, fCombatSplashDamageMinRadius, fCombatStaffTimer, fCombatStaminaRegenRateMult, fCombatStealthPointAttackedMaxValue, fCombatStealthPointDetectedEventMaxValue, fCombatStealthPointDrainMult, fCombatStealthPointMax, fCombatStealthPointRegenAlertWaitTime, fCombatStealthPointRegenAttackedWaitTime, fCombatStealthPointRegenDetectedEventWaitTime, fCombatStealthPointRegenLostWaitTime, fCombatStealthPointRegenMin, fCombatStealthPointRegenMult, fCombatStepAdvanceDistance, fCombatStrafeChanceMax, fCombatStrafeChanceMin, fCombatStrafeDistanceMax, fCombatStrafeDistanceMin, fCombatStrafeMinDistanceRadiusMult, fCombatStrengthUpdateTime, fCombatSurroundDistanceMax, fCombatSurroundDistanceMin, fCombatTargetEngagedLastSeenTime, fCombatTargetLocationAvoidNodeRadiusOffset, fCombatTargetLocationCurrentReservationDistanceMult, fCombatTargetLocationMaxDistance, fCombatTargetLocationMinDistanceMult, fCombatTargetLocationPathingRadius, fCombatTargetLocationRadiusSizeMult, fCombatTargetLocationRepositionAngleMult, fCombatTargetLocationSwimmingOffset, fCombatTargetLocationWidthMax, fCombatTargetLocationWidthMin, fCombatTargetLocationWidthSizeMult, fCombatTeammateFollowRadiusBase, fCombatTeammateFollowRadiusMin, fCombatTeammateFollowRadiusMult, fCombatThreatAnticipateTime, fCombatThreatAvoidCost, fCombatThreatBufferRadius, fCombatThreatCacheVelocityTime, fCombatThreatDangerousObjectHealth, fCombatThreatExplosiveObjectThreatTime, fCombatThreatExtrudeTime, fCombatThreatExtrudeVelocityThreshold, fCombatThreatNegativeExtrudeTime, fCombatThreatProximityExplosionAvoidTime, fCombatThreatRatioUpdateTime, fCombatThreatSignificantScore, fCombatThreatTimedExplosionLength, fCombatThreatUpdateTimeMax, fCombatThreatUpdateTimeMin, fCombatThreatViewCone, fCombatUnarmedCritDamageMult, fCombatUnreachableTargetCheckTime, fCombatVulnerabilityMod, fCombatYieldRetryTime, fCombatYieldTime, fCommentOnPlayerActionsTimer, fCommentOnPlayerKnockingThings, fConcussionTimer, fConeProjectileEnvironmentDistance, fConeProjectileEnvironmentTimer, fConeProjectileForceBase, fConeProjectileForceMult, fConeProjectileForceMultAngular, fConeProjectileForceMultLinear, fConeProjectileWaterScaleMult, fCoverEvaluationLastSeenExpireTime, fCoverFiredProjectileExpireTime, fCoverFiringReloadClipPercent, fCoverWaitReloadClipPercent, fCoveredAdvanceMinAdvanceDistanceMax, fCoveredAdvanceMinAdvanceDistanceMin, fCrafting, fCreatureDefaultTurningSpeed, fCreditsScrollSpeed, fCrimeAlarmRespMult, fCrimeDispAttack, fCrimeDispMurder, fCrimeDispPersonal, fCrimeDispPickpocket, fCrimeDispSteal, fCrimeDispTresspass, fCrimeFavorMult, fCrimeGoldSkillPenaltyMult, fCrimeGoldSteal, fCrimePersonalRegardMult, fCrimeRegardMult, fCrimeSoundBase, fCrimeSoundMult, fCrimeWitnessRegardMult, fDOFDistanceMult, fDamageArmConditionBase, fDamageArmConditionMult, fDamageGunWeapCondBase, fDamageGunWeapCondMult, fDamageMeleeWeapCondBase, fDamageMeleeWeapCondMult, fDamagePCSkillMax, fDamagePCSkillMin, fDamageSkillMax, fDamageSkillMin, fDamageSneakAttackMult, fDamageStrengthBase, fDamageStrengthMult, fDamageToArmorPercentage, fDamageToWeaponEnergyMult, fDamageToWeaponGunMult, fDamageToWeaponLauncherMult, fDamageToWeaponMeleeMult, fDamageUnarmedPenalty, fDamageWeaponMult, fDamagedAVRegenDelay, fDamagedHealthRegenDelay, fDamagedMagickaRegenDelay, fDamagedStaminaRegenDelay, fDangerousObjectExplosionDamage, fDangerousObjectExplosionRadius, fDangerousProjectileExplosionDamage, fDangerousProjectileExplosionRadius, fDaytimeColorExtension, fDeadReactionDistance, fDeathForceDamageMax, fDeathForceDamageMin, fDeathForceForceMax, fDeathForceForceMin, fDeathForceMassBase, fDeathForceMassMult, fDeathForceRangedDamageMax, fDeathForceRangedDamageMin, fDeathForceRangedForceMax, fDeathForceRangedForceMin, fDeathForceSpellImpactMult, fDeathSoundMaxDistance, fDebrisFadeTime, fDecalLOD, fDecapitateBloodTime, fDefault, fDefaultAngleTolerance, fDefaultBowSpeedBonus, fDemandBase, fDemandMult, fDetectEventDistanceNPC, fDetectEventDistancePlayer, fDetectEventDistanceVeryLoudMult, fDetectEventSneakDistanceVeryLoud, fDetectProjectileDistanceNPC, fDetectProjectileDistancePlayer, fDetectionActionTimer, fDetectionCombatNonTargetDistanceMult, fDetectionCommentTimer, fDetectionEventExpireTime, fDetectionLOSDistanceAngle, fDetectionLOSDistanceMultExterior, fDetectionLOSDistanceMultInterior, fDetectionLargeActorSizeMult, fDetectionNightEyeBonus, fDetectionSneakLightMod, fDetectionStateExpireTime, fDetectionUpdateTimeMax, fDetectionUpdateTimeMaxComplex, fDetectionUpdateTimeMin, fDetectionUpdateTimeMinComplex, fDetectionViewCone, fDialogFocalDepthRange, fDialogFocalDepthStrength, fDialogSpeechDelaySeconds, fDialogZoomInSeconds, fDialogZoomOutSeconds, fDialogueHardStopAngle, fDialogueSoftStopAngle, fDiffMultHPByPCE, fDiffMultHPByPCH, fDiffMultHPByPCN, fDiffMultHPByPCVE, fDiffMultHPByPCVH, fDiffMultHPToPCE, fDiffMultHPToPCH, fDiffMultHPToPCN, fDiffMultHPToPCVE, fDiffMultHPToPCVH, fDiffMultXPE, fDiffMultXPH, fDiffMultXPN, fDiffMultXPVE, fDiffMultXPVH, fDifficultyDamageMultiplier, fDifficultyDefaultValue, fDifficultyMaxValue, fDifficultyMinValue, fDisarmedPickupWeaponDistanceMult, fDisenchantSkillUse, fDistanceAutomaticallyActivateDoor, fDistanceExteriorReactCombat, fDistanceFadeActorAutoLoadDoor, fDistanceInteriorReactCombat, fDistanceProjectileExplosionDetection, fDistancetoPlayerforConversations, fDrinkRepeatRate, fDyingTimer, fEmbeddedWeaponSwitchChance, fEmbeddedWeaponSwitchTime, fEnchantingCostExponent, fEnchantingRuleOfFive, fEnchantingRuleOfTen, fEnchantingRuleOfTwo, fEnchantingSkillCostBase, fEnchantingSkillCostMult, fEnchantingSkillCostScale, fEnchantingSkillFactor, fEnchantmentEffectPointsMult, fEnchantmentGoldMult, fEnchantmentPointsMult, fEnemyHealthBarTimer, fEnvMapLOD, fEssentialDeathTime, fEssentialDownCombatHealthRegenMult, fEssentialHealthPercentReGain, fEssentialNPCMinimumHealth, fEssentialNonCombatHealRateBonus, fEvaluatePackageTimer, fEvaluateProcedureTimer, fExplodeLimbRemovalDelay, fExplodeLimbRemovalDelayVATS, fExplosionForceClutterUpBias, fExplosionForceKnockdownMinimum, fExplosionForceMultAngular, fExplosionForceMultLinear, fExplosionImageSpaceSwapPower, fExplosionKnockStateExplodeDownTime, fExplosionLOSBuffer, fExplosionLOSBufferDistance, fExplosionMaxImpulse, fExplosionSourceRefMult, fExplosionSplashRadius, fExplosionWaterRadiusRatio, fExplosiveProjectileBlockedResetTime, fExplosiveProjectileBlockedWaitTime, fExpressionChangePerSec, fExpressionStrengthAdd, fEyeEnvMapLOD, fEyeHeadingMaxOffsetEmotionAngry, fEyeHeadingMaxOffsetEmotionFear, fEyeHeadingMaxOffsetEmotionHappy, fEyeHeadingMaxOffsetEmotionNeutral, fEyeHeadingMaxOffsetEmotionSad, fEyeHeadingMinOffsetEmotionAngry, fEyeHeadingMinOffsetEmotionFear, fEyeHeadingMinOffsetEmotionHappy, fEyeHeadingMinOffsetEmotionNeutral, fEyeHeadingMinOffsetEmotionSad, fEyePitchMaxOffsetEmotionAngry, fEyePitchMaxOffsetEmotionFear, fEyePitchMaxOffsetEmotionHappy, fEyePitchMaxOffsetEmotionNeutral, fEyePitchMaxOffsetEmotionSad, fEyePitchMinOffsetEmotionAngry, fEyePitchMinOffsetEmotionFear, fEyePitchMinOffsetEmotionHappy, fEyePitchMinOffsetEmotionNeutral, fEyePitchMinOffsetEmotionSad, fFallLegDamageMult, fFastTravelSpeedMult, fFastWalkInterpolationBetweenWalkAndRun, fFavorCostActivator, fFavorCostAttack, fFavorCostAttackCrimeMult, fFavorCostLoadDoor, fFavorCostNonLoadDoor, fFavorCostOwnedDoorMult, fFavorCostStealContainerCrime, fFavorCostStealContainerMult, fFavorCostStealObjectMult, fFavorCostTakeObject, fFavorCostUnlockContainer, fFavorCostUnlockDoor, fFavorEventStopDistance, fFavorEventTriggerDistance, fFavorRequestPickDistance, fFavorRequestRadius, fFavorRequestWaitTimer, fFirstPersonLookAtVertOffset, fFleeDistanceExterior, fFleeDistanceInterior, fFleeDoneDistanceExterior, fFleeDoneDistanceInterior, fFleeIsSafeTimer, fFloatQuestMarkerFloatHeight, fFloatQuestMarkerMaxDistance, fFloatQuestMarkerMinDistance, fFlyingActorDefaultTurningSpeed, fFollowExtraCatchUpSpeedMult, fFollowMatchSpeedZoneWidth, fFollowRunMaxSpeedupMultiplier, fFollowRunMinSlowdownMultiplier, fFollowSlowdownZoneWidth, fFollowSpaceBetweenFollowers, fFollowStartSprintDistance, fFollowStopZoneMinMult, fFollowWalkMaxSpeedupMultiplier, fFollowWalkMinSlowdownMultiplier, fFollowWalkZoneMult, fFollowerSpacingAtDoors, fFriendHitTimer, fFriendMinimumLastHitTime, fFurnitureMarkerAngleTolerance, fFurnitureScaleAnimDurationNPC, fFurnitureScaleAnimDurationPlayer, fGameplayImpulseMinMass, fGameplayImpulseMultBiped, fGameplayImpulseMultClutter, fGameplayImpulseMultDebrisLarge, fGameplayImpulseMultProp, fGameplayImpulseMultTrap, fGameplayImpulseScale, fGameplaySpeakingEmotionMaxChangeValue, fGameplaySpeakingEmotionMinChangeValue, fGameplayVoiceFilePadding, fGameplayiSpeakingEmotionMaxDeltaChange, fGameplayiSpeakingEmotionMinDeltaChange, fGetHitPainMult, fGrabMaxWeightRunning, fGrabMaxWeightWalking, fGrenadeAgeMax, fGrenadeFriction, fGrenadeHighArcSpeedPercentage, fGrenadeRestitution, fGrenadeThrowHitFractionThreshold, fGuardPackageAttackRadiusMult, fGunDecalCameraDistance, fGunParticleCameraDistance, fGunReferenceSkill, fGunShellCameraDistance, fGunShellDirectionRandomize, fGunShellEjectSpeed, fGunShellLifetime, fGunShellRotateRandomize, fGunShellRotateSpeed, fGunSpreadArmBase, fGunSpreadArmMult, fGunSpreadCondBase, fGunSpreadCondMult, fGunSpreadCrouchBase, fGunSpreadCrouchMult, fGunSpreadDriftBase, fGunSpreadDriftMult, fGunSpreadHeadBase, fGunSpreadHeadMult, fGunSpreadIronSightsBase, fGunSpreadIronSightsMult, fGunSpreadNPCArmBase, fGunSpreadNPCArmMult, fGunSpreadRunBase, fGunSpreadRunMult, fGunSpreadSkillBase, fGunSpreadSkillMult, fGunSpreadWalkBase, fGunSpreadWalkMult, fHUDCompassLocationMaxDist, fHUDOpacity, fHandDamageSkillBase, fHandDamageSkillMult, fHandDamageStrengthBase, fHandDamageStrengthMult, fHandHealthMax, fHandHealthMin, fHandReachDefault, fHavokTauRatio, fHazardDropMaxDistance, fHazardMaxWaitTime, fHazardSpacingMult, fHeadTrackSpeedMax, fHeadTrackSpeedMaxAngle, fHeadTrackSpeedMin, fHeadTrackSpeedMinAngle, fHeadingMarkerAngleTolerance, fHealthRegenDelayMax, fHorseMountOffsetX, fHorseMountOffsetY, fHostileActorExteriorDistance, fHostileActorInteriorDistance, fHostileFlyingActorExteriorDistance, fIdleChatterCommentTimer, fIdleChatterCommentTimerMax, fIdleMarkerAngleTolerance, fImpactShaderMaxDistance, fImpactShaderMaxMagnitude, fImpactShaderMinMagnitude, fIntimidateConfidenceMultAverage, fIntimidateConfidenceMultBrave, fIntimidateConfidenceMultCautious, fIntimidateConfidenceMultCowardly, fIntimidateConfidenceMultFoolhardy, fIntimidateSpeechcraftCurve, fInventory, fInventoryLight, fInventoryMenuLight, fIronSightsDOFDistance, fIronSightsDOFRange, fIronSightsDOFStrengthCap, fIronSightsDOFSwitchSeconds, fIronSightsFOVTimeChange, fIronSightsGunMotionBlur, fIronSightsMotionBlur, fItemPointsMult, fItemRepairCostMult, fJogInterpolationBetweenWalkAndRun, fJumpDoubleMult, fJumpFallHeightExponent, fJumpFallHeightExponentNPC, fJumpFallHeightMin, fJumpFallHeightMinNPC, fJumpFallHeightMult, fJumpFallHeightMultNPC, fJumpFallRiderMult, fJumpFallSkillBase, fJumpFallSkillMult, fJumpFallVelocityMin, fJumpHeightMin, fJumpMoveBase, fJumpMoveMult, fJumpSwimmingMult, fKarmaModKillingEvilActor, fKarmaModMurderingNonEvilCreature, fKarmaModMurderingNonEvilNPC, fKarmaModStealing, fKillCamBaseOdds, fKillCamLevelBias, fKillCamLevelFactor, fKillCamLevelMaxBias, fKillMoveMaxDuration, fKillWitnessesTimerSetting, fKnockbackAgilBase, fKnockbackAgilMult, fKnockbackDamageBase, fKnockbackDamageMult, fKnockbackForceMax, fKnockbackTime, fKnockdownAgilBase, fKnockdownAgilMult, fKnockdownBaseHealthThreshold, fKnockdownChance, fKnockdownCurrentHealthThreshold, fKnockdownDamageBase, fKnockdownDamageMult, fLargeProjectilePickBufferSize, fLargeProjectileSize, fLevelUpCarryWeightMod, fLightRecalcTimer, fLightRecalcTimerPlayer, fLoadingWheelScale, fLockLevelBase, fLockLevelMult, fLockPickBreakBase, fLockPickBreakMult, fLockPickQualityBase, fLockPickQualityMult, fLockSkillBase, fLockSkillMult, fLockTrapGoOffBase, fLockTrapGoOffMult, fLockpickBreakAdept, fLockpickBreakApprentice, fLockpickBreakExpert, fLockpickBreakMaster, fLockpickBreakNovice, fLockpickBreakSkillBase, fLockpickBreakSkillMult, fLockpickBrokenPicksMult, fLockpickSkillPartialPickBase, fLockpickSkillPartialPickMult, fLockpickSkillSweetSpotBase, fLockpickSkillSweetSpotMult, fLookDownDisableBlinkingAmt, fLookGraphX, fLookGraphY, fLowHealthTutorialPercentage, fLowLevelNPCBaseHealthMult, fLowMagickaTutorialPercentage, fLowStaminaTutorialPercentage, fMagic, fMagicAbsorbDistanceReachMult, fMagicAbsorbVisualTimer, fMagicAccumulatingModifierEffectHoldDuration, fMagicAreaBaseCostMult, fMagicAreaScale, fMagicAreaScaleMax, fMagicAreaScaleMin, fMagicBarrierDepth, fMagicBarrierHeight, fMagicBarrierSpacing, fMagicBoltDuration, fMagicBoltSegmentLength, fMagicCEEnchantMagOffset, fMagicCasterPCSkillCostBase, fMagicCasterPCSkillCostMult, fMagicCasterSkillCostBase, fMagicCasterSkillCostMult, fMagicChainExplosionEffectivenessDelta, fMagicCloudAreaMin, fMagicCloudDurationMin, fMagicCloudFindTargetTime, fMagicCloudLifeScale, fMagicCloudSizeScale, fMagicCloudSlowdownRate, fMagicCloudSpeedBase, fMagicCloudSpeedScale, fMagicCostScale, fMagicDefaultAccumulatingModifierEffectRate, fMagicDefaultTouchDistance, fMagicDiseaseTransferBase, fMagicDiseaseTransferMult, fMagicDispelMagnitudeMult, fMagicDualCastingCostBase, fMagicDualCastingCostMult, fMagicDualCastingEffectivenessBase, fMagicDualCastingEffectivenessMult, fMagicDualCastingTimeBase, fMagicDualCastingTimeMult, fMagicDurMagBaseCostMult, fMagicEnchantmentChargeBase, fMagicEnchantmentChargeMult, fMagicEnchantmentDrainBase, fMagicEnchantmentDrainMult, fMagicExplosionAgilityMult, fMagicExplosionClutterMult, fMagicExplosionIncorporealMult, fMagicExplosionIncorporealTime, fMagicExplosionPowerBase, fMagicExplosionPowerMax, fMagicExplosionPowerMin, fMagicExplosionPowerMult, fMagicGuideSpacing, fMagicLightForwardOffset, fMagicLightHeightOffset, fMagicLightRadiusBase, fMagicLightSideOffset, fMagicNightEyeAmbient, fMagicPCSkillCostScale, fMagicPlayerMinimumInvisibility, fMagicPostDrawCastDelay, fMagicProjectileMaxDistance, fMagicRangeTargetCostMult, fMagicResistActorSkillBase, fMagicResistActorSkillMult, fMagicResistTargetWillpowerBase, fMagicResistTargetWillpowerMult, fMagicSkillCostScale, fMagicSummonMaxAppearTime, fMagicTelekinesiDistanceMult, fMagicTelekinesisBaseDistance, fMagicTelekinesisComplexMaxForce, fMagicTelekinesisComplexObjectDamping, fMagicTelekinesisComplexSpringDamping, fMagicTelekinesisComplexSpringElasticity, fMagicTelekinesisDamageBase, fMagicTelekinesisDamageMult, fMagicTelekinesisDistanceMin, fMagicTelekinesisDualCastDamageMult, fMagicTelekinesisDualCastThrowMult, fMagicTelekinesisLiftPowerMult, fMagicTelekinesisMaxForce, fMagicTelekinesisMoveAccelerate, fMagicTelekinesisMoveBase, fMagicTelekinesisMoveMax, fMagicTelekinesisObjectDamping, fMagicTelekinesisSpringDamping, fMagicTelekinesisSpringElasticity, fMagicTelekinesisThrow, fMagicTelekinesisThrowAccelerate, fMagicTelekinesisThrowMax, fMagicTrackingLimit, fMagicTrackingLimitComplex, fMagicTrackingMultBall, fMagicTrackingMultBolt, fMagicTrackingMultFog, fMagicUnitsPerFoot, fMagicVACNoPartTargetedMult, fMagicVACPartTargetedMult, fMagicWardPowerMaxBase, fMagicWardPowerMaxMult, fMagickaRegenDelayMax, fMagickaReturnBase, fMagickaReturnMult, fMapMarkerMaxPercentSize, fMapMarkerMinFadeAlpha, fMapMarkerMinPercentSize, fMapQuestMarkerMaxPercentSize, fMapQuestMarkerMinFadeAlpha, fMapQuestMarkerMinPercentSize, fMasserAngleFadeEnd, fMasserAngleFadeStart, fMasserAngleShadowEarlyFade, fMasserSpeed, fMasserZOffset, fMaxArmorRating, fMaxSandboxRescanSeconds, fMaxSellMult, fMaximumWind, fMeleeMovementRestrictionsUpdateTime, fMeleeSweepViewAngleMult, fMeshLODLevel, fMinBuyMult, fMinDistanceUseHorse, fMinSandboxRescanSeconds, fMineAgeMax, fMineExteriorRadiusMult, fMinesBlinkFast, fMinesBlinkMax, fMinesBlinkSlow, fMinesDelayMin, fModelReferenceEffectMaxWaitTime, fMostCommonProjectileCollisionRadius, fMotionBlur, fMountedMaxLookingDown, fMoveCharRunBase, fMoveCharWalkBase, fMoveEncumEffect, fMoveEncumEffectNoWeapon, fMoveFlyRunMult, fMoveFlyWalkMult, fMoveGraphX, fMoveGraphY, fMoveSprintMult, fMoveSwimMult, fMoveWeightMax, fMoveWeightMin, fMovementNearTargetAvoidCost, fMovementNearTargetAvoidRadius, fMovementTargetAvoidCost, fMovementTargetAvoidRadius, fMovementTargetAvoidRadiusMult, fNPCAttributeHealthMult, fNPCBaseMagickaMult, fNPCHealthLevelBonus, fNear, fObjectHitH, fObjectHitTwoHandReach, fObjectHitWeaponReach, fObjectMotionBlur, fObjectWeightPickupDetectionMult, fOutOfBreathStaminaRegenDelay, fPCBaseHealthMult, fPCBaseMagickaMult, fPCHealthLevelBonus, fPainDelay, fPartialPickAverage, fPartialPickEasy, fPartialPickHard, fPartialPickVeryEasy, fPartialPickVeryHard, fPerceptionMult, fPerkHeavyArmorExpertSpeedMult, fPerkHeavyArmorJourneymanDamageMult, fPerkHeavyArmorMasterSpeedMult, fPerkHeavyArmorNoviceDamageMult, fPerkHeavyArmorSinkGravityMult, fPerkLightArmorExpertSpeedMult, fPerkLightArmorJourneymanDamageMult, fPerkLightArmorMasterRatingMult, fPerkLightArmorNoviceDamageMult, fPersAdmireAggr, fPersAdmireConf, fPersAdmireEner, fPersAdmireIntel, fPersAdmirePers, fPersAdmireResp, fPersAdmireStre, fPersAdmireWillp, fPersBoastAggr, fPersBoastConf, fPersBoastEner, fPersBoastIntel, fPersBoastPers, fPersBoastResp, fPersBoastStre, fPersBoastWillp, fPersBullyAggr, fPersBullyConf, fPersBullyEner, fPersBullyIntel, fPersBullyPers, fPersBullyResp, fPersBullyStre, fPersBullyWillp, fPersJokeAggr, fPersJokeConf, fPersJokeEner, fPersJokeIntel, fPersJokePers, fPersJokeResp, fPersJokeStre, fPersJokeWillp, fPersuasionAccuracyMaxDisposition, fPersuasionAccuracyMaxSelect, fPersuasionAccuracyMinDispostion, fPersuasionAccuracyMinSelect, fPersuasionBaseValueMaxDisposition, fPersuasionBaseValueMaxSelect, fPersuasionBaseValueMinDispostion, fPersuasionBaseValueMinSelect, fPersuasionBaseValueShape, fPersuasionMaxDisposition, fPersuasionMaxInput, fPersuasionMaxSelect, fPersuasionMinDispostion, fPersuasionMinInput, fPersuasionMinPercentCircle, fPersuasionMinSelect, fPersuasionShape, fPhysicsDamage, fPhysicsDamageSpeedBase, fPhysicsDamageSpeedMin, fPhysicsDamageSpeedMult, fPickLevelBase, fPickLevelMult, fPickMaxAngle, fPickNumBase, fPickNumMult, fPickPocketActorSkillBase, fPickPocketActorSkillMult, fPickPocketAmountBase, fPickPocketAmountMult, fPickPocketDetected, fPickPocketMaxChance, fPickPocketMinChance, fPickPocketTargetSkillBase, fPickPocketTargetSkillMult, fPickPocketWeightBase, fPickPocketWeightMult, fPickSpring, fPickUpWeaponDelay, fPickpocketSkillUsesCurve, fPickupItemDistanceFudge, fPickupWeaponDistanceMinMaxDPSMult, fPickupWeaponMeleeDistanceMax, fPickupWeaponMeleeDistanceMin, fPickupWeaponMeleeWeaponDPSMult, fPickupWeaponMinDPSImprovementPercent, fPickupWeaponRangedDistanceMax, fPickupWeaponRangedDistanceMin, fPickupWeaponRangedMeleeDPSRatioThreshold, fPickupWeaponTargetUnreachableDistanceMult, fPickupWeaponUnarmedDistanceMax, fPickupWeaponUnarmedDistanceMin, fPlayerDeathReloadTime, fPlayerDetectActorValue, fPlayerDetectionSneakBase, fPlayerDetectionSneakMult, fPlayerDropDistance, fPlayerHealthHeartbeatFast, fPlayerHealthHeartbeatSlow, fPlayerMaxResistance, fPlayerTargetCombatDistance, fPlayerTeleportFadeSeconds, fPlayerVelocityCacheTime, fPlayerVelocitySampleInterval, fPlayerVelocitySampleTime, fPotionGoldValueMult, fPotionMortPestleMult, fPotionT, fPowerAttackCoolDownTime, fPowerAttackDefaultBonus, fPowerAttackStaminaPenalty, fProjectileCollisionImpulseScale, fProjectileDefaultTracerRange, fProjectileDeflectionTime, fProjectileInventoryGrenadeFreakoutTime, fProjectileInventoryGrenadeTimer, fProjectileKnockMinMass, fProjectileKnockMultBiped, fProjectileKnockMultClutter, fProjectileKnockMultProp, fProjectileKnockMultTrap, fProjectileMaxDistance, fProjectileReorientTracerMin, fQuestCinematicCharacterFadeIn, fQuestCinematicCharacterFadeInDelay, fQuestCinematicCharacterFadeOut, fQuestCinematicCharacterRemain, fQuestCinematicObjectiveFadeIn, fQuestCinematicObjectiveFadeInDelay, fQuestCinematicObjectiveFadeOut, fQuestCinematicObjectivePauseTime, fQuestCinematicObjectiveScrollTime, fRandomSceneAgainMaxTime, fRandomSceneAgainMinTime, fReEquipArmorTime, fRechargeGoldMult, fReflectedAbsorbChanceReduction, fRelationshipBase, fRelationshipMult, fRemoteCombatMissedAttack, fRemoveExcessComplexDeadTime, fRemoveExcessDeadTime, fRepairMax, fRepairMin, fRepairScavengeMult, fRepairSkillBase, fRepairSkillMax, fReservationExpirationSeconds, fResistArrestTimer, fRockitDamageBonusWeightMin, fRockitDamageBonusWeightMult, fRoomLightingTransitionDuration, fRumbleBlockStrength, fRumbleBlockTime, fRumbleHitBlockedStrength, fRumbleHitBlockedTime, fRumbleHitStrength, fRumbleHitTime, fRumblePainStrength, fRumblePainTime, fRumbleShakeRadiusMult, fRumbleShakeTimeMult, fRumbleStruckStrength, fRumbleStruckTime, fSandBoxDelayEvalSeconds, fSandBoxExtraDialogueRange, fSandBoxInterMarkerMinDist, fSandBoxRadiusHysteresis, fSandBoxSearchRadius, fSandboxBreakfastMax, fSandboxBreakfastMin, fSandboxCylinderBottom, fSandboxCylinderTop, fSandboxDinnerMax, fSandboxDinnerMin, fSandboxDurationBase, fSandboxDurationMultEatSitting, fSandboxDurationMultEatStanding, fSandboxDurationMultFurniture, fSandboxDurationMultIdleMarker, fSandboxDurationMultSitting, fSandboxDurationMultSleeping, fSandboxDurationMultWandering, fSandboxDurationRangeMult, fSandboxEnergyMult, fSandboxEnergyMultEatSitting, fSandboxEnergyMultEatStanding, fSandboxEnergyMultFurniture, fSandboxEnergyMultIdleMarker, fSandboxEnergyMultSitting, fSandboxEnergyMultSleeping, fSandboxEnergyMultWandering, fSandboxLunchMax, fSandboxLunchMin, fSandboxMealDurationMax, fSandboxMealDurationMin, fSandboxSleepDurationMax, fSandboxSleepDurationMin, fSandboxSleepStartMax, fSandboxSleepStartMin, fSayOncePerDayInfoTimer, fScrollCostMult, fSecondsBetweenWindowUpdate, fSecundaAngleFadeEnd, fSecundaAngleFadeStart, fSecundaAngleShadowEarlyFade, fSecundaSpeed, fSecundaZOffset, fShieldBaseFactor, fShieldBashMax, fShieldBashMin, fShieldBashPCMax, fShieldBashPCMin, fShieldBashSkillUseBase, fShieldBashSkillUseMult, fShieldScalingFactor, fShockBoltGrowWidth, fShockBoltSmallWidth, fShockBoltsLength, fShockBoltsRadius, fShockBoltsRadiusStrength, fShockBranchBoltsRadius, fShockBranchBoltsRadiusStrength, fShockBranchLifetime, fShockBranchSegmentLength, fShockBranchSegmentVariance, fShockCastVOffset, fShockCoreColorB, fShockCoreColorG, fShockCoreColorR, fShockGlowColorB, fShockGlowColorG, fShockGlowColorR, fShockSegmentLength, fShockSegmentVariance, fShockSubSegmentVariance, fShoutTime, fShoutTimeout, fSittingMaxLookingDown, fSkillUsageLockPickAverage, fSkillUsageLockPickBroken, fSkillUsageLockPickEasy, fSkillUsageLockPickHard, fSkillUsageLockPickVeryEasy, fSkillUsageLockPickVeryHard, fSkillUsageRechargeMult, fSkillUsageSneakHidden, fSkillUsageSneakPerSecond, fSkillUseCurve, fSkinnedDecalLOD, fSkyCellRefFadeDistance, fSmallBumpSpeed, fSmithingArmorMax, fSmithingConditionFactor, fSmithingWeaponMax, fSneakActionMult, fSneakAlertMod, fSneakAmbushNonTargetMod, fSneakAmbushTargetMod, fSneakAttackSkillUsageMelee, fSneakAttackSkillUsageRanged, fSneakBaseValue, fSneakCombatMod, fSneakDetectionSizeLarge, fSneakDetectionSizeNormal, fSneakDetectionSizeSmall, fSneakDetectionSizeVeryLarge, fSneakDistanceAttenuationExponent, fSneakEquippedWeightBase, fSneakEquippedWeightMult, fSneakExteriorDistanceMult, fSneakFlyingDistanceMult, fSneakLightExteriorMult, fSneakLightMoveMult, fSneakLightMult, fSneakLightRunMult, fSneakMaxDistance, fSneakNoticeMin, fSneakPerceptionSkillMax, fSneakPerceptionSkillMin, fSneakRunningMult, fSneakSizeBase, fSneakSkillMult, fSneakSleepBonus, fSneakSleepMod, fSneakSoundLosMult, fSneakSoundsMult, fSneakStealthBoyMult, fSortActorDistanceListTimer, fSpeechCraftBase, fSpeechCraftMult, fSpeechDelay, fSpeechcraftFavorMax, fSpeechcraftFavorMin, fSpellCastingDetectionHitActorMod, fSpellCastingDetectionMod, fSpellmakingGoldMult, fSplashScale, fSplashSoundHeavy, fSplashSoundLight, fSplashSoundMedium, fSplashSoundOutMult, fSplashSoundTimer, fSplashSoundVelocityMult, fSprintEncumbranceMult, fSprintStaminaDrainMult, fSprintStaminaWeightBase, fSprintStaminaWeightMult, fStagger, fStaggerAttackBase, fStaggerAttackMult, fStaggerBlockAttackBase, fStaggerBlockAttackMult, fStaggerBlockAttackShieldBase, fStaggerBlockAttackShieldMult, fStaggerBlockBase, fStaggerBlockMult, fStaggerBlockingMult, fStaggerMassBase, fStaggerMassMult, fStaggerMassOffsetBase, fStaggerMassOffsetMult, fStaggerMaxDuration, fStaggerMin, fStaggerPlayerMassMult, fStaggerRecoilingMult, fStaggerRunningMult, fStaggerShieldMult, fStaminaAttackWeaponBase, fStaminaAttackWeaponMult, fStaminaBashBase, fStaminaBlockBase, fStaminaBlockDmgMult, fStaminaBlockStaggerMult, fStaminaPowerBashBase, fStaminaRegenDelayMax, fStarsRotateDays, fStarsRotateXAxis, fStarsRotateYAxis, fStatsCameraFOV, fStatsCameraNearDistance, fStatsHealthLevelMult, fStatsHealthStartMult, fStatsLineScale, fStatsRotationRampTime, fStatsRotationSpeedMax, fStatsSkillsLookAtX, fStatsSkillsLookAtY, fStatsSkillsLookAtZ, fStatsStarCameraOffsetX, fStatsStarCameraOffsetY, fStatsStarCameraOffsetZ, fStatsStarLookAtX, fStatsStarLookAtY, fStatsStarLookAtZ, fStatsStarScale, fStatsStarXIncrement, fStatsStarYIncrement, fStatsStarZIncrement, fStatsStarZInitialOffset, fSubSegmentVariance, fSubmergedAngularDamping, fSubmergedLODDistance, fSubmergedLinearDampingH, fSubmergedLinearDampingV, fSubmergedMaxSpeed, fSubmergedMaxWaterDistance, fSubtitleSpeechDelay, fSummonDistanceCheckThreshold, fSummonedCreatureFadeOutSeconds, fSummonedCreatureMaxFollowDist, fSummonedCreatureMinFollowDist, fSummonedCreatureSearchRadius, fSunAlphaTransTime, fSunDirXExtreme, fSunMinimumGlareScale, fSunReduceGlareSpeed, fSunXExtreme, fSunYExtreme, fSunZExtreme, fSweetSpotAverage, fSweetSpotEasy, fSweetSpotHard, fSweetSpotVeryEasy, fSweetSpotVeryHard, fTakeBackTimerSetting, fTargetMovedCoveredMoveRepathLength, fTargetMovedRepathLength, fTargetMovedRepathLengthLow, fTeammateAggroOnDistancefromPlayer, fTeleportDoorActivateDelayTimer, fTemperingSkillUseMult, fTimerForPlayerFurnitureEnter, fTorchEvaluationTimer, fTorchLightLevelInterior, fTorchLightLevelMorning, fTorchLightLevelNight, fTrackDeadZoneXY, fTrackDeadZoneZ, fTrackEyeXY, fTrackEyeZ, fTrackFudgeXY, fTrackFudgeZ, fTrackJustAcquiredDuration, fTrackMaxZ, fTrackMinZ, fTrackSpeed, fTrackXY, fTrainingBaseCost, fTrainingMultCost, fTriggerAvoidPlayerDistance, fUIAltLogoModel, fUILogoModel, fUIMistMenu, fUIMistModel, fUIPlayerSceneLight, fUIRaceSexLight, fUnarmedCreatureDPSMult, fUnarmedDamageMult, fUnarmedNPCDPSMult, fUnderwaterFullDepth, fVATSAutomaticMeleeDamageMult, fVATSCamTransRBDownStart, fVATSCamTransRBRampDown, fVATSCamTransRBRampup, fVATSCamTransRBStart, fVATSCamTransRBStrengthCap, fVATSCamZoomInTime, fVATSCameraMaxTime, fVATSCameraMinTime, fVATSCriticalChanceBonus, fVATSDOFRange, fVATSDOFStrengthCap, fVATSDOFSwitchSeconds, fVATSDamageToWeaponMult, fVATSDestructibleMult, fVATSDistanceFactor, fVATSGrenadeChanceMult, fVATSGrenadeDistAimZMult, fVATSGrenadeRangeMin, fVATSGrenadeRangeMult, fVATSGrenadeSkillFactor, fVATSGrenadeSuccessExplodeTimer, fVATSGrenadeSuccessMaxDistance, fVATSGrenadeTargetArea, fVATSGrenadeTargetMelee, fVATSH, fVATSHitChanceMult, fVATSImageSpaceTransitionTime, fVATSLimbSelectCamPanTime, fVATSMaxChance, fVATSMaxEngageDistance, fVATSMeleeArmConditionBase, fVATSMeleeArmConditionMult, fVATSMeleeChanceMult, fVATSMeleeMaxDistance, fVATSMeleeReachMult, fVATSMeleeWarpDistanceMult, fVATSMoveCameraLimbMult, fVATSMoveCameraLimbPercent, fVATSMoveCameraMaxSpeed, fVATSMoveCameraXPercent, fVATSMoveCameraYPercent, fVATSParalyzePalmChance, fVATSPlaybackDelay, fVATSPlayerDamageMult, fVATSPlayerMagicTimeSlowdownMult, fVATSPlayerTimeUpdateMult, fVATSRadialRampup, fVATSRadialStart, fVATSRadialStrength, fVATSRangeSpreadMax, fVATSRangeSpreadUncertainty, fVATSScreenPercentFactor, fVATSShotBurstTime, fVATSShotLongBurstTime, fVATSSkillFactor, fVATSSmartCameraCheckHeight, fVATSSmartCameraCheckStepCount, fVATSSmartCameraCheckStepDistance, fVATSSpreadMult, fVATSStealthMult, fVATSStrangerDistance, fVATSStrangerOdds, fVATSTargetActorHeightPanMult, fVATSTargetActorZMultFar, fVATSTargetActorZMultFarDist, fVATSTargetActorZMultNear, fVATSTargetFOVMinDist, fVATSTargetFOVMinFOV, fVATSTargetFOVMultFar, fVATSTargetFOVMultFarDist, fVATSTargetFOVMultNear, fVATSTargetRotateMult, fVATSTargetScanRotateMult, fVATSTargetSelectCamPanTime, fVATSTargetTimeUpdateMult, fVATSThrownWeaponRangeMult, fValueofItemForNoOwnership, fVatsShotgunSpreadRatio, fVoiceRateBase, fWardAngleForExplosions, fWarningTimer, fWaterKnockdownSizeLarge, fWaterKnockdownSizeNormal, fWaterKnockdownSizeSmall, fWaterKnockdownSizeVeryLarge, fWaterKnockdownVelocity, fWeaponBashMax, fWeaponBashMin, fWeaponBashPCMax, fWeaponBashPCMin, fWeaponBashSkillUseBase, fWeaponBashSkillUseMult, fWeaponBlockSkillUseBase, fWeaponBlockSkillUseMult, fWeaponClutterKnockBipedScale, fWeaponClutterKnockMaxWeaponMass, fWeaponClutterKnockMinClutterMass, fWeaponClutterKnockMult, fWeaponConditionCriticalChanceMult, fWeaponConditionJam, fWeaponConditionRateOfFire, fWeaponConditionReloadJam, fWeaponConditionSpread, fWeaponTwoHandedAnimationSpeedMult, fWeatherFlashAmbient, fWeatherFlashDirectional, fWeatherFlashDuration, fWeatherTransAccel, fWeatherTransMax, fWeatherTransMin, fWortFailSkillUseMagnitude, fWortStrMult, fWortalchmult, fWortcraftChanceIntDenom, fWortcraftChanceLuckDenom, fWortcraftStrChanceDenom, fWortcraftStrCostDenom, fXPLevelUpBase, fXPLevelUpMult, fXPPerSkillRank, fZKeyComplexHelperMinDistance, fZKeyComplexHelperScale, fZKeyComplexHelperWeightMax, fZKeyComplexHelperWeightMin, fZKeyHeavyWeight, fZKeyMaxContactDistance, fZKeyMaxContactMassRatio, fZKeyMaxForce, fZKeyMaxForceScaleHigh, fZKeyMaxForceScaleLow, fZKeyMaxForceWeightHigh, fZKeyMaxForceWeightLow, fZKeyObjectDamping, fZKeySpringDamping, fZKeySpringElasticity, fmodifiedTargetAttackRange};
        }

        public static FloatSetting[] values() {
            FloatSetting[] floatSettingArray = ENUM$VALUES;
            int n = floatSettingArray.length;
            FloatSetting[] floatSettingArray2 = new FloatSetting[n];
            System.arraycopy(ENUM$VALUES, 0, floatSettingArray2, 0, n);
            return floatSettingArray2;
        }

        public static FloatSetting valueOf(String string) {
            return Enum.valueOf(FloatSetting.class, string);
        }

        private static void  enum constant initialization$2() {
            fAIAcquireObjectDistance = new FloatSetting();
            fAIActivateHeight = new FloatSetting();
            fAIActivateReach = new FloatSetting();
            fAIActorPackTargetHeadTrackMod = new FloatSetting();
            fAIAimBlockedHalfCircleRadius = new FloatSetting();
            fAIAimBlockedToleranceDegrees = new FloatSetting();
            fAIAwareofPlayerTimer = new FloatSetting();
            fAIBestHeadTrackDistance = new FloatSetting();
            fAICombatFleeScoreThreshold = new FloatSetting();
            fAICombatNoAreaEffectAllyDistance = new FloatSetting();
            fAICombatNoTargetLOSPriorityMult = new FloatSetting();
            fAICombatSlopeDifference = new FloatSetting();
            fAICombatTargetUnreachablePriorityMult = new FloatSetting();
            fAICombatUnreachableTargetPriorityMult = new FloatSetting();
            fAICommentTimeWindow = new FloatSetting();
            fAIConversationExploreTime = new FloatSetting();
            fAIDefaultSpeechMult = new FloatSetting();
            fAIDialogueDistance = new FloatSetting();
            fAIDistanceRadiusMinLocation = new FloatSetting();
            fAIDistanceTeammateDrawWeapon = new FloatSetting();
            fAIDodgeDecisionBase = new FloatSetting();
            fAIDodgeFavorLeftRightMult = new FloatSetting();
            fAIDodgeVerticalRangedAttackMult = new FloatSetting();
            fAIDodgeWalkChance = new FloatSetting();
            fAIEnergyLevelBase = new FloatSetting();
            fAIEngergyLevelMult = new FloatSetting();
            fAIEscortFastTravelMaxDistFromPath = new FloatSetting();
            fAIEscortHysteresisWidth = new FloatSetting();
            fAIEscortStartStopDelayTime = new FloatSetting();
            fAIEscortWaitDistanceExterior = new FloatSetting();
            fAIEscortWaitDistanceInterior = new FloatSetting();
            fAIExclusiveGreetingTimer = new FloatSetting();
            fAIExplosiveWeaponDamageMult = new FloatSetting();
            fAIExplosiveWeaponRangeMult = new FloatSetting();
            fAIExteriorSpectatorDetection = new FloatSetting();
            fAIExteriorSpectatorDistance = new FloatSetting();
            fAIFaceTargetAnimationAngle = new FloatSetting();
            fAIFindBedChairsDistance = new FloatSetting();
            fAIFleeConfBase = new FloatSetting();
            fAIFleeConfMult = new FloatSetting();
            fAIFleeHealthMult = new FloatSetting();
            fAIFleeSuccessTimeout = new FloatSetting();
            fAIForceGreetingTimer = new FloatSetting();
            fAIFurnitureDestinationRadius = new FloatSetting();
            fAIGreetingTimer = new FloatSetting();
            fAIHeadTrackDialogueOffsetRandomValue = new FloatSetting();
            fAIHeadTrackDialoguePickNewOffsetTimer = new FloatSetting();
            fAIHeadTrackDialogueResetPositionTimer = new FloatSetting();
            fAIHeadTrackDialogueStayInOffsetMax = new FloatSetting();
            fAIHeadTrackDialogueStayInOffsetMin = new FloatSetting();
            fAIHeadTrackOffsetRandomValueMax = new FloatSetting();
            fAIHeadTrackOffsetRandomValueMin = new FloatSetting();
            fAIHeadTrackPickNewOffsetTimer = new FloatSetting();
            fAIHeadTrackResetPositionTimer = new FloatSetting();
            fAIHeadTrackStayInOffsetMax = new FloatSetting();
            fAIHeadTrackStayInOffsetMin = new FloatSetting();
            fAIHoldDefaultHeadTrackTimer = new FloatSetting();
            fAIHorseSearchDistance = new FloatSetting();
            fAIIdleAnimationDistance = new FloatSetting();
            fAIIdleAnimationLargeCreatureDistanceMult = new FloatSetting();
            fAIIdleWaitTime = new FloatSetting();
            fAIIdleWaitTimeComplexScene = new FloatSetting();
            fAIInDialogueModeWithPlayerDistance = new FloatSetting();
            fAIInDialogueModewithPlayerTimer = new FloatSetting();
            fAIInteriorHeadTrackMult = new FloatSetting();
            fAIInteriorSpectatorDetection = new FloatSetting();
            fAIInteriorSpectatorDistance = new FloatSetting();
            fAILockDoorsSeenRecentlySeconds = new FloatSetting();
            fAIMagicSpellMult = new FloatSetting();
            fAIMagicTimer = new FloatSetting();
            fAIMarkerDestinationRadius = new FloatSetting();
            fAIMaxAngleRangeMovingToStartSceneDialogue = new FloatSetting();
            fAIMaxHeadTrackDistance = new FloatSetting();
            fAIMaxHeadTrackDistanceFromPC = new FloatSetting();
            fAIMaxLargeCreatureHeadTrackDistance = new FloatSetting();
            fAIMaxSmileDistance = new FloatSetting();
            fAIMaxWanderTime = new FloatSetting();
            fAIMeleeArmorMult = new FloatSetting();
            fAIMeleeHandMult = new FloatSetting();
            fAIMinAngleRangeToStartSceneDialogue = new FloatSetting();
            fAIMinGreetingDistance = new FloatSetting();
            fAIMinLocationHeight = new FloatSetting();
            fAIMoveDistanceToRecalcFollowPath = new FloatSetting();
            fAIMoveDistanceToRecalcTravelPath = new FloatSetting();
            fAIMoveDistanceToRecalcTravelToActor = new FloatSetting();
            fAIPatrolHysteresisWidth = new FloatSetting();
            fAIPatrolMinSecondsAtNormalFurniture = new FloatSetting();
            fAIPowerAttackCreatureChance = new FloatSetting();
            fAIPowerAttackKnockdownBonus = new FloatSetting();
            fAIPowerAttackNPCChance = new FloatSetting();
            fAIPowerAttackRecoilBonus = new FloatSetting();
            fAIPursueDistanceLineOfSight = new FloatSetting();
            fAIRandomizeInitialLocationMinRadius = new FloatSetting();
            fAIRangMagicSpellMult = new FloatSetting();
            fAIRangedWeaponMult = new FloatSetting();
            fAIRevertToScriptTracking = new FloatSetting();
            fAIShoutMinAimSeconds = new FloatSetting();
            fAIShoutRetryDelaySeconds = new FloatSetting();
            fAIShoutToleranceDegrees = new FloatSetting();
            fAISocialRadiusToTriggerConversation = new FloatSetting();
            fAISocialRadiusToTriggerConversationInterior = new FloatSetting();
            fAISocialTimerForConversationsMax = new FloatSetting();
            fAISocialTimerForConversationsMin = new FloatSetting();
            fAISocialTimerToWaitForEvent = new FloatSetting();
            fAISocialchanceForConversation = new FloatSetting();
            fAISocialchanceForConversationInterior = new FloatSetting();
            fAISpectatorCommentTimer = new FloatSetting();
            fAISpectatorRememberThreatTimer = new FloatSetting();
            fAISpectatorShutdownDistance = new FloatSetting();
            fAISpectatorThreatDistExplosion = new FloatSetting();
            fAISpectatorThreatDistMelee = new FloatSetting();
            fAISpectatorThreatDistMine = new FloatSetting();
            fAISpectatorThreatDistRanged = new FloatSetting();
            fAIStayonScriptHeadtrack = new FloatSetting();
            fAITrespassWarningTimer = new FloatSetting();
            fAIUpdateMovementRestrictionsDistance = new FloatSetting();
            fAIUseMagicToleranceDegrees = new FloatSetting();
            fAIUseWeaponAnimationTimeoutSeconds = new FloatSetting();
            fAIUseWeaponDistance = new FloatSetting();
            fAIUseWeaponToleranceDegrees = new FloatSetting();
            fAIWaitingforScriptCallback = new FloatSetting();
            fAIWalkAwayTimerForConversation = new FloatSetting();
            fAIWanderDefaultMinDist = new FloatSetting();
            fAItalktoNPCtimer = new FloatSetting();
            fAItalktosameNPCtimer = new FloatSetting();
            fActionPointsAimAdjustment = new FloatSetting();
            fActionPointsAttackMagic = new FloatSetting();
            fActionPointsAttackOneHandMelee = new FloatSetting();
            fActionPointsAttackRanged = new FloatSetting();
            fActionPointsAttackTwoHandMelee = new FloatSetting();
            fActionPointsAttackUnarmed = new FloatSetting();
            fActionPointsCrouch = new FloatSetting();
            fActionPointsFOVBase = new FloatSetting();
            fActionPointsFOVMult = new FloatSetting();
            fActionPointsHeal = new FloatSetting();
            fActionPointsPowerAttackMult = new FloatSetting();
            fActionPointsReload = new FloatSetting();
            fActionPointsRestoreRate = new FloatSetting();
            fActionPointsRunAndGunMult = new FloatSetting();
            fActionPointsStand = new FloatSetting();
            fActionPointsSwitchWeapon = new FloatSetting();
            fActionPointsToggleWeaponDrawn = new FloatSetting();
            fActionPointsVATSMeleeMult = new FloatSetting();
            fActiveEffectConditionUpdateInterval = new FloatSetting();
            fActorAlertSoundTimer = new FloatSetting();
            fActorAlphaFadeSeconds = new FloatSetting();
            fActorAnimZAdjust = new FloatSetting();
            fActorArmorDesirabilityDamageMult = new FloatSetting();
            fActorArmorDesirabilitySkillMult = new FloatSetting();
            fActorDefaultTurningSpeed = new FloatSetting();
            fActorLeaveWaterBreathTimer = new FloatSetting();
            fActorLuckSkillMult = new FloatSetting();
            fActorStrengthEncumbranceMult = new FloatSetting();
            fActorSwimBreathBase = new FloatSetting();
            fActorSwimBreathDamage = new FloatSetting();
            fActorSwimBreathMult = new FloatSetting();
            fActorTeleportFadeSeconds = new FloatSetting();
            fActorWeaponDesirabilityDamageMult = new FloatSetting();
            fActorWeaponDesirabilitySkillMult = new FloatSetting();
            fAddictionUsageMonitorThreshold = new FloatSetting();
            fAiAcquireKillBase = new FloatSetting();
            fAiAcquireKillMult = new FloatSetting();
            fAiAcquirePickBase = new FloatSetting();
            fAiAcquirePickMult = new FloatSetting();
            fAiAcquireStealBase = new FloatSetting();
            fAiAcquireStealMult = new FloatSetting();
            fAlchemyGoldMult = new FloatSetting();
            fAlchemyIngredientInitMult = new FloatSetting();
            fAlchemySkillFactor = new FloatSetting();
            fAmbushOverRideRadiusforPlayerDetection = new FloatSetting();
            fArmorBaseFactor = new FloatSetting();
            fArmorRatingBase = new FloatSetting();
            fArmorRatingMax = new FloatSetting();
            fArmorRatingPCBase = new FloatSetting();
            fArmorRatingPCMax = new FloatSetting();
            fArmorScalingFactor = new FloatSetting();
            fArmorWeightLightMaxMod = new FloatSetting();
            fArrowBounceBlockPercentage = new FloatSetting();
            fArrowBounceLinearSpeed = new FloatSetting();
            fArrowBounceRotateSpeed = new FloatSetting();
            fArrowBowFastMult = new FloatSetting();
            fArrowBowMinTime = new FloatSetting();
            fArrowBowSlowMult = new FloatSetting();
            fArrowFakeMass = new FloatSetting();
            fArrowGravityBase = new FloatSetting();
            fArrowGravityMin = new FloatSetting();
            fArrowGravityMult = new FloatSetting();
            fArrowMaxDistance = new FloatSetting();
            fArrowMinBowVelocity = new FloatSetting();
            fArrowMinDistanceForTrails = new FloatSetting();
            fArrowMinPower = new FloatSetting();
            fArrowMinSpeedForTrails = new FloatSetting();
            fArrowMinVelocity = new FloatSetting();
            fArrowOptimalDistance = new FloatSetting();
            fArrowSpeedMult = new FloatSetting();
            fArrowWeakGravity = new FloatSetting();
            fAuroraFadeInStart = new FloatSetting();
            fAuroraFadeOutStart = new FloatSetting();
            fAutoAimMaxDegrees = new FloatSetting();
            fAutoAimMaxDegreesMelee = new FloatSetting();
            fAutoAimMaxDegreesVATS = new FloatSetting();
            fAutoAimMaxDistance = new FloatSetting();
            fAutoAimScreenPercentage = new FloatSetting();
            fAutomaticWeaponBurstCooldownTime = new FloatSetting();
            fAutomaticWeaponBurstFireTime = new FloatSetting();
            fAutoraFadeIn = new FloatSetting();
            fAutoraFadeOut = new FloatSetting();
            fAvoidPlayerDistance = new FloatSetting();
            fBarterBuyMin = new FloatSetting();
            fBarterMax = new FloatSetting();
            fBarterMin = new FloatSetting();
            fBarterSellMax = new FloatSetting();
            fBeamWidthDefault = new FloatSetting();
            fBigBumpSpeed = new FloatSetting();
            fBleedoutCheck = new FloatSetting();
            fBleedoutDefault = new FloatSetting();
            fBleedoutMin = new FloatSetting();
            fBleedoutRate = new FloatSetting();
            fBleedoutRecover = new FloatSetting();
            fBlinkDelayMax = new FloatSetting();
            fBlinkDelayMin = new FloatSetting();
            fBlinkDownTime = new FloatSetting();
            fBlinkUpTime = new FloatSetting();
            fBlockAmountHandToHandMult = new FloatSetting();
            fBlockAmountWeaponMult = new FloatSetting();
            fBlockLevel = new FloatSetting();
            fBlockMax = new FloatSetting();
            fBlockPowerAttackMult = new FloatSetting();
            fBlockScoreNoShieldMult = new FloatSetting();
            fBlockSkillBase = new FloatSetting();
            fBlockSkillMult = new FloatSetting();
            fBlockWeaponBase = new FloatSetting();
            fBlockWeaponScaling = new FloatSetting();
            fBloodSplatterCountBase = new FloatSetting();
            fBloodSplatterCountDamageBase = new FloatSetting();
            fBloodSplatterCountDamageMult = new FloatSetting();
            fBloodSplatterCountRandomMargin = new FloatSetting();
            fBloodSplatterDuration = new FloatSetting();
            fBloodSplatterFadeStart = new FloatSetting();
            fBloodSplatterFlareMult = new FloatSetting();
            fBloodSplatterFlareOffsetScale = new FloatSetting();
            fBloodSplatterFlareSize = new FloatSetting();
            fBloodSplatterMaxOpacity = new FloatSetting();
            fBloodSplatterMaxSize = new FloatSetting();
            fBloodSplatterMinOpacity = new FloatSetting();
            fBloodSplatterMinSize = new FloatSetting();
            fBloodSplatterOpacityChance = new FloatSetting();
            fBookLight = new FloatSetting();
            fBowDrawTime = new FloatSetting();
            fBowHoldTimer = new FloatSetting();
            fBowNPCSpreadAngle = new FloatSetting();
            fBowZoomStaminaDrainMult = new FloatSetting();
            fBowZoomStaminaRegenDelay = new FloatSetting();
            fBribeBase = new FloatSetting();
            fBribeCostCurve = new FloatSetting();
            fBribeMoralityMult = new FloatSetting();
            fBribeMult = new FloatSetting();
            fBribeNPCLevelMult = new FloatSetting();
            fBribeScale = new FloatSetting();
            fBribeSpeechcraftMult = new FloatSetting();
            fBumpReactionIdealMoveDist = new FloatSetting();
            fBumpReactionMinMoveDist = new FloatSetting();
            fBumpReactionSmallDelayTime = new FloatSetting();
            fBumpReactionSmallWaitTimer = new FloatSetting();
            fBuoyancyMultBody = new FloatSetting();
            fBuoyancyMultExtremity = new FloatSetting();
            fCameraShakeDistFadeDelta = new FloatSetting();
            fCameraShakeDistFadeStart = new FloatSetting();
            fCameraShakeDistMin = new FloatSetting();
            fCameraShakeExplosionDistMult = new FloatSetting();
            fCameraShakeFadeTime = new FloatSetting();
            fCameraShakeMultMin = new FloatSetting();
            fCameraShakeTime = new FloatSetting();
            fChaseDetectionTimerSetting = new FloatSetting();
            fCheckDeadBodyTimer = new FloatSetting();
            fCheckPositionFallDistance = new FloatSetting();
            fClosetoPlayerDistance = new FloatSetting();
            fClothingArmorBase = new FloatSetting();
            fClothingArmorScale = new FloatSetting();
            fClothingBase = new FloatSetting();
            fClothingClassScale = new FloatSetting();
            fClothingJewelryBase = new FloatSetting();
            fClothingJewelryScale = new FloatSetting();
            fCombatAbsoluteMaxRangeMult = new FloatSetting();
            fCombatAcquirePickupAnimationDelay = new FloatSetting();
            fCombatAcquireWeaponAmmoMinimumScoreMult = new FloatSetting();
            fCombatAcquireWeaponAvoidTargetRadius = new FloatSetting();
            fCombatAcquireWeaponCloseDistanceMax = new FloatSetting();
            fCombatAcquireWeaponCloseDistanceMin = new FloatSetting();
            fCombatAcquireWeaponDisarmedAcquireTime = new FloatSetting();
            fCombatAcquireWeaponDisarmedDistanceMax = new FloatSetting();
            fCombatAcquireWeaponDisarmedDistanceMin = new FloatSetting();
            fCombatAcquireWeaponDisarmedTime = new FloatSetting();
            fCombatAcquireWeaponEnchantmentChargeMult = new FloatSetting();
            fCombatAcquireWeaponFindAmmoDistance = new FloatSetting();
            fCombatAcquireWeaponMeleeScoreMult = new FloatSetting();
            fCombatAcquireWeaponMinimumScoreMult = new FloatSetting();
            fCombatAcquireWeaponMinimumTargetDistance = new FloatSetting();
            fCombatAcquireWeaponRangedDistanceMax = new FloatSetting();
            fCombatAcquireWeaponRangedDistanceMin = new FloatSetting();
            fCombatAcquireWeaponReachDistance = new FloatSetting();
            fCombatAcquireWeaponScoreCostMult = new FloatSetting();
            fCombatAcquireWeaponScoreRatioMax = new FloatSetting();
            fCombatAcquireWeaponSearchFailedDelay = new FloatSetting();
            fCombatAcquireWeaponSearchRadiusBuffer = new FloatSetting();
            fCombatAcquireWeaponSearchSuccessDelay = new FloatSetting();
            fCombatAcquireWeaponTargetDistanceCheck = new FloatSetting();
            fCombatAcquireWeaponUnarmedDistanceMax = new FloatSetting();
            fCombatAcquireWeaponUnarmedDistanceMin = new FloatSetting();
            fCombatActiveCombatantAttackRangeDistance = new FloatSetting();
            fCombatActiveCombatantLastSeenTime = new FloatSetting();
            fCombatAdvanceInnerRadiusMax = new FloatSetting();
            fCombatAdvanceInnerRadiusMid = new FloatSetting();
            fCombatAdvanceInnerRadiusMin = new FloatSetting();
            fCombatAdvanceLastDamagedThreshold = new FloatSetting();
            fCombatAdvanceNormalAttackChance = new FloatSetting();
            fCombatAdvanceOuterRadiusMax = new FloatSetting();
            fCombatAdvanceOuterRadiusMid = new FloatSetting();
            fCombatAdvanceOuterRadiusMin = new FloatSetting();
            fCombatAdvancePathRetryTime = new FloatSetting();
            fCombatAdvanceRadiusStaggerMult = new FloatSetting();
            fCombatAimDeltaThreshold = new FloatSetting();
            fCombatAimLastSeenLocationTimeLimit = new FloatSetting();
            fCombatAimMeleeHighPriorityUpdateTime = new FloatSetting();
            fCombatAimMeleeUpdateTime = new FloatSetting();
            fCombatAimProjectileBlockedTime = new FloatSetting();
            fCombatAimProjectileGroundMinRadius = new FloatSetting();
            fCombatAimProjectileRandomOffset = new FloatSetting();
            fCombatAimProjectileUpdateTime = new FloatSetting();
            fCombatAimTrackTargetUpdateTime = new FloatSetting();
            fCombatAngleTolerance = new FloatSetting();
            fCombatAnticipateTime = new FloatSetting();
            fCombatAnticipatedLocationCheckDistance = new FloatSetting();
            fCombatApproachTargetSlowdownDecelerationMult = new FloatSetting();
            fCombatApproachTargetSlowdownDistance = new FloatSetting();
            fCombatApproachTargetSlowdownUpdateTime = new FloatSetting();
            fCombatApproachTargetSlowdownVelocityAngle = new FloatSetting();
            fCombatApproachTargetSprintStopMovingRange = new FloatSetting();
            fCombatApproachTargetSprintStopRange = new FloatSetting();
            fCombatApproachTargetUpdateTime = new FloatSetting();
            fCombatAreaHoldPositionMinimumRadius = new FloatSetting();
            fCombatAreaStandardAttackedRadius = new FloatSetting();
            fCombatAreaStandardAttackedTime = new FloatSetting();
            fCombatAreaStandardCheckViewConeDistanceMax = new FloatSetting();
            fCombatAreaStandardCheckViewConeDistanceMin = new FloatSetting();
            fCombatAreaStandardFlyingRadiusMult = new FloatSetting();
            fCombatAreaStandardRadius = new FloatSetting();
            fCombatAttackAllowedOverrunDistance = new FloatSetting();
            fCombatAttackAnimationDrivenDelayTime = new FloatSetting();
            fCombatAttackAnticipatedDistanceMin = new FloatSetting();
            fCombatAttackChanceBlockingMultMax = new FloatSetting();
            fCombatAttackChanceBlockingMultMin = new FloatSetting();
            fCombatAttackChanceBlockingSwingMult = new FloatSetting();
            fCombatAttackChanceLastAttackBonus = new FloatSetting();
            fCombatAttackChanceLastAttackBonusTime = new FloatSetting();
            fCombatAttackChanceMax = new FloatSetting();
            fCombatAttackChanceMin = new FloatSetting();
            fCombatAttackCheckTargetRangeDistance = new FloatSetting();
            fCombatAttackMovingAttackDistance = new FloatSetting();
            fCombatAttackMovingAttackReachMult = new FloatSetting();
            fCombatAttackMovingStrikeAngleMult = new FloatSetting();
            fCombatAttackPlayerAnticipateMult = new FloatSetting();
            fCombatAttackStationaryAttackDistance = new FloatSetting();
            fCombatAttackStrikeAngleMult = new FloatSetting();
            fCombatAvoidThreatsChance = new FloatSetting();
            fCombatBackoffChance = new FloatSetting();
            fCombatBackoffMinDistanceMult = new FloatSetting();
            fCombatBashChanceMax = new FloatSetting();
            fCombatBashChanceMin = new FloatSetting();
            fCombatBashReach = new FloatSetting();
            fCombatBashTargetBlockingMult = new FloatSetting();
            fCombatBetweenAdvanceTimer = new FloatSetting();
            fCombatBlockAttackChanceMax = new FloatSetting();
            fCombatBlockAttackChanceMin = new FloatSetting();
            fCombatBlockAttackReachMult = new FloatSetting();
            fCombatBlockAttackStrikeAngleMult = new FloatSetting();
            fCombatBlockChanceMax = new FloatSetting();
            fCombatBlockChanceMin = new FloatSetting();
            fCombatBlockChanceWeaponMult = new FloatSetting();
            fCombatBlockMaxTargetRetreatVelocity = new FloatSetting();
            fCombatBlockStartDistanceMax = new FloatSetting();
            fCombatBlockStartDistanceMin = new FloatSetting();
            fCombatBlockStopDistanceMax = new FloatSetting();
            fCombatBlockStopDistanceMin = new FloatSetting();
            fCombatBlockTimeMax = new FloatSetting();
            fCombatBlockTimeMid = new FloatSetting();
            fCombatBlockTimeMin = new FloatSetting();
            fCombatBoundWeaponDPSBonus = new FloatSetting();
            fCombatBuffMaxTimer = new FloatSetting();
            fCombatBuffStandoffTimer = new FloatSetting();
            fCombatCastConcentrationOffensiveMagicCastTimeMax = new FloatSetting();
            fCombatCastConcentrationOffensiveMagicCastTimeMin = new FloatSetting();
            fCombatCastConcentrationOffensiveMagicChanceMax = new FloatSetting();
            fCombatCastConcentrationOffensiveMagicChanceMin = new FloatSetting();
            fCombatCastConcentrationOffensiveMagicWaitTimeMax = new FloatSetting();
            fCombatCastConcentrationOffensiveMagicWaitTimeMin = new FloatSetting();
            fCombatCastImmediateOffensiveMagicChanceMax = new FloatSetting();
            fCombatCastImmediateOffensiveMagicChanceMin = new FloatSetting();
            fCombatCastImmediateOffensiveMagicHoldTimeAbsoluteMin = new FloatSetting();
            fCombatCastImmediateOffensiveMagicHoldTimeMax = new FloatSetting();
            fCombatCastImmediateOffensiveMagicHoldTimeMin = new FloatSetting();
            fCombatCastImmediateOffensiveMagicHoldTimeMinDistance = new FloatSetting();
            fCombatChangeProcessFaceTargetDistance = new FloatSetting();
            fCombatCircleAngleMax = new FloatSetting();
            fCombatCircleAngleMin = new FloatSetting();
            fCombatCircleAnglePlayerMult = new FloatSetting();
            fCombatCircleChanceMax = new FloatSetting();
            fCombatCircleChanceMin = new FloatSetting();
            fCombatCircleDistanceMax = new FloatSetting();
            fCombatCircleDistantChanceMax = new FloatSetting();
            fCombatCircleDistantChanceMin = new FloatSetting();
            fCombatCircleMinDistanceMult = new FloatSetting();
            fCombatCircleMinDistanceRadiusMult = new FloatSetting();
            fCombatCircleMinMovementDistance = new FloatSetting();
            fCombatCircleViewConeAngle = new FloatSetting();
            fCombatCloseRangeTrackTargetDistance = new FloatSetting();
            fCombatClusterUpdateTime = new FloatSetting();
            fCombatCollectAlliesTimer = new FloatSetting();
            fCombatConfidenceModifierMax = new FloatSetting();
            fCombatConfidenceModifierMin = new FloatSetting();
            fCombatCoverAttackMaxWaitTime = new FloatSetting();
            fCombatCoverAttackOffsetDistance = new FloatSetting();
            fCombatCoverAttackTimeMax = new FloatSetting();
            fCombatCoverAttackTimeMid = new FloatSetting();
            fCombatCoverAttackTimeMin = new FloatSetting();
            fCombatCoverAvoidTargetRadius = new FloatSetting();
            fCombatCoverCheckCoverHeightMin = new FloatSetting();
            fCombatCoverCheckCoverHeightOffset = new FloatSetting();
            fCombatCoverEdgeOffsetDistance = new FloatSetting();
            fCombatCoverLedgeOffsetDistance = new FloatSetting();
            fCombatCoverMaxRangeMult = new FloatSetting();
            fCombatCoverMidPointMaxRangeBuffer = new FloatSetting();
            fCombatCoverMinimumActiveRange = new FloatSetting();
            fCombatCoverMinimumRange = new FloatSetting();
            fCombatCoverObstacleMovedTime = new FloatSetting();
            fCombatCoverRangeMaxActiveMult = new FloatSetting();
            fCombatCoverRangeMaxBufferDistance = new FloatSetting();
            fCombatCoverRangeMinActiveMult = new FloatSetting();
            fCombatCoverRangeMinBufferDistance = new FloatSetting();
            fCombatCoverReservationWidthMult = new FloatSetting();
            fCombatCoverSearchDistanceMax = new FloatSetting();
            fCombatCoverSearchDistanceMin = new FloatSetting();
            fCombatCoverSearchFailedDelay = new FloatSetting();
            fCombatCoverSecondaryThreatLastSeenTime = new FloatSetting();
            fCombatCoverSecondaryThreatMinDistance = new FloatSetting();
            fCombatCoverWaitLookOffsetDistance = new FloatSetting();
            fCombatCoverWaitTimeMax = new FloatSetting();
            fCombatCoverWaitTimeMid = new FloatSetting();
            fCombatCoverWaitTimeMin = new FloatSetting();
            fCombatCurrentWeaponAbsoluteMaxRangeMult = new FloatSetting();
            fCombatDPSBowSpeedMult = new FloatSetting();
            fCombatDPSMeleeSpeedMult = new FloatSetting();
            fCombatDamageBonusMeleeSneakingMult = new FloatSetting();
            fCombatDamageBonusSneakingMult = new FloatSetting();
            fCombatDamageScale = new FloatSetting();
            fCombatDeadActorHitConeMult = new FloatSetting();
            fCombatDetectionDialogueIdleMaxElapsedTime = new FloatSetting();
            fCombatDetectionDialogueIdleMinElapsedTime = new FloatSetting();
            fCombatDetectionDialogueMaxElapsedTime = new FloatSetting();
            fCombatDetectionDialogueMinElapsedTime = new FloatSetting();
            fCombatDetectionFleeingLostRemoveTime = new FloatSetting();
            fCombatDetectionLostCheckNoticedDistance = new FloatSetting();
            fCombatDetectionLostRemoveDistance = new FloatSetting();
            fCombatDetectionLostRemoveDistanceTime = new FloatSetting();
            fCombatDetectionLostRemoveTime = new FloatSetting();
            fCombatDetectionLostTimeLimit = new FloatSetting();
            fCombatDetectionLowDetectionDistance = new FloatSetting();
            fCombatDetectionLowPriorityDistance = new FloatSetting();
            fCombatDetectionNoticedDistanceLimit = new FloatSetting();
            fCombatDetectionNoticedTimeLimit = new FloatSetting();
            fCombatDetectionVeryLowPriorityDistance = new FloatSetting();
            fCombatDialogueAllyKilledDistanceMult = new FloatSetting();
            fCombatDialogueAllyKilledMaxElapsedTime = new FloatSetting();
            fCombatDialogueAllyKilledMinElapsedTime = new FloatSetting();
            fCombatDialogueAttackDistanceMult = new FloatSetting();
            fCombatDialogueAttackMaxElapsedTime = new FloatSetting();
            fCombatDialogueAttackMinElapsedTime = new FloatSetting();
            fCombatDialogueAvoidThreatDistanceMult = new FloatSetting();
            fCombatDialogueAvoidThreatMaxElapsedTime = new FloatSetting();
            fCombatDialogueAvoidThreatMinElapsedTime = new FloatSetting();
            fCombatDialogueBashDistanceMult = new FloatSetting();
            fCombatDialogueBleedOutMaxElapsedTime = new FloatSetting();
            fCombatDialogueBleedOutMinElapsedTime = new FloatSetting();
            fCombatDialogueBleedoutDistanceMult = new FloatSetting();
            fCombatDialogueBlockDistanceMult = new FloatSetting();
            fCombatDialogueDeathDistanceMult = new FloatSetting();
            fCombatDialogueFleeDistanceMult = new FloatSetting();
            fCombatDialogueFleeMaxElapsedTime = new FloatSetting();
            fCombatDialogueFleeMinElapsedTime = new FloatSetting();
            fCombatDialogueGroupStrategyDistanceMult = new FloatSetting();
            fCombatDialogueHitDistanceMult = new FloatSetting();
            fCombatDialoguePowerAttackDistanceMult = new FloatSetting();
            fCombatDialogueTauntDistanceMult = new FloatSetting();
            fCombatDialogueTauntMaxElapsedTime = new FloatSetting();
            fCombatDialogueTauntMinElapsedTime = new FloatSetting();
            fCombatDisarmedFindBetterWeaponInitialTime = new FloatSetting();
            fCombatDisarmedFindBetterWeaponTime = new FloatSetting();
            fCombatDismemberedLimbVelocity = new FloatSetting();
            fCombatDistance = new FloatSetting();
            fCombatDistanceMin = new FloatSetting();
            fCombatDiveBombChanceMax = new FloatSetting();
            fCombatDiveBombChanceMin = new FloatSetting();
            fCombatDiveBombOffsetPercent = new FloatSetting();
            fCombatDiveBombSlowDownDistance = new FloatSetting();
            fCombatDodgeAccelerationMult = new FloatSetting();
            fCombatDodgeAcceptableThreatScoreMult = new FloatSetting();
            fCombatDodgeAnticipateThreatTime = new FloatSetting();
            fCombatDodgeBufferDistance = new FloatSetting();
            fCombatDodgeChanceMax = new FloatSetting();
            fCombatDodgeChanceMin = new FloatSetting();
            fCombatDodgeDecelerationMult = new FloatSetting();
            fCombatDodgeMovingReactionTime = new FloatSetting();
            fCombatDodgeReactionTime = new FloatSetting();
            fCombatEffectiveDistanceAnticipateTime = new FloatSetting();
            fCombatEnvironmentBloodChance = new FloatSetting();
            fCombatFallbackChanceMax = new FloatSetting();
            fCombatFallbackChanceMin = new FloatSetting();
            fCombatFallbackDistanceMax = new FloatSetting();
            fCombatFallbackDistanceMin = new FloatSetting();
            fCombatFallbackMaxAngle = new FloatSetting();
            fCombatFallbackMinMovementDistance = new FloatSetting();
            fCombatFallbackWaitTimeMax = new FloatSetting();
            fCombatFallbackWaitTimeMin = new FloatSetting();
            fCombatFindAllyAttackLocationAllyRadius = new FloatSetting();
            fCombatFindAllyAttackLocationDistanceMax = new FloatSetting();
            fCombatFindAllyAttackLocationDistanceMin = new FloatSetting();
            fCombatFindAttackLocationAvoidTargetRadius = new FloatSetting();
            fCombatFindAttackLocationDistance = new FloatSetting();
            fCombatFindAttackLocationKeyAngle = new FloatSetting();
            fCombatFindAttackLocationKeyHeight = new FloatSetting();
            fCombatFindBetterWeaponTime = new FloatSetting();
            fCombatFindLateralAttackLocationDistance = new FloatSetting();
            fCombatFindLateralAttackLocationIntervalMax = new FloatSetting();
            fCombatFindLateralAttackLocationIntervalMin = new FloatSetting();
            fCombatFiringArcStationaryTurnMult = new FloatSetting();
            fCombatFlankingAngleOffset = new FloatSetting();
            fCombatFlankingAngleOffsetCostMult = new FloatSetting();
            fCombatFlankingAngleOffsetMax = new FloatSetting();
            fCombatFlankingDirectionDistanceMult = new FloatSetting();
            fCombatFlankingDirectionGoalAngleOffset = new FloatSetting();
            fCombatFlankingDirectionOffsetCostMult = new FloatSetting();
            fCombatFlankingDirectionRotateAngleOffset = new FloatSetting();
            fCombatFlankingDistanceMax = new FloatSetting();
            fCombatFlankingDistanceMin = new FloatSetting();
            fCombatFlankingGoalAngleFarMax = new FloatSetting();
            fCombatFlankingGoalAngleFarMaxDistance = new FloatSetting();
            fCombatFlankingGoalAngleFarMin = new FloatSetting();
            fCombatFlankingGoalAngleFarMinDistance = new FloatSetting();
            fCombatFlankingGoalAngleNear = new FloatSetting();
            fCombatFlankingGoalCheckDistanceMax = new FloatSetting();
            fCombatFlankingGoalCheckDistanceMin = new FloatSetting();
            fCombatFlankingGoalCheckDistanceMult = new FloatSetting();
            fCombatFlankingLocationGridSize = new FloatSetting();
            fCombatFlankingMaxTurnAngle = new FloatSetting();
            fCombatFlankingMaxTurnAngleGoal = new FloatSetting();
            fCombatFlankingNearDistance = new FloatSetting();
            fCombatFlankingRotateAngle = new FloatSetting();
            fCombatFlankingStalkRange = new FloatSetting();
            fCombatFlankingStalkTimeMax = new FloatSetting();
            fCombatFlankingStalkTimeMin = new FloatSetting();
            fCombatFlankingStepDistanceMax = new FloatSetting();
            fCombatFlankingStepDistanceMin = new FloatSetting();
            fCombatFlankingStepDistanceMult = new FloatSetting();
            fCombatFleeAllyDistanceMax = new FloatSetting();
            fCombatFleeAllyDistanceMin = new FloatSetting();
            fCombatFleeAllyRadius = new FloatSetting();
            fCombatFleeCoverMinDistance = new FloatSetting();
            fCombatFleeCoverSearchRadius = new FloatSetting();
            fCombatFleeDistanceExterior = new FloatSetting();
            fCombatFleeDistanceInterior = new FloatSetting();
            fCombatFleeDoorDistanceMax = new FloatSetting();
            fCombatFleeDoorTargetCheckDistance = new FloatSetting();
            fCombatFleeInitialDoorRestrictChance = new FloatSetting();
            fCombatFleeLastDoorRestrictTime = new FloatSetting();
            fCombatFleeTargetAvoidRadius = new FloatSetting();
            fCombatFleeTargetGatherRadius = new FloatSetting();
            fCombatFleeUseDoorChance = new FloatSetting();
            fCombatFleeUseDoorRestrictTime = new FloatSetting();
            fCombatFlightEffectiveDistance = new FloatSetting();
            fCombatFlightMinimumRange = new FloatSetting();
            fCombatFlyingAttackChanceMax = new FloatSetting();
            fCombatFlyingAttackChanceMin = new FloatSetting();
            fCombatFlyingAttackTargetDistanceThreshold = new FloatSetting();
            fCombatFollowRadiusBase = new FloatSetting();
            fCombatFollowRadiusMin = new FloatSetting();
            fCombatFollowRadiusMult = new FloatSetting();
            fCombatFollowSneakFollowRadius = new FloatSetting();
            fCombatForwardAttackChance = new FloatSetting();
            fCombatGiantCreatureReachMult = new FloatSetting();
            fCombatGrenadeBounceTimeMax = new FloatSetting();
            fCombatGrenadeBounceTimeMin = new FloatSetting();
            fCombatGroundAttackChanceMax = new FloatSetting();
            fCombatGroundAttackChanceMin = new FloatSetting();
            fCombatGroundAttackTimeMax = new FloatSetting();
            fCombatGroundAttackTimeMin = new FloatSetting();
            fCombatGroupCombatStrengthUpdateTime = new FloatSetting();
            fCombatGroupOffensiveMultMin = new FloatSetting();
            fCombatGuardFollowBufferDistance = new FloatSetting();
            fCombatGuardRadiusMin = new FloatSetting();
            fCombatGuardRadiusMult = new FloatSetting();
            fCombatHealthRegenRateMult = new FloatSetting();
            fCombatHideCheckViewConeDistanceMax = new FloatSetting();
            fCombatHideCheckViewConeDistanceMin = new FloatSetting();
            fCombatHideFailedTargetDistance = new FloatSetting();
            fCombatHideFailedTargetLOSDistance = new FloatSetting();
            fCombatHitConeAngle = new FloatSetting();
            fCombatHoverAngleLimit = new FloatSetting();
            fCombatHoverAngleMax = new FloatSetting();
            fCombatHoverAngleMin = new FloatSetting();
            fCombatHoverChanceMax = new FloatSetting();
            fCombatHoverChanceMin = new FloatSetting();
            fCombatHoverTimeMax = new FloatSetting();
            fCombatHoverTimeMin = new FloatSetting();
            fCombatInTheWayTimer = new FloatSetting();
            fCombatInventoryDesiredRangeScoreMultMax = new FloatSetting();
            fCombatInventoryDesiredRangeScoreMultMid = new FloatSetting();
            fCombatInventoryDesiredRangeScoreMultMin = new FloatSetting();
            fCombatInventoryDualWieldScorePenalty = new FloatSetting();
            fCombatInventoryEquipmentMinScoreMult = new FloatSetting();
            fCombatInventoryEquippedScoreBonus = new FloatSetting();
            fCombatInventoryMaxRangeEquippedBonus = new FloatSetting();
            fCombatInventoryMaxRangeScoreMult = new FloatSetting();
            fCombatInventoryMeleeEquipRange = new FloatSetting();
            fCombatInventoryMinEquipTimeBlock = new FloatSetting();
            fCombatInventoryMinEquipTimeDefault = new FloatSetting();
            fCombatInventoryMinEquipTimeMagic = new FloatSetting();
            fCombatInventoryMinEquipTimeShout = new FloatSetting();
            fCombatInventoryMinEquipTimeStaff = new FloatSetting();
            fCombatInventoryMinEquipTimeTorch = new FloatSetting();
            fCombatInventoryMinEquipTimeWeapon = new FloatSetting();
            fCombatInventoryMinRangeScoreMult = new FloatSetting();
            fCombatInventoryMinRangeUnequippedBonus = new FloatSetting();
            fCombatInventoryOptimalRangePercent = new FloatSetting();
            fCombatInventoryRangedScoreMult = new FloatSetting();
            fCombatInventoryResourceCurrentRequiredMult = new FloatSetting();
            fCombatInventoryResourceDesiredRequiredMult = new FloatSetting();
            fCombatInventoryResourceRegenTime = new FloatSetting();
            fCombatInventoryShieldEquipRange = new FloatSetting();
            fCombatInventoryShoutMaxRecoveryTime = new FloatSetting();
            fCombatInventoryTorchEquipRange = new FloatSetting();
            fCombatInventoryUpdateTimer = new FloatSetting();
            fCombatIronSightsDistance = new FloatSetting();
            fCombatIronSightsRangeMult = new FloatSetting();
            fCombatItemBuffTimer = new FloatSetting();
            fCombatItemRestoreTimer = new FloatSetting();
            fCombatKillMoveDamageMult = new FloatSetting();
            fCombatLandingAvoidActorRadius = new FloatSetting();
            fCombatLandingSearchDistance = new FloatSetting();
            fCombatLandingZoneDistance = new FloatSetting();
            fCombatLineOfSightTimer = new FloatSetting();
            fCombatLocationTargetRadiusMin = new FloatSetting();
            fCombatLowFleeingTargetHitPercent = new FloatSetting();
            fCombatLowMaxAttackDistance = new FloatSetting();
            fCombatLowTargetHitPercent = new FloatSetting();
            fCombatMagicArmorDistanceMax = new FloatSetting();
            fCombatMagicArmorDistanceMin = new FloatSetting();
            fCombatMagicArmorMinCastTime = new FloatSetting();
            fCombatMagicBoundItemDistance = new FloatSetting();
            fCombatMagicBuffDuration = new FloatSetting();
            fCombatMagicCloakDistanceMax = new FloatSetting();
            fCombatMagicCloakDistanceMin = new FloatSetting();
            fCombatMagicCloakMinCastTime = new FloatSetting();
            fCombatMagicConcentrationAimVariance = new FloatSetting();
            fCombatMagicConcentrationFiringArcMult = new FloatSetting();
            fCombatMagicConcentrationMinCastTime = new FloatSetting();
            fCombatMagicConcentrationScoreDuration = new FloatSetting();
            fCombatMagicDefaultLongDuration = new FloatSetting();
            fCombatMagicDefaultMinCastTime = new FloatSetting();
            fCombatMagicDefaultShortDuration = new FloatSetting();
            fCombatMagicDisarmDistance = new FloatSetting();
            fCombatMagicDisarmRestrictTime = new FloatSetting();
            fCombatMagicDrinkPotionWaitTime = new FloatSetting();
            fCombatMagicDualCastChance = new FloatSetting();
            fCombatMagicDualCastInterruptTime = new FloatSetting();
            fCombatMagicImmediateAimVariance = new FloatSetting();
            fCombatMagicInvisibilityDistance = new FloatSetting();
            fCombatMagicInvisibilityMinCastTime = new FloatSetting();
            fCombatMagicLightMinCastTime = new FloatSetting();
            fCombatMagicOffensiveMinCastTime = new FloatSetting();
            fCombatMagicParalyzeDistance = new FloatSetting();
            fCombatMagicParalyzeMinCastTime = new FloatSetting();
            fCombatMagicParalyzeRestrictTime = new FloatSetting();
            fCombatMagicProjectileFiringArc = new FloatSetting();
            fCombatMagicReanimateDistance = new FloatSetting();
            fCombatMagicReanimateMinCastTime = new FloatSetting();
            fCombatMagicReanimateRestrictTime = new FloatSetting();
            fCombatMagicStaggerDistance = new FloatSetting();
            fCombatMagicSummonMinCastTime = new FloatSetting();
            fCombatMagicSummonRestrictTime = new FloatSetting();
            fCombatMagicTacticalDuration = new FloatSetting();
            fCombatMagicTargetEffectMinCastTime = new FloatSetting();
            fCombatMagicWardAttackRangeDistance = new FloatSetting();
            fCombatMagicWardAttackReachMult = new FloatSetting();
            fCombatMagicWardCooldownTime = new FloatSetting();
            fCombatMagicWardMagickaCastLimit = new FloatSetting();
            fCombatMagicWardMagickaEquipLimit = new FloatSetting();
            fCombatMagicWardMinCastTime = new FloatSetting();
            fCombatMagickaRegenRateMult = new FloatSetting();
            fCombatMaintainOptimalDistanceMaxAngle = new FloatSetting();
            fCombatMaintainRangeDistanceMin = new FloatSetting();
            fCombatMaxHoldScore = new FloatSetting();
            fCombatMaximumOptimalRangeMax = new FloatSetting();
            fCombatMaximumOptimalRangeMid = new FloatSetting();
            fCombatMaximumOptimalRangeMin = new FloatSetting();
            fCombatMaximumProjectileRange = new FloatSetting();
            fCombatMaximumRange = new FloatSetting();
            fCombatMeleeTrackTargetDistanceMax = new FloatSetting();
            fCombatMeleeTrackTargetDistanceMin = new FloatSetting();
            fCombatMinEngageDistance = new FloatSetting();
            fCombatMissileImpaleDepth = new FloatSetting();
            fCombatMissileStickDepth = new FloatSetting();
            fCombatMonitorBuffsTimer = new FloatSetting();
            fCombatMoveToActorBufferDistance = new FloatSetting();
            fCombatMusicGroupThreatRatioMax = new FloatSetting();
            fCombatMusicGroupThreatRatioMin = new FloatSetting();
            fCombatMusicGroupThreatRatioTimer = new FloatSetting();
            fCombatMusicNearCombatInnerRadius = new FloatSetting();
            fCombatMusicNearCombatOuterRadius = new FloatSetting();
            fCombatMusicPlayerCombatStrengthCap = new FloatSetting();
            fCombatMusicPlayerNearStrengthMult = new FloatSetting();
            fCombatMusicPlayerTargetedThreatRatio = new FloatSetting();
            fCombatMusicStopTime = new FloatSetting();
            fCombatMusicUpdateTime = new FloatSetting();
            fCombatOffensiveBashChanceMax = new FloatSetting();
            fCombatOffensiveBashChanceMin = new FloatSetting();
            fCombatOptimalRangeMaxBufferDistance = new FloatSetting();
            fCombatOptimalRangeMinBufferDistance = new FloatSetting();
            fCombatOrbitDistance = new FloatSetting();
            fCombatOrbitTimeMax = new FloatSetting();
            fCombatOrbitTimeMin = new FloatSetting();
            fCombatParalyzeTacticalDuration = new FloatSetting();
            fCombatPathingAccelerationMult = new FloatSetting();
            fCombatPathingCurvedPathSmoothingMult = new FloatSetting();
            fCombatPathingDecelerationMult = new FloatSetting();
            fCombatPathingGoalRayCastPathDistance = new FloatSetting();
            fCombatPathingIncompletePathMinDistance = new FloatSetting();
            fCombatPathingLocationCenterOffsetMult = new FloatSetting();
            fCombatPathingLookAheadDelta = new FloatSetting();
            fCombatPathingNormalizedRotationSpeed = new FloatSetting();
            fCombatPathingRefLocationUpdateDistance = new FloatSetting();
            fCombatPathingRefLocationUpdateTimeDistanceMax = new FloatSetting();
            fCombatPathingRefLocationUpdateTimeDistanceMin = new FloatSetting();
            fCombatPathingRefLocationUpdateTimeMax = new FloatSetting();
            fCombatPathingRefLocationUpdateTimeMin = new FloatSetting();
            fCombatPathingRetryWaitTime = new FloatSetting();
            fCombatPathingRotationAccelerationMult = new FloatSetting();
            fCombatPathingStartRayCastPathDistance = new FloatSetting();
            fCombatPathingStraightPathCheckDistance = new FloatSetting();
            fCombatPathingStraightRayCastPathDistance = new FloatSetting();
            fCombatPathingUpdatePathCostMult = new FloatSetting();
            fCombatPerchAttackChanceMax = new FloatSetting();
            fCombatPerchAttackChanceMin = new FloatSetting();
            fCombatPerchAttackTimeMax = new FloatSetting();
            fCombatPerchAttackTimeMin = new FloatSetting();
            fCombatPerchMaxTargetAngle = new FloatSetting();
            fCombatPlayerBleedoutHealthDamageMult = new FloatSetting();
            fCombatPlayerLimbDamageMult = new FloatSetting();
            fCombatProjectileMaxRangeMult = new FloatSetting();
            fCombatProjectileMaxRangeOptimalMult = new FloatSetting();
            fCombatRadiusMinMult = new FloatSetting();
            fCombatRangedAimVariance = new FloatSetting();
            fCombatRangedAttackChanceLastAttackBonus = new FloatSetting();
            fCombatRangedAttackChanceLastAttackBonusTime = new FloatSetting();
            fCombatRangedAttackChanceMax = new FloatSetting();
            fCombatRangedAttackChanceMin = new FloatSetting();
            fCombatRangedAttackHoldTimeAbsoluteMin = new FloatSetting();
            fCombatRangedAttackHoldTimeMax = new FloatSetting();
            fCombatRangedAttackHoldTimeMin = new FloatSetting();
            fCombatRangedAttackHoldTimeMinDistance = new FloatSetting();
            fCombatRangedAttackMaximumHoldTime = new FloatSetting();
            fCombatRangedDistance = new FloatSetting();
            fCombatRangedMinimumRange = new FloatSetting();
            fCombatRangedProjectileFiringArc = new FloatSetting();
            fCombatRangedStandoffTimer = new FloatSetting();
            fCombatRelativeDamageMod = new FloatSetting();
            fCombatRestoreHealthPercentMax = new FloatSetting();
            fCombatRestoreHealthPercentMin = new FloatSetting();
            fCombatRestoreHealthRestrictTime = new FloatSetting();
            fCombatRestoreMagickaPercentMax = new FloatSetting();
            fCombatRestoreMagickaPercentMin = new FloatSetting();
            fCombatRestoreMagickaRestrictTime = new FloatSetting();
            fCombatRestoreStopCastThreshold = new FloatSetting();
            fCombatRoundAmount = new FloatSetting();
            fCombatSearchAreaUpdateTime = new FloatSetting();
            fCombatSearchCenterRadius = new FloatSetting();
            fCombatSearchCheckDestinationDistanceMax = new FloatSetting();
            fCombatSearchCheckDestinationDistanceMid = new FloatSetting();
            fCombatSearchCheckDestinationDistanceMin = new FloatSetting();
            fCombatSearchCheckDestinationTime = new FloatSetting();
            fCombatSearchDoorDistance = new FloatSetting();
            fCombatSearchDoorDistanceLow = new FloatSetting();
            fCombatSearchDoorSearchRadius = new FloatSetting();
            fCombatSearchExteriorRadiusMax = new FloatSetting();
            fCombatSearchExteriorRadiusMin = new FloatSetting();
            fCombatSearchIgnoreLocationRadius = new FloatSetting();
            fCombatSearchInteriorRadiusMax = new FloatSetting();
            fCombatSearchInteriorRadiusMin = new FloatSetting();
            fCombatSearchInvestigateTime = new FloatSetting();
            fCombatSearchLocationCheckDistance = new FloatSetting();
            fCombatSearchLocationCheckTime = new FloatSetting();
            fCombatSearchLocationInitialCheckTime = new FloatSetting();
            fCombatSearchLocationInvestigateDistance = new FloatSetting();
            fCombatSearchLocationRadius = new FloatSetting();
            fCombatSearchLookTime = new FloatSetting();
            fCombatSearchRadiusBufferDistance = new FloatSetting();
            fCombatSearchRadiusMemberDistance = new FloatSetting();
            fCombatSearchSightRadius = new FloatSetting();
            fCombatSearchStartWaitTime = new FloatSetting();
            fCombatSearchUpdateTime = new FloatSetting();
            fCombatSearchWanderDistance = new FloatSetting();
            fCombatSelectTargetSwitchUpdateTime = new FloatSetting();
            fCombatSelectTargetUpdateTime = new FloatSetting();
            fCombatShoutHeadTrackingAngleMovingMult = new FloatSetting();
            fCombatShoutHeadTrackingAngleMult = new FloatSetting();
            fCombatShoutLongRecoveryTime = new FloatSetting();
            fCombatShoutMaxHeadTrackingAngle = new FloatSetting();
            fCombatShoutReleaseTime = new FloatSetting();
            fCombatShoutShortRecoveryTime = new FloatSetting();
            fCombatSneakAttackBonusMult = new FloatSetting();
            fCombatSpeakAttackChance = new FloatSetting();
            fCombatSpeakHitChance = new FloatSetting();
            fCombatSpeakHitThreshold = new FloatSetting();
            fCombatSpeakPowerAttackChance = new FloatSetting();
            fCombatSpeakTauntChance = new FloatSetting();
            fCombatSpecialAttackChanceMax = new FloatSetting();
            fCombatSpecialAttackChanceMin = new FloatSetting();
            fCombatSpeedValueFastWalk = new FloatSetting();
            fCombatSpeedValueJog = new FloatSetting();
            fCombatSpeedValueRun = new FloatSetting();
            fCombatSpeedValueWalk = new FloatSetting();
            fCombatSplashDamageMaxSpeed = new FloatSetting();
            fCombatSplashDamageMinDamage = new FloatSetting();
            fCombatSplashDamageMinRadius = new FloatSetting();
            fCombatStaffTimer = new FloatSetting();
            fCombatStaminaRegenRateMult = new FloatSetting();
            fCombatStealthPointAttackedMaxValue = new FloatSetting();
            fCombatStealthPointDetectedEventMaxValue = new FloatSetting();
            fCombatStealthPointDrainMult = new FloatSetting();
            fCombatStealthPointMax = new FloatSetting();
            fCombatStealthPointRegenAlertWaitTime = new FloatSetting();
            fCombatStealthPointRegenAttackedWaitTime = new FloatSetting();
            fCombatStealthPointRegenDetectedEventWaitTime = new FloatSetting();
            fCombatStealthPointRegenLostWaitTime = new FloatSetting();
            fCombatStealthPointRegenMin = new FloatSetting();
            fCombatStealthPointRegenMult = new FloatSetting();
            fCombatStepAdvanceDistance = new FloatSetting();
            fCombatStrafeChanceMax = new FloatSetting();
            fCombatStrafeChanceMin = new FloatSetting();
            fCombatStrafeDistanceMax = new FloatSetting();
            fCombatStrafeDistanceMin = new FloatSetting();
            fCombatStrafeMinDistanceRadiusMult = new FloatSetting();
            fCombatStrengthUpdateTime = new FloatSetting();
            fCombatSurroundDistanceMax = new FloatSetting();
            fCombatSurroundDistanceMin = new FloatSetting();
            fCombatTargetEngagedLastSeenTime = new FloatSetting();
            fCombatTargetLocationAvoidNodeRadiusOffset = new FloatSetting();
            fCombatTargetLocationCurrentReservationDistanceMult = new FloatSetting();
            fCombatTargetLocationMaxDistance = new FloatSetting();
            fCombatTargetLocationMinDistanceMult = new FloatSetting();
            fCombatTargetLocationPathingRadius = new FloatSetting();
            fCombatTargetLocationRadiusSizeMult = new FloatSetting();
            fCombatTargetLocationRepositionAngleMult = new FloatSetting();
            fCombatTargetLocationSwimmingOffset = new FloatSetting();
            fCombatTargetLocationWidthMax = new FloatSetting();
            fCombatTargetLocationWidthMin = new FloatSetting();
            fCombatTargetLocationWidthSizeMult = new FloatSetting();
            fCombatTeammateFollowRadiusBase = new FloatSetting();
            fCombatTeammateFollowRadiusMin = new FloatSetting();
            fCombatTeammateFollowRadiusMult = new FloatSetting();
            fCombatThreatAnticipateTime = new FloatSetting();
            fCombatThreatAvoidCost = new FloatSetting();
            fCombatThreatBufferRadius = new FloatSetting();
            fCombatThreatCacheVelocityTime = new FloatSetting();
            fCombatThreatDangerousObjectHealth = new FloatSetting();
            fCombatThreatExplosiveObjectThreatTime = new FloatSetting();
            fCombatThreatExtrudeTime = new FloatSetting();
            fCombatThreatExtrudeVelocityThreshold = new FloatSetting();
            fCombatThreatNegativeExtrudeTime = new FloatSetting();
            fCombatThreatProximityExplosionAvoidTime = new FloatSetting();
            fCombatThreatRatioUpdateTime = new FloatSetting();
            fCombatThreatSignificantScore = new FloatSetting();
            fCombatThreatTimedExplosionLength = new FloatSetting();
            fCombatThreatUpdateTimeMax = new FloatSetting();
            fCombatThreatUpdateTimeMin = new FloatSetting();
            fCombatThreatViewCone = new FloatSetting();
            fCombatUnarmedCritDamageMult = new FloatSetting();
            fCombatUnreachableTargetCheckTime = new FloatSetting();
            fCombatVulnerabilityMod = new FloatSetting();
            fCombatYieldRetryTime = new FloatSetting();
            fCombatYieldTime = new FloatSetting();
            fCommentOnPlayerActionsTimer = new FloatSetting();
            fCommentOnPlayerKnockingThings = new FloatSetting();
            fConcussionTimer = new FloatSetting();
            fConeProjectileEnvironmentDistance = new FloatSetting();
            fConeProjectileEnvironmentTimer = new FloatSetting();
            fConeProjectileForceBase = new FloatSetting();
            fConeProjectileForceMult = new FloatSetting();
            fConeProjectileForceMultAngular = new FloatSetting();
            fConeProjectileForceMultLinear = new FloatSetting();
            fConeProjectileWaterScaleMult = new FloatSetting();
            fCoverEvaluationLastSeenExpireTime = new FloatSetting();
            fCoverFiredProjectileExpireTime = new FloatSetting();
            fCoverFiringReloadClipPercent = new FloatSetting();
            fCoverWaitReloadClipPercent = new FloatSetting();
            fCoveredAdvanceMinAdvanceDistanceMax = new FloatSetting();
            fCoveredAdvanceMinAdvanceDistanceMin = new FloatSetting();
            fCrafting = new FloatSetting();
            fCreatureDefaultTurningSpeed = new FloatSetting();
            fCreditsScrollSpeed = new FloatSetting();
            fCrimeAlarmRespMult = new FloatSetting();
            fCrimeDispAttack = new FloatSetting();
            fCrimeDispMurder = new FloatSetting();
            fCrimeDispPersonal = new FloatSetting();
            fCrimeDispPickpocket = new FloatSetting();
            fCrimeDispSteal = new FloatSetting();
            fCrimeDispTresspass = new FloatSetting();
            fCrimeFavorMult = new FloatSetting();
            fCrimeGoldSkillPenaltyMult = new FloatSetting();
            fCrimeGoldSteal = new FloatSetting();
            fCrimePersonalRegardMult = new FloatSetting();
            fCrimeRegardMult = new FloatSetting();
            fCrimeSoundBase = new FloatSetting();
            fCrimeSoundMult = new FloatSetting();
            fCrimeWitnessRegardMult = new FloatSetting();
            fDOFDistanceMult = new FloatSetting();
            fDamageArmConditionBase = new FloatSetting();
            fDamageArmConditionMult = new FloatSetting();
            fDamageGunWeapCondBase = new FloatSetting();
            fDamageGunWeapCondMult = new FloatSetting();
            fDamageMeleeWeapCondBase = new FloatSetting();
            fDamageMeleeWeapCondMult = new FloatSetting();
            fDamagePCSkillMax = new FloatSetting();
            fDamagePCSkillMin = new FloatSetting();
            fDamageSkillMax = new FloatSetting();
            fDamageSkillMin = new FloatSetting();
            fDamageSneakAttackMult = new FloatSetting();
            fDamageStrengthBase = new FloatSetting();
            fDamageStrengthMult = new FloatSetting();
            fDamageToArmorPercentage = new FloatSetting();
            fDamageToWeaponEnergyMult = new FloatSetting();
            fDamageToWeaponGunMult = new FloatSetting();
            fDamageToWeaponLauncherMult = new FloatSetting();
            fDamageToWeaponMeleeMult = new FloatSetting();
            fDamageUnarmedPenalty = new FloatSetting();
            fDamageWeaponMult = new FloatSetting();
            fDamagedAVRegenDelay = new FloatSetting();
            fDamagedHealthRegenDelay = new FloatSetting();
            fDamagedMagickaRegenDelay = new FloatSetting();
            fDamagedStaminaRegenDelay = new FloatSetting();
            fDangerousObjectExplosionDamage = new FloatSetting();
            fDangerousObjectExplosionRadius = new FloatSetting();
            fDangerousProjectileExplosionDamage = new FloatSetting();
            fDangerousProjectileExplosionRadius = new FloatSetting();
            fDaytimeColorExtension = new FloatSetting();
            fDeadReactionDistance = new FloatSetting();
            fDeathForceDamageMax = new FloatSetting();
            fDeathForceDamageMin = new FloatSetting();
            fDeathForceForceMax = new FloatSetting();
            fDeathForceForceMin = new FloatSetting();
            fDeathForceMassBase = new FloatSetting();
            fDeathForceMassMult = new FloatSetting();
            fDeathForceRangedDamageMax = new FloatSetting();
            fDeathForceRangedDamageMin = new FloatSetting();
            fDeathForceRangedForceMax = new FloatSetting();
            fDeathForceRangedForceMin = new FloatSetting();
            fDeathForceSpellImpactMult = new FloatSetting();
            fDeathSoundMaxDistance = new FloatSetting();
            fDebrisFadeTime = new FloatSetting();
            fDecalLOD = new FloatSetting();
            fDecapitateBloodTime = new FloatSetting();
            fDefault = new FloatSetting();
            fDefaultAngleTolerance = new FloatSetting();
            fDefaultBowSpeedBonus = new FloatSetting();
            fDemandBase = new FloatSetting();
            fDemandMult = new FloatSetting();
            fDetectEventDistanceNPC = new FloatSetting();
            fDetectEventDistancePlayer = new FloatSetting();
            fDetectEventDistanceVeryLoudMult = new FloatSetting();
            fDetectEventSneakDistanceVeryLoud = new FloatSetting();
            fDetectProjectileDistanceNPC = new FloatSetting();
            fDetectProjectileDistancePlayer = new FloatSetting();
            fDetectionActionTimer = new FloatSetting();
            fDetectionCombatNonTargetDistanceMult = new FloatSetting();
            fDetectionCommentTimer = new FloatSetting();
            fDetectionEventExpireTime = new FloatSetting();
            fDetectionLOSDistanceAngle = new FloatSetting();
            fDetectionLOSDistanceMultExterior = new FloatSetting();
            fDetectionLOSDistanceMultInterior = new FloatSetting();
            fDetectionLargeActorSizeMult = new FloatSetting();
            fDetectionNightEyeBonus = new FloatSetting();
            fDetectionSneakLightMod = new FloatSetting();
            fDetectionStateExpireTime = new FloatSetting();
            fDetectionUpdateTimeMax = new FloatSetting();
            fDetectionUpdateTimeMaxComplex = new FloatSetting();
            fDetectionUpdateTimeMin = new FloatSetting();
            fDetectionUpdateTimeMinComplex = new FloatSetting();
            fDetectionViewCone = new FloatSetting();
            fDialogFocalDepthRange = new FloatSetting();
            fDialogFocalDepthStrength = new FloatSetting();
            fDialogSpeechDelaySeconds = new FloatSetting();
            fDialogZoomInSeconds = new FloatSetting();
            fDialogZoomOutSeconds = new FloatSetting();
            fDialogueHardStopAngle = new FloatSetting();
            fDialogueSoftStopAngle = new FloatSetting();
            fDiffMultHPByPCE = new FloatSetting();
            fDiffMultHPByPCH = new FloatSetting();
            fDiffMultHPByPCN = new FloatSetting();
            fDiffMultHPByPCVE = new FloatSetting();
            fDiffMultHPByPCVH = new FloatSetting();
            fDiffMultHPToPCE = new FloatSetting();
            fDiffMultHPToPCH = new FloatSetting();
            fDiffMultHPToPCN = new FloatSetting();
            fDiffMultHPToPCVE = new FloatSetting();
            fDiffMultHPToPCVH = new FloatSetting();
            fDiffMultXPE = new FloatSetting();
            fDiffMultXPH = new FloatSetting();
            fDiffMultXPN = new FloatSetting();
            fDiffMultXPVE = new FloatSetting();
            fDiffMultXPVH = new FloatSetting();
            fDifficultyDamageMultiplier = new FloatSetting();
            fDifficultyDefaultValue = new FloatSetting();
            fDifficultyMaxValue = new FloatSetting();
            fDifficultyMinValue = new FloatSetting();
            fDisarmedPickupWeaponDistanceMult = new FloatSetting();
            fDisenchantSkillUse = new FloatSetting();
            fDistanceAutomaticallyActivateDoor = new FloatSetting();
            fDistanceExteriorReactCombat = new FloatSetting();
            fDistanceFadeActorAutoLoadDoor = new FloatSetting();
            fDistanceInteriorReactCombat = new FloatSetting();
            fDistanceProjectileExplosionDetection = new FloatSetting();
            fDistancetoPlayerforConversations = new FloatSetting();
            fDrinkRepeatRate = new FloatSetting();
            fDyingTimer = new FloatSetting();
            fEmbeddedWeaponSwitchChance = new FloatSetting();
            fEmbeddedWeaponSwitchTime = new FloatSetting();
            fEnchantingCostExponent = new FloatSetting();
            fEnchantingRuleOfFive = new FloatSetting();
            fEnchantingRuleOfTen = new FloatSetting();
            fEnchantingRuleOfTwo = new FloatSetting();
            fEnchantingSkillCostBase = new FloatSetting();
            fEnchantingSkillCostMult = new FloatSetting();
            fEnchantingSkillCostScale = new FloatSetting();
            fEnchantingSkillFactor = new FloatSetting();
            fEnchantmentEffectPointsMult = new FloatSetting();
            fEnchantmentGoldMult = new FloatSetting();
            fEnchantmentPointsMult = new FloatSetting();
            fEnemyHealthBarTimer = new FloatSetting();
            fEnvMapLOD = new FloatSetting();
            fEssentialDeathTime = new FloatSetting();
            fEssentialDownCombatHealthRegenMult = new FloatSetting();
            fEssentialHealthPercentReGain = new FloatSetting();
            fEssentialNPCMinimumHealth = new FloatSetting();
            fEssentialNonCombatHealRateBonus = new FloatSetting();
            fEvaluatePackageTimer = new FloatSetting();
            fEvaluateProcedureTimer = new FloatSetting();
            fExplodeLimbRemovalDelay = new FloatSetting();
            fExplodeLimbRemovalDelayVATS = new FloatSetting();
            fExplosionForceClutterUpBias = new FloatSetting();
            fExplosionForceKnockdownMinimum = new FloatSetting();
            fExplosionForceMultAngular = new FloatSetting();
            fExplosionForceMultLinear = new FloatSetting();
            fExplosionImageSpaceSwapPower = new FloatSetting();
            fExplosionKnockStateExplodeDownTime = new FloatSetting();
            fExplosionLOSBuffer = new FloatSetting();
            fExplosionLOSBufferDistance = new FloatSetting();
            fExplosionMaxImpulse = new FloatSetting();
            fExplosionSourceRefMult = new FloatSetting();
            fExplosionSplashRadius = new FloatSetting();
            fExplosionWaterRadiusRatio = new FloatSetting();
            fExplosiveProjectileBlockedResetTime = new FloatSetting();
            fExplosiveProjectileBlockedWaitTime = new FloatSetting();
            fExpressionChangePerSec = new FloatSetting();
            fExpressionStrengthAdd = new FloatSetting();
            fEyeEnvMapLOD = new FloatSetting();
            fEyeHeadingMaxOffsetEmotionAngry = new FloatSetting();
            fEyeHeadingMaxOffsetEmotionFear = new FloatSetting();
            fEyeHeadingMaxOffsetEmotionHappy = new FloatSetting();
            fEyeHeadingMaxOffsetEmotionNeutral = new FloatSetting();
            fEyeHeadingMaxOffsetEmotionSad = new FloatSetting();
            fEyeHeadingMinOffsetEmotionAngry = new FloatSetting();
            fEyeHeadingMinOffsetEmotionFear = new FloatSetting();
            fEyeHeadingMinOffsetEmotionHappy = new FloatSetting();
            fEyeHeadingMinOffsetEmotionNeutral = new FloatSetting();
            fEyeHeadingMinOffsetEmotionSad = new FloatSetting();
            fEyePitchMaxOffsetEmotionAngry = new FloatSetting();
            fEyePitchMaxOffsetEmotionFear = new FloatSetting();
            fEyePitchMaxOffsetEmotionHappy = new FloatSetting();
            fEyePitchMaxOffsetEmotionNeutral = new FloatSetting();
            fEyePitchMaxOffsetEmotionSad = new FloatSetting();
            fEyePitchMinOffsetEmotionAngry = new FloatSetting();
            fEyePitchMinOffsetEmotionFear = new FloatSetting();
            fEyePitchMinOffsetEmotionHappy = new FloatSetting();
            fEyePitchMinOffsetEmotionNeutral = new FloatSetting();
            fEyePitchMinOffsetEmotionSad = new FloatSetting();
            fFallLegDamageMult = new FloatSetting();
            fFastTravelSpeedMult = new FloatSetting();
            fFastWalkInterpolationBetweenWalkAndRun = new FloatSetting();
            fFavorCostActivator = new FloatSetting();
            fFavorCostAttack = new FloatSetting();
            fFavorCostAttackCrimeMult = new FloatSetting();
            fFavorCostLoadDoor = new FloatSetting();
            fFavorCostNonLoadDoor = new FloatSetting();
            fFavorCostOwnedDoorMult = new FloatSetting();
            fFavorCostStealContainerCrime = new FloatSetting();
            fFavorCostStealContainerMult = new FloatSetting();
            fFavorCostStealObjectMult = new FloatSetting();
            fFavorCostTakeObject = new FloatSetting();
            fFavorCostUnlockContainer = new FloatSetting();
            fFavorCostUnlockDoor = new FloatSetting();
            fFavorEventStopDistance = new FloatSetting();
            fFavorEventTriggerDistance = new FloatSetting();
            fFavorRequestPickDistance = new FloatSetting();
            fFavorRequestRadius = new FloatSetting();
            fFavorRequestWaitTimer = new FloatSetting();
            fFirstPersonLookAtVertOffset = new FloatSetting();
            fFleeDistanceExterior = new FloatSetting();
            fFleeDistanceInterior = new FloatSetting();
            fFleeDoneDistanceExterior = new FloatSetting();
            fFleeDoneDistanceInterior = new FloatSetting();
            fFleeIsSafeTimer = new FloatSetting();
            fFloatQuestMarkerFloatHeight = new FloatSetting();
            fFloatQuestMarkerMaxDistance = new FloatSetting();
            fFloatQuestMarkerMinDistance = new FloatSetting();
            fFlyingActorDefaultTurningSpeed = new FloatSetting();
            fFollowExtraCatchUpSpeedMult = new FloatSetting();
            fFollowMatchSpeedZoneWidth = new FloatSetting();
            fFollowRunMaxSpeedupMultiplier = new FloatSetting();
            fFollowRunMinSlowdownMultiplier = new FloatSetting();
            fFollowSlowdownZoneWidth = new FloatSetting();
            fFollowSpaceBetweenFollowers = new FloatSetting();
            fFollowStartSprintDistance = new FloatSetting();
            fFollowStopZoneMinMult = new FloatSetting();
            fFollowWalkMaxSpeedupMultiplier = new FloatSetting();
            fFollowWalkMinSlowdownMultiplier = new FloatSetting();
            fFollowWalkZoneMult = new FloatSetting();
            fFollowerSpacingAtDoors = new FloatSetting();
            fFriendHitTimer = new FloatSetting();
            fFriendMinimumLastHitTime = new FloatSetting();
            fFurnitureMarkerAngleTolerance = new FloatSetting();
            fFurnitureScaleAnimDurationNPC = new FloatSetting();
            fFurnitureScaleAnimDurationPlayer = new FloatSetting();
            fGameplayImpulseMinMass = new FloatSetting();
            fGameplayImpulseMultBiped = new FloatSetting();
            fGameplayImpulseMultClutter = new FloatSetting();
            fGameplayImpulseMultDebrisLarge = new FloatSetting();
            fGameplayImpulseMultProp = new FloatSetting();
            fGameplayImpulseMultTrap = new FloatSetting();
            fGameplayImpulseScale = new FloatSetting();
            fGameplaySpeakingEmotionMaxChangeValue = new FloatSetting();
            fGameplaySpeakingEmotionMinChangeValue = new FloatSetting();
            fGameplayVoiceFilePadding = new FloatSetting();
            fGameplayiSpeakingEmotionMaxDeltaChange = new FloatSetting();
            fGameplayiSpeakingEmotionMinDeltaChange = new FloatSetting();
            fGetHitPainMult = new FloatSetting();
            fGrabMaxWeightRunning = new FloatSetting();
            fGrabMaxWeightWalking = new FloatSetting();
            fGrenadeAgeMax = new FloatSetting();
            fGrenadeFriction = new FloatSetting();
            fGrenadeHighArcSpeedPercentage = new FloatSetting();
            fGrenadeRestitution = new FloatSetting();
            fGrenadeThrowHitFractionThreshold = new FloatSetting();
            fGuardPackageAttackRadiusMult = new FloatSetting();
            fGunDecalCameraDistance = new FloatSetting();
            fGunParticleCameraDistance = new FloatSetting();
            fGunReferenceSkill = new FloatSetting();
            fGunShellCameraDistance = new FloatSetting();
            fGunShellDirectionRandomize = new FloatSetting();
            fGunShellEjectSpeed = new FloatSetting();
            fGunShellLifetime = new FloatSetting();
            fGunShellRotateRandomize = new FloatSetting();
            fGunShellRotateSpeed = new FloatSetting();
            fGunSpreadArmBase = new FloatSetting();
            fGunSpreadArmMult = new FloatSetting();
            fGunSpreadCondBase = new FloatSetting();
            fGunSpreadCondMult = new FloatSetting();
            fGunSpreadCrouchBase = new FloatSetting();
            fGunSpreadCrouchMult = new FloatSetting();
            fGunSpreadDriftBase = new FloatSetting();
            fGunSpreadDriftMult = new FloatSetting();
            fGunSpreadHeadBase = new FloatSetting();
            fGunSpreadHeadMult = new FloatSetting();
            fGunSpreadIronSightsBase = new FloatSetting();
            fGunSpreadIronSightsMult = new FloatSetting();
            fGunSpreadNPCArmBase = new FloatSetting();
            fGunSpreadNPCArmMult = new FloatSetting();
            fGunSpreadRunBase = new FloatSetting();
            fGunSpreadRunMult = new FloatSetting();
            fGunSpreadSkillBase = new FloatSetting();
            fGunSpreadSkillMult = new FloatSetting();
            fGunSpreadWalkBase = new FloatSetting();
            fGunSpreadWalkMult = new FloatSetting();
            fHUDCompassLocationMaxDist = new FloatSetting();
            fHUDOpacity = new FloatSetting();
            fHandDamageSkillBase = new FloatSetting();
            fHandDamageSkillMult = new FloatSetting();
            fHandDamageStrengthBase = new FloatSetting();
            fHandDamageStrengthMult = new FloatSetting();
            fHandHealthMax = new FloatSetting();
            fHandHealthMin = new FloatSetting();
            fHandReachDefault = new FloatSetting();
            fHavokTauRatio = new FloatSetting();
            fHazardDropMaxDistance = new FloatSetting();
            fHazardMaxWaitTime = new FloatSetting();
            fHazardSpacingMult = new FloatSetting();
            fHeadTrackSpeedMax = new FloatSetting();
            fHeadTrackSpeedMaxAngle = new FloatSetting();
            fHeadTrackSpeedMin = new FloatSetting();
            fHeadTrackSpeedMinAngle = new FloatSetting();
            fHeadingMarkerAngleTolerance = new FloatSetting();
            fHealthRegenDelayMax = new FloatSetting();
            fHorseMountOffsetX = new FloatSetting();
            fHorseMountOffsetY = new FloatSetting();
            fHostileActorExteriorDistance = new FloatSetting();
            fHostileActorInteriorDistance = new FloatSetting();
            fHostileFlyingActorExteriorDistance = new FloatSetting();
            fIdleChatterCommentTimer = new FloatSetting();
            fIdleChatterCommentTimerMax = new FloatSetting();
            fIdleMarkerAngleTolerance = new FloatSetting();
            fImpactShaderMaxDistance = new FloatSetting();
            fImpactShaderMaxMagnitude = new FloatSetting();
            fImpactShaderMinMagnitude = new FloatSetting();
            fIntimidateConfidenceMultAverage = new FloatSetting();
            fIntimidateConfidenceMultBrave = new FloatSetting();
            fIntimidateConfidenceMultCautious = new FloatSetting();
            fIntimidateConfidenceMultCowardly = new FloatSetting();
            fIntimidateConfidenceMultFoolhardy = new FloatSetting();
            fIntimidateSpeechcraftCurve = new FloatSetting();
            fInventory = new FloatSetting();
            fInventoryLight = new FloatSetting();
            fInventoryMenuLight = new FloatSetting();
            fIronSightsDOFDistance = new FloatSetting();
            fIronSightsDOFRange = new FloatSetting();
            fIronSightsDOFStrengthCap = new FloatSetting();
            fIronSightsDOFSwitchSeconds = new FloatSetting();
            fIronSightsFOVTimeChange = new FloatSetting();
            fIronSightsGunMotionBlur = new FloatSetting();
            fIronSightsMotionBlur = new FloatSetting();
            fItemPointsMult = new FloatSetting();
            fItemRepairCostMult = new FloatSetting();
            fJogInterpolationBetweenWalkAndRun = new FloatSetting();
            fJumpDoubleMult = new FloatSetting();
            fJumpFallHeightExponent = new FloatSetting();
            fJumpFallHeightExponentNPC = new FloatSetting();
            fJumpFallHeightMin = new FloatSetting();
            fJumpFallHeightMinNPC = new FloatSetting();
            fJumpFallHeightMult = new FloatSetting();
            fJumpFallHeightMultNPC = new FloatSetting();
            fJumpFallRiderMult = new FloatSetting();
            fJumpFallSkillBase = new FloatSetting();
            fJumpFallSkillMult = new FloatSetting();
            fJumpFallVelocityMin = new FloatSetting();
            fJumpHeightMin = new FloatSetting();
            fJumpMoveBase = new FloatSetting();
            fJumpMoveMult = new FloatSetting();
            fJumpSwimmingMult = new FloatSetting();
            fKarmaModKillingEvilActor = new FloatSetting();
            fKarmaModMurderingNonEvilCreature = new FloatSetting();
            fKarmaModMurderingNonEvilNPC = new FloatSetting();
            fKarmaModStealing = new FloatSetting();
            fKillCamBaseOdds = new FloatSetting();
            fKillCamLevelBias = new FloatSetting();
            fKillCamLevelFactor = new FloatSetting();
            fKillCamLevelMaxBias = new FloatSetting();
            fKillMoveMaxDuration = new FloatSetting();
            fKillWitnessesTimerSetting = new FloatSetting();
            fKnockbackAgilBase = new FloatSetting();
            fKnockbackAgilMult = new FloatSetting();
            fKnockbackDamageBase = new FloatSetting();
            fKnockbackDamageMult = new FloatSetting();
            fKnockbackForceMax = new FloatSetting();
            fKnockbackTime = new FloatSetting();
            fKnockdownAgilBase = new FloatSetting();
            fKnockdownAgilMult = new FloatSetting();
            fKnockdownBaseHealthThreshold = new FloatSetting();
            fKnockdownChance = new FloatSetting();
            fKnockdownCurrentHealthThreshold = new FloatSetting();
            fKnockdownDamageBase = new FloatSetting();
            fKnockdownDamageMult = new FloatSetting();
            fLargeProjectilePickBufferSize = new FloatSetting();
            fLargeProjectileSize = new FloatSetting();
            fLevelUpCarryWeightMod = new FloatSetting();
            fLightRecalcTimer = new FloatSetting();
            fLightRecalcTimerPlayer = new FloatSetting();
            fLoadingWheelScale = new FloatSetting();
            fLockLevelBase = new FloatSetting();
            fLockLevelMult = new FloatSetting();
            fLockPickBreakBase = new FloatSetting();
            fLockPickBreakMult = new FloatSetting();
            fLockPickQualityBase = new FloatSetting();
            fLockPickQualityMult = new FloatSetting();
            fLockSkillBase = new FloatSetting();
            fLockSkillMult = new FloatSetting();
            fLockTrapGoOffBase = new FloatSetting();
            fLockTrapGoOffMult = new FloatSetting();
            fLockpickBreakAdept = new FloatSetting();
            fLockpickBreakApprentice = new FloatSetting();
            fLockpickBreakExpert = new FloatSetting();
            fLockpickBreakMaster = new FloatSetting();
            fLockpickBreakNovice = new FloatSetting();
            fLockpickBreakSkillBase = new FloatSetting();
            fLockpickBreakSkillMult = new FloatSetting();
            fLockpickBrokenPicksMult = new FloatSetting();
            fLockpickSkillPartialPickBase = new FloatSetting();
            fLockpickSkillPartialPickMult = new FloatSetting();
            fLockpickSkillSweetSpotBase = new FloatSetting();
            fLockpickSkillSweetSpotMult = new FloatSetting();
            fLookDownDisableBlinkingAmt = new FloatSetting();
            fLookGraphX = new FloatSetting();
            fLookGraphY = new FloatSetting();
            fLowHealthTutorialPercentage = new FloatSetting();
            fLowLevelNPCBaseHealthMult = new FloatSetting();
            fLowMagickaTutorialPercentage = new FloatSetting();
            fLowStaminaTutorialPercentage = new FloatSetting();
            fMagic = new FloatSetting();
            fMagicAbsorbDistanceReachMult = new FloatSetting();
            fMagicAbsorbVisualTimer = new FloatSetting();
            fMagicAccumulatingModifierEffectHoldDuration = new FloatSetting();
            fMagicAreaBaseCostMult = new FloatSetting();
            fMagicAreaScale = new FloatSetting();
            fMagicAreaScaleMax = new FloatSetting();
            fMagicAreaScaleMin = new FloatSetting();
            fMagicBarrierDepth = new FloatSetting();
            fMagicBarrierHeight = new FloatSetting();
            fMagicBarrierSpacing = new FloatSetting();
            fMagicBoltDuration = new FloatSetting();
            fMagicBoltSegmentLength = new FloatSetting();
            fMagicCEEnchantMagOffset = new FloatSetting();
            fMagicCasterPCSkillCostBase = new FloatSetting();
            fMagicCasterPCSkillCostMult = new FloatSetting();
            fMagicCasterSkillCostBase = new FloatSetting();
            fMagicCasterSkillCostMult = new FloatSetting();
            fMagicChainExplosionEffectivenessDelta = new FloatSetting();
            fMagicCloudAreaMin = new FloatSetting();
            fMagicCloudDurationMin = new FloatSetting();
            fMagicCloudFindTargetTime = new FloatSetting();
            fMagicCloudLifeScale = new FloatSetting();
            fMagicCloudSizeScale = new FloatSetting();
            fMagicCloudSlowdownRate = new FloatSetting();
            fMagicCloudSpeedBase = new FloatSetting();
            fMagicCloudSpeedScale = new FloatSetting();
            fMagicCostScale = new FloatSetting();
            fMagicDefaultAccumulatingModifierEffectRate = new FloatSetting();
            fMagicDefaultTouchDistance = new FloatSetting();
            fMagicDiseaseTransferBase = new FloatSetting();
            fMagicDiseaseTransferMult = new FloatSetting();
            fMagicDispelMagnitudeMult = new FloatSetting();
            fMagicDualCastingCostBase = new FloatSetting();
            fMagicDualCastingCostMult = new FloatSetting();
            fMagicDualCastingEffectivenessBase = new FloatSetting();
            fMagicDualCastingEffectivenessMult = new FloatSetting();
            fMagicDualCastingTimeBase = new FloatSetting();
            fMagicDualCastingTimeMult = new FloatSetting();
            fMagicDurMagBaseCostMult = new FloatSetting();
            fMagicEnchantmentChargeBase = new FloatSetting();
            fMagicEnchantmentChargeMult = new FloatSetting();
            fMagicEnchantmentDrainBase = new FloatSetting();
            fMagicEnchantmentDrainMult = new FloatSetting();
            fMagicExplosionAgilityMult = new FloatSetting();
            fMagicExplosionClutterMult = new FloatSetting();
            fMagicExplosionIncorporealMult = new FloatSetting();
            fMagicExplosionIncorporealTime = new FloatSetting();
            fMagicExplosionPowerBase = new FloatSetting();
            fMagicExplosionPowerMax = new FloatSetting();
            fMagicExplosionPowerMin = new FloatSetting();
            fMagicExplosionPowerMult = new FloatSetting();
            fMagicGuideSpacing = new FloatSetting();
            fMagicLightForwardOffset = new FloatSetting();
            fMagicLightHeightOffset = new FloatSetting();
            fMagicLightRadiusBase = new FloatSetting();
            fMagicLightSideOffset = new FloatSetting();
            fMagicNightEyeAmbient = new FloatSetting();
            fMagicPCSkillCostScale = new FloatSetting();
            fMagicPlayerMinimumInvisibility = new FloatSetting();
            fMagicPostDrawCastDelay = new FloatSetting();
            fMagicProjectileMaxDistance = new FloatSetting();
            fMagicRangeTargetCostMult = new FloatSetting();
            fMagicResistActorSkillBase = new FloatSetting();
            fMagicResistActorSkillMult = new FloatSetting();
            fMagicResistTargetWillpowerBase = new FloatSetting();
            fMagicResistTargetWillpowerMult = new FloatSetting();
            fMagicSkillCostScale = new FloatSetting();
            fMagicSummonMaxAppearTime = new FloatSetting();
            fMagicTelekinesiDistanceMult = new FloatSetting();
            fMagicTelekinesisBaseDistance = new FloatSetting();
            fMagicTelekinesisComplexMaxForce = new FloatSetting();
            fMagicTelekinesisComplexObjectDamping = new FloatSetting();
            fMagicTelekinesisComplexSpringDamping = new FloatSetting();
            fMagicTelekinesisComplexSpringElasticity = new FloatSetting();
            fMagicTelekinesisDamageBase = new FloatSetting();
            fMagicTelekinesisDamageMult = new FloatSetting();
            fMagicTelekinesisDistanceMin = new FloatSetting();
            fMagicTelekinesisDualCastDamageMult = new FloatSetting();
            fMagicTelekinesisDualCastThrowMult = new FloatSetting();
            fMagicTelekinesisLiftPowerMult = new FloatSetting();
            fMagicTelekinesisMaxForce = new FloatSetting();
            fMagicTelekinesisMoveAccelerate = new FloatSetting();
            fMagicTelekinesisMoveBase = new FloatSetting();
            fMagicTelekinesisMoveMax = new FloatSetting();
            fMagicTelekinesisObjectDamping = new FloatSetting();
            fMagicTelekinesisSpringDamping = new FloatSetting();
            fMagicTelekinesisSpringElasticity = new FloatSetting();
            fMagicTelekinesisThrow = new FloatSetting();
            fMagicTelekinesisThrowAccelerate = new FloatSetting();
            fMagicTelekinesisThrowMax = new FloatSetting();
            fMagicTrackingLimit = new FloatSetting();
            fMagicTrackingLimitComplex = new FloatSetting();
            fMagicTrackingMultBall = new FloatSetting();
            fMagicTrackingMultBolt = new FloatSetting();
            fMagicTrackingMultFog = new FloatSetting();
            fMagicUnitsPerFoot = new FloatSetting();
            fMagicVACNoPartTargetedMult = new FloatSetting();
            fMagicVACPartTargetedMult = new FloatSetting();
            fMagicWardPowerMaxBase = new FloatSetting();
            fMagicWardPowerMaxMult = new FloatSetting();
            fMagickaRegenDelayMax = new FloatSetting();
            fMagickaReturnBase = new FloatSetting();
            fMagickaReturnMult = new FloatSetting();
            fMapMarkerMaxPercentSize = new FloatSetting();
            fMapMarkerMinFadeAlpha = new FloatSetting();
            fMapMarkerMinPercentSize = new FloatSetting();
            fMapQuestMarkerMaxPercentSize = new FloatSetting();
            fMapQuestMarkerMinFadeAlpha = new FloatSetting();
            fMapQuestMarkerMinPercentSize = new FloatSetting();
            fMasserAngleFadeEnd = new FloatSetting();
            fMasserAngleFadeStart = new FloatSetting();
            fMasserAngleShadowEarlyFade = new FloatSetting();
            fMasserSpeed = new FloatSetting();
            fMasserZOffset = new FloatSetting();
            fMaxArmorRating = new FloatSetting();
            fMaxSandboxRescanSeconds = new FloatSetting();
            fMaxSellMult = new FloatSetting();
            fMaximumWind = new FloatSetting();
            fMeleeMovementRestrictionsUpdateTime = new FloatSetting();
            fMeleeSweepViewAngleMult = new FloatSetting();
            fMeshLODLevel = new FloatSetting();
            fMinBuyMult = new FloatSetting();
            fMinDistanceUseHorse = new FloatSetting();
            fMinSandboxRescanSeconds = new FloatSetting();
            fMineAgeMax = new FloatSetting();
            fMineExteriorRadiusMult = new FloatSetting();
            fMinesBlinkFast = new FloatSetting();
            fMinesBlinkMax = new FloatSetting();
            fMinesBlinkSlow = new FloatSetting();
            fMinesDelayMin = new FloatSetting();
            fModelReferenceEffectMaxWaitTime = new FloatSetting();
            fMostCommonProjectileCollisionRadius = new FloatSetting();
            fMotionBlur = new FloatSetting();
            fMountedMaxLookingDown = new FloatSetting();
            fMoveCharRunBase = new FloatSetting();
            fMoveCharWalkBase = new FloatSetting();
            fMoveEncumEffect = new FloatSetting();
            fMoveEncumEffectNoWeapon = new FloatSetting();
            fMoveFlyRunMult = new FloatSetting();
            fMoveFlyWalkMult = new FloatSetting();
            fMoveGraphX = new FloatSetting();
            fMoveGraphY = new FloatSetting();
            fMoveSprintMult = new FloatSetting();
            fMoveSwimMult = new FloatSetting();
            fMoveWeightMax = new FloatSetting();
            fMoveWeightMin = new FloatSetting();
            fMovementNearTargetAvoidCost = new FloatSetting();
            fMovementNearTargetAvoidRadius = new FloatSetting();
            fMovementTargetAvoidCost = new FloatSetting();
            fMovementTargetAvoidRadius = new FloatSetting();
            fMovementTargetAvoidRadiusMult = new FloatSetting();
            fNPCAttributeHealthMult = new FloatSetting();
            fNPCBaseMagickaMult = new FloatSetting();
            fNPCHealthLevelBonus = new FloatSetting();
            fNear = new FloatSetting();
            fObjectHitH = new FloatSetting();
            fObjectHitTwoHandReach = new FloatSetting();
            fObjectHitWeaponReach = new FloatSetting();
            fObjectMotionBlur = new FloatSetting();
            fObjectWeightPickupDetectionMult = new FloatSetting();
            fOutOfBreathStaminaRegenDelay = new FloatSetting();
            fPCBaseHealthMult = new FloatSetting();
            fPCBaseMagickaMult = new FloatSetting();
            fPCHealthLevelBonus = new FloatSetting();
            fPainDelay = new FloatSetting();
            fPartialPickAverage = new FloatSetting();
            fPartialPickEasy = new FloatSetting();
            fPartialPickHard = new FloatSetting();
            fPartialPickVeryEasy = new FloatSetting();
            fPartialPickVeryHard = new FloatSetting();
            fPerceptionMult = new FloatSetting();
            fPerkHeavyArmorExpertSpeedMult = new FloatSetting();
            fPerkHeavyArmorJourneymanDamageMult = new FloatSetting();
            fPerkHeavyArmorMasterSpeedMult = new FloatSetting();
            fPerkHeavyArmorNoviceDamageMult = new FloatSetting();
            fPerkHeavyArmorSinkGravityMult = new FloatSetting();
            fPerkLightArmorExpertSpeedMult = new FloatSetting();
            fPerkLightArmorJourneymanDamageMult = new FloatSetting();
            fPerkLightArmorMasterRatingMult = new FloatSetting();
            fPerkLightArmorNoviceDamageMult = new FloatSetting();
            fPersAdmireAggr = new FloatSetting();
            fPersAdmireConf = new FloatSetting();
            fPersAdmireEner = new FloatSetting();
            fPersAdmireIntel = new FloatSetting();
            fPersAdmirePers = new FloatSetting();
            fPersAdmireResp = new FloatSetting();
            fPersAdmireStre = new FloatSetting();
            fPersAdmireWillp = new FloatSetting();
            fPersBoastAggr = new FloatSetting();
            fPersBoastConf = new FloatSetting();
            fPersBoastEner = new FloatSetting();
            fPersBoastIntel = new FloatSetting();
            fPersBoastPers = new FloatSetting();
            fPersBoastResp = new FloatSetting();
            fPersBoastStre = new FloatSetting();
            fPersBoastWillp = new FloatSetting();
            fPersBullyAggr = new FloatSetting();
            fPersBullyConf = new FloatSetting();
            fPersBullyEner = new FloatSetting();
            fPersBullyIntel = new FloatSetting();
            fPersBullyPers = new FloatSetting();
            fPersBullyResp = new FloatSetting();
            fPersBullyStre = new FloatSetting();
            fPersBullyWillp = new FloatSetting();
            fPersJokeAggr = new FloatSetting();
            fPersJokeConf = new FloatSetting();
            fPersJokeEner = new FloatSetting();
            fPersJokeIntel = new FloatSetting();
            fPersJokePers = new FloatSetting();
            fPersJokeResp = new FloatSetting();
            fPersJokeStre = new FloatSetting();
            fPersJokeWillp = new FloatSetting();
            fPersuasionAccuracyMaxDisposition = new FloatSetting();
            fPersuasionAccuracyMaxSelect = new FloatSetting();
            fPersuasionAccuracyMinDispostion = new FloatSetting();
            fPersuasionAccuracyMinSelect = new FloatSetting();
            fPersuasionBaseValueMaxDisposition = new FloatSetting();
            fPersuasionBaseValueMaxSelect = new FloatSetting();
            fPersuasionBaseValueMinDispostion = new FloatSetting();
            fPersuasionBaseValueMinSelect = new FloatSetting();
            fPersuasionBaseValueShape = new FloatSetting();
            fPersuasionMaxDisposition = new FloatSetting();
            fPersuasionMaxInput = new FloatSetting();
            fPersuasionMaxSelect = new FloatSetting();
            fPersuasionMinDispostion = new FloatSetting();
            fPersuasionMinInput = new FloatSetting();
            fPersuasionMinPercentCircle = new FloatSetting();
            fPersuasionMinSelect = new FloatSetting();
            fPersuasionShape = new FloatSetting();
            fPhysicsDamage = new FloatSetting();
            fPhysicsDamageSpeedBase = new FloatSetting();
            fPhysicsDamageSpeedMin = new FloatSetting();
            fPhysicsDamageSpeedMult = new FloatSetting();
            fPickLevelBase = new FloatSetting();
            fPickLevelMult = new FloatSetting();
            fPickMaxAngle = new FloatSetting();
            fPickNumBase = new FloatSetting();
            fPickNumMult = new FloatSetting();
            fPickPocketActorSkillBase = new FloatSetting();
            fPickPocketActorSkillMult = new FloatSetting();
            fPickPocketAmountBase = new FloatSetting();
            fPickPocketAmountMult = new FloatSetting();
            fPickPocketDetected = new FloatSetting();
            fPickPocketMaxChance = new FloatSetting();
            fPickPocketMinChance = new FloatSetting();
            fPickPocketTargetSkillBase = new FloatSetting();
            fPickPocketTargetSkillMult = new FloatSetting();
            fPickPocketWeightBase = new FloatSetting();
            fPickPocketWeightMult = new FloatSetting();
            fPickSpring = new FloatSetting();
            fPickUpWeaponDelay = new FloatSetting();
            fPickpocketSkillUsesCurve = new FloatSetting();
            fPickupItemDistanceFudge = new FloatSetting();
            fPickupWeaponDistanceMinMaxDPSMult = new FloatSetting();
            fPickupWeaponMeleeDistanceMax = new FloatSetting();
            fPickupWeaponMeleeDistanceMin = new FloatSetting();
            fPickupWeaponMeleeWeaponDPSMult = new FloatSetting();
            fPickupWeaponMinDPSImprovementPercent = new FloatSetting();
            fPickupWeaponRangedDistanceMax = new FloatSetting();
            fPickupWeaponRangedDistanceMin = new FloatSetting();
            fPickupWeaponRangedMeleeDPSRatioThreshold = new FloatSetting();
            fPickupWeaponTargetUnreachableDistanceMult = new FloatSetting();
            fPickupWeaponUnarmedDistanceMax = new FloatSetting();
            fPickupWeaponUnarmedDistanceMin = new FloatSetting();
            fPlayerDeathReloadTime = new FloatSetting();
            fPlayerDetectActorValue = new FloatSetting();
            fPlayerDetectionSneakBase = new FloatSetting();
            fPlayerDetectionSneakMult = new FloatSetting();
            fPlayerDropDistance = new FloatSetting();
            fPlayerHealthHeartbeatFast = new FloatSetting();
            fPlayerHealthHeartbeatSlow = new FloatSetting();
            fPlayerMaxResistance = new FloatSetting();
            fPlayerTargetCombatDistance = new FloatSetting();
            fPlayerTeleportFadeSeconds = new FloatSetting();
            fPlayerVelocityCacheTime = new FloatSetting();
            fPlayerVelocitySampleInterval = new FloatSetting();
            fPlayerVelocitySampleTime = new FloatSetting();
            fPotionGoldValueMult = new FloatSetting();
            fPotionMortPestleMult = new FloatSetting();
            fPotionT = new FloatSetting();
            fPowerAttackCoolDownTime = new FloatSetting();
            fPowerAttackDefaultBonus = new FloatSetting();
            fPowerAttackStaminaPenalty = new FloatSetting();
            fProjectileCollisionImpulseScale = new FloatSetting();
            fProjectileDefaultTracerRange = new FloatSetting();
            fProjectileDeflectionTime = new FloatSetting();
            fProjectileInventoryGrenadeFreakoutTime = new FloatSetting();
            fProjectileInventoryGrenadeTimer = new FloatSetting();
            fProjectileKnockMinMass = new FloatSetting();
            fProjectileKnockMultBiped = new FloatSetting();
            fProjectileKnockMultClutter = new FloatSetting();
            fProjectileKnockMultProp = new FloatSetting();
            fProjectileKnockMultTrap = new FloatSetting();
            fProjectileMaxDistance = new FloatSetting();
            fProjectileReorientTracerMin = new FloatSetting();
            fQuestCinematicCharacterFadeIn = new FloatSetting();
            fQuestCinematicCharacterFadeInDelay = new FloatSetting();
            fQuestCinematicCharacterFadeOut = new FloatSetting();
            fQuestCinematicCharacterRemain = new FloatSetting();
            fQuestCinematicObjectiveFadeIn = new FloatSetting();
            fQuestCinematicObjectiveFadeInDelay = new FloatSetting();
            fQuestCinematicObjectiveFadeOut = new FloatSetting();
            fQuestCinematicObjectivePauseTime = new FloatSetting();
            fQuestCinematicObjectiveScrollTime = new FloatSetting();
            fRandomSceneAgainMaxTime = new FloatSetting();
            fRandomSceneAgainMinTime = new FloatSetting();
            fReEquipArmorTime = new FloatSetting();
            fRechargeGoldMult = new FloatSetting();
            fReflectedAbsorbChanceReduction = new FloatSetting();
            fRelationshipBase = new FloatSetting();
            fRelationshipMult = new FloatSetting();
            fRemoteCombatMissedAttack = new FloatSetting();
            fRemoveExcessComplexDeadTime = new FloatSetting();
            fRemoveExcessDeadTime = new FloatSetting();
            fRepairMax = new FloatSetting();
            fRepairMin = new FloatSetting();
            fRepairScavengeMult = new FloatSetting();
            fRepairSkillBase = new FloatSetting();
            fRepairSkillMax = new FloatSetting();
            fReservationExpirationSeconds = new FloatSetting();
            fResistArrestTimer = new FloatSetting();
            fRockitDamageBonusWeightMin = new FloatSetting();
            fRockitDamageBonusWeightMult = new FloatSetting();
            fRoomLightingTransitionDuration = new FloatSetting();
            fRumbleBlockStrength = new FloatSetting();
            fRumbleBlockTime = new FloatSetting();
            fRumbleHitBlockedStrength = new FloatSetting();
            fRumbleHitBlockedTime = new FloatSetting();
            fRumbleHitStrength = new FloatSetting();
            fRumbleHitTime = new FloatSetting();
            fRumblePainStrength = new FloatSetting();
            fRumblePainTime = new FloatSetting();
            fRumbleShakeRadiusMult = new FloatSetting();
            fRumbleShakeTimeMult = new FloatSetting();
            fRumbleStruckStrength = new FloatSetting();
            fRumbleStruckTime = new FloatSetting();
            fSandBoxDelayEvalSeconds = new FloatSetting();
            fSandBoxExtraDialogueRange = new FloatSetting();
            fSandBoxInterMarkerMinDist = new FloatSetting();
            fSandBoxRadiusHysteresis = new FloatSetting();
            fSandBoxSearchRadius = new FloatSetting();
            fSandboxBreakfastMax = new FloatSetting();
            fSandboxBreakfastMin = new FloatSetting();
            fSandboxCylinderBottom = new FloatSetting();
            fSandboxCylinderTop = new FloatSetting();
            fSandboxDinnerMax = new FloatSetting();
            fSandboxDinnerMin = new FloatSetting();
            fSandboxDurationBase = new FloatSetting();
            fSandboxDurationMultEatSitting = new FloatSetting();
            fSandboxDurationMultEatStanding = new FloatSetting();
            fSandboxDurationMultFurniture = new FloatSetting();
            fSandboxDurationMultIdleMarker = new FloatSetting();
            fSandboxDurationMultSitting = new FloatSetting();
            fSandboxDurationMultSleeping = new FloatSetting();
            fSandboxDurationMultWandering = new FloatSetting();
            fSandboxDurationRangeMult = new FloatSetting();
            fSandboxEnergyMult = new FloatSetting();
            fSandboxEnergyMultEatSitting = new FloatSetting();
            fSandboxEnergyMultEatStanding = new FloatSetting();
            fSandboxEnergyMultFurniture = new FloatSetting();
            fSandboxEnergyMultIdleMarker = new FloatSetting();
            fSandboxEnergyMultSitting = new FloatSetting();
            fSandboxEnergyMultSleeping = new FloatSetting();
            fSandboxEnergyMultWandering = new FloatSetting();
            fSandboxLunchMax = new FloatSetting();
            fSandboxLunchMin = new FloatSetting();
            fSandboxMealDurationMax = new FloatSetting();
            fSandboxMealDurationMin = new FloatSetting();
            fSandboxSleepDurationMax = new FloatSetting();
            fSandboxSleepDurationMin = new FloatSetting();
            fSandboxSleepStartMax = new FloatSetting();
            fSandboxSleepStartMin = new FloatSetting();
            fSayOncePerDayInfoTimer = new FloatSetting();
            fScrollCostMult = new FloatSetting();
            fSecondsBetweenWindowUpdate = new FloatSetting();
            fSecundaAngleFadeEnd = new FloatSetting();
            fSecundaAngleFadeStart = new FloatSetting();
            fSecundaAngleShadowEarlyFade = new FloatSetting();
            fSecundaSpeed = new FloatSetting();
            fSecundaZOffset = new FloatSetting();
            fShieldBaseFactor = new FloatSetting();
            fShieldBashMax = new FloatSetting();
            fShieldBashMin = new FloatSetting();
            fShieldBashPCMax = new FloatSetting();
            fShieldBashPCMin = new FloatSetting();
            fShieldBashSkillUseBase = new FloatSetting();
            fShieldBashSkillUseMult = new FloatSetting();
            fShieldScalingFactor = new FloatSetting();
            fShockBoltGrowWidth = new FloatSetting();
            fShockBoltSmallWidth = new FloatSetting();
            fShockBoltsLength = new FloatSetting();
            fShockBoltsRadius = new FloatSetting();
            fShockBoltsRadiusStrength = new FloatSetting();
            fShockBranchBoltsRadius = new FloatSetting();
            fShockBranchBoltsRadiusStrength = new FloatSetting();
            fShockBranchLifetime = new FloatSetting();
            fShockBranchSegmentLength = new FloatSetting();
            fShockBranchSegmentVariance = new FloatSetting();
            fShockCastVOffset = new FloatSetting();
            fShockCoreColorB = new FloatSetting();
            fShockCoreColorG = new FloatSetting();
            fShockCoreColorR = new FloatSetting();
            fShockGlowColorB = new FloatSetting();
            fShockGlowColorG = new FloatSetting();
            fShockGlowColorR = new FloatSetting();
            fShockSegmentLength = new FloatSetting();
            fShockSegmentVariance = new FloatSetting();
            fShockSubSegmentVariance = new FloatSetting();
            fShoutTime = new FloatSetting();
            fShoutTimeout = new FloatSetting();
            fSittingMaxLookingDown = new FloatSetting();
            fSkillUsageLockPickAverage = new FloatSetting();
            fSkillUsageLockPickBroken = new FloatSetting();
            fSkillUsageLockPickEasy = new FloatSetting();
            fSkillUsageLockPickHard = new FloatSetting();
            fSkillUsageLockPickVeryEasy = new FloatSetting();
            fSkillUsageLockPickVeryHard = new FloatSetting();
            fSkillUsageRechargeMult = new FloatSetting();
            fSkillUsageSneakHidden = new FloatSetting();
            fSkillUsageSneakPerSecond = new FloatSetting();
            fSkillUseCurve = new FloatSetting();
            fSkinnedDecalLOD = new FloatSetting();
            fSkyCellRefFadeDistance = new FloatSetting();
            fSmallBumpSpeed = new FloatSetting();
            fSmithingArmorMax = new FloatSetting();
            fSmithingConditionFactor = new FloatSetting();
            fSmithingWeaponMax = new FloatSetting();
            fSneakActionMult = new FloatSetting();
            fSneakAlertMod = new FloatSetting();
            fSneakAmbushNonTargetMod = new FloatSetting();
            fSneakAmbushTargetMod = new FloatSetting();
            fSneakAttackSkillUsageMelee = new FloatSetting();
            fSneakAttackSkillUsageRanged = new FloatSetting();
            fSneakBaseValue = new FloatSetting();
            fSneakCombatMod = new FloatSetting();
            fSneakDetectionSizeLarge = new FloatSetting();
            fSneakDetectionSizeNormal = new FloatSetting();
            fSneakDetectionSizeSmall = new FloatSetting();
            fSneakDetectionSizeVeryLarge = new FloatSetting();
            fSneakDistanceAttenuationExponent = new FloatSetting();
            fSneakEquippedWeightBase = new FloatSetting();
            fSneakEquippedWeightMult = new FloatSetting();
            fSneakExteriorDistanceMult = new FloatSetting();
            fSneakFlyingDistanceMult = new FloatSetting();
            fSneakLightExteriorMult = new FloatSetting();
            fSneakLightMoveMult = new FloatSetting();
            fSneakLightMult = new FloatSetting();
            fSneakLightRunMult = new FloatSetting();
            fSneakMaxDistance = new FloatSetting();
            fSneakNoticeMin = new FloatSetting();
            fSneakPerceptionSkillMax = new FloatSetting();
            fSneakPerceptionSkillMin = new FloatSetting();
            fSneakRunningMult = new FloatSetting();
            fSneakSizeBase = new FloatSetting();
            fSneakSkillMult = new FloatSetting();
            fSneakSleepBonus = new FloatSetting();
            fSneakSleepMod = new FloatSetting();
            fSneakSoundLosMult = new FloatSetting();
            fSneakSoundsMult = new FloatSetting();
            fSneakStealthBoyMult = new FloatSetting();
            fSortActorDistanceListTimer = new FloatSetting();
            fSpeechCraftBase = new FloatSetting();
            fSpeechCraftMult = new FloatSetting();
            fSpeechDelay = new FloatSetting();
            fSpeechcraftFavorMax = new FloatSetting();
            fSpeechcraftFavorMin = new FloatSetting();
            fSpellCastingDetectionHitActorMod = new FloatSetting();
            fSpellCastingDetectionMod = new FloatSetting();
            fSpellmakingGoldMult = new FloatSetting();
            fSplashScale = new FloatSetting();
            fSplashSoundHeavy = new FloatSetting();
            fSplashSoundLight = new FloatSetting();
            fSplashSoundMedium = new FloatSetting();
            fSplashSoundOutMult = new FloatSetting();
            fSplashSoundTimer = new FloatSetting();
            fSplashSoundVelocityMult = new FloatSetting();
            fSprintEncumbranceMult = new FloatSetting();
            fSprintStaminaDrainMult = new FloatSetting();
            fSprintStaminaWeightBase = new FloatSetting();
            fSprintStaminaWeightMult = new FloatSetting();
            fStagger = new FloatSetting();
            fStaggerAttackBase = new FloatSetting();
            fStaggerAttackMult = new FloatSetting();
            fStaggerBlockAttackBase = new FloatSetting();
            fStaggerBlockAttackMult = new FloatSetting();
            fStaggerBlockAttackShieldBase = new FloatSetting();
            fStaggerBlockAttackShieldMult = new FloatSetting();
            fStaggerBlockBase = new FloatSetting();
            fStaggerBlockMult = new FloatSetting();
            fStaggerBlockingMult = new FloatSetting();
            fStaggerMassBase = new FloatSetting();
            fStaggerMassMult = new FloatSetting();
            fStaggerMassOffsetBase = new FloatSetting();
            fStaggerMassOffsetMult = new FloatSetting();
            fStaggerMaxDuration = new FloatSetting();
            fStaggerMin = new FloatSetting();
            fStaggerPlayerMassMult = new FloatSetting();
            fStaggerRecoilingMult = new FloatSetting();
            fStaggerRunningMult = new FloatSetting();
            fStaggerShieldMult = new FloatSetting();
            fStaminaAttackWeaponBase = new FloatSetting();
            fStaminaAttackWeaponMult = new FloatSetting();
            fStaminaBashBase = new FloatSetting();
            fStaminaBlockBase = new FloatSetting();
            fStaminaBlockDmgMult = new FloatSetting();
            fStaminaBlockStaggerMult = new FloatSetting();
            fStaminaPowerBashBase = new FloatSetting();
            fStaminaRegenDelayMax = new FloatSetting();
            fStarsRotateDays = new FloatSetting();
            fStarsRotateXAxis = new FloatSetting();
            fStarsRotateYAxis = new FloatSetting();
            fStatsCameraFOV = new FloatSetting();
            fStatsCameraNearDistance = new FloatSetting();
            fStatsHealthLevelMult = new FloatSetting();
            fStatsHealthStartMult = new FloatSetting();
            fStatsLineScale = new FloatSetting();
            fStatsRotationRampTime = new FloatSetting();
            fStatsRotationSpeedMax = new FloatSetting();
            fStatsSkillsLookAtX = new FloatSetting();
            fStatsSkillsLookAtY = new FloatSetting();
            fStatsSkillsLookAtZ = new FloatSetting();
            fStatsStarCameraOffsetX = new FloatSetting();
            fStatsStarCameraOffsetY = new FloatSetting();
            fStatsStarCameraOffsetZ = new FloatSetting();
            fStatsStarLookAtX = new FloatSetting();
            fStatsStarLookAtY = new FloatSetting();
            fStatsStarLookAtZ = new FloatSetting();
            fStatsStarScale = new FloatSetting();
            fStatsStarXIncrement = new FloatSetting();
            fStatsStarYIncrement = new FloatSetting();
            fStatsStarZIncrement = new FloatSetting();
            fStatsStarZInitialOffset = new FloatSetting();
            fSubSegmentVariance = new FloatSetting();
            fSubmergedAngularDamping = new FloatSetting();
            fSubmergedLODDistance = new FloatSetting();
            fSubmergedLinearDampingH = new FloatSetting();
            fSubmergedLinearDampingV = new FloatSetting();
            fSubmergedMaxSpeed = new FloatSetting();
            fSubmergedMaxWaterDistance = new FloatSetting();
            fSubtitleSpeechDelay = new FloatSetting();
            fSummonDistanceCheckThreshold = new FloatSetting();
            fSummonedCreatureFadeOutSeconds = new FloatSetting();
            fSummonedCreatureMaxFollowDist = new FloatSetting();
            fSummonedCreatureMinFollowDist = new FloatSetting();
            fSummonedCreatureSearchRadius = new FloatSetting();
            fSunAlphaTransTime = new FloatSetting();
            fSunDirXExtreme = new FloatSetting();
            fSunMinimumGlareScale = new FloatSetting();
            fSunReduceGlareSpeed = new FloatSetting();
            fSunXExtreme = new FloatSetting();
            fSunYExtreme = new FloatSetting();
            fSunZExtreme = new FloatSetting();
            fSweetSpotAverage = new FloatSetting();
            fSweetSpotEasy = new FloatSetting();
            fSweetSpotHard = new FloatSetting();
            fSweetSpotVeryEasy = new FloatSetting();
            fSweetSpotVeryHard = new FloatSetting();
            fTakeBackTimerSetting = new FloatSetting();
            fTargetMovedCoveredMoveRepathLength = new FloatSetting();
            fTargetMovedRepathLength = new FloatSetting();
            fTargetMovedRepathLengthLow = new FloatSetting();
            fTeammateAggroOnDistancefromPlayer = new FloatSetting();
            fTeleportDoorActivateDelayTimer = new FloatSetting();
            fTemperingSkillUseMult = new FloatSetting();
            fTimerForPlayerFurnitureEnter = new FloatSetting();
            fTorchEvaluationTimer = new FloatSetting();
            fTorchLightLevelInterior = new FloatSetting();
            fTorchLightLevelMorning = new FloatSetting();
            fTorchLightLevelNight = new FloatSetting();
            fTrackDeadZoneXY = new FloatSetting();
            fTrackDeadZoneZ = new FloatSetting();
            fTrackEyeXY = new FloatSetting();
            fTrackEyeZ = new FloatSetting();
            fTrackFudgeXY = new FloatSetting();
            fTrackFudgeZ = new FloatSetting();
            fTrackJustAcquiredDuration = new FloatSetting();
            fTrackMaxZ = new FloatSetting();
            fTrackMinZ = new FloatSetting();
            fTrackSpeed = new FloatSetting();
            fTrackXY = new FloatSetting();
            fTrainingBaseCost = new FloatSetting();
            fTrainingMultCost = new FloatSetting();
            fTriggerAvoidPlayerDistance = new FloatSetting();
            fUIAltLogoModel = new FloatSetting();
            fUILogoModel = new FloatSetting();
            fUIMistMenu = new FloatSetting();
            fUIMistModel = new FloatSetting();
            fUIPlayerSceneLight = new FloatSetting();
            fUIRaceSexLight = new FloatSetting();
            fUnarmedCreatureDPSMult = new FloatSetting();
            fUnarmedDamageMult = new FloatSetting();
            fUnarmedNPCDPSMult = new FloatSetting();
            fUnderwaterFullDepth = new FloatSetting();
            fVATSAutomaticMeleeDamageMult = new FloatSetting();
            fVATSCamTransRBDownStart = new FloatSetting();
            fVATSCamTransRBRampDown = new FloatSetting();
            fVATSCamTransRBRampup = new FloatSetting();
            fVATSCamTransRBStart = new FloatSetting();
            fVATSCamTransRBStrengthCap = new FloatSetting();
            fVATSCamZoomInTime = new FloatSetting();
            fVATSCameraMaxTime = new FloatSetting();
            fVATSCameraMinTime = new FloatSetting();
            fVATSCriticalChanceBonus = new FloatSetting();
            fVATSDOFRange = new FloatSetting();
            fVATSDOFStrengthCap = new FloatSetting();
            fVATSDOFSwitchSeconds = new FloatSetting();
            fVATSDamageToWeaponMult = new FloatSetting();
            fVATSDestructibleMult = new FloatSetting();
            fVATSDistanceFactor = new FloatSetting();
            fVATSGrenadeChanceMult = new FloatSetting();
            fVATSGrenadeDistAimZMult = new FloatSetting();
            fVATSGrenadeRangeMin = new FloatSetting();
            fVATSGrenadeRangeMult = new FloatSetting();
            fVATSGrenadeSkillFactor = new FloatSetting();
            fVATSGrenadeSuccessExplodeTimer = new FloatSetting();
            fVATSGrenadeSuccessMaxDistance = new FloatSetting();
            fVATSGrenadeTargetArea = new FloatSetting();
            fVATSGrenadeTargetMelee = new FloatSetting();
            fVATSH = new FloatSetting();
            fVATSHitChanceMult = new FloatSetting();
            fVATSImageSpaceTransitionTime = new FloatSetting();
            fVATSLimbSelectCamPanTime = new FloatSetting();
            fVATSMaxChance = new FloatSetting();
            fVATSMaxEngageDistance = new FloatSetting();
            fVATSMeleeArmConditionBase = new FloatSetting();
            fVATSMeleeArmConditionMult = new FloatSetting();
            fVATSMeleeChanceMult = new FloatSetting();
            fVATSMeleeMaxDistance = new FloatSetting();
            fVATSMeleeReachMult = new FloatSetting();
            fVATSMeleeWarpDistanceMult = new FloatSetting();
            fVATSMoveCameraLimbMult = new FloatSetting();
            fVATSMoveCameraLimbPercent = new FloatSetting();
            fVATSMoveCameraMaxSpeed = new FloatSetting();
            fVATSMoveCameraXPercent = new FloatSetting();
            fVATSMoveCameraYPercent = new FloatSetting();
            fVATSParalyzePalmChance = new FloatSetting();
            fVATSPlaybackDelay = new FloatSetting();
            fVATSPlayerDamageMult = new FloatSetting();
            fVATSPlayerMagicTimeSlowdownMult = new FloatSetting();
            fVATSPlayerTimeUpdateMult = new FloatSetting();
            fVATSRadialRampup = new FloatSetting();
            fVATSRadialStart = new FloatSetting();
            fVATSRadialStrength = new FloatSetting();
            fVATSRangeSpreadMax = new FloatSetting();
            fVATSRangeSpreadUncertainty = new FloatSetting();
            fVATSScreenPercentFactor = new FloatSetting();
            fVATSShotBurstTime = new FloatSetting();
            fVATSShotLongBurstTime = new FloatSetting();
            fVATSSkillFactor = new FloatSetting();
            fVATSSmartCameraCheckHeight = new FloatSetting();
            fVATSSmartCameraCheckStepCount = new FloatSetting();
            fVATSSmartCameraCheckStepDistance = new FloatSetting();
            fVATSSpreadMult = new FloatSetting();
            fVATSStealthMult = new FloatSetting();
            fVATSStrangerDistance = new FloatSetting();
            fVATSStrangerOdds = new FloatSetting();
            fVATSTargetActorHeightPanMult = new FloatSetting();
            fVATSTargetActorZMultFar = new FloatSetting();
            fVATSTargetActorZMultFarDist = new FloatSetting();
            fVATSTargetActorZMultNear = new FloatSetting();
            fVATSTargetFOVMinDist = new FloatSetting();
            fVATSTargetFOVMinFOV = new FloatSetting();
            fVATSTargetFOVMultFar = new FloatSetting();
            fVATSTargetFOVMultFarDist = new FloatSetting();
            fVATSTargetFOVMultNear = new FloatSetting();
            fVATSTargetRotateMult = new FloatSetting();
            fVATSTargetScanRotateMult = new FloatSetting();
            fVATSTargetSelectCamPanTime = new FloatSetting();
            fVATSTargetTimeUpdateMult = new FloatSetting();
            fVATSThrownWeaponRangeMult = new FloatSetting();
            fValueofItemForNoOwnership = new FloatSetting();
            fVatsShotgunSpreadRatio = new FloatSetting();
            fVoiceRateBase = new FloatSetting();
            fWardAngleForExplosions = new FloatSetting();
            fWarningTimer = new FloatSetting();
            fWaterKnockdownSizeLarge = new FloatSetting();
            fWaterKnockdownSizeNormal = new FloatSetting();
            fWaterKnockdownSizeSmall = new FloatSetting();
            fWaterKnockdownSizeVeryLarge = new FloatSetting();
            fWaterKnockdownVelocity = new FloatSetting();
            fWeaponBashMax = new FloatSetting();
            fWeaponBashMin = new FloatSetting();
            fWeaponBashPCMax = new FloatSetting();
            fWeaponBashPCMin = new FloatSetting();
            fWeaponBashSkillUseBase = new FloatSetting();
            fWeaponBashSkillUseMult = new FloatSetting();
        }

        private static void  enum constant initialization$3() {
            fWeaponBlockSkillUseBase = new FloatSetting();
            fWeaponBlockSkillUseMult = new FloatSetting();
            fWeaponClutterKnockBipedScale = new FloatSetting();
            fWeaponClutterKnockMaxWeaponMass = new FloatSetting();
            fWeaponClutterKnockMinClutterMass = new FloatSetting();
            fWeaponClutterKnockMult = new FloatSetting();
            fWeaponConditionCriticalChanceMult = new FloatSetting();
            fWeaponConditionJam = new FloatSetting();
            fWeaponConditionRateOfFire = new FloatSetting();
            fWeaponConditionReloadJam = new FloatSetting();
            fWeaponConditionSpread = new FloatSetting();
            fWeaponTwoHandedAnimationSpeedMult = new FloatSetting();
            fWeatherFlashAmbient = new FloatSetting();
            fWeatherFlashDirectional = new FloatSetting();
            fWeatherFlashDuration = new FloatSetting();
            fWeatherTransAccel = new FloatSetting();
            fWeatherTransMax = new FloatSetting();
            fWeatherTransMin = new FloatSetting();
            fWortFailSkillUseMagnitude = new FloatSetting();
            fWortStrMult = new FloatSetting();
            fWortalchmult = new FloatSetting();
            fWortcraftChanceIntDenom = new FloatSetting();
            fWortcraftChanceLuckDenom = new FloatSetting();
            fWortcraftStrChanceDenom = new FloatSetting();
            fWortcraftStrCostDenom = new FloatSetting();
            fXPLevelUpBase = new FloatSetting();
            fXPLevelUpMult = new FloatSetting();
            fXPPerSkillRank = new FloatSetting();
            fZKeyComplexHelperMinDistance = new FloatSetting();
            fZKeyComplexHelperScale = new FloatSetting();
            fZKeyComplexHelperWeightMax = new FloatSetting();
            fZKeyComplexHelperWeightMin = new FloatSetting();
            fZKeyHeavyWeight = new FloatSetting();
            fZKeyMaxContactDistance = new FloatSetting();
            fZKeyMaxContactMassRatio = new FloatSetting();
            fZKeyMaxForce = new FloatSetting();
            fZKeyMaxForceScaleHigh = new FloatSetting();
            fZKeyMaxForceScaleLow = new FloatSetting();
            fZKeyMaxForceWeightHigh = new FloatSetting();
            fZKeyMaxForceWeightLow = new FloatSetting();
            fZKeyObjectDamping = new FloatSetting();
            fZKeySpringDamping = new FloatSetting();
            fZKeySpringElasticity = new FloatSetting();
            fmodifiedTargetAttackRange = new FloatSetting();
        }
    }

    public static enum GMSTType {
        Bool,
        Int,
        Float,
        String,
        Unknown;

    }

    public static enum IntSetting {
        iAICombatMaxAllySummonCount,
        iAICombatMinDetection,
        iAICombatRestoreHealthPercentage,
        iAICombatRestoreMagickaPercentage,
        iAIFleeMaxHitCount,
        iAIMaxSocialDistanceToTriggerEvent,
        iAINPCRacePowerChance,
        iAINumberActorsComplexScene,
        iAINumberDaysToStayBribed,
        iAINumberDaysToStayIntimidated,
        iAISocialDistanceToTriggerEvent,
        iActivatePickLength,
        iActorKeepTurnDegree,
        iActorLuckSkillBase,
        iActorTorsoMaxRotation,
        iAimingNumIterations,
        iAlertAgressionMin,
        iAllowAlchemyDuringCombat,
        iAllowRechargeDuringCombat,
        iAllowRepairDuringCombat,
        iAllyHitCombatAllowed,
        iAllyHitNonCombatAllowed,
        iArmorBaseSkill,
        iArmorDamageBootsChance,
        iArmorDamageCuirassChance,
        iArmorDamageGauntletsChance,
        iArmorDamageGreavesChance,
        iArmorDamageHelmChance,
        iArmorDamageShieldChance,
        iArrestOnSightNonViolent,
        iArrestOnSightViolent,
        iArrowInventoryChance,
        iArrowMaxCount,
        iAttackOnSightNonViolent,
        iAttackOnSightViolent,
        iAttractModeIdleTime,
        iAvoidHurtingNonTargetsResponsibility,
        iBallisticProjectilePathPickSegments,
        iBloodSplatterMaxCount,
        iBoneLODDistMult,
        iClassAcrobat,
        iClassAgent,
        iClassArcher,
        iClassAssassin,
        iClassBarbarian,
        iClassBard,
        iClassBattlemage,
        iClassCharactergenClass,
        iClassCrusader,
        iClassHealer,
        iClassKnight,
        iClassMage,
        iClassMonk,
        iClassNightblade,
        iClassPilgrim,
        iClassPriest,
        iClassRogue,
        iClassScout,
        iClassSorcerer,
        iClassSpellsword,
        iClassThief,
        iClassWarrior,
        iClassWitchhunter,
        iCombatAimMaxIterations,
        iCombatCastDrainMinimumValue,
        iCombatCrippledTorsoHitStaggerChance,
        iCombatDismemberPartChance,
        iCombatExplodePartChance,
        iCombatFlankingAngleOffsetCount,
        iCombatFlankingAngleOffsetGoalCount,
        iCombatFlankingDirectionOffsetCount,
        iCombatHighPriorityModifier,
        iCombatHoverLocationCount,
        iCombatSearchDoorFailureMax,
        iCombatStealthPointDetectionThreshold,
        iCombatStealthPointSneakDetectionThreshold,
        iCombatTargetLocationCount,
        iCombatTargetPlayerSoftCap,
        iCombatUnloadedActorLastSeenTimeLimit,
        iCommonSoulActorLevel,
        iCrimeAlarmLowRecDistance,
        iCrimeAlarmRecDistance,
        iCrimeCommentNumber,
        iCrimeDaysInPrisonMod,
        iCrimeEnemyCoolDownTimer,
        iCrimeFavorBaseValue,
        iCrimeGoldAttack,
        iCrimeGoldEscape,
        iCrimeGoldMinValue,
        iCrimeGoldMurder,
        iCrimeGoldPickpocket,
        iCrimeGoldStealHorse,
        iCrimeGoldTrespass,
        iCrimeGoldWerewolf,
        iCrimeMaxNumberofDaysinJail,
        iCrimeRegardBaseValue,
        iCrimeValueAttackValue,
        iCurrentTargetBonus,
        iDeathDropWeaponChance,
        iDebrisMaxCount,
        iDetectEventLightLevelExterior,
        iDetectEventLightLevelInterior,
        iDetectionHighNumPicks,
        iDialogueDispositionFriendValue,
        iDismemberBloodDecalCount,
        iDispKaramMax,
        iDistancetoAttackedTarget,
        iFallLegDamageChance,
        iFavorAllyValue,
        iFavorConfidantValue,
        iFavorFriendValue,
        iFavorLoverValue,
        iFavorPointsRestore,
        iFriendHitCombatAllowed,
        iFriendHitNonCombatAllowed,
        iGameplayiSpeakingEmotionDeltaChange,
        iGameplayiSpeakingEmotionListenValue,
        iGrandSoulActorLevel,
        iGreaterSoulActorLevel,
        iGuardWarnings,
        iHairColor,
        iHorseTurnDegreesPerSecond,
        iHorseTurnDegreesRampUpPerSecond,
        iInventoryAskQuantityAt,
        iIsInSneak,
        iKarmaMax,
        iKarmaMin,
        iKillCamLevelOffset,
        iLargeProjectilePickCount,
        iLastHDRSetting,
        iLesserSoulActorLevel,
        iLevelUpReminder,
        iLightLevelExteriorMod,
        iLightLevelInteriorMod,
        iLightLevelMax,
        iLocation,
        iLowLevelNPCMaxLevel,
        iMagicGuideWaypoints,
        iMagicLightMaxCount,
        iMapMarkerFadeStartDistance,
        iMapMarkerRevealDistance,
        iMapMarkerVisibleDistance,
        iMasserSize,
        iMaxCharacterLevel,
        iMaxPlayerRunes,
        iMaxQuestObjectives,
        iMaxSummonedCreatures,
        iMessCrippledLimbExplodeBonus,
        iMessIntactLimbDismemberChance,
        iMessIntactLimbExplodeBonus,
        iMessTargetedLimbExplodeBonus,
        iMessTorsoExplodeChance,
        iMinClipSizeToAddReloadDelay,
        iMineDisarmExperience,
        iMoodFaceValue,
        iNPCBasePerLevelHealthMult,
        iNumExplosionDecalCDPoint,
        iNumberActorsAllowedToFollowPlayer,
        iNumberActorsGoThroughLoadDoorInCombat,
        iNumberActorsInCombatPlayer,
        iNumberGuardsCrimeResponse,
        iPCStartSpellSkillLevel,
        iPerkAttackDisarmChance,
        iPerkBlockDisarmChance,
        iPerkBlockStaggerChance,
        iPerkHandToHandBlockRecoilChance,
        iPerkHeavyArmorJumpSum,
        iPerkHeavyArmorSinkSum,
        iPerkLightArmorMasterMinSum,
        iPerkMarksmanKnockdownChance,
        iPerkMarksmanParalyzeChance,
        iPersuasionAngleMax,
        iPersuasionAngleMin,
        iPersuasionBribeCrime,
        iPersuasionBribeGold,
        iPersuasionBribeRefuse,
        iPersuasionBribeScale,
        iPersuasionDemandDisposition,
        iPersuasionDemandGold,
        iPersuasionDemandRefuse,
        iPersuasionDemandScale,
        iPersuasionInner,
        iPersuasionMiddle,
        iPersuasionOuter,
        iPersuasionPower,
        iPickPocketWarnings,
        iPlayerCustomClass,
        iPlayerHealthHeartbeatFadeMS,
        iProjectileMaxRefCount,
        iProjectileMineShooterCanTrigger,
        iQuestReminderPipboyDisabledTime,
        iRelationshipAcquaintanceValue,
        iRelationshipAllyValue,
        iRelationshipArchnemesisValue,
        iRelationshipConfidantValue,
        iRelationshipEnemyValue,
        iRelationshipFoeValue,
        iRelationshipFriendValue,
        iRelationshipLoverValue,
        iRelationshipRivalValue,
        iRemoveExcessDeadComplexCount,
        iRemoveExcessDeadComplexTotalActorCount,
        iRemoveExcessDeadCount,
        iRemoveExcessDeadTotalActorCount,
        iSecondsToSleepPerUpdate,
        iSecundaSize,
        iShockBranchNumBolts,
        iShockBranchSegmentsPerBolt,
        iShockDebug,
        iShockNumBolts,
        iShockSegmentsPerBolt,
        iShockSubSegments,
        iSize,
        iSkillPointsTagSkillMult,
        iSkillUsageSneakFullDetection,
        iSkillUsageSneakMinDetection,
        iSneakSkillUseDistance,
        iSoundLevelLoud,
        iSoundLevelNormal,
        iSoundLevelSilent,
        iSoundLevelVeryLoud,
        iStaggerAttackChance,
        iStealWarnings,
        iTrainingExpertCost,
        iTrainingExpertSkill,
        iTrainingJourneymanCost,
        iTrainingJourneymanSkill,
        iTrainingMasterCost,
        iTrainingMasterSkill,
        iTrainingNumAllowedPerLevel,
        iTrespassWarnings,
        iVATSCameraHitDist,
        iVATSConcentratedFireBonus,
        iVATSStrangerMaxHP,
        iVoicePointsDefault,
        iWeaponCriticalHitDropChance,
        iXPBase,
        iXPBumpBase,
        iXPDeathRewardHealthThreshold,
        iXPLevelHackComputerAverage,
        iXPLevelHackComputerEasy,
        iXPLevelHackComputerHard,
        iXPLevelHackComputerVeryEasy,
        iXPLevelHackComputerVeryHard,
        iXPLevelKillCreatureAverage,
        iXPLevelKillCreatureEasy,
        iXPLevelKillCreatureHard,
        iXPLevelKillCreatureVeryEasy,
        iXPLevelKillCreatureVeryHard,
        iXPLevelKillNPCAverage,
        iXPLevelKillNPCEasy,
        iXPLevelKillNPCHard,
        iXPLevelKillNPCVeryEasy,
        iXPLevelKillNPCVeryHard,
        iXPLevelPickLockAverage,
        iXPLevelPickLockEasy,
        iXPLevelPickLockHard,
        iXPLevelPickLockVeryEasy,
        iXPLevelPickLockVeryHard,
        iXPLevelSpeechChallengeAverage,
        iXPLevelSpeechChallengeEasy,
        iXPLevelSpeechChallengeHard,
        iXPLevelSpeechChallengeVeryEasy,
        iXPLevelSpeechChallengeVeryHard,
        iXPRewardDiscoverMapMarker,
        iXPRewardDiscoverSecretArea,
        iXPRewardHackComputer,
        iXPRewardHackComputerAverage,
        iXPRewardHackComputerEasy,
        iXPRewardHackComputerHard,
        iXPRewardHackComputerVeryEasy,
        iXPRewardHackComputerVeryHard,
        iXPRewardKillNPCAverage,
        iXPRewardKillNPCEasy,
        iXPRewardKillNPCHard,
        iXPRewardKillNPCVeryEasy,
        iXPRewardKillNPCVeryHard,
        iXPRewardKillOpponent,
        iXPRewardKillOpponentAverage,
        iXPRewardKillOpponentEasy,
        iXPRewardKillOpponentHard,
        iXPRewardKillOpponentVeryEasy,
        iXPRewardKillOpponentVeryHard,
        iXPRewardPickLock,
        iXPRewardPickLockAverage,
        iXPRewardPickLockEasy,
        iXPRewardPickLockHard,
        iXPRewardPickLockVeryEasy,
        iXPRewardPickLockVeryHard,
        iXPRewardSpeechChallengeAverage,
        iXPRewardSpeechChallengeEasy,
        iXPRewardSpeechChallengeHard,
        iXPRewardSpeechChallengeVeryEasy,
        iXPRewardSpeechChallengeVeryHard,
        iHoursToRespawnCell,
        iHoursToRespawnCellCleared,
        iDaysToRespawnVendor,
        iHoursToClearCorpses,
        iMaxAttachedArrows;

    }

    public static enum StringSetting {
        sAbortText,
        sAccept,
        sActionMapping,
        sActionPointsAttack,
        sActionPointsCrouch,
        sActionPointsHeal,
        sActionPointsPunch,
        sActionPointsReload,
        sActionPointsStand,
        sActionPointsSwitchWeapon,
        sActionPointsToggleWeaponDrawn,
        sActivate,
        sActivateCreatureCalmed,
        sActivateNPCCalmed,
        sActivationChoiceMessage,
        sActiveEffects,
        sActiveMineDescription,
        sActorFade,
        sAdd,
        sAddCrimeGold,
        sAddItemtoInventory,
        sAddItemtoSpellList,
        sAddedEffects,
        sAddedNote,
        sAlchemy,
        sAlchemyMenuDescription,
        sAllItems,
        sAllegiance,
        sAlreadyKnown,
        sAlreadyPlacedMine,
        sAlteration,
        sAmber,
        sAnimationCanNotEquipArmor,
        sAnimationCanNotEquipWeapon,
        sAnimationCanNotUnequip,
        sApparel,
        sAreaText,
        sArmor,
        sArmorEnchantments,
        sArmorRating,
        sArmorSmithing,
        sAttack,
        sAttributeDamaged,
        sAttributeDrained,
        sAttributesCount,
        sAttributesTitle,
        sAutoLoading,
        sAutoSaveDisabledDueToLackOfSpace,
        sAutoSaving,
        sAutoSavingLong,
        sAutosaveAbbrev,
        sBack,
        sBasePath,
        sBleedingOutMessage,
        sBloodParticleDefault,
        sBloodParticleMeleeDefault,
        sBloodSplatterAlpha,
        sBloodSplatterColor,
        sBloodSplatterFlare,
        sBloodTextureDefault,
        sBooks,
        sBounty,
        sBountyStatString,
        sBrightness,
        sBroken,
        sButton,
        sButtonLocked,
        sCameraPitch,
        sCanNotEquipWornEnchantment,
        sCanNotReadBook,
        sCanNotTrainAnymore,
        sCanNotTrainHigher,
        sCancel,
        sCannotCastShout,
        sCantChangeResolution,
        sCantEquipBrokenItem,
        sCantEquipGeneric,
        sCantEquipPowerArmor,
        sCantHotkeyItem,
        sCantQuickLoad,
        sCantQuickSave,
        sCantRemoveWornItem,
        sCantRepairPastMax,
        sCantSaveNow,
        sCantUnequipGeneric,
        sChangeItemSelection,
        sCharGenControlsDisabled,
        sChemsAddicted,
        sChemsWithdrawal,
        sChemsWornOff,
        sChoose,
        sChooseSoulGem,
        sClearSelections,
        sCleared,
        sClose,
        sCombatCannotActivate,
        sConfirmAttribute,
        sConfirmContinue,
        sConfirmDelete,
        sConfirmDisenchant,
        sConfirmLoad,
        sConfirmNew,
        sConfirmSave,
        sConfirmSpendSoul,
        sConfirmWarning,
        sConjuration,
        sConstructibleMenuConfirm,
        sConstructibleMenuDescription,
        sContainerItemsTitle,
        sContainerPlaceChance,
        sContainerStealChance,
        sContinue,
        sContinueText,
        sContractedDisease,
        sControllerOption,
        sCopyProtectionMessage,
        sCopyProtectionTitle,
        sCorruptContentMessage,
        sCraft,
        sCreate,
        sCreated,
        sCreatedPoisonNamePrefix,
        sCreatedPotionNamePrefix,
        sCriticalStrike,
        sCrosshair,
        sCurrentLocation,
        sCurrentObjective,
        sCursorFilename,
        sDaedric,
        sDamage,
        sDefaultMessage,
        sDefaultPlayerName,
        sDeleteSaveGame,
        sDeleteSuccessful,
        sDestruction,
        sDevice,
        sDeviceRemoved,
        sDialogSubtitles,
        sDifficulty,
        sDisableHelp,
        sDisableXBoxController,
        sDiscoveredEffects,
        sDiscoveredIngredientEffectEating,
        sDiscoveredText,
        sDisenchant,
        sDismemberParticleDefault,
        sDismemberRobotParticleDefault,
        sDone,
        sDownloadsAvailable,
        sDownloadsNotAvail,
        sDragon,
        sDragonSoulAcquired,
        sDraugr,
        sDropEquippedItemWarning,
        sDropQuestItemWarning,
        sDungeonCleared,
        sDurationText,
        sDwarven,
        sEbony,
        sEffectAlreadyAdded,
        sEffectsListDisplayHour,
        sEffectsListDisplayHours,
        sEffectsListDisplayMin,
        sEffectsListDisplayMins,
        sEffectsListDisplaySec,
        sEffectsListDisplaySecs,
        sEffectsVolume,
        sElven,
        sEmpty,
        sEnableHelp,
        sEnchantArmorIncompatible,
        sEnchantDeconstructMenuDescription,
        sEnchantInsufficientCharge,
        sEnchantItem,
        sEnchantMenuDescription,
        sEnchantMustChooseItems,
        sEnchanting,
        sEnchantment,
        sEnchantmentKnown,
        sEnchantmentsLearned,
        sEnterItemName,
        sEnterName,
        sEquipItemOnPlayer,
        sEssentialCharacterDown,
        sExit,
        sExitGameAffirm,
        sExplosionSplashParticles,
        sFailShouting,
        sFailSpendSoul,
        sFailedActivation,
        sFalmer,
        sFastTravelConfirm,
        sFastTravelNoTravelHealthDamage,
        sFavorites,
        sFileNotFound,
        sFindingContentMessage,
        sFirstPersonSkeleton,
        sFood,
        sFootstepsVolume,
        sFor,
        sFullHealth,
        sFurnitureSleep,
        sGFWLive,
        sGeneralSubtitles,
        sGlass,
        sGold,
        sGotAwayWithStealing,
        sGrassFade,
        sHUDArmorRating,
        sHUDColor,
        sHUDCompleted,
        sHUDDamage,
        sHUDFailed,
        sHUDOpacity,
        sHUDStarted,
        sHairColor,
        sHarvest,
        sHealth,
        sHeavyArmorNoJump,
        sHeavyArmorSink,
        sHelp,
        sHide,
        sHigh,
        sHold,
        sIgnoreText,
        sIllusion,
        sImpactParticleConcreteDefault,
        sImpactParticleMetalDefault,
        sImpactParticleWoodDefault,
        sImperial,
        sImpossibleLock,
        sImprovement,
        sInaccessible,
        sIngredient,
        sIngredientFail,
        sIngredients,
        sInsufficientGoldToTrain,
        sInvalidPickpocket,
        sIron,
        sItem,
        sItemFade,
        sItemTooExpensive,
        sItemTooHeavy,
        sJewelry,
        sJunk,
        sKeyLocked,
        sKeys,
        sKnownEffects,
        sLackRequiredPerkToImproveMagical,
        sLackRequiredPerksToImprove,
        sLackRequiredSkillToImprove,
        sLackRequiredToCreate,
        sLackRequiredToImprove,
        sLarge,
        sLearn,
        sLearningEnchantments,
        sLeather,
        sLeaveMarker,
        sLevelAbbrev,
        sLevelProgress,
        sLevelUpAvailable,
        sLightFade,
        sLoadFromMainMenu,
        sLoadWhilePlaying,
        sLoading,
        sLoadingArea,
        sLoadingContentMessage,
        sLoadingLOD,
        sLockBroken,
        sLocked,
        sLockpickInsufficientPerks,
        sLostController,
        sLow,
        sMagicEffectNotApplied,
        sMagicEffectResisted,
        sMagicEnhanceWeaponNoWeapon,
        sMagicEnhanceWeaponWeaponEnchanted,
        sMagicGuideNoMarker,
        sMagicGuideNoPath,
        sMagicTelekinesisNoRecast,
        sMagnitudeIsLevelText,
        sMagnitudeText,
        sMainMenu,
        sMakeDefaults,
        sMapMarkerAdded,
        sMasterVolume,
        sMedium,
        sMenuDisplayAutosaveName,
        sMenuDisplayDayString,
        sMenuDisplayLevelString,
        sMenuDisplayNewSave,
        sMenuDisplayNoSaves,
        sMenuDisplayPlayTime,
        sMenuDisplayQuicksaveName,
        sMenuDisplaySave,
        sMenuDisplayShortXBoxSaveMessage,
        sMenuDisplayUnknownLocationString,
        sMenuDisplayXBoxSaveMessage,
        sMisc,
        sMiscConstantEffect,
        sMiscPlayerDeadLoadOption,
        sMiscPlayerDeadMenuOption,
        sMiscPlayerDeadMessage,
        sMiscQuestDescription,
        sMiscQuestName,
        sMiscUnknownEffect,
        sMissingImage,
        sMissingName,
        sMouseSensitivity,
        sMoveMarker,
        sMoveMarkerQuestion,
        sMultipleDragonSoulCount,
        sMusicVolume,
        sMustRestart,
        sName,
        sNeutral,
        sNewSave,
        sNext,
        sNo,
        sNoArrows,
        sNoChargeItems,
        sNoChildUse,
        sNoDeviceSelected,
        sNoEatQuestItem,
        sNoFastTravelAlarm,
        sNoFastTravelCell,
        sNoFastTravelCombat,
        sNoFastTravelDefault,
        sNoFastTravelHostileActorsNear,
        sNoFastTravelInAir,
        sNoFastTravelOverencumbered,
        sNoFastTravelScriptBlock,
        sNoFastTravelUndiscovered,
        sNoItemsToRepair,
        sNoJumpWarning,
        sNoKeyDropWarning,
        sNoLockPickIfCrimeAlert,
        sNoMoreFollowers,
        sNoPickPocketAgain,
        sNoProfileSelected,
        sNoRepairHostileActorsNear,
        sNoRepairInCombat,
        sNoRestart,
        sNoSaves,
        sNoSitOnOwnedFurniture,
        sNoSleepDefault,
        sNoSleepHostileActorsNear,
        sNoSleepInAir,
        sNoSleepInCell,
        sNoSleepInOwnedBed,
        sNoSleepTakingHealthDamage,
        sNoSleepTrespass,
        sNoSleepWarnToLeave,
        sNoSleepWhileAlarm,
        sNoSpareParts,
        sNoTalkFleeing,
        sNoTalkUnConscious,
        sNoText,
        sNoWaitDefault,
        sNoWaitHostileActorsNear,
        sNoWaitInAir,
        sNoWaitInCell,
        sNoWaitTakingHealthDamage,
        sNoWaitTrespass,
        sNoWaitWarnToLeave,
        sNoWaitWhileAlarm,
        sNone,
        sNormal,
        sNormalWeaponsResisted,
        sNotAllowedToUseAutoDoorsWhileonHorse,
        sNotEnoughRoomWarning,
        sNotEnoughVendorGold,
        sNumberAbbrev,
        sOKText,
        sObjectFade,
        sObjectInUse,
        sObjectLODFade,
        sOf,
        sOff,
        sOk,
        sOldDownloadsAvailable,
        sOn,
        sOpen,
        sOpenWithKey,
        sOpenedContainer,
        sOptional,
        sOr,
        sOrcish,
        sOutOfLockpicks,
        sOverEncumbered,
        sOwned,
        sPCControlsTextNone,
        sPCControlsTextPrefix,
        sPCControlsTriggerPrefix,
        sPCRelationshipNegativeChangeText,
        sPCRelationshipPositiveChangeText,
        sPauseText,
        sPickpocket,
        sPickpocketFail,
        sPipboyColor,
        sPlaceMarker,
        sPlaceMarkerUndiscovered,
        sPlayTime,
        sPlayerDisarmedMessage,
        sPlayerLeavingBorderRegion,
        sPlayerSetMarkerName,
        sPleaseStandBy,
        sPoisonAlreadyPoisonedMessage,
        sPoisonBowConfirmMessage,
        sPoisonConfirmMessage,
        sPoisonNoWeaponMessage,
        sPoisonUnableToPoison,
        sPoisoned,
        sPotionCreationFailed,
        sPotions,
        sPowers,
        sPressControl,
        sPrevious,
        sPreviousSelection,
        sPrisoner,
        sQuantity,
        sQuestAddedText,
        sQuestCompletedText,
        sQuestFailed,
        sQuestUpdatedText,
        sQuickLoading,
        sQuickSaving,
        sQuicksaveAbbrev,
        sQuitAlchemy,
        sQuitEnchanting,
        sRSMAge,
        sRSMBody,
        sRSMBrow,
        sRSMBrowForward,
        sRSMBrowHeight,
        sRSMBrowTypes,
        sRSMBrowWidth,
        sRSMCheekColor,
        sRSMCheekColorLower,
        sRSMCheekboneHeight,
        sRSMCheekboneWidth,
        sRSMChinColor,
        sRSMChinForward,
        sRSMChinLength,
        sRSMChinWidth,
        sRSMComplexion,
        sRSMComplexionColor,
        sRSMConfirm,
        sRSMConfirmDestruction,
        sRSMDirt,
        sRSMDirtColor,
        sRSMEyeColor,
        sRSMEyeDepth,
        sRSMEyeHeight,
        sRSMEyeSocketLowerColor,
        sRSMEyeSocketUpperColor,
        sRSMEyeTypes,
        sRSMEyeWidth,
        sRSMEyelinerColor,
        sRSMEyes,
        sRSMFace,
        sRSMFacialHairColorPresets,
        sRSMFacialHairPresets,
        sRSMForeheadColor,
        sRSMHair,
        sRSMHairColorPresets,
        sRSMHairPresets,
        sRSMHead,
        sRSMHeadPresets,
        sRSMJawForward,
        sRSMJawHeight,
        sRSMJawWidth,
        sRSMLaughLines,
        sRSMLipColor,
        sRSMMouth,
        sRSMMouthForward,
        sRSMMouthHeight,
        sRSMMouthTypes,
        sRSMName,
        sRSMNameWarning,
        sRSMNeckColor,
        sRSMNoseColor,
        sRSMNoseHeight,
        sRSMNoseLength,
        sRSMNoseTypes,
        sRSMPaint,
        sRSMPaintColor,
        sRSMRace,
        sRSMScars,
        sRSMSex,
        sRSMSkinColor,
        sRSMTone,
        sRSMWeight,
        sRadioSignalLost,
        sRadioStationDiscovered,
        sRadioVolume,
        sRangeText,
        sRanksText,
        sRead,
        sRemoteActivation,
        sRemove,
        sRemoveCrimeGold,
        sRemoveItemfromInventory,
        sRemoveMarker,
        sRenameItem,
        sRepair,
        sRepairAllItems,
        sRepairCost,
        sRepairItem,
        sRepairServicesTitle,
        sRepairSkill,
        sRepairSkillTooLow,
        sRequirements,
        sRequirementsText,
        sResetToDefaults,
        sResolution,
        sResource,
        sRestartBecauseContentRemoved,
        sRestartSignedOut,
        sRestartToUseNewContent,
        sRestartToUseProfileContent,
        sRestoration,
        sRetryText,
        sReturn,
        sRewardXP,
        sRewardXPIcon,
        sRide,
        sRumble,
        sSaveFailed,
        sSaveGameContentIsMissing,
        sSaveGameCorrupt,
        sSaveGameCorruptMenuMessage,
        sSaveGameDeviceError,
        sSaveGameIsCorrupt,
        sSaveGameNoLongerAvailable,
        sSaveGameNoMasterFilesFound,
        sSaveGameOldVersion,
        sSaveGameOutOfDiskSpace,
        sSaveNotAvailable,
        sSaveOnRest,
        sSaveOnTravel,
        sSaveOnWait,
        sSaveOverSaveGame,
        sSaveSuccessful,
        sSceneBlockingActorActivation,
        sScrollEquipped,
        sScrolls,
        sSearch,
        sSelect,
        sSelectItemToRepair,
        sSelfRange,
        sServeSentenceQuestion,
        sServeTimeQuestion,
        sSexFemale,
        sSexFemalePossessive,
        sSexFemalePronoun,
        sSexMale,
        sSexMalePossessive,
        sSexMalePronoun,
        sShadowFade,
        sShoutAdded,
        sShouts,
        sSingleDragonSoulCount,
        sSit,
        sSkillIncreased,
        sSkillIncreasedNum,
        sSkillsCount,
        sSkillsTitle,
        sSmall,
        sSmithingConfirm,
        sSmithingMenuDescription,
        sSneakAttack,
        sSneakCaution,
        sSneakDanger,
        sSneakDetected,
        sSneakHidden,
        sSortMethod,
        sSoulCaptured,
        sSoulGem,
        sSoulGemTooSmall,
        sSoulGems,
        sSoulLevel,
        sSpace,
        sSpecularityFade,
        sSpeechChallengeFailure,
        sSpeechChallengeSuccess,
        sSpellAdded,
        sSplashParticles,
        sStatsMustSelectPerk,
        sStatsNextRank,
        sStatsPerkConfirm,
        sSteal,
        sStealFrom,
        sStealHorse,
        sSteel,
        sStormcloak,
        sStudded,
        sSuccessfulSneakAttackEnd,
        sSuccessfulSneakAttackMain,
        sTake,
        sTakeAll,
        sTalk,
        sTargetRange,
        sTeammateCantGiveOutfit,
        sTeammateCantTakeOutfit,
        sTeammateOverencumbered,
        sTestFile,
        sTextureSize,
        sTo,
        sTouchRange,
        sTraitsCount,
        sTraitsTitle,
        sTreeLODFade,
        sTweenDisabledMessage,
        sUIMistMenu,
        sUnequipItemOnPlayer,
        sUnlock,
        sUse,
        sVATSMessageLowAP,
        sVATSMessageNoAmmo,
        sVATSMessageZeroChance,
        sVDSGManual,
        sVDSGPlate,
        sValue,
        sVatsAimed,
        sVatsAiming,
        sVatsBodyPart,
        sVatsSelect,
        sVatsTarget,
        sVideoChange,
        sViewDistance,
        sVoiceVolume,
        sWaitHere,
        sWeaponBreak,
        sWeaponEnchantments,
        sWeaponSmithing,
        sWeapons,
        sWeight,
        sWhite,
        sWitnessKilled,
        sWood,
        sXSensitivity,
        sYSensitivity,
        sYes,
        sYesRestart,
        sYesText,
        sYesToAllText,
        sYour;

    }
}

