/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.util.ArrayList;
import java.util.zip.DataFormatException;
import lev.LImport;
import lev.Ln;
import skyproc.MajorRecord;
import skyproc.Mod;
import skyproc.ModListing;
import skyproc.Record;
import skyproc.SPGlobal;
import skyproc.SubData;
import skyproc.SubFloat;
import skyproc.SubPrototype;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;

public class GLOB
extends MajorRecord {
    static final SubPrototype GLOBproto = new SubPrototype(MajorRecord.majorProto){

        @Override
        protected void addRecords() {
            SubData fnam = new SubData("FNAM");
            fnam.data = new byte[1];
            this.add(fnam);
            this.add(new SubFloat("FLTV"));
        }
    };

    GLOB() {
        this.subRecords.setPrototype(GLOBproto);
    }

    public GLOB(String edid, GLOBType type) {
        this();
        this.originateFromPatch(edid);
        this.setType(type);
    }

    public GLOB(String edid, GLOBType type, float value, Boolean constant) {
        this(edid, type);
        this.setValue(Float.valueOf(value));
        this.setConstant(constant);
    }

    @Override
    Record getNew() {
        return new GLOB();
    }

    @Override
    ArrayList<String> getTypes() {
        return Record.getTypeList("GLOB");
    }

    public GLOBType getGLOBType() {
        SubData fnam = this.subRecords.getSubData("FNAM");
        if (fnam.data[0] == GLOBType.Short.value) {
            return GLOBType.Short;
        }
        if (fnam.data[0] == GLOBType.Long.value) {
            return GLOBType.Long;
        }
        return GLOBType.Float;
    }

    public final void setType(GLOBType type) {
        this.subRecords.getSubData((String)"FNAM").data[0] = (byte)type.value;
    }

    @Override
    public ModListing getFormMaster() {
        return super.getFormMaster();
    }

    @Override
    void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
        super.parseData(in, srcMod);
        if (SPGlobal.logMods) {
            GLOB.logMod(srcMod, "GLOB", "Constant: " + this.get(MajorRecord.MajorFlags.RelatedToShields));
        }
    }

    public float getValue() {
        return this.subRecords.getSubFloat("FLTV").get();
    }

    public final void setValue(Float value) {
        this.subRecords.setSubFloat("FLTV", value.floatValue());
    }

    public final void setValue(Boolean value) {
        this.setValue(Float.valueOf(Integer.valueOf(Ln.convertBoolTo1((Boolean)value)).intValue()));
    }

    public boolean isConstant() {
        return this.get(MajorRecord.MajorFlags.RelatedToShields);
    }

    public final void setConstant(boolean on) {
        this.set(MajorRecord.MajorFlags.RelatedToShields, on);
    }

    public static enum GLOBType {
        Short(115),
        Long(108),
        Float(102);

        int value;

        private GLOBType(int value) {
            this.value = value;
        }
    }
}

