/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import lev.LImport;
import lev.Ln;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.ModListing;
import skyproc.SPGlobal;

public class FormID
implements Comparable,
Serializable {
    static ArrayList<FormID> allIDs = new ArrayList();
    public static final FormID NULL = new FormID();
    byte[] form = new byte[4];
    ModListing master = null;

    FormID() {
        if (SPGlobal.testing) {
            allIDs.add(this);
        }
    }

    public FormID(String id, String master) {
        this(id, new ModListing(master));
    }

    public FormID(String form) {
        this(form.substring(0, 6), form.substring(6));
    }

    public FormID(String id, ModListing master) {
        this(Ln.parseHexString((String)id, (int)4, (boolean)false), master);
    }

    public FormID(byte[] id, ModListing master) {
        this();
        this.set(id);
        this.master = master;
    }

    public FormID(int[] id, ModListing master) {
        this(Ln.toByteArray((int[])id), master);
    }

    FormID(int id, ModListing master) {
        this();
        this.setInternal(Ln.toByteArray((int)id));
        this.master = master;
    }

    public FormID(FormID in) {
        System.arraycopy(in.form, 0, this.form, 0, in.form.length);
        this.master = in.master;
    }

    final void set(byte[] id) {
        this.setInternal(Ln.reverse((byte[])id));
    }

    void setTo(FormID id) {
        this.form = id.form;
        this.master = id.master;
    }

    private void setInternal(byte[] id) {
        this.form = id;
        if (id.length > 4) {
            this.form = Arrays.copyOfRange(this.form, 0, 3);
        } else if (id.length < 4) {
            this.form = new byte[4];
            System.arraycopy(id, 0, this.form, 0, id.length);
        }
    }

    final void setInternal(byte[] id, Mod srcMod) {
        this.setInternal(id);
        this.standardize(srcMod);
    }

    void export(ModExporter out) throws IOException {
        this.standardize(out.getSourceMod());
        this.adjustMasterIndex(out.getExportMod());
        out.write(this.getInternal(true), 4);
    }

    void parseData(LImport in, Mod srcMod) {
        this.setInternal(in.extract(4), srcMod);
    }

    String getArrayStr(Boolean masterIndex) {
        if (this.isValid()) {
            return Ln.printHex((byte[])this.getInternal(masterIndex), (Boolean)false, (Boolean)true);
        }
        return "No FormID";
    }

    public byte[] get() {
        return Ln.reverse((byte[])this.getInternal(true));
    }

    byte[] getInternal(Boolean masterIndex) {
        if (!masterIndex.booleanValue()) {
            return Arrays.copyOfRange(this.form, 0, 3);
        }
        return this.form;
    }

    public ModListing getMaster() {
        return this.master;
    }

    public String getFormStr() {
        if (this.master == null) {
            return this.getArrayStr(false);
        }
        return String.valueOf(this.getArrayStr(false)) + this.getMaster().print();
    }

    public String getTitle() {
        return this.toString();
    }

    public String toString() {
        if (this.isStandardized().booleanValue()) {
            return this.getFormStr();
        }
        if (this.isValid()) {
            return this.getArrayStr(true);
        }
        return "NULL";
    }

    void standardize(Mod srcMod) {
        if (this.master == null) {
            this.master = srcMod.getNthMaster(this.form[3]);
        }
    }

    void adjustMasterIndex(Mod srcMod) {
        this.form[3] = (byte)srcMod.getMasterIndex(this.master);
    }

    public static String[] parseString(String s) {
        String[] ida = new String[2];
        if (s.length() > 6) {
            ida[0] = s.substring(0, 6);
            String modName = s.substring(6);
            modName = Ln.cleanLine((String)modName, (String)"//");
            ida[1] = modName = Ln.cleanLine((String)modName, (String)";");
        } else {
            ida[0] = "000000";
            ida[1] = String.valueOf(SPGlobal.gameName) + ".esm";
        }
        return ida;
    }

    public static FormID parseString(String[] s) {
        if (s.length == 2 && s[0].length() == 6) {
            return new FormID(s[0], s[1]);
        }
        return new FormID(NULL);
    }

    boolean isValid() {
        return !this.equals(NULL);
    }

    Boolean isStandardized() {
        if (this.master != null) {
            return true;
        }
        return false;
    }

    int getContentLength() {
        return 4;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FormID other = (FormID)obj;
        int i = 0;
        while (i < 3) {
            if (this.form[i] != other.form[i]) {
                return false;
            }
            ++i;
        }
        return !(this.master == null ? other.master != null : !this.master.equals(other.master));
    }

    public boolean isNull() {
        return this.equals(NULL);
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Arrays.hashCode(Arrays.copyOf(this.form, 3));
        hash = 97 * hash + (this.master != null ? this.master.hashCode() : 0);
        return hash;
    }

    public int compareTo(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return 0;
        }
        FormID rhs = (FormID)o;
        if (this.master.equals(rhs.master)) {
            return Ln.arrayToInt((byte[])this.form) - Ln.arrayToInt((byte[])rhs.form);
        }
        return this.master.compareTo(rhs.master);
    }
}

