/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.DataFormatException;
import lev.LFlags;
import lev.LImport;
import skyproc.FormID;
import skyproc.MagicItem;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.Record;
import skyproc.SubPrototype;
import skyproc.SubRecord;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;
import skyproc.genenums.CastType;
import skyproc.genenums.DeliveryType;

public class ENCH
extends MagicItem {
    static final SubPrototype ENCHproto = new SubPrototype(MagicItem.magicItemProto){

        @Override
        protected void addRecords() {
            this.reposition("OBND");
            this.reposition("FULL");
            this.remove("DESC");
            this.add(new ENIT());
            this.reposition("EFID");
            this.reposition("KWDA");
        }
    };

    ENCH() {
        this.subRecords.setPrototype(ENCHproto);
    }

    @Override
    ArrayList<String> getTypes() {
        return Record.getTypeList("ENCH");
    }

    @Override
    Record getNew() {
        return new ENCH();
    }

    ENIT getENIT() {
        return (ENIT)this.subRecords.get("ENIT");
    }

    public void setBaseCost(int cost) {
        this.getENIT().baseCost = cost;
    }

    public int getBaseCost() {
        return this.getENIT().baseCost;
    }

    public void set(ENCHFlag in, boolean on) {
        this.getENIT().flags.set(in.value, on);
    }

    public boolean get(ENCHFlag in) {
        return this.getENIT().flags.get(in.value);
    }

    public void setCastType(CastType type) {
        this.getENIT().castType = type;
    }

    public CastType getCastType() {
        return this.getENIT().castType;
    }

    public void setChargeAmount(int amount) {
        this.getENIT().chargeAmount = amount;
    }

    public int getChargeAmount() {
        return this.getENIT().chargeAmount;
    }

    public void setDeliveryType(DeliveryType type) {
        this.getENIT().targetType = type;
    }

    public DeliveryType getDeliveryType() {
        return this.getENIT().targetType;
    }

    public void setEnchantType(EnchantType type) {
        this.getENIT().enchantType = type;
    }

    public EnchantType getEnchantType() {
        return this.getENIT().enchantType;
    }

    public void setChargeTime(float time) {
        this.getENIT().chargeTime = time;
    }

    public float getChargeTime() {
        return this.getENIT().chargeTime;
    }

    public void setBaseEnchantment(FormID id) {
        this.getENIT().baseEnchantment = id;
    }

    public FormID getBaseEnchantment() {
        return this.getENIT().baseEnchantment;
    }

    public void setWornRestrictions(FormID id) {
        this.getENIT().wornRestrictions = id;
    }

    public FormID getWornRestrictions() {
        return this.getENIT().wornRestrictions;
    }

    public static enum ENCHFlag {
        ManualCalc(0),
        ExtendDurationOnRecast(3);

        int value;

        private ENCHFlag(int in) {
            this.value = in;
        }
    }

    static final class ENIT
    extends SubRecord {
        int baseCost = 0;
        LFlags flags = new LFlags(4);
        CastType castType = CastType.ConstantEffect;
        int chargeAmount = 0;
        DeliveryType targetType = DeliveryType.Self;
        EnchantType enchantType = EnchantType.Enchantment;
        float chargeTime = 0.0f;
        FormID baseEnchantment = new FormID();
        FormID wornRestrictions = new FormID();
        boolean old = false;

        ENIT() {
        }

        @Override
        void export(ModExporter out) throws IOException {
            super.export(out);
            out.write(this.baseCost, 4);
            out.write(this.flags.export());
            out.write(this.castType.ordinal(), 4);
            out.write(this.chargeAmount, 4);
            out.write(this.targetType.ordinal(), 4);
            out.write(this.enchantType.value, 4);
            out.write(this.chargeTime);
            this.baseEnchantment.export(out);
            if (!this.old) {
                this.wornRestrictions.export(out);
            }
        }

        @Override
        void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
            super.parseData(in, srcMod);
            this.baseCost = in.extractInt(4);
            this.flags.set(in.extract(4));
            this.castType = CastType.values()[in.extractInt(4)];
            this.chargeAmount = in.extractInt(4);
            this.targetType = DeliveryType.values()[in.extractInt(4)];
            this.enchantType = EnchantType.value(in.extractInt(4));
            this.chargeTime = in.extractFloat();
            this.baseEnchantment.parseData(in, srcMod);
            if (!in.isDone().booleanValue()) {
                this.wornRestrictions.parseData(in, srcMod);
            } else {
                this.old = true;
            }
        }

        @Override
        SubRecord getNew(String type) {
            return new ENIT();
        }

        @Override
        int getContentLength(ModExporter out) {
            if (this.old) {
                return 32;
            }
            return 36;
        }

        @Override
        ArrayList<FormID> allFormIDs() {
            ArrayList<FormID> out = new ArrayList<FormID>(2);
            out.add(this.baseEnchantment);
            out.add(this.wornRestrictions);
            return out;
        }

        @Override
        ArrayList<String> getTypes() {
            return Record.getTypeList("ENIT");
        }
    }

    public static enum EnchantType {
        Enchantment(6),
        StaffEnchantment(12);

        int value;

        private EnchantType(int value) {
            this.value = value;
        }

        static EnchantType value(int in) {
            switch (in) {
                case 12: {
                    return StaffEnchantment;
                }
            }
            return Enchantment;
        }
    }
}

