/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.JOptionPane;
import lev.LInChannel;
import lev.LMergeMap;
import lev.LOutChannel;
import lev.LShrinkArray;
import skyproc.FormID;
import skyproc.GRUP;
import skyproc.MajorRecord;
import skyproc.Mod;
import skyproc.ModListing;
import skyproc.SPGlobal;

class Consistency {
    static ConsistencyVersion consistency = new ConsistencyV3();
    static String header = "Consistency";
    private static boolean cleaned = false;
    static boolean automaticExport = true;
    static boolean imported = false;
    static char[] badChars = new char[]{'\r', '\n'};
    static String debugFolder = "Consistency/";

    Consistency() {
    }

    static FormID getOldForm(String edid) {
        return consistency.getOldForm(edid);
    }

    static boolean requestID(FormID id) {
        return consistency.requestID(id);
    }

    static void cleanConsistency() {
        cleaned = true;
    }

    static boolean isCleaned() {
        return cleaned;
    }

    static void syncIDwithEDID(String edid, MajorRecord m) {
        FormID saved = Consistency.getOldForm(edid);
        if (saved != null) {
            if (SPGlobal.logging()) {
                SPGlobal.logSpecial(LogTypes.CONSISTENCY, header, "Assigning FormID " + saved + " for EDID " + edid);
            }
            m.setForm(saved);
        } else if (m.getForm().isNull()) {
            FormID freshID = Consistency.getNextID(m.srcMod);
            Consistency.insert(edid, freshID);
            m.setForm(freshID);
            if (SPGlobal.logging()) {
                SPGlobal.logSpecial(LogTypes.CONSISTENCY, header, "Assigning FRESH FormID " + freshID + " for EDID " + edid);
            }
        }
    }

    public static FormID getNextID(Mod srcMod) {
        FormID possibleID = srcMod.getNextID();
        while (!Consistency.requestID(possibleID)) {
            if (possibleID.isNull()) {
                if (!cleaned) {
                    srcMod.resetNextIDcounter();
                    Consistency.cleanConsistency();
                    return Consistency.getNextID(srcMod);
                }
                SPGlobal.logError(srcMod.toString(), "Ran out of available formids.");
                JOptionPane.showMessageDialog(null, "<html>The output patch ran out of available FormIDs.<br>Please contact Leviathan1753.</html>");
                return null;
            }
            possibleID = srcMod.getNextID();
        }
        return possibleID;
    }

    public static String edidFilter(String edid) {
        edid = edid.replaceAll(" ", "");
        char[] cArray = badChars;
        int n = badChars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            edid = edid.replaceAll(String.valueOf(c), "");
            ++n2;
        }
        return edid;
    }

    static void getConsistencyFile() throws FileNotFoundException, IOException {
        consistency.getConsistencyFile();
    }

    static void clear() {
        imported = false;
        consistency.clear();
    }

    static void importConsistency(boolean globalOnly) {
        try {
            if (SPGlobal.testing) {
                return;
            }
            consistency.importConsistency(globalOnly);
            imported = true;
        }
        catch (Exception ex) {
            SPGlobal.logException(ex);
            JOptionPane.showMessageDialog(null, "<html>There was an error importing the consistency information.<br><br>This means your savegame has a good chance of having mismatched records.<br><br>It would be greatly appreciated if you sent the failed consistency file located in<br>'My Documents/My Games/Skyrim/Skyproc/' to Leviathan1753 for analysis.<br><br> If this is the first time running the patch, please ignore this message.</html>");
        }
    }

    static boolean insert(String EDID, FormID id) {
        return consistency.insert(EDID, id);
    }

    static void export() throws IOException {
        consistency.export();
    }

    static boolean isImported() {
        return imported;
    }

    static class ConsistencyV2
    extends ConsistencyVersion {
        Map<ModListing, Map<String, FormID>> storage = new HashMap<ModListing, Map<String, FormID>>();

        ConsistencyV2() {
        }

        @Override
        FormID getOldForm(String edid) {
            return this.storage.get(SPGlobal.getGlobalPatch().getInfo()).get(edid);
        }

        @Override
        String getConsistencyFile() throws FileNotFoundException, IOException {
            File myDocs = SPGlobal.getSkyProcDocuments();
            return String.valueOf(myDocs.getPath()) + "\\Consistency";
        }

        @Override
        void clear() {
            super.clear();
            this.storage.clear();
        }

        @Override
        boolean insert(String EDID, FormID id) {
            Map<String, FormID> modEDIDlist = this.storage.get(id.master);
            if (modEDIDlist == null) {
                modEDIDlist = new HashMap<String, FormID>();
                this.storage.put(id.master, modEDIDlist);
            }
            return this.insert(EDID, id, modEDIDlist);
        }

        @Override
        void export() throws IOException {
            if (SPGlobal.logging()) {
                SPGlobal.logMain(header, "Exporting Consistency file.");
            }
            if (SPGlobal.testing) {
                return;
            }
            this.pruneConflicts();
            this.importConsistency(false);
            try {
                this.getConsistencyFile();
                File tmp = new File(String.valueOf(this.getConsistencyFile()) + "Tmp");
                LOutChannel out = new LOutChannel(tmp);
                out.write("SPC2");
                out.markLength(4);
                for (ModListing m : this.storage.keySet()) {
                    out.write(m.print().length(), 2);
                    out.write(m.print());
                    out.setPosMarker(4);
                }
                out.closeLength();
                for (ModListing m : this.storage.keySet()) {
                    out.fillPosMarker();
                    out.markLength(4);
                    Map<String, FormID> map = this.storage.get(m);
                    for (String edid : map.keySet()) {
                        out.write(edid.length(), 2);
                        out.write(edid);
                        out.write(map.get(edid).getFormStr().substring(0, 6));
                    }
                    out.closeLength();
                }
                out.close();
                File f = new File(String.valueOf(this.getConsistencyFile()) + "V2");
                if (f.isFile()) {
                    f.delete();
                }
                tmp.renameTo(f);
                out.close();
            }
            catch (IOException ex) {
                SPGlobal.logException(ex);
                SPGlobal.logSpecial(LogTypes.CONSISTENCY, header, "Error exporting Consistency file.");
                JOptionPane.showMessageDialog(null, "<html>There was an error exporting the consistency information.<br><br>This means your savegame has a good chance of having mismatched records the next<br>time you run the patcher.</html>");
            }
        }

        @Override
        void remove(String edid) {
            this.storage.get(SPGlobal.getGlobalPatch().getInfo()).remove(edid);
        }

        @Override
        boolean importConsistency(boolean globalOnly) throws IOException {
            File f;
            if (!imported) {
                this.storage.put(SPGlobal.getGlobalPatch().getInfo(), new HashMap());
            }
            if (!(f = new File(String.valueOf(this.getConsistencyFile()) + "V2")).isFile()) {
                return false;
            }
            if (SPGlobal.logging()) {
                String name = globalOnly ? String.valueOf(debugFolder) + "Import - V2 - Only Global.txt" : String.valueOf(debugFolder) + "Import - V2 - Remaining.txt";
                SPGlobal.newSpecialLog(LogTypes.CONSISTENCY_IMPORT, name);
                SPGlobal.logSpecial(LogTypes.CONSISTENCY_IMPORT, "v2Import", "Importing v2 consistency file.");
            }
            LInChannel in = new LInChannel(f);
            in.skip(4);
            ModListing globalListing = SPGlobal.getGlobalPatch().getInfo();
            Map<ModListing, Integer> headerMap = this.importHeader(in);
            if (globalOnly) {
                Integer tmp = headerMap.get(globalListing);
                headerMap.clear();
                if (tmp != null) {
                    headerMap.put(globalListing, tmp);
                }
            } else {
                headerMap.remove(globalListing);
            }
            for (ModListing m : headerMap.keySet()) {
                if (SPGlobal.logging()) {
                    SPGlobal.logSpecial(LogTypes.CONSISTENCY_IMPORT, "v2Import", "===========================");
                    SPGlobal.logSpecial(LogTypes.CONSISTENCY_IMPORT, "v2Import", "== Importing " + m);
                    SPGlobal.logSpecial(LogTypes.CONSISTENCY_IMPORT, "v2Import", "===========================");
                }
                in.pos((long)headerMap.get(m).intValue());
                int length = in.extractInt(0, 4);
                LInChannel contentArr = new LInChannel(in, (long)length);
                while (!contentArr.isDone().booleanValue()) {
                    int edidLen = in.extractInt(2);
                    String EDID = in.extractString(edidLen);
                    String FormStr = in.extractString(6);
                    FormID ID = new FormID(FormStr, m);
                    if (SPGlobal.logging()) {
                        SPGlobal.logSpecial(LogTypes.CONSISTENCY_IMPORT, "v2Import", "  | EDID: " + EDID);
                        SPGlobal.logSpecial(LogTypes.CONSISTENCY_IMPORT, "v2Import", "  | Form: " + FormStr);
                        SPGlobal.logSpecial(LogTypes.CONSISTENCY_IMPORT, "v2Import", "  |============================");
                    }
                    this.insert(EDID, ID);
                }
            }
            in.close();
            this.v1import(globalOnly);
            return true;
        }

        boolean v1import(boolean globalOnly) throws IOException {
            File f = new File(this.getConsistencyFile());
            if (!f.isFile()) {
                return false;
            }
            if (SPGlobal.logging()) {
                String name = globalOnly ? String.valueOf(debugFolder) + "Import - V1 - Only Global.txt" : String.valueOf(debugFolder) + "Import - V1 - Remaining.txt";
                SPGlobal.newSpecialLog(LogTypes.CONSISTENCY_IMPORT, name);
                SPGlobal.logSpecial(LogTypes.CONSISTENCY_IMPORT, "v1Import", "Importing v1 consistency file.");
            }
            BufferedReader in = new BufferedReader(new FileReader(f));
            while (in.ready()) {
                String EDID = in.readLine();
                String form = in.readLine();
                boolean fail = false;
                while (in.ready() && !form.toUpperCase().endsWith(".ESP") && !form.toUpperCase().endsWith(".ESM")) {
                    if (SPGlobal.logging()) {
                        SPGlobal.logSpecial(LogTypes.CONSISTENCY_IMPORT, "v1Import", "  Read fail line: " + form);
                    }
                    form = in.readLine();
                    fail = true;
                }
                if (fail) continue;
                FormID ID = new FormID(form);
                boolean isGlobal = ID.getMaster().equals(SPGlobal.getGlobalPatch().getInfo());
                if ((!globalOnly || !isGlobal) && (globalOnly || isGlobal) || !this.insert(EDID, ID) || !SPGlobal.logging()) continue;
                SPGlobal.logSpecial(LogTypes.CONSISTENCY_IMPORT, "Consistency Import", "  Inserting " + form + " with " + EDID);
            }
            in.close();
            return true;
        }

        Map<ModListing, Integer> importHeader(LInChannel in) {
            HashMap<ModListing, Integer> out = new HashMap<ModListing, Integer>();
            int headerLength = in.extractInt(4);
            LShrinkArray headerArr = new LShrinkArray(in.extract(headerLength));
            while (!headerArr.isDone().booleanValue()) {
                int length = headerArr.extractInt(2);
                String name = headerArr.extractString(length);
                ModListing mod = new ModListing(name);
                Integer pos = headerArr.extractInt(0, 4);
                out.put(mod, pos);
            }
            return out;
        }
    }

    static class ConsistencyV3
    extends ConsistencyVersion {
        Map<String, FormID> storage = new TreeMap<String, FormID>();

        ConsistencyV3() {
        }

        @Override
        FormID getOldForm(String edid) {
            return this.storage.get(edid);
        }

        @Override
        String getConsistencyFile() throws IOException {
            File myDocs = SPGlobal.getSkyProcDocuments();
            return String.valueOf(myDocs.getPath()) + "\\ConsistencyV3\\" + SPGlobal.getGlobalPatch().getName() + "_Consistency";
        }

        @Override
        boolean insert(String EDID, FormID id) {
            return this.insert(EDID, id, this.storage);
        }

        @Override
        void export() throws IOException {
            if (SPGlobal.logging()) {
                SPGlobal.logMain(header, "Exporting Consistency file.");
            }
            if (SPGlobal.testing) {
                return;
            }
            this.pruneConflicts();
            try {
                this.getConsistencyFile();
                File tmp = new File(String.valueOf(this.getConsistencyFile()) + "Tmp");
                LOutChannel out = new LOutChannel(tmp);
                out.write("SPC3");
                for (String edid : this.storage.keySet()) {
                    out.write(edid.length(), 2);
                    out.write(edid);
                    out.write(this.storage.get(edid).getInternal(true));
                }
                out.close();
                File f = new File(this.getConsistencyFile());
                if (f.isFile()) {
                    f.delete();
                }
                tmp.renameTo(f);
                out.close();
            }
            catch (IOException ex) {
                SPGlobal.logException(ex);
                SPGlobal.logSpecial(LogTypes.CONSISTENCY, header, "Error exporting Consistency file.");
                JOptionPane.showMessageDialog(null, "<html>There was an error exporting the consistency information.<br><br>This means your savegame has a good chance of having mismatched records the next<br>time you run the patcher.</html>");
            }
        }

        @Override
        void remove(String edid) {
            this.storage.remove(edid);
        }

        @Override
        boolean importConsistency(boolean globalOnly) throws IOException {
            File f = new File(this.getConsistencyFile());
            if (!f.isFile()) {
                this.upgrade();
                return false;
            }
            if (SPGlobal.logging()) {
                String name = String.valueOf(debugFolder) + "Import - V3.txt";
                SPGlobal.newSpecialLog(LogTypes.CONSISTENCY_IMPORT, name);
                SPGlobal.logSpecial(LogTypes.CONSISTENCY_IMPORT, "Import", "Importing v3 consistency file.");
            }
            Mod global = SPGlobal.getGlobalPatch();
            LInChannel in = new LInChannel(f);
            in.skip(4);
            LShrinkArray arr = new LShrinkArray(in.extractAllBytes());
            while (!arr.isDone().booleanValue()) {
                int edidLen = arr.extractInt(2);
                String EDID = arr.extractString(edidLen);
                byte[] bytes = arr.extract(4);
                FormID ID = new FormID();
                ID.setInternal(bytes, global);
                if (SPGlobal.logging()) {
                    SPGlobal.logSpecial(LogTypes.CONSISTENCY_IMPORT, "Import", "  | EDID: " + EDID);
                    SPGlobal.logSpecial(LogTypes.CONSISTENCY_IMPORT, "Import", "  | Form: " + ID);
                    SPGlobal.logSpecial(LogTypes.CONSISTENCY_IMPORT, "Import", "  |============================");
                }
                this.insert(EDID, ID);
            }
            in.close();
            this.upgrade();
            return true;
        }

        void upgrade() throws IOException {
            ConsistencyV2 v2 = new ConsistencyV2();
            v2.importConsistency(true);
            Map<String, FormID> map = v2.storage.get(SPGlobal.getGlobalPatch().getInfo());
            if (SPGlobal.logging()) {
                String name = String.valueOf(debugFolder) + "Import - V3.txt";
                SPGlobal.newSpecialLog(LogTypes.CONSISTENCY_IMPORT, name);
                SPGlobal.logSpecial(LogTypes.CONSISTENCY_IMPORT, "Import", "Upgrading from v2 consistency.");
            }
            for (Map.Entry<String, FormID> entry : map.entrySet()) {
                this.insert(entry.getKey(), entry.getValue());
            }
        }
    }

    static abstract class ConsistencyVersion {
        Set<FormID> set = new HashSet<FormID>();
        LMergeMap<FormID, String> conflicts = new LMergeMap(Boolean.valueOf(false));

        ConsistencyVersion() {
        }

        abstract FormID getOldForm(String var1);

        boolean requestID(FormID id) {
            return !this.set.contains(id);
        }

        abstract String getConsistencyFile() throws IOException;

        void clear() {
            this.set.clear();
        }

        abstract boolean insert(String var1, FormID var2);

        boolean insert(String EDID, FormID id, Map<String, FormID> modEDIDlist) {
            if (!modEDIDlist.containsKey(EDID)) {
                if (this.set.contains(id)) {
                    String offendingEDID = "";
                    for (String item : modEDIDlist.keySet()) {
                        if (!modEDIDlist.get(item).equals(id)) continue;
                        offendingEDID = item;
                        break;
                    }
                    this.conflicts.put((Object)id, (Object)EDID);
                    this.conflicts.put((Object)id, (Object)offendingEDID);
                    if (SPGlobal.logging()) {
                        SPGlobal.logSpecial(LogTypes.CONSISTENCY, header, "!!!>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
                        SPGlobal.logSpecial(LogTypes.CONSISTENCY, header, "!!!>>> Duplicate FormID warning.  ID: " + id + "  EDID: " + EDID + " and EDID2: " + offendingEDID);
                        SPGlobal.logSpecial(LogTypes.CONSISTENCY, header, "!!!>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
                    }
                }
                modEDIDlist.put(EDID, id);
                this.set.add(id);
                return true;
            }
            return false;
        }

        abstract void export() throws IOException;

        abstract void remove(String var1);

        abstract boolean importConsistency(boolean var1) throws IOException;

        void pruneConflicts() {
            if (SPGlobal.logging()) {
                SPGlobal.newLog(String.valueOf(debugFolder) + "Conflict Pruning.txt");
                SPGlobal.log(header, "====================================");
                SPGlobal.log(header, "====== Pruning Conflicts ===========");
                SPGlobal.log(header, "====================================");
            }
            Mod global = SPGlobal.getGlobalPatch();
            for (FormID id : this.conflicts.keySet()) {
                if (SPGlobal.logging()) {
                    SPGlobal.log(header, "------ Addressing " + id);
                }
                ArrayList edidConflicts = this.conflicts.get((Object)id);
                ArrayList<String> found = new ArrayList<String>(2);
                block1: for (String edid : edidConflicts) {
                    if (SPGlobal.logging()) {
                        SPGlobal.log(header, "| For EDID: " + edid);
                    }
                    for (GRUP g : global.GRUPs.values()) {
                        if (!g.contains(edid)) continue;
                        found.add(edid);
                        if (!SPGlobal.logging()) continue block1;
                        SPGlobal.log(header, "|   Found!");
                        continue block1;
                    }
                }
                if (found.size() == 1) {
                    if (SPGlobal.logging()) {
                        SPGlobal.log(header, "| Only one EDID is being used, pruning others.");
                    }
                    edidConflicts.remove(found.get(0));
                    for (String unusedEDID : edidConflicts) {
                        consistency.remove(unusedEDID);
                    }
                }
                if (!SPGlobal.logging()) continue;
                SPGlobal.log(header, "-----------------------");
            }
        }
    }

    static enum LogTypes {
        CONSISTENCY,
        CONSISTENCY_IMPORT;

    }
}

