/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.IOException;
import java.util.zip.DataFormatException;
import lev.LFlags;
import lev.LImport;
import skyproc.MajorRecord;
import skyproc.Mod;
import skyproc.ModExporter;
import skyproc.SubPrototype;
import skyproc.SubRecord;
import skyproc.SubRecordTyped;
import skyproc.SubShell;
import skyproc.exceptions.BadParameter;
import skyproc.exceptions.BadRecord;
import skyproc.genenums.ArmorType;
import skyproc.genenums.FirstPersonFlags;

public class BodyTemplate
extends SubShell {
    static SubPrototype BODTproto = new SubPrototype(){

        @Override
        protected void addRecords() {
            this.add(new BodyTemplateMain("BODT"));
            this.add(new BodyTemplateMain("BOD2"));
        }
    };

    BodyTemplate() {
        super(BODTproto);
    }

    BodyTemplateMain getMain() {
        BodyTemplateMain b = (BodyTemplateMain)this.subRecords.get("BODT");
        if (!b.isValid()) {
            b = (BodyTemplateMain)this.subRecords.get("BOD2");
        }
        return b;
    }

    @Override
    SubRecord getNew(String type) {
        return new BodyTemplate();
    }

    public void set(BodyTemplateType type, FirstPersonFlags flag, boolean on) {
        BodyTemplateMain main = this.getMain();
        if (flag == FirstPersonFlags.NONE) {
            main.bodyParts.clear();
        } else {
            main.bodyParts.set(flag.ordinal(), on);
        }
        main.valid = true;
    }

    public boolean get(BodyTemplateType type, FirstPersonFlags part) {
        BodyTemplateMain main = this.getMain();
        main.valid = true;
        if (part == FirstPersonFlags.NONE) {
            return main.bodyParts.isZeros();
        }
        return main.bodyParts.get(part.ordinal());
    }

    public void set(GeneralFlags flag, boolean on) {
        BodyTemplateMain main = this.getMain();
        main.valid = true;
        main.flags.set(flag.value, on);
    }

    public boolean get(GeneralFlags flag) {
        BodyTemplateMain main = this.getMain();
        main.valid = true;
        return main.flags.get(flag.value);
    }

    public void setArmorType(BodyTemplateType type, ArmorType armorType) {
        BodyTemplateMain main = this.getMain();
        main.valid = true;
        main.armorType = armorType;
    }

    public ArmorType getArmorType(BodyTemplateType type) {
        BodyTemplateMain main = this.getMain();
        main.valid = true;
        return main.armorType;
    }

    void makeBod2(MajorRecord owner) {
        BodyTemplateMain main = this.getMain();
        if (main.isBODT()) {
            if (main.flags.get(GeneralFlags.NonPlayable.value)) {
                owner.set(MajorRecord.MajorFlags.NonPlayable, true);
            }
            BodyTemplateMain bod2 = (BodyTemplateMain)this.subRecords.get("BOD2");
            bod2.bodyParts = main.bodyParts;
            bod2.armorType = main.armorType;
            if (bod2.armorType == null) {
                bod2.armorType = ArmorType.CLOTHING;
            }
            bod2.valid = main.valid;
            this.subRecords.remove("BODT");
            this.subRecords.add(new BodyTemplateMain("BODT"));
        }
    }

    static class BodyTemplateMain
    extends SubRecordTyped {
        LFlags bodyParts = new LFlags(4);
        LFlags flags = new LFlags(4);
        ArmorType armorType = null;
        boolean valid = false;

        BodyTemplateMain(String type) {
            super(type);
        }

        @Override
        void export(ModExporter out) throws IOException {
            super.export(out);
            out.write(this.bodyParts.export(), 4);
            if (this.isBODT()) {
                out.write(this.flags.export(), 4);
            }
            if (this.armorType != null) {
                out.write(this.armorType.ordinal());
            }
        }

        @Override
        void parseData(LImport in, Mod srcMod) throws BadRecord, DataFormatException, BadParameter {
            super.parseData(in, srcMod);
            this.bodyParts = new LFlags(in.extract(4));
            if (this.isBODT()) {
                this.flags = new LFlags(in.extract(4));
            }
            if (!in.isDone().booleanValue()) {
                this.armorType = ArmorType.values()[in.extractInt(4)];
            }
            this.valid = true;
        }

        @Override
        SubRecord getNew(String type) {
            return new BodyTemplateMain(type);
        }

        boolean isBODT() {
            return "BODT".equals(this.getType());
        }

        @Override
        boolean isValid() {
            return this.valid;
        }

        @Override
        int getContentLength(ModExporter out) {
            int len = 4;
            if (this.isBODT()) {
                len += 4;
            }
            if (this.armorType != null) {
                len += 4;
            }
            return len;
        }
    }

    public static enum BodyTemplateType {
        Normal("BODT"),
        Biped("BOD2");

        String type;

        private BodyTemplateType(String in) {
            this.type = in;
        }
    }

    public static enum GeneralFlags {
        ModulatesVoice(0),
        NonPlayable(4);

        int value;

        private GeneralFlags(int val) {
            this.value = val;
        }
    }
}

