/*
 * Decompiled with CFR 0.152.
 */
package skyproc;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.zip.DataFormatException;
import lev.LFlags;
import lev.LInChannel;
import lev.LShrinkArray;
import lev.Ln;
import skyproc.Mod;
import skyproc.ModListing;
import skyproc.SPGlobal;
import skyproc.SPImporter;
import skyproc.exceptions.BadParameter;

public class BSA {
    static ArrayList<BSA> resourceLoadOrder;
    static Map<ModListing, BSA> pluginLoadOrder;
    static boolean pluginsLoaded;
    static boolean overlapDeleted;
    static String header;
    String filePath;
    int offset;
    LFlags archiveFlags;
    int folderCount;
    int fileCount;
    int folderNameLength;
    int fileNameLength;
    LFlags fileFlags;
    boolean loaded = false;
    boolean bad = false;
    Map<String, BSAFolder> folders;
    LInChannel in = new LInChannel();

    static {
        pluginLoadOrder = new TreeMap<ModListing, BSA>();
        pluginsLoaded = false;
        overlapDeleted = false;
        header = "BSA";
    }

    BSA(File file, boolean load) throws FileNotFoundException, IOException, BadParameter {
        this(file.getPath(), load);
    }

    BSA(String filePath, boolean load) throws FileNotFoundException, IOException, BadParameter {
        this.filePath = filePath;
        this.in.openFile(filePath);
        if (!this.in.extractString(0, 3).equals("BSA") || this.in.extractInt(1, 4) != 104) {
            throw new BadParameter("Was not a BSA file of version 104: " + filePath);
        }
        this.offset = this.in.extractInt(0, 4);
        this.archiveFlags = new LFlags(this.in.extract(0, 4));
        this.folderCount = this.in.extractInt(0, 4);
        this.folders = new HashMap<String, BSAFolder>(this.folderCount);
        this.fileCount = this.in.extractInt(0, 4);
        this.folderNameLength = this.in.extractInt(0, 4);
        this.fileNameLength = this.in.extractInt(0, 4);
        this.fileFlags = new LFlags(this.in.extract(0, 4));
        if (SPGlobal.debugBSAimport && SPGlobal.logging()) {
            SPGlobal.logSpecial(LogTypes.BSA, header, "|==================>");
            SPGlobal.logSpecial(LogTypes.BSA, header, "| Imported " + filePath);
            SPGlobal.logSpecial(LogTypes.BSA, header, "| Offset " + this.offset + ", archiveFlags: " + this.archiveFlags);
            SPGlobal.logSpecial(LogTypes.BSA, header, "| hasDirectoryNames: " + this.archiveFlags.get(0) + ", hasFileNames: " + this.archiveFlags.get(1) + ", compressed: " + this.archiveFlags.get(2));
            SPGlobal.logSpecial(LogTypes.BSA, header, "| FolderCount: " + Ln.prettyPrintHex((int)this.folderCount) + ", FileCount: " + Ln.prettyPrintHex((int)this.fileCount));
            SPGlobal.logSpecial(LogTypes.BSA, header, "| totalFolderNameLength: " + Ln.prettyPrintHex((int)this.folderNameLength) + ", totalFileNameLength: " + Ln.prettyPrintHex((int)this.fileNameLength));
            SPGlobal.logSpecial(LogTypes.BSA, header, "| fileFlags: " + this.fileFlags.toString());
            SPGlobal.logSpecial(LogTypes.BSA, header, "|==================>");
        }
        if (load) {
            this.loadFolders();
        }
    }

    public BSA(String filePath) throws FileNotFoundException, IOException, BadParameter {
        this(filePath, true);
    }

    final void loadFolders() {
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        if (SPGlobal.logging()) {
            SPGlobal.logSpecial(LogTypes.BSA, header, "|============================================");
            SPGlobal.logSpecial(LogTypes.BSA, header, "|============  Loading " + this + " ============");
            SPGlobal.logSpecial(LogTypes.BSA, header, "|============================================");
        }
        try {
            int fileCounter = 0;
            this.in.pos((long)this.offset);
            LShrinkArray folderData = new LShrinkArray(this.in.extract(0, this.folderCount * 16));
            this.posAtFilenames();
            LShrinkArray fileNames = new LShrinkArray(this.in.extract(0, this.fileNameLength));
            int i = 0;
            while (i < this.folderCount) {
                BSAFolder folder = new BSAFolder();
                folderData.skip(8);
                folder.setFileCount(folderData.extractInt(4));
                folder.dataPos = folderData.extractInt(4);
                this.posAtFolder(folder);
                folder.name = String.valueOf(this.in.extractString(0, this.in.read() - 1)) + "\\";
                folder.name = folder.name.toUpperCase();
                this.in.skip(1);
                this.folders.put(folder.name, folder);
                if (SPGlobal.debugBSAimport && SPGlobal.logging()) {
                    SPGlobal.logSpecial(LogTypes.BSA, header, "Loaded folder: " + folder.name);
                }
                int j = 0;
                while (j < folder.fileCount) {
                    BSAFileRef f = new BSAFileRef();
                    f.size = this.in.extractInt(8, 3);
                    LFlags sizeFlag = new LFlags(this.in.extract(1));
                    f.flippedCompression = sizeFlag.get(6);
                    f.dataOffset = this.in.extractLong(0, 4);
                    String fileName = fileNames.extractString();
                    folder.files.put(fileName.toUpperCase(), f);
                    if (SPGlobal.logging()) {
                        SPGlobal.logSpecial(LogTypes.BSA, header, "  " + fileName + ", size: " + Ln.prettyPrintHex((int)f.size) + ", offset: " + Ln.prettyPrintHex((long)f.dataOffset));
                        ++fileCounter;
                    }
                    ++j;
                }
                ++i;
            }
            if (SPGlobal.logging()) {
                if (SPGlobal.debugBSAimport) {
                    SPGlobal.logSpecial(LogTypes.BSA, header, "Loaded " + fileCounter + " files.");
                }
                SPGlobal.logSpecial(LogTypes.BSA, header, "Loaded BSA: " + this.getFilePath());
            }
        }
        catch (Exception e) {
            SPGlobal.logException(e);
            SPGlobal.logError("BSA", "Skipped BSA " + this);
            this.bad = true;
        }
    }

    void posAtFilenames() {
        this.in.pos((long)(this.folderNameLength + this.fileCount * 16 + this.folderCount * 17 + this.offset));
    }

    void posAtFolder(BSAFolder folder) {
        this.in.pos(folder.dataPos - (long)this.fileNameLength);
    }

    public boolean loaded() {
        return this.loaded;
    }

    public LShrinkArray getFile(String filePath) throws IOException, DataFormatException {
        BSAFileRef ref = this.getFileRef(filePath);
        if (ref != null) {
            this.in.pos(this.getFileLocation(ref));
            LShrinkArray out = new LShrinkArray(this.in.extract(0, ref.size));
            this.trimName(out);
            if (this.isCompressed(ref)) {
                out = out.correctForCompression();
            }
            return out;
        }
        return new LShrinkArray(new byte[0]);
    }

    void trimName(LShrinkArray out) {
        if (this.is(BSAFlag.NamesInFileData)) {
            out.skip(out.extractInt(1));
        }
    }

    long getFileLocation(BSAFileRef ref) {
        return ref.dataOffset;
    }

    long getFileLocation(String filePath) {
        BSAFileRef ref = this.getFileRef(filePath);
        if (ref != null) {
            return this.getFileLocation(ref);
        }
        return -1L;
    }

    long getFileLocation(File f) {
        return this.getFileLocation(f.getPath());
    }

    public LShrinkArray getFile(File f) throws IOException, DataFormatException {
        return this.getFile(f.getPath());
    }

    String getFilename(String filePath) throws IOException {
        BSAFileRef ref = this.getFileRef(filePath);
        if (ref != null) {
            this.in.pos(ref.nameOffset);
            return this.in.extractString();
        }
        return "";
    }

    static String getUsedFilename(String filePath) throws IOException {
        String out = "";
        File file = new File(filePath);
        if (!(file = Ln.getFilepathCaseInsensitive((File)file)).getPath().equals("")) {
            return file.getName();
        }
        Iterator<BSA> bsas = BSA.iterator();
        while (bsas.hasNext()) {
            String tmp = bsas.next().getFilename(filePath);
            if (tmp.equals("")) continue;
            out = tmp;
        }
        return out;
    }

    public static LShrinkArray getUsedFile(String filePath) throws IOException, DataFormatException {
        File outsideBSA = new File(String.valueOf(SPGlobal.pathToData) + filePath);
        if (outsideBSA.isFile()) {
            SPGlobal.logSpecial(LogTypes.BSA, header, "Loaded from loose files: " + outsideBSA.getPath());
            return new LShrinkArray(outsideBSA);
        }
        Iterator<BSA> bsas = BSA.iterator();
        BSA bsa = null;
        while (bsas.hasNext()) {
            BSA tmp = bsas.next();
            if (!tmp.hasFile(filePath)) continue;
            bsa = tmp;
        }
        if (bsa != null) {
            if (SPGlobal.logging()) {
                SPGlobal.logSpecial(LogTypes.BSA, header, "Loaded from BSA " + bsa.getFilePath() + ": " + filePath);
            }
            return bsa.getFile(filePath);
        }
        return null;
    }

    static void loadPluginLoadOrder() {
        if (pluginsLoaded) {
            return;
        }
        if (SPGlobal.logging()) {
            SPGlobal.logSpecial(LogTypes.BSA, header, "Loading in active plugin BSA headers.");
        }
        try {
            ArrayList<ModListing> activeMods = SPImporter.getActiveModList();
            for (ModListing m : activeMods) {
                BSA bsa;
                if (pluginLoadOrder.containsKey(m) || (bsa = BSA.getBSA(m)) == null) continue;
                pluginLoadOrder.put(m, bsa);
            }
        }
        catch (IOException ex) {
            SPGlobal.logException(ex);
        }
        pluginsLoaded = true;
    }

    static void loadResourceLoadOrder() {
        if (resourceLoadOrder != null) {
            return;
        }
        try {
            ArrayList<String> resources = new ArrayList<String>();
            boolean line1 = false;
            boolean line2 = false;
            try {
                File ini = SPGlobal.getSkyrimINI();
                if (SPGlobal.logging()) {
                    SPGlobal.logSpecial(LogTypes.BSA, header, "Loading in BSA list from Skyrim.ini: " + ini);
                }
                LInChannel input = new LInChannel(ini);
                String line = "";
                while (input.available() > 0 && !line.toUpperCase().contains("SRESOURCEARCHIVELIST")) {
                    line = input.extractLine();
                }
                if (line.toUpperCase().contains("SRESOURCEARCHIVELIST2")) {
                    line2 = true;
                    resources.addAll(BSA.processINIline(line));
                } else {
                    line1 = true;
                    resources.addAll(0, BSA.processINIline(line));
                }
                line = "";
                while (input.available() > 0 && !line.toUpperCase().contains("SRESOURCEARCHIVELIST")) {
                    line = Ln.cleanLine((String)input.extractLine(), (String)"#");
                }
                if (line.toUpperCase().contains("SRESOURCEARCHIVELIST2")) {
                    line2 = true;
                    resources.addAll(BSA.processINIline(line));
                } else {
                    line1 = true;
                    resources.addAll(0, BSA.processINIline(line));
                }
            }
            catch (IOException e) {
                SPGlobal.logException(e);
            }
            if (!line1 || !line2) {
                if (!resources.contains("Skyrim - Misc.bsa")) {
                    resources.add("Skyrim - Misc.bsa");
                }
                if (!resources.contains("Skyrim - Shaders.bsa")) {
                    resources.add("Skyrim - Shaders.bsa");
                }
                if (!resources.contains("Skyrim - Textures.bsa")) {
                    resources.add("Skyrim - Textures.bsa");
                }
                if (!resources.contains("Skyrim - Interface.bsa")) {
                    resources.add("Skyrim - Interface.bsa");
                }
                if (!resources.contains("Skyrim - Animations.bsa")) {
                    resources.add("Skyrim - Animations.bsa");
                }
                if (!resources.contains("Skyrim - Meshes.bsa")) {
                    resources.add("Skyrim - Meshes.bsa");
                }
                if (!resources.contains("Skyrim - Sounds.bsa")) {
                    resources.add("Skyrim - Sounds.bsa");
                }
                if (!resources.contains("Skyrim - Sounds.bsa")) {
                    resources.add("Skyrim - Voices.bsa");
                }
                if (!resources.contains("Skyrim - Sounds.bsa")) {
                    resources.add("Skyrim - VoicesExtra.bsa");
                }
            }
            if (SPGlobal.logging()) {
                SPGlobal.logSpecial(LogTypes.BSA, header, "BSA resource load order: ");
                for (String s : resources) {
                    SPGlobal.logSpecial(LogTypes.BSA, header, "  " + s);
                }
                SPGlobal.logSpecial(LogTypes.BSA, header, "Loading in their headers.");
            }
            ArrayList<ModListing> activeMods = SPImporter.getActiveModList();
            for (ModListing m : activeMods) {
                File pluginIni = new File(String.valueOf(SPGlobal.pathToData) + Ln.changeFileTypeTo((String)m.print(), (String)"ini"));
                if (!pluginIni.exists()) continue;
                LInChannel input = new LInChannel(pluginIni);
                String line = "";
                while (input.available() > 0 && !line.toUpperCase().contains("SRESOURCEARCHIVELIST")) {
                    line = input.extractLine();
                }
                if (line.toUpperCase().contains("SRESOURCEARCHIVELIST2")) {
                    resources.addAll(BSA.processINIline(line));
                } else {
                    resources.addAll(0, BSA.processINIline(line));
                }
                line = "";
                while (input.available() > 0 && !line.toUpperCase().contains("SRESOURCEARCHIVELIST")) {
                    line = Ln.cleanLine((String)input.extractLine(), (String)"#");
                }
                if (line.toUpperCase().contains("SRESOURCEARCHIVELIST2")) {
                    resources.addAll(BSA.processINIline(line));
                    continue;
                }
                resources.addAll(0, BSA.processINIline(line));
            }
            resourceLoadOrder = new ArrayList(resources.size());
            for (String s : resources) {
                File bsaPath = new File(String.valueOf(SPGlobal.pathToData) + s);
                if (bsaPath.exists()) {
                    try {
                        if (SPGlobal.logging()) {
                            SPGlobal.logSpecial(LogTypes.BSA, header, "Loading: " + bsaPath);
                        }
                        BSA bsa = new BSA(bsaPath, false);
                        resourceLoadOrder.add(bsa);
                    }
                    catch (FileNotFoundException | BadParameter ex) {
                        BSA.logBSAError(s, ex);
                    }
                    continue;
                }
                if (!SPGlobal.logging()) continue;
                SPGlobal.logSpecial(LogTypes.BSA, header, "  BSA skipped because it didn't exist: " + bsaPath);
            }
        }
        catch (IOException ex) {
            SPGlobal.logException(ex);
        }
    }

    static ArrayList<String> processINIline(String in) {
        if (SPGlobal.logging()) {
            SPGlobal.logSpecial(LogTypes.BSA, header, "Processing line: " + in);
        }
        ArrayList<String> out = new ArrayList<String>();
        int index = in.indexOf("=");
        if (index != -1) {
            String[] split;
            in = in.substring(index + 1);
            String[] stringArray = split = in.split(",");
            int n = split.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (!(s = s.trim()).isEmpty()) {
                    out.add(s);
                }
                ++n2;
            }
        }
        return out;
    }

    BSAFileRef getFileRef(String filePath) {
        String file;
        BSAFileRef ref;
        int index;
        String folderPath = (filePath = filePath.toUpperCase()).substring(0, (index = filePath.lastIndexOf(92)) + 1);
        BSAFolder folder = this.folders.get(folderPath);
        if (folder != null && (ref = folder.files.get(file = filePath.substring(index + 1))) != null) {
            return ref;
        }
        return null;
    }

    public boolean hasFile(String filePath) {
        return this.getFileRef(filePath) != null;
    }

    public boolean hasFile(File f) {
        return this.hasFile(f.getPath());
    }

    public String getFilePath() {
        return this.filePath.substring(0, this.filePath.length());
    }

    public boolean hasFolder(String folderPath) {
        this.filePath = this.filePath.toUpperCase();
        return this.folders.containsKey(folderPath);
    }

    public Set<String> getFolders() {
        return this.folders.keySet();
    }

    public Map<String, ArrayList<String>> getFiles() {
        HashMap<String, ArrayList<String>> out = new HashMap<String, ArrayList<String>>(this.folders.size());
        for (BSAFolder folder : this.folders.values()) {
            ArrayList<String> list = new ArrayList<String>(folder.files.values().size());
            out.put(folder.name, list);
            list.addAll(folder.files.keySet());
        }
        return out;
    }

    public int numFolders() {
        return this.folders.size();
    }

    public int numFiles() {
        int out = 0;
        for (BSAFolder folder : this.folders.values()) {
            out += folder.fileCount;
        }
        return out;
    }

    public boolean contains(FileType fileType) {
        if (!this.fileFlags.isZeros()) {
            return this.fileFlags.get(fileType.ordinal());
        }
        return this.manualContains(fileType);
    }

    boolean manualContains(FileType fileType) {
        FileType[] types = new FileType[]{fileType};
        return this.manualContains(types);
    }

    boolean manualContains(FileType[] fileTypes) {
        this.loadFolders();
        for (BSAFolder folder : this.folders.values()) {
            for (String file : folder.files.keySet()) {
                FileType[] fileTypeArray = fileTypes;
                int n = fileTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    FileType type = fileTypeArray[n2];
                    if (file.endsWith(type.toString())) {
                        return true;
                    }
                    ++n2;
                }
            }
        }
        return false;
    }

    public boolean containsAny(FileType[] fileTypes) {
        if (!this.fileFlags.isZeros()) {
            FileType[] fileTypeArray = fileTypes;
            int n = fileTypes.length;
            int n2 = 0;
            while (n2 < n) {
                FileType f = fileTypeArray[n2];
                if (this.contains(f)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        return this.manualContains(fileTypes);
    }

    public static ArrayList<BSA> loadInBSAs(FileType ... types) {
        ArrayList<BSA> out = new ArrayList<BSA>();
        Iterator<BSA> bsas = BSA.iterator();
        while (bsas.hasNext()) {
            BSA tmp = bsas.next();
            try {
                if (tmp.bad || !tmp.containsAny(types)) continue;
                tmp.loadFolders();
                out.add(tmp);
            }
            catch (Exception e) {
                SPGlobal.logException(e);
                SPGlobal.logError("BSA", "Skipped BSA " + tmp);
            }
        }
        return out;
    }

    static void deleteOverlap() {
        if (!overlapDeleted) {
            return;
        }
        for (BSA b : pluginLoadOrder.values()) {
            resourceLoadOrder.remove(b);
        }
        overlapDeleted = true;
    }

    static Iterator<BSA> iterator() {
        return BSA.getBSAs().iterator();
    }

    static ArrayList<BSA> getBSAs() {
        BSA.loadResourceLoadOrder();
        BSA.loadPluginLoadOrder();
        BSA.deleteOverlap();
        ArrayList<BSA> order = new ArrayList<BSA>(resourceLoadOrder.size() + pluginLoadOrder.size());
        order.addAll(resourceLoadOrder);
        order.addAll(pluginLoadOrder.values());
        return order;
    }

    static ArrayList<BSA> getResourceBSAa() {
        BSA.loadResourceLoadOrder();
        ArrayList<BSA> resources = new ArrayList<BSA>(resourceLoadOrder.size());
        resources.addAll(resourceLoadOrder);
        return resources;
    }

    static ArrayList<BSA> getPluginBSAs() {
        BSA.loadPluginLoadOrder();
        ArrayList<BSA> resources = new ArrayList<BSA>(pluginLoadOrder.size());
        resources.addAll(pluginLoadOrder.values());
        return resources;
    }

    public static BSA getBSA(ModListing m) {
        if (pluginLoadOrder.containsKey(m)) {
            return pluginLoadOrder.get(m);
        }
        File bsaPath = new File(String.valueOf(SPGlobal.pathToData) + Ln.changeFileTypeTo((String)m.print(), (String)"bsa"));
        if (bsaPath.exists()) {
            try {
                BSA bsa = new BSA(bsaPath, false);
                pluginLoadOrder.put(m, bsa);
                return bsa;
            }
            catch (IOException | BadParameter ex) {
                BSA.logBSAError(String.valueOf(m.printNoSuffix()) + ".bsa", ex);
                return null;
            }
        }
        if (SPGlobal.logging()) {
            SPGlobal.logSpecial(LogTypes.BSA, header, "  BSA skipped because it didn't exist: " + bsaPath);
        }
        return null;
    }

    public static BSA getBSA(Mod m) {
        return BSA.getBSA(m.getInfo());
    }

    public static boolean hasBSA(ModListing m) {
        File bsaPath = new File(String.valueOf(SPGlobal.pathToData) + Ln.changeFileTypeTo((String)m.print(), (String)"bsa"));
        return bsaPath.exists();
    }

    public static boolean hasBSA(Mod m) {
        return BSA.hasBSA(m.getInfo());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BSA other = (BSA)obj;
        return Objects.equals(this.filePath, other.filePath);
    }

    public int hashCode() {
        int hash = 7;
        hash = 19 * hash + Objects.hashCode(this.filePath);
        return hash;
    }

    public String toString() {
        return this.filePath;
    }

    static void logBSAError(String source, Exception ex) {
        String error = "Could not get " + source + ". Strings files or ini changes in it will not be availible.";
        SPGlobal.logError(header, error);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        ex.printStackTrace(pw);
        pw.flush();
        sw.flush();
        SPGlobal.log(sw.toString(), new String[0]);
    }

    public boolean is(BSAFlag flag) {
        return this.archiveFlags.get(flag.value);
    }

    boolean isCompressed(BSAFileRef ref) {
        boolean compressed = this.is(BSAFlag.Compressed);
        if (ref.flippedCompression) {
            compressed = !compressed;
        }
        return compressed;
    }

    static class BSAFileRef {
        int size;
        long nameOffset;
        boolean flippedCompression;
        long dataOffset;

        BSAFileRef() {
        }
    }

    public static enum BSAFlag {
        DirectoriesHaveNames(0),
        FilesHaveNames(1),
        Compressed(2),
        NamesInFileData(8);

        int value;

        private BSAFlag(int val) {
            this.value = val;
        }
    }

    static class BSAFolder {
        String name;
        long dataPos;
        private int fileCount;
        Map<String, BSAFileRef> files = new HashMap<String, BSAFileRef>();

        BSAFolder() {
        }

        void setFileCount(int fileCount) {
            this.fileCount = fileCount;
            this.files = new HashMap<String, BSAFileRef>(fileCount);
        }
    }

    public static enum FileType {
        NIF,
        DDS,
        XML,
        WAV,
        MP3,
        TXT_HTML_BAT_SCC,
        SPT,
        TEX_FNT,
        CTL;

    }

    public static enum LogTypes {
        BSA;

    }
}

